/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.Proxy;
import com.bmc.arsys.api.ProxyManager;
import com.bmc.arsys.api.ProxyPool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PoolingProxyManager
extends ProxyManager
implements Serializable {
    private static final long serialVersionUID = -8656598772149963739L;
    private int maxProxiesPerServer;
    private Hashtable<String, ProxyPool> serverProxyPools = new Hashtable();

    PoolingProxyManager(int n2) {
        this.maxProxiesPerServer = n2;
    }

    public Proxy getProxy(ARServerUser aRServerUser) throws ARException {
        Proxy proxy;
        if (aRServerUser.isProxyInContext()) {
            proxy = aRServerUser.getProxy();
        } else {
            ProxyPool proxyPool = this.a(aRServerUser);
            proxy = proxyPool.get(aRServerUser);
        }
        proxy.setProxyProperties(aRServerUser);
        return proxy;
    }

    private synchronized ProxyPool a(ARServerUser aRServerUser) throws ARException {
        if (aRServerUser.getServer() == null || aRServerUser.getServer().length() == 0) {
            throw new ARException(2, 150);
        }
        String string = this.do(aRServerUser);
        ProxyPool proxyPool = this.serverProxyPools.get(string);
        if (proxyPool == null) {
            proxyPool = new ProxyPool(this.maxProxiesPerServer);
            this.serverProxyPools.put(string, proxyPool);
            string = this.if(aRServerUser);
            this.serverProxyPools.put(string, proxyPool);
        }
        return proxyPool;
    }

    public void releaseProxy(Proxy proxy, ARServerUser aRServerUser) {
        if (proxy == null) {
            return;
        }
        if (!aRServerUser.isProxyInContext()) {
            try {
                ProxyPool proxyPool = this.a(aRServerUser);
                proxyPool.put(proxy);
            }
            catch (ARException aRException) {
                return;
            }
        }
    }

    synchronized void clear() {
        Enumeration<String> enumeration = this.serverProxyPools.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            ProxyPool proxyPool = this.serverProxyPools.get(string);
            proxyPool.clear();
        }
        this.serverProxyPools.clear();
    }

    synchronized ProxyManager.PoolInfo[] getInfo() {
        ArrayList<ProxyManager.PoolInfo> arrayList = new ArrayList<ProxyManager.PoolInfo>();
        Enumeration<String> enumeration = this.serverProxyPools.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            ProxyPool proxyPool = this.serverProxyPools.get(string);
            if (proxyPool == null) continue;
            ProxyManager.PoolInfo poolInfo = proxyPool.getInfo(string);
            arrayList.add(poolInfo);
        }
        return arrayList.toArray(new ProxyManager.PoolInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.clear();
        }
        finally {
            super.finalize();
        }
    }

    private String do(ARServerUser aRServerUser) {
        String string = aRServerUser.getServer();
        int n2 = aRServerUser.getPort();
        if (n2 != 0) {
            string = string + ":" + n2;
        }
        return string;
    }

    private String if(ARServerUser aRServerUser) {
        return aRServerUser.getServer();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Max Proxies Per Server", this.maxProxiesPerServer).append("Server Proxy Pools", this.serverProxyPools).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.maxProxiesPerServer).append(this.serverProxyPools).toHashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PoolingProxyManager)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        PoolingProxyManager poolingProxyManager = (PoolingProxyManager)object;
        return new EqualsBuilder().appendSuper(super.equals(object)).append(this.maxProxiesPerServer, poolingProxyManager.maxProxiesPerServer).append(this.serverProxyPools, poolingProxyManager.serverProxyPools).isEquals();
    }
}

