/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.mapping;

import com.bmc.arsys.ws.util.ARWSException;
import com.bmc.arsys.ws.wsdl.XMLSchemaParser;
import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class ARSMapping {
    public XMLSchemaParser schemaParser = null;
    public static final int MAPPING_INTERNAL = 1;
    public static final int MAPPING_EXTERNAL_ELEMENT = 2;
    public static final int MAPPING_EXTERNAL_COMPLEXTYPE = 3;
    protected int mappingMode = 1;
    protected Element mappingElement = null;
    protected Element rootElement = null;
    protected String name;
    protected String targetNamespace;
    protected boolean generateXsiType = false;
    protected String externalSchema = null;
    protected boolean xmlSchemaLinked = false;
    protected String externalGlobalName;
    protected String externalNamespace;

    public int getMappingMode() {
        return this.mappingMode;
    }

    public String getName() {
        return this.name;
    }

    public Element getMappingElement() {
        return this.mappingElement;
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public boolean getGenerateXsiType() {
        return this.generateXsiType;
    }

    public boolean isXmlSchemaLinked() {
        return this.xmlSchemaLinked;
    }

    public String getExternalSchema() {
        return this.externalSchema;
    }

    public String getExternalGlobalName() {
        return this.externalGlobalName;
    }

    public String getExternalNamespace() {
        return this.externalNamespace;
    }

    public ARSMapping(Element element) {
        String string;
        this.mappingElement = element;
        this.name = element.getAttribute("name");
        this.externalSchema = element.getAttribute("externalSchema");
        if (this.externalSchema != null && this.externalSchema.equals("")) {
            this.externalSchema = null;
        }
        if ((string = element.getAttribute("xmlSchemaSource")) != null && string.equals("linked")) {
            this.xmlSchemaLinked = true;
        }
        if ((string = element.getAttribute("generateXsiType")) != null && string.equals("true")) {
            this.generateXsiType = true;
        }
        this.rootElement = ARSMapping.skipToFirstMappingElement(element, false);
        if (this.rootElement == null) {
            return;
        }
        this.targetNamespace = this.rootElement.getAttribute("targetNamespace");
        String string2 = this.rootElement.getAttribute("complexType");
        if (string2 != null && !string2.equals("")) {
            this.mappingMode = 3;
            int n = string2.lastIndexOf(58);
            if (n > -1) {
                this.externalNamespace = string2.substring(0, n);
                this.externalGlobalName = string2.substring(n + 1, string2.length());
            } else {
                Element element2 = ARSMapping.skipToFirstMappingElement(this.rootElement, true);
                this.externalNamespace = element2 != null ? element2.getAttribute("targetNamespace") : "";
                this.externalGlobalName = string2;
            }
        } else {
            Element element3 = ARSMapping.skipToFirstMappingElement(this.rootElement, true);
            if (element3 != null && !element3.getAttribute("targetNamespace").equals("") && !this.targetNamespace.equals(element3.getAttribute("targetNamespace"))) {
                this.mappingMode = 2;
                this.externalNamespace = element3.getAttribute("targetNamespace");
                this.externalGlobalName = element3.getAttribute("name");
            }
        }
    }

    public static Element getFirstChildElement(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element skipToFirstMappingElement(Element element, boolean bl) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            if (element2.getLocalName().equals("formMapping")) {
                return ARSMapping.skipToFirstMappingElement(element2, bl);
            }
            if (!element2.getLocalName().equals("element")) continue;
            if (bl && element2.getAttribute("name").equals("ROOT")) {
                return ARSMapping.skipToFirstMappingElement(element2, false);
            }
            return element2;
        }
        return null;
    }

    public ARSMapping(XMLSchemaParser xMLSchemaParser, Message message, String string, Document document, String string2) {
        this.schemaParser = xMLSchemaParser;
        this.name = message.getQName().getLocalPart();
        this.targetNamespace = string;
        if (string2.equals("encoded")) {
            this.generateXsiType = true;
        }
        this.mappingMode = 2;
        this.createMappingRootElement(document);
        for (Part part : message.getOrderedParts(null)) {
            Element element = null;
            if (part.getElementName() != null) {
                if (xMLSchemaParser == null) {
                    throw new ARWSException("INVALID_WSDL", "part has an element name, but there is no <types> section in WSDL");
                }
                element = xMLSchemaParser.parseSchemaForElement(document, part.getElementName());
            } else if (part.getTypeName() != null) {
                element = document.createElementNS(null, "element");
                element.setAttributeNS(null, "name", part.getName());
                if (xMLSchemaParser != null) {
                    element.setAttributeNS(null, "targetNamespace", string);
                    element.setAttributeNS(null, "form", xMLSchemaParser.getElementFormDefault(string));
                } else {
                    element.setAttributeNS(null, "form", "unqualified");
                }
                if (string2.equals("literal")) {
                    if (xMLSchemaParser == null) {
                        throw new ARWSException("INVALID_WSDL", "part is literal, has a type name, but there is no <types> section in WSDL");
                    }
                    xMLSchemaParser.parseSchemaForType(element, part.getTypeName());
                } else if (string2.equals("encoded")) {
                    if (part.getTypeName().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                        element.setAttributeNS(null, "dataType", part.getTypeName().getLocalPart());
                    } else {
                        element.setAttributeNS(null, "dataType", "string");
                        element.setAttributeNS(null, "xmlType", "true");
                    }
                }
            }
            this.rootElement.appendChild(element);
        }
    }

    public ARSMapping(XMLSchemaParser xMLSchemaParser, Part part, Document document, String string, boolean bl) {
        this.schemaParser = xMLSchemaParser;
        if (xMLSchemaParser == null) {
            throw new ARWSException("INVALID_WSDL", "document style wsdl must have a <types> section");
        }
        if (string.equals("encoded")) {
            this.generateXsiType = true;
        }
        if (part.getElementName() != null) {
            this.name = part.getElementName().getLocalPart();
            this.targetNamespace = part.getElementName().getNamespaceURI();
            this.mappingMode = 2;
            this.createMappingRootElement(document);
            Element element = xMLSchemaParser.parseSchemaForElement(document, part.getElementName());
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            if (n != 0) {
                for (int i = 0; i < n; ++i) {
                    this.rootElement.appendChild(nodeList.item(0));
                }
            }
        } else if (part.getTypeName() != null) {
            this.name = part.getTypeName().getLocalPart();
            this.targetNamespace = part.getTypeName().getNamespaceURI();
            this.mappingMode = 3;
            this.createMappingRootElement(document);
            xMLSchemaParser.parseSchemaForType(this.rootElement, part.getTypeName());
        } else {
            throw new ARWSException("INVALID_WSDL", "Part must have element or type");
        }
    }

    public ARSMapping(XMLSchemaParser xMLSchemaParser, QName qName, String string, Document document) {
        this.schemaParser = xMLSchemaParser;
        if (xMLSchemaParser == null) {
            throw new ARWSException("INVALID_XSD", "xml schema parsing should have valid schema");
        }
        this.name = qName.getLocalPart();
        this.targetNamespace = qName.getNamespaceURI();
        this.mappingMode = string.equals("complexType") ? 3 : 2;
        this.createMappingRootElement(document);
        if (string.equals("complexType")) {
            xMLSchemaParser.parseSchemaForType(this.rootElement, qName);
            String string2 = (qName.getNamespaceURI().length() > 0 ? qName.getNamespaceURI() + ":" : "") + qName.getLocalPart();
            this.rootElement.setAttributeNS(null, "complexType", string2);
        } else {
            Element element = xMLSchemaParser.parseSchemaForElement(document, qName);
            this.rootElement.appendChild(element);
        }
    }

    public ARSMapping(String string, String string2, Document document) {
        this.name = string;
        this.targetNamespace = string2;
        this.createMappingRootElement(document);
    }

    protected void createMappingRootElement(Document document) {
        this.rootElement = document.createElementNS(null, "element");
        this.rootElement.setAttributeNS(null, "name", "ROOT");
        this.rootElement.setAttributeNS(null, "targetNamespace", this.targetNamespace);
        this.mappingElement = document.createElementNS(null, "arDocMapping");
        this.mappingElement.setAttributeNS(null, "name", this.name);
        this.mappingElement.appendChild(this.rootElement);
        if (this.generateXsiType) {
            this.mappingElement.setAttributeNS(null, "generateXsiType", "true");
        }
        if (this.mappingMode == 1) {
            this.mappingElement.setAttributeNS(null, "schemaSource", "generated");
        } else {
            this.mappingElement.setAttributeNS(null, "schemaSource", "imported");
        }
    }

    public void setMappingName(String string) {
        this.name = string;
        this.mappingElement.setAttributeNS(null, "name", string);
    }

    public void addSoapHeader(XMLSchemaParser xMLSchemaParser, Part part) {
        Document document = this.rootElement.getOwnerDocument();
        Element element = document.createElementNS(null, "element");
        element.setAttributeNS(null, "name", "SOAPHeader");
        if (part.getElementName() != null) {
            Element element2;
            Element element3;
            Element element4 = xMLSchemaParser.parseSchemaForElement(document, part.getElementName());
            element.appendChild(element4);
            if (element4.getTagName().equals("element") && element4.getAttribute("name").equals("AuthenticationInfo") && (element3 = (Element)element4.getFirstChild()) != null && element3.getTagName().equals("element") && element3.getAttribute("name") != null && element3.getAttribute("name").equals("userName") && (element2 = (Element)element3.getNextSibling()) != null && element2.getTagName().equals("element") && element2.getAttribute("name") != null && element2.getAttribute("name").equals("password")) {
                element3.setAttributeNS(null, "arUsername", "true");
                element2.setAttributeNS(null, "arPassword", "true");
            }
        } else if (part.getTypeName() != null) {
            xMLSchemaParser.parseSchemaForType(element, part.getTypeName());
        } else {
            throw new ARWSException("INVALID_WSDL", "Part must have element or type");
        }
        this.rootElement.insertBefore(element, this.rootElement.getFirstChild());
    }

    public void resolveMapping(ARSMapping aRSMapping, StringBuffer stringBuffer) {
        Document document = this.getMappingElement().getOwnerDocument();
        TreeWalker treeWalker = ((DocumentTraversal)((Object)document)).createTreeWalker(this.rootElement, 1, new FieldAndFormFilter(), false);
        Element element = (Element)treeWalker.getCurrentNode();
        Document document2 = aRSMapping.getMappingElement().getOwnerDocument();
        TreeWalker treeWalker2 = ((DocumentTraversal)((Object)document2)).createTreeWalker(aRSMapping.rootElement, 1, new FieldAndFormFilter(), false);
        Element element2 = (Element)treeWalker2.getCurrentNode();
        if (!(element.getLocalName().equals("element") && element2.getLocalName().equals("element") && element.getAttribute("name").equals("ROOT") && element2.getAttribute("name").equals("ROOT"))) {
            throw new ARWSException("OTHER_ERROR", "Internal error, root element is absent");
        }
        this.resolveTrees(treeWalker, treeWalker2, "", "", stringBuffer);
    }

    public static Element importElement(Document document, Element element) {
        Element element2 = (Element)document.importNode(element, false);
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            Attr attr2 = (Attr)document.importNode(attr, false);
            element2.setAttributeNode(attr2);
        }
        return element2;
    }

    protected void resolveTrees(TreeWalker treeWalker, TreeWalker treeWalker2, String string, String string2, StringBuffer stringBuffer) {
        Object object;
        Element element;
        Element element2;
        Object object2;
        Element element3 = (Element)treeWalker2.getCurrentNode();
        Element element4 = (Element)treeWalker.getCurrentNode();
        Element element5 = this.getFormMapping(element3);
        Element element6 = this.getFieldMapping(element3);
        Document document = element4.getOwnerDocument();
        if (element5 != null) {
            object2 = ARSMapping.getFirstChildElement(element5);
            element2 = ARSMapping.importElement(document, (Element)object2);
            element = ARSMapping.importElement(document, element5);
            element.appendChild(element2);
            string = object2.getAttribute("formName");
            object = element4.getParentNode();
            object.insertBefore(element, element4);
            element.appendChild(element4);
        }
        if (element6 != null) {
            object2 = ARSMapping.importElement(document, element6);
            element4.appendChild((Node)object2);
        }
        object2 = new LinkedList();
        element2 = (Element)treeWalker.firstChild();
        while (element2 != null) {
            ((LinkedList)object2).addLast(element2);
            element2 = (Element)treeWalker.nextSibling();
        }
        element = (Element)treeWalker2.firstChild();
        while (element != null) {
            object = string2 + element.getAttribute("name") + "/";
            boolean bl = false;
            Iterator iterator = ((AbstractSequentialList)object2).iterator();
            while (iterator.hasNext()) {
                element2 = (Element)iterator.next();
                if (!element2.getLocalName().equals(element.getLocalName()) || !element2.getAttribute("name").equals(element.getAttribute("name")) || !element2.getAttribute("dataType").equals(element.getAttribute("dataType"))) continue;
                iterator.remove();
                bl = true;
                break;
            }
            if (bl) {
                treeWalker.setCurrentNode(element2);
                this.resolveTrees(treeWalker, treeWalker2, string, (String)object, stringBuffer);
            } else {
                this.warnChildren(treeWalker2, string, string2, stringBuffer);
            }
            element = (Element)treeWalker2.nextSibling();
        }
        treeWalker2.setCurrentNode(element3);
        treeWalker.setCurrentNode(element4);
    }

    public Element getFormMapping(Element element) {
        Node node = element.getParentNode();
        if (node != null && node.getNodeType() == 1 && node.getNodeName().equals("formMapping")) {
            return (Element)node;
        }
        return null;
    }

    public Element getFieldMapping(Element element) {
        Element element2 = ARSMapping.getFirstChildElement(element);
        if (element2 != null && element2.getNodeName().equals("fieldMapping")) {
            return element2;
        }
        return null;
    }

    public void warnChildren(StringBuffer stringBuffer) {
        Document document = this.getMappingElement().getOwnerDocument();
        TreeWalker treeWalker = ((DocumentTraversal)((Object)document)).createTreeWalker(this.rootElement, 1, new FieldAndFormFilter(), false);
        this.warnChildren(treeWalker, "", "", stringBuffer);
    }

    public void warnChildren(TreeWalker treeWalker, String string, String string2, StringBuffer stringBuffer) {
        Element element;
        Element element2 = (Element)treeWalker.getCurrentNode();
        Element element3 = this.getFormMapping(element2);
        Element element4 = this.getFieldMapping(element2);
        if (element3 != null) {
            element = ARSMapping.getFirstChildElement(element3);
            string = element.getAttribute("formName");
            stringBuffer.append("WARNING: losing form mapping of " + string2 + element2.getAttribute("name") + " to FORM " + string + " in " + this.getName() + System.getProperty("line.separator"));
        }
        if (element4 != null) {
            stringBuffer.append("WARNING: losing field mapping of " + string2 + element2.getAttribute("name") + " to FIELD " + element4.getAttribute("arFieldId") + " of " + string + " in " + this.getName() + System.getProperty("line.separator"));
        }
        element = (Element)treeWalker.firstChild();
        while (element != null) {
            String string3 = string2 + element2.getAttribute("name") + "/";
            this.warnChildren(treeWalker, string, string3, stringBuffer);
            element = (Element)treeWalker.nextSibling();
        }
        treeWalker.setCurrentNode(element2);
    }

    public void generateXML(Element element) {
        Document document = element.getOwnerDocument();
        if (document == this.mappingElement.getOwnerDocument()) {
            element.appendChild(this.mappingElement);
        }
    }

    public class FieldAndFormFilter
    implements NodeFilter {
        public short acceptNode(Node node) {
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if (element.getLocalName().equals("element") || element.getLocalName().equals("attribute") || element.getLocalName().equals("choice")) {
                    return 1;
                }
                if (element.getLocalName().equals("formMapping")) {
                    return 3;
                }
            }
            return 2;
        }
    }
}

