/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.util;

import com.bmc.arsys.ws.util.ARWSException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WsdlUtil {
    protected static boolean nativeLogging = false;
    protected static String adminToolEncoding = System.getProperty("file.encoding");
    public static boolean enableLogging = true;

    public static void trace(String string) {
        if (enableLogging) {
            if (nativeLogging) {
                WsdlUtil.nativeTrace("WSDL trace: " + string + "\r\n");
            } else {
                System.err.println(string);
            }
        }
    }

    protected static native void nativeTrace(String var0);

    public static Document newDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ARWSException("OTHER_ERROR", "ParserConfigurationException ", parserConfigurationException);
        }
        return document;
    }

    protected static ARWSException analyseSAXException(SAXException sAXException, InputSource inputSource) {
        Object object;
        Reader reader = inputSource.getCharacterStream();
        if (reader == null) {
            object = inputSource.getByteStream();
            if (object == null) {
                try {
                    object = new URL(inputSource.getSystemId()).openStream();
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (object != null) {
                reader = new BufferedReader(new InputStreamReader((InputStream)object));
            }
        }
        if (reader != null) {
            object = new char[8192];
            try {
                reader.read((char[])object);
                String string = new String((char[])object);
                if (string.indexOf("ARSystem login page") != -1) {
                    return new ARWSException("ARS_WS_NEEDS_PUBLIC_ACCESS", "You need to grant public access to this ARSystem Web Service, before you can use it " + inputSource.getSystemId(), sAXException, inputSource.getSystemId());
                }
                if (string.indexOf("<HTML>") != -1 || string.indexOf("<html>") != -1) {
                    return new ARWSException("XML_IS_ACTUALLY_HTML", "This is not an XML file. It is actually an HTML file, open it in the browser to see what it says " + inputSource.getSystemId(), sAXException, inputSource.getSystemId());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new ARWSException("INVALID_XML", "Invalid XML in " + inputSource.getSystemId(), sAXException, inputSource.getSystemId());
    }

    public static InputSource validateWSDL(InputSource inputSource) {
        Object object;
        Document document = null;
        StringWriter stringWriter = new StringWriter();
        boolean bl = false;
        try {
            object = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object).setNamespaceAware(true);
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            document = documentBuilder.parse(inputSource);
            Element element = document.getDocumentElement();
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node = namedNodeMap.item(i);
                String string = node.getNodeName();
                String string2 = node.getNodeValue();
                if (!string2.equals("http://schemas.xmlsoap.org/wsdl/soap12/")) continue;
                element.setAttribute(string, "http://schemas.xmlsoap.org/wsdl/soap/");
                bl = true;
            }
            if (bl) {
                XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, null);
                xMLSerializer.asDOMSerializer();
                xMLSerializer.serialize(document);
            }
        }
        catch (IOException iOException) {
            throw new ARWSException("URI_NOT_FOUND", "URI not found " + inputSource.getSystemId(), iOException, inputSource.getSystemId());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ARWSException("OTHER_ERROR", "ParserConfigurationException cannot parse " + inputSource.getSystemId(), parserConfigurationException, inputSource.getSystemId());
        }
        catch (SAXException sAXException) {
            throw WsdlUtil.analyseSAXException(sAXException, inputSource);
        }
        object = inputSource;
        if (bl) {
            object = new InputSource(new StringReader(stringWriter.toString()));
        }
        return object;
    }

    public static Document newDocument(InputSource inputSource) {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(inputSource);
        }
        catch (IOException iOException) {
            throw new ARWSException("URI_NOT_FOUND", "URI not found " + inputSource.getSystemId(), iOException, inputSource.getSystemId());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ARWSException("OTHER_ERROR", "ParserConfigurationException cannot parse " + inputSource.getSystemId(), parserConfigurationException, inputSource.getSystemId());
        }
        catch (SAXException sAXException) {
            throw WsdlUtil.analyseSAXException(sAXException, inputSource);
        }
        return document;
    }

    public static Document newDocument(InputStream inputStream) {
        return WsdlUtil.newDocument(new InputSource(inputStream));
    }

    public static Document newDocument(String string, boolean bl) {
        InputSource inputSource = new InputSource(string);
        if (bl) {
            inputSource = WsdlUtil.validateWSDL(inputSource);
        }
        return WsdlUtil.newDocument(inputSource);
    }

    public static String getAdminToolEncoding() {
        return adminToolEncoding;
    }
}

