/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.artranscode.ARCharSet;
import com.bmc.arsys.pluginsvr.ARPluginDefinition;
import com.bmc.arsys.pluginsvr.ARPluginServerConfigKey;
import com.bmc.arsys.pluginsvr.PluginGroup;
import com.bmc.arsys.pluginsvr.encrypt.ARPluginServerEncryptionInfo;
import com.bmc.arsys.utils.CatalogReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.xml.DOMConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARPluginServerConfiguration {
    private static final String PLUGIN_SERVER_WORKING_DIRECTORY = "pluginWork";
    private static Logger log = Logger.getLogger(ARPluginServerConfiguration.class);
    private static ARPluginServerConfiguration theInstance = new ARPluginServerConfiguration();
    private static String AR_PLUGIN_SERVER_CONFIG_FILE = "pluginsvr_config.xml";
    public static String DEFAULT_SET_NAME = "NONE";
    private static String SET_NAME_PREFIX = "PluginSet_";
    private static int SETCOUNT = 0;
    private static String AR_PLUGIN_USER_DEFINED_TAG = "userDefined";
    private XMLConfiguration mConfig;
    private InetAddress mHostID;
    private int mPort;
    private String mInstallPath = "";
    private String mCharSet;
    private String[] mCmdLineArgs;
    private int mMinThreads = 2;
    private int mMaxThreads = 5;
    private int mThreadTimeout = 10000;
    private int mDataEncryptionKeyExpiry = ARPluginServerConfigKey.DataKeyExpiry.getIntDefaultValue();
    private int mPublicKeyExpiry = ARPluginServerConfigKey.PublicKeyExpiry.getIntDefaultValue();
    private int mEncryptionSecurityPolicy = ARPluginServerConfigKey.EncPolicy.getIntDefaultValue();
    private int mDataEncryptionAlgorithm = ARPluginServerConfigKey.DataEncryptionAlg.getIntDefaultValue();
    private int mPublicKeyAlgorithm = ARPluginServerConfigKey.PublicKeyAlg.getIntDefaultValue();
    private int mNumEncSessionHashentries;
    private HashMap<String, PluginGroup> mPluginGroups;
    private ArrayList<ARPluginDefinition> mTopLevelPlugins;
    private ArrayList<ARPluginDefinition> mLegacyPlugins = new ArrayList();
    private HashMap<String, String> mPluginNames = new HashMap();
    private HashMap<String, Integer> mPluginCount = new HashMap();
    private HashMap<String, Integer> mGroupCount = new HashMap();
    private HashMap mARConfig = new HashMap();
    private String mPluginAuth;
    private String mPluginPass;
    private boolean mbRegPortMapper = false;
    private boolean mbLoadNativePluginHost = true;

    private ARPluginServerConfiguration() {
    }

    private void initializeLogging() {
        Logger logger;
        Appender appender;
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("log4j_pluginsvr.xml");
        if (uRL != null) {
            DOMConfigurator.configure((URL)uRL);
        }
        if ((appender = (logger = Logger.getRootLogger()).getAppender("PluginLog")) instanceof RollingFileAppender) {
            String string = ((RollingFileAppender)appender).getFile();
            PrintStream printStream = null;
            PrintStream printStream2 = null;
            if (string != null) {
                try {
                    File file = new File(string);
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(string, true);
                    printStream = new PrintStream(fileOutputStream);
                    FileOutputStream fileOutputStream2 = new FileOutputStream(string, true);
                    printStream2 = new PrintStream(fileOutputStream2);
                    System.setErr(printStream2);
                    System.setOut(printStream);
                }
                catch (IOException iOException) {
                    log.warn((Object)"Error encountered while redirecting stdout and stderr to the plugin log", (Throwable)iOException);
                }
            }
        }
    }

    public void initialize(String[] stringArray) throws ARException {
        this.mCmdLineArgs = stringArray;
        try {
            String string;
            this.initializeLogging();
            this.parseCommandLineArguments(stringArray);
            URL uRL = Thread.currentThread().getContextClassLoader().getResource(AR_PLUGIN_SERVER_CONFIG_FILE);
            if (uRL == null) {
                log.error((Object)CatalogReader.getInstance().getMessage(8768));
                System.out.println(CatalogReader.getInstance().getMessage(8768));
                throw new ARException(2, 8768);
            }
            this.mConfig = new XMLConfiguration(uRL);
            this.mConfig.load();
            this.mEncryptionSecurityPolicy = this.mConfig.getInt(ARPluginServerConfigKey.EncPolicy.getKey(), ARPluginServerConfigKey.EncPolicy.getIntDefaultValue());
            this.mPublicKeyAlgorithm = this.mConfig.getInt(ARPluginServerConfigKey.PublicKeyAlg.getKey(), ARPluginServerConfigKey.PublicKeyAlg.getIntDefaultValue());
            this.mPublicKeyExpiry = this.mConfig.getInt(ARPluginServerConfigKey.PublicKeyExpiry.getKey(), ARPluginServerConfigKey.PublicKeyExpiry.getIntDefaultValue());
            this.mDataEncryptionAlgorithm = this.mConfig.getInt(ARPluginServerConfigKey.DataEncryptionAlg.getKey(), ARPluginServerConfigKey.DataEncryptionAlg.getIntDefaultValue());
            this.mDataEncryptionKeyExpiry = this.mConfig.getInt(ARPluginServerConfigKey.DataKeyExpiry.getKey(), ARPluginServerConfigKey.DataKeyExpiry.getIntDefaultValue());
            this.mPort = this.mConfig.getInt(ARPluginServerConfigKey.TcpPort.getKey(), ARPluginServerConfigKey.TcpPort.getIntDefaultValue());
            this.mPluginAuth = this.mConfig.getString(ARPluginServerConfigKey.PluginAuth.getKey(), ARPluginServerConfigKey.PluginAuth.getDefaultValue());
            this.mbRegPortMapper = this.mConfig.getBoolean(ARPluginServerConfigKey.RegPortMapper.getKey(), ARPluginServerConfigKey.RegPortMapper.getBoolDefaultValue());
            this.mbLoadNativePluginHost = this.mConfig.getBoolean(ARPluginServerConfigKey.LoadNativePluginHost.getKey(), ARPluginServerConfigKey.LoadNativePluginHost.getBoolDefaultValue());
            if (this.mPort < 0 || this.mPort > 65535) {
                log.error((Object)CatalogReader.getInstance().getMessage(8782));
                log.error((Object)"Using portmapper for an available port");
                this.mbRegPortMapper = true;
                this.mPort = 0;
            }
            if (this.mPort == 0) {
                this.mbRegPortMapper = true;
                this.mPort = 0;
                log.info((Object)"Using portmapper for an available port");
            }
            if (this.mCharSet == null) {
                string = this.mConfig.getString(ARPluginServerConfigKey.ServerCharSet.getKey());
                if (string != null) {
                    this.mCharSet = ARCharSet.getServerCharSetName((String)string);
                    if (!Charset.isSupported(this.mCharSet)) {
                        log.warn((Object)"The configured charset is not supported by the JVM.");
                        this.mCharSet = null;
                    }
                }
                if (this.mCharSet == null) {
                    Charset charset = Charset.defaultCharset();
                    this.mCharSet = charset.name();
                }
            }
            string = ARPluginServerConfigKey.PluginsRoot.getKey() + ARPluginServerConfigKey.Plugins.getKey();
            this.mTopLevelPlugins = this.loadPlugins((HierarchicalConfiguration)this.mConfig, string, string);
            this.mPluginGroups = this.loadPluginGroups(ARPluginServerConfigKey.PluginsRoot.getKey() + ARPluginServerConfigKey.PluginSet.getKey(), DEFAULT_SET_NAME);
            this.setupPluginAuth();
        }
        catch (ConfigurationException configurationException) {
            log.error((Object)CatalogReader.getInstance().getMessage(8768), (Throwable)configurationException);
            System.out.println(CatalogReader.getInstance().getMessage(8768) + configurationException.getLocalizedMessage());
            throw new ARException(2, 8768, configurationException.getLocalizedMessage());
        }
    }

    private boolean isValidPluginConfiguration(ARPluginDefinition aRPluginDefinition) {
        boolean bl = true;
        String string = aRPluginDefinition.getFileName();
        String string2 = aRPluginDefinition.getPluginType();
        String string3 = aRPluginDefinition.getPluginCode();
        String string4 = aRPluginDefinition.getFileName();
        String string5 = aRPluginDefinition.getClassName();
        int n = aRPluginDefinition.getVersion();
        if (string == null || string.equals("")) {
            if (!string3.equals("C")) {
                return false;
            }
            string = "";
        }
        if (string4 == null || string4.equals("")) {
            return false;
        }
        if (string3 == null || string3.equals("") || !string3.equalsIgnoreCase("C") && !string3.equalsIgnoreCase("JAVA")) {
            return false;
        }
        if (string3.equalsIgnoreCase("JAVA") && (string5 == null || string5.equals(""))) {
            return false;
        }
        if (string2 == null || string2.equals("") || !string2.equalsIgnoreCase("ARDBC") && !string2.equalsIgnoreCase("AREA") && !string2.equalsIgnoreCase("FilterAPI")) {
            return false;
        }
        if (string2.equals("ARDBC")) {
            if (n == 0) {
                aRPluginDefinition.setVersion(4);
            } else if (n != 4) {
                return false;
            }
        } else if (string2.equals("AREA")) {
            if (n == 0) {
                aRPluginDefinition.setVersion(3);
            } else if (n != 3) {
                return false;
            }
        } else if (string2.equals("FILTERAPI")) {
            if (n == 0) {
                aRPluginDefinition.setVersion(2);
            } else if (n != 2) {
                return false;
            }
        }
        return bl;
    }

    private ArrayList<ARPluginDefinition> loadPlugins(HierarchicalConfiguration hierarchicalConfiguration, String string, String string2) {
        ArrayList<ARPluginDefinition> arrayList = new ArrayList<ARPluginDefinition>();
        List list = hierarchicalConfiguration.configurationsAt(string2);
        for (HierarchicalConfiguration hierarchicalConfiguration2 : list) {
            Object object;
            String string3 = hierarchicalConfiguration2.getString(ARPluginServerConfigKey.PluginName.getKey());
            String string4 = hierarchicalConfiguration2.getString(ARPluginServerConfigKey.PluginType.getKey());
            String string5 = hierarchicalConfiguration2.getString(ARPluginServerConfigKey.PluginFilename.getKey());
            String string6 = hierarchicalConfiguration2.getString(ARPluginServerConfigKey.PluginCode.getKey());
            String string7 = hierarchicalConfiguration2.getString(ARPluginServerConfigKey.PluginClassname.getKey());
            int n = hierarchicalConfiguration2.getInt(ARPluginServerConfigKey.PluginVersion.getKey(), ARPluginServerConfigKey.PluginVersion.getIntDefaultValue());
            ARPluginDefinition aRPluginDefinition = new ARPluginDefinition(string3, string5, string7, string6, string4, n);
            List list2 = hierarchicalConfiguration2.configurationsAt(ARPluginServerConfigKey.PluginClassPath.getKey());
            if (list2 != null && list2.size() > 0) {
                object = new ArrayList();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (HierarchicalConfiguration hierarchicalConfiguration3 : list2) {
                    String string8 = hierarchicalConfiguration3.getString("[@type]");
                    String string9 = null;
                    String string10 = null;
                    if (string8 != null && string8.equals("path")) {
                        string9 = (String)hierarchicalConfiguration3.getRoot().getValue();
                    } else if (string8 != null && string8.equals("location")) {
                        string10 = (String)hierarchicalConfiguration3.getRoot().getValue();
                    }
                    if (string9 != null) {
                        arrayList2.add(string9);
                    }
                    if (string10 == null) continue;
                    ((ArrayList)object).add(string10);
                }
                aRPluginDefinition.setClassPathFolders(arrayList2);
                aRPluginDefinition.setClassPathJars((ArrayList<String>)object);
            }
            if (!this.isValidPluginConfiguration(aRPluginDefinition)) {
                object = aRPluginDefinition.getPluginName();
                if (aRPluginDefinition.getPluginName() == null || aRPluginDefinition.getPluginName().equals("")) {
                    object = aRPluginDefinition.getFileName();
                }
                log.error((Object)(CatalogReader.getInstance().getMessage(8769) + ": " + (String)object));
                continue;
            }
            if (this.mPluginNames.containsKey(string3)) {
                int n2 = this.mPluginCount.get(string3) + 1;
                this.mPluginCount.put(string3, n2);
                if ((string3 == null || string3.equals("")) && string6.equals("C")) {
                    if (this.mLegacyPlugins.contains(aRPluginDefinition)) {
                        if (n2 <= 2) continue;
                        log.error((Object)(CatalogReader.getInstance().getMessage(8771) + " :" + string3));
                        continue;
                    }
                } else {
                    if (n2 <= 2) continue;
                    log.error((Object)(CatalogReader.getInstance().getMessage(8771) + " :" + string3));
                    continue;
                }
            }
            this.mPluginNames.put(string3, string);
            this.mPluginCount.put(string3, 1);
            if (string6.equalsIgnoreCase("C") || string5.endsWith(".dll")) {
                this.mLegacyPlugins.add(aRPluginDefinition);
                continue;
            }
            arrayList.add(aRPluginDefinition);
        }
        return arrayList;
    }

    private HashMap<String, PluginGroup> loadPluginGroups(String string, String string2) {
        List list = this.mConfig.configurationsAt(string);
        HashMap<String, PluginGroup> hashMap = new HashMap<String, PluginGroup>();
        for (HierarchicalConfiguration hierarchicalConfiguration : list) {
            String string3 = hierarchicalConfiguration.getString("[@name]");
            if (string3 == null) {
                string3 = SET_NAME_PREFIX + SETCOUNT++;
            }
            if (hashMap.containsKey(string3)) {
                int n = this.mGroupCount.get(string3) + 1;
                this.mGroupCount.put(string3, n);
                if (n <= 2) continue;
                log.warn((Object)(CatalogReader.getInstance().getMessage(8771) + " " + string3));
                continue;
            }
            ArrayList<ARPluginDefinition> arrayList = this.loadPlugins(hierarchicalConfiguration, string + ARPluginServerConfigKey.Plugins.getKey(), ARPluginServerConfigKey.Plugins.getKey().substring(1));
            HashMap<String, PluginGroup> hashMap2 = this.loadPluginGroups(string + ARPluginServerConfigKey.PluginSet.getKey(), string3);
            PluginGroup pluginGroup = new PluginGroup(string2, hashMap2, arrayList);
            List list2 = hierarchicalConfiguration.configurationsAt(ARPluginServerConfigKey.PluginClassPath.getKey());
            if (list2 != null && list2.size() > 0) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                for (HierarchicalConfiguration hierarchicalConfiguration2 : list2) {
                    String string4 = hierarchicalConfiguration2.getString("[@type]");
                    String string5 = null;
                    String string6 = null;
                    if (string4 != null && string4.equals("path")) {
                        string5 = (String)hierarchicalConfiguration2.getRoot().getValue();
                    } else if (string4 != null && string4.equals("location")) {
                        string6 = (String)hierarchicalConfiguration2.getRoot().getValue();
                    }
                    if (string5 != null) {
                        arrayList3.add(string5);
                    }
                    if (string6 == null) continue;
                    arrayList2.add(string6);
                }
                pluginGroup.setClassPathFolders(arrayList3);
                pluginGroup.setClassPathJars(arrayList2);
            }
            hashMap.put(string3, pluginGroup);
            this.mGroupCount.put(string3, 1);
        }
        return hashMap;
    }

    public static ARPluginServerConfiguration getInstance() {
        return theInstance;
    }

    public boolean getLoadNativePluginhost() {
        String string = System.getProperty("os.arch");
        if (string != null && string.equals("sparc")) {
            return false;
        }
        return this.mbLoadNativePluginHost;
    }

    public String getServerCharset() {
        return this.mCharSet;
    }

    public String getServerARCharset() {
        return ARCharSet.getServerKnownCharSetString((String)this.mCharSet.toLowerCase());
    }

    public String[] getCmdLineArgs() {
        return this.mCmdLineArgs;
    }

    public synchronized String getConfigValue(String string, String string2) {
        String string3;
        String string4 = null;
        if (string != null && string2 != null && (string3 = this.mPluginNames.get(string)) != null && !string3.equals("")) {
            List list = this.mConfig.configurationsAt(string3);
            for (HierarchicalConfiguration hierarchicalConfiguration : list) {
                String string5 = hierarchicalConfiguration.getString(ARPluginServerConfigKey.PluginName.getKey());
                if (!string5.equals(string)) continue;
                string4 = hierarchicalConfiguration.getString(AR_PLUGIN_USER_DEFINED_TAG + "." + string2);
                break;
            }
        }
        return string4;
    }

    public synchronized void setConfigValue(String string, String string2, Object object) {
        String string3;
        if (string != null && string2 != null && (string3 = this.mPluginNames.get(string)) != null && !string3.equals("")) {
            List list = this.mConfig.configurationsAt(string3);
            for (HierarchicalConfiguration hierarchicalConfiguration : list) {
                String string4 = hierarchicalConfiguration.getString(ARPluginServerConfigKey.PluginName.getKey());
                if (!string4.equals(string)) continue;
                hierarchicalConfiguration.setProperty(string2, object);
                break;
            }
        }
    }

    public synchronized void saveConfiguration() {
        try {
            this.mConfig.save();
        }
        catch (ConfigurationException configurationException) {
            log.warn((Object)CatalogReader.getInstance().getMessage(8769), (Throwable)configurationException);
        }
    }

    public int getThreadTimeout() {
        return this.mThreadTimeout;
    }

    public int getPort() {
        return this.mPort;
    }

    public String getHostName() {
        return this.mHostID.getHostName();
    }

    public InetAddress getHostID() {
        return this.mHostID;
    }

    public int getMinThreads(int n) {
        return this.mMinThreads;
    }

    public int getMaxThreads(int n) {
        return this.mMaxThreads;
    }

    public ArrayList<ARPluginDefinition> getConfiguredPlugins() {
        return this.mTopLevelPlugins;
    }

    public ArrayList<ARPluginDefinition> getNativePlugins() {
        return this.mLegacyPlugins;
    }

    public HashMap<String, PluginGroup> getConfiguredPluginGroups() {
        return this.mPluginGroups;
    }

    public boolean isRegisteredWithPortMapper() {
        return this.mbRegPortMapper;
    }

    public void setMaxThreads(int n, int n2) {
        this.mMaxThreads = n2;
    }

    public void setMinThreads(int n, int n2) {
        this.mMinThreads = n2;
    }

    public int getDataEncryptionKeyExpiry() {
        return this.mDataEncryptionKeyExpiry;
    }

    public int getPublicKeyExpiry() {
        return this.mPublicKeyExpiry;
    }

    public int getEncryptionSecurityPolicy() {
        return this.mEncryptionSecurityPolicy;
    }

    public int getDataEncryptionAlgorithm() {
        return this.mDataEncryptionAlgorithm;
    }

    public int getPublicKeyAlgorithm() {
        return this.mPublicKeyAlgorithm;
    }

    public int getNumEncSessionHashentries() {
        return this.mNumEncSessionHashentries;
    }

    public String getWorkingDirectory() {
        if (this.mInstallPath.endsWith(File.separator)) {
            return this.mInstallPath + PLUGIN_SERVER_WORKING_DIRECTORY;
        }
        return this.mInstallPath + File.separator + PLUGIN_SERVER_WORKING_DIRECTORY;
    }

    public String getARConfigEntry(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        Object v = this.mARConfig.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof List) {
            ArrayList arrayList = (ArrayList)v;
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = (String)arrayList.get(i);
                stringBuffer.append(string2);
                stringBuffer.append(";");
            }
        } else {
            stringBuffer.append((String)v);
        }
        return stringBuffer.toString();
    }

    public Object getARConfigItem(String string) {
        Object v = this.mARConfig.get(string);
        return v;
    }

    public String getPluginPassword() {
        return this.mPluginPass;
    }

    public void parseCommandLineArguments(String[] stringArray) throws ARException {
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                if (i < stringArray.length && stringArray[i].equals("-x")) {
                    String string2 = string = ++i < stringArray.length ? stringArray[i] : null;
                    if (string != null && !string.equals("")) {
                        try {
                            this.mHostID = InetAddress.getByName(string);
                            continue;
                        }
                        catch (UnknownHostException unknownHostException) {
                            try {
                                this.mHostID = InetAddress.getLocalHost();
                                continue;
                            }
                            catch (UnknownHostException unknownHostException2) {
                                log.error((Object)CatalogReader.getInstance().getMessage(8783), (Throwable)unknownHostException);
                                throw new ARException(2, 8783);
                            }
                        }
                    }
                    try {
                        this.mHostID = InetAddress.getLocalHost();
                        continue;
                    }
                    catch (UnknownHostException unknownHostException) {
                        log.error((Object)CatalogReader.getInstance().getMessage(8781));
                        throw new ARException(2, 8781);
                    }
                }
                if (i < stringArray.length && stringArray[i].equals("-t")) {
                    String string3 = string = ++i < stringArray.length ? stringArray[i] : null;
                    if (string == null || string.equals("")) continue;
                    try {
                        this.mPort = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.error((Object)CatalogReader.getInstance().getMessage(8782), (Throwable)numberFormatException);
                    }
                    continue;
                }
                if (i < stringArray.length && stringArray[i].equals("-i")) {
                    String string4 = string = ++i < stringArray.length ? stringArray[i] : null;
                    if (string != null && !string.equals("")) {
                        File file = new File(string);
                        if (!file.exists() || !file.isDirectory()) {
                            log.error((Object)("Invalid path for install folder " + string));
                            this.mInstallPath = "";
                            continue;
                        }
                        this.mInstallPath = string;
                        if (this.mInstallPath.endsWith("/") || this.mInstallPath.endsWith("\\")) continue;
                        this.mInstallPath = this.mInstallPath + "/";
                        continue;
                    }
                    this.mInstallPath = "";
                    log.error((Object)CatalogReader.getInstance().getMessage(8781));
                    System.out.println(CatalogReader.getInstance().getMessage(8781));
                    throw new ARException(2, 8781);
                }
                if (i >= stringArray.length || !stringArray[i].equalsIgnoreCase("--unicode") && !stringArray[i].equalsIgnoreCase("--U")) continue;
                this.mCharSet = "utf-8";
            }
            if (this.mHostID == null) {
                try {
                    this.mHostID = InetAddress.getLocalHost();
                }
                catch (UnknownHostException unknownHostException) {
                    log.error((Object)CatalogReader.getInstance().getMessage(8781));
                    throw new ARException(2, 8781);
                }
            }
        } else {
            System.out.println("Invalid command line arguments");
            this.printUsage();
            log.error((Object)CatalogReader.getInstance().getMessage(8781));
            throw new ARException(2, 8781);
        }
        this.loadARConfigFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadARConfigFile() {
        if (this.mInstallPath != null && !this.mInstallPath.equals("")) {
            BufferedReader bufferedReader = null;
            try {
                String string = this.mInstallPath + File.separator + "conf" + File.separator + "ar.";
                String string2 = string + "cfg";
                File file = new File(string2);
                if (!file.exists() || !file.isFile()) {
                    string2 = string + "conf";
                    file = new File(string2);
                }
                if (file.exists() && file.isFile()) {
                    bufferedReader = new BufferedReader(new FileReader(file));
                    String string3 = null;
                    while ((string3 = bufferedReader.readLine()) != null) {
                        int n;
                        if (string3.equals("") || (n = string3.indexOf(58)) <= 0) continue;
                        String string4 = string3.substring(0, n).trim();
                        String string5 = string3.substring(n + 1).trim();
                        if (this.mARConfig.containsKey(string4)) {
                            Object v = this.mARConfig.get(string4);
                            if (v instanceof List) {
                                ((List)v).add(string5);
                                this.mARConfig.put(string4, v);
                                continue;
                            }
                            ArrayList<Object> arrayList = new ArrayList<Object>();
                            arrayList.add(v);
                            arrayList.add(string5);
                            this.mARConfig.put(string4, arrayList);
                            continue;
                        }
                        this.mARConfig.put(string4, string5);
                    }
                } else {
                    log.error((Object)("Could not find AR config file " + string2));
                }
            }
            catch (Throwable throwable) {
                log.error((Object)"Could not load AR config file ", throwable);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void setupPluginAuth() throws ARException {
        Object object;
        String string = null;
        if (this.mPluginAuth == null || this.mPluginAuth.equals("")) {
            object = this.getARConfigItem("Plugin-Password");
            if (object != null) {
                String string2 = null;
                if (object instanceof String) {
                    string2 = (String)object;
                } else {
                    ArrayList arrayList = (ArrayList)object;
                    for (int i = 0; i < arrayList.size() && (string2 = (String)arrayList.get(i)) == null; ++i) {
                    }
                }
                if (string2 != null) {
                    string = string2;
                }
            }
        } else {
            string = this.mPluginAuth;
        }
        this.mPluginPass = string != null ? ((object = System.getProperty("os.arch")) != null && ((String)object).equals("sparc") ? null : ARPluginServerEncryptionInfo.getInstance().toPswdString(string)) : null;
    }

    private void printUsage() {
        System.out.println("Usage: java ARPluginServerMain -x hostname -t portnum");
    }
}

