/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import org.quartz.SchedulerConfigException;
import org.quartz.spi.ThreadPool;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public class LocalTaskExecutorThreadPool
implements ThreadPool {
    private TaskExecutor taskExecutor;

    public void initialize() throws SchedulerConfigException {
        this.taskExecutor = SchedulerFactoryBean.getConfigTimeTaskExecutor();
        if (this.taskExecutor == null) {
            throw new SchedulerConfigException("No local TaskExecutor found for configuration - 'taskExecutor' property must be set on SchedulerFactoryBean");
        }
    }

    public void shutdown(boolean waitForJobsToComplete) {
    }

    public int getPoolSize() {
        return -1;
    }

    public boolean runInThread(Runnable runnable) {
        if (runnable == null) {
            return false;
        }
        this.taskExecutor.execute(runnable);
        return true;
    }
}

