/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.util.ObjectUtils;

public class ReplaceOverride
extends MethodOverride {
    private final String methodReplacerBeanName;
    private List typeIdentifiers = new LinkedList();

    public ReplaceOverride(String methodName, String methodReplacerBeanName) {
        super(methodName);
        this.methodReplacerBeanName = methodReplacerBeanName;
    }

    public String getMethodReplacerBeanName() {
        return this.methodReplacerBeanName;
    }

    public void addTypeIdentifier(String s) {
        this.typeIdentifiers.add(s);
    }

    public boolean matches(Method method) {
        if (!method.getName().equals(this.getMethodName())) {
            return false;
        }
        if (!this.isOverloaded()) {
            return true;
        }
        if (this.typeIdentifiers.size() != method.getParameterTypes().length) {
            return false;
        }
        for (int i = 0; i < this.typeIdentifiers.size(); ++i) {
            String identifier = (String)this.typeIdentifiers.get(i);
            if (method.getParameterTypes()[i].getName().indexOf(identifier) != -1) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ReplaceOverride that = (ReplaceOverride)o;
        if (!ObjectUtils.nullSafeEquals(this.methodReplacerBeanName, that.methodReplacerBeanName)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.typeIdentifiers, that.typeIdentifiers);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + ObjectUtils.nullSafeHashCode(this.methodReplacerBeanName);
        result = 29 * result + ObjectUtils.nullSafeHashCode(this.typeIdentifiers);
        return result;
    }

    public String toString() {
        return "Replace override for method '" + this.getMethodName() + "; will call bean '" + this.methodReplacerBeanName + "'";
    }
}

