/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.plugins;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.PropInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.PasswordEncryption;
import com.bmc.arsys.arrpc.ArEsRequest4In;
import com.bmc.arsys.arrpc.ArEsRequest4Out;
import com.bmc.arsys.arrpc.ArPropList;
import com.bmc.arsys.arrpc.ArStatusList6;
import com.bmc.arsys.arrpc.ArStatusStruct6;
import com.bmc.arsys.pluginsvr.mapping.ApiToRpcMapping;
import com.bmc.arsys.pluginsvr.plugins.AREAPluggable;
import com.bmc.arsys.pluginsvr.plugins.AREAResponse;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginRepository;
import com.bmc.arsys.pluginsvr.plugins.PluginEnvelope;
import com.bmc.arsys.pluginsvr.plugins.ValueObjectFactory;
import com.bmc.arsys.utils.CatalogReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AREAPluginRepository
extends ARPluginRepository {
    private static Logger LOGGER = Logger.getLogger(AREAPluginRepository.class);
    private static final int AR_AUTH_PROP_NONE = 0;
    private static final int AR_AUTH_PROP_NAME = 1;
    private static final int AR_AUTH_PROP_PASSWORD = 2;
    private static final int AR_AUTH_PROP_LICENSE_TYPE = 3;
    private static final int AR_AUTH_PROP_LICENSE_FTS = 4;
    private static final int AR_AUTH_PROP_LICENSE_RES1 = 5;
    private static final int AR_AUTH_PROP_GROUPS = 6;
    private static final int AR_AUTH_PROP_EMAIL = 7;
    private static final int AR_AUTH_PROP_STATUS = 8;
    private static final int AR_AUTH_PROP_MESSAGE_TEXT = 9;
    private static final int AR_AUTH_PROP_NETWORK_ADDR = 10;
    private static final int AR_AUTH_PROP_NOTIFY_MECH = 11;
    private static final int AR_AUTH_PROP_LOG_TEXT = 12;
    private static final int AR_AUTH_PROP_MOD_TIME = 13;
    private static final int AR_AUTH_PROP_AUTH_STRING = 14;
    private static final int AR_AUTH_PROP_LICENSE_APPS = 15;
    private static final int AR_AUTH_PROP_BSM_AUTH = 16;
    private static final int AR_AUTH_MAX_PROP = 16;
    public static final int AREA_VERIFY_LOGIN = 1;
    public static final int AREA_NEED_SYNC = 2;
    protected ArrayList<PluginEnvelope> mPlugins = new ArrayList();

    AREAPluginRepository() {
    }

    @Override
    void addPlugin(String string, PluginEnvelope pluginEnvelope) throws ARException {
        this.mPlugins.add(pluginEnvelope);
    }

    @Override
    PluginEnvelope getPlugin(String string) {
        for (PluginEnvelope pluginEnvelope : this.mPlugins) {
            if (!pluginEnvelope.getPluginName().equals(string)) continue;
            return pluginEnvelope;
        }
        return null;
    }

    public ArEsRequest4Out AREANeedSync(ArEsRequest4In arEsRequest4In) {
        ArEsRequest4Out arEsRequest4Out = new ArEsRequest4Out();
        arEsRequest4Out.setControl(arEsRequest4In.getControl());
        arEsRequest4Out.setStatus(new ArStatusList6());
        PropInfo[] propInfoArray = null;
        propInfoArray = new PropInfo[]{new PropInfo(8, new Value(1))};
        try {
            this.validateClient(arEsRequest4In.getControl().getPassword());
            Iterator<PluginEnvelope> iterator = this.mPlugins.iterator();
            AREAPluggable aREAPluggable = null;
            PluginEnvelope pluginEnvelope = null;
            boolean bl = false;
            while (iterator.hasNext()) {
                try {
                    pluginEnvelope = iterator.next();
                    aREAPluggable = (AREAPluggable)pluginEnvelope.mPlugin;
                    bl = aREAPluggable.areaNeedSync(ApiToRpcMapping.getInstance().getContextFromControl(arEsRequest4In.getControl(), pluginEnvelope.mPluginInfo));
                    if (!bl) continue;
                    break;
                }
                catch (ARException aRException) {
                    LOGGER.warn((Object)("AREANeedSync() FAIL: for plugin " + pluginEnvelope.getPluginName()), (Throwable)aRException);
                }
                catch (Throwable throwable) {
                    LOGGER.warn((Object)("AREANeedSync() FAIL: for plugin " + pluginEnvelope.getPluginName()), throwable);
                }
            }
            propInfoArray[0] = new PropInfo(8, new Value(bl ? 1 : 0));
            arEsRequest4Out.setProps(ValueObjectFactory.setPropList(propInfoArray));
        }
        catch (ARException aRException) {
            LOGGER.error((Object)"AREANeedSync() FAIL: ", (Throwable)aRException);
            arEsRequest4Out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(aRException.getLastStatus()));
        }
        catch (Throwable throwable) {
            LOGGER.warn((Object)"AREANeedSync() FAIL: ", throwable);
            ArStatusList6 arStatusList6 = new ArStatusList6();
            arStatusList6.value = new ArStatusStruct6[1];
            arStatusList6.value[0] = new ArStatusStruct6(2, 8790, CatalogReader.getInstance().getMessage(8790), throwable.getLocalizedMessage());
            arEsRequest4Out.setStatus(arStatusList6);
        }
        return arEsRequest4Out;
    }

    public ArEsRequest4Out AREAVerifyLogin(ArEsRequest4In arEsRequest4In) {
        ArEsRequest4Out arEsRequest4Out = new ArEsRequest4Out();
        arEsRequest4Out.setControl(arEsRequest4In.getControl());
        arEsRequest4Out.setStatus(new ArStatusList6());
        try {
            Object object;
            Object object2;
            this.validateClient(arEsRequest4In.getControl().getPassword());
            ArPropList arPropList = arEsRequest4In.getProps();
            PropInfo[] propInfoArray = ValueObjectFactory.getPropList(arPropList);
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            block14: for (int i = 0; i < propInfoArray.length; ++i) {
                switch (propInfoArray[i].getPropertyTag()) {
                    case 1: {
                        string = (String)propInfoArray[i].getPropertyValue().getValue();
                        continue block14;
                    }
                    case 2: {
                        string2 = (String)propInfoArray[i].getPropertyValue().getValue();
                        object2 = new PasswordEncryption(0, false);
                        try {
                            object = object2.decryptPasswordEx(string2.getBytes());
                            string2 = new String((byte[])object);
                            continue block14;
                        }
                        catch (AREncryptionException aREncryptionException) {
                            throw new ARException(0, 0, "Decryption Failed");
                        }
                    }
                    case 10: {
                        string3 = (String)propInfoArray[i].getPropertyValue().getValue();
                        continue block14;
                    }
                    case 14: {
                        string4 = (String)propInfoArray[i].getPropertyValue().getValue();
                        continue block14;
                    }
                }
            }
            Iterator<PluginEnvelope> iterator = this.mPlugins.iterator();
            object2 = null;
            object = null;
            PluginEnvelope pluginEnvelope = null;
            while (iterator.hasNext()) {
                try {
                    pluginEnvelope = iterator.next();
                    object = (AREAPluggable)pluginEnvelope.mPlugin;
                    object2 = object.areaVerifyLogin(ApiToRpcMapping.getInstance().getContextFromControl(arEsRequest4In.getControl(), pluginEnvelope.mPluginInfo), string, string2, string3, string4);
                    if (((AREAResponse)object2).getLoginStatus() != 0 && ((AREAResponse)object2).getLoginStatus() != 3) continue;
                    break;
                }
                catch (ARException aRException) {
                    LOGGER.warn((Object)("AREAVerifyLogin() FAIL for plugin " + pluginEnvelope.getPluginName()), (Throwable)aRException);
                }
                catch (Throwable throwable) {
                    LOGGER.warn((Object)("AREAVerifyLogin() FAIL for plugin " + pluginEnvelope.getPluginName()), throwable);
                }
            }
            PropInfo[] propInfoArray2 = null;
            boolean bl = false;
            if (pluginEnvelope != null) {
                bl = pluginEnvelope.isTrustedAreaPlugin();
            }
            propInfoArray2 = this.responseToPropList((AREAResponse)object2, bl);
            arEsRequest4Out.setProps(ValueObjectFactory.setPropList(propInfoArray2));
        }
        catch (ARException aRException) {
            LOGGER.error((Object)"AREAVerifyLogin() FAIL: ", (Throwable)aRException);
            arEsRequest4Out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(aRException.getLastStatus()));
        }
        catch (Throwable throwable) {
            LOGGER.error((Object)"AREAVerifyLogin() FAIL: ", throwable);
            ArStatusList6 arStatusList6 = new ArStatusList6();
            arStatusList6.value = new ArStatusStruct6[1];
            arStatusList6.value[0] = new ArStatusStruct6(2, 8790, CatalogReader.getInstance().getMessage(8790), throwable.getLocalizedMessage());
            arEsRequest4Out.setStatus(arStatusList6);
        }
        return arEsRequest4Out;
    }

    private PropInfo[] responseToPropList(AREAResponse aREAResponse, boolean bl) {
        PropInfo[] propInfoArray = null;
        int n = 0;
        if (aREAResponse == null) {
            propInfoArray = new PropInfo[1];
            Value value = new Value(1);
            propInfoArray[0] = new PropInfo(8, value);
            return propInfoArray;
        }
        propInfoArray = new PropInfo[16];
        Value value = new Value(aREAResponse.getLoginStatus());
        propInfoArray[n] = new PropInfo(8, value);
        ++n;
        if (aREAResponse.getLoginStatus() == 0) {
            if ((aREAResponse.getLicenseMask() & 1) > 0) {
                value = new Value(aREAResponse.getLicenseWrite());
                propInfoArray[n] = new PropInfo(3, value);
                ++n;
            }
            if ((aREAResponse.getLicenseMask() & 2) > 0) {
                value = new Value(aREAResponse.getLicenseFTS());
                propInfoArray[n] = new PropInfo(4, value);
                ++n;
            }
            if ((aREAResponse.getLicenseMask() & 4) > 0) {
                value = new Value(aREAResponse.getLicenseRes1());
                propInfoArray[n] = new PropInfo(5, value);
                ++n;
            }
            if ((aREAResponse.getLicenseMask() & 8) > 0 && aREAResponse.getLicenseApps() != null) {
                value = new Value(aREAResponse.getLicenseApps());
                propInfoArray[n] = new PropInfo(15, value);
                ++n;
            }
            if (aREAResponse.getGroups() != null) {
                value = new Value(aREAResponse.getGroups());
                propInfoArray[n] = new PropInfo(6, value);
                ++n;
            }
            if (aREAResponse.getNotifyMech() <= 3) {
                value = new Value(aREAResponse.getNotifyMech());
                propInfoArray[n] = new PropInfo(11, value);
                ++n;
            }
            if (aREAResponse.getEmail() != null) {
                value = new Value(aREAResponse.getEmail());
                propInfoArray[n] = new PropInfo(7, value);
                ++n;
            }
            if (aREAResponse.getModTime() != null) {
                value = new Value(aREAResponse.getModTime());
                propInfoArray[n] = new PropInfo(13, value);
                ++n;
            }
            if (bl) {
                value = new Value(1);
                propInfoArray[n] = new PropInfo(16, value);
                ++n;
            }
        }
        if (aREAResponse.getMessageText() != null) {
            value = new Value(aREAResponse.getMessageText());
            propInfoArray[n] = new PropInfo(9, value);
            ++n;
        }
        if (aREAResponse.getLogText() != null) {
            value = new Value(aREAResponse.getLogText());
            propInfoArray[n] = new PropInfo(12, value);
            ++n;
        }
        if (n == 0) {
            propInfoArray = null;
        }
        return propInfoArray;
    }

    @Override
    public List<StatusInfo> onEvent(ARPluginContext aRPluginContext, int n) {
        ArrayList<StatusInfo> arrayList = new ArrayList<StatusInfo>();
        for (PluginEnvelope pluginEnvelope : this.mPlugins) {
            try {
                aRPluginContext.setPluginInfo(pluginEnvelope.mPluginInfo);
                pluginEnvelope.mPlugin.onEvent(aRPluginContext, n);
            }
            catch (ARException aRException) {
                arrayList.addAll(aRException.getLastStatus());
            }
        }
        return arrayList;
    }

    @Override
    void terminatePlugins(ARPluginContext aRPluginContext) {
        for (PluginEnvelope pluginEnvelope : this.mPlugins) {
            try {
                aRPluginContext.setPluginInfo(pluginEnvelope.mPluginInfo);
                pluginEnvelope.mPlugin.terminate(aRPluginContext);
            }
            catch (ARException aRException) {
                LOGGER.warn((Object)(CatalogReader.getInstance().getMessage(8794) + pluginEnvelope.getPluginName() + " for thread Id: " + Thread.currentThread().getId()), (Throwable)aRException);
            }
        }
    }
}

