/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ActiveLinkAction;
import com.bmc.arsys.api.AssignInfo;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.FieldAssignInfo;
import com.bmc.arsys.api.FilterAction;
import com.bmc.arsys.api.SetFieldsAction;
import com.bmc.arsys.api.Value;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetFieldsFromFilterAPI
extends SetFieldsAction
implements ActiveLinkAction,
FilterAction,
Cloneable,
Serializable {
    private static final long serialVersionUID = -3900257526767435755L;
    private String serviceName;
    private List<AssignInfo> inputAssignList;
    private int noMatchOption;
    private int multiMatchOption;

    public SetFieldsFromFilterAPI() {
        this(null, null, new ArrayList<FieldAssignInfo>());
    }

    public SetFieldsFromFilterAPI(String string, String string2, List<FieldAssignInfo> list) {
        super(list);
        super.setFromServer(string);
        super.setReadValuesFrom(string2);
    }

    public int getMultiMatchOption() {
        return this.multiMatchOption;
    }

    public void setMultiMatchOption(int n2) {
        this.multiMatchOption = n2;
    }

    public int getNoMatchOption() {
        return this.noMatchOption;
    }

    public void setNoMatchOption(int n2) {
        this.noMatchOption = n2;
    }

    public List<AssignInfo> getInputAssignList() {
        return this.inputAssignList;
    }

    public void setInputAssignList(List<AssignInfo> list) {
        this.inputAssignList = list;
    }

    public void addInputAssignment(int n2, AssignInfo assignInfo) {
        List<AssignInfo> list = this.getInputAssignList();
        if (list == null) {
            this.setInputAssignList(new ArrayList<AssignInfo>());
            list = this.getInputAssignList();
        }
        list.add(assignInfo);
    }

    public void addInputAssignment(AssignInfo assignInfo) {
        this.addInputAssignment(this.getInputAssignList().size(), assignInfo);
    }

    private AssignInfo a(Object object) {
        AssignInfo assignInfo = new AssignInfo();
        assignInfo.setAssignType(1);
        if (object instanceof Integer) {
            assignInfo.setValue(new Value((Integer)object));
        } else if (object instanceof Double) {
            assignInfo.setValue(new Value((Double)object));
        } else if (object instanceof String) {
            assignInfo.setValue(new Value((String)object));
        }
        return assignInfo;
    }

    public void addInputAssignment(int n2, int n3) {
        this.addInputAssignment(n2, this.a(n3));
    }

    public void addInputAssignment(int n2) {
        this.addInputAssignment(this.getInputAssignList().size(), n2);
    }

    public void addInputAssignment(int n2, double d2) {
        this.addInputAssignment(n2, this.a(d2));
    }

    public void addInputAssignment(double d2) {
        this.addInputAssignment(this.getInputAssignList().size(), d2);
    }

    public void addInputAssignment(int n2, String string) {
        this.addInputAssignment(n2, this.a(string));
    }

    public void addInputAssignment(String string) {
        this.addInputAssignment(this.getInputAssignList().size(), string);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    static List<AssignInfo> buildInputAssignList(List<AssignInfo> list, ARServerUser aRServerUser) throws ARException {
        if (list == null || list.size() <= 0 || !Config.getInstance().isStringizeFieldAssignments()) {
            return list;
        }
        String string = aRServerUser.getSession().getCurrentLocalForm();
        int n2 = 8;
        String string2 = aRServerUser.getSession().getCurrentLocalForm();
        for (AssignInfo assignInfo : list) {
            assignInfo.prepareAssignmentString(aRServerUser, string, n2, string2);
        }
        return list;
    }

    @Override
    void fromVariant(Object[] objectArray, ARServerUser aRServerUser) {
        if (objectArray == null) {
            return;
        }
        super.fromVariant(objectArray, aRServerUser);
    }

    void fixFieldAssignments(ARServerUser aRServerUser) {
        SetFieldsFromFilterAPI.fixARAssignFieldStruct(this.getSetFieldsList(), "", "", null, "", this.getServiceName(), 3, 6, aRServerUser);
    }

    @Override
    Object toVariant(ARServerUser aRServerUser) {
        Object[] objectArray = (Object[])super.toVariant(aRServerUser);
        return objectArray;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SetFieldsFromFilterAPI setFieldsFromFilterAPI = (SetFieldsFromFilterAPI)super.clone();
        if (this.inputAssignList != null) {
            int n2 = this.inputAssignList.size();
            setFieldsFromFilterAPI.inputAssignList = new ArrayList<AssignInfo>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                setFieldsFromFilterAPI.inputAssignList.add((AssignInfo)this.inputAssignList.get(i2).clone());
            }
        }
        return setFieldsFromFilterAPI;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SetFieldsFromFilterAPI)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        SetFieldsFromFilterAPI setFieldsFromFilterAPI = (SetFieldsFromFilterAPI)object;
        return new EqualsBuilder().appendSuper(super.equals(object)).append((Object)this.serviceName, (Object)setFieldsFromFilterAPI.serviceName).append(this.inputAssignList, setFieldsFromFilterAPI.inputAssignList).append(this.noMatchOption, setFieldsFromFilterAPI.noMatchOption).append(this.multiMatchOption, setFieldsFromFilterAPI.multiMatchOption).isEquals();
    }
}

