/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrEncodingStream;

public class XdrUdpEncodingStream
extends XdrEncodingStream {
    private DatagramSocket socket;
    private InetAddress receiverAddress = null;
    private int receiverPort = 0;
    private byte[] buffer;
    private int bufferIndex;
    private int bufferHighmark;
    private static final byte[] paddingZeros = new byte[]{0, 0, 0, 0};

    public XdrUdpEncodingStream(DatagramSocket datagramSocket, int n) {
        this.socket = datagramSocket;
        if (n < 1024) {
            n = 1024;
        }
        if ((n & 3) != 0) {
            n = n + 4 & 0xFFFFFFFC;
        }
        this.buffer = new byte[n];
        this.bufferIndex = 0;
        this.bufferHighmark = n - 4;
    }

    public void beginEncoding(InetAddress inetAddress, int n) throws OncRpcException, IOException {
        this.receiverAddress = inetAddress;
        this.receiverPort = n;
        this.bufferIndex = 0;
    }

    public void endEncoding() throws OncRpcException, IOException {
        DatagramPacket datagramPacket = new DatagramPacket(this.buffer, this.bufferIndex, this.receiverAddress, this.receiverPort);
        this.socket.send(datagramPacket);
    }

    public void close() throws OncRpcException, IOException {
        this.buffer = null;
        this.socket = null;
    }

    public void xdrEncodeInt(int n) throws OncRpcException, IOException {
        if (this.bufferIndex > this.bufferHighmark) {
            throw new OncRpcException(42);
        }
        this.buffer[this.bufferIndex++] = (byte)(n >>> 24);
        this.buffer[this.bufferIndex++] = (byte)(n >>> 16);
        this.buffer[this.bufferIndex++] = (byte)(n >>> 8);
        this.buffer[this.bufferIndex++] = (byte)n;
    }

    public void xdrEncodeOpaque(byte[] byArray, int n, int n2) throws OncRpcException, IOException {
        int n3 = 4 - (n2 & 3) & 3;
        if (this.bufferIndex <= this.bufferHighmark - (n2 + n3)) {
            System.arraycopy(byArray, n, this.buffer, this.bufferIndex, n2);
            this.bufferIndex += n2;
            if (n3 != 0) {
                System.arraycopy(paddingZeros, 0, this.buffer, this.bufferIndex, n3);
                this.bufferIndex += n3;
            }
        } else {
            throw new OncRpcException(42);
        }
    }
}

