/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.SocketException;

public class OncRpcUdpSocketHelper {
    private DatagramSocket socket;
    private Method methodSetSendBufferSize;
    private Method methodSetReceiveBufferSize;
    private Method methodGetSendBufferSize;
    private Method methodGetReceiveBufferSize;

    public OncRpcUdpSocketHelper(DatagramSocket datagramSocket) {
        this.socket = datagramSocket;
        this.queryMethods();
    }

    public void setSendBufferSize(int n) throws SocketException {
        if (this.methodSetSendBufferSize != null) {
            try {
                this.methodSetSendBufferSize.invoke((Object)this.socket, new Integer(n));
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SocketException) {
                    throw (SocketException)throwable;
                }
                if (throwable instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)throwable;
                }
                throw new SocketException(throwable.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SocketException(illegalAccessException.getMessage());
            }
        }
    }

    public int getSendBufferSize() throws SocketException {
        if (this.methodGetSendBufferSize != null) {
            try {
                Object object = this.methodGetSendBufferSize.invoke((Object)this.socket, (Object[])null);
                if (object instanceof Integer) {
                    return (Integer)object;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SocketException) {
                    throw (SocketException)throwable;
                }
                throw new SocketException(throwable.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SocketException(illegalAccessException.getMessage());
            }
        }
        return 65536;
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        if (this.methodSetReceiveBufferSize != null) {
            try {
                this.methodSetReceiveBufferSize.invoke((Object)this.socket, new Integer(n));
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SocketException) {
                    throw (SocketException)throwable;
                }
                if (throwable instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)throwable;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SocketException(illegalAccessException.getMessage());
            }
        }
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.methodGetReceiveBufferSize != null) {
            try {
                Object object = this.methodGetReceiveBufferSize.invoke((Object)this.socket, (Object[])null);
                if (object instanceof Integer) {
                    return (Integer)object;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SocketException) {
                    throw (SocketException)throwable;
                }
                throw new SocketException(throwable.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SocketException(illegalAccessException.getMessage());
            }
        }
        return 65536;
    }

    protected void queryMethods() {
        Class<DatagramSocket> clazz = DatagramSocket.class;
        try {
            this.methodSetSendBufferSize = clazz.getMethod("setSendBufferSize", Integer.TYPE);
            this.methodGetSendBufferSize = clazz.getMethod("getSendBufferSize", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.methodSetReceiveBufferSize = clazz.getMethod("setReceiveBufferSize", Integer.TYPE);
            this.methodGetReceiveBufferSize = clazz.getMethod("getReceiveBufferSize", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

