/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.javadriver;

import com.bmc.arsys.api.ObjectPrinter;
import com.bmc.arsys.demo.javadriver.JavaDriver;
import com.bmc.arsys.demo.javadriver.ThreadControlBlock;
import java.io.PrintWriter;

public class OutputWriter
extends ObjectPrinter {
    public void printResult(String string) {
        if ((JavaDriver.quietMode & JavaDriver.SUPPRESS_RESULTS) == 0) {
            ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
            PrintWriter printWriter = threadControlBlock.getOutFile();
            printWriter.print(string);
            printWriter.flush();
        }
    }

    public void driverPrintHeader(String string) {
        ThreadControlBlock threadControlBlock;
        if ((JavaDriver.quietMode & JavaDriver.SUPPRESS_HEADERS) == 0 && (threadControlBlock = JavaDriver.getThreadControlBlockPtr()).getPrimaryThread()) {
            System.out.println(string);
        }
    }

    public void driverPrintPrompt(String string) {
        ThreadControlBlock threadControlBlock;
        if ((JavaDriver.quietMode & JavaDriver.SUPPRESS_PROMPTS) == 0 && (threadControlBlock = JavaDriver.getThreadControlBlockPtr()).getPrimaryThread()) {
            System.out.print(string);
        }
    }

    public void driverPrintNotSupportCommand(int n) {
        ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
        String string = threadControlBlock.getBuffer();
        String string2 = threadControlBlock.args;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" **** No support for this command: ").append(n).append(", with args: ").append(string2).append(", in line: ").append(string);
        if (threadControlBlock.getCurrentInputFileName() != null) {
            stringBuilder.append(", from: ").append(threadControlBlock.getCurrentInputFileName());
        }
        stringBuilder.append(", in driver \n");
        this.driverPrintError(stringBuilder.toString());
    }

    public void driverPrintMenu(String string) {
        if ((JavaDriver.quietMode & JavaDriver.SUPPRESS_MENU) == 0) {
            System.out.print(string);
        }
    }

    public void driverPrintError(String string) {
        if ((JavaDriver.quietMode & JavaDriver.SUPPRESS_RESULTS) == 0) {
            ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
            PrintWriter printWriter = threadControlBlock.getOutFile();
            printWriter.print(string);
            printWriter.flush();
        }
    }

    public void driverPrintException(Exception exception) {
        if ((JavaDriver.quietMode & JavaDriver.SUPPRESS_RESULTS) == 0) {
            exception.printStackTrace();
        }
    }

    public void driverPrintWarning(String string) {
        if ((JavaDriver.quietMode & JavaDriver.SUPPRESS_WARNINGS) == 0) {
            ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
            PrintWriter printWriter = threadControlBlock.getOutFile();
            printWriter.print(string);
            printWriter.flush();
        }
    }

    public void closeOutputFile() {
        ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
        if (threadControlBlock.getIsStdOut()) {
            this.driverPrintWarning(" **** Output to stdout; cannot close stdout file\n");
        } else {
            threadControlBlock.setOutputToStdOut();
        }
    }

    public void openOutputFile(String string) {
        if (string == null || string.length() == 0) {
            this.driverPrintWarning(" **** No filename specified so no change to output file\n");
        } else {
            if ((JavaDriver.getQuietMode() & JavaDriver.SUPPRESS_RESULTS) != 0) {
                return;
            }
            String string2 = null;
            String string3 = JavaDriver.getResultDirectory();
            string2 = string3 != null && string3.length() > 0 ? string3 + "\\" + string : string;
            try {
                ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
                threadControlBlock.setOutputFile(string2);
            }
            catch (Exception exception) {
                this.driverPrintWarning(" **** File error during open; no change to output file\n");
            }
        }
    }

    public void driverPrintHelp() {
        System.out.print("         AR System Java API Driver\n");
        System.out.println();
        System.out.print("Container      Form           Char Menu       Form Field       <mult>\n");
        System.out.print("------------   -----------    -----------     -------------    ------\n");
        System.out.print("get    (gco)   get    (gs)    get    (gc)     get    (gsf)\n");
        System.out.print("set    (sco)   set    (ss)    set    (sc)     set    (ssf)\n");
        System.out.print("create (cco)   create (cs)    create (cc)     create (csf)\n");
        System.out.print("delete (dco)   delete (ds)    delete (dc)     delete (dsf)     (dmsf)\n");
        System.out.print("getlist(glco)  getlist(gls)   getlist(glc)    getlist(glsf)\n");
        System.out.print("getmult(gmco)  getmult(gms)   getmult(gmc)    getmult(gmsf)\n");
        System.out.print("                              expand (ec)\n");
        System.out.println();
        System.out.print("Active Link    Filter         Escalation      Entry          Entry\n");
        System.out.print("------------   -----------    -----------     -----------    ------\n");
        System.out.print("get    (gal)   get    (gf)    get    (ges)    get    (ge)    merge (me)\n");
        System.out.print("set    (sal)   set    (sf)    set    (ses)    set    (se)    stats (stat)\n");
        System.out.print("create (cal)   create (cf)    create (ces)    create (ce)    getlistw/f(glewf)\n");
        System.out.print("delete (dal)   delete (df)    delete (des)    delete (de) \n");
        System.out.print("getlist(glal)  getlist(glf)   getlist(gles)   getlist(gle) \n");
        System.out.print("getmult(gmal)  getmult(gmf)   getmult(gmes)   getmult(gme) \n");
        System.out.println();
        System.out.print("VUI            Misc Lists     Alerts            Encode/Decode  \n");
        System.out.print("-----------    -----------    ---------------   ---------------\n");
        System.out.print("get    (gv)    server(svr)    Create     (ce)   enquery (ecqal) \n");
        System.out.print("set    (sv)    group (glg)    Register   (rfa)  dequery (dcqal) \n");
        System.out.print("create (cv)    user  (glu)    Deregister (dfa)  enassig (ecasn) \n");
        System.out.print("delete (dv)    sql   (glsql)  gla user   (glau) deassig (deasn) \n");
        System.out.print("                              get Count  (gac)  echstry (echst) \n");
        System.out.print("                                                ecdiary (ecdia) \n");
        System.out.print("                                                enc date(ecdat) \n");
        System.out.print("                                                dec date(dcdat) \n");
        System.out.println();
        System.out.print("Init/Term         Control/Logging       Info           Misc              Misc\n");
        System.out.print("---------------   ---------------       ------------   -------------     ----------------\n");
        System.out.print("login  (log)      record    (rec)       get svr (gsi)  ver user (ver)    get errmsg (gem)  \n");
        System.out.print("exit   (q)        stop rec  (srec)      set svr (ssi)  export   (exp)    set logging(slog)  \n");
        System.out.print("help   (h, ?)     open out  (oout)      get FT  (gft)  import   (imp)  \n");
        System.out.print("begtran(bbet)     close out (cout)      set FT  (sft)  exec proc(proc)  \n");
        System.out.print("endtran(ebet)     rcrd pmpt (recPrompt) get stat(gss)  load qual(lqs)   \n");
        System.out.print("charset(g[sc]cs)  stp recpmt(srecPrompt)               set port (ssp)  \n");
        System.out.print("                                                       impusr   (imusr)   \n");
        System.out.println();
        System.out.print("Localized Value    Support File     Session Config\n");
        System.out.print("---------------    --------------   --------------------------\n");
        System.out.print("get       (glv)    create   (cfl)   get conf(gsc)\n");
        System.out.print("getmult   (gmlv)   delete   (dfl)   set conf(ssc)\n");
        System.out.print("                   get      (gfl)   use connection pooling(ucp)\n");
        System.out.print("                   set      (sfl)   set connection limits(scl)\n");
        System.out.print("                   get list (glfl) \n");
        System.out.println();
        System.out.print(" Complex Entry   Localized Val  App States      Currency Ratio\n");
        System.out.print(" -------------   -------------  ------------    --------------\n");
        System.out.print(" create (xmlce)  get    (glv)   get     (gas)   getmult sets(gmcrs)\n");
        System.out.print(" get    (xmlge)  getmult(gmlv)  set     (sas)   get ratio   (gcr)\n");
        System.out.print(" set    (xmlse)                 getlist (glas)\n");
        System.out.print(" service(sve)\n");
        System.out.print(" xml svc(xmlsve)\n");
        System.out.println();
    }
}

