/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.CriteriaFlags;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.IARPersistentObject;
import com.bmc.arsys.api.ObjectBaseCriteria;
import com.bmc.arsys.api.PermissionInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.internal.ARStructMemTypeInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectBase
implements IARPersistentObject,
Cloneable {
    private static Logger a = Logger.getLogger(ObjectBase.class);
    @ARStructMemTypeInfo(Name="name", Offset=0)
    private String m_name;
    private String m_newName;
    @ARStructMemTypeInfo(Name="permissionList", Offset=1)
    protected List<PermissionInfo> m_permissionList;
    @ARStructMemTypeInfo(Name="helpText", Offset=2)
    private String m_helpText;
    @ARStructMemTypeInfo(Name="lastUpdateTime", Offset=3)
    private Timestamp m_lastUpdateTime;
    @ARStructMemTypeInfo(Name="owner", Offset=4)
    private String m_owner;
    @ARStructMemTypeInfo(Name="lastChangedBy", Offset=5)
    private String m_lastChangedBy;
    @ARStructMemTypeInfo(Name="diaryStr", Offset=6)
    private DiaryListValue m_diaryList;
    protected ObjectBaseCriteria m_changeFlags;
    protected Integer[] hashValues = null;

    protected ObjectBase() {
        this.m_name = "";
        this.m_newName = "";
        this.m_permissionList = new ArrayList<PermissionInfo>();
        this.m_helpText = "";
        this.m_lastUpdateTime = new Timestamp();
        this.m_owner = "";
        this.m_lastChangedBy = "";
        this.m_diaryList = new DiaryListValue();
    }

    protected ObjectBase(String string, List<PermissionInfo> list, String string2, long l2, String string3, String string4, String string5) {
        this.m_name = string;
        this.m_permissionList = list;
        this.m_helpText = string2;
        this.m_lastUpdateTime = new Timestamp(l2);
        this.m_owner = string3;
        this.m_lastChangedBy = string4;
        this.setDiary(string5);
    }

    public void clear() {
        this.m_name = null;
        this.m_newName = null;
        this.m_permissionList = null;
        this.m_helpText = null;
        this.m_lastUpdateTime = null;
        this.m_owner = null;
        this.m_lastChangedBy = null;
        this.m_diaryList = null;
    }

    public Object clone() throws CloneNotSupportedException {
        ObjectBase objectBase = (ObjectBase)super.clone();
        if (this.m_permissionList != null) {
            objectBase.m_permissionList = new ArrayList<PermissionInfo>(this.m_permissionList.size());
            for (int i2 = 0; i2 < this.m_permissionList.size(); ++i2) {
                objectBase.m_permissionList.add((PermissionInfo)this.m_permissionList.get(i2).clone());
            }
        }
        if (this.m_lastUpdateTime != null) {
            objectBase.m_lastUpdateTime = (Timestamp)this.m_lastUpdateTime.clone();
        }
        if (this.m_diaryList != null) {
            objectBase.m_diaryList = (DiaryListValue)this.m_diaryList.clone();
        }
        if (this.m_changeFlags != null) {
            objectBase.m_changeFlags = (ObjectBaseCriteria)this.m_changeFlags.clone();
        }
        return objectBase;
    }

    @Override
    public void setName(String string) {
        this.m_name = string;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getNewName() {
        return this.m_newName;
    }

    @Override
    public void setNewName(String string) {
        this.m_newName = string;
        if (this.m_name != null && this.m_name.length() == 0) {
            this.m_name = string;
        }
        this.m_changeFlags.setParameter(0L, true);
    }

    @Override
    public List<PermissionInfo> getPermissions() {
        return this.m_permissionList;
    }

    @Override
    public void setPermissions(List<PermissionInfo> list) {
        this.m_permissionList = list;
        this.m_changeFlags.setParameter(1L, true);
    }

    @Override
    public String getHelpText() {
        return this.m_helpText;
    }

    @Override
    public void setHelpText(String string) {
        this.m_helpText = string;
        this.m_changeFlags.setParameter(2L, true);
    }

    @Override
    public Timestamp getLastUpdateTime() {
        return this.m_lastUpdateTime;
    }

    protected void setLastUpdateTime(Timestamp timestamp) {
        this.m_lastUpdateTime = timestamp;
    }

    protected void setLastUpdateTime(long l2) {
        this.m_lastUpdateTime = new Timestamp(l2);
    }

    @Override
    public String getOwner() {
        return this.m_owner;
    }

    @Override
    public void setOwner(String string) {
        this.m_owner = string;
        this.m_changeFlags.setParameter(3L, true);
    }

    @Override
    public String getLastChangedBy() {
        return this.m_lastChangedBy;
    }

    @Override
    public void setLastChangedBy(String string) {
        this.m_lastChangedBy = string;
    }

    @Override
    public DiaryListValue getDiary() {
        return this.m_diaryList;
    }

    @Override
    public void setDiary(DiaryListValue diaryListValue) {
        this.m_diaryList = diaryListValue;
        this.m_changeFlags.setParameter(4L, true);
    }

    public void setDiary(String string) {
        try {
            this.setDiary(DiaryListValue.decode(string));
        }
        catch (ARException aRException) {
            a.error((Object)("Error in setDiary, String=" + string), (Throwable)aRException);
        }
        this.m_changeFlags.setParameter(4L, true);
    }

    @Override
    public void appendDiaryText(String string) {
        this.m_diaryList.setAppendedText(string);
        this.m_changeFlags.setParameter(4L, true);
    }

    protected void resetChangeFlags() {
        this.m_changeFlags.setRetrieveAll(false);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ObjectBase)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ObjectBase objectBase = (ObjectBase)object;
        return new EqualsBuilder().append((Object)this.m_name, (Object)objectBase.m_name).append((Object)this.m_newName, (Object)objectBase.m_newName).append(this.m_permissionList, objectBase.m_permissionList).append((Object)this.m_helpText, (Object)objectBase.m_helpText).append((Object)this.m_lastUpdateTime, (Object)objectBase.m_lastUpdateTime).append((Object)this.m_owner, (Object)objectBase.m_owner).append((Object)this.m_lastChangedBy, (Object)objectBase.m_lastChangedBy).append((Object)this.m_diaryList, (Object)objectBase.m_diaryList).append((Object)this.m_changeFlags, (Object)objectBase.m_changeFlags).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.m_name).append((Object)this.m_newName).append(this.m_permissionList).append((Object)this.m_helpText).append((Object)this.m_lastUpdateTime).append((Object)this.m_owner).append((Object)this.m_lastChangedBy).append((Object)this.m_diaryList).append((Object)this.m_changeFlags).toHashCode();
    }

    protected CriteriaFlags getChangeFlags() {
        return this.m_changeFlags;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, Config.getInstance().getToStringStyle()).append("Name", (Object)this.m_name).append("New Name", (Object)this.m_newName).append("Permission List", this.m_permissionList).append("Help Text", (Object)this.m_helpText).append("Last Update Time", (Object)this.m_lastUpdateTime).append("Owner", (Object)this.m_owner).append("Last Changed By", (Object)this.m_lastChangedBy).append("Diary List", (Object)this.m_diaryList).append("Change Flags", (Object)this.m_changeFlags).toString();
    }

    void calculateHashCodeOnGet() {
        if (this.hashValues == null) {
            throw new IllegalArgumentException("hashValues has not been initialized");
        }
        this.hashValues[1] = this.m_permissionList != null ? Integer.valueOf(((Object)this.m_permissionList).hashCode()) : null;
        this.hashValues[4] = this.m_diaryList != null ? Integer.valueOf(this.m_diaryList.hashCode()) : null;
        this.hashValues[2] = this.m_helpText != null ? Integer.valueOf(this.m_helpText.hashCode()) : null;
        this.hashValues[3] = this.m_owner != null ? Integer.valueOf(this.m_owner.hashCode()) : null;
    }

    void calculateChangeFlagsOnSet() {
        int n2;
        if (this.hashValues == null) {
            throw new IllegalArgumentException("hashValues has not been initialized");
        }
        boolean[] blArray = this.m_changeFlags.getParameters();
        if (!blArray[1]) {
            if (this.m_permissionList != null) {
                n2 = ((Object)this.m_permissionList).hashCode();
                if (this.hashValues[1] == null || n2 != this.hashValues[1]) {
                    this.m_changeFlags.setParameter(1L, true);
                }
                this.hashValues[1] = this.m_permissionList != null ? Integer.valueOf(n2) : null;
            } else if (this.hashValues[1] != null) {
                this.m_changeFlags.setParameter(1L, true);
                this.hashValues[1] = null;
            }
        }
        if (!blArray[4]) {
            if (this.m_diaryList != null) {
                n2 = this.m_diaryList.hashCode();
                if (this.hashValues[4] == null || n2 != this.hashValues[4]) {
                    this.m_changeFlags.setParameter(4L, true);
                }
                this.hashValues[4] = this.m_diaryList != null ? Integer.valueOf(n2) : null;
            } else if (this.hashValues[4] != null) {
                this.m_changeFlags.setParameter(4L, true);
                this.hashValues[4] = null;
            }
        }
    }
}

