/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrDecodingStream;

public class XdrTcpDecodingStream
extends XdrDecodingStream {
    private Socket socket;
    InputStream stream;
    private byte[] buffer;
    private int bufferIndex;
    private int bufferHighmark;
    private int fragmentLength;
    private boolean lastFragment;

    public XdrTcpDecodingStream(Socket socket, int n) throws IOException {
        this.socket = socket;
        this.stream = this.socket.getInputStream();
        if (n < 1024) {
            n = 1024;
        }
        if ((n & 3) != 0) {
            n = n + 4 & 0xFFFFFFFC;
        }
        this.buffer = new byte[n];
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
        this.lastFragment = false;
        this.fragmentLength = 0;
    }

    public InetAddress getSenderAddress() {
        return this.socket.getInetAddress();
    }

    public int getSenderPort() {
        return this.socket.getPort();
    }

    public void beginDecoding() throws OncRpcException, IOException {
        this.fill();
    }

    private void readBuffer(InputStream inputStream, byte[] byArray, int n) throws IOException, OncRpcException {
        int n2 = 0;
        while (n > 0) {
            int n3 = inputStream.read(byArray, n2, n);
            if (n3 <= 0) {
                throw new OncRpcException(4);
            }
            n -= n3;
            n2 += n3;
        }
    }

    protected void fill() throws OncRpcException, IOException {
        if (this.fragmentLength <= 0) {
            if (this.lastFragment) {
                throw new OncRpcException(43);
            }
            byte[] byArray = new byte[4];
            this.readBuffer(this.stream, byArray, 4);
            this.fragmentLength = byArray[0] & 0xFF;
            this.fragmentLength = (this.fragmentLength << 8) + (byArray[1] & 0xFF);
            this.fragmentLength = (this.fragmentLength << 8) + (byArray[2] & 0xFF);
            this.fragmentLength = (this.fragmentLength << 8) + (byArray[3] & 0xFF);
            if ((this.fragmentLength & Integer.MIN_VALUE) != 0) {
                this.fragmentLength &= Integer.MAX_VALUE;
                this.lastFragment = true;
            } else {
                this.lastFragment = false;
            }
            if ((this.fragmentLength & 3) != 0) {
                throw new IOException("ONC/RPC XDR fragment length is not a multiple of four");
            }
            if (this.fragmentLength == 0 && !this.lastFragment) {
                throw new IOException("empty ONC/RPC XDR fragment which is not a trailing fragment");
            }
        }
        this.bufferIndex = 0;
        if (this.fragmentLength < this.buffer.length) {
            this.readBuffer(this.stream, this.buffer, this.fragmentLength);
            this.bufferHighmark = this.fragmentLength - 4;
            this.fragmentLength = 0;
        } else {
            this.readBuffer(this.stream, this.buffer, this.buffer.length);
            this.bufferHighmark = this.buffer.length - 4;
            this.fragmentLength -= this.buffer.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endDecoding() throws OncRpcException, IOException {
        try {
            while (!this.lastFragment || this.fragmentLength != 0) {
                this.fill();
            }
        }
        finally {
            this.bufferIndex = 0;
            this.bufferHighmark = -4;
            this.lastFragment = false;
            this.fragmentLength = 0;
        }
    }

    public void close() throws OncRpcException, IOException {
        this.buffer = null;
        this.stream = null;
        this.socket = null;
    }

    public int xdrDecodeInt() throws OncRpcException, IOException {
        while (this.bufferIndex > this.bufferHighmark) {
            this.fill();
        }
        int n = this.buffer[this.bufferIndex++] & 0xFF;
        n = (n << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
        n = (n << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
        n = (n << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
        return n;
    }

    public byte[] xdrDecodeOpaque(int n) throws OncRpcException, IOException {
        int n2 = 4 - (n & 3) & 3;
        int n3 = 0;
        byte[] byArray = new byte[n];
        while (this.bufferIndex > this.bufferHighmark) {
            this.fill();
        }
        while (n > 0) {
            int n4 = this.bufferHighmark - this.bufferIndex + 4;
            if (n4 >= n) {
                System.arraycopy(this.buffer, this.bufferIndex, byArray, n3, n);
                this.bufferIndex += n;
                break;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, n3, n4);
            this.bufferIndex += n4;
            n3 += n4;
            n -= n4;
            this.fill();
        }
        this.bufferIndex += n2;
        return byArray;
    }

    public void xdrDecodeOpaque(byte[] byArray, int n, int n2) throws OncRpcException, IOException {
        int n3 = 4 - (n2 & 3) & 3;
        if (this.bufferIndex > this.bufferHighmark) {
            this.fill();
        }
        while (n2 > 0) {
            int n4 = this.bufferHighmark - this.bufferIndex + 4;
            if (n4 >= n2) {
                System.arraycopy(this.buffer, this.bufferIndex, byArray, n, n2);
                this.bufferIndex += n2;
                break;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, n, n4);
            this.bufferIndex += n4;
            n += n4;
            n2 -= n4;
            this.fill();
        }
        this.bufferIndex += n3;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    protected void setBuffer(byte[] byArray) {
        this.buffer = byArray;
    }

    protected int getBufferIndex() {
        return this.bufferIndex;
    }

    protected void setBufferIndex(int n) {
        this.bufferIndex = n;
    }

    protected int getBufferHighmark() {
        return this.bufferHighmark;
    }

    protected void setBufferHighmark(int n) {
        this.bufferHighmark = n;
    }

    protected boolean isLastFragment() {
        return this.lastFragment;
    }
}

