/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.mapping;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ArithmeticOperationInfo;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AttachmentFieldLimit;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.ByteListValue;
import com.bmc.arsys.api.CharacterFieldLimit;
import com.bmc.arsys.api.ColumnFieldLimit;
import com.bmc.arsys.api.CoordinateInfo;
import com.bmc.arsys.api.CoreFieldId;
import com.bmc.arsys.api.CurrencyDetail;
import com.bmc.arsys.api.CurrencyFieldLimit;
import com.bmc.arsys.api.CurrencyPartInfo;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DateOnlyFieldLimit;
import com.bmc.arsys.api.DecimalFieldLimit;
import com.bmc.arsys.api.DiaryFieldLimit;
import com.bmc.arsys.api.DisplayFieldLimit;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryKey;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.EnumItem;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.FuncCurrencyInfo;
import com.bmc.arsys.api.IntegerFieldLimit;
import com.bmc.arsys.api.OperandType;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.QueryInfo;
import com.bmc.arsys.api.RealFieldLimit;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.SelectionFieldLimit;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.StatisticsResultInfo;
import com.bmc.arsys.api.StatusHistoryValueIndicator;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.TableFieldLimit;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.api.ViewFieldLimit;
import com.bmc.arsys.arcompress.ARCompressor;
import com.bmc.arsys.arrpc.ArAndOrStruct8;
import com.bmc.arsys.arrpc.ArArithOpStruct8;
import com.bmc.arsys.arrpc.ArAttachLimitsStruct12;
import com.bmc.arsys.arrpc.ArBoolean;
import com.bmc.arsys.arrpc.ArByteList;
import com.bmc.arsys.arrpc.ArCharLimitsStruct8;
import com.bmc.arsys.arrpc.ArColumnLimitsStruct8;
import com.bmc.arsys.arrpc.ArCompoundSchema12;
import com.bmc.arsys.arrpc.ArCompoundSchemaList12;
import com.bmc.arsys.arrpc.ArCoordList;
import com.bmc.arsys.arrpc.ArCoordStruct;
import com.bmc.arsys.arrpc.ArCurrencyCodeType;
import com.bmc.arsys.arrpc.ArCurrencyDetailList;
import com.bmc.arsys.arrpc.ArCurrencyDetailStruct;
import com.bmc.arsys.arrpc.ArCurrencyLimitsStruct;
import com.bmc.arsys.arrpc.ArCurrencyPartStruct;
import com.bmc.arsys.arrpc.ArCurrencyStruct;
import com.bmc.arsys.arrpc.ArDateLimitsStruct;
import com.bmc.arsys.arrpc.ArDecimalLimitsStruct6;
import com.bmc.arsys.arrpc.ArDiaryLimitsStruct;
import com.bmc.arsys.arrpc.ArDisplayLimits;
import com.bmc.arsys.arrpc.ArEntryIdList;
import com.bmc.arsys.arrpc.ArEntryIdType;
import com.bmc.arsys.arrpc.ArEntryListFieldList;
import com.bmc.arsys.arrpc.ArEntryListFieldValueList6;
import com.bmc.arsys.arrpc.ArEntryListFieldValueStruct6;
import com.bmc.arsys.arrpc.ArEnumItemList;
import com.bmc.arsys.arrpc.ArEnumItemStruct;
import com.bmc.arsys.arrpc.ArEnumLimitsStruct;
import com.bmc.arsys.arrpc.ArEnumQueryStruct;
import com.bmc.arsys.arrpc.ArEsArdbcCancelQuery4In;
import com.bmc.arsys.arrpc.ArEsArdbcCancelQuery4Out;
import com.bmc.arsys.arrpc.ArEsArdbcCommit4In;
import com.bmc.arsys.arrpc.ArEsArdbcCommit4Out;
import com.bmc.arsys.arrpc.ArEsArdbcCreate4In;
import com.bmc.arsys.arrpc.ArEsArdbcCreate4Out;
import com.bmc.arsys.arrpc.ArEsArdbcDelete4In;
import com.bmc.arsys.arrpc.ArEsArdbcDelete4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGet4In;
import com.bmc.arsys.arrpc.ArEsArdbcGet4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGetBlob4In;
import com.bmc.arsys.arrpc.ArEsArdbcGetBlob4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGetEntryStatistics4In;
import com.bmc.arsys.arrpc.ArEsArdbcGetEntryStatistics4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGetListForms4In;
import com.bmc.arsys.arrpc.ArEsArdbcGetListForms4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGetMultipleFields4In;
import com.bmc.arsys.arrpc.ArEsArdbcGetMultipleFields4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGlewf4In;
import com.bmc.arsys.arrpc.ArEsArdbcGlewf4Out;
import com.bmc.arsys.arrpc.ArEsArdbcRollback4In;
import com.bmc.arsys.arrpc.ArEsArdbcRollback4Out;
import com.bmc.arsys.arrpc.ArEsArdbcSet4In;
import com.bmc.arsys.arrpc.ArEsArdbcSet4Out;
import com.bmc.arsys.arrpc.ArEsControlStruct4;
import com.bmc.arsys.arrpc.ArEsVendorFieldList;
import com.bmc.arsys.arrpc.ArEsVendorFieldStruct;
import com.bmc.arsys.arrpc.ArFieldLimitStruct12;
import com.bmc.arsys.arrpc.ArFieldMappingStruct10;
import com.bmc.arsys.arrpc.ArFieldValueList;
import com.bmc.arsys.arrpc.ArFieldValueOrArithStruct8;
import com.bmc.arsys.arrpc.ArFieldValueStruct;
import com.bmc.arsys.arrpc.ArFuncCurrencyList;
import com.bmc.arsys.arrpc.ArFuncCurrencyStruct;
import com.bmc.arsys.arrpc.ArIntegerLimitsStruct;
import com.bmc.arsys.arrpc.ArInternalId;
import com.bmc.arsys.arrpc.ArInternalIdList;
import com.bmc.arsys.arrpc.ArNameList8;
import com.bmc.arsys.arrpc.ArNameType8;
import com.bmc.arsys.arrpc.ArPropStruct;
import com.bmc.arsys.arrpc.ArQualifierStruct8;
import com.bmc.arsys.arrpc.ArQueryValueStruct8;
import com.bmc.arsys.arrpc.ArRealLimitsStruct2;
import com.bmc.arsys.arrpc.ArRelOpStruct8;
import com.bmc.arsys.arrpc.ArServerNameType;
import com.bmc.arsys.arrpc.ArSortList;
import com.bmc.arsys.arrpc.ArStatHistoryValue;
import com.bmc.arsys.arrpc.ArStatisticsResultList;
import com.bmc.arsys.arrpc.ArStatisticsResultStruct;
import com.bmc.arsys.arrpc.ArStatusList6;
import com.bmc.arsys.arrpc.ArStatusStruct6;
import com.bmc.arsys.arrpc.ArTableLimitsStruct10;
import com.bmc.arsys.arrpc.ArTimestamp;
import com.bmc.arsys.arrpc.ArValueList;
import com.bmc.arsys.arrpc.ArValueStruct;
import com.bmc.arsys.arrpc.ArVendorMappingStruct8;
import com.bmc.arsys.arrpc.ArVendorSchema12;
import com.bmc.arsys.arrpc.ArViewLimits;
import com.bmc.arsys.pluginsvr.ARPluginServerConfiguration;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCancelIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCancelOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCommitIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCommitOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCreateIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCreateOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcDeleteIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcDeleteOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetBlobIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetBlobOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetEntryStatisticsIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetEntryStatisticsOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetListFormsIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetListFormsOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetMultipleFieldsIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetMultipleFieldsOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGlewfOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGlwefIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcRollbackIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcRollbackOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcSetIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcSetOut;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import com.bmc.arsys.pluginsvr.plugins.ValueObjectFactory;
import com.bmc.arsys.utils.CatalogReader;
import com.bmc.arsys.utils.StringByteUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiToRpcMapping {
    private static ApiToRpcMapping theInstance = new ApiToRpcMapping();
    private static Logger LOGGER = Logger.getLogger(ApiToRpcMapping.class);
    private ARCompressor compresser = new ARCompressor();

    public static ApiToRpcMapping getInstance() {
        return theInstance;
    }

    private ApiToRpcMapping() {
    }

    public String getEncodedString(byte[] byArray) {
        String string = null;
        try {
            string = StringByteUtil.createNullTerminatedString((byte[])byArray, (String)ARPluginServerConfiguration.getInstance().getServerCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.warn((Object)CatalogReader.getInstance().getMessage(8797), (Throwable)unsupportedEncodingException);
            string = new String(byArray).trim();
        }
        return string;
    }

    List<ARVendorField> getVendorFields(ArEsVendorFieldList arEsVendorFieldList) {
        ArrayList<ARVendorField> arrayList = new ArrayList<ARVendorField>();
        ArEsVendorFieldStruct[] arEsVendorFieldStructArray = arEsVendorFieldList.value;
        if (arEsVendorFieldStructArray != null) {
            for (int i = 0; i < arEsVendorFieldStructArray.length; ++i) {
                int n = arEsVendorFieldStructArray[i].getFieldId().value;
                String string = null;
                try {
                    string = StringByteUtil.createNullTerminatedString((byte[])arEsVendorFieldStructArray[i].getFieldName().value, (String)ARPluginServerConfiguration.getInstance().getServerCharset());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    LOGGER.warn((Object)CatalogReader.getInstance().getMessage(8797), (Throwable)unsupportedEncodingException);
                }
                int n2 = arEsVendorFieldStructArray[i].getDataType();
                ARVendorField aRVendorField = new ARVendorField(string, n, n2);
                arrayList.add(aRVendorField);
            }
        }
        return arrayList;
    }

    String getEntryIdListString(ArEntryIdList arEntryIdList) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (arEntryIdList.value != null) {
            for (int i = 0; i < arEntryIdList.value.length; ++i) {
                try {
                    stringBuffer.append(StringByteUtil.createNullTerminatedString((byte[])arEntryIdList.value[i].value, (String)ARPluginServerConfiguration.getInstance().getServerCharset()));
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    LOGGER.warn((Object)CatalogReader.getInstance().getMessage(8797), (Throwable)unsupportedEncodingException);
                }
            }
        }
        return stringBuffer.toString();
    }

    Entry getEntryFromInput(ArEntryIdList arEntryIdList, ArFieldValueList arFieldValueList, String string) throws ARException {
        String string2;
        Entry entry = this.getEntryItemsFromFieldValList(arFieldValueList);
        if (!entry.containsKey((Object)CoreFieldId.EntryId.getFieldId()) && (string2 = this.getEntryIdListString(arEntryIdList)) != null) {
            entry.put(Integer.valueOf(CoreFieldId.EntryId.getFieldId()), new Value(string2));
        }
        return entry;
    }

    Entry getEntryItemsFromFieldValList(ArFieldValueList arFieldValueList) throws ARException {
        Entry entry = new Entry();
        if (arFieldValueList.value != null) {
            for (int i = 0; i < arFieldValueList.value.length; ++i) {
                entry.put(Integer.valueOf(arFieldValueList.value[i].fieldId.value), ValueObjectFactory.getValueObject(arFieldValueList.value[i].value));
            }
        }
        return entry;
    }

    ArFieldValueList getFieldValListFromEntryItems(Entry entry) throws ARException {
        ArFieldValueList arFieldValueList = new ArFieldValueList();
        ArFieldValueStruct[] arFieldValueStructArray = new ArFieldValueStruct[entry.size()];
        int n = 0;
        for (Map.Entry entry2 : entry.entrySet()) {
            arFieldValueStructArray[n] = new ArFieldValueStruct();
            arFieldValueStructArray[n].fieldId = new ArInternalId(((Integer)entry2.getKey()).intValue());
            arFieldValueStructArray[n].value = this.getArValueFromValue((Value)entry2.getValue());
            ++n;
        }
        arFieldValueList.value = arFieldValueStructArray;
        return arFieldValueList;
    }

    ArValueList getArValueListFromValueList(Value[] valueArray) throws ARException {
        ArValueList arValueList = new ArValueList();
        if (valueArray != null) {
            arValueList.value = new ArValueStruct[valueArray.length];
            for (int i = 0; i < valueArray.length; ++i) {
                arValueList.value[i] = this.getArValueFromValue(valueArray[i]);
            }
        }
        return arValueList;
    }

    ArValueList getArValueListFromValueList(List<Value> list) throws ARException {
        ArValueList arValueList = new ArValueList();
        if (list != null) {
            arValueList.value = new ArValueStruct[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                arValueList.value[i] = this.getArValueFromValue(list.get(i));
            }
        }
        return arValueList;
    }

    ArValueStruct getArValueFromValue(Value value) throws ARException {
        ArValueStruct arValueStruct = ValueObjectFactory.setValueObject(value, null);
        return arValueStruct;
    }

    ArEntryIdList getEntryIdListFromKey(String string) throws ARException {
        String[] stringArray = Entry.splitEntryId((String)string);
        return this.toRpcArEntryIdList(stringArray);
    }

    EntryKey getEntryKeyFromEntryId(String string, ArEntryIdList arEntryIdList) {
        EntryKey entryKey = null;
        String string2 = this.getEntryIdListString(arEntryIdList);
        entryKey = new EntryKey(string, string2);
        return entryKey;
    }

    int[] getIntListFromInternalIds(ArInternalIdList arInternalIdList) {
        int[] nArray = null;
        if (arInternalIdList.value != null) {
            nArray = new int[arInternalIdList.value.length];
            for (int i = 0; i < arInternalIdList.value.length; ++i) {
                nArray[i] = arInternalIdList.value[i].value;
            }
        }
        return nArray;
    }

    public ArStatusList6 getRpcStatusFromStatusInfo(List<StatusInfo> list) {
        ArStatusList6 arStatusList6 = new ArStatusList6();
        if (list != null) {
            arStatusList6.value = new ArStatusStruct6[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                StatusInfo statusInfo = list.get(i);
                arStatusList6.value[i] = new ArStatusStruct6();
                arStatusList6.value[i].messageNum = (int)statusInfo.getMessageNum();
                arStatusList6.value[i].messageText = statusInfo.getMessageText();
                arStatusList6.value[i].messageType = statusInfo.getMessageType();
                arStatusList6.value[i].appendedText = statusInfo.getAppendedText();
                if (arStatusList6.value[i].messageText == null) {
                    arStatusList6.value[i].messageText = "";
                }
                if (arStatusList6.value[i].appendedText != null) continue;
                arStatusList6.value[i].appendedText = "";
            }
        }
        return arStatusList6;
    }

    ArFieldValueList getFieldValueListFromEntry(Entry entry) throws ARException {
        ArFieldValueList arFieldValueList = this.getFieldValListFromEntryItems(entry);
        return arFieldValueList;
    }

    Timestamp getTimestampFromArTimestamp(ArTimestamp arTimestamp) {
        Timestamp timestamp = new Timestamp((long)arTimestamp.value);
        return timestamp;
    }

    ArTimestamp getArTimestampFromTimestamp(Timestamp timestamp) {
        ArTimestamp arTimestamp = new ArTimestamp();
        arTimestamp.value = (int)timestamp.getValue();
        return arTimestamp;
    }

    boolean getBooleanFromArBoolean(ArBoolean arBoolean) {
        boolean bl = false;
        Boolean.getBoolean(arBoolean.toString());
        return bl;
    }

    protected ArEntryIdType toRpcArEntryIdType(String string) throws ARException {
        try {
            return new ArEntryIdType(StringByteUtil.stringToMaxByteArray((String)string, (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)16));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ARException(2, 9062, unsupportedEncodingException.getMessage());
        }
    }

    private ArEntryIdList toRpcArEntryIdList(String[] stringArray) throws ARException {
        int n = stringArray == null ? 0 : stringArray.length;
        ArEntryIdType[] arEntryIdTypeArray = new ArEntryIdType[n];
        for (int i = 0; i < n; ++i) {
            arEntryIdTypeArray[i] = this.toRpcArEntryIdType(stringArray[i]);
        }
        return new ArEntryIdList(arEntryIdTypeArray);
    }

    ArEntryListFieldValueList6 getEntryListValueListFromEntries(List<Entry> list) throws ARException {
        ArEntryListFieldValueList6 arEntryListFieldValueList6 = new ArEntryListFieldValueList6();
        if (list != null) {
            arEntryListFieldValueList6.value = new ArEntryListFieldValueStruct6[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                arEntryListFieldValueList6.value[i] = new ArEntryListFieldValueStruct6();
                arEntryListFieldValueList6.value[i].entryId = this.getEntryIdListFromKey(list.get(i).getEntryId());
                arEntryListFieldValueList6.value[i].entryValues = this.getFieldValListFromEntryItems(list.get(i));
            }
        }
        return arEntryListFieldValueList6;
    }

    List<SortInfo> getSortInfoFromRpcSortList(ArSortList arSortList) {
        ArrayList<SortInfo> arrayList = new ArrayList<SortInfo>();
        if (arSortList != null && arSortList.value != null) {
            for (int i = 0; i < arSortList.value.length; ++i) {
                SortInfo sortInfo = new SortInfo(arSortList.value[i].getFieldId().value, arSortList.value[i].getSortOrder());
                arrayList.add(sortInfo);
            }
        }
        return arrayList;
    }

    List<EntryListFieldInfo> getGetListFieldsFromRPC(ArEntryListFieldList arEntryListFieldList) {
        ArrayList<EntryListFieldInfo> arrayList = new ArrayList<EntryListFieldInfo>();
        if (arEntryListFieldList != null && arEntryListFieldList.value != null) {
            for (int i = 0; i < arEntryListFieldList.value.length; ++i) {
                EntryListFieldInfo entryListFieldInfo = new EntryListFieldInfo(arEntryListFieldList.value[i].getFieldId().value, arEntryListFieldList.value[i].getColumnWidth(), this.getEncodedString(arEntryListFieldList.value[i].getSeparator()));
                arrayList.add(entryListFieldInfo);
            }
        }
        return arrayList;
    }

    ArCompoundSchemaList12 getRpcVendorForm(List<VendorForm> list) throws ARException {
        ArCompoundSchemaList12 arCompoundSchemaList12 = new ArCompoundSchemaList12();
        if (list != null) {
            arCompoundSchemaList12.value = new ArCompoundSchema12[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                VendorForm vendorForm = list.get(i);
                arCompoundSchemaList12.value[i] = this.getCompoundSchema(vendorForm);
            }
        }
        return arCompoundSchemaList12;
    }

    ArCompoundSchema12 getCompoundSchema(VendorForm vendorForm) throws ARException {
        ArCompoundSchema12 arCompoundSchema12 = new ArCompoundSchema12();
        arCompoundSchema12.schemaType = vendorForm.getFormType();
        arCompoundSchema12.vendor = new ArVendorSchema12();
        byte[] byArray = null;
        try {
            if (vendorForm.getVendorName() != null) {
                byArray = StringByteUtil.stringToMaxByteArray((String)vendorForm.getVendorName(), (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)255);
                arCompoundSchema12.vendor.setVendorName(new ArNameType8(byArray));
            } else {
                arCompoundSchema12.vendor.setVendorName(new ArNameType8());
            }
        }
        catch (Exception exception) {
            StatusInfo statusInfo = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), vendorForm.getVendorName());
            ArrayList<StatusInfo> arrayList = new ArrayList<StatusInfo>();
            arrayList.add(statusInfo);
            throw new ARException(arrayList);
        }
        try {
            byArray = vendorForm.getTableName() != null ? StringByteUtil.stringToMaxByteArray((String)vendorForm.getTableName(), null, (int)2048) : new byte[2048];
        }
        catch (Exception exception) {
            StatusInfo statusInfo = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), vendorForm.getTableName());
            ArrayList<StatusInfo> arrayList = new ArrayList<StatusInfo>();
            arrayList.add(statusInfo);
            throw new ARException(arrayList);
        }
        arCompoundSchema12.vendor.setTableName(byArray);
        return arCompoundSchema12;
    }

    void getGMFOutFromVendorFields(ArEsArdbcGetMultipleFields4Out arEsArdbcGetMultipleFields4Out, List<ARVendorField> list) throws ARException {
        if (list != null) {
            int n = list.size();
            arEsArdbcGetMultipleFields4Out.dataType.value = new int[n];
            arEsArdbcGetMultipleFields4Out.fieldMapping.value = new ArFieldMappingStruct10[n];
            arEsArdbcGetMultipleFields4Out.limitList.value = new ArFieldLimitStruct12[n];
            for (int i = 0; i < n; ++i) {
                ARVendorField aRVendorField = list.get(i);
                arEsArdbcGetMultipleFields4Out.dataType.value[i] = aRVendorField.getDataType();
                arEsArdbcGetMultipleFields4Out.fieldMapping.value[i] = new ArFieldMappingStruct10();
                arEsArdbcGetMultipleFields4Out.fieldMapping.value[i].fieldType = 4;
                arEsArdbcGetMultipleFields4Out.fieldMapping.value[i].vendor = new ArVendorMappingStruct8();
                byte[] byArray = null;
                try {
                    if (aRVendorField.getName() != null) {
                        byArray = StringByteUtil.stringToMaxByteArray((String)aRVendorField.getName(), (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)255);
                        arEsArdbcGetMultipleFields4Out.fieldMapping.value[i].vendor.setFieldName(new ArNameType8(byArray));
                    } else {
                        arEsArdbcGetMultipleFields4Out.fieldMapping.value[i].vendor.setFieldName(new ArNameType8());
                    }
                }
                catch (Exception exception) {
                    StatusInfo statusInfo = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), aRVendorField.getName());
                    ArrayList<StatusInfo> arrayList = new ArrayList<StatusInfo>();
                    arrayList.add(statusInfo);
                    throw new ARException(arrayList);
                }
                arEsArdbcGetMultipleFields4Out.limitList.value[i] = this.getRPCFieldLimit(aRVendorField.getFieldLimit());
            }
        }
    }

    ArFieldLimitStruct12 getRPCFieldLimit(FieldLimit fieldLimit) throws ARException {
        byte[] byArray = null;
        ArFieldLimitStruct12 arFieldLimitStruct12 = new ArFieldLimitStruct12();
        if (fieldLimit != null) {
            arFieldLimitStruct12.dataType = fieldLimit.getDataType();
            switch (fieldLimit.getDataType()) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    IntegerFieldLimit integerFieldLimit = (IntegerFieldLimit)fieldLimit;
                    arFieldLimitStruct12.intLimits = new ArIntegerLimitsStruct();
                    arFieldLimitStruct12.intLimits.setRangeHigh(integerFieldLimit.getHighRange());
                    arFieldLimitStruct12.intLimits.setRangeLow(integerFieldLimit.getLowRange());
                    break;
                }
                case 3: {
                    RealFieldLimit realFieldLimit = (RealFieldLimit)fieldLimit;
                    arFieldLimitStruct12.realLimits = new ArRealLimitsStruct2();
                    arFieldLimitStruct12.realLimits.setPrecision(realFieldLimit.getPrecision());
                    arFieldLimitStruct12.realLimits.setRangeHigh(realFieldLimit.getHighRange());
                    arFieldLimitStruct12.realLimits.setRangeLow(realFieldLimit.getLowRange());
                    break;
                }
                case 4: {
                    CharacterFieldLimit characterFieldLimit = (CharacterFieldLimit)fieldLimit;
                    arFieldLimitStruct12.charLimits = new ArCharLimitsStruct8();
                    try {
                        if (characterFieldLimit.getCharMenu() != null) {
                            byArray = StringByteUtil.stringToMaxByteArray((String)characterFieldLimit.getCharMenu(), (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)255);
                            arFieldLimitStruct12.charLimits.setCharMenu(new ArNameType8(byArray));
                        } else {
                            arFieldLimitStruct12.charLimits.setCharMenu(new ArNameType8());
                        }
                    }
                    catch (Exception exception) {
                        StatusInfo statusInfo = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), characterFieldLimit.getCharMenu());
                        ArrayList<StatusInfo> arrayList = new ArrayList<StatusInfo>();
                        arrayList.add(statusInfo);
                        throw new ARException(arrayList);
                    }
                    arFieldLimitStruct12.charLimits.setFullTextOptions(characterFieldLimit.getFullTextOption());
                    arFieldLimitStruct12.charLimits.setMaxLength(characterFieldLimit.getMaxLength());
                    arFieldLimitStruct12.charLimits.setMenuStyle(characterFieldLimit.getMenuStyle());
                    arFieldLimitStruct12.charLimits.setPattern(characterFieldLimit.getPattern() == null ? "" : characterFieldLimit.getPattern());
                    arFieldLimitStruct12.charLimits.setQbeMatchOperation(characterFieldLimit.getQBEMatch());
                    break;
                }
                case 5: {
                    DiaryFieldLimit diaryFieldLimit = (DiaryFieldLimit)fieldLimit;
                    arFieldLimitStruct12.diaryLimits = new ArDiaryLimitsStruct();
                    arFieldLimitStruct12.diaryLimits.setFullTextOptions(diaryFieldLimit.getFullTextOption());
                    break;
                }
                case 7: {
                    arFieldLimitStruct12.dataType = 0;
                    break;
                }
                case 8: 
                case 40: {
                    break;
                }
                case 14: {
                    arFieldLimitStruct12.dataType = 0;
                    break;
                }
                case 12: {
                    CurrencyFieldLimit currencyFieldLimit = (CurrencyFieldLimit)fieldLimit;
                    arFieldLimitStruct12.currencyLimits = new ArCurrencyLimitsStruct();
                    arFieldLimitStruct12.currencyLimits.allowableCurrencies = this.getCurrencyList(currencyFieldLimit.getAllowable());
                    arFieldLimitStruct12.currencyLimits.functionalCurrencies = this.getCurrencyList(currencyFieldLimit.getFunctional());
                    arFieldLimitStruct12.currencyLimits.precision = currencyFieldLimit.getPrecision();
                    arFieldLimitStruct12.currencyLimits.rangeHigh = currencyFieldLimit.getHighRange().toPlainString();
                    arFieldLimitStruct12.currencyLimits.rangeLow = currencyFieldLimit.getLowRange().toPlainString();
                    break;
                }
                case 13: {
                    DateOnlyFieldLimit dateOnlyFieldLimit = (DateOnlyFieldLimit)fieldLimit;
                    arFieldLimitStruct12.dateLimits = new ArDateLimitsStruct();
                    arFieldLimitStruct12.dateLimits.setMaxDate(dateOnlyFieldLimit.getMaxDate());
                    arFieldLimitStruct12.dateLimits.setMinDate(dateOnlyFieldLimit.getMinDate());
                    break;
                }
                case 10: {
                    DecimalFieldLimit decimalFieldLimit = (DecimalFieldLimit)fieldLimit;
                    arFieldLimitStruct12.decimalLimits = new ArDecimalLimitsStruct6(decimalFieldLimit.getLowRange().toPlainString(), decimalFieldLimit.getHighRange().toPlainString(), decimalFieldLimit.getPrecision());
                    break;
                }
                case 11: {
                    AttachmentFieldLimit attachmentFieldLimit = (AttachmentFieldLimit)fieldLimit;
                    arFieldLimitStruct12.attachLimits = new ArAttachLimitsStruct12();
                    arFieldLimitStruct12.attachLimits.setAttachType(attachmentFieldLimit.getAttachType());
                    arFieldLimitStruct12.attachLimits.setFullTextOptions(attachmentFieldLimit.getFullTextOption());
                    arFieldLimitStruct12.attachLimits.setMaxSize(attachmentFieldLimit.getMaxSize());
                    break;
                }
                case 34: {
                    ColumnFieldLimit columnFieldLimit = (ColumnFieldLimit)fieldLimit;
                    arFieldLimitStruct12.columnLimits = new ArColumnLimitsStruct8();
                    arFieldLimitStruct12.columnLimits.setColLength(columnFieldLimit.getColumnLength());
                    arFieldLimitStruct12.columnLimits.setDataField(new ArInternalId(columnFieldLimit.getDataField()));
                    arFieldLimitStruct12.columnLimits.setDataSource(columnFieldLimit.getDataSource());
                    arFieldLimitStruct12.columnLimits.setParent(new ArInternalId(columnFieldLimit.getParent()));
                    break;
                }
                case 33: {
                    TableFieldLimit tableFieldLimit = (TableFieldLimit)fieldLimit;
                    arFieldLimitStruct12.tableLimits = new ArTableLimitsStruct10();
                    arFieldLimitStruct12.tableLimits.setMaxRetrieve(tableFieldLimit.getMaxRetrieve());
                    arFieldLimitStruct12.tableLimits.setNumColumns(tableFieldLimit.getColumnCount());
                    arFieldLimitStruct12.tableLimits.setQualifier(this.getRPCQualFromQualInfo(tableFieldLimit.getQualifier()));
                    try {
                        if (tableFieldLimit.getSampleForm() != null) {
                            byArray = StringByteUtil.stringToMaxByteArray((String)tableFieldLimit.getSampleForm(), null, (int)255);
                            arFieldLimitStruct12.tableLimits.setSampleSchema(new ArNameType8(byArray));
                        } else {
                            arFieldLimitStruct12.tableLimits.setSampleSchema(new ArNameType8());
                        }
                    }
                    catch (Exception exception) {
                        StatusInfo statusInfo = new StatusInfo(2, 8789L, "Error while encoding string to bytes", tableFieldLimit.getSampleForm());
                        ArrayList<StatusInfo> arrayList = new ArrayList<StatusInfo>();
                        arrayList.add(statusInfo);
                        throw new ARException(arrayList);
                    }
                    try {
                        if (tableFieldLimit.getSampleServer() != null) {
                            byArray = StringByteUtil.stringToMaxByteArray((String)tableFieldLimit.getSampleServer(), null, (int)65);
                            arFieldLimitStruct12.tableLimits.setSampleServer(new ArServerNameType(byArray));
                        } else {
                            arFieldLimitStruct12.tableLimits.setSampleServer(new ArServerNameType());
                        }
                    }
                    catch (Exception exception) {
                        StatusInfo statusInfo = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), tableFieldLimit.getSampleServer());
                        ArrayList<StatusInfo> arrayList = new ArrayList<StatusInfo>();
                        arrayList.add(statusInfo);
                        throw new ARException(arrayList);
                    }
                    try {
                        if (tableFieldLimit.getForm() != null) {
                            byArray = StringByteUtil.stringToMaxByteArray((String)tableFieldLimit.getForm(), null, (int)255);
                            arFieldLimitStruct12.tableLimits.setSchema(new ArNameType8(byArray));
                        } else {
                            arFieldLimitStruct12.tableLimits.setSchema(new ArNameType8());
                        }
                    }
                    catch (Exception exception) {
                        StatusInfo statusInfo = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), tableFieldLimit.getForm());
                        ArrayList<StatusInfo> arrayList = new ArrayList<StatusInfo>();
                        arrayList.add(statusInfo);
                        throw new ARException(arrayList);
                    }
                    try {
                        if (tableFieldLimit.getServer() != null) {
                            byArray = StringByteUtil.stringToMaxByteArray((String)tableFieldLimit.getServer(), null, (int)65);
                            arFieldLimitStruct12.tableLimits.setServer(new ArServerNameType(byArray));
                            break;
                        }
                        arFieldLimitStruct12.tableLimits.setServer(new ArServerNameType());
                        break;
                    }
                    catch (Exception exception) {
                        StatusInfo statusInfo = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), tableFieldLimit.getServer());
                        ArrayList<StatusInfo> arrayList = new ArrayList<StatusInfo>();
                        arrayList.add(statusInfo);
                        throw new ARException(arrayList);
                    }
                }
                case 43: {
                    DisplayFieldLimit displayFieldLimit = (DisplayFieldLimit)fieldLimit;
                    arFieldLimitStruct12.displayLimits = new ArDisplayLimits();
                    arFieldLimitStruct12.displayLimits.setMaxLength(displayFieldLimit.getMaxLength());
                    break;
                }
                case 6: {
                    SelectionFieldLimit selectionFieldLimit = (SelectionFieldLimit)fieldLimit;
                    arFieldLimitStruct12.enumLimits = new ArEnumLimitsStruct();
                    arFieldLimitStruct12.enumLimits.listStyle = selectionFieldLimit.getListStyle();
                    switch (arFieldLimitStruct12.enumLimits.listStyle) {
                        case 2: {
                            arFieldLimitStruct12.enumLimits.customList = this.getArEnumItemList(selectionFieldLimit.getValues());
                            break;
                        }
                        case 1: {
                            arFieldLimitStruct12.enumLimits.regularList = this.getArNameList(selectionFieldLimit.getValues());
                            break;
                        }
                        case 3: {
                            arFieldLimitStruct12.enumLimits.queryList = this.getArEnumStruct(selectionFieldLimit.getValues());
                        }
                    }
                    break;
                }
                case 42: {
                    ViewFieldLimit viewFieldLimit = (ViewFieldLimit)fieldLimit;
                    arFieldLimitStruct12.viewLimits = new ArViewLimits();
                    arFieldLimitStruct12.viewLimits.setMaxLength(viewFieldLimit.getMaxLength());
                    break;
                }
                case 41: {
                    break;
                }
            }
        }
        return arFieldLimitStruct12;
    }

    ArEnumItemList getArEnumItemList(List<EnumItem> list) throws ARException {
        ArEnumItemList arEnumItemList = new ArEnumItemList();
        if (list != null) {
            arEnumItemList.value = new ArEnumItemStruct[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                EnumItem enumItem = list.get(i);
                arEnumItemList.value[i] = new ArEnumItemStruct();
                byte[] byArray = null;
                try {
                    if (enumItem.getEnumItemName() != null) {
                        byArray = StringByteUtil.stringToMaxByteArray((String)enumItem.getEnumItemName(), (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)255);
                        arEnumItemList.value[i].setItemName(new ArNameType8(byArray));
                    } else {
                        arEnumItemList.value[i].setItemName(new ArNameType8());
                    }
                }
                catch (Exception exception) {
                    StatusInfo statusInfo = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), enumItem.getEnumItemName());
                    ArrayList<StatusInfo> arrayList = new ArrayList<StatusInfo>();
                    arrayList.add(statusInfo);
                    throw new ARException(arrayList);
                }
                arEnumItemList.value[i].setItemNumber(enumItem.getEnumItemNumber());
            }
        }
        return arEnumItemList;
    }

    ArNameList8 getArNameList(List<EnumItem> list) throws ARException {
        ArNameList8 arNameList8 = new ArNameList8();
        if (list != null) {
            arNameList8.value = new ArNameType8[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                EnumItem enumItem = list.get(i);
                byte[] byArray = null;
                try {
                    if (enumItem.getEnumItemName() != null) {
                        byArray = StringByteUtil.stringToMaxByteArray((String)enumItem.getEnumItemName(), (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)255);
                        arNameList8.value[i] = new ArNameType8(byArray);
                        continue;
                    }
                    arNameList8.value[i] = new ArNameType8();
                    continue;
                }
                catch (Exception exception) {
                    StatusInfo statusInfo = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), enumItem.getEnumItemName());
                    ArrayList<StatusInfo> arrayList = new ArrayList<StatusInfo>();
                    arrayList.add(statusInfo);
                    throw new ARException(arrayList);
                }
            }
        }
        return arNameList8;
    }

    ArCurrencyDetailList getCurrencyList(List<CurrencyDetail> list) throws ARException {
        ArCurrencyDetailList arCurrencyDetailList = new ArCurrencyDetailList();
        if (list != null) {
            arCurrencyDetailList.value = new ArCurrencyDetailStruct[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                arCurrencyDetailList.value[i] = new ArCurrencyDetailStruct();
                CurrencyDetail currencyDetail = list.get(i);
                byte[] byArray = null;
                try {
                    if (currencyDetail.getCurrencyCode() != null) {
                        byArray = StringByteUtil.stringToMaxByteArray((String)currencyDetail.getCurrencyCode(), (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)4);
                        arCurrencyDetailList.value[i].setCurrencyCode(new ArCurrencyCodeType(byArray));
                    } else {
                        arCurrencyDetailList.value[i].setCurrencyCode(new ArCurrencyCodeType());
                    }
                }
                catch (Exception exception) {
                    StatusInfo statusInfo = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), currencyDetail.getCurrencyCode());
                    ArrayList<StatusInfo> arrayList = new ArrayList<StatusInfo>();
                    arrayList.add(statusInfo);
                    throw new ARException(arrayList);
                }
                arCurrencyDetailList.value[i].setPrecision(currencyDetail.getPrecision());
            }
        }
        return arCurrencyDetailList;
    }

    VendorForm getVendorForm(ArCompoundSchema12 arCompoundSchema12) {
        VendorForm vendorForm = null;
        if (arCompoundSchema12 != null && arCompoundSchema12.schemaType == 5 && arCompoundSchema12.vendor != null) {
            String string = null;
            String string2 = null;
            try {
                string = StringByteUtil.createNullTerminatedString((byte[])arCompoundSchema12.vendor.vendorName.value, (String)ARPluginServerConfiguration.getInstance().getServerCharset());
                string2 = StringByteUtil.createNullTerminatedString((byte[])arCompoundSchema12.vendor.tableName, (String)ARPluginServerConfiguration.getInstance().getServerCharset());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOGGER.warn((Object)CatalogReader.getInstance().getMessage(8797), (Throwable)unsupportedEncodingException);
            }
            vendorForm = new VendorForm(string, string2);
        }
        return vendorForm;
    }

    ArithmeticOrRelationalOperand getFieldValueOrArithFromRPC(ArFieldValueOrArithStruct8 arFieldValueOrArithStruct8, boolean bl) throws ARException {
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand = null;
        switch (arFieldValueOrArithStruct8.tag) {
            case 3: {
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(this.getArithmeticOpInfo(arFieldValueOrArithStruct8.arithOp, bl));
                break;
            }
            case 6: {
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(this.getCurrencyPartInfo(arFieldValueOrArithStruct8.currencyField));
                break;
            }
            case 56: {
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(56, this.getCurrencyPartInfo(arFieldValueOrArithStruct8.currencyFieldCurrent));
                break;
            }
            case 55: {
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(56, this.getCurrencyPartInfo(arFieldValueOrArithStruct8.currencyFieldDB));
                break;
            }
            case 54: {
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(56, this.getCurrencyPartInfo(arFieldValueOrArithStruct8.currencyFieldTran));
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                if (bl) {
                    arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(OperandType.FIELDID, arFieldValueOrArithStruct8.fieldId.value);
                    break;
                }
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(OperandType.getOperandType((int)arFieldValueOrArithStruct8.tag), arFieldValueOrArithStruct8.fieldId.value);
                break;
            }
            case 1: {
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(OperandType.FIELDID, arFieldValueOrArithStruct8.fieldId.value);
                break;
            }
            case 99: {
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(OperandType.FIELDID_CURRENT, arFieldValueOrArithStruct8.fieldIdDB.value);
                break;
            }
            case 51: {
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(OperandType.FIELDID_DB, arFieldValueOrArithStruct8.fieldIdDB.value);
                break;
            }
            case 50: {
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(OperandType.FIELDID_TRANSACTION, arFieldValueOrArithStruct8.fieldIdTran.value);
                break;
            }
            case 52: {
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(OperandType.LOCAL_VARIABLE, arFieldValueOrArithStruct8.variable);
                break;
            }
            case 53: {
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(this.getQueryInfo(arFieldValueOrArithStruct8.queryValue, bl));
                break;
            }
            case 2: {
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(this.getValue(arFieldValueOrArithStruct8.value));
                break;
            }
            case 4: {
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(this.getStatHistoryValue(arFieldValueOrArithStruct8.statHistory));
                break;
            }
            case 5: {
                arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(this.getValueList(arFieldValueOrArithStruct8.valueSet));
            }
        }
        return arithmeticOrRelationalOperand;
    }

    Value getValue(ArValueStruct arValueStruct) throws ARException {
        Value value = ValueObjectFactory.getValueObject(arValueStruct);
        return value;
    }

    List<Value> getValueList(ArValueList arValueList) throws ARException {
        ArrayList<Value> arrayList = new ArrayList<Value>();
        if (arValueList != null && arValueList.value != null) {
            for (int i = 0; i < arValueList.value.length; ++i) {
                Value value = this.getValue(arValueList.value[i]);
                arrayList.add(value);
            }
        }
        return arrayList;
    }

    StatusHistoryValueIndicator getStatHistoryValue(ArStatHistoryValue arStatHistoryValue) {
        StatusHistoryValueIndicator statusHistoryValueIndicator = new StatusHistoryValueIndicator(arStatHistoryValue.getEnumVal() == 1, arStatHistoryValue.getUserOrTime());
        return null;
    }

    QueryInfo getQueryInfo(ArQueryValueStruct8 arQueryValueStruct8, boolean bl) throws ARException {
        String string = null;
        String string2 = null;
        try {
            string = StringByteUtil.createNullTerminatedString((byte[])arQueryValueStruct8.server, (String)ARPluginServerConfiguration.getInstance().getServerCharset());
            string2 = StringByteUtil.createNullTerminatedString((byte[])arQueryValueStruct8.schema.value, (String)"utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.warn((Object)CatalogReader.getInstance().getMessage(8797), (Throwable)unsupportedEncodingException);
        }
        QualifierInfo qualifierInfo = this.getQualInfoFromRpcQual(arQueryValueStruct8.qualifier, bl);
        int n = arQueryValueStruct8.valueField.value;
        int n2 = arQueryValueStruct8.multiMatchCode;
        QueryInfo queryInfo = new QueryInfo(string2, string, qualifierInfo, n, n2);
        return queryInfo;
    }

    CurrencyPartInfo getCurrencyPartInfo(ArCurrencyPartStruct arCurrencyPartStruct) {
        String string = null;
        try {
            string = StringByteUtil.createNullTerminatedString((byte[])arCurrencyPartStruct.currencyCode.value, (String)ARPluginServerConfiguration.getInstance().getServerCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.warn((Object)CatalogReader.getInstance().getMessage(8797), (Throwable)unsupportedEncodingException);
        }
        CurrencyPartInfo currencyPartInfo = new CurrencyPartInfo(arCurrencyPartStruct.fieldId.value, arCurrencyPartStruct.getPartTag(), string);
        return currencyPartInfo;
    }

    ArithmeticOperationInfo getArithmeticOpInfo(ArArithOpStruct8 arArithOpStruct8, boolean bl) throws ARException {
        ArithmeticOperationInfo arithmeticOperationInfo = new ArithmeticOperationInfo(arArithOpStruct8.getOperation(), this.getFieldValueOrArithFromRPC(arArithOpStruct8.operandLeft, bl), this.getFieldValueOrArithFromRPC(arArithOpStruct8.operandRight, bl));
        return arithmeticOperationInfo;
    }

    ArStatisticsResultList getRPCStatisticsResults(List<StatisticsResultInfo> list) throws ARException {
        ArStatisticsResultList arStatisticsResultList = new ArStatisticsResultList();
        if (list != null) {
            arStatisticsResultList.value = new ArStatisticsResultStruct[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                StatisticsResultInfo statisticsResultInfo = list.get(i);
                arStatisticsResultList.value[i] = new ArStatisticsResultStruct();
                List list2 = statisticsResultInfo.getGroupByValues();
                Value value = statisticsResultInfo.getResult();
                arStatisticsResultList.value[i].setGroupByValues(this.getArValueListFromValueList(list2));
                arStatisticsResultList.value[i].setResult(this.getArValueFromValue(value));
            }
        }
        return null;
    }

    byte[] getBytesFromAttachmentValue(AttachmentValue attachmentValue) {
        byte[] byArray = attachmentValue.getContent();
        return byArray;
    }

    AttachmentValue getAttachmentInfoFromBytes(byte[] byArray) {
        AttachmentValue attachmentValue = new AttachmentValue(byArray);
        return attachmentValue;
    }

    QualifierInfo getQualInfoFromRpcQual(ArQualifierStruct8 arQualifierStruct8, boolean bl) throws ARException {
        QualifierInfo qualifierInfo = null;
        if (arQualifierStruct8 != null) {
            switch (arQualifierStruct8.operation) {
                case 1: {
                    qualifierInfo = new QualifierInfo(arQualifierStruct8.operation, this.getQualInfoFromRpcQual(arQualifierStruct8.andQual.operandLeft, bl), this.getQualInfoFromRpcQual(arQualifierStruct8.andQual.operandRight, bl));
                    break;
                }
                case 0: {
                    qualifierInfo = new QualifierInfo();
                    qualifierInfo.setOperation(arQualifierStruct8.operation);
                    break;
                }
                case 3: {
                    qualifierInfo = new QualifierInfo(arQualifierStruct8.operation, this.getQualInfoFromRpcQual(arQualifierStruct8.notQual, bl), null);
                    break;
                }
                case 2: {
                    qualifierInfo = new QualifierInfo(arQualifierStruct8.operation, this.getQualInfoFromRpcQual(arQualifierStruct8.orQual.operandLeft, bl), this.getQualInfoFromRpcQual(arQualifierStruct8.orQual.operandLeft, bl));
                    break;
                }
                case 4: {
                    qualifierInfo = new QualifierInfo(this.getRelationOperationInfo(arQualifierStruct8.relOp, bl));
                }
            }
        }
        return qualifierInfo;
    }

    RelationalOperationInfo getRelationOperationInfo(ArRelOpStruct8 arRelOpStruct8, boolean bl) throws ARException {
        RelationalOperationInfo relationalOperationInfo = new RelationalOperationInfo(arRelOpStruct8.getOperation(), this.getFieldValueOrArithFromRPC(arRelOpStruct8.getOperandLeft(), bl), this.getFieldValueOrArithFromRPC(arRelOpStruct8.getOperandRight(), bl));
        return relationalOperationInfo;
    }

    ArRelOpStruct8 getArRelOpStruct(RelationalOperationInfo relationalOperationInfo) throws ARException {
        ArRelOpStruct8 arRelOpStruct8 = new ArRelOpStruct8(relationalOperationInfo.getOperation(), this.getRPCFieldValueOrArith(relationalOperationInfo.getLeftOperand()), this.getRPCFieldValueOrArith(relationalOperationInfo.getRightOperand()));
        return arRelOpStruct8;
    }

    ArFieldValueOrArithStruct8 getRPCFieldValueOrArith(ArithmeticOrRelationalOperand arithmeticOrRelationalOperand) throws ARException {
        ArFieldValueOrArithStruct8 arFieldValueOrArithStruct8 = null;
        ArArithOpStruct8 arArithOpStruct8 = null;
        switch (arithmeticOrRelationalOperand.getType().toInt()) {
            case 3: {
                arArithOpStruct8 = this.getArArithOpStruct((ArithmeticOperationInfo)arithmeticOrRelationalOperand.getValue());
                arFieldValueOrArithStruct8 = new ArFieldValueOrArithStruct8(3, (Object)arArithOpStruct8);
                break;
            }
            case 6: {
                arArithOpStruct8 = this.getArCurrencyStruct((CurrencyPartInfo)arithmeticOrRelationalOperand.getValue());
                arFieldValueOrArithStruct8 = new ArFieldValueOrArithStruct8(6, (Object)arArithOpStruct8);
                break;
            }
            case 56: {
                arArithOpStruct8 = this.getArCurrencyStruct((CurrencyPartInfo)arithmeticOrRelationalOperand.getValue());
                arFieldValueOrArithStruct8 = new ArFieldValueOrArithStruct8(56, (Object)arArithOpStruct8);
                break;
            }
            case 55: {
                arArithOpStruct8 = this.getArCurrencyStruct((CurrencyPartInfo)arithmeticOrRelationalOperand.getValue());
                arFieldValueOrArithStruct8 = new ArFieldValueOrArithStruct8(3, (Object)arArithOpStruct8);
                break;
            }
            case 54: {
                arArithOpStruct8 = this.getArCurrencyStruct((CurrencyPartInfo)arithmeticOrRelationalOperand.getValue());
                arFieldValueOrArithStruct8 = new ArFieldValueOrArithStruct8(3, (Object)arArithOpStruct8);
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                arArithOpStruct8 = new ArInternalId(((Integer)arithmeticOrRelationalOperand.getValue()).intValue());
                arFieldValueOrArithStruct8 = new ArFieldValueOrArithStruct8(arithmeticOrRelationalOperand.getType().toInt(), (Object)arArithOpStruct8);
                break;
            }
            case 99: {
                arArithOpStruct8 = new ArInternalId(((Integer)arithmeticOrRelationalOperand.getValue()).intValue());
                arFieldValueOrArithStruct8 = new ArFieldValueOrArithStruct8(99, (Object)arArithOpStruct8);
                break;
            }
            case 51: {
                arArithOpStruct8 = new ArInternalId(((Integer)arithmeticOrRelationalOperand.getValue()).intValue());
                arFieldValueOrArithStruct8 = new ArFieldValueOrArithStruct8(51, (Object)arArithOpStruct8);
                break;
            }
            case 50: {
                arArithOpStruct8 = new ArInternalId(((Integer)arithmeticOrRelationalOperand.getValue()).intValue());
                arFieldValueOrArithStruct8 = new ArFieldValueOrArithStruct8(50, (Object)arArithOpStruct8);
                break;
            }
            case 52: {
                arArithOpStruct8 = new ArInternalId(((Integer)arithmeticOrRelationalOperand.getValue()).intValue());
                arFieldValueOrArithStruct8 = new ArFieldValueOrArithStruct8(52, (Object)arArithOpStruct8);
                break;
            }
            case 53: {
                arArithOpStruct8 = this.getArQueryValueStruct((QueryInfo)arithmeticOrRelationalOperand.getValue());
                arFieldValueOrArithStruct8 = new ArFieldValueOrArithStruct8(53, (Object)arArithOpStruct8);
                break;
            }
            case 2: {
                arArithOpStruct8 = this.getArValueFromValue((Value)arithmeticOrRelationalOperand.getValue());
                arFieldValueOrArithStruct8 = new ArFieldValueOrArithStruct8(2, (Object)arArithOpStruct8);
                break;
            }
            case 4: {
                arArithOpStruct8 = this.getArStatHistory((StatusHistoryValueIndicator)arithmeticOrRelationalOperand.getValue());
                arFieldValueOrArithStruct8 = new ArFieldValueOrArithStruct8(4, (Object)arArithOpStruct8);
                break;
            }
            case 5: {
                arArithOpStruct8 = this.getArValueListFromValueList((List)arithmeticOrRelationalOperand.getValue());
                arFieldValueOrArithStruct8 = new ArFieldValueOrArithStruct8(5, (Object)arArithOpStruct8);
            }
        }
        return arFieldValueOrArithStruct8;
    }

    ArStatHistoryValue getArStatHistory(StatusHistoryValueIndicator statusHistoryValueIndicator) {
        ArStatHistoryValue arStatHistoryValue = null;
        if (statusHistoryValueIndicator != null) {
            arStatHistoryValue = new ArStatHistoryValue(statusHistoryValueIndicator.getEnumValue(), statusHistoryValueIndicator.isUser() ? 1 : 2);
        }
        return arStatHistoryValue;
    }

    ArCurrencyPartStruct getArCurrencyStruct(CurrencyPartInfo currencyPartInfo) throws ARException {
        ArCurrencyPartStruct arCurrencyPartStruct = null;
        if (currencyPartInfo != null) {
            byte[] byArray = null;
            ArCurrencyCodeType arCurrencyCodeType = null;
            try {
                if (currencyPartInfo.getCurrencyCode() != null) {
                    byArray = StringByteUtil.stringToMaxByteArray((String)currencyPartInfo.getCurrencyCode(), (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)4);
                    arCurrencyCodeType = new ArCurrencyCodeType(byArray);
                } else {
                    arCurrencyCodeType = new ArCurrencyCodeType();
                }
            }
            catch (Exception exception) {
                StatusInfo statusInfo = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8797), currencyPartInfo.getCurrencyCode());
                ArrayList<StatusInfo> arrayList = new ArrayList<StatusInfo>();
                arrayList.add(statusInfo);
                throw new ARException(arrayList);
            }
            arCurrencyPartStruct = new ArCurrencyPartStruct(new ArInternalId(currencyPartInfo.getFieldId()), currencyPartInfo.getPartTag(), arCurrencyCodeType);
        }
        return arCurrencyPartStruct;
    }

    public ArCoordList toRpcArCoordList(List<CoordinateInfo> list) throws ARException {
        int n = list == null ? 0 : list.size();
        ArCoordStruct[] arCoordStructArray = new ArCoordStruct[n];
        for (int i = 0; i < n; ++i) {
            arCoordStructArray[i] = this.toRpcArCoordStruct(list.get(i));
        }
        return new ArCoordList(arCoordStructArray);
    }

    public ArCoordStruct toRpcArCoordStruct(CoordinateInfo coordinateInfo) throws ARException {
        if (coordinateInfo == null) {
            return new ArCoordStruct();
        }
        int n = coordinateInfo.getXCoordinate();
        int n2 = coordinateInfo.getYCoordinate();
        return new ArCoordStruct(n, n2);
    }

    public List<CoordinateInfo> fromRpcArCoordList(ArCoordList arCoordList) {
        ArrayList<CoordinateInfo> arrayList = new ArrayList<CoordinateInfo>();
        if (arCoordList != null) {
            for (ArCoordStruct arCoordStruct : arCoordList.value) {
                arrayList.add(new CoordinateInfo(arCoordStruct.x, arCoordStruct.y));
            }
        }
        return arrayList;
    }

    public String byteArrayToString(byte[] byArray) throws ARException {
        try {
            int n;
            for (n = 0; n < byArray.length && byArray[n] != 0; ++n) {
            }
            return new String(byArray, 0, n, ARPluginServerConfiguration.getInstance().getServerCharset()).trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ARException(2, 9062, unsupportedEncodingException.getLocalizedMessage());
        }
    }

    public byte[] stringToByteArray(String string) throws ARException {
        try {
            return StringByteUtil.stringToMaxByteArray((String)string, (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)(string.getBytes(ARPluginServerConfiguration.getInstance().getServerCharset()).length + 1));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ARException(2, 9062, unsupportedEncodingException.getMessage());
        }
    }

    public ArCurrencyCodeType toRpcArCurrencyCodeType(String string) throws ARException {
        try {
            return new ArCurrencyCodeType(StringByteUtil.stringToMaxByteArray((String)string, (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)4));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ARException(2, 9062, unsupportedEncodingException.getMessage());
        }
    }

    public ArCurrencyStruct toRpcArCurrencyStruct(CurrencyValue currencyValue) throws ARException {
        if (currencyValue == null) {
            return new ArCurrencyStruct();
        }
        String string = currencyValue.getValueString();
        ArCurrencyCodeType arCurrencyCodeType = this.toRpcArCurrencyCodeType(currencyValue.getCurrencyCode());
        ArTimestamp arTimestamp = this.getArTimestampFromTimestamp(currencyValue.getConversionDate());
        ArFuncCurrencyList arFuncCurrencyList = this.toRpcArFuncCurrencyList(currencyValue.getFuncCurrencyList());
        return new ArCurrencyStruct(string, arCurrencyCodeType, arTimestamp, arFuncCurrencyList);
    }

    public ArFuncCurrencyList toRpcArFuncCurrencyList(List<FuncCurrencyInfo> list) throws ARException {
        int n = list == null ? 0 : list.size();
        ArFuncCurrencyStruct[] arFuncCurrencyStructArray = new ArFuncCurrencyStruct[n];
        for (int i = 0; i < n; ++i) {
            arFuncCurrencyStructArray[i] = this.toRpcArFuncCurrencyStruct(list.get(i));
        }
        return new ArFuncCurrencyList(arFuncCurrencyStructArray);
    }

    public ArFuncCurrencyStruct toRpcArFuncCurrencyStruct(FuncCurrencyInfo funcCurrencyInfo) throws ARException {
        if (funcCurrencyInfo == null) {
            return new ArFuncCurrencyStruct();
        }
        String string = funcCurrencyInfo.getValueString();
        ArCurrencyCodeType arCurrencyCodeType = this.toRpcArCurrencyCodeType(funcCurrencyInfo.getCurrencyCode());
        return new ArFuncCurrencyStruct(string, arCurrencyCodeType);
    }

    public CurrencyValue fromRpcArCurrencyStructToCurrencyInfo(ArCurrencyStruct arCurrencyStruct) throws ARException {
        return new CurrencyValue(new BigDecimal(arCurrencyStruct.getValue()), this.byteArrayToString(arCurrencyStruct.getCurrencyCode().getValue()), this.getTimestampFromArTimestamp(arCurrencyStruct.getConversionDate()), this.fromRpcArFuncCurrencyListToList(arCurrencyStruct.getFuncCurrencyList()));
    }

    public List<FuncCurrencyInfo> fromRpcArFuncCurrencyListToList(ArFuncCurrencyList arFuncCurrencyList) throws ARException {
        ArrayList<FuncCurrencyInfo> arrayList = new ArrayList<FuncCurrencyInfo>();
        for (int i = 0; i < arFuncCurrencyList.getValue().length; ++i) {
            FuncCurrencyInfo funcCurrencyInfo = this.fromRpcArFuncCurrencyStructToFuncCurrencyInfo(arFuncCurrencyList.getValue()[i]);
            if (funcCurrencyInfo == null) continue;
            arrayList.add(funcCurrencyInfo);
        }
        return arrayList;
    }

    public FuncCurrencyInfo fromRpcArFuncCurrencyStructToFuncCurrencyInfo(ArFuncCurrencyStruct arFuncCurrencyStruct) throws ARException {
        if (arFuncCurrencyStruct.getValue() != null && arFuncCurrencyStruct.getValue().equals("")) {
            return null;
        }
        return new FuncCurrencyInfo(new BigDecimal(arFuncCurrencyStruct.getValue()), this.byteArrayToString(arFuncCurrencyStruct.getCurrencyCode().getValue()));
    }

    ArQueryValueStruct8 getArQueryValueStruct(QueryInfo queryInfo) throws ARException {
        ArQueryValueStruct8 arQueryValueStruct8 = null;
        if (queryInfo != null) {
            byte[] byArray = null;
            byte[] byArray2 = null;
            try {
                if (queryInfo.getFormID() != null) {
                    byArray = StringByteUtil.stringToMaxByteArray((String)queryInfo.getFormID(), (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)255);
                }
                byArray2 = queryInfo.getServerName() != null ? StringByteUtil.stringToMaxByteArray((String)queryInfo.getServerName(), null, (int)65) : new byte[65];
            }
            catch (Exception exception) {
                StatusInfo statusInfo = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), queryInfo.getFormID());
                ArrayList<StatusInfo> arrayList = new ArrayList<StatusInfo>();
                arrayList.add(statusInfo);
                throw new ARException(arrayList);
            }
            arQueryValueStruct8 = new ArQueryValueStruct8(new ArNameType8(byArray), byArray2, this.getRPCQualFromQualInfo(queryInfo.getQualifierInfo()), new ArInternalId(queryInfo.getFieldID()), queryInfo.getMatchMode());
        } else {
            arQueryValueStruct8 = new ArQueryValueStruct8();
        }
        return arQueryValueStruct8;
    }

    ArArithOpStruct8 getArArithOpStruct(ArithmeticOperationInfo arithmeticOperationInfo) throws ARException {
        ArArithOpStruct8 arArithOpStruct8 = new ArArithOpStruct8(arithmeticOperationInfo.getOperation(), this.getRPCFieldValueOrArith(arithmeticOperationInfo.getLeftOperand()), this.getRPCFieldValueOrArith(arithmeticOperationInfo.getRightOperand()));
        return null;
    }

    ArQualifierStruct8 getRPCQualFromQualInfo(QualifierInfo qualifierInfo) throws ARException {
        ArQualifierStruct8 arQualifierStruct8 = null;
        ArQualifierStruct8 arQualifierStruct82 = null;
        switch (qualifierInfo.getOperation()) {
            case 1: {
                arQualifierStruct82 = new ArAndOrStruct8(this.getRPCQualFromQualInfo(qualifierInfo.getLeftOperand()), this.getRPCQualFromQualInfo(qualifierInfo.getRightOperand()));
                arQualifierStruct8 = new ArQualifierStruct8(qualifierInfo.getOperation(), (Object)arQualifierStruct82);
                break;
            }
            case 0: {
                arQualifierStruct8 = new ArQualifierStruct8(qualifierInfo.getOperation(), (Object)arQualifierStruct82);
                break;
            }
            case 3: {
                arQualifierStruct82 = this.getRPCQualFromQualInfo(qualifierInfo.getNotOperand());
                arQualifierStruct8 = new ArQualifierStruct8(qualifierInfo.getOperation(), (Object)arQualifierStruct82);
                break;
            }
            case 2: {
                arQualifierStruct82 = new ArAndOrStruct8(this.getRPCQualFromQualInfo(qualifierInfo.getLeftOperand()), this.getRPCQualFromQualInfo(qualifierInfo.getRightOperand()));
                arQualifierStruct8 = new ArQualifierStruct8(qualifierInfo.getOperation(), (Object)arQualifierStruct82);
                break;
            }
            case 4: {
                arQualifierStruct82 = this.getArRelOpStruct(qualifierInfo.getRelationalOperationInfo());
                arQualifierStruct8 = new ArQualifierStruct8(qualifierInfo.getOperation(), (Object)arQualifierStruct82);
            }
        }
        return arQualifierStruct8;
    }

    public ARPluginContext getContextFromControl(ArEsControlStruct4 arEsControlStruct4, ARPluginInfo aRPluginInfo) {
        ARPluginContext aRPluginContext = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (arEsControlStruct4 != null && arEsControlStruct4.reservedPropList != null) {
            ArPropStruct[] arPropStructArray = arEsControlStruct4.reservedPropList.getValue();
            if (arPropStructArray != null) {
                block5: for (int i = 0; i < arPropStructArray.length; ++i) {
                    ArValueStruct arValueStruct = arPropStructArray[i].getValue();
                    if (arValueStruct.getDataType() != 4) continue;
                    switch (arPropStructArray[i].getProp()) {
                        case 1: {
                            string = arValueStruct.charVal;
                            continue block5;
                        }
                        case 2: {
                            string3 = arValueStruct.charVal;
                            continue block5;
                        }
                        case 3: {
                            string2 = arValueStruct.charVal;
                        }
                    }
                }
            }
            aRPluginContext = new ARPluginContext(string, string2, string3, ARPluginServerConfiguration.getInstance().getCmdLineArgs(), aRPluginInfo);
        }
        return aRPluginContext;
    }

    ArEnumQueryStruct getArEnumStruct(List<EnumItem> list) {
        ArEnumQueryStruct arEnumQueryStruct = new ArEnumQueryStruct();
        return arEnumQueryStruct;
    }

    public ByteListValue fromRpcArByteListToByteListInfo(ArByteList arByteList) throws ARException {
        return new ByteListValue(arByteList.getType(), arByteList.getBytes());
    }

    public ArByteList toRpcArByteList(ByteListValue byteListValue) throws ARException {
        if (byteListValue == null) {
            return new ArByteList();
        }
        int n = byteListValue.getType();
        byte[] byArray = byteListValue.getValue();
        return new ArByteList(n, byArray);
    }

    public ArdbcCreateIn fromRPC(ArEsArdbcCreate4In arEsArdbcCreate4In, ARPluginInfo aRPluginInfo) throws ARException {
        ArdbcCreateIn ardbcCreateIn = null;
        ardbcCreateIn = new ArdbcCreateIn();
        ardbcCreateIn.tableName = arEsArdbcCreate4In.tableName;
        ardbcCreateIn.transId = arEsArdbcCreate4In.transId.value;
        ardbcCreateIn.fieldsList = this.getVendorFields(arEsArdbcCreate4In.vendorFieldList);
        ardbcCreateIn.entry = this.getEntryFromInput(arEsArdbcCreate4In.entryId, arEsArdbcCreate4In.fieldValueList, arEsArdbcCreate4In.tableName);
        ardbcCreateIn.context = this.getContextFromControl(arEsArdbcCreate4In.control, aRPluginInfo);
        return ardbcCreateIn;
    }

    public ArEsArdbcCreate4Out toRPC(ArdbcCreateOut ardbcCreateOut) throws ARException {
        ArEsArdbcCreate4Out arEsArdbcCreate4Out = new ArEsArdbcCreate4Out(ardbcCreateOut.control, this.getEntryIdListFromKey(ardbcCreateOut.key), this.getRpcStatusFromStatusInfo(ardbcCreateOut.status));
        return arEsArdbcCreate4Out;
    }

    public ArdbcGetIn fromRPC(ArEsArdbcGet4In arEsArdbcGet4In, ARPluginInfo aRPluginInfo) {
        ArdbcGetIn ardbcGetIn = new ArdbcGetIn();
        ardbcGetIn.context = this.getContextFromControl(arEsArdbcGet4In.control, aRPluginInfo);
        ardbcGetIn.entryId = this.getEntryIdListString(arEsArdbcGet4In.entryId);
        ardbcGetIn.fieldsList = this.getVendorFields(arEsArdbcGet4In.vendorFieldList);
        ardbcGetIn.idList = this.getIntListFromInternalIds(arEsArdbcGet4In.idList);
        ardbcGetIn.tableName = arEsArdbcGet4In.tableName;
        ardbcGetIn.transId = arEsArdbcGet4In.transId.value;
        return ardbcGetIn;
    }

    public ArEsArdbcGet4Out toRPC(ArdbcGetOut ardbcGetOut) throws ARException {
        ArEsArdbcGet4Out arEsArdbcGet4Out = new ArEsArdbcGet4Out(ardbcGetOut.control, this.getFieldValueListFromEntry(ardbcGetOut.entry), this.getRpcStatusFromStatusInfo(ardbcGetOut.status));
        return arEsArdbcGet4Out;
    }

    public ArdbcSetIn fromRPC(ArEsArdbcSet4In arEsArdbcSet4In, ARPluginInfo aRPluginInfo) throws ARException {
        ArdbcSetIn ardbcSetIn = new ArdbcSetIn();
        ardbcSetIn.tableName = arEsArdbcSet4In.tableName;
        ardbcSetIn.transId = arEsArdbcSet4In.transId.value;
        ardbcSetIn.fieldsList = this.getVendorFields(arEsArdbcSet4In.vendorFieldList);
        ardbcSetIn.entryId = this.getEntryIdListString(arEsArdbcSet4In.entryId);
        ardbcSetIn.entry = this.getEntryFromInput(arEsArdbcSet4In.entryId, arEsArdbcSet4In.fieldValueList, arEsArdbcSet4In.tableName);
        ardbcSetIn.context = this.getContextFromControl(arEsArdbcSet4In.control, aRPluginInfo);
        ardbcSetIn.timestamp = this.getTimestampFromArTimestamp(arEsArdbcSet4In.getTimestamp);
        return ardbcSetIn;
    }

    public ArEsArdbcSet4Out toRPC(ArdbcSetOut ardbcSetOut) {
        ArEsArdbcSet4Out arEsArdbcSet4Out = new ArEsArdbcSet4Out(ardbcSetOut.control, this.getRpcStatusFromStatusInfo(ardbcSetOut.status));
        return arEsArdbcSet4Out;
    }

    public ArdbcDeleteIn fromRPC(ArEsArdbcDelete4In arEsArdbcDelete4In, ARPluginInfo aRPluginInfo) {
        ArdbcDeleteIn ardbcDeleteIn = new ArdbcDeleteIn();
        ardbcDeleteIn.context = this.getContextFromControl(arEsArdbcDelete4In.control, aRPluginInfo);
        ardbcDeleteIn.entryId = this.getEntryIdListString(arEsArdbcDelete4In.entryId);
        ardbcDeleteIn.fieldsList = this.getVendorFields(arEsArdbcDelete4In.vendorFieldList);
        ardbcDeleteIn.tableName = arEsArdbcDelete4In.tableName;
        ardbcDeleteIn.transId = arEsArdbcDelete4In.transId.value;
        ardbcDeleteIn.deleteBlob = this.getBooleanFromArBoolean(arEsArdbcDelete4In.deleteBLOB);
        return ardbcDeleteIn;
    }

    public ArEsArdbcDelete4Out toRPC(ArdbcDeleteOut ardbcDeleteOut) {
        ArEsArdbcDelete4Out arEsArdbcDelete4Out = new ArEsArdbcDelete4Out(ardbcDeleteOut.control, this.getRpcStatusFromStatusInfo(ardbcDeleteOut.status));
        return arEsArdbcDelete4Out;
    }

    public ArdbcGetBlobIn fromRPC(ArEsArdbcGetBlob4In arEsArdbcGetBlob4In, ARPluginInfo aRPluginInfo) {
        ArdbcGetBlobIn ardbcGetBlobIn = new ArdbcGetBlobIn();
        ardbcGetBlobIn.context = this.getContextFromControl(arEsArdbcGetBlob4In.control, aRPluginInfo);
        ardbcGetBlobIn.entryId = this.getEntryIdListString(arEsArdbcGetBlob4In.entryId);
        ardbcGetBlobIn.fieldsList = this.getVendorFields(arEsArdbcGetBlob4In.vendorFieldList);
        ardbcGetBlobIn.tableName = arEsArdbcGetBlob4In.tableName;
        ardbcGetBlobIn.transId = arEsArdbcGetBlob4In.transId.value;
        ardbcGetBlobIn.fieldId = arEsArdbcGetBlob4In.fieldId.value;
        return ardbcGetBlobIn;
    }

    public ArEsArdbcGetBlob4Out toRPC(ArdbcGetBlobOut ardbcGetBlobOut) {
        byte[] byArray = this.getBytesFromAttachmentValue(ardbcGetBlobOut.attachment);
        byte[] byArray2 = new byte[]{};
        if (byArray != null) {
            this.compresser.setInput(byArray);
            byArray2 = this.compresser.deflate();
        }
        ArEsArdbcGetBlob4Out arEsArdbcGetBlob4Out = new ArEsArdbcGetBlob4Out(ardbcGetBlobOut.control, byArray2, this.getRpcStatusFromStatusInfo(ardbcGetBlobOut.status));
        return arEsArdbcGetBlob4Out;
    }

    public ArdbcGlwefIn fromRPC(ArEsArdbcGlewf4In arEsArdbcGlewf4In, ARPluginInfo aRPluginInfo, boolean bl) throws ARException {
        ArdbcGlwefIn ardbcGlwefIn = new ArdbcGlwefIn();
        ardbcGlwefIn.context = this.getContextFromControl(arEsArdbcGlewf4In.control, aRPluginInfo);
        ardbcGlwefIn.fieldsList = this.getVendorFields(arEsArdbcGlewf4In.vendorFieldList);
        ardbcGlwefIn.tableName = arEsArdbcGlewf4In.tableName;
        ardbcGlwefIn.transId = arEsArdbcGlewf4In.transId.value;
        ardbcGlwefIn.maxRetrieve = arEsArdbcGlewf4In.maxRetrieve;
        ardbcGlwefIn.startAt = arEsArdbcGlewf4In.firstRetrieve;
        ardbcGlwefIn.qualifier = this.getQualInfoFromRpcQual(arEsArdbcGlewf4In.qualifier, bl);
        ardbcGlwefIn.sortList = this.getSortInfoFromRpcSortList(arEsArdbcGlewf4In.sortList);
        ardbcGlwefIn.getListFields = this.getGetListFieldsFromRPC(arEsArdbcGlewf4In.getListFields);
        return ardbcGlwefIn;
    }

    public ArEsArdbcGlewf4Out toRPC(ArdbcGlewfOut ardbcGlewfOut) throws ARException {
        ArEsArdbcGlewf4Out arEsArdbcGlewf4Out = new ArEsArdbcGlewf4Out(ardbcGlewfOut.control, this.getEntryListValueListFromEntries(ardbcGlewfOut.entries), ardbcGlewfOut.numMatches.intValue(), this.getRpcStatusFromStatusInfo(ardbcGlewfOut.status));
        return arEsArdbcGlewf4Out;
    }

    public ArdbcCommitIn fromRPC(ArEsArdbcCommit4In arEsArdbcCommit4In, ARPluginInfo aRPluginInfo) {
        ArdbcCommitIn ardbcCommitIn = new ArdbcCommitIn();
        ardbcCommitIn.context = this.getContextFromControl(arEsArdbcCommit4In.control, aRPluginInfo);
        ardbcCommitIn.transId = arEsArdbcCommit4In.transId.value;
        return ardbcCommitIn;
    }

    public ArEsArdbcCommit4Out toRPC(ArdbcCommitOut ardbcCommitOut) {
        ArEsArdbcCommit4Out arEsArdbcCommit4Out = new ArEsArdbcCommit4Out(ardbcCommitOut.control, this.getRpcStatusFromStatusInfo(ardbcCommitOut.status));
        return arEsArdbcCommit4Out;
    }

    public ArdbcRollbackIn fromRPC(ArEsArdbcRollback4In arEsArdbcRollback4In, ARPluginInfo aRPluginInfo) {
        ArdbcRollbackIn ardbcRollbackIn = new ArdbcRollbackIn();
        ardbcRollbackIn.context = this.getContextFromControl(arEsArdbcRollback4In.control, aRPluginInfo);
        ardbcRollbackIn.transId = arEsArdbcRollback4In.transId.value;
        return ardbcRollbackIn;
    }

    public ArEsArdbcRollback4Out toRPC(ArdbcRollbackOut ardbcRollbackOut) {
        ArEsArdbcRollback4Out arEsArdbcRollback4Out = new ArEsArdbcRollback4Out(ardbcRollbackOut.control, this.getRpcStatusFromStatusInfo(ardbcRollbackOut.status));
        return arEsArdbcRollback4Out;
    }

    public ArdbcCancelIn fromRPC(ArEsArdbcCancelQuery4In arEsArdbcCancelQuery4In, ARPluginInfo aRPluginInfo) {
        ArdbcCancelIn ardbcCancelIn = new ArdbcCancelIn();
        ardbcCancelIn.context = this.getContextFromControl(arEsArdbcCancelQuery4In.control, aRPluginInfo);
        ardbcCancelIn.transId = arEsArdbcCancelQuery4In.transId.value;
        return ardbcCancelIn;
    }

    public ArEsArdbcCancelQuery4Out toRPC(ArdbcCancelOut ardbcCancelOut) {
        ArEsArdbcCancelQuery4Out arEsArdbcCancelQuery4Out = new ArEsArdbcCancelQuery4Out(ardbcCancelOut.control, this.getRpcStatusFromStatusInfo(ardbcCancelOut.status));
        return arEsArdbcCancelQuery4Out;
    }

    public ArdbcGetListFormsIn fromRPC(ArEsArdbcGetListForms4In arEsArdbcGetListForms4In, ARPluginInfo aRPluginInfo) {
        ArdbcGetListFormsIn ardbcGetListFormsIn = new ArdbcGetListFormsIn();
        ardbcGetListFormsIn.context = this.getContextFromControl(arEsArdbcGetListForms4In.control, aRPluginInfo);
        return ardbcGetListFormsIn;
    }

    public ArEsArdbcGetListForms4Out toRPC(ArdbcGetListFormsOut ardbcGetListFormsOut) throws ARException {
        ArEsArdbcGetListForms4Out arEsArdbcGetListForms4Out = new ArEsArdbcGetListForms4Out(ardbcGetListFormsOut.control, this.getRpcVendorForm(ardbcGetListFormsOut.forms), this.getRpcStatusFromStatusInfo(ardbcGetListFormsOut.status));
        return arEsArdbcGetListForms4Out;
    }

    public ArdbcGetMultipleFieldsIn fromRPC(ArEsArdbcGetMultipleFields4In arEsArdbcGetMultipleFields4In, ARPluginInfo aRPluginInfo) {
        ArdbcGetMultipleFieldsIn ardbcGetMultipleFieldsIn = new ArdbcGetMultipleFieldsIn();
        ardbcGetMultipleFieldsIn.context = this.getContextFromControl(arEsArdbcGetMultipleFields4In.control, aRPluginInfo);
        ardbcGetMultipleFieldsIn.schema = this.getVendorForm(arEsArdbcGetMultipleFields4In.schema);
        return ardbcGetMultipleFieldsIn;
    }

    public ArEsArdbcGetMultipleFields4Out toRPC(ArdbcGetMultipleFieldsOut ardbcGetMultipleFieldsOut) throws ARException {
        ArEsArdbcGetMultipleFields4Out arEsArdbcGetMultipleFields4Out = new ArEsArdbcGetMultipleFields4Out();
        this.getGMFOutFromVendorFields(arEsArdbcGetMultipleFields4Out, ardbcGetMultipleFieldsOut.fields);
        return arEsArdbcGetMultipleFields4Out;
    }

    public ArdbcGetEntryStatisticsIn fromRPC(ArEsArdbcGetEntryStatistics4In arEsArdbcGetEntryStatistics4In, ARPluginInfo aRPluginInfo, boolean bl) throws ARException {
        ArdbcGetEntryStatisticsIn ardbcGetEntryStatisticsIn = new ArdbcGetEntryStatisticsIn();
        ardbcGetEntryStatisticsIn.context = this.getContextFromControl(arEsArdbcGetEntryStatistics4In.control, aRPluginInfo);
        ardbcGetEntryStatisticsIn.fieldsList = this.getVendorFields(arEsArdbcGetEntryStatistics4In.vendorFieldList);
        ardbcGetEntryStatisticsIn.tableName = arEsArdbcGetEntryStatistics4In.tableName;
        ardbcGetEntryStatisticsIn.transId = arEsArdbcGetEntryStatistics4In.transId.value;
        ardbcGetEntryStatisticsIn.qualifier = this.getQualInfoFromRpcQual(arEsArdbcGetEntryStatistics4In.qualifier, bl);
        ardbcGetEntryStatisticsIn.groupByList = this.getIntListFromInternalIds(arEsArdbcGetEntryStatistics4In.groupByList);
        ardbcGetEntryStatisticsIn.statistic = arEsArdbcGetEntryStatistics4In.statistic;
        ardbcGetEntryStatisticsIn.target = this.getFieldValueOrArithFromRPC(arEsArdbcGetEntryStatistics4In.target, bl);
        return ardbcGetEntryStatisticsIn;
    }

    public ArEsArdbcGetEntryStatistics4Out toRPC(ArdbcGetEntryStatisticsOut ardbcGetEntryStatisticsOut) throws ARException {
        ArEsArdbcGetEntryStatistics4Out arEsArdbcGetEntryStatistics4Out = new ArEsArdbcGetEntryStatistics4Out();
        arEsArdbcGetEntryStatistics4Out.control = ardbcGetEntryStatisticsOut.control;
        arEsArdbcGetEntryStatistics4Out.status = this.getRpcStatusFromStatusInfo(ardbcGetEntryStatisticsOut.status);
        arEsArdbcGetEntryStatistics4Out.results = this.getRPCStatisticsResults(ardbcGetEntryStatisticsOut.stats);
        return arEsArdbcGetEntryStatistics4Out;
    }
}

