/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.utils;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class StringByteUtil {
    private static Base64 a = new Base64();

    private StringByteUtil() {
    }

    public static byte[] concatenateByteArrays(byte[] byArray, byte[] byArray2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length + byArray2.length);
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        return byteBuffer.array();
    }

    public static byte[] concatenateByteArrays(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length + byArray2.length + byArray3.length);
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        byteBuffer.put(byArray3);
        return byteBuffer.array();
    }

    public static byte[] concatenateByteArrays(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length + byArray2.length + byArray3.length + byArray4.length);
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        byteBuffer.put(byArray3);
        byteBuffer.put(byArray4);
        return byteBuffer.array();
    }

    public static byte[] getByteArrays(byte[] byArray, int n, int n2) {
        int n3 = byArray.length > n + n2 ? byArray.length : n + n2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        byteBuffer.put(byArray);
        byte[] byArray2 = new byte[n2];
        byteBuffer.position(n);
        byteBuffer.get(byArray2);
        return byArray2;
    }

    public static byte[] getOctetKey(byte[] byArray) {
        int n = 8;
        int n2 = byArray.length > n << 1 ? byArray.length : n << 1;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.put(byArray);
        byteBuffer.position(n);
        byte[] byArray2 = new byte[n];
        byteBuffer.get(byArray2);
        return byArray2;
    }

    public static byte[] resizeByteArray(byte[] byArray, int n) {
        if (n == byArray.length) {
            return byArray;
        }
        return StringByteUtil.getByteArrays(byArray, 0, n);
    }

    public static byte[] resizeStringToByteArray(String string, String string2, int n) throws UnsupportedEncodingException {
        byte[] byArray = string.getBytes(string2);
        return StringByteUtil.resizeByteArray(byArray, n);
    }

    public static byte[] stringToMaxByteArray(String string, String string2, int n) throws IllegalArgumentException, UnsupportedEncodingException {
        byte[] byArray;
        if (string == null) {
            return new byte[n];
        }
        if (string2 == null) {
            string2 = "utf-8";
        }
        if (string2.equals("EUC_JP")) {
            string = new String(string.getBytes("windows-31j"), "SJIS");
        }
        if ((byArray = string.getBytes(string2)).length > n) {
            throw new IllegalArgumentException("String is longer than the maximum allowed length, which is " + n + " bytes");
        }
        return StringByteUtil.resizeByteArray(byArray, n);
    }

    public static String createNullTerminatedString(byte[] byArray, String string) throws UnsupportedEncodingException {
        String string2 = null;
        if (string == null) {
            string = "utf-8";
        }
        int n = 0;
        for (n = 0; n < byArray.length && byArray[n] != 0; ++n) {
        }
        string2 = byArray.length == 0 || n < byArray.length ? new String(byArray, 0, n, string) : new String(byArray, string);
        if (string.equals("EUC_JP")) {
            string2 = new String(string2.getBytes("SJIS"), "windows-31j");
        }
        return string2;
    }

    public static byte[] generateRandomBytes(int n) {
        if (n < 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[n];
        Random random = new Random();
        random.nextBytes(byArray);
        return byArray;
    }

    public static long uLongToLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static int longToULong(long l) {
        return (int)(l & 0xFFFFFFFFFFFFFFFFL);
    }

    public static byte[] hexStrToBytes(String string) throws DecoderException {
        char[] cArray = string.toCharArray();
        return StringByteUtil.hexCharToBytes(cArray);
    }

    public static byte[] hexCharToBytes(char[] cArray) throws DecoderException {
        return Hex.decodeHex((char[])cArray);
    }

    public static String bytesToHexString(byte[] byArray) {
        return StringByteUtil.bytesToHexCharArray(byArray).toString();
    }

    public static char[] bytesToHexCharArray(byte[] byArray) {
        return Hex.encodeHex((byte[])byArray);
    }

    public static byte[] base64Encode(byte[] byArray) {
        return a.encode(byArray);
    }

    public static byte[] base64Decode(byte[] byArray) {
        return a.decode(byArray);
    }

    public static ByteBuffer expandDirectByteBufferCapacity(ByteBuffer byteBuffer, int n) {
        if (n <= byteBuffer.capacity()) {
            return byteBuffer;
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n);
        int n2 = byteBuffer.position();
        byteBuffer.flip();
        byteBuffer2.put(byteBuffer);
        byteBuffer2.position(n2);
        return byteBuffer2;
    }

    public static ByteBuffer checkAndExpandDirectByteBufferCapacity(ByteBuffer byteBuffer, int n) {
        if (byteBuffer == null || byteBuffer.remaining() >= n) {
            return byteBuffer;
        }
        int n2 = StringByteUtil.getNewBufferCapacityForExpanding(byteBuffer.capacity(), n);
        return StringByteUtil.expandDirectByteBufferCapacity(byteBuffer, n2);
    }

    public static int getNewBufferCapacityForExpanding(int n, int n2) {
        int n3 = n;
        if (n > 0x7FFFFF7F || n2 > 0 && 0x7FFFFF7F - Math.max(n2, 4096) < n || n2 == 0 && 2137483519 < n) {
            return n;
        }
        n3 = n2 > 0 ? (n3 += Math.max(n2, 4096)) : (n < 10000000 && n < 0x1FFFFFFF ? n * 4 : (n3 += 10000000));
        return n3;
    }
}

