/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;

public class SubnodeConfiguration
extends HierarchicalConfiguration {
    private static final long serialVersionUID = 3105734147019386480L;
    private HierarchicalConfiguration parent;

    public SubnodeConfiguration(HierarchicalConfiguration parent, ConfigurationNode root) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent configuration must not be null!");
        }
        if (root == null) {
            throw new IllegalArgumentException("Root node must not be null!");
        }
        this.setRootNode(root);
        this.parent = parent;
        this.initFromParent(parent);
    }

    public HierarchicalConfiguration getParent() {
        return this.parent;
    }

    protected SubnodeConfiguration createSubnodeConfiguration(ConfigurationNode node) {
        return new SubnodeConfiguration(this.getParent(), node);
    }

    protected HierarchicalConfiguration.Node createNode(String name) {
        return this.getParent().createNode(name);
    }

    protected void initFromParent(HierarchicalConfiguration parentConfig) {
        this.setExpressionEngine(parentConfig.getExpressionEngine());
        this.setListDelimiter(parentConfig.getListDelimiter());
        this.setDelimiterParsingDisabled(parentConfig.isDelimiterParsingDisabled());
        this.setThrowExceptionOnMissing(parentConfig.isThrowExceptionOnMissing());
    }

    protected Object interpolate(Object value) {
        return this.getParent().interpolate(value);
    }
}

