/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.SessionFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

public abstract class AbstractSessionFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean,
PersistenceExceptionTranslator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean exposeTransactionAwareSessionFactory = true;
    private SQLExceptionTranslator jdbcExceptionTranslator;
    private SessionFactory sessionFactory;
    static /* synthetic */ Class class$org$hibernate$SessionFactory;
    static /* synthetic */ Class class$org$hibernate$engine$SessionFactoryImplementor;

    public void setExposeTransactionAwareSessionFactory(boolean exposeTransactionAwareSessionFactory) {
        this.exposeTransactionAwareSessionFactory = exposeTransactionAwareSessionFactory;
    }

    protected boolean isExposeTransactionAwareSessionFactory() {
        return this.exposeTransactionAwareSessionFactory;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public void afterPropertiesSet() throws Exception {
        SessionFactory rawSf = this.buildSessionFactory();
        this.sessionFactory = this.wrapSessionFactoryIfNecessary(rawSf);
    }

    protected SessionFactory wrapSessionFactoryIfNecessary(SessionFactory rawSf) {
        if (this.isExposeTransactionAwareSessionFactory()) {
            return this.getTransactionAwareSessionFactoryProxy(rawSf);
        }
        return rawSf;
    }

    protected SessionFactory getTransactionAwareSessionFactoryProxy(SessionFactory target) {
        Class sfInterface;
        Class clazz = sfInterface = class$org$hibernate$SessionFactory == null ? (class$org$hibernate$SessionFactory = AbstractSessionFactoryBean.class$("org.hibernate.SessionFactory")) : class$org$hibernate$SessionFactory;
        if (target instanceof SessionFactoryImplementor) {
            sfInterface = class$org$hibernate$engine$SessionFactoryImplementor == null ? (class$org$hibernate$engine$SessionFactoryImplementor = AbstractSessionFactoryBean.class$("org.hibernate.engine.SessionFactoryImplementor")) : class$org$hibernate$engine$SessionFactoryImplementor;
        }
        return (SessionFactory)Proxy.newProxyInstance(sfInterface.getClassLoader(), new Class[]{sfInterface}, (InvocationHandler)new TransactionAwareInvocationHandler(target));
    }

    protected final SessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            throw new IllegalStateException("SessionFactory not initialized yet");
        }
        return this.sessionFactory;
    }

    public void destroy() throws HibernateException {
        this.logger.info((Object)"Closing Hibernate SessionFactory");
        this.sessionFactory.close();
    }

    public Object getObject() {
        return this.sessionFactory;
    }

    public Class getObjectType() {
        return this.sessionFactory != null ? this.sessionFactory.getClass() : (class$org$hibernate$SessionFactory == null ? (class$org$hibernate$SessionFactory = AbstractSessionFactoryBean.class$("org.hibernate.SessionFactory")) : class$org$hibernate$SessionFactory);
    }

    public boolean isSingleton() {
        return true;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof HibernateException) {
            return this.convertHibernateAccessException((HibernateException)ex);
        }
        return null;
    }

    protected DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (this.jdbcExceptionTranslator != null && ex instanceof JDBCException) {
            JDBCException jdbcEx = (JDBCException)ex;
            return this.jdbcExceptionTranslator.translate("Hibernate operation: " + jdbcEx.getMessage(), jdbcEx.getSQL(), jdbcEx.getSQLException());
        }
        return SessionFactoryUtils.convertHibernateAccessException(ex);
    }

    protected abstract SessionFactory buildSessionFactory() throws Exception;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TransactionAwareInvocationHandler
    implements InvocationHandler {
        private final SessionFactory target;

        public TransactionAwareInvocationHandler(SessionFactory target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getCurrentSession")) {
                try {
                    return SessionFactoryUtils.doGetSession((SessionFactory)proxy, false);
                }
                catch (IllegalStateException ex) {
                    throw new HibernateException(ex.getMessage());
                }
            }
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

