/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.Menu;
import com.bmc.arsys.api.MenuItem;
import com.bmc.arsys.api.internal.ConversionUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileMenu
extends Menu
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -2906076780489180128L;
    private int m_location;
    private String m_fileName;

    public FileMenu() {
    }

    public FileMenu(int n2, String string) {
        this.m_location = n2;
        this.m_fileName = string;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FileMenu fileMenu = null;
        fileMenu = (FileMenu)super.clone();
        return fileMenu;
    }

    public int getLocation() {
        return this.m_location;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String string) {
        this.m_fileName = string;
        this.m_changeFlags.setParameter(9L, true);
    }

    public void setLocation(int n2) {
        this.m_location = n2;
        this.m_changeFlags.setParameter(9L, true);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FileMenu)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        FileMenu fileMenu = (FileMenu)object;
        return new EqualsBuilder().appendSuper(super.equals(object)).append(this.m_location, fileMenu.m_location).append((Object)this.m_fileName, (Object)fileMenu.m_fileName).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.m_location).append((Object)this.m_fileName).toHashCode();
    }

    @Override
    void fromVariant(Object[] objectArray, ARServerUser aRServerUser) {
        if (objectArray == null) {
            return;
        }
        super.fromVariant(objectArray, aRServerUser);
        objectArray = (Object[])ARTypeMgr.GetAt((Object)objectArray, new int[]{5, 1});
        this.m_location = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)objectArray, 0));
        this.m_fileName = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)objectArray, 1));
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Location", this.m_location).append("File Name", (Object)this.m_fileName).toString();
    }

    protected List<MenuItem> expandMenu(ARServerUser aRServerUser, boolean bl) throws ARException {
        List<MenuItem> list = new ArrayList<MenuItem>();
        Scanner scanner = null;
        List<String> list2 = this.a(aRServerUser, bl);
        if (this.getLocation() == 2) {
            for (String string : list2) {
                try {
                    scanner = new Scanner(new File(string));
                    break;
                }
                catch (Exception exception) {
                    if (!string.equals(this.getFileName())) continue;
                    String string2 = exception.getMessage();
                    throw new ARException(2, 67, string2);
                }
            }
        } else {
            for (String string : list2) {
                try {
                    String string3 = aRServerUser.exportFile(string);
                    if (string3 == null) break;
                    scanner = new Scanner(string3);
                    break;
                }
                catch (ARException aRException) {
                    if (!string.equals(this.getFileName())) continue;
                    throw aRException;
                }
            }
        }
        if (scanner != null) {
            list = MenuItem.bufferToMenuItemList(scanner);
            scanner.close();
        }
        return list;
    }

    private List<String> a(ARServerUser aRServerUser, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        if (bl) {
            arrayList.add(this.getFileName() + "." + aRServerUser.getLocale());
            Scanner scanner = new Scanner(aRServerUser.getLocale()).useDelimiter("_");
            if (scanner.hasNext()) {
                arrayList.add(this.getFileName() + "." + scanner.next());
            }
            scanner.close();
        }
        arrayList.add(this.getFileName());
        return arrayList;
    }
}

