/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.plugins;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.pluginsvr.ARPluginDefinition;
import com.bmc.arsys.pluginsvr.ARPluginServerConfiguration;
import com.bmc.arsys.pluginsvr.PluginGroup;
import com.bmc.arsys.pluginsvr.legacy.CARDBCPlugin;
import com.bmc.arsys.pluginsvr.legacy.CAREAPlugin;
import com.bmc.arsys.pluginsvr.legacy.CARFilterAPIPlugin;
import com.bmc.arsys.pluginsvr.legacy.PluginProxy;
import com.bmc.arsys.pluginsvr.plugins.ARDBCPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARDBCPluginRepository;
import com.bmc.arsys.pluginsvr.plugins.AREAPluggable;
import com.bmc.arsys.pluginsvr.plugins.AREAPluginRepository;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPluginRepository;
import com.bmc.arsys.pluginsvr.plugins.ARPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.pluginsvr.plugins.PluginClassLoader;
import com.bmc.arsys.pluginsvr.plugins.PluginEnvelope;
import com.bmc.arsys.pluginsvr.plugins.TrustedAREAPluggable;
import com.bmc.arsys.utils.CatalogReader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARPluginLoaderRouter {
    private static int mPluginCount = 0;
    private static Logger LOGGER = Logger.getLogger(ARPluginLoaderRouter.class);
    private static HashMap<Long, ARPluginLoaderRouter> MAP_THREAD_PLUGINS = new HashMap();
    private static HashMap<String, URLClassLoader> MAP_PLUGINSET_CLASS_LOADERS = new HashMap();
    private static HashMap<String, URLClassLoader> MAP_PLUGIN_CLASS_LOADERS = new HashMap();
    private static HashMap<String, Class> MAP_PLUGIN_CLASSES = new HashMap();
    public final ARDBCPluginRepository ARDBC = new ARDBCPluginRepository();
    public final AREAPluginRepository AREA = new AREAPluginRepository();
    public final ARFilterAPIPluginRepository FILTERAPI = new ARFilterAPIPluginRepository();

    public static synchronized void addPluginRouter(ARPluginLoaderRouter aRPluginLoaderRouter) {
        MAP_THREAD_PLUGINS.put(Thread.currentThread().getId(), aRPluginLoaderRouter);
    }

    public static synchronized ARPluginLoaderRouter getPluginRouter() {
        return MAP_THREAD_PLUGINS.get(Thread.currentThread().getId());
    }

    public static synchronized void removePluginRouter() {
        ARPluginLoaderRouter aRPluginLoaderRouter = MAP_THREAD_PLUGINS.remove(Thread.currentThread().getId());
        aRPluginLoaderRouter.cleanUpPlugins();
    }

    private static synchronized URLClassLoader getPluginSetClassLoader(String string) {
        return MAP_PLUGINSET_CLASS_LOADERS.get(string);
    }

    private static synchronized void addPluginSetClassLoader(String string, URLClassLoader uRLClassLoader) {
        MAP_PLUGINSET_CLASS_LOADERS.put(string, uRLClassLoader);
    }

    private static synchronized URLClassLoader getPluginClassLoader(String string) {
        return MAP_PLUGIN_CLASS_LOADERS.get(string);
    }

    private static synchronized void addPluginClassLoader(String string, URLClassLoader uRLClassLoader) {
        MAP_PLUGIN_CLASS_LOADERS.put(string, uRLClassLoader);
    }

    private static synchronized void addPluginClass(String string, Class clazz) {
        MAP_PLUGIN_CLASSES.put(string, clazz);
    }

    private static synchronized Class getPluginClass(String string) {
        return MAP_PLUGIN_CLASSES.get(string);
    }

    public static void initializeJavaPlugins() {
        LOGGER.info((Object)"Loading all Java Plugins and Plugin sets");
        String[] stringArray = ARPluginServerConfiguration.getInstance().getCmdLineArgs();
        ArrayList<ARPluginDefinition> arrayList = ARPluginServerConfiguration.getInstance().getConfiguredPlugins();
        ARPluginLoaderRouter.loadAllPlugins(null, arrayList, stringArray);
        HashMap<String, PluginGroup> hashMap = ARPluginServerConfiguration.getInstance().getConfiguredPluginGroups();
        ARPluginLoaderRouter.loadPluginGroups(hashMap, stringArray);
    }

    public static void terminateAllPlugins() {
        if (!ARPluginServerConfiguration.getInstance().getNativePlugins().isEmpty()) {
            try {
                PluginProxy.getInstance().terminateNativePlugins();
            }
            catch (Exception exception) {
                LOGGER.error((Object)CatalogReader.getInstance().getMessage(8794), (Throwable)exception);
            }
        }
        if (!MAP_THREAD_PLUGINS.isEmpty()) {
            Set<Map.Entry<Long, ARPluginLoaderRouter>> set = MAP_THREAD_PLUGINS.entrySet();
            for (ARPluginLoaderRouter aRPluginLoaderRouter : set) {
                try {
                    aRPluginLoaderRouter.cleanUpPlugins();
                }
                catch (Exception exception) {
                    LOGGER.error((Object)CatalogReader.getInstance().getMessage(8794), (Throwable)exception);
                }
            }
        }
    }

    private static void logURLs(URL[] uRLArray) {
        if (uRLArray != null) {
            for (int i = 0; i < uRLArray.length; ++i) {
                LOGGER.info((Object)("URL" + (i + 1) + ": " + uRLArray[i].toString()));
            }
        }
    }

    private static void loadPluginGroups(HashMap<String, PluginGroup> hashMap, String[] stringArray) {
        Set<String> set = hashMap.keySet();
        for (String string : set) {
            URLClassLoader uRLClassLoader;
            PluginGroup pluginGroup;
            block4: {
                LOGGER.info((Object)("Loading Java PluginSet " + string));
                pluginGroup = hashMap.get(string);
                uRLClassLoader = null;
                uRLClassLoader = ARPluginLoaderRouter.getPluginSetClassLoader(string);
                try {
                    if (uRLClassLoader != null) break block4;
                    URL[] uRLArray = ARPluginLoaderRouter.getJarURLs(pluginGroup, true);
                    LOGGER.info((Object)("Number of shared URLs for group " + string + " is " + uRLArray.length));
                    ARPluginLoaderRouter.logURLs(uRLArray);
                    ClassLoader classLoader = null;
                    classLoader = pluginGroup.getParent().equals(ARPluginServerConfiguration.DEFAULT_SET_NAME) ? Thread.currentThread().getContextClassLoader() : ARPluginLoaderRouter.getPluginSetClassLoader(pluginGroup.getParent());
                    uRLClassLoader = new PluginClassLoader(uRLArray, classLoader, pluginGroup.getFolders(), ARPluginServerConfiguration.getInstance().getWorkingDirectory());
                    ARPluginLoaderRouter.addPluginSetClassLoader(string, uRLClassLoader);
                }
                catch (MalformedURLException malformedURLException) {
                    LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Group: " + string), (Throwable)malformedURLException);
                    continue;
                }
                catch (IOException iOException) {
                    LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Group: " + string), (Throwable)iOException);
                    continue;
                }
            }
            LOGGER.info((Object)("Loading all Java Plugins for the group " + string));
            ARPluginLoaderRouter.loadAllPlugins(uRLClassLoader, pluginGroup.getPlugins(), stringArray);
            ARPluginLoaderRouter.loadPluginGroups(pluginGroup.getGroups(), stringArray);
        }
    }

    private static void loadAllPlugins(URLClassLoader uRLClassLoader, ArrayList<ARPluginDefinition> arrayList, String[] stringArray) {
        for (ARPluginDefinition aRPluginDefinition : arrayList) {
            URLClassLoader uRLClassLoader2;
            block4: {
                ClassLoader classLoader = null;
                classLoader = uRLClassLoader == null ? Thread.currentThread().getContextClassLoader() : uRLClassLoader;
                LOGGER.info((Object)("Attempting to load Java Plugin " + aRPluginDefinition.getPluginName()));
                uRLClassLoader2 = ARPluginLoaderRouter.getPluginClassLoader(aRPluginDefinition.getPluginName());
                try {
                    if (uRLClassLoader2 != null) break block4;
                    URL[] uRLArray = ARPluginLoaderRouter.getJarURLs(aRPluginDefinition, true);
                    LOGGER.info((Object)("Number of URLs for plugin " + aRPluginDefinition.getPluginName() + " is " + uRLArray.length));
                    ARPluginLoaderRouter.logURLs(uRLArray);
                    uRLClassLoader2 = new PluginClassLoader(uRLArray, classLoader, aRPluginDefinition.getClassPathFolders(), ARPluginServerConfiguration.getInstance().getWorkingDirectory());
                    ARPluginLoaderRouter.addPluginClassLoader(aRPluginDefinition.getPluginName(), uRLClassLoader2);
                }
                catch (MalformedURLException malformedURLException) {
                    LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + aRPluginDefinition.getPluginName()), (Throwable)malformedURLException);
                    aRPluginDefinition.setActive(false);
                    continue;
                }
                catch (IOException iOException) {
                    LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + aRPluginDefinition.getPluginName()), (Throwable)iOException);
                    aRPluginDefinition.setActive(false);
                    continue;
                }
            }
            ARPluginLoaderRouter.loadClass(uRLClassLoader2, aRPluginDefinition, aRPluginDefinition.getFileName(), aRPluginDefinition.getClassName(), stringArray);
            LOGGER.info((Object)("Succesfully loaded Java Plugin " + aRPluginDefinition.getPluginName()));
        }
    }

    static void loadClass(URLClassLoader uRLClassLoader, ARPluginDefinition aRPluginDefinition, String string, String string2, String[] stringArray) {
        String string3 = aRPluginDefinition.getPluginName();
        try {
            Class clazz = ARPluginLoaderRouter.loadJars(uRLClassLoader, string3, string, string2);
            ARPluginLoaderRouter.addPluginClass(string3, clazz);
        }
        catch (ARException aRException) {
            aRPluginDefinition.setActive(false);
        }
        catch (Throwable throwable) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + aRPluginDefinition.getPluginName()), throwable);
            aRPluginDefinition.setActive(false);
        }
    }

    private static Class loadJars(URLClassLoader uRLClassLoader, String string, String string2, String string3) throws ARException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string3, true, uRLClassLoader);
            try {
                Method method;
                if (clazz != null && (method = clazz.getMethod("init", ARPluginContext.class)) != null) {
                    ARPluginContext aRPluginContext = new ARPluginContext();
                    aRPluginContext.setPluginInfo(new ARPluginInfo(string, 2, true));
                    method.invoke(null, aRPluginContext);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOGGER.info((Object)("No static init routine found, skipping init call - " + string));
            }
            catch (SecurityException securityException) {
                LOGGER.warn((Object)("Exception while finding static init method - " + string), (Throwable)securityException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.warn((Object)("Invocation exception for static init method - " + string), (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.warn((Object)("Illegal Access exception for static init method - " + string), (Throwable)illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.warn((Object)("Illegal argument exception for static init method - " + string), (Throwable)illegalArgumentException);
            }
            catch (Throwable throwable) {
                LOGGER.warn((Object)("Exception in static init method - " + string), throwable);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + string), (Throwable)classNotFoundException);
            throw new ARException(2, 8756, classNotFoundException.getLocalizedMessage());
        }
        catch (ClassCastException classCastException) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + string), (Throwable)classCastException);
            throw new ARException(2, 8756, classCastException.getLocalizedMessage());
        }
        catch (Exception exception) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + string), (Throwable)exception);
            throw new ARException(2, 8756, exception.getLocalizedMessage());
        }
        return clazz;
    }

    private static URL[] getJarURLs(ARPluginDefinition aRPluginDefinition, boolean bl) throws IOException {
        String string;
        Manifest manifest;
        Object object;
        ArrayList<String> arrayList;
        File file = new File(aRPluginDefinition.getFileName());
        JarFile jarFile = new JarFile(file);
        String string2 = ARPluginServerConfiguration.getInstance().getWorkingDirectory();
        File file2 = new File(string2);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        File file3 = new File(file2, "plugin_" + Thread.currentThread().getId() + "_" + mPluginCount++);
        ArrayList<URL> arrayList2 = new ArrayList<URL>();
        arrayList2.add(file.toURI().toURL());
        ArrayList<String> arrayList3 = aRPluginDefinition.getClassPathFolders();
        if (arrayList3 != null) {
            for (int i = 0; i < arrayList3.size(); ++i) {
                File file4 = new File(arrayList3.get(i));
                if (!file4.exists()) continue;
                arrayList2.add(file4.toURI().toURL());
            }
        }
        if ((arrayList = aRPluginDefinition.getClassPathJars()) != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                object = new File(arrayList.get(i));
                if (!((File)object).exists()) continue;
                arrayList2.add(((File)object).toURI().toURL());
            }
        }
        if ((manifest = jarFile.getManifest()) != null && (string = ((Attributes)(object = manifest.getMainAttributes())).getValue(Attributes.Name.CLASS_PATH)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                URL uRL = ARPluginLoaderRouter.getDependentJarURL(jarFile, file3, string3, bl);
                if (uRL == null) continue;
                arrayList2.add(uRL);
            }
        }
        return arrayList2.toArray(new URL[0]);
    }

    private static URL[] getJarURLs(PluginGroup pluginGroup, boolean bl) throws IOException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (pluginGroup != null) {
            ArrayList<String> arrayList2;
            ArrayList<String> arrayList3 = pluginGroup.getClassPathFolders();
            if (arrayList3 != null) {
                for (int i = 0; i < arrayList3.size(); ++i) {
                    File file = new File(arrayList3.get(i));
                    if (!file.exists()) continue;
                    arrayList.add(file.toURI().toURL());
                }
            }
            if ((arrayList2 = pluginGroup.getClassPathJars()) != null) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    File file = new File(arrayList2.get(i));
                    if (!file.exists()) continue;
                    arrayList.add(file.toURI().toURL());
                }
            }
        }
        return arrayList.toArray(new URL[0]);
    }

    private static URL[] getJarURLs(ArrayList<ARPluginDefinition> arrayList, boolean bl) throws IOException {
        ArrayList<URL> arrayList2 = new ArrayList<URL>();
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string;
                Object object;
                ArrayList<String> arrayList3;
                Object object2;
                ARPluginDefinition aRPluginDefinition = arrayList.get(i);
                if (aRPluginDefinition == null) continue;
                File file = new File(aRPluginDefinition.getFileName());
                JarFile jarFile = new JarFile(file);
                String string2 = ARPluginServerConfiguration.getInstance().getWorkingDirectory();
                File file2 = new File(string2);
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                File file3 = new File(file2, "plugin_" + Thread.currentThread().getId() + "_" + mPluginCount++);
                arrayList2.add(file.toURI().toURL());
                ArrayList<String> arrayList4 = aRPluginDefinition.getClassPathFolders();
                if (arrayList4 != null) {
                    for (int j = 0; j < arrayList4.size(); ++j) {
                        object2 = new File(arrayList4.get(j));
                        if (!((File)object2).exists()) continue;
                        arrayList2.add(((File)object2).toURI().toURL());
                    }
                }
                if ((arrayList3 = aRPluginDefinition.getClassPathJars()) != null) {
                    for (int j = 0; j < arrayList3.size(); ++j) {
                        object = new File(arrayList3.get(j));
                        if (!((File)object).exists()) continue;
                        arrayList2.add(((File)object).toURI().toURL());
                    }
                }
                if ((object2 = jarFile.getManifest()) == null || (string = ((Attributes)(object = ((Manifest)object2).getMainAttributes())).getValue(Attributes.Name.CLASS_PATH)) == null) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    URL uRL = ARPluginLoaderRouter.getDependentJarURL(jarFile, file3, string3, bl);
                    if (uRL == null) continue;
                    arrayList2.add(uRL);
                }
            }
        }
        return arrayList2.toArray(new URL[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL getDependentJarURL(JarFile jarFile, File file, String string, boolean bl) throws IOException {
        ZipEntry zipEntry = jarFile.getEntry(string);
        if (zipEntry != null) {
            File file2 = new File(file, string);
            if (bl || !file2.exists()) {
                file2.getParentFile().mkdirs();
                InputStream inputStream = jarFile.getInputStream(zipEntry);
                try {
                    ARPluginLoaderRouter.copyStreamDataToFile(inputStream, file2);
                }
                finally {
                    inputStream.close();
                }
            }
            return file2.toURI().toURL();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStreamDataToFile(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        try {
            int n;
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            bufferedOutputStream.close();
        }
    }

    public ARPluginLoaderRouter() {
        String[] stringArray = ARPluginServerConfiguration.getInstance().getCmdLineArgs();
        ArrayList<ARPluginDefinition> arrayList = ARPluginServerConfiguration.getInstance().getConfiguredPlugins();
        this.instantiateAllPlugins(null, arrayList, stringArray);
        HashMap<String, PluginGroup> hashMap = ARPluginServerConfiguration.getInstance().getConfiguredPluginGroups();
        this.instantiatePluginGroups(hashMap, stringArray);
        ArrayList<ARPluginDefinition> arrayList2 = ARPluginServerConfiguration.getInstance().getNativePlugins();
        this.loadNativePluginWrappers(arrayList2);
    }

    public void initializeInstanceData(ARPluginContext aRPluginContext) {
    }

    public void cleanUpPlugins() {
        ARPluginContext aRPluginContext = new ARPluginContext();
        aRPluginContext.setCmdLineArgs(ARPluginServerConfiguration.getInstance().getCmdLineArgs());
        this.AREA.terminatePlugins(aRPluginContext);
        this.FILTERAPI.terminatePlugins(aRPluginContext);
        this.ARDBC.terminatePlugins(aRPluginContext);
    }

    private void loadNativePluginWrappers(ArrayList<ARPluginDefinition> arrayList) {
        if (PluginProxy.IsNativeMethodAccessible()) {
            for (int i = 0; i < arrayList.size(); ++i) {
                ARPluginDefinition aRPluginDefinition = arrayList.get(i);
                String string = aRPluginDefinition.getPluginCode();
                String string2 = aRPluginDefinition.getPluginType();
                String string3 = aRPluginDefinition.getPluginName();
                if (string == null || !string.equalsIgnoreCase("C")) continue;
                try {
                    PluginEnvelope pluginEnvelope;
                    ARPlugin aRPlugin;
                    if (string2.equalsIgnoreCase("FilterAPI")) {
                        aRPlugin = new CARFilterAPIPlugin(string3);
                        pluginEnvelope = new PluginEnvelope(aRPlugin, new ARPluginInfo(string3, 2, false));
                        this.FILTERAPI.addPlugin(string3, pluginEnvelope);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("ARDBC")) {
                        aRPlugin = new CARDBCPlugin(string3);
                        pluginEnvelope = new PluginEnvelope(aRPlugin, new ARPluginInfo(string3, 4, false));
                        this.ARDBC.addPlugin(string3, pluginEnvelope);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("AREA")) continue;
                    aRPlugin = new CAREAPlugin(string3);
                    pluginEnvelope = new PluginEnvelope(aRPlugin, new ARPluginInfo(string3, 3, false));
                    this.AREA.addPlugin(string3, pluginEnvelope);
                    continue;
                }
                catch (ARException aRException) {
                    LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8767) + " Plugin: " + string3), (Throwable)aRException);
                }
            }
        }
    }

    private void instantiatePluginGroups(HashMap<String, PluginGroup> hashMap, String[] stringArray) {
        Set<String> set = hashMap.keySet();
        for (String string : set) {
            LOGGER.info((Object)("Creating instances of all plugins in the group " + string));
            PluginGroup pluginGroup = hashMap.get(string);
            URLClassLoader uRLClassLoader = null;
            uRLClassLoader = ARPluginLoaderRouter.getPluginSetClassLoader(string);
            if (uRLClassLoader == null) {
                LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Group: " + string));
                continue;
            }
            this.instantiateAllPlugins(uRLClassLoader, pluginGroup.getPlugins(), stringArray);
            this.instantiatePluginGroups(pluginGroup.getGroups(), stringArray);
        }
    }

    private void instantiateAllPlugins(URLClassLoader uRLClassLoader, ArrayList<ARPluginDefinition> arrayList, String[] stringArray) {
        for (ARPluginDefinition aRPluginDefinition : arrayList) {
            if (!aRPluginDefinition.isActive()) continue;
            Class clazz = null;
            LOGGER.info((Object)("Attempting to Create an instance of the plugin " + aRPluginDefinition.getPluginName()));
            URLClassLoader uRLClassLoader2 = ARPluginLoaderRouter.getPluginClassLoader(aRPluginDefinition.getPluginName());
            if (uRLClassLoader2 == null) {
                LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + aRPluginDefinition.getFileName()));
                continue;
            }
            clazz = ARPluginLoaderRouter.getPluginClass(aRPluginDefinition.getPluginName());
            if (clazz == null) {
                LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + aRPluginDefinition.getFileName()));
                continue;
            }
            this.loadPlugin(uRLClassLoader2, clazz, aRPluginDefinition, stringArray);
        }
    }

    void loadPlugin(URLClassLoader uRLClassLoader, Class clazz, ARPluginDefinition aRPluginDefinition, String[] stringArray) {
        String string = aRPluginDefinition.getPluginName();
        try {
            ARPluggable aRPluggable = this.instantiatePlugin(clazz, uRLClassLoader);
            ARPluginInfo aRPluginInfo = new ARPluginInfo(aRPluginDefinition.getPluginName(), aRPluginDefinition.getVersion(), !aRPluginDefinition.getPluginCode().equals("C"));
            PluginEnvelope pluginEnvelope = this.initializePlugin(string, stringArray, aRPluggable, aRPluginInfo);
            if (pluginEnvelope == null) {
                return;
            }
            string = pluginEnvelope.getPluginName();
            if (aRPluggable instanceof ARFilterAPIPluggable) {
                this.FILTERAPI.addPlugin(string, pluginEnvelope);
            } else if (aRPluggable instanceof AREAPluggable) {
                TrustedAREAPluggable trustedAREAPluggable;
                int n;
                if (aRPluggable instanceof TrustedAREAPluggable && (n = (trustedAREAPluggable = (TrustedAREAPluggable)aRPluggable).secretKey()) > 0) {
                    pluginEnvelope.setTrustedAreaPluginFlag(true);
                }
                this.AREA.addPlugin(string, pluginEnvelope);
            } else if (aRPluggable instanceof ARDBCPluggable) {
                this.ARDBC.addPlugin(string, pluginEnvelope);
            }
        }
        catch (ARException aRException) {
            aRPluginDefinition.setActive(false);
        }
        catch (Throwable throwable) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + string), throwable);
            aRPluginDefinition.setActive(false);
        }
        LOGGER.info((Object)("Succesfully created instance of plugin " + aRPluginDefinition.getPluginName()));
    }

    private PluginEnvelope initializePlugin(String string, String[] stringArray, ARPluggable aRPluggable, ARPluginInfo aRPluginInfo) throws ARException {
        assert (aRPluggable != null);
        ARPluginContext aRPluginContext = new ARPluginContext();
        if (aRPluggable == null) {
            return null;
        }
        String string2 = aRPluginInfo.getName();
        aRPluginContext.setCmdLineArgs(stringArray);
        aRPluginContext.setPluginInfo(aRPluginInfo);
        if (string2 != null) {
            PluginEnvelope pluginEnvelope = this.getPluginFromAnyMap(string2);
            Object var8_8 = null;
            if (pluginEnvelope == null) {
                aRPluggable.initialize(aRPluginContext);
                pluginEnvelope = new PluginEnvelope(aRPluggable, aRPluginInfo, var8_8);
                return pluginEnvelope;
            }
        }
        return null;
    }

    private PluginEnvelope getPluginFromAnyMap(String string) {
        PluginEnvelope pluginEnvelope = null;
        pluginEnvelope = this.FILTERAPI.getPlugin(string);
        if (pluginEnvelope != null) {
            return pluginEnvelope;
        }
        pluginEnvelope = this.AREA.getPlugin(string);
        if (pluginEnvelope != null) {
            return pluginEnvelope;
        }
        pluginEnvelope = this.ARDBC.getPlugin(string);
        return pluginEnvelope;
    }

    private ARPluggable instantiatePlugin(Class clazz, URLClassLoader uRLClassLoader) throws ARException {
        ARPluggable aRPluggable = null;
        try {
            aRPluggable = (ARPluggable)clazz.newInstance();
            if (aRPluggable.getClass().getClassLoader() != uRLClassLoader) {
                throw new ARException(2, 8756, "The plugin class " + clazz.getName() + " has been loaded by a parent classloader.\n");
            }
        }
        catch (InstantiationException instantiationException) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + clazz.getName()), (Throwable)instantiationException);
            throw new ARException(2, 8756, instantiationException.getLocalizedMessage());
        }
        catch (ClassCastException classCastException) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + clazz.getName()), (Throwable)classCastException);
            throw new ARException(2, 8756, classCastException.getLocalizedMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + clazz.getName()), (Throwable)illegalAccessException);
            throw new ARException(2, 8756, illegalAccessException.getLocalizedMessage());
        }
        catch (Throwable throwable) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + clazz.getName()), throwable);
            throw new ARException(2, 8756, throwable.getLocalizedMessage());
        }
        return aRPluggable;
    }
}

