/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.DiaryItem;
import com.bmc.arsys.api.Timestamp;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiaryListValue
extends ArrayList<DiaryItem>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -351544304667070934L;
    private String appendedText;
    public static final String AR_DEFN_DIARY_SEP = new String(new char[]{'\u0003'});
    public static final String AR_DEFN_DIARY_COMMA = new String(new char[]{'\u0004'});

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DiaryListValue)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        DiaryListValue diaryListValue = (DiaryListValue)object;
        return new EqualsBuilder().appendSuper(super.equals(object)).append((Object)this.appendedText, (Object)diaryListValue.appendedText).isEquals();
    }

    public static DiaryListValue decode(String string) throws ARException {
        DiaryListValue diaryListValue = new DiaryListValue();
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(AR_DEFN_DIARY_SEP)) {
                if (string2.length() == 0) continue;
                String[] stringArray2 = string2.split(AR_DEFN_DIARY_COMMA);
                if (stringArray2.length >= 3) {
                    String string3 = stringArray2[0];
                    long l2 = Long.parseLong(string3);
                    String string4 = stringArray2[1];
                    String string5 = stringArray2[2];
                    int n2 = stringArray2.length;
                    for (int i2 = 3; i2 < n2; ++i2) {
                        string5 = string5 + AR_DEFN_DIARY_COMMA + stringArray2[i2];
                    }
                    DiaryItem diaryItem = new DiaryItem(string4, string5, new Timestamp(l2));
                    diaryListValue.add(diaryItem);
                    continue;
                }
                throw new ARException(2, 339, string);
            }
        }
        return diaryListValue;
    }

    public String encode() {
        StringBuilder stringBuilder = new StringBuilder();
        for (DiaryItem diaryItem : this) {
            stringBuilder.append(new Long(diaryItem.getTimestamp().getValue()).toString());
            stringBuilder.append(AR_DEFN_DIARY_COMMA);
            stringBuilder.append(diaryItem.getUser());
            stringBuilder.append(AR_DEFN_DIARY_COMMA);
            stringBuilder.append(diaryItem.getText());
            stringBuilder.append(AR_DEFN_DIARY_SEP);
        }
        return stringBuilder.toString();
    }

    @Override
    public Object clone() {
        DiaryListValue diaryListValue = new DiaryListValue();
        try {
            for (DiaryItem diaryItem : this) {
                diaryListValue.add((DiaryItem)diaryItem.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return diaryListValue;
    }

    Object toVariant(ARServerUser aRServerUser) {
        if (this.appendedText != null) {
            return this.appendedText;
        }
        return this.encode();
    }

    public String getAppendedText() {
        return this.appendedText;
    }

    public void setAppendedText(String string) {
        this.appendedText = string;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Appended Text", (Object)this.appendedText).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.appendedText).toHashCode();
    }
}

