/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.javadriver;

import com.bmc.arsys.api.ARBulkException;
import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARQualifierHelper;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ActiveLink;
import com.bmc.arsys.api.ActiveLinkAction;
import com.bmc.arsys.api.ActiveLinkCriteria;
import com.bmc.arsys.api.AlertMessageCriteria;
import com.bmc.arsys.api.AlertMessageInfo;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AssignInfo;
import com.bmc.arsys.api.AuditInfo;
import com.bmc.arsys.api.Container;
import com.bmc.arsys.api.ContainerCriteria;
import com.bmc.arsys.api.ContainerOwner;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.DisplayInstanceMap;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryKey;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.Escalation;
import com.bmc.arsys.api.EscalationCriteria;
import com.bmc.arsys.api.EscalationTimeCriteria;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.FieldCriteria;
import com.bmc.arsys.api.FieldKey;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.FieldMapping;
import com.bmc.arsys.api.Filter;
import com.bmc.arsys.api.FilterAction;
import com.bmc.arsys.api.FilterCriteria;
import com.bmc.arsys.api.Form;
import com.bmc.arsys.api.FormCriteria;
import com.bmc.arsys.api.FormType;
import com.bmc.arsys.api.IARRowIterator;
import com.bmc.arsys.api.IndexInfo;
import com.bmc.arsys.api.LicenseValidInfo;
import com.bmc.arsys.api.LocalizedRequestInfo;
import com.bmc.arsys.api.LocalizedValueCriteria;
import com.bmc.arsys.api.LocalizedValueInfo;
import com.bmc.arsys.api.LoggingInfo;
import com.bmc.arsys.api.Menu;
import com.bmc.arsys.api.MenuCriteria;
import com.bmc.arsys.api.ObjectPropertyMap;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.PermissionInfo;
import com.bmc.arsys.api.ProcessResult;
import com.bmc.arsys.api.ProxyManager;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.Reference;
import com.bmc.arsys.api.RegularForm;
import com.bmc.arsys.api.SQLResult;
import com.bmc.arsys.api.ServerInfoMap;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.SqlMenu;
import com.bmc.arsys.api.StatusHistoryValue;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.StructItemInfo;
import com.bmc.arsys.api.SupportFile;
import com.bmc.arsys.api.SupportFileKey;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.View;
import com.bmc.arsys.api.ViewCriteria;
import com.bmc.arsys.api.ViewDisplayPropertyMap;
import com.bmc.arsys.api.WorkflowLockInfo;
import com.bmc.arsys.demo.javadriver.CommandProcessor;
import com.bmc.arsys.demo.javadriver.Commands;
import com.bmc.arsys.demo.javadriver.InputFile;
import com.bmc.arsys.demo.javadriver.InputReader;
import com.bmc.arsys.demo.javadriver.LocaleCharSet;
import com.bmc.arsys.demo.javadriver.OutputWriter;
import com.bmc.arsys.demo.javadriver.RandomNumberThread;
import com.bmc.arsys.demo.javadriver.RowIterator;
import com.bmc.arsys.demo.javadriver.SyncObject;
import com.bmc.arsys.demo.javadriver.ThreadControlBlock;
import com.bmc.arsys.demo.javadriver.ThreadControlLocalStorage;
import com.bmc.arsys.demo.javadriver.ThreadStartInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaDriver
extends Thread {
    boolean executeCommand = true;
    static int quietMode = 0;
    static int randomNumberSeed;
    static String resultDirectory;
    boolean primaryThread;
    static String[] commandLineArgs;
    static int maxConnectionPerServer;
    static ThreadControlLocalStorage localStorage;
    static RandomNumberThread randomNumberGenerator;
    static CommandProcessor timerCommandProcessor;
    static OutputWriter outputWriter;
    ThreadStartInfo threadStartInfoObject = null;
    static boolean javaDriverOnly;
    static int SUPPRESS_RESULTS;
    static int SUPPRESS_HEADERS;
    static int SUPPRESS_PROMPTS;
    static int SUPPRESS_MENU;
    static int SUPPRESS_ERRORS;
    static int SUPPRESS_WARNINGS;
    static int MAX_NESTED_LOOP_DEPTH;
    static int RAND_MAX;

    void printAuxillaryStatus() {
    }

    public void initCommandProcessing() {
        this.launchRandomNumberThread();
    }

    public void termCommandProcessing() {
    }

    public void beginAPICall() {
    }

    public void endAPICall(List<StatusInfo> list) {
    }

    protected void logResult(List<StatusInfo> list, long l) throws IOException {
    }

    public static int getRandomNumber() {
        if (randomNumberGenerator != null) {
            return randomNumberGenerator.getRandomNumber();
        }
        return 0;
    }

    public void cleanupThreadEnvironment() {
        if (randomNumberGenerator != null) {
            randomNumberGenerator.interrupt();
        }
        randomNumberGenerator.setWaitObjToNull();
        randomNumberGenerator = null;
    }

    public void setThreadStartInfo(ThreadStartInfo threadStartInfo) {
        this.threadStartInfoObject = threadStartInfo;
    }

    public ARServerUser getControlStructObject() {
        ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
        return threadControlBlock.getContext();
    }

    public void launchRandomNumberThread() {
        randomNumberGenerator = new RandomNumberThread(randomNumberSeed);
        randomNumberGenerator.start();
    }

    public static ThreadControlBlock getThreadControlBlockPtr() {
        if (localStorage == null) {
            return null;
        }
        return (ThreadControlBlock)localStorage.get();
    }

    public void setPrimaryThread(boolean bl) {
        this.primaryThread = bl;
    }

    public boolean isPrimaryThread() {
        return this.primaryThread;
    }

    public void setCommandLineArgs(String[] stringArray) {
        commandLineArgs = stringArray;
    }

    public String[] getCommandLineArgs() {
        return commandLineArgs;
    }

    public static void setResultDirectory(String string) {
        resultDirectory = string;
    }

    public static String getResultDirectory() {
        return resultDirectory;
    }

    public static void setQuietMode(int n) {
        quietMode = n;
    }

    public static int getQuietMode() {
        return quietMode;
    }

    public static void setRandomNumberSeed(int n) {
        randomNumberSeed = n;
    }

    public static int getRandomNumberSeed() {
        return randomNumberSeed;
    }

    int getNextCommand(StringBuilder stringBuilder) throws IOException {
        ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
        threadControlBlock.args = null;
        outputWriter.driverPrintPrompt("\nCommand: ");
        int n = -99;
        while (n == -99) {
            String string;
            InputReader.getInputLine();
            String string2 = string = threadControlBlock.getBuffer();
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != ' ') continue;
                char[] cArray = new char[string.length() - i - 1];
                string.getChars(i + 1, string.length(), cArray, 0);
                String string3 = new String(cArray);
                threadControlBlock.setArgs(string3);
                char[] cArray2 = new char[i];
                string.getChars(0, i, cArray2, 0);
                string2 = new String(cArray2);
                break;
            }
            if (string2.length() == 0 || string2.charAt(0) == '#') {
                outputWriter.driverPrintPrompt("\nCommand: ");
                continue;
            }
            if (string2.length() > 6) {
                outputWriter.driverPrintError(" ***Command too long, unrecognized ****\n");
                outputWriter.driverPrintPrompt("\nCommand: ");
                continue;
            }
            if (string2.equals("h") || string2.equals("?")) {
                outputWriter.driverPrintHelp();
                outputWriter.driverPrintPrompt("\nCommand: ");
                continue;
            }
            if (string2.equals("e") || string2.equals("q") || string2.equals("x")) {
                n = -1;
                continue;
            }
            n = Commands.getCommandCode(string2);
            if (n != -2) {
                threadControlBlock.setCurrentCommand(string2);
                continue;
            }
            outputWriter.driverPrintError(" *** Command not recognized ***\n");
            outputWriter.driverPrintPrompt("\nCommand: ");
        }
        if (threadControlBlock.args != null && threadControlBlock.args.length() > 0 && !threadControlBlock.args.equals("null")) {
            stringBuilder.append(threadControlBlock.args);
        }
        return n;
    }

    public void processCommands() throws IOException {
        int n = -1;
        StringBuilder stringBuilder = new StringBuilder();
        block153: while ((n = this.getNextCommand(stringBuilder)) != -1) {
            String string = stringBuilder.toString().length() > 0 ? stringBuilder.toString() : null;
            stringBuilder = new StringBuilder();
            switch (n) {
                case 0: {
                    this.getARServerUser();
                    continue block153;
                }
                case 1: {
                    this.getEntry();
                    continue block153;
                }
                case 2: {
                    this.setEntry();
                    continue block153;
                }
                case 3: {
                    this.createEntry();
                    continue block153;
                }
                case 4: {
                    this.deleteEntry();
                    continue block153;
                }
                case 5: {
                    this.getListEntry();
                    continue block153;
                }
                case 83: 
                case 999: {
                    this.getListEntryWithFields();
                    continue block153;
                }
                case 138: {
                    this.getListEntryBlocks();
                    continue block153;
                }
                case 6: {
                    this.getFilter();
                    continue block153;
                }
                case 7: {
                    this.setFilter();
                    continue block153;
                }
                case 8: {
                    this.createFilter();
                    continue block153;
                }
                case 9: {
                    this.deleteFilter();
                    continue block153;
                }
                case 10: {
                    this.getListFilter();
                    continue block153;
                }
                case 152: {
                    this.getMultipleFilters();
                    continue block153;
                }
                case 51: {
                    this.getEscalation();
                    continue block153;
                }
                case 52: {
                    this.setEscalation();
                    continue block153;
                }
                case 53: {
                    this.createEscalation();
                    continue block153;
                }
                case 54: {
                    this.deleteEscalation();
                    continue block153;
                }
                case 55: {
                    this.getListEscalation();
                    continue block153;
                }
                case 153: {
                    this.getMultipleEscalations();
                    continue block153;
                }
                case 11: {
                    this.getListGroup();
                    continue block153;
                }
                case 12: {
                    this.getForm();
                    continue block153;
                }
                case 13: {
                    this.setForm();
                    continue block153;
                }
                case 14: {
                    this.createForm();
                    continue block153;
                }
                case 15: {
                    this.deleteForm();
                    continue block153;
                }
                case 16: {
                    this.getListForm();
                    continue block153;
                }
                case 17: {
                    this.getMultipleForms();
                    continue block153;
                }
                case 18: {
                    this.getField();
                    continue block153;
                }
                case 19: {
                    this.setField();
                    continue block153;
                }
                case 20: {
                    this.createField();
                    continue block153;
                }
                case 21: {
                    this.deleteField();
                    continue block153;
                }
                case 22: {
                    this.getListField();
                    continue block153;
                }
                case 23: {
                    this.getCharMenu();
                    continue block153;
                }
                case 24: {
                    this.setCharMenu();
                    continue block153;
                }
                case 25: {
                    this.createCharMenu();
                    continue block153;
                }
                case 26: {
                    this.deleteCharMenu();
                    continue block153;
                }
                case 27: {
                    this.getListCharMenu();
                    continue block153;
                }
                case 151: {
                    this.getMultipleCharMenu();
                    continue block153;
                }
                case 63: {
                    this.getVUI();
                    continue block153;
                }
                case 64: {
                    this.setVUI();
                    continue block153;
                }
                case 65: {
                    this.createVUI();
                    continue block153;
                }
                case 66: {
                    this.deleteVUI();
                    continue block153;
                }
                case 67: {
                    this.getListVUI();
                    continue block153;
                }
                case 28: {
                    this.export();
                    continue block153;
                }
                case 29: {
                    this.arImport();
                    continue block153;
                }
                case 30: {
                    this.getServerInfo();
                    continue block153;
                }
                case 31: {
                    this.verifyUser();
                    continue block153;
                }
                case 32: {
                    this.openInputFile(string);
                    continue block153;
                }
                case 33: {
                    this.openOutputFile();
                    continue block153;
                }
                case 34: {
                    this.closeOutputFile();
                    continue block153;
                }
                case 35: {
                    this.startRecording();
                    continue block153;
                }
                case 36: {
                    this.stopRecording();
                    continue block153;
                }
                case 75: {
                    this.launchThread(false);
                    continue block153;
                }
                case 76: {
                    this.launchThread(true);
                    continue block153;
                }
                case 77: {
                    timerCommandProcessor.releaseWaitingThreads();
                    continue block153;
                }
                case 78: {
                    timerCommandProcessor.sleepTimer();
                    continue block153;
                }
                case 79: {
                    timerCommandProcessor.randomSleepTimer();
                    continue block153;
                }
                case 80: {
                    timerCommandProcessor.millisecondSleepTimer();
                    continue block153;
                }
                case 81: {
                    this.beginLoop();
                    continue block153;
                }
                case 82: {
                    this.endLoop();
                    continue block153;
                }
                case 38: {
                    continue block153;
                }
                case 39: {
                    this.termination();
                    continue block153;
                }
                case 40: {
                    this.getActiveLink();
                    continue block153;
                }
                case 41: {
                    this.setActiveLink();
                    continue block153;
                }
                case 42: {
                    this.createActiveLink();
                    continue block153;
                }
                case 43: {
                    this.deleteActiveLink();
                    continue block153;
                }
                case 44: {
                    this.getListActiveLink();
                    continue block153;
                }
                case 45: {
                    this.getMultipleActiveLinks();
                    continue block153;
                }
                case 46: {
                    this.mergeEntry();
                    continue block153;
                }
                case 47: {
                    this.getQualifier();
                    continue block153;
                }
                case 48: {
                    this.expandCharMenu();
                    continue block153;
                }
                case 49: {
                    this.setServerInfo();
                    continue block153;
                }
                case 50: {
                    this.getListUser();
                    continue block153;
                }
                case 56: {
                    this.getEntryStatistics();
                    continue block153;
                }
                case 59: {
                    this.getServerStatistics();
                    continue block153;
                }
                case 60: {
                    this.getListSQL();
                    continue block153;
                }
                case 61: {
                    this.deleteMultipleFields();
                    continue block153;
                }
                case 62: {
                    this.executeProcess();
                    continue block153;
                }
                case 68: {
                    this.setServerPort();
                    continue block153;
                }
                case 69: {
                    this.getMultipleEntries();
                    continue block153;
                }
                case 70: {
                    this.getSupportFile();
                    continue block153;
                }
                case 71: {
                    this.setSupportFile();
                    continue block153;
                }
                case 72: {
                    this.createSupportFile();
                    continue block153;
                }
                case 73: {
                    this.deleteSupportFile();
                    continue block153;
                }
                case 74: {
                    this.getListSupportFile();
                    continue block153;
                }
                case 84: {
                    this.getEntryBLOB();
                    continue block153;
                }
                case 85: {
                    this.getContainer();
                    continue block153;
                }
                case 86: {
                    this.setContainer();
                    continue block153;
                }
                case 87: {
                    this.createContainer();
                    continue block153;
                }
                case 88: {
                    this.deleteContainer();
                    continue block153;
                }
                case 89: {
                    this.getListContainer();
                    continue block153;
                }
                case 90: {
                    this.getMultipleContainers();
                    continue block153;
                }
                case 91: {
                    this.getTextForErrorMessage();
                    continue block153;
                }
                case 92: {
                    this.setLogging();
                    continue block153;
                }
                case 93: {
                    continue block153;
                }
                case 94: {
                    continue block153;
                }
                case 95: {
                    continue block153;
                }
                case 96: {
                    this.getMultipleFields();
                    continue block153;
                }
                case 98: {
                    this.getLocalizedValue();
                    continue block153;
                }
                case 119: {
                    this.getMultipleLocalizedValues();
                    continue block153;
                }
                case 97: {
                    this.getListFormWithAlias();
                    continue block153;
                }
                case 99: {
                    this.createAlertEvent();
                    continue block153;
                }
                case 100: {
                    this.registerForAlerts();
                    continue block153;
                }
                case 101: {
                    this.deregisterForAlerts();
                    continue block153;
                }
                case 102: {
                    this.getListAlertUser();
                    continue block153;
                }
                case 103: {
                    this.getAlertCount();
                    continue block153;
                }
                case 104: {
                    this.decodeAlertMessage();
                    continue block153;
                }
                case 105: {
                    this.encodeARQualifierStruct();
                    continue block153;
                }
                case 106: {
                    this.decodeARQualifierStruct();
                    continue block153;
                }
                case 107: {
                    this.encodeARAssignStruct();
                    continue block153;
                }
                case 108: {
                    this.decodeARAssignStruct();
                    continue block153;
                }
                case 109: {
                    this.encodeStatusHistory();
                    continue block153;
                }
                case 110: {
                    this.encodeDiary();
                    continue block153;
                }
                case 111: {
                    continue block153;
                }
                case 112: {
                    continue block153;
                }
                case 113: {
                    continue block153;
                }
                case 114: {
                    this.validateLicense();
                    continue block153;
                }
                case 115: {
                    this.validateMultipleLicenses();
                    continue block153;
                }
                case 116: {
                    this.getListLicense();
                    continue block153;
                }
                case 117: {
                    continue block153;
                }
                case 118: {
                    continue block153;
                }
                case 120: {
                    this.getListSQLForActiveLink();
                    continue block153;
                }
                case 121: {
                    this.executeProcessForActiveLink();
                    continue block153;
                }
                case 122: {
                    continue block153;
                }
                case 123: {
                    this.getSessionConfiguration();
                    continue block153;
                }
                case 124: {
                    this.setSessionConfiguration();
                    continue block153;
                }
                case 125: {
                    continue block153;
                }
                case 126: {
                    continue block153;
                }
                case 127: {
                    this.xmlCreateEntry();
                    continue block153;
                }
                case 128: {
                    this.xmlGetEntry();
                    continue block153;
                }
                case 129: {
                    this.xmlSetEntry();
                    continue block153;
                }
                case 132: {
                    this.getMultipleCurrencyRatioSets();
                    continue block153;
                }
                case 133: {
                    this.getCurrencyRatio();
                    continue block153;
                }
                case 130: {
                    continue block153;
                }
                case 131: {
                    this.setClientType();
                    continue block153;
                }
                case 134: {
                    this.getMultipleEntryPoints();
                    continue block153;
                }
                case 135: {
                    this.getListRole();
                    continue block153;
                }
                case 136: {
                    this.beginBulkEntryTransaction();
                    continue block153;
                }
                case 137: {
                    this.endBulkEntryTransaction();
                    continue block153;
                }
                case 139: {
                    this.dumpProxyInfo();
                    continue block153;
                }
                case 140: {
                    this.setUseConnectionPooling();
                    continue block153;
                }
                case 150: {
                    this.setConnectionLimitPerServer();
                    continue block153;
                }
                case 141: {
                    this.setImpersonatedUser();
                    continue block153;
                }
                case 142: {
                    this.getServerCharSet();
                    continue block153;
                }
                case 143: {
                    this.beginApiRecording();
                    continue block153;
                }
                case 144: {
                    this.stopApiRecording();
                    continue block153;
                }
                case 145: {
                    this.executeService();
                    continue block153;
                }
                case 146: {
                    this.getListApplicationState();
                    continue block153;
                }
                case 147: {
                    this.getApplicationState();
                    continue block153;
                }
                case 148: {
                    this.setApplicationState();
                    continue block153;
                }
                case 149: {
                    this.xmlExecuteService();
                    continue block153;
                }
            }
            outputWriter.driverPrintNotSupportCommand(n);
        }
    }

    void setClientType() {
        this.getControlStructObject().setClientType(3);
    }

    boolean processCommandLine() {
        String[] stringArray = this.getCommandLineArgs();
        int n = 0;
        String string = null;
        ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
        int n2 = 0;
        if (stringArray != null) {
            n2 = stringArray.length;
        }
        block20: for (int i = 0; i < n2; ++i) {
            if (stringArray[i].charAt(0) != '-' || stringArray[i].charAt(1) != 'u' && stringArray[i].charAt(1) != 'p' && stringArray[i].charAt(1) != 'l' && stringArray[i].charAt(1) != 's' && stringArray[i].charAt(1) != 'x' && stringArray[i].charAt(1) != 'o' && stringArray[i].charAt(1) != 'd' && stringArray[i].charAt(1) != 'q' && stringArray[i].charAt(1) != 'g' && stringArray[i].charAt(1) != 'c' && stringArray[i].charAt(1) != 'a') {
                outputWriter.driverPrintError("Unrecognized option " + stringArray[i] + "\n");
                return false;
            }
            char c = stringArray[i].charAt(1);
            if (stringArray[i].length() > 2) {
                int n3 = stringArray[i].length() - 2;
                char[] cArray = new char[n3];
                stringArray[i].getChars(2, stringArray[i].length(), cArray, 0);
                string = new String(cArray);
            } else if (++i < n2) {
                string = stringArray[i];
            } else {
                outputWriter.driverPrintError("Missing value for -" + c + "  option\n");
                return false;
            }
            switch (c) {
                case 'a': 
                case 'l': 
                case 'p': 
                case 's': 
                case 'u': {
                    n = 254;
                    break;
                }
                case 'd': 
                case 'x': {
                    n = 255;
                    break;
                }
                case 'o': 
                case 'q': {
                    n = 3;
                    break;
                }
                case 'g': {
                    n = 10;
                    break;
                }
                case 'c': {
                    n = 5;
                }
            }
            if (string.length() > n) {
                outputWriter.driverPrintError("Value for -" + c + "  option is too long: " + string + "\n");
                return false;
            }
            char[] cArray = null;
            switch (c) {
                case 'u': {
                    boolean bl = false;
                    int n4 = 0;
                    for (n4 = 0; n4 < string.length(); ++n4) {
                        if (string.charAt(n4) != '\\') continue;
                        cArray = new char[n4];
                        string.getChars(0, n4, cArray, 0);
                        threadControlBlock.setAuthentication(new String(cArray));
                        bl = true;
                        break;
                    }
                    if (bl) {
                        int n5 = string.length() - n4 - 1;
                        cArray = new char[n5];
                        string.getChars(n4 + 1, string.length(), cArray, 0);
                        threadControlBlock.setUser(new String(cArray));
                        continue block20;
                    }
                    threadControlBlock.setUser(string);
                    continue block20;
                }
                case 'a': {
                    threadControlBlock.setAuthentication(string);
                    continue block20;
                }
                case 'p': {
                    threadControlBlock.setPassword(string);
                    continue block20;
                }
                case 'l': {
                    threadControlBlock.setLocale(string);
                    continue block20;
                }
                case 's': {
                    threadControlBlock.setServer(string);
                    continue block20;
                }
                case 'x': {
                    this.openInputFile(string);
                    continue block20;
                }
                case 'o': {
                    this.setOutputSetting(string);
                    continue block20;
                }
                case 'd': {
                    resultDirectory = string;
                    continue block20;
                }
                case 'q': {
                    quietMode = new Integer(string);
                    continue block20;
                }
                case 'g': {
                    randomNumberSeed = new Integer(string);
                    continue block20;
                }
                case 'c': {
                    this.setOutputCount(string);
                }
            }
        }
        return true;
    }

    protected void setOutputSetting(String string) {
        ProxyManager.setConnectionLimits((int)maxConnectionPerServer);
    }

    protected void setOutputCount(String string) {
    }

    void getARServerUser() {
        try {
            InputReader.getARServerUser();
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            outputWriter.printString("Bad User or Password...\n");
        }
    }

    void openInputFile(String string) {
        try {
            InputReader.openInputFile(string);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
    }

    void closeOutputFile() {
        outputWriter.closeOutputFile();
    }

    void openOutputFile() {
        try {
            String string = InputReader.getString("Filename of output file (): ", "");
            outputWriter.openOutputFile(string);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
    }

    void startRecording() {
        String string = null;
        try {
            ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
            if (threadControlBlock.getRecordFile() != null) {
                outputWriter.driverPrintWarning(" **** Recording already active; stop previous to start new\n");
            } else {
                string = InputReader.getString("Filename of record file (): ", "");
                if (string == null || string.length() == 0) {
                    outputWriter.driverPrintError(" **** No filename specified so no recording started\n");
                } else {
                    threadControlBlock.setRecordFile(new PrintWriter(new FileOutputStream(new File(string))));
                }
            }
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...or opening the file " + string + "  .\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
    }

    void stopRecording() {
        try {
            ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
            if (threadControlBlock.getRecordFile() == null) {
                outputWriter.driverPrintWarning(" **** Recording is not active\n");
            } else {
                threadControlBlock.setRecordFile(null);
            }
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
    }

    void beginLoop() {
        try {
            outputWriter.driverPrintHeader("BEGIN LOOP");
            ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
            if (threadControlBlock.isCurrentInputSourceStdInput()) {
                outputWriter.driverPrintError("\n*** Command must be issued from input file\n");
                return;
            }
            int n = InputReader.getInt("Number of iterations (1): ", 1);
            if (n <= 0) {
                n = 1;
            }
            if (threadControlBlock.getCurrentLoopDepth() == MAX_NESTED_LOOP_DEPTH - 1) {
                outputWriter.driverPrintError("\n*** Maximum nested loop depth exceeded\n");
                threadControlBlock.incrementNumFailedBeginLoop();
                return;
            }
            threadControlBlock.incrementCurrentLoopDepth();
            threadControlBlock.setNumberOfIterations(threadControlBlock.getCurrentLoopDepth(), n);
            threadControlBlock.setLoopBeginFilePos(threadControlBlock.getCurrentLoopDepth(), threadControlBlock.getCurrentInputFilePos());
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
    }

    void endLoop() throws IOException, FileNotFoundException {
        try {
            outputWriter.driverPrintHeader("END LOOP");
            ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
            if (threadControlBlock.isCurrentInputSourceStdInput()) {
                outputWriter.driverPrintError("\n*** Command must be issued from input file\n");
                return;
            }
            if (threadControlBlock.getCurrentLoopDepth() < 0) {
                outputWriter.driverPrintWarning("\n*** Command ignored because no corresponding begin loop issued\n");
                return;
            }
            if (threadControlBlock.getNumFailedBeginLoop() > 0) {
                outputWriter.driverPrintWarning("\n*** Command ignored because previous begin loop failed\n");
                threadControlBlock.reduceNumFailedBeginLoop();
                return;
            }
            long l = threadControlBlock.getNumberOfIterations(threadControlBlock.getCurrentLoopDepth());
            threadControlBlock.reduceNumberOfIterations(threadControlBlock.getCurrentLoopDepth());
            if (l - 1L > 0L) {
                int n = threadControlBlock.getCurrentLoopDepth();
                long l2 = threadControlBlock.getLoopBeginFilePos(n);
                threadControlBlock.setCurrentInputFileReadingPostion(l2);
            } else {
                threadControlBlock.reduceCurrentLoopDepth();
            }
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
    }

    void setLogging() {
        try {
            boolean bl = InputReader.getBooleanForChangingInfo("enable logging? (T):", true);
            long l = 0L;
            long l2 = 0L;
            String string = null;
            if (bl) {
                l = InputReader.getLong("Logging Type NONE(0), SQL(1), Filter(2), API(16)? (0): ", 0L);
                l2 = InputReader.getLong("Return logging records to file(1), status list(2)? (1): ", 1L);
                if ((int)(l2 & 1L) == 1) {
                    string = InputReader.getString("Name of file to hold returned records: ", "");
                }
            }
            LoggingInfo loggingInfo = new LoggingInfo(bl, l, l2, string);
            this.getControlStructObject().setLogging(loggingInfo);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void createForm() {
        try {
            Object object;
            outputWriter.driverPrintHeader("CREATE SCHEMA");
            Form form = InputReader.getForm();
            String string = InputReader.getString("Form Name: ");
            form.setName(string);
            List<PermissionInfo> list = InputReader.getPermissionInfoList(false);
            form.setPermissions(list);
            outputWriter.driverPrintHeader("Ids of sub admin groups allowed to access form:");
            List<Integer> list2 = InputReader.getIntegerList();
            form.setAdminGrpList(list2);
            List<EntryListFieldInfo> list3 = InputReader.getEntryListFieldInfoList();
            form.setEntryListFieldInfo(list3);
            List<SortInfo> list4 = InputReader.getSortInfoList();
            form.setSortInfo(list4);
            List<IndexInfo> list5 = InputReader.getIndexInfoList();
            form.setIndexInfo(list5);
            if (InputReader.getBooleanForChangingInfo("Change archive info? (F): ", false)) {
                object = InputReader.getArchiveInfo();
                form.setArchiveInfo(object);
            }
            if (InputReader.getBooleanForChangingInfo("Change audit info? (F): ", false)) {
                object = InputReader.getAuditInfo();
                form.setAuditInfo((AuditInfo)object);
            }
            object = InputReader.getString("   Default VUI  ");
            form.setDefaultVUI((String)object);
            String string2 = InputReader.getString("Help Text:", "");
            form.setHelpText(string2);
            String string3 = InputReader.getString("Owner");
            form.setOwner(string3);
            String string4 = InputReader.getString("Change DiaryList:", "");
            form.appendDiaryText(string4);
            ObjectPropertyMap objectPropertyMap = InputReader.getObjectPropertyMap();
            form.setProperties(objectPropertyMap);
            this.beginAPICall();
            this.getControlStructObject().createForm(form);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list6 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Create Form Status", list6);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void deleteForm() {
        try {
            outputWriter.driverPrintHeader("DELETE SCHEMA");
            String string = InputReader.getString("Form Name: ");
            int n = InputReader.getInt("Delete option ? ( 0, 1, 2 ) ( 0 ):", 0);
            this.beginAPICall();
            this.getControlStructObject().deleteForm(string, n);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Delete Form Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getForm() {
        try {
            String string = InputReader.getString("Form Name:", "");
            FormCriteria formCriteria = new FormCriteria();
            formCriteria.setRetrieveAll(true);
            this.beginAPICall();
            Form form = this.getControlStructObject().getForm(string, formCriteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printForm("", "Form Information...", form);
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Form Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getMultipleForms() {
        try {
            long l = InputReader.getLong("Get All changed since, as UNIX epoch (0): ", 0L);
            FormType formType = InputReader.getFormType();
            boolean bl = InputReader.getBooleanForChangingInfo("Include hidden forms (T):", true);
            if (bl && formType != null) {
                formType.setHiddenIncrement();
            }
            outputWriter.driverPrintPrompt("Ids of fields, which must be on the form:\n");
            int[] nArray = InputReader.getIntArray();
            this.beginAPICall();
            FormCriteria formCriteria = new FormCriteria();
            formCriteria.setRetrieveAll(true);
            List list = null;
            if (formType != null) {
                list = this.getControlStructObject().getListFormObjects(l, formType.toInt(), null, nArray, formCriteria);
            }
            this.endAPICall(this.getControlStructObject().getLastStatus());
            if (list != null) {
                outputWriter.print("", "Total number of forms: ", list.size());
                for (int i = 0; i < list.size(); ++i) {
                    Form form = (Form)list.get(i);
                    outputWriter.print("    ", "Form: ", form);
                }
            }
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetListForm Status", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListForm() {
        try {
            long l = InputReader.getLong("Get All changed since, as UNIX epoch (0): ", 0L);
            FormType formType = InputReader.getFormType();
            boolean bl = InputReader.getBooleanForChangingInfo("Include hidden forms (T):", true);
            String string = null;
            string = formType != null && (formType.equals((Object)FormType.UPLINK) || formType.equals((Object)FormType.DOWNLINK)) ? InputReader.getString("Form name (): ", "") : "";
            if (bl) {
                formType.setHiddenIncrement();
            }
            outputWriter.driverPrintPrompt("Ids of fields, which must be on the form:\n");
            int[] nArray = InputReader.getIntArray();
            outputWriter.driverPrintPrompt("list of props to search for:\n");
            ObjectPropertyMap objectPropertyMap = InputReader.getObjectPropertyMap();
            this.beginAPICall();
            List list = this.getControlStructObject().getListForm(l, formType.toInt(), string, nArray, objectPropertyMap);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Schama name List: ", list);
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetListForm Status", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void setForm() {
        try {
            Object object;
            RegularForm regularForm = new RegularForm();
            if (InputReader.getBooleanForChangingInfo("Change compound form info? (F): ", false)) {
                regularForm = InputReader.getForm();
            }
            String string = InputReader.getString("Form Name: ");
            regularForm.setName(string);
            if (InputReader.getBooleanForChangingInfo("Change form name? (F): ", false)) {
                object = InputReader.getString("Form name: ");
                regularForm.setNewName((String)object);
            }
            if (InputReader.getBooleanForChangingInfo("Change group list? (F): ", false)) {
                object = InputReader.getPermissionInfoList(true);
                regularForm.setPermissions((List)object);
            }
            if (InputReader.getBooleanForChangingInfo("Change sub admin group list? (F): ", false)) {
                outputWriter.driverPrintHeader("Ids of sub admin groups allowed to access form:");
                object = InputReader.getIntegerList();
                regularForm.setAdminGrpList(object);
            }
            if (InputReader.getBooleanForChangingInfo("Change query list fields? (F): ", false)) {
                object = InputReader.getEntryListFieldInfoList();
                regularForm.setEntryListFieldInfo(object);
            }
            if (InputReader.getBooleanForChangingInfo("Change sort list? (F): ", false)) {
                object = InputReader.getSortInfoList();
                regularForm.setSortInfo(object);
            }
            if (InputReader.getBooleanForChangingInfo("Change index list? (F): ", false)) {
                object = InputReader.getIndexInfoList();
                regularForm.setIndexInfo(object);
            }
            if (InputReader.getBooleanForChangingInfo("Change archive info? (F): ", false)) {
                object = InputReader.getArchiveInfo();
                regularForm.setArchiveInfo(object);
            }
            if (InputReader.getBooleanForChangingInfo("Change audit info? (F): ", false)) {
                object = InputReader.getAuditInfo();
                regularForm.setAuditInfo((AuditInfo)object);
            }
            if (InputReader.getBoolean("Change default VUI? (F): ", false)) {
                object = InputReader.getString("   Default VUI  ");
                regularForm.setDefaultVUI((String)object);
            }
            if (InputReader.getBooleanForChangingInfo("Change help text? (F): ", false)) {
                object = InputReader.getString("Help Text (): ", "");
                regularForm.setHelpText((String)object);
            }
            if (InputReader.getBooleanForChangingInfo("Change owner? (F): ", false)) {
                object = InputReader.getString("New Owner");
                regularForm.setOwner((String)object);
            }
            if (InputReader.getBooleanForChangingInfo("Add to change diary? (F): ", false)) {
                object = InputReader.getString("Change DiaryList (): ", "");
                regularForm.appendDiaryText((String)object);
            }
            if (InputReader.getBooleanForChangingInfo("Change object properties? (F): ", false)) {
                object = InputReader.getObjectPropertyMap();
                regularForm.setProperties((ObjectPropertyMap)object);
            }
            this.beginAPICall();
            this.getControlStructObject().setForm((Form)regularForm);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            object = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Form Status", (List)object);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getEntry() {
        try {
            outputWriter.driverPrintHeader("GET ENTRY");
            EntryKey entryKey = this.getAndConvertEntryKey();
            int[] nArray = InputReader.getIntArray();
            this.beginAPICall();
            Entry entry = this.getControlStructObject().getEntry(entryKey.getFormName(), entryKey.getEntryID(), nArray);
            List list = this.getControlStructObject().getLastStatus();
            this.endAPICall(list);
            outputWriter.printEntry("", "Entry Information:", entry);
            List list2 = this.getControlStructObject().getLastStatus();
            list.addAll(list.size(), list2);
            outputWriter.printStatusInfoList("", "Get Entry Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    protected EntryKey getAndConvertEntryKey() throws IOException {
        return InputReader.getEntryKey();
    }

    void setEntry() {
        try {
            outputWriter.driverPrintHeader("SET  ENTRY");
            EntryKey entryKey = InputReader.getEntryKey();
            outputWriter.driverPrintPrompt("Field/value pairs to set:\n");
            Entry entry = InputReader.getEntry();
            Timestamp timestamp = new Timestamp(InputReader.getLong("Time of Get operation (0): ", 0L));
            int n = InputReader.getInt("SetEntry option ? (0): ", 0);
            this.beginAPICall();
            this.getControlStructObject().setEntry(entryKey.getFormName(), entryKey.getEntryID(), entry, timestamp, n);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "SetEntry Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input for set entry...\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    public void createEntry() {
        Entry entry = null;
        try {
            outputWriter.driverPrintHeader("CREATE ENTRY");
            String string = InputReader.getString("Form Name: ");
            outputWriter.driverPrintHeader("Field/value pairs to create:");
            entry = InputReader.getEntry();
            this.beginAPICall();
            this.getControlStructObject().createEntry(string, entry);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printString("Entry id: " + entry.getEntryId());
            outputWriter.printNewLine();
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Create Entry Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void executeService() {
        try {
            outputWriter.driverPrintHeader("EXECUTE SERVICE");
            String string = InputReader.getString("Form Name: ");
            String string2 = InputReader.getString("Entry ID:", null);
            outputWriter.driverPrintPrompt("Field/value pairs to set:\n");
            Entry entry = InputReader.getEntry();
            int[] nArray = InputReader.getIntArray();
            this.beginAPICall();
            entry = this.getControlStructObject().executeService(string, string2, entry, nArray);
            List list = this.getControlStructObject().getLastStatus();
            this.endAPICall(list);
            outputWriter.printEntry("", "Entry Information:", entry);
            outputWriter.printStatusInfoList("", "executeService Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input for executeService input entry...\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void xmlExecuteService() {
        try {
            outputWriter.driverPrintHeader("XML EXECUTE SERVICE");
            String string = InputReader.getFileContent("Filename containing XML query mapping: ", null, 3, outputWriter);
            if (string == null) {
                return;
            }
            String string2 = InputReader.getFileContent("Filename containing XML query document: ", null, 3, outputWriter);
            if (string2 == null) {
                return;
            }
            String string3 = InputReader.getFileContent("Filename containing XML input mapping: ", null, 3, outputWriter);
            if (string3 == null) {
                return;
            }
            String string4 = InputReader.getFileContent("Filename containing XML input document: ", null, 3, outputWriter);
            if (string4 == null) {
                return;
            }
            String string5 = InputReader.getFileContent("Filename containing XML output mapping: ", null, 3, outputWriter);
            if (string5 == null) {
                return;
            }
            String string6 = InputReader.getFileContent("Filename containing XML option document: ", null, 3, outputWriter);
            if (string6 == null) {
                return;
            }
            String string7 = null;
            this.beginAPICall();
            string7 = this.getControlStructObject().xmlExecuteService(string, string2, string3, string4, string5, string6);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "XMLExecuteService Results", list);
            if (string7 != null) {
                outputWriter.printString(string7);
            } else {
                outputWriter.printString("xmlOutputDoc is null...\n");
            }
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.printString("Null Pointer exception...\n");
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void deleteEntry() {
        try {
            outputWriter.driverPrintHeader("DELETE ENTRY");
            EntryKey entryKey = InputReader.getEntryKey();
            int n = InputReader.getInt("DeleteEntry option ? (0): ", 0);
            this.beginAPICall();
            this.getControlStructObject().deleteEntry(entryKey.getFormName(), entryKey.getEntryID(), n);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Delete Entry", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getMultipleEntries() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE ENTRIES");
            String string = InputReader.getString("Form Name (): ", "");
            List<String> list = InputReader.getStringList("", "Entry Id");
            outputWriter.driverPrintPrompt("Ids of fields to retrieve:\n");
            int[] nArray = InputReader.getIntArray();
            this.beginAPICall();
            List list2 = this.getControlStructObject().getListEntryObjects(string, list, nArray);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Entry List: ", list2);
            List list3 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetMultipleEntries Status", list3);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListEntry() {
        try {
            outputWriter.driverPrintHeader("GETLIST ENTRY");
            String string = InputReader.getString("Form Name (): ", "");
            QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
            List<EntryListFieldInfo> list = InputReader.getEntryListFieldInfoList();
            List<SortInfo> list2 = InputReader.getSortInfoList();
            int n = InputReader.getInt("firstRetrieve (0): ", 0);
            int n2 = InputReader.getInt("Maximum Number of Entries to retrieve (500):", 500);
            OutputInteger outputInteger = null;
            if (InputReader.getBooleanForChangingInfo("Get number of matches? (F): ", false)) {
                outputInteger = new OutputInteger(0);
            }
            boolean bl = InputReader.getBooleanForChangingInfo("Use Locale Sensitive Search(F):", false);
            this.beginAPICall();
            List list3 = this.getControlStructObject().getListEntry(string, qualifierInfo, n, n2, list2, list, bl, outputInteger);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printInteger("", "Number of Matches:", outputInteger);
            outputWriter.print("", "Entry List:", list3);
            List list4 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetListEntry Status", list4);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListEntryWithFields() {
        try {
            outputWriter.driverPrintHeader("GETLIST ENTRY WITH FIELDS");
            String string = InputReader.getString("Form Name (): ", "");
            QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
            List<EntryListFieldInfo> list = InputReader.getEntryListFieldInfoList();
            int n = list == null ? 0 : list.size();
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = list.get(i).getFieldId();
            }
            List<SortInfo> list2 = InputReader.getSortInfoList();
            int n2 = InputReader.getInt("firstRetrieve (0): ", 0);
            int n3 = InputReader.getInt("Maximum Number of Entries to retrieve (500):", 500);
            OutputInteger outputInteger = null;
            if (InputReader.getBooleanForChangingInfo("Get number of matches? (F): ", false)) {
                outputInteger = new OutputInteger(0);
            }
            boolean bl = InputReader.getBooleanForChangingInfo("Use Locale Sensitive Search(F):", false);
            this.beginAPICall();
            List list3 = this.getControlStructObject().getListEntryObjects(string, qualifierInfo, n2, n3, list2, nArray, bl, outputInteger);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Entry List: ", list3);
            ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
            threadControlBlock.resetListIds();
            if (list3.size() > 0) {
                threadControlBlock.setFirstListId(((Entry)list3.get(0)).getEntryId());
                if (list3.size() > 1) {
                    threadControlBlock.setSecondListId(((Entry)list3.get(1)).getEntryId());
                } else {
                    threadControlBlock.setSecondListId(((Entry)list3.get(0)).getEntryId());
                }
                threadControlBlock.setLastListId(((Entry)list3.get(list3.size() - 1)).getEntryId());
            }
            List list4 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetListEntryWithFields Status", list4);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListEntryBlocks() {
        try {
            outputWriter.driverPrintHeader("GETLIST ENTRY BLOCKS");
            String string = InputReader.getString("Form Name (): ", "");
            QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
            List<SortInfo> list = InputReader.getSortInfoList();
            int n = InputReader.getInt("firstRetrieve (0): ", 0);
            int n2 = InputReader.getInt("Maximum Number of Entries to retrieve (500):", 500);
            OutputInteger outputInteger = null;
            if (InputReader.getBooleanForChangingInfo("Get number of matches? (F): ", false)) {
                outputInteger = new OutputInteger(0);
            }
            boolean bl = InputReader.getBooleanForChangingInfo("Use Locale Sensitive Search(F):", false);
            this.beginAPICall();
            RowIterator rowIterator = new RowIterator();
            this.getControlStructObject().getListEntryObjects(string, qualifierInfo, n, n2, list, null, bl, outputInteger, (IARRowIterator)rowIterator);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printInteger("", "Number of Matches:", outputInteger);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.printString("Null Pointer exception...\n");
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    public void mergeEntry() {
        try {
            outputWriter.driverPrintHeader("MERGE ENTRY");
            String string = InputReader.getString("Form Name: ");
            outputWriter.driverPrintHeader("Field/value pairs to merge:");
            Entry entry = InputReader.getEntry();
            int n = InputReader.getInt("Operation on duplicate entry (error, new ID, overwrite, merge) (1-4): ", 4);
            this.beginAPICall();
            this.getControlStructObject().mergeEntry(string, entry, n);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printString("Entry id: " + entry.getEntryId());
            outputWriter.printNewLine();
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Merge Entry Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void createField() {
        try {
            DisplayInstanceMap displayInstanceMap;
            Object object;
            outputWriter.driverPrintHeader("CREATE FIELD");
            Field field = InputReader.getField();
            String string = InputReader.getString("Form Name: ");
            field.setForm(string);
            int n = InputReader.getInt("Field id (0): ", 0);
            field.setFieldID(n);
            boolean bl = InputReader.getBoolean("Create even if ID is reserved? (F): ", false);
            field.setReservedIDOK(bl);
            String string2 = InputReader.getString("Field Name");
            field.setName(string2);
            int n2 = InputReader.getInt("Required, Optional, System, or Display-only (1-4) (2): ", 2);
            field.setFieldOption(n2);
            int n3 = InputReader.getInt("Open or Protected at create (1 or 2) (1): ", 1);
            field.setCreateMode(n3);
            int n4 = InputReader.getInt("Field option for Audit/Copy (0): ", 0);
            field.setAuditOption(n4);
            int n5 = field.getDataType();
            if (InputReader.getBooleanForChangingInfo("Have new default value? (F): ", false)) {
                object = InputReader.getValue(n5);
                field.setDefaultValue(object);
            }
            object = InputReader.getPermissionInfoList(true);
            field.setPermissions((List)object);
            if (InputReader.getBooleanForChangingInfo("Have field limits? (T): ", true)) {
                displayInstanceMap = InputReader.getFieldLimitInfo(n5);
                field.setFieldLimit((FieldLimit)displayInstanceMap);
            }
            displayInstanceMap = InputReader.getDisplayInstanceMap();
            field.setDisplayInstance(displayInstanceMap);
            String string3 = InputReader.getString("Help Text: ", "");
            field.setHelpText(string3);
            String string4 = InputReader.getString("Owner");
            field.setOwner(string4);
            String string5 = InputReader.getString("DiaryList: ", "");
            field.appendDiaryText(string5);
            FieldMapping fieldMapping = InputReader.getFieldMappingInfo();
            field.setFieldMap(fieldMapping);
            this.beginAPICall();
            this.getControlStructObject().createField(field, true);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "CreateField Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void deleteField() {
        try {
            outputWriter.driverPrintHeader("DELETE FIELD");
            String string = InputReader.getString("Form Name: ");
            int n = InputReader.getInt("Field id (0):", 0);
            int n2 = InputReader.getInt("Delete option - clean, data, cascade (0 - 2) (0): ", 0);
            this.beginAPICall();
            this.getControlStructObject().deleteField(string, n, n2);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "DeleteField Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void deleteMultipleFields() {
        try {
            outputWriter.driverPrintHeader("DELETE MULTIPLE FIELDS");
            String string = InputReader.getString("Form Name: ");
            outputWriter.driverPrintPrompt("Ids of fields to delete:\n");
            int[] nArray = InputReader.getIntArray();
            int n = InputReader.getInt("Delete Option- clean, data, cascade (0, 1, 2 ) (0): ", 0);
            this.beginAPICall();
            this.getControlStructObject().deleteFields(string, nArray, n);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Delete Multiple Fields  Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getField() {
        try {
            outputWriter.driverPrintHeader("GET FIELD");
            String string = InputReader.getString("Form Name: ");
            int n = InputReader.getInt("Field id (1): ", 1);
            FieldKey fieldKey = new FieldKey(string, n);
            FieldCriteria fieldCriteria = new FieldCriteria();
            fieldCriteria.setRetrieveAll(true);
            this.beginAPICall();
            Field field = this.getControlStructObject().getField(fieldKey.getFormName(), fieldKey.getFieldID(), fieldCriteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printField("", "Field Information:", field);
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Field Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListField() {
        try {
            outputWriter.driverPrintHeader("GET LIST FIELD");
            String string = InputReader.getString("Form Name (): ", "");
            long l = InputReader.getLong("Get all changed since ", 0L);
            int n = InputReader.getInt("Field Type - data, trim, control, page, page holder, table, column, attach,\n attach pool  (1, 2, 4, 8, 16, 32, 64, 128, 256) (1): ", 1);
            this.beginAPICall();
            List list = this.getControlStructObject().getListFieldObjects(string, n, l, null);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Field List Information:", list);
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get List Field Status", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void setField() {
        try {
            Object object;
            String string;
            outputWriter.driverPrintHeader("SET FIELD");
            Field field = InputReader.getField();
            String string2 = InputReader.getString("Form name: ");
            field.setForm(string2);
            int n = InputReader.getInt("Field id (1): ", 1);
            field.setFieldID(n);
            if (InputReader.getBooleanForChangingInfo("Change fieldName? (F): ", false)) {
                string = InputReader.getString("field name");
                field.setNewName(string);
            }
            if (InputReader.getBooleanForChangingInfo("Change field mapping? (F): ", false)) {
                string = InputReader.getFieldMappingInfo();
                field.setFieldMap((FieldMapping)string);
            }
            if (InputReader.getBooleanForChangingInfo("Have new option? (F): ", false)) {
                int n2 = InputReader.getInt("Required, Optional, System, or Display-only (1-4) (2): ", 2);
                field.setFieldOption(n2);
            }
            if (InputReader.getBooleanForChangingInfo("Have new create mode? (F): ", false)) {
                int n3 = InputReader.getInt("Open or Protected at create (1 or 2) (1) ", 1);
                field.setCreateMode(n3);
            }
            if (InputReader.getBooleanForChangingInfo("Have new field option? (F): ", false)) {
                int n4 = InputReader.getInt("Field option for Audit/Copy (0): ", 0);
                field.setAuditOption(n4);
            }
            int n5 = field.getDataType();
            if (InputReader.getBooleanForChangingInfo("Have new default value? (F): ", false)) {
                object = InputReader.getValue(n5);
                field.setDefaultValue(object);
            }
            if (InputReader.getBooleanForChangingInfo("Have new permissions? (F): ", false)) {
                object = InputReader.getPermissionInfoList(true);
                field.setPermissions((List)object);
            }
            if (InputReader.getBooleanForChangingInfo("Have new field limits? (F): ", false)) {
                object = InputReader.getFieldLimitInfo(n5);
                field.setFieldLimit((FieldLimit)object);
            }
            if (InputReader.getBooleanForChangingInfo("Have new display instance? (F): ", false)) {
                object = InputReader.getDisplayInstanceMap();
                field.setDisplayInstance((DisplayInstanceMap)object);
            }
            if (InputReader.getBooleanForChangingInfo("Have a new set field option for display instance? (F): ", false)) {
                int n6 = InputReader.getInt("Replace only new display instances(1) or Replace all display instances(0) ", 1);
                field.setSetFieldOptions(n6);
            }
            if (InputReader.getBooleanForChangingInfo("Change help text? (F): ", false)) {
                String string3 = InputReader.getString("Help Text: ", "");
                field.setHelpText(string3);
            }
            if (InputReader.getBooleanForChangingInfo("Change owner? (F): ", false)) {
                String string4 = InputReader.getString("Owner");
                field.setOwner(string4);
            }
            if (InputReader.getBooleanForChangingInfo("Add to change diary? (F): ", false)) {
                String string5 = InputReader.getString("DiaryList: ", "");
                field.appendDiaryText(string5);
            }
            this.beginAPICall();
            this.getControlStructObject().setField(field);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Field Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void createCharMenu() {
        try {
            outputWriter.driverPrintHeader("CREATE CHAR MENU");
            Menu menu = InputReader.getMenu();
            String string = InputReader.getString("Character Menu Name");
            menu.setName(string);
            int n = InputReader.getInt("Refresh on connect, open, interval (1 - 3) (1): ", 1);
            menu.setRefreshCode(n);
            String string2 = InputReader.getString("Help Text():", "");
            menu.setHelpText(string2);
            String string3 = InputReader.getString("Owner");
            menu.setOwner(string3);
            String string4 = InputReader.getString("Change DiaryList():", "");
            menu.appendDiaryText(string4);
            ObjectPropertyMap objectPropertyMap = InputReader.getObjectPropertyMap();
            menu.setProperties(objectPropertyMap);
            this.beginAPICall();
            this.getControlStructObject().createMenu(menu);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "CreateCharMenu Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void deleteCharMenu() {
        try {
            outputWriter.driverPrintHeader("DELETE CHAR MENU");
            String string = InputReader.getString("Character Menu Name");
            int n = InputReader.getInt("Delete option ? ( 0, 1, 2 ) ( 0 ):", 0);
            this.beginAPICall();
            this.getControlStructObject().deleteMenu(string, n);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "DeleteCharMenu", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getCharMenu() {
        try {
            outputWriter.driverPrintHeader("GET CHAR MENU");
            String string = InputReader.getString("Menu Name:", "");
            MenuCriteria menuCriteria = new MenuCriteria();
            menuCriteria.setRetrieveAll(true);
            this.beginAPICall();
            Menu menu = this.getControlStructObject().getMenu(string, menuCriteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printMenu("", "Menu Information: ", menu);
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetCharMenu Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListCharMenu() {
        try {
            outputWriter.driverPrintHeader("GET LIST CHAR MENU");
            long l = InputReader.getLong("Get all changed since (0): ", 0L);
            outputWriter.driverPrintHeader("Get menus associated with forms:");
            List<String> list = InputReader.getStringList("", "Form Name");
            outputWriter.driverPrintHeader("Get menus associated with active links:");
            List<String> list2 = InputReader.getStringList("", "Active Link Name");
            ObjectPropertyMap objectPropertyMap = InputReader.getObjectPropertyMap();
            this.beginAPICall();
            List list3 = this.getControlStructObject().getListMenu(l, list, list2, objectPropertyMap);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Menu List Information: ", list3);
            List list4 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get List Char Menu Status", list4);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getMultipleCharMenu() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE CHAR MENUS");
            long l = InputReader.getLong("Get all changed since (0): ", 0L);
            outputWriter.driverPrintHeader("Get menus associated with forms:");
            List<String> list = InputReader.getStringList("", "Form Name");
            outputWriter.driverPrintHeader("Get menus associated with active links:");
            List<String> list2 = InputReader.getStringList("", "Active Link Name");
            MenuCriteria menuCriteria = new MenuCriteria();
            menuCriteria.setRetrieveAll(true);
            this.beginAPICall();
            List list3 = this.getControlStructObject().getListMenuObjects(l, list, list2, menuCriteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Multiple Menu Information: ", list3);
            List list4 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Multiple Char Menu Status", list4);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void expandCharMenu() {
        try {
            outputWriter.driverPrintHeader("EXPAND CHAR MENU");
            Entry entry = null;
            Entry entry2 = null;
            Menu menu = InputReader.getMenu();
            if (menu.getName() != null && menu.getName().length() != 0) {
                outputWriter.driverPrintPrompt("      Keyword List:\n");
                entry = InputReader.getEntry();
                outputWriter.driverPrintPrompt("      Parameter List:\n");
                entry2 = InputReader.getEntry();
                outputWriter.driverPrintPrompt("      Extern List:\n");
                InputReader.getQualifierInfoList();
                ((SqlMenu)menu).setServer(InputReader.getString("      Server (): ", ""));
                InputReader.getString("      Form Name (): ", "");
            }
            this.beginAPICall();
            List list = this.getControlStructObject().expandMenu(menu, entry, entry2);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printCharMenuItemInfoList("", "Expanded char Menu Info:", list);
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ExpandCharMenu Status", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void setCharMenu() {
        try {
            Object object;
            outputWriter.driverPrintHeader("SET CHAR MENU");
            Menu menu = InputReader.getMenu();
            String string = InputReader.getString("Character Menu Name");
            menu.setName(string);
            if (InputReader.getBooleanForChangingInfo("Change Character Menu Name? (F): ", false)) {
                object = InputReader.getString("New Name");
                menu.setNewName((String)object);
            }
            if (InputReader.getBooleanForChangingInfo("Change Refresh Code? (F): ", false)) {
                int n = InputReader.getInt("Refresh on connect, open, interval (1 - 3) (1): ", 1);
                menu.setRefreshCode(n);
            }
            if (InputReader.getBooleanForChangingInfo("Change help text? (F): ", false)) {
                object = InputReader.getString("    Help Text(): ", "");
                menu.setHelpText((String)object);
            }
            if (InputReader.getBooleanForChangingInfo("Change Owner? (F): ", false)) {
                object = InputReader.getString("Owner");
                menu.setOwner((String)object);
            }
            if (InputReader.getBooleanForChangingInfo("Add to Change DiaryList? (F): ", false)) {
                object = InputReader.getString("    Change DiaryList (): ", "");
                menu.appendDiaryText((String)object);
            }
            if (InputReader.getBooleanForChangingInfo("Change object properties? (F): ", false)) {
                object = InputReader.getObjectPropertyMap();
                menu.setProperties((ObjectPropertyMap)object);
            }
            this.beginAPICall();
            this.getControlStructObject().setMenu(menu);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            object = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Char Menu Status", (List)object);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void createContainer() {
        try {
            outputWriter.driverPrintHeader("CREATE CONTAINER");
            Container container = InputReader.getContainer();
            String string = InputReader.getString("Container Name");
            container.setName(string);
            List<PermissionInfo> list = InputReader.getPermissionInfoList(true);
            container.setPermissions(list);
            outputWriter.driverPrintPrompt("Ids of sub admin groups allowed to access container:\n");
            List<Integer> list2 = InputReader.getIntegerList();
            container.setAdminGroupList(list2);
            List<ContainerOwner> list3 = InputReader.getContainerOwnerList();
            container.setContainerOwner(list3);
            String string2 = InputReader.getString("Label ():", "");
            container.setLabel(string2);
            String string3 = InputReader.getString("Description ():", "");
            container.setDescription(string3);
            List<Reference> list4 = InputReader.getReferenceList();
            container.setReferences(list4);
            String string4 = InputReader.getString("Help Text ():", "");
            container.setHelpText(string4);
            String string5 = InputReader.getString("Owner");
            container.setOwner(string5);
            String string6 = InputReader.getString("Change DiaryList ():", "");
            container.appendDiaryText(string6);
            ObjectPropertyMap objectPropertyMap = InputReader.getObjectPropertyMap();
            container.setProperties(objectPropertyMap);
            this.beginAPICall();
            this.getControlStructObject().createContainer(container);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list5 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Create Container Status", list5);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void setContainer() {
        try {
            Object object;
            outputWriter.driverPrintHeader("SET CONTAINER");
            Container container = InputReader.getContainer();
            String string = InputReader.getString("Container Name:", "");
            container.setName(string);
            if (InputReader.getBooleanForChangingInfo("Change container name? (F): ", false)) {
                object = InputReader.getString("New Name");
                container.setNewName((String)object);
            }
            if (InputReader.getBooleanForChangingInfo("Change group( permission ) list? (F): ", false)) {
                object = InputReader.getPermissionInfoList(true);
                container.setPermissions((List)object);
            }
            if (InputReader.getBooleanForChangingInfo("Change sub admin group list? (F): ", false)) {
                outputWriter.driverPrintPrompt("Ids of sub admin groups allowed to access container:\n");
                object = InputReader.getIntegerList();
                container.setAdminGroupList(object);
            }
            if (InputReader.getBooleanForChangingInfo("Change container owner object? (F): ", false)) {
                object = InputReader.getContainerOwnerList();
                container.setContainerOwner(object);
            }
            if (InputReader.getBooleanForChangingInfo("Change label? (F): ", false)) {
                object = InputReader.getString("    Label ():", "");
                container.setLabel((String)object);
            }
            if (InputReader.getBooleanForChangingInfo("Change description? (F): ", false)) {
                object = InputReader.getString("    Description ():", "");
                container.setDescription(object);
            }
            if (InputReader.getBooleanForChangingInfo("Change reference list? (F): ", false)) {
                object = InputReader.getReferenceList();
                container.setReferences(object);
            }
            if (InputReader.getBooleanForChangingInfo("Change help text? (F): ", false)) {
                object = InputReader.getString("    Help Text ():", "");
                container.setHelpText((String)object);
            }
            if (InputReader.getBooleanForChangingInfo("Change owner? (F): ", false)) {
                object = InputReader.getString("Owner");
                container.setOwner((String)object);
            }
            if (InputReader.getBooleanForChangingInfo("Add to change diary? (F): ", false)) {
                object = InputReader.getString("    Change DiaryList ():", "");
                container.appendDiaryText((String)object);
            }
            if (InputReader.getBooleanForChangingInfo("Change object properties? (F): ", false)) {
                object = InputReader.getObjectPropertyMap();
                container.setProperties((ObjectPropertyMap)object);
            }
            this.beginAPICall();
            this.getControlStructObject().setContainer(container);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            object = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Container Status", (List)object);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void deleteContainer() {
        try {
            outputWriter.driverPrintHeader("DELETE CONTAINER");
            String string = InputReader.getString("Container Name");
            int n = InputReader.getInt("Delete option ? ( 0, 1, 2 ) ( 0 ):", 0);
            this.beginAPICall();
            this.getControlStructObject().deleteContainer(string, n);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Delete Container Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getContainer() {
        try {
            outputWriter.driverPrintHeader("GET CONTAINER");
            String string = InputReader.getString("Container Key:");
            ContainerCriteria containerCriteria = new ContainerCriteria();
            containerCriteria.setRetrieveAll(true);
            this.beginAPICall();
            Container container = this.getControlStructObject().getContainer(string, containerCriteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printContainer("", "Container Information:", container);
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetContainer Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListContainer() {
        try {
            outputWriter.driverPrintHeader("GET LIST CONTAINER");
            long l = InputReader.getLong("Get All changed since, as UNIX epoch (0): ", 0L);
            int[] nArray = InputReader.getIntArray();
            boolean bl = InputReader.getBoolean("Retrieve hidden containers (false-true) (true):", true);
            List<ContainerOwner> list = InputReader.getContainerOwnerList();
            ContainerCriteria containerCriteria = new ContainerCriteria();
            containerCriteria.setRetrieveAll(true);
            this.beginAPICall();
            List list2 = this.getControlStructObject().getListContainer(l, nArray, bl, list, null);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Container List:", list2);
            List list3 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetListContainer Status", list3);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getMultipleContainers() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE CONTAINERS");
            List<String> list = InputReader.getStringList("", "Container Name");
            List list2 = this.getControlStructObject().getListContainerObjects(list);
            outputWriter.print("", "Container List:", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.printString("Null Pointer exception...\n");
        }
        catch (ARException aRException) {
            outputWriter.printARException(aRException);
        }
    }

    void createVUI() {
        try {
            outputWriter.driverPrintHeader("CREATE VIEW");
            View view = new View();
            view.setContext(this.getControlStructObject());
            String string = InputReader.getString("Form Name: ");
            view.setFormName(string);
            int n = InputReader.getInt("VUI id (0): ", 0);
            view.setVUIId(n);
            String string2 = InputReader.getString("VUI name");
            view.setName(string2);
            String string3 = InputReader.getString("Locale (): ", "");
            view.setLocale(string3);
            int n2 = InputReader.getInt("VUI-Type (0): ", 0);
            view.setVUIType(n2);
            ViewDisplayPropertyMap viewDisplayPropertyMap = InputReader.getViewDisplayPropertyMap();
            view.setDisplayProperties(viewDisplayPropertyMap);
            String string4 = InputReader.getString("Help Text:", "");
            view.setHelpText(string4);
            String string5 = InputReader.getString("Owner");
            view.setOwner(string5);
            String string6 = InputReader.getString("Change DiaryList:", "");
            view.appendDiaryText(string6);
            this.beginAPICall();
            this.getControlStructObject().createView(view);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "CreateView Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void deleteVUI() {
        try {
            outputWriter.driverPrintHeader("DELETE VIEW");
            View view = new View();
            view.setContext(this.getControlStructObject());
            String string = InputReader.getString("Form Name: ");
            view.setFormName(string);
            int n = InputReader.getInt("VUI id (0): ", 0);
            view.setVUIId(n);
            this.beginAPICall();
            this.getControlStructObject().deleteView(view.getFormName(), view.getVUIId());
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Delete View Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getVUI() {
        try {
            outputWriter.driverPrintHeader("GET VIEW");
            String string = InputReader.getString("Form Name (): ", "");
            int n = InputReader.getInt("VUI id (1): ", 1);
            ViewCriteria viewCriteria = new ViewCriteria();
            viewCriteria.setRetrieveAll(true);
            this.beginAPICall();
            View view = this.getControlStructObject().getView(string, n, viewCriteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printView("", "View Information:", view);
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get View STatus", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListVUI() {
        try {
            outputWriter.driverPrintHeader("GET LIST VIEW");
            ViewCriteria viewCriteria = new ViewCriteria();
            viewCriteria.setRetrieveAll(true);
            String string = InputReader.getString("Form Name (): ", "");
            long l = InputReader.getLong("Get All changed since, as UNIX epoch (0): ", 0L);
            this.beginAPICall();
            List list = this.getControlStructObject().getListView(string, l);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Views Ids:", list);
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetListView status", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void setVUI() {
        try {
            Object object;
            outputWriter.driverPrintHeader("SET VIEW");
            View view = new View();
            view.setContext(this.getControlStructObject());
            String string = InputReader.getString("Form Name: ");
            view.setFormName(string);
            int n = InputReader.getInt(" VUI id (1): ", 1);
            view.setVUIId(n);
            if (InputReader.getBooleanForChangingInfo("Change VUI name? (F): ", false)) {
                object = InputReader.getString("VUI name");
                view.setNewName((String)object);
            }
            if (InputReader.getBooleanForChangingInfo("Change Locale? (F): ", false)) {
                view.setLocale(InputReader.getString("Locale(): ", ""));
            }
            if (InputReader.getBooleanForChangingInfo("Change VUI-Type? (F): ", false)) {
                view.setVUIType(InputReader.getInt("VUI-Type (0): ", 0));
            }
            if (InputReader.getBooleanForChangingInfo("Have new Prop List Info? (F): ", false)) {
                object = InputReader.getViewDisplayPropertyMap();
                view.setDisplayProperties((ViewDisplayPropertyMap)object);
            }
            if (InputReader.getBooleanForChangingInfo("Change Help Text? (F): ", false)) {
                object = InputReader.getString("Help Text:", "");
                view.setHelpText((String)object);
            }
            if (InputReader.getBooleanForChangingInfo("Change Owner? (F): ", false)) {
                object = InputReader.getString("Owner");
                view.setOwner((String)object);
            }
            if (InputReader.getBooleanForChangingInfo("Add to Change DiaryList? (F): ", false)) {
                object = InputReader.getString("Change DiaryList (): ", "");
                view.appendDiaryText((String)object);
            }
            this.beginAPICall();
            this.getControlStructObject().setView(view);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            object = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set View status", (List)object);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void createActiveLink() {
        try {
            outputWriter.driverPrintHeader("CREATE ACTIVE LINK");
            ActiveLink activeLink = new ActiveLink();
            String string = InputReader.getString("Active link Name");
            activeLink.setName(string);
            int n = InputReader.getInt("Execution order (1-1000) (1):", 1);
            activeLink.setOrder(n);
            List<String> list = InputReader.getStringList("", "Form");
            activeLink.setFormList(list);
            outputWriter.driverPrintPrompt("Ids of groups allowed to perform active link:\n");
            List<Integer> list2 = InputReader.getInternalIDArrayList();
            activeLink.setGroupList(list2);
            int n2 = InputReader.getInt("Execution bit mask (1):", 1);
            activeLink.setExecuteMask(n2);
            int n3 = InputReader.getInt("Control Field to tie active link to (0):", 0);
            activeLink.setControlField(n3);
            int n4 = InputReader.getInt("Focus Field to tie active link to (0):", 0);
            activeLink.setFocusField(n4);
            boolean bl = InputReader.getBoolean("Disable/Enable (F-T) (T):", true);
            activeLink.setEnable(bl);
            QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
            activeLink.setQualifier(qualifierInfo);
            List<ActiveLinkAction> list3 = InputReader.getActiveLinkActionInfoList(true);
            activeLink.setActionList(list3);
            List<ActiveLinkAction> list4 = InputReader.getActiveLinkActionInfoList(false);
            activeLink.setElseList(list4);
            String string2 = InputReader.getString("Help Text ():", "");
            activeLink.setHelpText(string2);
            String string3 = InputReader.getString("Owner");
            activeLink.setOwner(string3);
            String string4 = InputReader.getString("Change DiaryList ():", "");
            activeLink.appendDiaryText(string4);
            ObjectPropertyMap objectPropertyMap = InputReader.getObjectPropertyMap();
            activeLink.setProperties(objectPropertyMap);
            this.beginAPICall();
            this.getControlStructObject().createActiveLink(activeLink);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list5 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Create Active Link Status", list5);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void deleteActiveLink() {
        try {
            outputWriter.driverPrintHeader("DELETE ACTIVELINK");
            String string = InputReader.getString("Active link name");
            int n = InputReader.getInt("Delete option ? ( 0, 1, 2 ) ( 0 ):", 0);
            this.beginAPICall();
            this.getControlStructObject().deleteActiveLink(string, n);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Delete Active Link Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getActiveLink() {
        try {
            outputWriter.driverPrintHeader("GET ACTIVELINK");
            String string = InputReader.getString("Active Link Key:");
            ActiveLinkCriteria activeLinkCriteria = new ActiveLinkCriteria();
            activeLinkCriteria.setRetrieveAll(true);
            this.beginAPICall();
            ActiveLink activeLink = this.getControlStructObject().getActiveLink(string, activeLinkCriteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printActiveLink("", "Active Link:", activeLink);
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Active Link Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListActiveLink() {
        try {
            outputWriter.driverPrintHeader("GETLIST ACTIVE LINK");
            String string = null;
            if (InputReader.getBooleanForChangingInfo("For a specific form? (F):", false)) {
                string = InputReader.getString("Form Name (): ", "");
            }
            long l = InputReader.getLong("Get all changed since (0):", 0L);
            ObjectPropertyMap objectPropertyMap = InputReader.getObjectPropertyMap();
            this.beginAPICall();
            List list = this.getControlStructObject().getListActiveLink(string, l, objectPropertyMap);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Active Link List:", list);
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Active Link List Status", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getMultipleActiveLinks() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE ACTIVE LINKS");
            ActiveLinkCriteria activeLinkCriteria = new ActiveLinkCriteria();
            activeLinkCriteria.setRetrieveAll(true);
            long l = InputReader.getLong("Get all changed since (0):", 0L);
            List<String> list = InputReader.getStringList("", "Active link name");
            this.beginAPICall();
            List list2 = this.getControlStructObject().getListActiveLinkObjects(list, l, activeLinkCriteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Active Link List:", list2);
            List list3 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Active Link List Status", list3);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void setActiveLink() {
        try {
            List<Integer> list;
            outputWriter.driverPrintHeader("SET ACTIVE LINK");
            ActiveLink activeLink = new ActiveLink();
            String string = InputReader.getString("Active link Name");
            activeLink.setName(string);
            if (InputReader.getBooleanForChangingInfo("Change active link name? (F): ", false)) {
                list = InputReader.getString("New Name");
                activeLink.setNewName((String)((Object)list));
            }
            if (InputReader.getBooleanForChangingInfo("Change execution order? (F): ", false)) {
                int n = InputReader.getInt("Execution order (1-1000) (1):", 1);
                activeLink.setOrder(n);
            }
            if (InputReader.getBooleanForChangingInfo("Change Work Flow information? (F): ", false)) {
                list = InputReader.getStringList("", "Form");
                activeLink.setFormList((List)list);
            }
            if (InputReader.getBooleanForChangingInfo("Change group List? (F): ", false)) {
                outputWriter.driverPrintPrompt("Ids of groups allowed to perform active link:\n");
                list = InputReader.getIntegerList();
                activeLink.setGroupList(list);
            }
            if (InputReader.getBooleanForChangingInfo("Change execute mask? (F): ", false)) {
                int n = InputReader.getInt("Execution bit mask (1):", 1);
                activeLink.setExecuteMask(n);
            }
            if (InputReader.getBooleanForChangingInfo("Change control field? (F): ", false)) {
                int n = InputReader.getInt("Control Field to tie active link to (0):", 0);
                activeLink.setControlField(n);
            }
            if (InputReader.getBooleanForChangingInfo("Change focus field? (F): ", false)) {
                int n = InputReader.getInt("Focus Field to tie active link to (0):", 0);
                activeLink.setFocusField(n);
            }
            if (InputReader.getBooleanForChangingInfo("Change enable/disable? (F): ", false)) {
                boolean bl = InputReader.getBoolean("Disable/Enable (F-T) (T):", true);
                activeLink.setEnable(bl);
            }
            if (InputReader.getBooleanForChangingInfo("Change query? (F): ", false)) {
                QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
                activeLink.setQualifier(qualifierInfo);
            }
            if (InputReader.getBooleanForChangingInfo("Change actions? (F): ", false)) {
                List<ActiveLinkAction> list2 = InputReader.getActiveLinkActionInfoList(true);
                activeLink.setActionList(list2);
            }
            if (InputReader.getBooleanForChangingInfo("Change else actions? (F): ", false)) {
                List<ActiveLinkAction> list3 = InputReader.getActiveLinkActionInfoList(false);
                activeLink.setElseList(list3);
            }
            if (InputReader.getBooleanForChangingInfo("Change help text? (F): ", false)) {
                String string2 = InputReader.getString("Help Text ():", "");
                activeLink.setHelpText(string2);
            }
            if (InputReader.getBooleanForChangingInfo("Change owner? (F): ", false)) {
                String string3 = InputReader.getString("Owner");
                activeLink.setOwner(string3);
            }
            if (InputReader.getBooleanForChangingInfo("Add to change diary? (F): ", false)) {
                String string4 = InputReader.getString("Change DiaryList ():", "");
                activeLink.appendDiaryText(string4);
            }
            if (InputReader.getBooleanForChangingInfo("Change object properties? (F): ", false)) {
                ObjectPropertyMap objectPropertyMap = InputReader.getObjectPropertyMap();
                activeLink.setProperties(objectPropertyMap);
            }
            this.beginAPICall();
            this.getControlStructObject().setActiveLink(activeLink);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list4 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Active Link Status", list4);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void createFilter() {
        try {
            outputWriter.driverPrintHeader("CREATE FILTER");
            Filter filter = new Filter();
            String string = InputReader.getString("Filter Name: ");
            filter.setName(string);
            int n = InputReader.getInt("Filter order (0-1000) (500): ", 500);
            filter.setOrder(n);
            List<String> list = InputReader.getStringList("", "Form");
            filter.setFormList(list);
            int n2 = InputReader.getInt("Operation bit mask (0):", 0);
            filter.setOpSet(n2);
            boolean bl = InputReader.getBoolean("Disable/Enable (0-1) (1):", true);
            filter.setEnable(bl);
            QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
            filter.setQualifier(qualifierInfo);
            List<FilterAction> list2 = InputReader.getFilterActionInfoList(true);
            filter.setActionList(list2);
            List<FilterAction> list3 = InputReader.getFilterActionInfoList(false);
            filter.setElseList(list3);
            String string2 = InputReader.getString("Help Text ():", "");
            filter.setHelpText(string2);
            String string3 = InputReader.getString("Owner ():");
            filter.setOwner(string3);
            String string4 = InputReader.getString("Change DiaryList ():", "");
            filter.appendDiaryText(string4);
            ObjectPropertyMap objectPropertyMap = InputReader.getObjectPropertyMap();
            filter.setProperties(objectPropertyMap);
            this.beginAPICall();
            this.getControlStructObject().createFilter(filter);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list4 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Create Filter Status", list4);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void deleteFilter() {
        try {
            outputWriter.driverPrintHeader("DELETE FILTER");
            String string = InputReader.getString("Filter name");
            this.beginAPICall();
            this.getControlStructObject().deleteFilter(string, 1);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Delete Filter Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getFilter() {
        try {
            outputWriter.driverPrintHeader("GET FILTER");
            String string = InputReader.getString("Filter Key:");
            FilterCriteria filterCriteria = new FilterCriteria();
            filterCriteria.setRetrieveAll(true);
            this.beginAPICall();
            Filter filter = this.getControlStructObject().getFilter(string, filterCriteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printFilter("", "Filter:", filter);
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Filter Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListFilter() {
        try {
            outputWriter.driverPrintHeader("GET FILTER LIST");
            String string = null;
            if (InputReader.getBooleanForChangingInfo("For a specific form? (F):", false)) {
                string = InputReader.getString("Form Name (): ", "");
            }
            long l = InputReader.getLong("Get all changed since (0):", 0L);
            ObjectPropertyMap objectPropertyMap = InputReader.getObjectPropertyMap();
            this.beginAPICall();
            List list = this.getControlStructObject().getListFilter(string, l, objectPropertyMap);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Filter List:", list);
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get List Filter status", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getMultipleFilters() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE FILTERS");
            FilterCriteria filterCriteria = new FilterCriteria();
            filterCriteria.setRetrieveAll(true);
            String string = null;
            if (InputReader.getBooleanForChangingInfo("For a specific form? (F):", false)) {
                string = InputReader.getString("Form Name (): ", "");
            }
            long l = InputReader.getLong("Get all changed since (0):", 0L);
            this.beginAPICall();
            List list = this.getControlStructObject().getListFilterObjects(string, l, filterCriteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Filter List:", list);
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Multiple Filters status", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void setFilter() {
        try {
            Object object;
            outputWriter.driverPrintHeader("SET FILTER");
            Filter filter = new Filter();
            String string = InputReader.getString("Filter Name ():");
            filter.setName(string);
            if (InputReader.getBooleanForChangingInfo("Change filter name? (F): ", false)) {
                object = InputReader.getString("New Name ():");
                filter.setNewName((String)object);
            }
            if (InputReader.getBooleanForChangingInfo("Change filter order? (F): ", false)) {
                int n = InputReader.getInt("Filter order (1-1000) (500):", 500);
                filter.setOrder(n);
            }
            if (InputReader.getBooleanForChangingInfo("Change workflow info? (F): ", false)) {
                object = InputReader.getStringList("", "Form");
                filter.setFormList((List)object);
            }
            if (InputReader.getBooleanForChangingInfo("Change operations mask? (F): ", false)) {
                int n = InputReader.getInt("Operation bit mask (0):", 0);
                filter.setOpSet(n);
            }
            if (InputReader.getBooleanForChangingInfo("Change enable/disable? (F): ", false)) {
                boolean bl = InputReader.getBoolean("Disable/Enable (0-1) (1):", true);
                filter.setEnable(bl);
            }
            if (InputReader.getBooleanForChangingInfo("Change Query? (F): ", false)) {
                QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
                filter.setQualifier(qualifierInfo);
            }
            if (InputReader.getBooleanForChangingInfo("Change action(s)? (F): ", false)) {
                List<FilterAction> list = InputReader.getFilterActionInfoList(true);
                filter.setActionList(list);
            }
            if (InputReader.getBooleanForChangingInfo("Change else(s)? (F): ", false)) {
                List<FilterAction> list = InputReader.getFilterActionInfoList(false);
                filter.setElseList(list);
            }
            if (InputReader.getBooleanForChangingInfo("Change help text? (F): ", false)) {
                String string2 = InputReader.getString("Help Text ():", "");
                filter.setHelpText(string2);
            }
            if (InputReader.getBooleanForChangingInfo("Change owner? (F): ", false)) {
                String string3 = InputReader.getString("Owner");
                filter.setOwner(string3);
            }
            if (InputReader.getBooleanForChangingInfo("Add to Change DiaryList? (F): ", false)) {
                String string4 = InputReader.getString("Change DiaryList (): ", "");
                filter.appendDiaryText(string4);
            }
            if (InputReader.getBooleanForChangingInfo("Change object properties? (F): ", false)) {
                ObjectPropertyMap objectPropertyMap = InputReader.getObjectPropertyMap();
                filter.setProperties(objectPropertyMap);
            }
            this.beginAPICall();
            this.getControlStructObject().setFilter(filter);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Filter Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void createEscalation() {
        try {
            outputWriter.driverPrintHeader("CREATE ESCALATION");
            Escalation escalation = new Escalation();
            String string = InputReader.getString("Escalation Name: ");
            escalation.setName(string);
            EscalationTimeCriteria escalationTimeCriteria = InputReader.getEsclationTmInfo();
            escalation.setEscalationTm(escalationTimeCriteria);
            List<String> list = InputReader.getStringList("", "Form");
            escalation.setFormList(list);
            boolean bl = InputReader.getBoolean("Disable/Enable (0-1) (1): ", true);
            escalation.setEnable(bl);
            QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
            escalation.setQualifier(qualifierInfo);
            List<FilterAction> list2 = InputReader.getFilterActionInfoList(true);
            escalation.setActionList(list2);
            List<FilterAction> list3 = InputReader.getFilterActionInfoList(false);
            escalation.setElseList(list3);
            String string2 = InputReader.getString("Help Text (): ", "");
            escalation.setHelpText(string2);
            String string3 = InputReader.getString("Owner: ");
            escalation.setOwner(string3);
            String string4 = InputReader.getString("Change DiaryList (): ", "");
            escalation.appendDiaryText(string4);
            ObjectPropertyMap objectPropertyMap = InputReader.getObjectPropertyMap();
            escalation.setProperties(objectPropertyMap);
            this.beginAPICall();
            this.getControlStructObject().createEscalation(escalation);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list4 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Create Escalation status", list4);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void deleteEscalation() {
        try {
            outputWriter.driverPrintHeader("DELETE ESCALATION");
            String string = InputReader.getString("Escalation Name: ");
            int n = InputReader.getInt("Delete option ? (0): ", 0);
            this.beginAPICall();
            this.getControlStructObject().deleteEscalation(string, n);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Delete Escalation Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getEscalation() {
        try {
            outputWriter.driverPrintHeader("GET ESCALATION");
            String string = InputReader.getString("Escalation Key:");
            EscalationCriteria escalationCriteria = new EscalationCriteria();
            escalationCriteria.setRetrieveAll(true);
            this.beginAPICall();
            Escalation escalation = this.getControlStructObject().getEscalation(string, escalationCriteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printEscalation("", "Esclation Data:", escalation);
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Escalation Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListEscalation() {
        try {
            outputWriter.driverPrintHeader("GET LIST ESCALATION");
            String string = null;
            if (InputReader.getBooleanForChangingInfo("For a specific form? (F):", false)) {
                string = InputReader.getString("Form Name (): ", "");
            }
            long l = InputReader.getLong("Get all changed since (0):", 0L);
            this.beginAPICall();
            List list = this.getControlStructObject().getListEscalation(string, l);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Esclation List:", list);
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetListEscalation status", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getMultipleEscalations() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE ESCALATIONS");
            EscalationCriteria escalationCriteria = new EscalationCriteria();
            escalationCriteria.setRetrieveAll(true);
            String string = null;
            if (InputReader.getBooleanForChangingInfo("For a specific form? (F):", false)) {
                string = InputReader.getString("Form Name (): ", "");
            }
            long l = InputReader.getLong("Get all changed since (0):", 0L);
            this.beginAPICall();
            List list = this.getControlStructObject().getListEscalationObjects(string, l, escalationCriteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Esclation List:", list);
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetMultipleEscalations status", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void setEscalation() {
        try {
            Object object;
            outputWriter.driverPrintHeader("SET ESCALATION");
            Escalation escalation = new Escalation();
            String string = InputReader.getString("Escalation Name: ");
            escalation.setName(string);
            if (InputReader.getBooleanForChangingInfo("Change escalation name? (F): ", false)) {
                object = InputReader.getString("New Name: ");
                escalation.setNewName((String)object);
            }
            if (InputReader.getBooleanForChangingInfo("Change escalation Time? (F): ", false)) {
                object = InputReader.getEsclationTmInfo();
                escalation.setEscalationTm((EscalationTimeCriteria)object);
            }
            if (InputReader.getBooleanForChangingInfo("Change Work Flow information? (F): ", false)) {
                object = InputReader.getStringList("", "Form");
                escalation.setFormList((List)object);
            }
            if (InputReader.getBooleanForChangingInfo("Change enable/disable? (F): ", false)) {
                boolean bl = InputReader.getBoolean("Disable/Enable (0-1) (1): ", true);
                escalation.setEnable(bl);
            }
            if (InputReader.getBooleanForChangingInfo("Change Query? (F): ", false)) {
                QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
                escalation.setQualifier(qualifierInfo);
            }
            if (InputReader.getBooleanForChangingInfo("Change action(s)? (F): ", false)) {
                List<FilterAction> list = InputReader.getFilterActionInfoList(true);
                escalation.setActionList(list);
            }
            if (InputReader.getBooleanForChangingInfo("Change else(s)? (F): ", false)) {
                List<FilterAction> list = InputReader.getFilterActionInfoList(false);
                escalation.setElseList(list);
            }
            if (InputReader.getBooleanForChangingInfo("Change help text? (F): ", false)) {
                String string2 = InputReader.getString("Help Text (): ", "");
                escalation.setHelpText(string2);
            }
            if (InputReader.getBooleanForChangingInfo("Change owner? (F): ", false)) {
                String string3 = InputReader.getString("Owner: ");
                escalation.setOwner(string3);
            }
            if (InputReader.getBooleanForChangingInfo("Add to Change DiaryList? (F): ", false)) {
                String string4 = InputReader.getString("Change DiaryList (): ", "");
                escalation.appendDiaryText(string4);
            }
            if (InputReader.getBooleanForChangingInfo("Change object properties? (F): ", false)) {
                ObjectPropertyMap objectPropertyMap = InputReader.getObjectPropertyMap();
                escalation.setProperties(objectPropertyMap);
            }
            this.beginAPICall();
            this.getControlStructObject().setEscalation(escalation);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Escalation Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void createSupportFile() {
        try {
            outputWriter.driverPrintHeader("CREATE SUPPORT FILE");
            SupportFile supportFile = new SupportFile();
            SupportFileKey supportFileKey = InputReader.getSupportFileKey();
            supportFile.setKey(supportFileKey);
            String string = InputReader.getString("File name ():", "");
            supportFile.setFilePath(string);
            this.beginAPICall();
            this.getControlStructObject().createSupportFile(supportFile);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Create Support File Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void deleteSupportFile() {
        try {
            outputWriter.driverPrintHeader("DELETE SUPPORT FILE");
            SupportFile supportFile = new SupportFile();
            SupportFileKey supportFileKey = InputReader.getSupportFileKey();
            supportFile.setKey(supportFileKey);
            this.beginAPICall();
            this.getControlStructObject().deleteSupportFile(supportFile.getKey());
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Delete Support File Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getSupportFile() {
        try {
            Object object;
            outputWriter.driverPrintHeader("GET SUPPORT FILE");
            SupportFileKey supportFileKey = InputReader.getSupportFileKey();
            String string = InputReader.getString("Filename to hold returned file: ", "");
            this.beginAPICall();
            SupportFile supportFile = this.getControlStructObject().getSupportFile(supportFileKey.getName(), supportFileKey.getFileId(), supportFileKey.getFileType(), supportFileKey.getFieldId(), string);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printSupportFile("", "SupportFile Data:", supportFile);
            if (supportFile != null) {
                object = supportFile.getFilePath();
                String string2 = InputReader.getFileContents((String)object);
                FileWriter fileWriter = new FileWriter((String)object);
                fileWriter.write(string2, 0, string2.length());
                fileWriter.close();
            }
            object = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Support File Status", (List)object);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void setSupportFile() {
        try {
            outputWriter.driverPrintHeader("SET SUPPORT FILE");
            SupportFile supportFile = new SupportFile();
            SupportFileKey supportFileKey = InputReader.getSupportFileKey();
            supportFile.setKey(supportFileKey);
            String string = InputReader.getString("File name to load to server():", "");
            supportFile.setFilePath(string);
            this.beginAPICall();
            this.getControlStructObject().setSupportFile(supportFile);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set SupportFile Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListSupportFile() {
        try {
            outputWriter.driverPrintHeader("GET List SUPPORT FILE");
            int n = InputReader.getInt("File type -- external report (1) (1): ", 1);
            String string = InputReader.getString("Nameof associated object ():", "");
            int n2 = InputReader.getInt("   Supporting ID for object (0): ", 0);
            long l = InputReader.getLong("Get all changed since (0):", 0L);
            this.beginAPICall();
            List list = this.getControlStructObject().getListSupportFileObjects(n, string, n2, l);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Support Files:", list);
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get List SupportFile STatus", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListGroup() {
        try {
            outputWriter.driverPrintHeader("GET LIST GROUP");
            String string = null;
            String string2 = null;
            if (InputReader.getBooleanForChangingInfo("For a specific user? (F): ", false)) {
                string = InputReader.getString("Name of the user: ");
                string2 = InputReader.getString("Password of the User: ");
            }
            this.beginAPICall();
            List list = this.getControlStructObject().getListGroup(string, string2);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "ARGetListGroup Results:", list);
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetListGroup Status", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListRole() {
        try {
            outputWriter.driverPrintHeader("GET LIST ROLE");
            String string = null;
            String string2 = null;
            String string3 = null;
            string = InputReader.getString("Application name:");
            if (InputReader.getBooleanForChangingInfo("For a specific user? (F): ", false)) {
                string2 = InputReader.getString("Name of the user: ");
                string3 = InputReader.getString("Password of the User: ");
            }
            this.beginAPICall();
            List list = this.getControlStructObject().getListRole(string, string2, string3);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "ARGetListRole Results:", list);
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetListRoles Status", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListUser() {
        try {
            outputWriter.driverPrintHeader("GET LIST USER");
            int n = InputReader.getInt("User List Type (myself, registered or current (0-2)(1): ", 1);
            long l = InputReader.getLong("Get registered users changed since (0 means all): ", 0L);
            this.beginAPICall();
            List list = this.getControlStructObject().getListUser(n, l);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "ARGetListUser Results:", list);
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetListUser Status", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getServerInfo() {
        try {
            outputWriter.driverPrintHeader("GET SERVER INFO");
            int n = InputReader.getInt("Number of server info operations (1): ", 1);
            if (n < 1) {
                n = 1;
            }
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = InputReader.getInt("   Operation (1-255) (1): ", 1);
            }
            this.beginAPICall();
            ServerInfoMap serverInfoMap = this.getControlStructObject().getServerInfo(nArray);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "ARGetServerInfo Results:", serverInfoMap);
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetServerInfo Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void setServerInfo() {
        try {
            outputWriter.driverPrintHeader("SET SERVER INFO");
            ServerInfoMap serverInfoMap = InputReader.getServerInfoMap();
            this.beginAPICall();
            this.getControlStructObject().setServerInfo(serverInfoMap);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Server Information Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void setServerPort() {
        try {
            outputWriter.driverPrintHeader("SET SERVER PORT");
            int n = InputReader.getInt("The port number of server (0):", 0);
            int n2 = InputReader.getInt("The RPC program number of Server (0):", 0);
            this.getControlStructObject().setPort(n);
            this.getControlStructObject().usePrivateRpcQueue(n2);
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Server Port Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void export() {
        try {
            outputWriter.driverPrintHeader("ARExport");
            List<StructItemInfo> list = InputReader.getStructItemInfoList();
            String string = null;
            int n = 0;
            WorkflowLockInfo workflowLockInfo = InputReader.getWorkflowLockInfo();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i).getType() != 3 && list.get(i).getType() != 103) continue;
                    string = InputReader.getString("Display Tag");
                    n = InputReader.getInt("VUI- Type (0): ", 0);
                    break;
                }
            }
            String string2 = InputReader.getString("Filename for exported data: ", "");
            FileWriter fileWriter = new FileWriter(string2);
            this.beginAPICall();
            String string3 = this.getControlStructObject().exportDef(list, string, n, workflowLockInfo);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            if (string3 != null) {
                fileWriter.write(string3);
                fileWriter.flush();
            }
            fileWriter.close();
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARExport Status", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getServerStatistics() {
        try {
            outputWriter.driverPrintHeader("GET SERVER STATISTICS");
            int n = InputReader.getInt("Number Of server info Operations (0):", 0);
            int[] nArray = null;
            if (n != 0) {
                nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = InputReader.getInt("Operation (1-63 ):", 1);
                }
            }
            this.beginAPICall();
            ServerInfoMap serverInfoMap = this.getControlStructObject().getServerStatistics(nArray);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printString("ARGetServerStatistics Results\n");
            outputWriter.print("", "Server Information", serverInfoMap);
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetServerStatistics Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void executeProcess() {
        try {
            outputWriter.driverPrintHeader("EXECUTE PROCESS");
            String string = InputReader.getString("Command:", "");
            boolean bl = InputReader.getBooleanForChangingInfo("Wait For process to complete (F): ", false);
            this.beginAPICall();
            ProcessResult processResult = this.getControlStructObject().executeProcess(string, bl);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printProcessResult("", "ARExecuteProcess Results:", processResult);
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARExecuteProcess Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListSQL() {
        try {
            outputWriter.driverPrintHeader("GETLIST SQL");
            String string = InputReader.getString("SQL Command:", "");
            int n = InputReader.getInt("Maximum number of entries to retrieve (500):", 500);
            boolean bl = InputReader.getBooleanForChangingInfo("Get Number Of Matches? (F): ", false);
            this.beginAPICall();
            SQLResult sQLResult = this.getControlStructObject().getListSQL(string, n, bl);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printSQLResult("", "ARGetListSQL Results:", sQLResult);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getTextForErrorMessage() {
        try {
            outputWriter.driverPrintHeader("GET TEXT FOR ERROR MESSAGE");
            int n = InputReader.getInt("The message identifier for the message (0):", 0);
            this.beginAPICall();
            String string = this.getControlStructObject().getTextForErrorMessage(n);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printString("", "ARGetTextForErrorMessage Results:", string, "\n");
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetTextForErrorMessage Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getEntryBLOB() {
        try {
            outputWriter.driverPrintHeader("GET ENTRY BLOB");
            String string = InputReader.getString("Form Name: ");
            String string2 = InputReader.getString("Entry ID:", "");
            int n = InputReader.getInt("Field ID (1):", 1);
            String string3 = InputReader.getString("File path to retrieve the attachment value :", "");
            byte[] byArray = null;
            this.beginAPICall();
            if (string3 != null && string3.length() > 0) {
                this.getControlStructObject().getEntryBlob(string, string2, n, string3);
            } else {
                outputWriter.printString("File path was not supplied, so content will be retrieved into a buffer\n");
                byArray = this.getControlStructObject().getEntryBlob(string, string2, n);
            }
            this.endAPICall(this.getControlStructObject().getLastStatus());
            if (string3 != null && string3.length() > 0 && new File(string3).exists()) {
                outputWriter.printString("File retrieved to: " + string3 + "\n");
            } else if (byArray != null) {
                outputWriter.printString("Buffer size is: " + byArray.length + "\n");
            } else {
                outputWriter.printString("Empty buffer...\n");
            }
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Entry Blob Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void verifyUser() {
        try {
            outputWriter.driverPrintHeader("VERIFY USER");
            this.beginAPICall();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Verify User Results:", this.getControlStructObject());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Verify User Status", list);
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
    }

    void encodeARQualifierStruct() {
        try {
            outputWriter.driverPrintHeader("ENCODE ARQUALIFIER STRUCT TO STRING");
            QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
            this.beginAPICall();
            String string = this.getControlStructObject().encodeQualification(qualifierInfo);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            if (string != null) {
                outputWriter.printHeader("", "Qualifier Text: ", "\n");
                outputWriter.printString(string);
            }
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "EncodeQualifier Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.printString("Null Pointer exception...\n");
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void decodeARQualifierStruct() {
        try {
            outputWriter.driverPrintHeader("DECODE STRING TO ARQUALIFIER STRUCT");
            String string = InputReader.getString("Qualifier Text: ", "");
            this.beginAPICall();
            QualifierInfo qualifierInfo = this.getControlStructObject().decodeQualification(string);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            if (qualifierInfo != null) {
                outputWriter.printQualifierInfo("", "ARDecodeARQualifierStruct: ", qualifierInfo);
            }
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARDecodeARQualifierStruct  Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void encodeARAssignStruct() {
        try {
            outputWriter.driverPrintHeader("ENCODE ARASSIGN STRUCT TO STRING");
            AssignInfo assignInfo = InputReader.getAssignInfo();
            this.beginAPICall();
            String string = this.getControlStructObject().encodeAssignment(assignInfo);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printHeader("", "Assign Text: ", "\n");
            if (string != null) {
                outputWriter.printString(string);
                outputWriter.printNewLine();
            }
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "AREncodeARAssignStruct Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void decodeARAssignStruct() {
        try {
            outputWriter.driverPrintHeader("DECODE STRING TO ARASSIGN STRUCT");
            String string = InputReader.getString("Assign Text: ", "");
            this.beginAPICall();
            AssignInfo assignInfo = this.getControlStructObject().decodeAssignment(string);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            if (assignInfo != null) {
                outputWriter.printAssignInfo("", "ARDecodeARAssignStruct: ", assignInfo);
            }
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARDecodeARAssignStruct Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void encodeStatusHistory() {
        try {
            outputWriter.driverPrintHeader("ENCODE STATUS HISTORY ARRAY TO STRING");
            StatusHistoryValue statusHistoryValue = InputReader.getStatusHistory();
            this.beginAPICall();
            String string = statusHistoryValue.encode();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            if (string != null) {
                outputWriter.printString("Status History String: \n");
                outputWriter.printString(string);
                outputWriter.printStatusHistoryString("", "Status History Items:", string);
                List list = this.getControlStructObject().getLastStatus();
                outputWriter.printStatusInfoList("", "AREncodeStatusHistory Status", list);
            } else {
                outputWriter.printString("Status History String: Null\n");
            }
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
    }

    void encodeDiary() {
        try {
            List list;
            outputWriter.driverPrintHeader("ENCODE DIARY ARRAY TO STRING");
            DiaryListValue diaryListValue = InputReader.getDiaryInfoList();
            this.beginAPICall();
            String string = ARServerUser.encodeDiary((DiaryListValue)diaryListValue);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printHeader("", "DiaryList Text: ", "\n");
            if (string != null) {
                outputWriter.printString(string);
                outputWriter.printString("", "DiaryList Items:", string);
                list = DiaryListValue.decode((String)string);
                outputWriter.printDiaryList("", "DiaryList Items:", (DiaryListValue)list);
            } else {
                outputWriter.printString("Encoded diary String: Null\n");
            }
            list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "AREncodeDiary Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void createAlertEvent() {
        try {
            outputWriter.driverPrintHeader("CREATE ALERT EVENT");
            String string = InputReader.getString("User");
            String string2 = InputReader.getString("Alert Text(): ", "");
            int n = InputReader.getInt("Alert Priority (0):", 0);
            String string3 = InputReader.getString("Alert Source");
            String string4 = InputReader.getString("Server Name: ", "");
            String string5 = InputReader.getString("Form Name");
            String string6 = InputReader.getString("Object Id(): ", "");
            this.beginAPICall();
            String string7 = this.getControlStructObject().createAlertEvent(string, string2, n, string3, string4, string5, string6);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printString("", "String:", string7);
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARCreateAlertEvent Status", list);
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void registerForAlerts() {
        try {
            outputWriter.driverPrintHeader("REGISTER FOR ALERTS");
            int n = InputReader.getInt("clientPort (0):", 0);
            int n2 = InputReader.getInt("registrationFlags (0):", 0);
            this.beginAPICall();
            this.getControlStructObject().registerForAlerts(n, n2);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARRegisterForAlerts Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void deregisterForAlerts() {
        try {
            outputWriter.driverPrintHeader("Deregister For Alerts");
            int n = InputReader.getInt("clientPort (0):", 0);
            this.beginAPICall();
            this.getControlStructObject().deregisterForAlerts(n);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARDeregisterForAlerts STatus", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListAlertUser() {
        try {
            outputWriter.driverPrintHeader("GET LIST ALERT USER");
            this.beginAPICall();
            List list = this.getControlStructObject().getListAlertUser();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "users List: ", list);
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetListAlertUser Status", list2);
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getAlertCount() {
        try {
            outputWriter.driverPrintHeader("GET ALERT COUNT");
            QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
            this.beginAPICall();
            int n = this.getControlStructObject().getAlertCount(qualifierInfo);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printInt("", "ALert Count = ", n, "\n");
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetAlertCount Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getLocalizedValue() {
        try {
            outputWriter.driverPrintHeader("GET LOCALIZED VALUE");
            LocalizedRequestInfo localizedRequestInfo = InputReader.getLocalizedRequestInfo();
            LocalizedValueCriteria localizedValueCriteria = InputReader.getLocalizedValueCriteria();
            this.beginAPICall();
            LocalizedValueInfo localizedValueInfo = this.getControlStructObject().getLocalizedValue(localizedValueCriteria, localizedRequestInfo);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            if (localizedValueInfo != null) {
                if (localizedValueInfo.getValue() != null) {
                    outputWriter.printValue("   ", "Localized Value: ", localizedValueInfo.getValue());
                }
                if (localizedValueInfo.getTimestamp() != null) {
                    outputWriter.printString("Got the time stamp");
                }
                outputWriter.printNewLine();
            }
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetLocalizedValue Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getMultipleLocalizedValues() {
        try {
            outputWriter.driverPrintHeader("GET LOCALIZED VALUES");
            int n = InputReader.getInt("Number of requests (1): ", 1);
            ArrayList<LocalizedRequestInfo> arrayList = new ArrayList<LocalizedRequestInfo>();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    arrayList.add(InputReader.getLocalizedRequestInfo());
                }
            }
            LocalizedValueCriteria localizedValueCriteria = InputReader.getLocalizedValueCriteria();
            this.beginAPICall();
            List list = this.getControlStructObject().getMultipleLocalizedValues(localizedValueCriteria, arrayList);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            for (int i = 0; i < list.size(); ++i) {
                if (((LocalizedValueInfo)list.get(i)).getValue() != null) {
                    outputWriter.printValue("   ", "Localized Request " + i + ": ", ((LocalizedValueInfo)list.get(i)).getValue());
                }
                if (((LocalizedValueInfo)list.get(i)).getTimestamp() == null) continue;
                outputWriter.printLong("   ", "Timestamp: ", ((LocalizedValueInfo)list.get(i)).getTimestamp().getValue(), "\n");
            }
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetMultipleLocalizedValues Status", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListFormWithAlias() {
        try {
            long l = InputReader.getLong("Get All changed since, as UNIX epoch (0): ", 0L);
            FormType formType = InputReader.getFormType();
            String string = null;
            if (formType != null && (formType.equals((Object)FormType.UPLINK) || formType.equals((Object)FormType.DOWNLINK))) {
                string = InputReader.getString("Form name (): ", "");
            }
            outputWriter.driverPrintPrompt("Ids of fields, which must be on the form:\n");
            int[] nArray = InputReader.getIntArray();
            String string2 = InputReader.getString("VUI Label (): ", "");
            this.beginAPICall();
            List list = this.getControlStructObject().getListFormAliases(l, formType.toInt(), string, nArray, string2);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Form Alias Info", list);
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "findAliases Status", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void decodeAlertMessage() {
        try {
            outputWriter.driverPrintHeader("DECODE ALERT MESSAGE");
            AlertMessageCriteria alertMessageCriteria = new AlertMessageCriteria();
            String string = InputReader.getString(" Message (): ", "");
            int n = string.length();
            this.beginAPICall();
            AlertMessageInfo alertMessageInfo = this.getControlStructObject().decodeAlertMessage(alertMessageCriteria, (Object)string.getBytes(), n);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printAlertMessageInfo("", "DecodeAlertMessage Results: ", alertMessageInfo);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void executeProcessForActiveLink() {
        try {
            outputWriter.driverPrintHeader("EXECUTE PROCESS FOR ACTIVE LINK");
            String string = InputReader.getString("Name of Active Link");
            int n = InputReader.getInt("Action Index (0): ", 0);
            int n2 = InputReader.getInt("actionType (0): ", 0);
            int n3 = InputReader.getInt("fieldid(0):", 0);
            Timestamp timestamp = InputReader.getTimestamp("timestamp", new Timestamp());
            outputWriter.driverPrintPrompt("Keyword List: \n");
            List<Value> list = InputReader.getValueList();
            outputWriter.driverPrintPrompt("Parameter List:\n");
            List<Value> list2 = InputReader.getValueList();
            boolean bl = InputReader.getBooleanForChangingInfo("Wait For process to complete (F): ", false);
            InputReader.getBooleanForChangingInfo("Get return command? (F): ", false);
            this.beginAPICall();
            ProcessResult processResult = this.getControlStructObject().executeProcessForActiveLink(string, n, n2, n3, timestamp, list, list2, bl);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printProcessResult("", "ARExecuteProcessForActiveLink Results:", processResult);
            List list3 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARExecuteProcessForActiveLink Status", list3);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListSQLForActiveLink() {
        try {
            outputWriter.driverPrintHeader("GETLIST SQL FOR ACTIVE LINK");
            String string = InputReader.getString("Name of Active Link ");
            int n = InputReader.getInt("Action Index (0): ", 0);
            int n2 = InputReader.getInt("action type (0): ", 0);
            Timestamp timestamp = InputReader.getTimestamp("timestamp", new Timestamp());
            outputWriter.driverPrintPrompt("Keyword List: \n");
            List<Value> list = InputReader.getValueList();
            outputWriter.driverPrintPrompt("Parameter List:\n");
            List<Value> list2 = InputReader.getValueList();
            int n3 = InputReader.getInt("Maximum number of entries to retrieve (500): ", 500);
            boolean bl = InputReader.getBoolean("Get Number of Matches (F): ", false);
            InputReader.getBooleanForChangingInfo("Get return command? (F): ", false);
            this.beginAPICall();
            SQLResult sQLResult = this.getControlStructObject().getListSQLForActiveLink(string, n, n2, timestamp, list, list2, n3, bl);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printSQLResult("", "ARGetListSQLForActiveLink Results:", sQLResult);
            List list3 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetListSQLForActiveLink Status", list3);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListExtFormCandidates(int n) {
        try {
            this.beginAPICall();
            List list = this.getControlStructObject().getListExtFormCandidates(n);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "ARGetListExtFormCandidates Results: ", list);
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetListExtFormCandidates Status", list2);
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListExtFormCandidates() {
        this.getListExtFormCandidates(5);
        this.getListExtFormCandidates(3);
    }

    void getMultipleExtFieldCandidates() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE EXTERNAL FIELD CANDIDATES");
            int n = InputReader.getInt("Form Type (3 or 5): ", 3);
            String string = "";
            String string2 = "";
            if (n == 3) {
                string2 = InputReader.getString("Table Name: ");
            } else if (n == 5) {
                string = InputReader.getString("Vendor Name: ");
                string2 = InputReader.getString("Table Name: ");
            } else {
                outputWriter.printString("Form type not applicable");
                return;
            }
            List list = null;
            this.beginAPICall();
            if (n == 3) {
                list = this.getControlStructObject().getListViewFormFieldCandidates(string2);
            } else if (n == 5) {
                list = this.getControlStructObject().getListVendorFormFieldCandidates(string, string2);
            }
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "ARGetListExtFormCandidates Results: ", list);
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetListExtFormCandidates Status", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getEntryStatistics() {
        try {
            outputWriter.driverPrintHeader("GET ENTRY STATISTICS");
            String string = InputReader.getString("Form Key:", "");
            QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
            outputWriter.driverPrintHeader("Target Expression:");
            ArithmeticOrRelationalOperand arithmeticOrRelationalOperand = InputReader.getArithmeticOrRelationalOperand();
            int n = InputReader.getInt("Statistic Operation to Perform (Count,Sum,Avg,Min,Max) (1-5)(1):", 1);
            outputWriter.driverPrintPrompt("Ids of fields to group statistics by:\n ");
            int[] nArray = InputReader.getInternalIDList();
            this.beginAPICall();
            List list = this.getControlStructObject().getEntryStatistics(string, qualifierInfo, arithmeticOrRelationalOperand, n, nArray);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "GET ENTRY STATISTICS RESULTS:", list);
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetEntryStatistics Status", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void validateLicense() {
        try {
            outputWriter.driverPrintHeader("VALIDATE LICENSE");
            String string = InputReader.getString("License Type: ");
            this.beginAPICall();
            LicenseValidInfo licenseValidInfo = this.getControlStructObject().validateLicense(string);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printLicenseValidInfo("", "ARValidateLicense Results:", licenseValidInfo);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getMultipleFields() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE FIELDS");
            String string = InputReader.getString("Form Name (): ", "");
            long l = InputReader.getLong("Get all changed since ", 0L);
            int n = InputReader.getInt("Field Type - data, trim, control, page, page holder, table, column, attach,\n attach pool  (1, 2, 4, 8, 16, 32, 64, 128, 256) (1): ", 1);
            FieldCriteria fieldCriteria = new FieldCriteria();
            fieldCriteria.setRetrieveAll(true);
            this.beginAPICall();
            List list = this.getControlStructObject().getListFieldObjects(string, n, l, fieldCriteria);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Field List Information:", list);
            outputWriter.printStatusInfoList("", "Status", this.getControlStructObject().getLastStatus());
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListLicense() {
        try {
            outputWriter.driverPrintHeader("GET LIST LICENSE");
            String string = InputReader.getString("License Type: ");
            this.beginAPICall();
            List list = this.getControlStructObject().getListLicense(string);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "ARGetListLicense Results:", list);
            outputWriter.printStatusInfoList("", "Status", this.getControlStructObject().getLastStatus());
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void validateMultipleLicenses() {
        try {
            outputWriter.driverPrintHeader("VALIDATE MULTIPLE LICENSE");
            List<String> list = InputReader.getStringList("", "license");
            this.beginAPICall();
            List list2 = this.getControlStructObject().validateMultipleLicense(list);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "ARValidateMultipleLicenses Results:", list2);
            outputWriter.printStatusInfoList("", "Status", this.getControlStructObject().getLastStatus());
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getListApplicationState() {
        try {
            outputWriter.driverPrintHeader("GET LIST APPLICATION STATE");
            this.beginAPICall();
            List list = this.getControlStructObject().getListApplicationState();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "getListApplicationState Results:", list);
            outputWriter.printStatusInfoList("", "Status", this.getControlStructObject().getLastStatus());
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getApplicationState() {
        try {
            outputWriter.driverPrintHeader("GET APPLICATION STATE");
            String string = InputReader.getString("Application Name:");
            this.beginAPICall();
            String string2 = this.getControlStructObject().getApplicationState(string);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Application State Data:", string2);
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Escalation Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void setApplicationState() {
        try {
            outputWriter.driverPrintHeader("GET APPLICATION STATE");
            String string = InputReader.getString("Application Name:");
            String string2 = InputReader.getString("New state:");
            this.beginAPICall();
            this.getControlStructObject().setApplicationState(string, string2);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.print("", "Application State Data:", string2);
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Get Escalation Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getSessionConfiguration() {
        try {
            outputWriter.driverPrintHeader("GET SESSION CONFIGURATION");
            int n = InputReader.getInt("Session Variable Id (0): ", 0);
            this.beginAPICall();
            ARServerUser aRServerUser = this.getControlStructObject();
            int n2 = 0;
            switch (n) {
                case 1: {
                    n2 = aRServerUser.getChunkResponseSize();
                    break;
                }
                case 2: {
                    n2 = aRServerUser.getTimeoutNormal();
                    break;
                }
                case 3: {
                    n2 = aRServerUser.getTimeoutLong();
                    break;
                }
                case 4: {
                    n2 = aRServerUser.getTimeoutXLong();
                    break;
                }
                case 5: {
                    n2 = aRServerUser.getServerRpcQueueNumber();
                    break;
                }
                case 7: {
                    n2 = aRServerUser.getClientType();
                    break;
                }
                case 8: {
                    n2 = aRServerUser.getVUIType();
                    break;
                }
                case 9: {
                    n2 = aRServerUser.getOverridePrevIP() ? 1 : 0;
                }
            }
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printInteger("   ", "Session Variable", n2);
            outputWriter.printStatusInfoList("", "Status", this.getControlStructObject().getLastStatus());
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
    }

    void setSessionConfiguration() {
        try {
            outputWriter.driverPrintHeader("SET SESSION CONFIGURATION");
            int n = InputReader.getInt("Variable Id (0): ", 0);
            Value value = InputReader.getValue();
            ARServerUser aRServerUser = this.getControlStructObject();
            this.beginAPICall();
            switch (n) {
                case 1: {
                    aRServerUser.setChunkResponseSize(((Integer)value.getValue()).intValue());
                    break;
                }
                case 2: {
                    aRServerUser.setTimeoutNormal(((Integer)value.getValue()).intValue());
                    break;
                }
                case 3: {
                    aRServerUser.setTimeoutLong(((Integer)value.getValue()).intValue());
                    break;
                }
                case 4: {
                    aRServerUser.setTimeoutXLong(((Integer)value.getValue()).intValue());
                    break;
                }
                case 5: {
                    aRServerUser.usePrivateRpcQueue(((Integer)value.getValue()).intValue());
                    break;
                }
                case 7: {
                    aRServerUser.setClientType(((Integer)value.getValue()).intValue());
                    break;
                }
                case 8: {
                    aRServerUser.setVUIType(((Integer)value.getValue()).intValue());
                    break;
                }
                case 9: {
                    int n2 = (Integer)value.getValue();
                    aRServerUser.setOverridePrevIP(n2 == 1);
                    break;
                }
                default: {
                    outputWriter.printString("Wrong tag for setSessionConfiguration tag = " + n);
                }
            }
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Session Results", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void xmlCreateEntry() {
        int n = 0;
        InputStreamReader inputStreamReader = null;
        try {
            outputWriter.driverPrintHeader("XML CREATE ENTRY");
            String string = null;
            for (int i = 0; i < 3; ++i) {
                string = InputReader.getString("Filename containing XML input mapping: ", "");
                if (string == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    inputStreamReader = new FileReader(string);
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    outputWriter.printString("Input file not found\n");
                    string = null;
                }
            }
            if (string == null) {
                return;
            }
            String string2 = "";
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[1024];
            while ((n = inputStreamReader.read(cArray, 0, cArray.length - 1)) >= 0) {
                stringBuffer.append(cArray, 0, n);
            }
            string2 = stringBuffer.toString();
            inputStreamReader.close();
            string = null;
            inputStreamReader = null;
            for (int i = 0; i < 3; ++i) {
                string = InputReader.getString("Filename containing XML input document: ", "");
                if (string == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    inputStreamReader = new FileReader(string);
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    outputWriter.printString("Input file not found\n");
                    string = null;
                }
            }
            if (string == null) {
                return;
            }
            String string3 = "";
            StringBuffer stringBuffer2 = new StringBuffer();
            while ((n = inputStreamReader.read(cArray, 0, cArray.length - 1)) >= 0) {
                stringBuffer2.append(cArray, 0, n);
            }
            string3 = stringBuffer2.toString();
            inputStreamReader.close();
            string = null;
            inputStreamReader = null;
            for (int i = 0; i < 3; ++i) {
                string = InputReader.getString("Filename containing XML output mapping: ", "");
                if (string == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    inputStreamReader = new FileReader(string);
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    outputWriter.printString("Input file not found\n");
                    string = null;
                }
            }
            if (string == null) {
                return;
            }
            String string4 = "";
            StringBuffer stringBuffer3 = new StringBuffer();
            while ((n = inputStreamReader.read(cArray, 0, cArray.length - 1)) >= 0) {
                stringBuffer3.append(cArray, 0, n);
            }
            string4 = stringBuffer3.toString();
            inputStreamReader.close();
            string = null;
            inputStreamReader = null;
            for (int i = 0; i < 3; ++i) {
                string = InputReader.getString("Filename containing XML option document: ", "");
                if (string == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    inputStreamReader = new FileReader(string);
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    outputWriter.printString("Input file not found\n");
                    string = null;
                }
            }
            if (string == null) {
                return;
            }
            String string5 = "";
            StringBuffer stringBuffer4 = new StringBuffer();
            while ((n = inputStreamReader.read(cArray, 0, cArray.length - 1)) >= 0) {
                stringBuffer4.append(cArray, 0, n);
            }
            string5 = stringBuffer4.toString();
            String string6 = null;
            this.beginAPICall();
            string6 = this.getControlStructObject().xmlCreateEntry(string2, string3, string4, string5);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "XMLCreateEntry Results", list);
            if (string6 != null) {
                outputWriter.printString(string6);
                return;
            }
            outputWriter.printString("xmlOutputDoc is null...\n");
            return;
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
            return;
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.printString("Null Pointer exception...\n");
            return;
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
            return;
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void xmlGetEntry() {
        int n = 0;
        InputStreamReader inputStreamReader = null;
        try {
            outputWriter.driverPrintHeader("XML GET ENTRY");
            String string = null;
            for (int i = 0; i < 3; ++i) {
                string = InputReader.getString("Filename containing XML query mapping: ", "");
                if (string == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    inputStreamReader = new FileReader(string);
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    outputWriter.printString("Input file not found\n");
                    string = null;
                }
            }
            if (string == null) {
                return;
            }
            String string2 = "";
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[1024];
            while ((n = inputStreamReader.read(cArray, 0, cArray.length - 1)) >= 0) {
                stringBuffer.append(cArray, 0, n);
            }
            string2 = stringBuffer.toString();
            inputStreamReader.close();
            string = null;
            inputStreamReader = null;
            for (int i = 0; i < 3; ++i) {
                string = InputReader.getString("Filename containing XML query document: ", "");
                if (string == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    inputStreamReader = new FileReader(string);
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    outputWriter.printString("Input file not found\n");
                    string = null;
                }
            }
            if (string == null) {
                return;
            }
            String string3 = "";
            StringBuffer stringBuffer2 = new StringBuffer();
            while ((n = inputStreamReader.read(cArray, 0, cArray.length - 1)) >= 0) {
                stringBuffer2.append(cArray, 0, n);
            }
            string3 = stringBuffer2.toString();
            inputStreamReader.close();
            string = null;
            inputStreamReader = null;
            for (int i = 0; i < 3; ++i) {
                string = InputReader.getString("Filename containing XML output mapping: ", "");
                if (string == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    inputStreamReader = new FileReader(string);
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    outputWriter.printString("Input file not found\n");
                    string = null;
                }
            }
            if (string == null) {
                return;
            }
            String string4 = "";
            StringBuffer stringBuffer3 = new StringBuffer();
            while ((n = inputStreamReader.read(cArray, 0, cArray.length - 1)) >= 0) {
                stringBuffer3.append(cArray, 0, n);
            }
            string4 = stringBuffer3.toString();
            inputStreamReader.close();
            string = null;
            inputStreamReader = null;
            for (int i = 0; i < 3; ++i) {
                string = InputReader.getString("Filename containing XML option document: ", "");
                if (string == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    inputStreamReader = new FileReader(string);
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    outputWriter.printString("Input file not found\n");
                    string = null;
                }
            }
            if (string == null) {
                return;
            }
            String string5 = "";
            StringBuffer stringBuffer4 = new StringBuffer();
            while ((n = inputStreamReader.read(cArray, 0, cArray.length - 1)) >= 0) {
                stringBuffer4.append(cArray, 0, n);
            }
            string5 = stringBuffer4.toString();
            String string6 = null;
            this.beginAPICall();
            string6 = this.getControlStructObject().xmlGetEntry(string2, string3, string4, string5);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "XMLGetEntry Results", list);
            if (string6 != null) {
                outputWriter.printString(string6);
                return;
            }
            outputWriter.printString("xmlOutputDoc is null...\n");
            return;
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
            return;
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.printString("Null Pointer exception...\n");
            return;
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
            return;
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void xmlSetEntry() {
        int n = 0;
        InputStreamReader inputStreamReader = null;
        try {
            outputWriter.driverPrintHeader("XML SET ENTRY");
            String string = null;
            for (int i = 0; i < 3; ++i) {
                string = InputReader.getString("Filename containing XML query mapping: ", "");
                if (string == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    inputStreamReader = new FileReader(string);
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    outputWriter.printString("Input file not found\n");
                    string = null;
                }
            }
            if (string == null) {
                return;
            }
            String string2 = "";
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[1024];
            while ((n = inputStreamReader.read(cArray, 0, cArray.length - 1)) >= 0) {
                stringBuffer.append(cArray, 0, n);
            }
            string2 = stringBuffer.toString();
            inputStreamReader.close();
            string = null;
            inputStreamReader = null;
            for (int i = 0; i < 3; ++i) {
                string = InputReader.getString("Filename containing XML query document: ", "");
                if (string == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    inputStreamReader = new FileReader(string);
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    outputWriter.printString("Input file not found\n");
                    string = null;
                }
            }
            if (string == null) {
                return;
            }
            String string3 = "";
            StringBuffer stringBuffer2 = new StringBuffer();
            while ((n = inputStreamReader.read(cArray, 0, cArray.length - 1)) >= 0) {
                stringBuffer2.append(cArray, 0, n);
            }
            string3 = stringBuffer2.toString();
            inputStreamReader.close();
            string = null;
            inputStreamReader = null;
            for (int i = 0; i < 3; ++i) {
                string = InputReader.getString("Filename containing XML input mapping: ", "");
                if (string == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    inputStreamReader = new FileReader(string);
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    outputWriter.printString("Input file not found\n");
                    string = null;
                }
            }
            if (string == null) {
                return;
            }
            String string4 = "";
            StringBuffer stringBuffer3 = new StringBuffer();
            while ((n = inputStreamReader.read(cArray, 0, cArray.length - 1)) >= 0) {
                stringBuffer3.append(cArray, 0, n);
            }
            string4 = stringBuffer3.toString();
            inputStreamReader.close();
            string = null;
            inputStreamReader = null;
            for (int i = 0; i < 3; ++i) {
                string = InputReader.getString("Filename containing XML input document: ", "");
                if (string == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    inputStreamReader = new FileReader(string);
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    outputWriter.printString("Input file not found\n");
                    string = null;
                }
            }
            if (string == null) {
                return;
            }
            String string5 = "";
            StringBuffer stringBuffer4 = new StringBuffer();
            while ((n = inputStreamReader.read(cArray, 0, cArray.length - 1)) >= 0) {
                stringBuffer4.append(cArray, 0, n);
            }
            string5 = stringBuffer4.toString();
            inputStreamReader.close();
            string = null;
            inputStreamReader = null;
            for (int i = 0; i < 3; ++i) {
                string = InputReader.getString("Filename containing XML output mapping: ", "");
                if (string == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    inputStreamReader = new FileReader(string);
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    outputWriter.printString("Input file not found\n");
                    string = null;
                }
            }
            if (string == null) {
                return;
            }
            String string6 = "";
            StringBuffer stringBuffer5 = new StringBuffer();
            while ((n = inputStreamReader.read(cArray, 0, cArray.length - 1)) >= 0) {
                stringBuffer5.append(cArray, 0, n);
            }
            string6 = stringBuffer5.toString();
            inputStreamReader.close();
            string = null;
            inputStreamReader = null;
            for (int i = 0; i < 3; ++i) {
                string = InputReader.getString("Filename containing XML option document: ", "");
                if (string == null) {
                    outputWriter.printString("Input file not found\n");
                    continue;
                }
                try {
                    inputStreamReader = new FileReader(string);
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    outputWriter.printString("Input file not found\n");
                    string = null;
                }
            }
            if (string == null) {
                return;
            }
            String string7 = "";
            StringBuffer stringBuffer6 = new StringBuffer();
            while ((n = inputStreamReader.read(cArray, 0, cArray.length - 1)) >= 0) {
                stringBuffer6.append(cArray, 0, n);
            }
            string7 = stringBuffer6.toString();
            this.beginAPICall();
            this.getControlStructObject().xmlSetEntry(string2, string3, string4, string5, string6, string7);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "XMLSetEntry Results", list);
            return;
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
            return;
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.printString("Null Pointer exception...\n");
            return;
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
            return;
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    void getMultipleCurrencyRatioSets() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE CURRENCY RATIO SETS");
            List<Timestamp> list = InputReader.getTimestampList();
            this.beginAPICall();
            List list2 = this.getControlStructObject().getMultipleCurrencyRatioSets(list);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list3 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetMultipleCurrencyRatioSets Results", list3);
            for (int i = 0; i < list2.size(); ++i) {
                outputWriter.printString((String)list2.get(i) + "\n");
            }
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getCurrencyRatio() {
        try {
            outputWriter.driverPrintHeader("GET CURRENCY RATIO");
            String string = InputReader.getString("Currency ratios string:", "");
            String string2 = InputReader.getString("From Currency Code:", "");
            System.out.println(string2);
            String string3 = InputReader.getString("To Currency Code:", "");
            System.out.println(string3);
            this.beginAPICall();
            BigDecimal bigDecimal = this.getControlStructObject().getCurrencyRatio(string.trim(), string2.trim(), string3.trim());
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "GetCurrencyRadio Results", list);
            outputWriter.printString("Currency Ratio: " + bigDecimal.toString());
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getQualifier() {
        try {
            Object object;
            QualifierInfo qualifierInfo;
            String string = InputReader.getString("Local Form Name: ");
            boolean bl = InputReader.getNullPromptOption();
            InputReader.setNullPromptOption(true);
            String string2 = InputReader.getString("Remote Form Name: ");
            InputReader.setNullPromptOption(bl);
            FieldCriteria fieldCriteria = new FieldCriteria();
            fieldCriteria.setRetrieveAll(true);
            List list = this.getControlStructObject().getListFieldObjects(string, 511, 0L, fieldCriteria);
            List list2 = null;
            if (string2 != null) {
                list2 = this.getControlStructObject().getListFieldObjects(string2, 511, 0L, fieldCriteria);
            }
            int n = InputReader.getInt("Enter ViewID (0):", 0);
            int n2 = InputReader.getInt("Customized? (0):", 0);
            String string3 = InputReader.getString("Qualifier String: ", "");
            if (n2 == 0) {
                qualifierInfo = list2 == null ? this.getControlStructObject().parseQualification(string3, list, null, 0) : this.getControlStructObject().parseQualification(string3, list2, list, 0);
            } else {
                object = new ARQualifierHelper();
                object.generateFieldMaps(list, n, null, list2);
                qualifierInfo = object.parseQualification(this.getControlStructObject().getLocale(), string3);
            }
            outputWriter.printQualifierInfo("", "", qualifierInfo);
            object = this.getControlStructObject().formatQualification(qualifierInfo, list, list2, 0, false);
            System.out.println("\nOriginal Query : " + string3);
            System.out.println("\nRebuilt Query : " + (String)object);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            outputWriter.printARException(aRException);
        }
    }

    void setImpersonatedUser() {
        try {
            outputWriter.driverPrintHeader("SET IMPERSONATED USER");
            String string = InputReader.getString("User To Impersonate: ", "");
            this.beginAPICall();
            this.getControlStructObject().impersonateUser(string);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            System.out.println("\nCall Returned OK");
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void dumpProxyInfo() {
        ProxyManager.PoolInfo[] poolInfoArray = ProxyManager.getPoolInformation();
        outputWriter.printString("Pooling Info:\n");
        for (int i = 0; i < poolInfoArray.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(poolInfoArray[i].getServerName()).append(" * ").append(new Integer(poolInfoArray[i].getInUse())).append(" * ").append(new Integer(poolInfoArray[i].getFree())).append(" * ").append(new Integer(poolInfoArray[i].getNotCreated()));
            outputWriter.printString(stringBuffer.toString());
            outputWriter.printString("\n");
        }
    }

    void setUseConnectionPooling() {
        boolean bl;
        boolean bl2 = bl = ProxyManager.isUseConnectionPooling();
        try {
            outputWriter.driverPrintHeader("SET CONNECTION POOLING");
            bl2 = InputReader.getBooleanForChangingInfo("Use Connection Pooling (false-true) (" + bl + "): ", bl);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (bl2 != bl) {
            ProxyManager.setUseConnectionPooling((boolean)bl2);
        }
    }

    void setConnectionLimitPerServer() throws IOException {
        outputWriter.driverPrintHeader("SET CONNECTION LIMITS PER SERVER");
        int n = InputReader.getInt("The connection limits per server :", maxConnectionPerServer);
        ProxyManager.setConnectionLimits((int)n);
    }

    void getServerCharSet() {
        try {
            outputWriter.driverPrintHeader("GET SERVER CHARSET");
            this.beginAPICall();
            String string = this.getControlStructObject().getServerCharSet();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printString("", "char-set: ", string, "\n");
            List list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetServerCharSet Status", list);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void beginApiRecording() {
        try {
            outputWriter.driverPrintHeader("BEGIN API RECORDING");
            int n = InputReader.getInt("Recording Mode (0,1,2,4,8,16,32,64)(0):", 0);
            String string = InputReader.getString("Command and Result Filename prefix:", "");
            List list = this.getControlStructObject().startRecording(n, string);
            if (list.size() != 0) {
                outputWriter.print("", "Api Recording files created", list);
            } else {
                outputWriter.printString("Problem in creating the Api Recording files\n");
            }
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
    }

    void stopApiRecording() {
        outputWriter.driverPrintHeader("STOP API RECORDING");
        this.getControlStructObject().stopRecording();
    }

    void termination() {
        this.getControlStructObject().logout();
    }

    void arImport() {
        try {
            outputWriter.driverPrintHeader("IMPORT");
            List<StructItemInfo> list = InputReader.getStructItemInfoList();
            String string = InputReader.getString("Filename containing import data:", "");
            String string2 = InputReader.getFileContents(string);
            int n = InputReader.getInt("The import option (0):", 0);
            this.beginAPICall();
            this.getControlStructObject().importDefFromBuffer(string2, n, list);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARImport ", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void getMultipleEntryPoints() {
        try {
            outputWriter.driverPrintHeader("GET MULTIPLE ENTRYPOINTS");
            long l = InputReader.getLong("Get All changed since, as UNIX epoch (0): ", 0L);
            List<String> list = InputReader.getStringList("", "Application name");
            int[] nArray = InputReader.getIntArray();
            String string = InputReader.getString("Display Tag ():", "");
            int n = InputReader.getInt("VUI Type (1-4) (0): ", 0);
            boolean bl = InputReader.getBoolean("Include hidden (false-true) (true): ", true);
            this.beginAPICall();
            List list2 = this.getControlStructObject().getListEntryPoint(l, list, nArray, n, string, bl);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List list3 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "ARGetMultipleEntryPoints ", list3);
            outputWriter.print("", "Entry Points List:", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.printString("Null Pointer exception...\n");
        }
        catch (ARException aRException) {
            outputWriter.printARException(aRException);
        }
    }

    void beginBulkEntryTransaction() {
        try {
            outputWriter.driverPrintHeader("BEGIN BULK ENTRY TRANSACTION");
            this.beginAPICall();
            this.getControlStructObject().beginBulkEntryTransaction();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printStatusInfoList("", "BeginBulkEntryTransaction Results", this.getControlStructObject().getLastStatus());
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void endBulkEntryTransaction() {
        List list = null;
        try {
            outputWriter.driverPrintHeader("END BULK ENTRY TRANSACTION");
            int n = InputReader.getInt("Action Type (1, 2): ", 1);
            this.beginAPICall();
            list = this.getControlStructObject().endBulkEntryTransaction(n);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printBulkEntryReturnList("   ", "Bulk Entry Return", list);
            outputWriter.printStatusInfoList("", "EndBulkEntryTransaction Results", this.getControlStructObject().getLastStatus());
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            if (((Object)((Object)aRException)).getClass() == ARBulkException.class) {
                list = ((ARBulkException)aRException).getBulkEntryReturn();
                outputWriter.printBulkEntryReturnList("   ", "Bulk Entry Return", list);
            }
            outputWriter.printARException(aRException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchThread(boolean bl) {
        block20: {
            ThreadStartInfo threadStartInfo = new ThreadStartInfo();
            try {
                SyncObject syncObject;
                String string;
                ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
                String string2 = bl ? "LAUNCH WAITING THREAD" : "LAUNCH THREAD";
                outputWriter.driverPrintHeader(string2);
                String string3 = InputReader.getString("Filename of input file (): ", "");
                if (string3 == null || string3.length() == 0) {
                    outputWriter.driverPrintError(" **** An input file is required to launch a thread\n");
                    return;
                }
                threadStartInfo.setInputFile(new InputFile(string3));
                String string4 = InputReader.getString("Filename of output file (): ", "");
                boolean bl2 = false;
                if (string4 == null || (quietMode & SUPPRESS_RESULTS) > 0) {
                    bl2 = true;
                } else if (string4.length() == 0) {
                    bl2 = true;
                }
                if (bl2) {
                    threadStartInfo.setOutputToStdOut();
                } else {
                    string = null;
                    string = JavaDriver.getResultDirectory() == null || JavaDriver.getResultDirectory().length() == 0 ? string4 : JavaDriver.getResultDirectory() + "\\" + string4;
                    threadStartInfo.setOutputFile(new PrintWriter(new FileOutputStream(new File(string))));
                    threadStartInfo.setOutputFileName(string);
                }
                string = InputReader.getString("Authentication string (): ", "");
                threadStartInfo.setAuthentication(string);
                String string5 = InputReader.getString("User name (): ", "");
                threadStartInfo.setUser(string5);
                String string6 = InputReader.getString("Password (): ", "");
                threadStartInfo.setPassword(string6);
                String string7 = InputReader.getString("Locale[.charSet] (): ", "");
                LocaleCharSet localeCharSet = new LocaleCharSet(string7);
                threadStartInfo.setLocale(localeCharSet.getLocale());
                threadStartInfo.setCharset(localeCharSet.getCharSet());
                String string8 = InputReader.getString("TimeZone () : ", "");
                threadStartInfo.setTimezone(string8);
                String string9 = InputReader.getString("Server (): ", "");
                threadStartInfo.setServer(string9);
                long l = InputReader.getLong("Thread startup sleep range (0): ", 0L);
                threadStartInfo.setUpperBound(l);
                threadStartInfo.setWaitFlag(bl);
                if (bl) {
                    threadStartInfo.setWaitObject(threadControlBlock.getWaitObject());
                    threadStartInfo.setReleaseObject(threadControlBlock.getReleaseObject());
                }
                JavaDriver javaDriver = this.instantiateJavaDriver();
                javaDriver.setThreadStartInfo(threadStartInfo);
                javaDriver.setPrimaryThread(false);
                javaDriver.start();
                threadControlBlock.addThreadHandle(javaDriver);
                if (!bl) break block20;
                SyncObject syncObject2 = syncObject = threadControlBlock.getWaitObject();
                synchronized (syncObject2) {
                    try {
                        while (!syncObject.getFlag()) {
                            syncObject.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        syncObject.setFlag(true);
                        System.out.println("Interrupted Exception ...in simplethread run");
                    }
                }
            }
            catch (IOException iOException) {
                try {
                    threadStartInfo.cleanUp();
                    outputWriter.printString("Problem in getting the input...Driver problem..\n");
                }
                catch (IOException iOException2) {
                    outputWriter.printString("Problem in cleaning up the thread start info..\n");
                }
            }
            catch (NullPointerException nullPointerException) {
                try {
                    threadStartInfo.cleanUp();
                    outputWriter.driverPrintException(nullPointerException);
                }
                catch (IOException iOException) {
                    outputWriter.printString("Problem in cleaning up the thread start info..\n");
                }
            }
        }
    }

    protected JavaDriver instantiateJavaDriver() {
        return new JavaDriver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadStartFunction() throws IOException {
        ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
        threadControlBlock.setCurrentInputFile(this.threadStartInfoObject.getInputFile());
        threadControlBlock.setOutputFile(this.threadStartInfoObject.getOutputFile(), this.threadStartInfoObject.getOutputFileName(), this.threadStartInfoObject.getIsStdOut());
        threadControlBlock.setAuthentication(this.threadStartInfoObject.getAuthentication());
        threadControlBlock.setUser(this.threadStartInfoObject.getUser());
        threadControlBlock.setPassword(this.threadStartInfoObject.getPassword());
        threadControlBlock.setLocale(this.threadStartInfoObject.getLocale());
        threadControlBlock.setServer(this.threadStartInfoObject.getServer());
        threadControlBlock.setPrimaryThread(false);
        if (this.threadStartInfoObject.getWaitFlag()) {
            SyncObject syncObject;
            SyncObject syncObject2 = syncObject = this.threadStartInfoObject.getWaitObject();
            synchronized (syncObject2) {
                syncObject.flag = true;
                syncObject.notify();
            }
            SyncObject syncObject3 = syncObject2 = this.threadStartInfoObject.getReleaseObject();
            synchronized (syncObject3) {
                try {
                    while (!syncObject2.getFlag()) {
                        syncObject2.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    syncObject2.setFlag(true);
                    System.out.println("Interrupted Exception ...in simplethread run");
                }
            }
        }
        if (this.threadStartInfoObject.getUpperBound() > 0L) {
            threadControlBlock.setCurrentCommand("rst");
            this.beginAPICall();
            timerCommandProcessor.randomSleep(0L, this.threadStartInfoObject.getUpperBound());
            this.endAPICall(this.getControlStructObject().getLastStatus());
        }
        this.threadStartInfoObject.cleanUp();
        this.threadStartInfoObject = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void run() {
        boolean bl = false;
        ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
        try {
            if (threadControlBlock == null) {
                threadControlBlock = this.initThreadControlBlockPtr();
            }
            if (this.isPrimaryThread()) {
                threadControlBlock.setPrimaryThread(true);
                threadControlBlock.setCurrentInputToStdIn();
                threadControlBlock.setOutputToStdOut();
                if (!this.processCommandLine()) {
                    System.exit(1);
                }
                outputWriter.driverPrintHelp();
                this.initCommandProcessing();
            } else {
                this.threadStartFunction();
            }
            this.processCommands();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            outputWriter.printString("IOException caught\n");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            outputWriter.printString("Exception caught" + exception.getLocalizedMessage() + "\n");
            System.out.println(exception.getLocalizedMessage());
            bl = true;
            return;
        }
        finally {
            try {
                this.destroyThreadControlBlockPtr(bl);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                this.termCommandProcessing();
                if (this.isPrimaryThread()) {
                    this.cleanupThreadEnvironment();
                }
                if (this.isPrimaryThread()) {
                    System.exit(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyThreadControlBlockPtr(boolean bl) throws IOException {
        ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
        try {
            threadControlBlock.closeOutputFile();
            threadControlBlock.closeInputFiles();
            threadControlBlock.closeRecordFile();
            Thread thread = (Thread)threadControlBlock.getThreadHandle();
            while (thread != null) {
                if (!bl && thread.isAlive()) {
                    try {
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                threadControlBlock.deleteThreadHandle();
                thread = (Thread)threadControlBlock.getThreadHandle();
            }
        }
        finally {
            threadControlBlock.setWaitObjectToNull();
            threadControlBlock.setReleaseObjectToNull();
        }
    }

    protected ThreadControlBlock initThreadControlBlockPtr() {
        localStorage = new ThreadControlLocalStorage();
        return (ThreadControlBlock)localStorage.get();
    }

    public static void main(String[] stringArray) {
        try {
            ProxyManager.setUseConnectionPooling((boolean)false);
            JavaDriver javaDriver = new JavaDriver();
            javaDriver.setCommandLineArgs(stringArray);
            javaDriver.setPrimaryThread(true);
            javaDriver.start();
        }
        catch (Exception exception) {
            outputWriter.printString("Error in executing the command\n");
        }
    }

    static {
        commandLineArgs = null;
        maxConnectionPerServer = 250;
        localStorage = null;
        randomNumberGenerator = null;
        timerCommandProcessor = new CommandProcessor();
        outputWriter = new OutputWriter();
        javaDriverOnly = true;
        SUPPRESS_RESULTS = 1;
        SUPPRESS_HEADERS = 2;
        SUPPRESS_PROMPTS = 4;
        SUPPRESS_MENU = 8;
        SUPPRESS_ERRORS = 16;
        SUPPRESS_WARNINGS = 32;
        MAX_NESTED_LOOP_DEPTH = 10;
        RAND_MAX = Short.MAX_VALUE;
    }
}

