/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.AopProxyFactory;
import org.springframework.aop.framework.Cglib2AopProxy;
import org.springframework.aop.framework.JdkDynamicAopProxy;
import org.springframework.util.ClassUtils;

public class DefaultAopProxyFactory
implements AopProxyFactory {
    private static final String CGLIB_ENHANCER_CLASS_NAME = "net.sf.cglib.proxy.Enhancer";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$aop$framework$DefaultAopProxyFactory == null ? (class$org$springframework$aop$framework$DefaultAopProxyFactory = DefaultAopProxyFactory.class$("org.springframework.aop.framework.DefaultAopProxyFactory")) : class$org$springframework$aop$framework$DefaultAopProxyFactory));
    private static boolean cglibAvailable = ClassUtils.isPresent("net.sf.cglib.proxy.Enhancer");
    static /* synthetic */ Class class$org$springframework$aop$framework$DefaultAopProxyFactory;

    public AopProxy createAopProxy(AdvisedSupport advisedSupport) throws AopConfigException {
        if (advisedSupport.isOptimize() || advisedSupport.isProxyTargetClass() || advisedSupport.getProxiedInterfaces().length == 0) {
            if (!cglibAvailable) {
                throw new AopConfigException("Cannot proxy target class because CGLIB2 is not available. Add CGLIB to the class path or specify proxy interfaces.");
            }
            return CglibProxyFactory.createCglibProxy(advisedSupport);
        }
        return new JdkDynamicAopProxy(advisedSupport);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (cglibAvailable) {
            logger.info((Object)"CGLIB2 available: proxyTargetClass feature enabled");
        } else {
            logger.info((Object)"CGLIB2 not available: proxyTargetClass feature disabled");
        }
    }

    private static class CglibProxyFactory {
        private CglibProxyFactory() {
        }

        private static AopProxy createCglibProxy(AdvisedSupport advisedSupport) {
            return new Cglib2AopProxy(advisedSupport);
        }
    }
}

