/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.ARCryptoConstants;
import com.bmc.arsys.arencrypt.AREncKeyBase;
import com.bmc.arsys.arencrypt.AREncryptionException;
import java.math.BigInteger;
import java.security.Key;

public abstract class ARPPKey
extends AREncKeyBase {
    private transient int d;
    private transient String c;
    private transient String b = "3";
    protected transient Key encKey;
    protected boolean debug;

    protected ARPPKey() {
    }

    public void setAlgorithmParam(int n) throws AREncryptionException {
        if (n < 4 || n > 6) {
            throw new AREncryptionException(9006);
        }
        this.a(n);
        this.do(ARCryptoConstants.goto[n - 1]);
        this.setModulusBitSize(ARCryptoConstants.G[n - 4]);
        this.setModulusBitSizeStr(ARCryptoConstants.I[n - 4]);
        this.a("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
    }

    protected int getModulusBitSize() {
        return this.d;
    }

    protected BigInteger getBigModulus() {
        return new BigInteger(1, this.getKey());
    }

    protected BigInteger getBigExponent() {
        return new BigInteger(this.b);
    }

    protected String getBigExponentStr() {
        return this.b;
    }

    protected void setBigExponent(String string) {
        this.b = string;
    }

    protected void setModulusBitSize(int n) {
        this.d = n;
    }

    protected abstract Key getRsaKey() throws AREncryptionException;

    protected void setModulusBitSizeStr(String string) {
        this.c = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        if (this.c != null) {
            stringBuilder.append("_P_").append(this.c);
        }
        return stringBuilder.toString();
    }
}

