/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.ARServerUser;
import com.remedy.arsys.api.ContainerCriteria;
import com.remedy.arsys.api.ContainerKey;
import com.remedy.arsys.api.ContainerOwner;
import com.remedy.arsys.api.ContainerType;
import com.remedy.arsys.api.CriteriaFlags;
import com.remedy.arsys.api.IARPersistentObject;
import com.remedy.arsys.api.InternalID;
import com.remedy.arsys.api.NameID;
import com.remedy.arsys.api.ObjectBase;
import com.remedy.arsys.api.PropInfo;
import com.remedy.arsys.api.Proxy;
import com.remedy.arsys.api.ProxyManager;
import com.remedy.arsys.api.ReferenceBase;
import com.remedy.arsys.api.StringHelper;
import com.remedy.arsys.api.Util;

public class Container
extends ObjectBase
implements IARPersistentObject,
Cloneable {
    private ARServerUser m_session;
    private InternalID[] m_adminGrpList;
    private char[] m_label;
    private char[] m_description;
    private ContainerType m_type;
    private ReferenceBase[] m_references;
    private ContainerOwner[] m_containerOwner;
    private PropInfo[] m_props;
    private boolean m_removeFlag;
    private NameID m_newName;
    private static final int TOTAL_PARAMS = 5;

    Container() {
        this.m_changeFlags = new CriteriaFlags(5);
    }

    Container(NameID nameID) {
        this.m_changeFlags = new CriteriaFlags(5);
        this.setName(nameID);
        this.setKey(new ContainerKey(nameID));
    }

    public ContainerKey getKey() {
        return new ContainerKey(this.getName());
    }

    public void setKey(ContainerKey containerKey) {
        this.setName(containerKey);
    }

    public void setAdminGroupList(InternalID[] internalIDArray) {
        this.m_adminGrpList = internalIDArray;
    }

    public InternalID[] getAdminGroupList() {
        return this.m_adminGrpList;
    }

    public void setLabel(String string) {
        if (null == this.m_label) {
            this.m_label = new char[255];
        }
        StringHelper.toChars(string, this.m_label, 255);
    }

    public char[] getLabel() {
        return this.m_label;
    }

    public void setDescription(String string) {
        if (null == this.m_description) {
            this.m_description = new char[2000];
        }
        StringHelper.toChars(string, this.m_description, 2000);
    }

    public char[] getDescription() {
        return this.m_description;
    }

    public ContainerType getType() {
        return this.m_type;
    }

    int getContainerTypeInt() {
        return this.m_type.toInt();
    }

    void setContainerTypeInt(int n) {
        this.m_type = ContainerType.toContainerType(n);
    }

    public void setType(ContainerType containerType) {
        this.m_type = containerType;
    }

    public void setReferences(ReferenceBase[] referenceBaseArray) {
        this.m_references = referenceBaseArray;
    }

    public ReferenceBase[] getReferences() {
        return this.m_references;
    }

    public void setContainerOwner(ContainerOwner[] containerOwnerArray) {
        this.m_containerOwner = containerOwnerArray;
    }

    public ContainerOwner[] getContainerOwner() {
        return this.m_containerOwner;
    }

    public void setProperties(PropInfo[] propInfoArray) {
        this.m_props = propInfoArray;
    }

    public PropInfo[] getProperties() {
        return this.m_props;
    }

    public void setRemoveFlag(boolean bl) {
        this.m_removeFlag = bl;
    }

    public boolean getRemoveFlag() {
        return this.m_removeFlag;
    }

    public void setNewname(NameID nameID) {
        this.m_newName = nameID;
    }

    public NameID getNewname() {
        return this.m_newName;
    }

    public void setContext(ARServerUser aRServerUser) {
        this.m_session = aRServerUser;
    }

    public void unsetContext() {
        this.m_session = null;
    }

    public void clear() {
        super.clear();
        this.m_adminGrpList = null;
        this.m_label = null;
        this.m_description = null;
        this.m_type = null;
        this.m_references = null;
        this.m_containerOwner = null;
        this.m_props = null;
        this.m_newName = null;
    }

    public Object clone() throws CloneNotSupportedException {
        Container container = (Container)super.clone();
        int n = this.m_adminGrpList.length;
        container.m_adminGrpList = new InternalID[n];
        int n2 = 0;
        while (n2 < n) {
            container.m_adminGrpList[n2] = (InternalID)this.m_adminGrpList[n2].clone();
            ++n2;
        }
        n = this.m_label.length;
        container.m_label = new char[n];
        System.arraycopy(this.m_label, 0, container.m_label, 0, n);
        n = this.m_description.length;
        container.m_description = new char[n];
        System.arraycopy(this.m_description, 0, container.m_description, 0, n);
        container.m_type = (ContainerType)this.m_type.clone();
        n = this.m_references.length;
        container.m_references = new ReferenceBase[n];
        int n3 = 0;
        while (n3 < n) {
            container.m_references[n3] = (ReferenceBase)this.m_references[n3].clone();
            ++n3;
        }
        container.m_containerOwner = (ContainerOwner[])this.m_containerOwner.clone();
        n = this.m_props.length;
        container.m_props = new PropInfo[n];
        n3 = 0;
        while (n3 < n) {
            container.m_props[n3] = (PropInfo)this.m_props[n3].clone();
            ++n3;
        }
        container.m_newName = (NameID)this.m_newName.clone();
        return container;
    }

    public void create() throws ARException {
        if (this.m_session == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_session.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_session, bl);
        try {
            proxy.ARCreateContainer(this.m_session, this);
            Object var5_3 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
            throw throwable;
        }
    }

    public void remove() throws ARException {
        if (this.m_session == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_session.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_session, bl);
        try {
            proxy.ARDeleteContainer(this.m_session, this.getKey());
            Object var5_3 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
            throw throwable;
        }
    }

    public void load() throws ARException {
        if (this.m_session == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_session.isProxyInContext();
        ContainerCriteria containerCriteria = new ContainerCriteria();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_session, bl);
        try {
            proxy.ARGetContainer(this.m_session, this.getKey(), containerCriteria, this);
            Object var6_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
            throw throwable;
        }
    }

    public void load(ContainerCriteria containerCriteria) throws ARException {
        if (this.m_session == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_session.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_session, bl);
        try {
            proxy.ARGetContainer(this.m_session, this.getKey(), containerCriteria, this);
            Object var6_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
            throw throwable;
        }
    }

    public void store() throws ARException {
        if (this.m_session == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_session.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_session, bl);
        try {
            proxy.ARSetContainer(this.m_session, this);
            Object var5_3 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
            throw throwable;
        }
    }

    public void activate() {
    }

    public void passivate() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        if (this == object) {
            return true;
        }
        if (object == null) return false;
        if (!(object instanceof Container)) {
            return false;
        }
        Container container = (Container)object;
        if (!super.equals(container)) return false;
        if (!Util.equals(this.m_adminGrpList, container.m_adminGrpList)) return false;
        if (this.m_label == null) {
            if (container.m_label != null) return false;
            bl3 = true;
        } else {
            bl3 = new String(this.m_label).equals(new String(container.m_label));
        }
        if (!bl3) return false;
        if (this.m_description == null) {
            if (container.m_description != null) return false;
            bl2 = true;
        } else {
            bl2 = new String(this.m_description).equals(new String(container.m_description));
        }
        if (!bl2) return false;
        if (this.m_type == null) {
            if (container.m_type != null) return false;
            bl = true;
        } else {
            bl = this.m_type.equals(container.m_type);
        }
        if (!bl) return false;
        if (!Util.equals(this.m_references, container.m_references)) return false;
        if (!Util.equals(this.m_containerOwner, container.m_containerOwner)) return false;
        if (!Util.equals(this.m_props, container.m_props)) return false;
        if (this.m_removeFlag != container.m_removeFlag) return false;
        if (this.m_newName == null) {
            if (container.m_newName != null) return false;
            return true;
        }
        boolean bl4 = this.m_newName.equals(container.m_newName);
        if (!bl4) return false;
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

