/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.ARServerUser;
import com.remedy.arsys.api.DefaultProxyManager;
import com.remedy.arsys.api.PoolingProxyManager;
import com.remedy.arsys.api.Proxy;

public abstract class ProxyManager {
    private static int maxProxiesPerServer = 10;
    private static boolean useConnectionPooling = false;
    private static ProxyManager currentManager = new DefaultProxyManager();

    public static ProxyManager getProxyManager() {
        return currentManager;
    }

    public static void setConnectionLimits(int n) {
        maxProxiesPerServer = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUseConnectionPooling(boolean bl) {
        if (useConnectionPooling == bl) {
            return;
        }
        ProxyManager proxyManager = currentManager;
        synchronized (proxyManager) {
            if (bl) {
                currentManager = new PoolingProxyManager(maxProxiesPerServer);
                useConnectionPooling = true;
            } else {
                currentManager.clear();
                currentManager = new DefaultProxyManager();
                useConnectionPooling = false;
            }
        }
    }

    public static PoolInfo[] getPoolInformation() {
        return currentManager.getInfo();
    }

    synchronized PoolInfo[] getInfo() {
        return new PoolInfo[0];
    }

    public abstract Proxy getProxy(ARServerUser var1, boolean var2) throws ARException;

    public abstract void releaseProxy(Proxy var1, ARServerUser var2, boolean var3);

    synchronized void clear() {
    }

    public static class PoolInfo {
        protected String mServerKey;
        protected int mFree;
        protected int mInUse;
        protected int mNotCreated;

        PoolInfo(String string, int n, int n2, int n3) {
            this.mServerKey = string;
            this.mInUse = n;
            this.mFree = n2;
            this.mNotCreated = n3;
        }

        public String getServerName() {
            return this.mServerKey;
        }

        public int getInUse() {
            return this.mInUse;
        }

        public int getFree() {
            return this.mFree;
        }

        public int getNotCreated() {
            return this.mNotCreated;
        }
    }
}

