/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.ARServerUser;
import com.remedy.arsys.api.ArchiveInfo;
import com.remedy.arsys.api.CompoundSchemaInfo;
import com.remedy.arsys.api.CriteriaFlags;
import com.remedy.arsys.api.EntryListFieldInfo;
import com.remedy.arsys.api.FieldID;
import com.remedy.arsys.api.IARPersistentObject;
import com.remedy.arsys.api.IndexInfo;
import com.remedy.arsys.api.InternalID;
import com.remedy.arsys.api.NameID;
import com.remedy.arsys.api.ObjectBase;
import com.remedy.arsys.api.PermissionInfo;
import com.remedy.arsys.api.PropInfo;
import com.remedy.arsys.api.Proxy;
import com.remedy.arsys.api.ProxyManager;
import com.remedy.arsys.api.SchemaCriteria;
import com.remedy.arsys.api.SchemaKey;
import com.remedy.arsys.api.SortInfo;
import com.remedy.arsys.api.Util;

public class Schema
extends ObjectBase
implements IARPersistentObject,
Cloneable {
    private ARServerUser m_context;
    private CompoundSchemaInfo m_compoundSchema;
    private EntryListFieldInfo[] m_getListFields = null;
    private InternalID[] m_adminGrpList;
    private SortInfo[] m_sortInfo;
    private IndexInfo[] m_indexInfo;
    private ArchiveInfo m_archiveInfo;
    private int m_deleteOption;
    private PropInfo[] m_props;
    private NameID m_defaultVUI;
    private static final int TOTAL_PARAMS = 13;
    private static final int NEW_COMPOUND_SCHEMA = 5;
    private static final int NEW_INTERNALID = 6;
    private static final int NEW_ENTRY_LIST_FIELD = 7;
    private static final int NEW_SORT_LIST = 8;
    private static final int NEW_INDEX_LIST = 9;
    private static final int NEW_ARCHIVE_INFO = 10;
    private static final int NEW_PROPERTIES = 11;
    private static final int NEW_DEFAULTVIEW = 12;

    Schema() {
        this.m_compoundSchema = new CompoundSchemaInfo();
        this.m_compoundSchema.m_type = 1;
        this.m_changeFlags = new CriteriaFlags(13);
    }

    Schema(NameID nameID) {
        this.setName(nameID);
        this.m_compoundSchema = new CompoundSchemaInfo();
        this.m_compoundSchema.m_type = 1;
        this.m_changeFlags = new CriteriaFlags(13);
    }

    protected Schema(String string, PermissionInfo[] permissionInfoArray, String string2, long l, String string3, String string4, String string5) {
        super(string, null, string2, l, string3, string4, string5);
        if (permissionInfoArray == null) {
            this.m_permissionList = null;
        } else {
            this.m_permissionList = new PermissionInfo[permissionInfoArray.length];
            for (int i = 0; i < permissionInfoArray.length; ++i) {
                long l2 = permissionInfoArray[i].getGroupID().getValue();
                int n = new Long(l2).intValue();
                this.m_permissionList[i] = new PermissionInfo(n, permissionInfoArray[i].getPermissionValue());
            }
        }
    }

    public void setAdminGrpList(InternalID[] internalIDArray) {
        this.m_adminGrpList = internalIDArray;
        if (this.m_adminGrpList != null) {
            for (int i = 0; i < this.m_adminGrpList.length; ++i) {
                long l = this.m_adminGrpList[i].getValue();
                int n = new Long(l).intValue();
                this.m_adminGrpList[i] = new InternalID(n);
            }
        }
        this.m_changeFlags.setParameter(6L, true);
    }

    public void setPermissions(PermissionInfo[] permissionInfoArray) {
        if (permissionInfoArray == null) {
            this.m_permissionList = null;
        } else {
            this.m_permissionList = new PermissionInfo[permissionInfoArray.length];
            for (int i = 0; i < permissionInfoArray.length; ++i) {
                long l = permissionInfoArray[i].getGroupID().getValue();
                int n = new Long(l).intValue();
                this.m_permissionList[i] = new PermissionInfo(n, permissionInfoArray[i].getPermissionValue());
            }
        }
        this.m_changeFlags.setParameter(1L, true);
    }

    public InternalID[] getAdminGrpList() {
        return this.m_adminGrpList;
    }

    public SortInfo[] getSortInfo() {
        return this.m_sortInfo;
    }

    public void setSortInfo(SortInfo[] sortInfoArray) {
        this.m_sortInfo = sortInfoArray;
        this.m_changeFlags.setParameter(8L, true);
    }

    public void setIndexInfo(IndexInfo[] indexInfoArray) {
        this.m_indexInfo = indexInfoArray;
        this.m_changeFlags.setParameter(9L, true);
    }

    public IndexInfo[] getIndexInfo() {
        return this.m_indexInfo;
    }

    public void setArchiveInfo(ArchiveInfo archiveInfo) {
        this.m_archiveInfo = archiveInfo;
        this.m_changeFlags.setParameter(10L, true);
    }

    public ArchiveInfo getArchiveInfo() {
        return this.m_archiveInfo;
    }

    public void setEntryListFieldInfo(EntryListFieldInfo[] entryListFieldInfoArray) {
        this.m_getListFields = entryListFieldInfoArray;
        this.m_changeFlags.setParameter(7L, true);
    }

    public EntryListFieldInfo[] getEntryListFieldInfo() {
        return this.m_getListFields;
    }

    public void setDeleteOption(int n) {
        this.m_deleteOption = n;
    }

    int getDeleteOption() {
        return this.m_deleteOption;
    }

    public void setSchemaType(int n, CompoundSchemaInfo compoundSchemaInfo) {
        if (n != 1 && n != 0 && n != 4) {
            this.m_compoundSchema = compoundSchemaInfo;
        }
        this.m_compoundSchema.m_type = n;
        this.m_changeFlags.setParameter(5L, true);
    }

    private void setSchemaType(int n) {
        this.m_compoundSchema.m_type = n;
        this.m_changeFlags.setParameter(5L, true);
    }

    private void setCompoundSchema(CompoundSchemaInfo compoundSchemaInfo) {
        this.m_compoundSchema = compoundSchemaInfo;
        this.m_changeFlags.setParameter(5L, true);
    }

    public int getSchemaType() {
        return this.m_compoundSchema.m_type;
    }

    public CompoundSchemaInfo getCompoundSchema() {
        return this.m_compoundSchema;
    }

    public void setProperties(PropInfo[] propInfoArray) {
        this.m_props = propInfoArray;
        this.m_changeFlags.setParameter(11L, true);
    }

    public PropInfo[] getProperties() {
        return this.m_props;
    }

    public SchemaKey getKey() {
        return new SchemaKey(this.getName());
    }

    public void setKey(SchemaKey schemaKey) {
        this.setName(schemaKey);
    }

    public void setDefaultVUI(NameID nameID) {
        this.m_defaultVUI = nameID;
        this.m_changeFlags.setParameter(12L, true);
    }

    public NameID getDefaultVUI() {
        return this.m_defaultVUI;
    }

    public void deleteFields(FieldID[] fieldIDArray, int n) throws ARException {
        boolean bl;
        long[] lArray = new long[fieldIDArray.length];
        for (bl = false; bl < fieldIDArray.length; bl += 1) {
            lArray[bl] = fieldIDArray[bl].toLong();
        }
        bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        try {
            proxy.ARDeleteMultipleFields(this.m_context, this.getName(), lArray, this.m_deleteOption);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        int n;
        Schema schema = null;
        schema = (Schema)super.clone();
        schema.m_compoundSchema = (CompoundSchemaInfo)this.m_compoundSchema.clone();
        schema.m_defaultVUI = (NameID)this.m_defaultVUI.clone();
        int n2 = this.m_getListFields.length;
        schema.m_getListFields = new EntryListFieldInfo[n2];
        for (n = 0; n < n2; ++n) {
            schema.m_getListFields[n] = (EntryListFieldInfo)this.m_getListFields[n].clone();
        }
        n2 = this.m_adminGrpList.length;
        schema.m_adminGrpList = new InternalID[n2];
        for (n = 0; n < n2; ++n) {
            schema.m_adminGrpList[n] = (InternalID)this.m_adminGrpList[n].clone();
        }
        n2 = this.m_sortInfo.length;
        schema.m_sortInfo = new SortInfo[n2];
        for (n = 0; n < n2; ++n) {
            schema.m_sortInfo[n] = (SortInfo)this.m_sortInfo[n].clone();
        }
        n2 = this.m_indexInfo.length;
        schema.m_indexInfo = new IndexInfo[n2];
        for (n = 0; n < n2; ++n) {
            schema.m_indexInfo[n] = (IndexInfo)this.m_indexInfo[n].clone();
        }
        n2 = this.m_props.length;
        schema.m_props = new PropInfo[n2];
        for (n = 0; n < n2; ++n) {
            schema.m_props[n] = (PropInfo)this.m_props[n].clone();
        }
        return schema;
    }

    public void create() throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        try {
            proxy.ARCreateSchema(this.m_context, this);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        this.resetChangeFlags();
    }

    public void remove() throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        try {
            proxy.ARDeleteSchema(this.m_context, this.getName(), this.m_deleteOption);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
    }

    public void load(SchemaCriteria schemaCriteria) throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        SchemaKey schemaKey = new SchemaKey(this.getName());
        try {
            proxy.ARGetSchema(this.m_context, schemaKey, schemaCriteria, this);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        this.resetChangeFlags();
    }

    public void load() throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        SchemaCriteria schemaCriteria = new SchemaCriteria();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        SchemaKey schemaKey = new SchemaKey(this.getName());
        try {
            proxy.ARGetSchema(this.m_context, schemaKey, schemaCriteria, this);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        this.resetChangeFlags();
    }

    public void store() throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        try {
            proxy.ARSetSchema(this.m_context, this, this.m_changeFlags.getParameters());
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        this.resetChangeFlags();
    }

    public void activate() {
    }

    public void passivate() {
    }

    public ARServerUser getContext() {
        return this.m_context;
    }

    public void setContext(ARServerUser aRServerUser) {
        this.m_context = aRServerUser;
    }

    public void unsetContext() {
        this.m_context = null;
    }

    public void clear() {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Schema)) {
            return false;
        }
        Schema schema = (Schema)object;
        return super.equals(schema) && (this.m_compoundSchema == null ? schema.m_compoundSchema == null : this.m_compoundSchema.equals(schema.m_compoundSchema)) && Util.equals(this.m_getListFields, schema.m_getListFields) && Util.equals(this.m_adminGrpList, schema.m_adminGrpList) && Util.equals(this.m_sortInfo, schema.m_sortInfo) && Util.equals(this.m_indexInfo, schema.m_indexInfo) && this.m_deleteOption == schema.m_deleteOption && Util.equals(this.m_props, schema.m_props) && (this.m_defaultVUI == null ? schema.m_defaultVUI == null : this.m_defaultVUI.equals(schema.m_defaultVUI));
    }

    public int hashCode() {
        return super.hashCode();
    }
}

