/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.AttachmentInfo;
import com.remedy.arsys.api.ByteListInfo;
import com.remedy.arsys.api.CoordinateInfo;
import com.remedy.arsys.api.CurrencyInfo;
import com.remedy.arsys.api.DataType;
import com.remedy.arsys.api.DateInfo;
import com.remedy.arsys.api.Diary;
import com.remedy.arsys.api.FieldID;
import com.remedy.arsys.api.Keyword;
import com.remedy.arsys.api.Time;
import com.remedy.arsys.api.Timestamp;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;

public class Value
implements Cloneable,
Serializable {
    private DataType _dataType;
    private Object _value;
    static Method decimalToPlainStringMethod;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public Value() {
        this._value = null;
        this._dataType = DataType.NULL;
    }

    public Value(String string, DataType dataType) {
        switch (dataType.toInt()) {
            case 2: {
                this._value = new Integer(string);
                this._dataType = DataType.INTEGER;
                break;
            }
            case 3: {
                this._value = new Double(string);
                this._dataType = DataType.REAL;
                break;
            }
            case 4: {
                this._value = string;
                this._dataType = DataType.CHAR;
                break;
            }
            case 7: {
                long l = new Long(string);
                this._value = new Timestamp(l);
                this._dataType = DataType.TIME;
                break;
            }
            case 8: {
                this._value = new Long(string);
                this._dataType = DataType.BITMASK;
                break;
            }
            case 14: {
                long l = new Long(string);
                this._value = new Time(l);
                this._dataType = DataType.TIME_OF_DAY;
                break;
            }
            case 10: {
                this._value = new BigDecimal(string);
                this._dataType = DataType.DECIMAL;
                break;
            }
            case 40: {
                this._value = new Long(string);
                this._dataType = DataType.ULONG;
                break;
            }
            case 6: {
                this._value = new Long(string);
                this._dataType = DataType.ENUM;
                break;
            }
            case 42: {
                this._value = string;
                this._dataType = DataType.VIEW;
                break;
            }
            case 43: {
                this._value = string;
                this._dataType = DataType.DISPLAY;
                break;
            }
            case 13: {
                this._value = new DateInfo(string);
                this._dataType = DataType.DATE;
                break;
            }
            case 12: {
                this._value = new CurrencyInfo(string);
                this._dataType = DataType.CURRENCY;
                break;
            }
            default: {
                throw new IllegalArgumentException("datatype not supported by this method");
            }
        }
    }

    public Value(Keyword keyword) {
        this._value = keyword;
        this._dataType = DataType.KEYWORD;
    }

    public Value(int n) {
        this._value = new Integer(n);
        this._dataType = DataType.INTEGER;
    }

    public Value(double d) {
        this._value = new Double(d);
        this._dataType = DataType.REAL;
    }

    public Value(String string) {
        this._value = string;
        this._dataType = DataType.CHAR;
    }

    public Value(Diary diary) {
        this._value = diary;
        this._dataType = DataType.DIARY;
    }

    public Value(long l) {
        this._value = new Long(l);
        this._dataType = DataType.ULONG;
    }

    public Value(DataType dataType, long l) throws IllegalArgumentException {
        if (dataType != DataType.ENUM && dataType != DataType.ULONG && dataType != DataType.BITMASK) {
            throw new IllegalArgumentException("datatype should be enum,long or bitmask");
        }
        this._value = new Long(l);
        this._dataType = dataType;
    }

    public Value(ByteListInfo byteListInfo) {
        this._value = byteListInfo;
        this._dataType = DataType.BYTES;
    }

    public Value(Timestamp timestamp) {
        this._value = timestamp;
        this._dataType = DataType.TIME;
    }

    public Value(Time time) {
        this._value = time;
        this._dataType = DataType.TIME_OF_DAY;
    }

    public Value(BigDecimal bigDecimal) {
        this._value = bigDecimal;
        this._dataType = DataType.DECIMAL;
    }

    public Value(CurrencyInfo currencyInfo) {
        this._value = currencyInfo;
        this._dataType = DataType.CURRENCY;
    }

    public Value(DateInfo dateInfo) {
        this._value = dateInfo;
        this._dataType = DataType.DATE;
    }

    public Value(AttachmentInfo attachmentInfo) {
        this._value = attachmentInfo;
        this._dataType = DataType.ATTACHMENT;
    }

    public Value(CoordinateInfo[] coordinateInfoArray) {
        this._value = coordinateInfoArray;
        this._dataType = DataType.COORDS;
    }

    public Value(FieldID fieldID) {
        this._value = new Long(fieldID.toLong());
        this._dataType = DataType.ULONG;
    }

    Value(int n, long l) {
        this._value = new Long(l);
        this._dataType = DataType.toDataType(n);
    }

    Value(int n, String string) {
        DataType dataType = DataType.toDataType(n);
        if (!(dataType.equals(DataType.DECIMAL) || dataType.equals(DataType.VIEW) || dataType.equals(DataType.DISPLAY))) {
            throw new IllegalArgumentException("datatype should be decimal, view or display");
        }
        if (dataType.equals(DataType.DECIMAL)) {
            if (".".equals(string)) {
                string = "0";
            }
            this._value = new BigDecimal(string);
        } else if (dataType.equals(DataType.VIEW) || dataType.equals(DataType.DISPLAY)) {
            this._value = string;
        }
        this._dataType = DataType.toDataType(n);
    }

    void setKeyword(int n) {
        this._dataType = DataType.KEYWORD;
        this._value = Keyword.toKeyword(n);
    }

    public Object getValue() {
        return this._value;
    }

    public DataType getDataType() {
        return this._dataType;
    }

    public void describe() {
        System.out.println(this._value);
    }

    int getType() {
        return this._dataType.toInt();
    }

    int getIntValue() {
        return (Integer)this._value;
    }

    int getKeywordValue() {
        return ((Keyword)this._value).toInt();
    }

    double getDoubleValue() {
        return (Double)this._value;
    }

    long getLongValue() {
        return (Long)this._value;
    }

    long getEnumValue() {
        return (Long)this._value;
    }

    long getTimestampValue() {
        return ((Timestamp)this._value).getValue();
    }

    long getTimeValue() {
        return ((Time)this._value).getValue();
    }

    int getDateValue() {
        return ((DateInfo)this._value).getValue();
    }

    String getDiaryValue() {
        return ((Diary)this._value).toString();
    }

    private static String DecimalToString(BigDecimal bigDecimal) {
        if (decimalToPlainStringMethod != null) {
            try {
                return (String)decimalToPlainStringMethod.invoke((Object)bigDecimal, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bigDecimal.toString();
    }

    String getDecimalStringValue() {
        return Value.DecimalToString((BigDecimal)this._value);
    }

    String getCurrencyValue() {
        return ((CurrencyInfo)this._value).getValue().toString();
    }

    public String toString() {
        if (null == this._value) {
            return null;
        }
        return this._value.toString();
    }

    Value(Object object, DataType dataType) {
        this._value = object;
        this._dataType = dataType;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Value value = (Value)object;
        if (!this._dataType.equals(value.getDataType())) {
            return false;
        }
        switch (this._dataType.toInt()) {
            case 0: {
                return true;
            }
            case 1: {
                return ((Keyword)this._value).equals(value.getValue());
            }
            case 2: {
                return ((Integer)this._value).equals(value.getValue());
            }
            case 3: {
                return ((Double)this._value).equals(value.getValue());
            }
            case 4: {
                return ((String)this._value).equals(value.getValue());
            }
            case 5: {
                return ((Diary)this._value).equals(value.getValue());
            }
            case 7: {
                return ((Timestamp)this._value).equals(value.getValue());
            }
            case 6: 
            case 8: 
            case 40: {
                return ((Long)this._value).equals(value.getValue());
            }
            case 14: {
                return ((Time)this._value).equals(value.getValue());
            }
            case 12: {
                return ((CurrencyInfo)this._value).equals(value.getValue());
            }
            case 13: {
                return ((DateInfo)this._value).equals(value.getValue());
            }
            case 10: {
                return ((BigDecimal)this._value).compareTo(value.getValue()) == 0;
            }
            case 41: {
                return ((CoordinateInfo)this._value).equals(value.getValue());
            }
        }
        return this._value.equals(value.getValue());
    }

    public Object clone() throws CloneNotSupportedException {
        Value value = (Value)super.clone();
        switch (this.getDataType().toInt()) {
            case 1: {
                value.setValue((Keyword)this._value);
                break;
            }
            case 2: {
                value.setValue(new Integer(this.getIntValue()));
                break;
            }
            case 3: {
                value.setValue(new Double(this.getDoubleValue()));
                break;
            }
            case 4: {
                value.setValue((String)this._value);
                break;
            }
            case 5: {
                value.setValue(((Diary)this._value).clone());
                break;
            }
            case 6: {
                value.setValue(new Long(this.getLongValue()));
                break;
            }
            case 7: {
                value.setValue(((Timestamp)this._value).clone());
                break;
            }
            case 8: {
                value.setValue(new Long(this.getLongValue()));
                break;
            }
            case 9: {
                value.setValue(((ByteListInfo)this._value).clone());
                break;
            }
            case 10: {
                value.setValue(new BigDecimal(((BigDecimal)this._value).toString()));
                break;
            }
            case 11: {
                value.setValue(((AttachmentInfo)this._value).clone());
                break;
            }
            case 12: {
                value.setValue(((CurrencyInfo)this._value).clone());
                break;
            }
            case 13: {
                value.setValue(((DateInfo)this._value).clone());
                break;
            }
            case 14: {
                value.setValue(((Time)this._value).clone());
                break;
            }
            case 40: {
                value.setValue(new Long(this.getLongValue()));
                break;
            }
            case 41: {
                value.setValue(((CoordinateInfo)this._value).clone());
                break;
            }
            case 42: {
                value.setValue((String)this._value);
                break;
            }
            case 43: {
                value.setValue((String)this._value);
                break;
            }
            default: {
                value.setValue(null);
            }
        }
        return value;
    }

    private void setDataType(DataType dataType) {
        this._dataType = dataType;
    }

    private void setValue(Object object) {
        this._value = object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            decimalToPlainStringMethod = (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Value.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getMethod("toPlainString", null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

