import java.io.*;
import java.math.*;
import java.util.*;
import com.remedy.arsys.api.*;

public class OutputWriter {

    static PrintWriter resultFile = null;
    static      String        tab = "    ";


    public static void DriverPrintResult( String resultString )
    {
       if( ( JavaDriver.quietMode & JavaDriver.SUPPRESS_RESULTS ) == 0 )
       {
          ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr( );
          PrintWriter outputFile = threadControlBlockPtr.getOutFile( );
          outputFile.print( resultString );
          outputFile.flush( );
       }
    }

    public static void DriverPrintResultHeader( String functionName )
    {
       if( ( JavaDriver.quietMode & JavaDriver.SUPPRESS_RESULTS ) == 0 )
       {
          ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr( );
          PrintWriter outputFile = threadControlBlockPtr.getOutFile( );
          outputFile.println( );
          outputFile.println( "results " + functionName );
          outputFile.flush( );
       }
    }
    public static void DriverPrintHeader(String header)
    {
       if( ( JavaDriver.quietMode & JavaDriver.SUPPRESS_HEADERS)  == 0 )
       {
          ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr( );
          if( threadControlBlockPtr.getPrimaryThread( ))
          {
              System.out.println( header );
          }
       }
    }

    public static void DriverPrintPrompt( String prompt )
    {
       if( ( JavaDriver.quietMode & JavaDriver.SUPPRESS_PROMPTS ) == 0 )
       {
          ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr( );
          if( threadControlBlockPtr.getPrimaryThread( ) )
          {
             System.out.print( prompt );
          }
       }
    }

    public static void DriverPrintMenu( String menuLine)
    {
       if( (JavaDriver.quietMode & JavaDriver.SUPPRESS_MENU) == 0 )
       {
          System.out.print( menuLine );
       }
    }
    public static void DriverPrintError( String errorMessage )
    {
       if( ( JavaDriver.quietMode  & JavaDriver.SUPPRESS_RESULTS ) == 0 )
       {
          ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr( );
          PrintWriter outputFile = threadControlBlockPtr.getOutFile( );
          outputFile.print( errorMessage );
          outputFile.flush( );
       }
    }

    public static void DriverPrintWarning( String warning )
    {
       if( ( JavaDriver.quietMode & JavaDriver.SUPPRESS_WARNINGS ) == 0 )
       {
          ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr( );
          PrintWriter outputFile = threadControlBlockPtr.getOutFile( );
          outputFile.print( warning );
          outputFile.flush( );
       }
    }



    public static void closeOutputFile()
    {
        ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();

         if( threadControlBlockPtr.getIsStdOut( ) )
         {
             OutputWriter.DriverPrintWarning(" **** Output to stdout; cannot close stdout file\n");
         }
         else
         {
          // Set the output to stdout
              threadControlBlockPtr.setOutputToStdOut( );
         }
    }

    public static void openOutputFile( String fileName )
    {
         if( ( fileName == null ) || fileName.length( ) == 0)
         {
             DriverPrintWarning(" **** No filename specified so no change to output file\n");
         }
         else
         {                             /* open the new file for writing */
             if( (JavaDriver.getQuietMode( ) & JavaDriver.SUPPRESS_RESULTS ) != 0 )
             {
                  return;
             }

             String absoluteFileName = null;
             String directory = JavaDriver.getResultDirectory( );
              if( directory != null && ( directory.length( ) > 0 ) )
             {
                  absoluteFileName = directory + "\\" + fileName;
              }
              else
              {
                    absoluteFileName = fileName;
               }
               try
               {
                   ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();
                   threadControlBlockPtr.setOutputFile( absoluteFileName  );
               }
               catch( Exception e )
               {
                   DriverPrintWarning( " **** File error during open; no change to output file" + "\n" );
               }
          }
   }

    public static void RecordOutput( )
    {
        String fileName = null;
        try{
            fileName = InputReader.GetString( "File name of Output file:", "" );
            if( fileName == null || fileName.length( ) == 0 )
            {
                PrintString( "No file name specified. So no change to output...\n" );
            }
            else
            {
                if( resultFile != null )
                {
                    resultFile.close( );
                    resultFile = null;
                }
                resultFile = new PrintWriter( new FileOutputStream( new File( fileName ) ) );
            }
        }
        catch( Exception e ){
            PrintString( "Problem in opening the file " + fileName + "\n" );
        }
    }

    public static void StopRecordingOutput( )
    {
        if( resultFile != null )
        {
            resultFile.close( );
            resultFile = null;
        }
    }

    public static void PrintHelp( )
    {
        System.out.print( "         AR System Java API Driver\n" );

        System.out.println( );

        System.out.print( "Container      Schema         Char Menu       Schema Field       <mult>\n" );
        System.out.print( "---------      -------        ----------      -------------      ------\n" );
        System.out.print( "get    (gco)   get    (gs)    get    (gc)     get      (gsf)\n" );
        System.out.print( "set    (sco)   set    (ss)    set    (sc)     set      (ssf)\n" );
        System.out.print( "create (cco)   create (cs)    create (cc)     create   (csf)\n" );
        System.out.print( "delete (dco)   delete (ds)    delete (dc)     delete   (dsf)     (dmsf)\n" );
        System.out.print( "getlist(glco)  getList(gls)   getlist(glc)    getlist  (glsf)\n" );
        System.out.print( "getmult(gmco)                 expand (ec)     get mult (gmsf)\n");

        System.out.println( );

        System.out.print( "Active Link    Filter         Escalation      Entry              <mult>\n" );
        System.out.print( "-----------    ------         ----------      -----              ------\n" );
        System.out.print( "get    (gal)   get    (gf)    get    (ges)    get       (ge)     (gme)\n" );
        System.out.print( "set    (sal)   set    (sf)    set    (ses)    set       (se) \n" );
        System.out.print( "create (cal)   create (cf)    create (ces)    create    (ce) \n");
        System.out.print( "delete (dal)   delete (df)    delete (des)    delete    (de) \n" );
        System.out.print( "getlist(glal)  getlist(glf)   getlist(gles)   getlist   (gle) \n" );
        System.out.print( "                                              getlistw/f(glewf) \n" );
        System.out.print( "                                              merge     (me) \n" );
        System.out.print( "                                              stats     (stat) \n" );

        System.out.println( );

        System.out.print( "VUI            Misc Lists     Alerts            Encode/Decode  \n" );
        System.out.print( "---            ----------     ------            -------------\n" );
        System.out.print( "get    (gv)    server(svr)    Create     (ce)   enquery (ecqal) \n" );
        System.out.print( "set    (sv)    group (glg)    Register   (rfa)  dequery (dcqal) \n" );
        System.out.print( "create (cv)    user  (glu)    Deregister (dfa)  enassig (ecasn) \n" );
        System.out.print( "delete (dv)    sql   (glsql)  gla user   (glau) deassig (deasn) \n" );
        System.out.print( "                              get Count  (gac)  echstry (echst) \n" );
        System.out.print( "                                                ecdiary (ecdia) \n" );

        System.out.println( );

        System.out.print( "Init/Term     Control/Logging      Info          Misc                   Misc\n" );
        System.out.print( "---------     ---------------      ----          ----              ----------------\n" );
        System.out.print( "login  (log)  record    (rec)      get svr (gsi) ver user (ver)    get errmsg (gem)  \n" );
        System.out.print( "exit   (q)    stop rec  (srec)     set svr (ssi) export   (exp)    set logging(slog)  \n" );
        System.out.print( "help   (h, ?) open out  (oout)     get FT  (gft) import   (imp)  \n" );
        System.out.print( "begtran(bbet) close out (cout)     set FT  (sft) exec proc(proc)  \n" );
        System.out.print( "endtran(ebet) rcrd pmpt(recPrompt) get stat(gss) load qual(lqs)   \n" );
        System.out.print( "              stp recpmt(srecPrompt)             set port (ssp)  \n" );

        System.out.print( "Localized Value      Support File \n" );
        System.out.print( "---------------      ------------ \n" );
        System.out.print( "get       (glv)      create   (cfl)\n" );
        System.out.print( "getmult   (gmlv)     delete   (dfl) \n" );
        System.out.print( "                     get      (gfl) \n" );
        System.out.print( "                     set      (sfl) \n" );
        System.out.print( "                     get list (glfl) \n" );
        System.out.println( );

        System.out.print(" Complex Entry Session Config  Localized Val Date            Currency Ratio\n");
        System.out.print(" ------------- --------------  ------------- ----            --------------\n");
        System.out.print(" create(xmlce) get conf(gsc)   get    (glv)  ecdate (ecdat)  getmult sets(gmcrs)\n");
        System.out.print(" get   (xmlge) set conf(ssc)   getmult(gmlv) dcdate (dcdat)  get ratio   (gcr)\n");
        System.out.print(" set   (xmlse)\n");
    }


    public static void PrintBoolean( String indent, String header, boolean val, String newLine )
    {
       if( val )
       {
          DriverPrintResult( indent + header + "  TRUE" + newLine );
       }
       else
       {
          DriverPrintResult( indent + header + "  FALSE" + newLine );
       }
    }

    public static void DriverPrintInt( int value )
    {
        DriverPrintResult( "" + value );
    }

    public static void PrintLong( long value )
    {
        DriverPrintResult( "" + value );
    }

    public static void PrintString( String prompt )
    {
        StringTokenizer tokens = new StringTokenizer( prompt, "\r\n\f", true );
        while( tokens.hasMoreTokens( ) )
        {
           String token = tokens.nextToken( );
           DriverPrintResult( token );
        }
    }
    public static void PrintStringWithoutNewLine( String prompt  )
    {

        StringTokenizer tokens = new StringTokenizer( prompt, "\r\n\f", false );
        while( tokens.hasMoreTokens( ) )
        {
           String token = tokens.nextToken( );
           DriverPrintResult( token );
        }

    }

    public static void PrintARException( ARException e )
    {
        StatusInfo[] statusList = e.getLastStatus();

        if (statusList != null)
        {
           PrintStatusInfoList( "", "   Results", statusList );
           return;
        }

        String message = e.toString( );

        if( message != null && message.length( ) > 0 )
        {
            DriverPrintResult( message );
        }
        else
        {
            DriverPrintResult( "No Error Message..." );
        }
        PrintNewLine( );
    }




    public static void PrintByte( byte value )
    {
       DriverPrintResult( "" + value );
    }
    public static void PrintFloat( float value )
    {
       DriverPrintResult( "" + value );
    }

    public static void PrintNewLine( )
    {
       DriverPrintResult( "\n" );
    }

    public static void PrintHeader( String indent, String header, String newLine )
    {
        if( header == null )
        {
            return;
        }
        DriverPrintResult( indent + header + newLine );
    }

    public static void PrintInt( String indent, String header, int value, String newLine )
    {
       DriverPrintResult( indent + header + value + newLine );
    }



    public static void PrintFloat( String indent, String header, float value, String newLine )
    {
       if( newLine != null )
       {
          DriverPrintResult( indent + header + value + "\n" );
       }
       else
       {
          DriverPrintResult( indent + header + value );
       }
    }

    public static void PrintByte( String indent, String header, byte value, String newLine )
    {
       if( newLine != null )
       {
          DriverPrintResult( indent + header + value + "\n" );
       }
       else
       {
          DriverPrintResult( indent + header + value );
       }
    }
    public static void PrintLong( String indent, String header, long value, String newLine  )
    {
       if( newLine != null )
       {
          DriverPrintResult( indent + header + value + "\n" );
       }
       else
       {
          DriverPrintResult( indent + header + value );
       }

    }


    public static void PrintULong( String indent, String header, String value, String newLine )
    {
       if( newLine != null )
       {
          DriverPrintResult( indent + header + value + "\n" );
       }
       else
       {
          DriverPrintResult( indent + header + value );
       }
    }


    public static void PrintDecimal( String indent, String header, BigDecimal value )
    {
        DriverPrintResult( indent + header + "\n");

        if( value == null )
        {
           DriverPrintResult( " Null Decimal value...." + "\n");
        }
        else
        {
           DriverPrintResult( value.toString( )  );
        }

        PrintNewLine(  );
    }

    public static void PrintInteger( String indent, String header, Integer value )
    {
       PrintString( indent + header  );

        if( value == null )
        {
            PrintString( " Null Integer value...." );
            return;
        }
        else
        {
            PrintString( "" + value.intValue( ) );
        }

        PrintNewLine(  );
    }

    public static void PrintDouble( String indent, String header, Double value )
    {
        PrintString( indent + header  );

        if( value == null )
        {
            PrintString( " Null Double value...." );
            return;
        }
        else
        {
            PrintString( value.toString( ) );
        }

        PrintNewLine( );
    }

    public static void PrintEnum( String indent, String header, Long value )
    {
        PrintStringWithoutNewLine( indent + header );

        if( value == null )
        {
            PrintString( " Null Enum value..." );
            return;
        }
        else
        {
            PrintString( value.toString( )  );
        }

        PrintNewLine( );
    }

    public static void PrintString( String indent, String header, String value, String newLine )
    {

       ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr( );
       PrintWriter outputFile = threadControlBlockPtr.getOutFile( );

       StringTokenizer tokens = null;
       if( value == null )
       {
          tokens = new StringTokenizer( indent + header + "  <NULL> ", "\r\n\f", false );
       }
       else
       {
          tokens = new StringTokenizer( indent + header + value, "\r\n\f", false );
       }
       while( tokens.hasMoreTokens( ) )
       {
          String token = tokens.nextToken( );
          outputFile.println( token );
          outputFile.flush( );
        }

    }
    public static void PrintTimeOfDay(String indent, String header, Time value)
    {
      PrintHeader(indent, header, "\n");
      if(value != null)
      {
         PrintLong(indent, "Value: ", value.getValue(), "\n");
      }
      else
      {
         PrintHeader(indent, "    Null TimeOfDay value", "\n");
      }
    }


    public static void PrintTimestamp( String indent, String header, Timestamp value )
    {
      PrintHeader( indent, header, "\n" );
        if( value != null )
        {
            PrintLong( indent, "Value: ", value.getValue( ), "\n" );
        }
        else
        {
            PrintHeader( indent, "    Null TimeStamp value", "\n" );
        }
    }

    public static void PrintTimestampList( String indent, String header, Timestamp[] value )
    {

/*
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent,  "    Null Timestamp list", "\n" );
            return;
        }


        PrintInt( indent + tab, "Number of values: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            if( i/4 * 4 == i )
            {
                PrintNewLine( );
                PrintHeader( indent, tab, null );
            }
            PrintLong( "", " ", value[i].getValue( ), "\n" );
        }

        PrintNewLine( );
*/
    }


    public static void PrintFieldKeyList( String indent, String header, FieldKey[] keyList )
    {
        PrintHeader( indent, header, "\n" );

        if( keyList == null )
        {
            PrintHeader( indent + tab,  " Null FieldKey list", "\n" );
            return;
        }


        PrintInt( indent + tab, "Number of FieldKeys: ", keyList.length, "\n" );

        for( int i = 0; i < keyList.length; i++ )
        {
            PrintString( indent + tab, "Schema Name: ", keyList[i].getSchemaName( ).toString( ), "\n" );
            PrintLong( indent + tab, "Field ID: ", keyList[i].getFieldID( ).getValue( ), "\n" );
        }

        PrintNewLine( );
    }


    public static void PrintEntryIdList( String indent, String header,  EntryID[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null EntryID list", "\n" );
            return;
        }


        PrintInt( indent + tab, "Number of values: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintString( indent + tab, "Entry ID: ", value[i].toString( ), "\n" );
        }
        PrintNewLine( );
    }

    public static void PrintEntryItem( String indent, String header, EntryItem eItem )
    {
        PrintHeader( indent, header, "\n" );

        if( eItem == null )
        {
            PrintHeader( indent + tab, " Null EntryItem", "\n" );
            return;
        }

        PrintHeader( indent + tab, "Field Id: " + eItem.getFieldID(), "\n");
        PrintValue( indent + tab, "Value: ", eItem.getValue() );

        PrintNewLine( );
    }


    public static void PrintEntryItemList( String indent, String header, EntryItem[] entryItemList )
    {
        PrintHeader( indent, header, "\n" );

        if( entryItemList  == null )
        {
            PrintHeader( indent + tab,  " Null EntryItem List", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of values: ", entryItemList.length, "\n" );

        for( int i = 0; i < entryItemList.length; i++ )
        {
            PrintEntryItem( indent + tab, "Entry Item " + i + " : ", entryItemList[i] );
        }
        PrintNewLine( );
    }

    public static void PrintEntry( String indent, String header, Entry entry )
    {
        PrintHeader( indent, header, "\n" );

        if( entry == null )
        {
            PrintHeader( indent + tab,  " Entry does not exist....", "\n" );
            return;
        }

        EntryItem[] entryItemList  =  entry.getEntryItems( );

        PrintEntryItemList( indent + tab, "Entry items List: ", entryItemList );

        PrintNewLine( );
    }

    public static void PrintInternalID( String indent, String header, InternalID value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null InternalID value", "\n" );
            return;
        }

        PrintLong( indent + tab, "Value: ", value.getValue( ), "\n" );

        PrintNewLine( );
    }


    public static void PrintInternalIDList( String indent, String header, InternalID[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null InternalID list", "\n" );
            return;
        }


        PrintInt( indent + tab, "Number of values: ", value.length, "\n" );

        int j = 1;
        PrintStringWithoutNewLine( indent + tab + tab );
        for( int i = 0; i < value.length; i++ )
        {
             if( j == 6 )
             {
                 j = 1;
                 PrintNewLine( );
                 PrintStringWithoutNewLine( indent + tab + tab );
             }
             PrintStringWithoutNewLine( value[i].getValue( ) + ", " );

        }

        PrintNewLine( );
    }

    public static void PrintAccessNameIDList( String indent, String header,  AccessNameID[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null AccessNameID list", "\n" );
            return;
        }
        PrintInt( indent + tab, "Number of values: ", value.length, "\n" );
        for( int i = 0; i < value.length; i++ )
        {
            if( value[i] != null )
            {
                PrintString( indent + tab, "AccessNameID: ", value[i].toString( ), "\n" );
            }
            else{
                PrintString( indent + tab, "AccessNameID: ", "null", "\n" );
            }
        }

        PrintNewLine( );
    }

    public static void PrintNameIDList( String indent, String header,  NameID[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null NameID list", "\n" );
            return;
        }
        PrintInt( indent + tab, "Number of values: ", value.length, "\n" );
        for( int i = 0; i < value.length; i++ )
        {
            if( value[i] != null )
            {
                PrintString( indent + tab, "Name ID: ", value[i].toString( ), "\n" );
            }
            else{
                PrintString( indent + tab, "Name ID: ", "null", "\n" );
            }
        }

        PrintNewLine( );
    }

    public static void PrintFieldIDList( String indent, String header, FieldID[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null FieldID list", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of values: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            if( value[i] != null )
            {
                PrintLong( indent + tab, "Field ID: ", value[i].getValue( ), "\n" );
            }
            else{
                PrintString( indent + tab, "Field ID: ", "null", "\n" );
            }
        }

        PrintNewLine( );
    }


    public static void PrintServerNameIDList( String indent, String header, ServerNameID[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null Server NameID list", "\n" );
            return;
        }
        PrintInt( indent + tab, "Number of values: ", value.length, "\n" );
        for( int i = 0; i < value.length; i++ )
        {
            if( value[i] != null )
            {
                PrintString( indent + tab, "Server Name ID: ", value[i].toString( ), "\n" );
            }
            else
            {
                PrintString( indent + tab, "Server Name ID for entry ",  i + " is null", "\n" );
            }
        }

        PrintNewLine( );
    }


    public static void PrintStatusInfo( String indent, String header, StatusInfo value )
    {
        PrintHeader( indent, header, "\n" );

        PrintHeader( indent + tab, "Message type : ", "" );

        switch( value.getMessageType( ) )
        {
            case Constants.AR_RETURN_OK:
                PrintHeader( "", "NOTE", "\n" );
                break;
            case Constants.AR_RETURN_WARNING:
                PrintHeader( "", "WARNING", "\n" );
                break;
            case Constants.AR_RETURN_ERROR:
                PrintHeader( "", "ERROR", "\n" );
                break;

            case Constants.AR_RETURN_FATAL:
                PrintHeader( "", "FATAL", "\n");
                break;

            default :

                PrintInt( "", "<Unknown Type>: ", value.getMessageType( ), "\n" );
                break;
        }
        PrintLong( indent + tab, "Message number : ", value.getMessageNum( ), "\n" );

        PrintString( indent + tab, "Message:  ", value.getMessageText( ), "\n" );

        PrintString( indent + tab, "Appended: ", value.getAppendedText( ), "\n" );
    }



    public static void PrintStatusInfoList( String indent, String header, StatusInfo[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null || value.length == 0)
        {
            PrintHeader( indent, "ReturnCode:  OK", "\n");
            PrintHeader( indent, "Status List : 0 items", "\n" );
            return;
        }

        PrintHeader( indent, "ReturnCode:  ", "");
        switch( value[0].getMessageType( ) )
        {
            case 0         :
                PrintHeader( "", "OK", "\n" );
                break;
            case 1     :
                PrintHeader( "", "WARNING", "\n" );
                break;
            case 2      :
                PrintHeader( "", "ERROR", "\n" );
                break;

            case 3     :
                PrintHeader( "", "FATAL", "\n");
                break;

            default :
                PrintInt( "", "<Unknown Type>: ", value[0].getMessageType( ), "\n" );
                break;
        }

        PrintHeader( indent, "Status List : " + value.length + " items", "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintStatusInfo( indent, "Status Struct :", value[i] );
        }

        PrintNewLine( );
    }




    public static void PrintByteListInfo( String indent, String header, ByteListInfo value)
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null ByteListInfo list", "\n" );
            return;
        }

        byte[] byteList = value.getValue( );

        if( byteList == null )
        {
            PrintHeader( indent + tab, "Null byte list..", "\n" );
            return;
        }

        switch( value.getType( ) )
        {
            case  Constants.AR_BYTE_LIST_WIN30_BITMAP :
                PrintString( indent + tab + "Type - WIN30_BITMAP" );
                break;

            case  Constants.AR_BYTE_LIST_JPEG         :
                PrintString( indent + tab + "Type - JPEG" );
                break;

            case  Constants.AR_BYTE_LIST_TIFF         :
                PrintString( indent + tab + "Type - TIFF" );
                break;

            case  Constants.AR_BYTE_LIST_TARGA        :
                PrintString( indent + tab + "Type - TARGA" );
                break;

            default:
                PrintString( indent + tab + "Type - < unknown" + value.getType( ) + "  >"  );
                break;
        }

        PrintInt( indent + tab, "Number of values: ", byteList.length, "\n" );
        try {
           for( int i = 0; i < value.getValue( ).length; i++ )
           {
               if( i/20 * 20 == i )
               {
                   if( i != 0 )
                   {
                       PrintNewLine( );
                   }
                   PrintHeader( indent, tab, "" );
               }
               int temp = 0;
               if ( ( byteList[i] & 128 ) == 128 ) temp = temp + 128;
               if ( ( byteList[i] & 64 ) == 64)  temp = temp + 64;
               if ( ( byteList[i] & 32 ) == 32 )  temp = temp + 32;
               if ( ( byteList[i] & 16 ) == 16 ) temp = temp + 16;
               if ( ( byteList[i] & 8 ) == 8 )   temp = temp + 8;
               if ( ( byteList[i] & 4 ) == 4 )  temp = temp + 4;
               if ( ( byteList[i] & 2 ) == 2 )  temp = temp + 2;
               if ( ( byteList[i] & 1 ) == 1 ) temp = temp + 1;

               String hexaString = ConvertToHexadecimalString( temp );
               PrintStringWithoutNewLine( hexaString );
           }
        }
        catch (IOException e )
        {
            PrintString( "Negative number" );
            System.exit( 1 );
        }

        PrintNewLine( );
    }



    public static void PrintCoordinateInfoList( String indent, String header,  CoordinateInfo[] value)
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null Coordinate Info list", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of values: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintString( indent + tab + tab, "x: " + value[i].getXCoordinate( ) , ",  y:" + value[i].getYCoordinate( ), "\n" );
        }

        PrintNewLine( );
    }




    public static void PrintAttachmentInfo( String indent, String header, AttachmentInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null AttachementInfo....", "\n" );
            return;
        }

        if( value.getName( ) != null )
        {
            PrintHeader( indent + tab, " Name: " + value.getName( ), "\n" );
        }
        else
        {
            PrintHeader( indent + tab, "Name: <null>", "\n" );
        }

        PrintLong( indent + tab, "Original size: ", value.getOriginalSize( ), "\n" );

        PrintLong( indent + tab, "Compressed size : ", value.getCompressedSize( ), "\n" );

  // PrintAttachLocInfo("Locator", &value->loc);

        PrintNewLine( );
    }


    public static void PrintDataType( String indent, String header,  DataType value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null DataType ....", "\n" );
            return;
        }

        switch( value.toInt( ) )
	{
	    case 1:
                PrintHeader( indent + tab, "KEYWORD", "\n" );
                break;

	    case 2:
                PrintHeader( indent + tab, "INTEGER", "\n" );
                break;

            case 3:
                PrintHeader( indent + tab,"REAL", "\n" );
                break;

            case 4:
                PrintHeader( indent + tab, "CHAR", "\n" );
                break;

            case 5:
                PrintHeader( indent + tab, "DIARY", "\n" );
                break;

            case 6:
                PrintHeader( indent + tab, "ENUM", "\n" );
                break;

	    case 7:
                PrintHeader( indent + tab, "TIME", "\n" );
                break;

	    case 8:
                PrintHeader( indent + tab, "BITMASK", "\n" );
                break;

	    case 9:
                PrintHeader( indent + tab, "BYTES", "\n" );
                break;

	    case 10:
                PrintHeader( indent + tab, "DECIMAL", "\n" );
                break;

	    case 11:
                PrintHeader( indent + tab, "ATTACHMENT", "\n" );
                break;
            case 12:
                PrintHeader(indent + tab, "CURRENCY", "\n");
                break;

            case 30:
                PrintHeader( indent + tab, "JOIN", "\n" );
                break;

	    case 31:
                PrintHeader( indent + tab, "TRIM", "\n" );
                break;

	    case 32:
                PrintHeader( indent + tab, "CONTROL", "\n" );
                break;

	    case 33:
                PrintHeader( indent + tab, "TABLE", "\n" );
                break;

	    case 34:
                PrintHeader( indent + tab, "COLUMN", "\n" );
                break;

	    case 35:
                PrintHeader( indent + tab, "PAGE", "\n" );
                break;

	    case 36:
                PrintHeader( indent + tab,"PAGE_HOLDER", "\n" );
                break;

	    case 40:
                PrintHeader( indent + tab,"ULONG", "\n" );
                break;

	    case 41:
                PrintHeader( indent + tab,"COORDS", "\n" );
                break;

	    default:
                PrintInt( indent + tab, "UnKnown Type: ", value.toInt( ), "\n" );
                break;
	}

        PrintNewLine( );
    }

    public static void PrintKeyword( String indent, String header, Keyword value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null Keyword....", "\n" );
            return;
        }

        PrintInt( indent + tab, "Value: ", value.toInt( ), "\n" );

        PrintNewLine( );
    }



    public static void PrintBitMask( String indent, String header, Long value )
    {
        PrintStringWithoutNewLine( indent + header );

        if( value == null )
        {
            PrintString( " Null BitMask value...." );
            return;
        }
        else
        {
            PrintString( value.toString( )  );
        }

        PrintNewLine( );
    }
    public static void PrintDiary( String indent, String header, Diary value )
    {
        PrintString( indent + header  );

        if( value == null )
        {
            PrintString( " Null Diary value..." );
            return;
        }
        PrintDiaryString( indent + tab, "Diary elements:", value.getValue( ) );
        PrintNewLine( );
    }

    public static void PrintValue( String indent, String header, Value value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null Value....", "\n" );
            return;
        }

         DataType  type = value.getDataType( );

         if( type == null )
         {
             PrintString( indent + tab, "getDataType method returns null value", " ", "\n" );
             return;
         }
         switch( type.toInt( ) )
	 {
	    case 1:
                PrintKeyword( indent + tab, "Type : KEYWORD - ", ( Keyword )value.getValue( ) );
                break;

	    case 2:
                PrintInt( indent + tab, "Type : INTEGER - ", (( Integer )value.getValue( )).intValue( ), "\n" );
                break;

            case 3:
                PrintString( indent + tab + "Type: REAL - " + ( ( Double )value.getValue( ) ).toString( ) );
                break;

            case 4:
                PrintString(  indent + tab, "Type: CHAR - ", ( String )value.getValue( ), "\n" );
                break;

            case 5:
                PrintString( indent + tab, "Type: DIARY - ", "   ","\n" );
                PrintDiary(  indent + tab, "Type: DIARY - ", ( Diary )value.getValue( ) );
                break;

            case 6:
                PrintEnum(  indent + tab, "Type: ENUM - ", ( Long )value.getValue( ) );
                break;

	    case 7:
                PrintTimestamp(  indent + tab, "Type: TIME - ", ( Timestamp )value.getValue( ) );
                break;

	    case 8:
                PrintBitMask(  indent + tab, "Type: BITMASK - ", ( Long )value.getValue( ) );
                break;

	    case 9:
                PrintByteListInfo(  indent + tab, "Type: BYTES - ", ( ByteListInfo )value.getValue( ) );
                break;

	    case 10:
                PrintDecimal(  indent + tab, "Type: DECIMAL - ", ( BigDecimal )value.getValue( ) );
                break;

	    case 11:
                PrintAttachmentInfo(  indent + tab, "Type: ATTACHMENT - ", ( AttachmentInfo )value.getValue( ) );
                break;

            case 13:
                PrintString( indent + tab, "Type: DATE - ", value.toString(), "\n");
                break;

            case 14:
                PrintString( indent + tab, "Type: TIME - ", value.toString(), "\n");
                break;

            case 30:
                PrintString(  indent + tab, "Type: JOIN - ", "", "\n"  );
                break;

	    case 31:
                PrintString( indent + tab, "Type : TRIM - ", " ", "\n" );
                break;

	    case 32:
                PrintString(  indent + tab, "Type: CONTROL - ", " ", "\n" );
                break;

	    case 33:
                PrintString(  indent + tab, "Type: TABLE - ", " ", "\n" );
                break;

	    case 34:
                PrintString(   indent + tab, "Type: COLUMN - ", " ", "\n" );
                break;

	    case 35:
                PrintString(  indent + tab, "Type: PAGE - ", " ", "\n" );
                break;

	    case 36:
                PrintString(  indent + tab, "Type: PAGE_HOLDER - ", " ", "\n" );
                break;

	    case 40:
                PrintLong(  indent + tab, "Type: ULONG - ", ( ( Long )value.getValue( ) ).longValue( ), "\n" );
                break;

	    case 41:
                PrintCoordinateInfoList(  indent + tab, "Type: COORDS - ", ( CoordinateInfo[] ) value.getValue( ) );
                break;

	    default:
                PrintInt(  indent + tab, "Type : Undefined : ", type.toInt( ), "\n");
                break;
        }

    }

    public static void PrintValueList( String indent, String header, Value[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null Value list", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of values: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintValue( indent, "Value: ", value[i] );
        }

        PrintNewLine( );
    }

    public static void PrintIndexInfo(  String indent, String header, IndexInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + "     ", " Null IndexInfo....", "\n" );
            return;
        }

        if( value.getIndexName( ) != null )
        {
            PrintString( indent + tab, "Name : ", value.getIndexName( ).toString( ), "\n" );
        }
        else
        {
            PrintString( indent + tab, "Name : ", "<null NameID>", "\n" );
        }

        PrintBoolean( indent + tab, "Unique: ", value.isUnique( ), "\n" );

        PrintInternalIDList( indent + tab, "Index Field List: ", value.getIndexFields( ) );

        PrintNewLine( );
    }

    public static void PrintIndexInfoList(  String indent, String header, IndexInfo[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null Index Info List", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of values: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintIndexInfo( indent + tab, "", value[i] );
        }

        PrintNewLine( );

    }
    public static void PrintArchiveInfo(  String indent, String header, ArchiveInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + "     ", " Null ArchiveInfo....", "\n" );
            return;
        }

        PrintLong( indent + tab, "Enable: ", value.getEnable( ) , "\n" );
        PrintLong( indent + tab, "ArchiveType: ", value.getArchiveType( ), "\n" );
        if (value.getArchiveType() == 1 || value.getArchiveType() == 3)
        {
            PrintString( indent + tab, " Archive Dest: ", value.getArchiveDest(), "\n");
        }
        PrintQualifierInfo( indent + tab, "Qualifier Info: ", value.getQualifier( ) );
        PrintDayInfo( indent + tab, "Archive Date: ", value.getArchiveTmInfo( ) );
        if (value.getArchiveFrom() != null)
           PrintString( indent + tab, " Archive From: ", value.getArchiveFrom(), "\n");
        else
           PrintHeader( indent + tab, " Archive From: null", "\n");
    }

    public static void PrintEntryListFieldInfo(  String indent, String header, EntryListFieldInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + "     ", " Null EntryListFieldInfo....", "\n" );
            return;
        }

        PrintLong( indent + tab, "Field Id : ", value.getFieldID( ).getValue( ), "\n" );

        PrintInt( indent + tab, "Column Width: ", value.getColumnWidth( ), "\n" );

        PrintString( indent + tab, "Separator: ", new String( value.getSeparator( ) ), "\n" );

        PrintNewLine( );
    }


    public static void PrintEntryListFieldInfoList( String indent, String header, EntryListFieldInfo[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null EntryListFieldInfo list", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of values: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintEntryListFieldInfo( indent, "EntryListFieldInfo: ", value[i] );
        }

        PrintNewLine( );
    }


    public static void PrintSortInfo( String indent, String header, SortInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + "     ", " Null SortInfo....", "\n" );
            return;
        }

        PrintLong( indent + tab, "Field Id :", value.getFieldID( ).getValue( ), "\n" );

        switch( value.getSortOrder( ) )
        {
            case 1  :
                PrintHeader( indent + tab, "Sort Order: ASCENDING", "\n" );
                break;

            case 2 :
                PrintHeader( indent + tab, "Sort Order: DESCENDING", "\n" );
                break;

            default              :
                PrintInt( indent + tab, "Sort Order: undefined  value = ", value.getSortOrder( ), "\n" );
                break;
        }
        PrintNewLine( );
    }


    public static void PrintSortInfoList( String indent, String header, SortInfo[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null SortInfo list", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of values: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintSortInfo( indent, "SortInfo: ", value[i] );
        }

        PrintNewLine( );
    }



    public static void PrintEntryListInfo( String indent, String header, EntryListInfo  value )
    {

        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + "     ", " Null EntryListInfo....", "\n" );
            return;
        }


        PrintString( indent + tab, "Entry Id : ",  value.getEntryID( ).toString( ), "\n" );


        PrintString( indent + tab, "Short Description :", new String( value.getDescription( ) ), "\n" );

        PrintNewLine( );
    }

	public static void PrintEntryListInfoList( String indent, String header, EntryListInfo[] value )
	{

		  PrintHeader( indent, header, "\n" );

		  if( value == null )
		  {
			  PrintHeader( indent + tab,  " Null EntryListInfo list", "\n" );
			  return;
		  }

		  PrintInt( indent + tab, "Number of values: ", value.length, "\n" );

		  for( int i = 0; i < value.length; i++ )
		  {
			  PrintEntryListInfo( indent, "EntryListInfo " + i + " : ", value[i] );
		  }

		  PrintNewLine( );
	}

    public static void PrintCompactQueryResult( String indent, String header, CompactQueryResult value )
    {
        String entryIds[] = null;
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null CompactQueryResult list", "\n" );
            return;
        }
        entryIds = value.getEntryIds();
        PrintInt( indent + tab, "Number of values: ", entryIds.length, "\n" );

        for( int i = 0; i < entryIds.length; i++ )
        {
            PrintString( indent + tab, "Entry Id : ", entryIds[i], "\n" );
        }

        PrintNewLine( );
    }



    public static void PrintArithOpAssignInfo( String indent, String header, ArithOpAssignInfo value )
    {
        PrintHeader( indent, header, "\n" );


        if( value == null )
        {
            PrintHeader( indent + tab,  " Null EntryListInfo list", "\n" );
            return;
        }

        switch( ( int ) value.getOperation( ) )
        {
            case 1      :
                PrintHeader( indent + tab, "Operation: ADD", "\n" );
                break;

            case 2 :
                PrintHeader( indent + tab, "Operation: SUBTRACT", "\n" );
                break;

            case 3 :
                PrintHeader( indent + tab, "Operation: MULTIPLY", "\n" );
                break;

            case 4   :
                PrintHeader( indent + tab, "Operation: DIVIDE", "\n" );
                break;

            case 5   :
                PrintHeader( indent + tab, "Operation: MODULO", "\n" );
                break;

            case 6   :
                PrintHeader( indent + tab, "Operation: NEGATE (unary minus)", "\n" );
                break;

            default                   :
                PrintLong( indent + tab, " Operation: Undefined -  ", value.getOperation( ), "\n" );
                break;
        }

        PrintAssignInfo( indent + tab, "LeftOperand :", value.getOperandLeft( ) );

        PrintAssignInfo( indent + tab, "RightOperand :", value.getOperandRight( ) );

        PrintNewLine( );
    }


    public static void PrintArithmeticOperationInfo( String indent, String header, ArithmeticOperationInfo  value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null ArithmeticOperationInfo....", "\n" );
            return;
        }

        int operation = value.getOperation( );

        PrintInt( indent + tab, "Operation: ", operation, "\n" );

        PrintArithmeticOrRelationalOperand( indent + tab, "Left Operand: ", value.getLeftOperand( ) );

        PrintArithmeticOrRelationalOperand( indent + tab, "Right Operand: ", value.getRightOperand( ) );

        PrintNewLine( );
    }

    public static void PrintQueryInfo( String indent, String header, QueryInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null Query Info....", "\n" );
            return;
        }

        PrintLong( indent + tab, "FieldID: ", value.getFieldID( ).getValue( ), "\n" );

        PrintLong( indent + tab, "Match Mode: ", value.getMatchMode( ), "\n" );

        PrintString( indent + tab, "Schema ID: ", value.getSchemaID( ).toString( ), "\n" );

        PrintString( indent + tab, "Server Name: ", value.getServerName( ).toString( ), "\n" );

        PrintQualifierInfo( indent + tab, "Qualifier Info: ", value.getQualifierInfo( ) );
    }

    public static void PrintArithmeticOrRelationalOperand( String indent, String header, ArithmeticOrRelationalOperand value )
    {

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null ArithmeticOrRelationalOperand....", "\n" );
            return;
        }

        OperandType opType = value.getType( );

        int operation = opType.toInt( );
        Object objVal = value.getValue( );


        if( opType == OperandType.FIELDID )
        {
            PrintHeader( indent + tab, "Type: FIELDID", "\n" );
            FieldID fieldId = ( FieldID ) objVal;
            PrintLong( indent + tab, "FieldId : ", fieldId.getValue( ), "\n" );

        }
        else if( opType == OperandType.VALUE )
        {
            PrintHeader( indent + tab, "Type: VALUE", "\n" );
            Value val = ( Value ) objVal;
            PrintValue( indent + tab, "Value: ", val );
        }
        else if( opType == OperandType.ARITHMETIC_OP )
        {
            PrintHeader( indent + tab, "Type: ARITHMETIC_OP", "\n" );
            ArithmeticOperationInfo arInfo = ( ArithmeticOperationInfo ) objVal;
            PrintArithmeticOperationInfo( indent + tab, "ArithmeticOperationInfo: ", arInfo );
        }
        else if( opType == OperandType.STATUS_HISTORY )
        {
            PrintHeader( indent + tab, "Type: STATUS_HISTORY", "\n" );
            StatusHistoryValue stHistoryVal = ( StatusHistoryValue ) objVal;
            PrintStatusHistoryValue( indent + tab, "StatusHistoryValue ", stHistoryVal );
        }
        else if( opType == OperandType.VALUE_SET )
        {
            PrintHeader( indent + tab, "Type: VALUE_SET", "\n" );
            PrintValueList( indent + tab, "Value List: ", ( Value[] )value.getValue( ) );
        }
        else if( opType == OperandType.FIELDID_TRANSACTION )
        {
            PrintHeader( indent + tab, "Type: FIELDID_TRANSACTION", "\n" );
            FieldID fieldIdTransaction = ( FieldID ) objVal;
            PrintLong( indent + tab, "FieldId : ", fieldIdTransaction.getValue( ), "\n" );
        }
        else if( opType == OperandType.FIELDID_DB )
        {
            PrintHeader( indent + tab, "Type: FIELDID_DB", "\n" );
            FieldID fieldIdDB = ( FieldID ) objVal;
            PrintLong( indent + tab, "FieldId : ", fieldIdDB.getValue( ), "\n" );
        }
        else if( opType == OperandType.LOCAL_VARIABLE )
        {
            PrintHeader( indent + tab, "Type: LOCAL_VARIABLE", "\n" );
            Integer variable = ( Integer ) value.getValue( );
            PrintHeader( indent + tab, "Local Variable Number: " + variable, "\n" );
        }
        else if( opType == OperandType.QUERY_INFO )
        {
            PrintHeader( indent + tab, "Type: QUERY_INFO", "\n" );
            QueryInfo qInfo = ( QueryInfo ) value.getValue( );
            PrintQueryInfo( indent + tab, " QueryInfo: ", qInfo );
        }
        else if( opType == OperandType.FIELDID_CURRENT )
        {
            PrintHeader( indent + tab, "Type: FIELDID_CURRENT", "\n" );
            FieldID fieldIdCurrent = ( FieldID ) objVal;
            PrintLong( indent + tab, "FieldId : ", fieldIdCurrent.getValue( ), "\n" );
        }
        else if(opType == OperandType.CURRENCY_FLD)
        {
           PrintHeader(indent + tab, "Type: CURRENCY_FLD", "\n");
           CurrencyPartInfo currencyPart = (CurrencyPartInfo) objVal;
           PrintString(indent + tab, "Currency Part Info: ", currencyPart.toString(), "\n");
        }
      else if(opType == OperandType.CURRENCY_FLD_TRAN)
      {
         PrintHeader(indent + tab, "Type: CURRENCY_FLD_TRAN", "\n");
         CurrencyPartInfo currencyPart = (CurrencyPartInfo) objVal;
         PrintString(indent + tab, "Currency Part Info: ", currencyPart.toString(), "\n");
      }
      else if(opType == OperandType.CURRENCY_FLD_DB)
      {
         PrintHeader(indent + tab, "Type: CURRENCY_FLD_DB", "\n");
         CurrencyPartInfo currencyPart = (CurrencyPartInfo) objVal;
         PrintString(indent + tab, "Currency Part Info: ", currencyPart.toString(), "\n");
      }
      else if(opType == OperandType.CURRENCY_FLD_CURRENT)
      {
         PrintHeader(indent + tab, "Type: CURRENCY_FLD_CURRENT", "\n");
         CurrencyPartInfo currencyPart = (CurrencyPartInfo) objVal;
         PrintString(indent + tab, "Currency Part Info: ", currencyPart.toString(), "\n");
      }
        else
        {
            PrintInt( indent + tab, "Type : Invalid Operation - ", operation, "\n" );
        }
    }


    public static void PrintRelationalOperationInfo( String indent, String header, RelationalOperationInfo value )
    {

        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null RelationalOperationInfo", "\n" );
            return;
        }

        PrintInt( indent + tab, "Operation Code :", value.getOperation( ), "\n" );

        PrintArithmeticOrRelationalOperand( indent + tab, "Left Operand : ", value.getLeftOperand( ) );
        PrintArithmeticOrRelationalOperand( indent + tab, "Right Operand : ", value.getRightOperand( ) );

        PrintNewLine( );
    }


    public static void PrintQualifierOperationCode( String indent, String header, int operationCode )
    {
        switch( operationCode )
        {
            case QualifierInfo.AR_COND_OP_NONE   :
                PrintString( indent + tab + header + " : <Operation code none>" );
                break;

            case QualifierInfo.AR_COND_OP_AND    :
                PrintString( indent + tab + header + " : < AND Operation (" + QualifierInfo.AR_COND_OP_AND + ") >"   );
                break;

            case QualifierInfo.AR_COND_OP_OR     :
                PrintString( indent + tab + header + " : < OR Operation (" + QualifierInfo.AR_COND_OP_OR + ") >"   );
                break;

            case QualifierInfo.AR_COND_OP_NOT    :
                PrintString( indent + tab + header + " : < NOT Operation (" + QualifierInfo.AR_COND_OP_NOT + ") >"  );
                break;

            case QualifierInfo.AR_COND_OP_REL_OP :
                PrintString( indent + tab + header + " : < RELATIONAL Operation (" + QualifierInfo.AR_COND_OP_REL_OP + ") >"   );
                break;

            case QualifierInfo.AR_COND_OP_FROM_FIELD :
                PrintString( indent + tab + header + " : < FROMFIELD Operation (" + QualifierInfo.AR_COND_OP_FROM_FIELD + ") >"  );
                break;
            default  :
                PrintString( indent + tab + "Invalid Operation code..." + operationCode  );
                break;
        }
    }

    public static void PrintQualifierInfo( String indent, String header, QualifierInfo value)
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null QualifierInfo", "\n" );
            return;
        }
        PrintQualifierOperationCode( indent + tab, "Operation Code : ", value.getOperation( ) );
        switch( value.getOperation( ) )
        {
            case QualifierInfo.AR_COND_OP_NONE   :
                PrintString( indent + tab + " No operation mentioned..."  );
                break;

            case QualifierInfo.AR_COND_OP_AND    :
            case QualifierInfo.AR_COND_OP_OR     :
                PrintQualifierInfo( indent + tab, "Left Operand: ", value.getLeftOperand( ) );
                PrintQualifierInfo( indent + tab, "Right Operand: ", value.getRightOperand( ) );
                break;

            case QualifierInfo.AR_COND_OP_NOT    :
                PrintQualifierInfo( indent + tab, "Right Operand: ", value.getNotOperand( ) );
                break;

            case QualifierInfo.AR_COND_OP_REL_OP :
                PrintRelationalOperationInfo( indent + tab, "Relational Operation Info: ", value.getRelationalOperationInfo( ) );
                break;

            case QualifierInfo.AR_COND_OP_FROM_FIELD :
                QualifierFromFieldInfo fromfid = value.getFromFieldInfo();
                PrintString(indent + tab, "From Field: ", fromfid.toString(), "\n");
                break;

            default  :
                PrintString( indent + tab + "Invalid Operation code..." );
                break;
        }

        PrintNewLine( );
    }

    public static void PrintPropertyTag( String indent, String header, int propertyTag )
    {
         PrintHeader( indent, header + "< " + propertyTag + " >", "" );

         switch( propertyTag )
         {
            case Constants.AR_DPROP_TRIM_TYPE       :
               PrintString("TRIM TYPE");
               break;
            case Constants.AR_DPROP_CNTL_TYPE       :
               PrintString("CNTL TYPE");
               break;
            case Constants.AR_DPROP_BBOX            :
               PrintString("BBOX");
               break;
            case Constants.AR_DPROP_VISIBLE         :
               PrintString("VISIBLE");
               break;
            case Constants.AR_DPROP_ENABLE          :
               PrintString("ENABLE");
               break;
            case Constants.AR_DPROP_HELP            :
               PrintString("HELP");
               break;
            case Constants.AR_DPROP_Z_ORDER         :
               PrintString("Z ORDER");
               break;
            case Constants.AR_DPROP_COLOR_FILL      :
               PrintString("COLOR FILL");
               break;
            case Constants.AR_DPROP_DEPTH_EFFECT    :
               PrintString("DEPTH EFFECT");
               break;
            case Constants.AR_DPROP_DEPTH_AMOUNT    :
               PrintString("DEPTH AMOUNT");
               break;
            case Constants.AR_DPROP_COLOR_LINE      :
               PrintString("COLOR LINE");
               break;
            case Constants.AR_DPROP_COLOR_TEXT      :
               PrintString("COLOR TEXT");
               break;
            case Constants.AR_DPROP_PROMPT          :
               PrintString("PROMPT");
               break;
            case Constants.AR_DPROP_LABEL           :
               PrintString("LABEL");
               break;
            case Constants.AR_DPROP_LABEL_BBOX      :
               PrintString("LABEL BBOX");
               break;
            case Constants.AR_DPROP_LABEL_FONT_STYLE:
               PrintString("LABEL FONT STYLE");
               break;
            case Constants.AR_DPROP_LABEL_FONT_SIZE :
               PrintString("LABEL FONT SIZE");
               break;
            case Constants.AR_DPROP_LABEL_COLOR_TEXT:
               PrintString("LABEL COLOR TEXT");
               break;
            case Constants.AR_DPROP_LABEL_JUSTIFY   :
               PrintString("LABEL JUSTIFY");
               break;
            case Constants.AR_DPROP_LABEL_ALIGN     :
               PrintString("LABEL ALIGN");
               break;
            case Constants.AR_DPROP_LABEL_POS_SECTOR :
               PrintString("LABEL POS SECTOR");
               break;
            case Constants.AR_DPROP_LABEL_POS_JUSTIFY:
               PrintString("LABEL POS JUSTIFY");
               break;
            case Constants.AR_DPROP_LABEL_POS_ALIGN :
               PrintString("LABEL POS ALIGN");
               break;
            case Constants.AR_DPROP_LABEL_COLOR_FILL:
               PrintString("LABEL COLOR FILL");
               break;
            case Constants.AR_DPROP_LABEL_COLOR_LINE:
               PrintString("LABEL COLOR LINE");
               break;
            case Constants.AR_DPROP_COORDS          :
               PrintString("COORDS");
               break;
            case Constants.AR_DPROP_LINE_WIDTH      :
               PrintString("LINE WIDTH");
               break;
            case Constants.AR_DPROP_LINE_PATTERN    :
               PrintString("LINE PATTERN");
               break;
            case Constants.AR_DPROP_JOINT_STYLE     :
               PrintString("JOINT STYLE");
               break;
            case Constants.AR_DPROP_ENDCAP_START    :
               PrintString("ENDCAP START");
               break;
            case Constants.AR_DPROP_ENDCAP_END      :
               PrintString("ENDCAP END");
               break;
            case Constants.AR_DPROP_DATA_ROWS       :
               PrintString("DATA ROWS");
               break;
            case Constants.AR_DPROP_DATA_COLS       :
               PrintString("DATA COLS");
               break;
            case Constants.AR_DPROP_DATA_SPIN       :
               PrintString("DATA SPIN");
               break;
            case Constants.AR_DPROP_DATA_MENU       :
               PrintString("DATA MENU");
               break;
            case Constants.AR_DPROP_DATA_RADIO      :
               PrintString("DATA RADIO");
               break;
            case Constants.AR_DPROP_DATA_MENU_BBOX  :
               PrintString("MENU BBOX");
               break;
            case Constants.AR_DPROP_DATA_EXPAND_BBOX:
               PrintString("EXPAND BBOX");
               break;
            case Constants.AR_DPROP_TEXT            :
               PrintString("TEXT");
               break;
            case Constants.AR_DPROP_TEXT_FONT_STYLE :
               PrintString("TEXT FONT STYLE");
               break;
            case Constants.AR_DPROP_TEXT_FONT_SIZE  :
               PrintString("TEXT FONT SIZE");
               break;
            case Constants.AR_DPROP_JUSTIFY         :
               PrintString("JUSTIFY");
               break;
            case Constants.AR_DPROP_ALIGN           :
               PrintString("ALIGN");
               break;
            case Constants.AR_DPROP_IMAGE           :
               PrintString("IMAGE");
               break;
            case Constants.AR_DPROP_PUSH_BUTTON_IMAGE:
               PrintString("PUSH BUTTON IMAGE");
               break;
            case Constants.AR_DPROP_BUTTON_TEXT     :
               PrintString("BUTTON TEXT");
               break;
            case Constants.AR_DPROP_BUTTON_2D       :
               PrintString("BUTTON 2D");
               break;
            case Constants.AR_DPROP_BUTTON_IMAGE_POSITION :
               PrintString("BUTTON IMAGE POSITION");
               break;
            case Constants.AR_DPROP_BUTTON_SCALE_IMAGE :
               PrintString("BUTTON SCALE IMAGE");
               break;
            case Constants.AR_DPROP_BUTTON_MAINTAIN_RATIO :
               PrintString("BUTTON MAINTAIN RATIO");
               break;
            case Constants.AR_DPROP_MENU_TEXT       :
               PrintString("MENU TEXT");
               break;
            case Constants.AR_DPROP_MENU_POS        :
               PrintString("MENU POS");
               break;
            case Constants.AR_DPROP_MENU_MODE       :
               PrintString("MENU MODE");
               break;
            case Constants.AR_DPROP_MENU_PARENT     :
               PrintString("MENU PARENT");
               break;
            case Constants.AR_DPROP_MENU_HELP       :
               PrintString("MENU HELP");
               break;
            case Constants.AR_DPROP_TOOLTIP         :
               PrintString("TOOLTIP");
               break;
            case Constants.AR_DPROP_TOOLBAR_POS     :
               PrintString("TOOLBAR POS");
               break;
            case Constants.AR_DPROP_TOOLBAR_MODE    :
               PrintString("TOOLBAR MODE");
               break;
            case Constants.AR_DPROP_TOOLBAR_TEXT    :
               PrintString("TOOLBAR TEXT");
               break;
            case Constants.AR_DPROP_TAB_MODE        :
               PrintString("TAB MODE");
               break;
            case Constants.AR_DPROP_TAB_COORD       :
               PrintString("TAB COORD");
               break;
            case Constants.AR_DPROP_TAB_TEXT        :
               PrintString("TAB TEXT");
               break;
            case Constants.AR_DPROP_TAB_ORDER       :
               PrintString("TAB ORDER");
               break;
            case Constants.AR_DPROP_DATETIME_POPUP  :
               PrintString("DATETIME POPUP");
               break;
            case Constants.AR_DPROP_BACKGROUND_MODE :
               PrintString("BACKGROUND MODE");
               break;
            case Constants.AR_DPROP_TAB_NEXT        :
               PrintString("TAB NEXT");
               break;
            case Constants.AR_DPROP_DATA_BBOX       :
               PrintString("DATA BBOX");
               break;
            case Constants.AR_DPROP_VIEW_GRID_BBOX  :
               PrintString("VIEW GRID BBOX");
               break;
            case Constants.AR_DPROP_VUI_DEFAULT     :
               PrintString("VUI DEFAULT");
               break;
            case Constants.AR_DPROP_PANE_LAYOUT     :
               PrintString("PANE LAYOUT");
               break;
            case Constants.AR_DPROP_DETAIL_PANE_VISIBILITY :
               PrintString("DETAIL PANE VISIBILITY");
               break;
            case Constants.AR_DPROP_PROMPT_PANE_VISIBILITY :
               PrintString("PROMPT PANE VISIBILITY");
               break;
            case Constants.AR_DPROP_RESULT_PANE_VISIBILITY :
               PrintString("RESULT PANE VISIBILITY");
               break;
            case Constants.AR_DPROP_DETAIL_PANE_COLOR :
               PrintString("DETAIL PANE COLOR");
               break;
            case Constants.AR_DPROP_DETAIL_PANE_IMAGE :
               PrintString("DETAIL PANE IMAGE");
               break;
            case Constants.AR_DPROP_IMAGE_ALIGN     :
               PrintString("IMAGE ALIGN");
               break;
            case Constants.AR_DPROP_IMAGE_JUSTIFY   :
               PrintString("IMAGE JUSTIFY");
               break;
            case Constants.AR_DPROP_DISPLAY_PARENT  :
               PrintString("DISPLAY PARENT");
               break;
            case Constants.AR_DPROP_PAGE_ORDER      :
               PrintString("PAGE ORDER");
               break;
            case Constants.AR_DPROP_PAGE_LABEL_DISPLAY :
               PrintString("PAGE LABEL DISPLAY");
               break;
            case Constants.AR_DPROP_PAGE_ARRANGEMENT:
               PrintString("PAGE ARRANGEMENT");
               break;
            case Constants.AR_DPROP_DEFAULT_PAGE    :
               PrintString("DEFAULT PAGE");
               break;
            case Constants.AR_DPROP_TITLE_BAR_ICON_IMAGE :
               PrintString("TITLE BAR ICON IMAGE");
               break;
            case Constants.AR_DPROP_DETAIL_PANE_WIDTH :
               PrintString("DETAIL PANE WIDTH");
               break;
            case Constants.AR_DPROP_DETAIL_PANE_HEIGHT :
               PrintString("DETAIL PANE HEIGHT");
               break;
            case Constants.AR_DPROP_DETAIL_BANNER_VISIBILITY :
               PrintString("DETAIL BANNER VISIBILITY");
               break;
            case Constants.AR_DPROP_PROMPT_BANNER_VISIBILITY :
               PrintString("PROMPT BANNER VISIBILITY");
               break;
            case Constants.AR_DPROP_RESULT_BANNER_VISIBILITY :
               PrintString("RESULT BANNER VISIBILITY");
               break;
            case Constants.AR_DPROP_ALIAS_SINGULAR  :
               PrintString("ALIAS SINGULAR ");
               break;
            case Constants.AR_DPROP_ALIAS_PLURAL    :
               PrintString("ALIAS PLURAL");
               break;
            case Constants.AR_DPROP_ALIAS_SHORT_SINGULAR :
               PrintString("ALIAS SHORT SINGULAR ");
               break;
            case Constants.AR_DPROP_ALIAS_SHORT_PLURAL :
               PrintString("ALIAS SHORT PLURAL");
               break;
            case Constants.AR_DPROP_ALIAS_ABBREV_SINGULAR :
               PrintString("ALIAS ABBREV SINGULAR ");
               break;
            case Constants.AR_DPROP_ALIAS_ABBREV_PLURAL :
               PrintString("ALIAS ABBREV PLURAL");
               break;
            case Constants.AR_DPROP_NAMED_SEARCHES  :
               PrintString("NAMED SEARCHES");
               break;
            case Constants.AR_DPROP_MENU_ACCESS     :
               PrintString("MENU ACCESS");
               break;
            case Constants.AR_DPROP_PANE_VISIBILITY_OPTION :
               PrintString("PANE VISIBILITY OPTION");
               break;
            case Constants.AR_DPROP_REQUEST_IDENTIFIER :
               PrintString("REQUEST IDENTIFIER");
               break;
            case Constants.AR_DPROP_QUERY_LIST_COLOR:
               PrintString("QUERY LIST COLOR");
               break;
            case Constants.AR_DPROP_COLUMN_WIDTH    :
               PrintString("COLUMN WIDTH");
               break;
            case Constants.AR_DPROP_COLUMN_ORDER    :
               PrintString("COLUMN ORDER");
               break;
            case Constants.AR_DPROP_SORT_SEQ        :
               PrintString("COLUMN SORT SEQUENCE");
               break;
            case Constants.AR_DPROP_SORT_DIR        :
               PrintString("COLUMN SORT DIRECTION");
               break;
            case Constants.AR_DPROP_DRILL_DOWN      :
               PrintString("DRILL DOWN");
               break;
            case Constants.AR_DPROP_REFRESH         :
               PrintString("REFRESH");
               break;
            case Constants.AR_DPROP_AUTO_REFRESH    :
               PrintString("AUTO REFRESH");
               break;
            case Constants.AR_DPROP_AUTOFIT_COLUMNS :
               PrintString("AUTOFIT COLUMNS");
               break;
            case Constants.AR_DPROP_APPLY_DIRTY     :
               PrintString("APPLY DIRTY");
               break;
	    case Constants.AR_DPROP_IMAGE_CACHE     :
               PrintString("IMAGE CACHE");
               break;
	    case Constants.AR_DPROP_ENUM_LABELS     :
               PrintString("DISPLAY LABELS");
               break;
            case Constants.AR_OPROP_VENDOR_NAME     :
               PrintString("VENDOR NAME");
               break;
            case Constants.AR_OPROP_VENDOR_PRODUCT  :
               PrintString("VENDOR PRODUCT");
               break;
            case Constants.AR_OPROP_VENDOR_VERSION     :
               PrintString("VENDOR VERSION");
               break;
            case Constants.AR_OPROP_GUID               :
               PrintString("GUID");
               break;
            case Constants.AR_OPROP_COPYRIGHT          :
               PrintString("COPYRIGHT");
               break;
            case Constants.AR_OPROP_SCC_LOCKED_BY      :
               PrintString("SCC LOCKED BY");
               break;
            case Constants.AR_OPROP_SCC_VERSION        :
               PrintString("SCC VERSION");
               break;
            case Constants.AR_OPROP_SCC_TIMESTAMP      :
               PrintString("SCC TIMESTAMP");
               break;
            case Constants.AR_OPROP_SCC_USER           :
               PrintString("SCC USER");
               break;
            case Constants.AR_OPROP_SCC_LOCATION       :
               PrintString("SCC LOCATION");
               break;
            case Constants.AR_OPROP_SCC_DATA_LOCKED_BY :
               PrintString("SCC DATA LOCKED BY");
               break;
            case Constants.AR_OPROP_SCC_DATA_VERSION   :
               PrintString("SCC DATA VERSION");
               break;
            case Constants.AR_OPROP_SCC_DATA_TIMESTAMP :
               PrintString("SCC DATA TIMESTAMP");
               break;
            case Constants.AR_OPROP_SCC_DATA_USER      :
               PrintString("SCC DATA USER");
               break;
            case Constants.AR_OPROP_SCC_DATA_LOCATION  :
               PrintString("SCC DATA LOCATION");
            default                       :
               PrintString( "   <undefined property >" );
               break;
         }
    }

    public static void PrintPropInfo( String indent, String header, PropInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null PropInfo", "\n" );
            return;
        }
        PrintPropertyTag(  indent + tab, "Property Tag : ", value.getPropertyTag( ) );

        PrintValue( indent + tab, "Property Value : ", value.getPropertyValue( ) );

        PrintNewLine( );
    }

    public static void PrintPropInfoList( String indent, String header, PropInfo[] value )
    {

        PrintHeader( indent, header, "\n"  );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null PropInfo list", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of values: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintPropInfo( indent + tab, "PropInfo: ", value[i] );
        }

        PrintNewLine( );
    }


    public static void PrintDisplayInstanceInfo( String indent, String header, DisplayInstanceInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null DisplayInstance Info", "\n" );
            return;
        }

        PrintLong( indent + tab, "Internal ID : ", value.getVUIId( ).getValue( ), "\n" );

        PrintPropInfoList( indent + tab, "Properties", value.getVUIProperties( ) );

        PrintNewLine( );
    }


    public static void PrintDisplayInstanceInfoList( String indent, String header, DisplayInstanceInfo[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null DisplayInstanceInfo list", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of values: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintDisplayInstanceInfo( indent + tab, "DisplayInstanceInfo: ", value[i] );
        }

        PrintNewLine( );

    }

    public static void PrintDisplayInstanceList( String indent, String header, DisplayInstanceList value )
    {

        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null DisplayInstance Info", "\n" );
            return;
        }

        if( value.getCommonProperties( ) != null )
        {
            PrintPropInfoList( indent + tab, "Common Properties : ", value.getCommonProperties( ) );
        }
        else
        {
            PrintHeader( indent + tab, "No Common properties", "\n" );
        }

        PrintDisplayInstanceInfoList( indent + tab, "DisplayInstances Properties list: ", value.getDisplayInstances( ) );

        PrintNewLine( );
    }


    public static void PrintDisplayInstanceListList( String indent, String header, DisplayInstanceList[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null DisplayInstanceList list", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of values: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintDisplayInstanceList( indent + tab, "DisplayInstanceList: ", value[i] );
        }

        PrintNewLine( );
    }

    public static void PrintAssignFieldInfo( String indent, String header, AssignFieldInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null assign Field Info value ...", "\n" );
            return;
        }

        PrintString(  indent + tab, "Server: ", value.getServer( ), "\n" );

        PrintString( indent + tab, "Schema: ", value.getSchema( ).toString( ), "\n" );

        PrintLong( indent + tab, "Tag : ", value.getTag( ), "\n" );
        switch (value.getTag())
        {
           case Constants.AR_FIELD:
               PrintLong(indent + tab, "FieldID : ", value.getFieldId(), "\n") ;
               break;
           case Constants.AR_CURRENCY_FLD:
               PrintString(indent + tab, "Currency Part: ", value.getCurrencyPart().toString(), "\n");
               break;
           default:
               break;
        }

        PrintLong( indent + tab, "FieldID : ", value.getFieldId( ), "\n" ) ;

        PrintQualifierInfo( indent + tab, "QualifierInfo: ", value.getQualifier( ) );

        PrintLong( indent + tab, "No Match Option : ", value.getNoMatchOption( ), "\n" );

        PrintLong( indent + tab, "Multi Match Option : ", value.getMultiMatchOption( ), "\n" );

        PrintStatusHistoryValue( indent + tab, "Status History: ", value.getStatHistory( ) );

        PrintNewLine( );
    }

    public static void PrintStatusHistoryValue( String indent, String header, StatusHistoryValue value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null Status History value ...", "\n" );
            return;
        }

        PrintBoolean( indent + tab, "Time : ", value.isTime( ), "\n" );

        PrintInt( indent + tab, "Value : ", value.getEnumValue( ), "\n" );

        PrintNewLine( );
    }


    public static void PrintAssignSQLInfo( String indent, String header, AssignSQLInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null AssignSQLInfo value...", "\n" );
            return;
        }

        PrintString( indent + tab, "Server: ", value.getServer( ), "\n" );


        if( value.getSqlCommand( ) == null)
        {
            PrintHeader( indent + tab, "SQL Command: NULL", "\n" );
        }
        else
        {
            PrintString( indent + tab, "SQL Command: ", value.getSqlCommand( ), "\n" );
        }

        PrintLong( indent + tab, "Value Index: ", value.getValueIndex( ), "\n" );

        PrintLong( indent + tab, "No Match Option : ", value.getNoMatchOption( ), "\n" );

        PrintLong( indent + tab, "Multi Match Option : ", value.getMultiMatchOption( ), "\n" );

        PrintNewLine( );
    }


    public static void PrintAssignInfo( String indent, String header, AssignInfo value )
    {

        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null AssignInfo value...", "\n" );
            return;
        }

        PrintLong( indent + tab, "Assign Type : ", value.getAssignType( ), "\n" );

        PrintArithOpAssignInfo( indent + tab, "AssignInfo :", value.getArithOp( ) );

        PrintAssignFieldInfo( indent + tab, "AssignFieldInfo :", value.getField( ) );

        PrintFunctionAssignInfo( indent + tab, "Function Assign Info :", value.getFunction( ) );

        PrintAssignSQLInfo( indent + tab, "Assign SQL Info :", value.getSql( ) );

        PrintString( indent + tab, "Process :", value.getProcess( ), "\n" );

        PrintDDEInfo( indent + tab, "DDE Info :", value.getDde( ) );


        PrintValue( indent + tab, "Value :", value.getValue( ) );

        PrintNewLine( );
    }

    public static void PrintAssignInfoList( String indent, String header, AssignInfo[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null AssignInfo list", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of values: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintAssignInfo( indent + tab, "AssignInfoInfo: ", value[i] );
        }

        PrintNewLine( );
    }

    public static void PrintFieldAssignInfo( String indent, String header, FieldAssignInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null AssignSQLInfo value...", "\n" );
            return;
        }


        PrintLong( indent + tab, "Field Id : ", value.getFieldId( ).getValue( ), "\n" );

        PrintAssignInfo( indent + tab, " AssignInfo : ", value.getAssignment( ) );

        PrintNewLine( );
    }




    public static void PrintFieldAssignInfoList( String indent, String header, FieldAssignInfo[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null FieldAssign list", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of values: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintFieldAssignInfo( indent + tab, "FieldAssignInfo: ", value[i] );
        }

        PrintNewLine( );
    }


    public static void PrintSetFieldsActionInfo(String indent, String header, SetFieldsActionInfo value) {
        PrintHeader( indent, header, "\n" );
        if( value == null )
        {
            PrintHeader( indent + tab, " Null Set Fields Info", "\n" );
            return;
        }
        PrintString(indent, "Sample Server: ", value.getSampleServer().toString(), "/n");
        PrintString(indent, "Sample Schema: ", value.getSampleSchema().toString(), "/n");
        PrintFieldAssignInfoList(indent, "Set Fields: ", value.getSetFieldsList());
    }

    public static void PrintFunctionAssignInfo( String indent, String header, FunctionAssignInfo value )
    {

        PrintHeader( indent, header, "\n" );


        if( value == null )
        {
            PrintHeader( indent + tab,  "Null FunctionAssignInfo....", "\n" );
            return;
        }

        PrintLong( indent + tab,  "Function Code : ", value.getFunctionCode( ), "\n" );

        PrintLong( indent + tab, "Number of items : ", value.getNumItems( ), "\n" );

        PrintAssignInfoList(  indent + tab, "Parameters List :", value.getParameterList( ) );

        PrintNewLine( );
    }

    public static void PrintNotifyActionInfo( String indent, String header, NotifyActionInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  "Null NotifyActionInfo....", "\n" );
            return;
        }

        PrintLong( indent + tab, "Notify Mechanism: ", value.getNotifyMechanism( ), "\n" );

        PrintLong( indent + tab, "Notify Priority: ", value.getNotifyPriority( ), "\n" );

        PrintLong( indent + tab, "Notify Mechanism X Ref: ", value.getNotifyMechanismXRef( ).getValue( ), "\n" );

        PrintString( indent + tab, "User: ", value.getUser( ), "\n" );

        PrintString( indent + tab, "Notify Text: ", value.getNotifyText( ), "\n" );

        PrintString( indent + tab, "Subject Text: ", value.getSubjectText( ), "\n" );

        PrintLong( indent + tab, "FieldIdListType: ", value.getFieldIdListType( ), "\n" );

        PrintInternalIDList( indent + tab, "Field ID List: ", value.getFieldIdList( ) );

        PrintNewLine( );
    }


    public static void PrintFilterActionInfoList( String indent, String header, FilterActionInfo[] actionList )
    {
        PrintHeader( indent, header, "\n" );

        if( actionList == null )
        {
            PrintHeader( indent + tab,  " Null FilterActionInfo list", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of actions: ", actionList.length, "\n" );

        for( int i = 0; i < actionList.length; i++ )
        {
            PrintFilterActionInfo( indent + tab, "FilterActionInfo " + i + " : ", actionList[i] );
        }

        PrintNewLine( );
    }

    public static void PrintFilterActionName( String indent, String header, long value )
    {
        switch( (int)value )
        {
            case Constants.AR_FILTER_ACTION_FIELDS  :
                PrintString( indent + "Action Name: SET FIELDS");
                break;
            case Constants.AR_FILTER_ACTION_PROCESS :
                PrintString( indent + "Action Name: PROCESS");
                break;
            case Constants.AR_FILTER_ACTION_MESSAGE :
                PrintString( indent + "Action Name: MESSAGE");
                break;
            case Constants.AR_FILTER_ACTION_FIELDP  :
                PrintString( indent + "Action Name: PUSH FIELDS");
                break;
            case Constants.AR_FILTER_ACTION_SQL     :
                PrintString( indent + "Action Name: DIRECT SQL");
                break;
            case Constants.AR_FILTER_ACTION_CALLGUIDE  :
                PrintString( indent + "Action Name: CALL GUIDE");
                break;
            case Constants.AR_FILTER_ACTION_LOG :
                PrintString( indent + "Action Name: LOG TO FILE");
                break;
            case Constants.AR_FILTER_ACTION_NOTIFY :
                PrintString( indent + "Action Name: NOTIFY");
                break;
            case Constants.AR_FILTER_ACTION_GOTOACTION:
                PrintString( indent + "Action Name: GOTO");
                break;
            default          :
                PrintString( indent + "Action Name:    <undefined action > " +  value );
                break;
       }
        PrintNewLine( );
    }
    public static void PrintFilterActionInfo( String indent, String header, FilterActionInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  "Null FilterActionInfo....", "\n" );
            return;
        }

        PrintFilterActionName( indent + tab, "Action : ", value.getAction( ) );

        PrintCallGuideInfo( indent + tab, "Call Guide : ", value.getCallGuide( ) );

        PrintSQLInfo( indent + tab, "SQL Command: ", value.getSqlCommand( ) );

        PrintGotoActionInfo( indent + tab, "Goto : ", value.getGotoAction( ) );

        PrintString( indent + tab, "Log To File : ", value.getLogFile( ), "\n" );

        PrintFilterStatusInfo( indent + tab, "Message: ", value.getMessage( ) );

        PrintNotifyActionInfo( indent + tab, "Notify: ", value.getNotify( ) );

        PrintPushFieldsActionInfo( indent + tab, "Push Fields: ", value.getPushFields( ) );

        PrintString( indent + tab, "Run Process : ", value.getProcess( ), "\n" );

        PrintSetFieldsActionInfo( indent + tab, "Set Fields: ", value.getSetFields( ) );

        PrintNewLine( );
    }


    public static void PrintFilterStatusInfo( String indent, String header, FilterStatusInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  "Null FilterStatusInfo....", "\n" );
            return;
        }

        PrintLong( indent + tab, "   Message type : ", value.getMessageType( ), "\n" );

        PrintLong( indent + tab, "   Message number : ", value.getMessageNum( ), "\n" );

        PrintString( indent + tab, "   Message Text : ", value.getMessageText( ), "\n" );

        PrintNewLine( );
    }


    public static void PrintPushFieldsInfo( String indent, String header,  PushFieldsInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null PushFieldsInfo....", "\n" );
            return;
        }

        PrintAssignFieldInfo( indent + tab, "Assign Field Info: ", value.getField( ) );

        PrintAssignInfo( indent + tab, "Assign Info: ", value.getAssign( ) );

        PrintNewLine( );
    }


    public static void PrintPushFieldsInfoList( String indent, String header, PushFieldsInfo[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null PushFieldsInfo list", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of values: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintPushFieldsInfo( indent + tab, "PushFieldsInfo: ", value[i] );
        }

        PrintNewLine( );
    }

    public static void PrintPushFieldsActionInfo(String indent, String header, PushFieldsActionInfo value)
    {
        PrintHeader( indent, header, "\n" );
        if( value == null )
        {
            PrintHeader( indent + tab, " Null Push Fields Info", "\n" );
            return;
        }
        PrintString(indent, "Sample Server: ", value.getSampleServer().toString(), "/n");
        PrintString(indent, "Sample Schema: ", value.getSampleSchema().toString(), "/n");
        PrintPushFieldsInfoList(indent, "Push Fields: ", value.getPushFieldsList());
    }

    public static void PrintSQLInfo( String indent, String header, SQLInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null SQL Info", "\n" );
            return;
        }

        if( value.getServer( ) != null )
        {
            PrintString( indent + tab, " Server: ", value.getServer( ), "\n" );
        }
        else
        {
            PrintHeader( indent + tab, "Server: <NULL> ", "\n" );
        }

        if( value.getCommand( ) != null )
        {
            PrintString( indent + tab, "SQL Command: ", value.getCommand( ), "\n" );
        }
        else
        {
            PrintHeader( indent + tab, "SQL Command: NULL", "\n" );
        }

        PrintNewLine( );
    }


    public static void PrintGotoActionInfo( String indent, String header, GotoActionInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null GotoActionInfo.....", "\n" );
            return;
        }

        PrintLong( indent + tab, "Tag: ", value.getTag( ), "\n" );
        PrintLong( indent + tab, "FieldID or Value : ", value.getFieldIdOrValue( ), "\n" );

        PrintNewLine( );
    }

    public static void PrintMacroParmInfo( String indent, String header, MacroParmInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null MacroParmInfo.....", "\n" );
            return;
        }

        PrintString( indent + tab, "Name: ", value.getName( ).toString( ), "\n" );
        PrintString( indent + tab, "Value: ", value.getValue( ), "\n" );

        PrintNewLine( );
    }

    public static void PrintMacroParmInfoList( String indent, String header, MacroParmInfo[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null MacroParmInfo list", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of values: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintMacroParmInfo( indent + tab, "PushMacroParmInfo: ", value[i] );
        }

        PrintNewLine( );
    }

    public static void PrintActiveLinkMacroInfo( String indent, String header, ActiveLinkMacroInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null GotoActionInfo.....", "\n" );
            return;
        }

        PrintString(  indent + tab, "Macro name: ", value.getMacroName( ).toString( ), "\n" );

        PrintString(  indent + tab, "Macro text: ", value.getMacroText( ), "\n" );

        PrintMacroParmInfoList( indent + tab, "Macro Param List :", value.getMacroParms( ) );

        PrintNewLine( );
    }


    public static void PrintMessageInfo( String indent, String header, MessageInfo value)
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null GotoActionInfo.....", "\n" );
            return;
        }

        PrintLong( indent + tab, "Message type : ", value.getMessageType( ), "\n" );

        PrintLong( indent + tab,  "Message number : ", value.getMessageNum( ), "\n" );

        if( value.getMessageText( ) != null)
        {
            PrintString( indent + tab, "Message: ", value.getMessageText( ), "\n" );
        }
        else
        {
            PrintHeader( indent + tab, "Message: <NULL>", "\n" );
        }

        PrintBoolean( indent + tab, "Use Prompting Pane : ", value.getUsePromptingPane( ), "\n" );

        PrintNewLine( );
    }


    public static void PrintFieldCharacteristicsInfo( String indent, String header, FieldCharacteristicsInfo value)
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null FieldCharacteristics Info.....", "\n" );
            return;
        }

	PrintInt( indent + tab, "Option: ", value.getOption( ), "\n" );

        PrintLong( indent + tab, "Field Id: ", value.getFieldId( ).getValue( ), "\n" );

        PrintLong( indent + tab, "Reset Focus:", value.getFocus( ), "\n" );

        PrintLong( indent + tab, "Access option:", value.getAccessOption( ), "\n" );

        if( value.getCharMenu( ) == null )
        {
            PrintHeader( indent + tab, "Char menu: NULL", "\n" );
        }
        else
        {
            PrintString( indent + tab, "Char menu: ", value.getCharMenu( ), "\n" );
        }

        PrintPropInfoList( indent + tab, "Properties :", value.getProps( ) );

        PrintNewLine( );
    }


    public static void PrintDDEInfo( String indent, String header, DDEInfo  value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null DDE Info.....", "\n" );
            return;
        }

        if( value.getServiceName( ) != null )
        {
            PrintString( indent + tab, "Service name:", value.getServiceName( ), "\n" );
        }
        else
        {
            PrintHeader( indent + tab, "Service name: < NULL >", "\n" );
        }

        if( value.getTopic( ) != null )
        {
            PrintString( indent + tab, "Topic:", value.getTopic( ), "\n" );
        }
        else
        {
            PrintHeader( indent + tab, "Topic: < NULL >", "\n" );
        }

        PrintLong( indent + tab, "Action: ", value.getAction( ), "\n" );

        if( value.getPathToProgram( ) != null )
        {
            PrintString( indent + tab, "Path to Program:", value.getPathToProgram( ), "\n" );
        }
        else
        {
            PrintHeader( indent + tab, "Path to Program:< NULL >", "\n" );
        }

        if( value.getCommand( ) != null )
        {
            PrintString( indent + tab, "Command: ", value.getCommand( ), "\n" );
        }
        else
        {
            PrintHeader( indent + tab, "Command: <NULL> ", "\n" );
        }

        if( value.getItem( ) != null )
        {
            PrintString( indent + tab, "Item:", value.getItem( ), "\n" );
        }
        else
        {
            PrintHeader( indent + tab, "Item:", "\n" );
        }

        PrintNewLine( );
    }


    public static void PrintAutomationInfo( String indent, String header, AutomationInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null Automation Info.....", "\n" );
            return;
        }

        PrintString( indent + tab, "Auto Server name:", value.getAutoServerName( ), "\n" );

        PrintBoolean( indent + tab, "Automation Server Showing flag :", value.getIsVisible( ), "\n" );

        PrintString( indent + tab, "Class Id:", value.getClsId( ), "\n" );

        PrintString( indent + tab, "Automation Action: ", value.getAction( ), "\n" );

        PrintCOMMethodInfoList( indent + tab, "Com methods list: ", value.getMethodList( ) );

        PrintNewLine( );
    }


    public static void PrintCOMValueInfo( String indent, String header, COMValueInfo value )
    {

        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null COMValueInfo.....", "\n" );
            return;
        }

        if( value.getFieldId( ) != null )
        {
            PrintLong( indent + tab, "FieldId: ", value.getFieldId( ).getValue( ), "\n" );
        }
        else
        {
            PrintString( indent + tab, "FieldId: ", "< null >", "\n" );
        }

        if( value.getTransId( ) != null )
        {
            PrintLong( indent + tab, "TransientId: ", value.getTransId( ).getValue( ), "\n" );
        }
        else
        {
            PrintString( indent + tab, "TransientId: ", "< null >", "\n" );
        }

        PrintLong( indent + tab, "Value Type: ", value.getValueType( ), "\n" );

        PrintString( indent + tab, "ValueId: ", value.getValueIId( ), "\n" );


        PrintValue( indent + tab, "value: ", value.getValue( ) );

        PrintNewLine( );
    }

    public static void PrintCOMMethodInfoList( String indent, String header, COMMethodInfo[] value)
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null COMMethodInfo List....", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of Items : ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintCOMMethodInfo( indent + tab, null, value[i] );
        }

        PrintNewLine( );
    }



    public static void PrintCOMMethodInfo( String indent, String header, COMMethodInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null COMMethodInfo Info....", "\n" );
            return;
        }

        PrintString( indent+ tab, "Method Name: ", value.getMethodName( ), "\n" );

        PrintString( indent + tab, "Method Interface Id: ", value.getMethodIId( ), "\n" );

        PrintLong( indent + tab, "Method Type: ", value.getMethodType( ), "\n" );

        PrintCOMValueInfo( indent + tab, "Method:", value.getMethodValue( ) );

        PrintCOMMethodParmInfoList( indent + tab, " Parameter List: \n",  value.getParameterList( ) );

        PrintNewLine( );
    }


    public static void PrintCOMMethodParmInfoList( String indent, String header, COMMethodParmInfo[] value )
    {

        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null COMMethodParmInfo List", "\n" );
            return;
        }
        PrintInt( indent +tab,  "Number of Items : ", value.length, "\n" );
        for( int i = 0; i < value.length; i++ )
        {
            PrintCOMMethodParmInfo( indent + tab, null, value[i] );
        }

        PrintNewLine( );
    }



    public static void PrintCOMMethodParmInfo( String indent, String header, COMMethodParmInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null COMMethodParmInfo", "\n" );
            return;
        }

        PrintString( indent + tab, "Parameter Name: ", value.getParmName( ), "\n" );

        PrintLong( indent + tab, "Parameter Type: ", value.getParmType( ), "\n" );

        PrintCOMValueInfo( indent + tab, "Parameter: ", value.getParmValue( ) );
    }




    public static void PrintOpenDialogInfo( String indent, String header, OpenDialogInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null OpenDlg Info", "\n" );
            return;
        }

        PrintString( indent + tab, "Server Name: ", value.getServerName( ).toString( ), "\n" );

        PrintString( indent + tab, "Schema Name: ", value.getSchemaName( ).toString( ), "\n" );

        PrintString( indent + tab, "Vui Label: ", value.getVuiLabel( ).toString( ), "\n" );

        PrintBoolean( indent + tab, "Close Box Showing flag : ", value.getCloseBox( ), "\n" );

        PrintFieldAssignInfoList( indent + tab, "Input Value Fields : ", value.getInputValueFieldPairs( ) );
        PrintFieldAssignInfoList( indent + tab, "Output Value Fields : ", value.getOutputValueFieldPairs( ) );

        PrintInt( indent + tab, "Window Mode: ", value.getWindowMode(), "\n");
        PrintString( indent + tab, "Target Location: ", value.getTargetLocation(), "\n");
        PrintQualifierInfo( indent + tab, "Query: ", value.getQuery());
        PrintBoolean( indent + tab, "No Match Continue: ", value.getNoMatchContinue(), "\n");
        PrintBoolean( indent + tab, "Suppress Empty List: ", value.getSuppressEmptyLst(), "\n");
        PrintMessageInfo( indent + tab, "Message: ", value.getMsg());
        PrintLong( indent + tab, "Polling Interval: ", value.getPollinginterval(), "\n");
        PrintString( indent + tab, "Report String: ", value.getReportString(), "\n");
        PrintSortInfoList( indent + tab, "Sort Order List: ", value.getSortOrderList());

        PrintNewLine( );
    }


    public static void PrintCallGuideInfo( String indent, String header, CallGuideInfo value )
    {
        PrintHeader( indent, header, "\n" );
        FieldID fid;

        if( value == null )
        {
            PrintHeader( indent + tab, " Null CallGuide Info", "\n" );
            return;
        }

        PrintString( indent + tab, "Server Name: ", value.getServerName( ).toString( ), "\n" );
        PrintString( indent + tab, "Guide Name: ", value.getGuideName( ).toString( ), "\n" );

        PrintInt( indent + tab,"Guide Mode: ", value.getGuideMode( ), "\n" );

        fid = value.getGuideTableId();
        PrintLong(indent + tab, "Table Field: ", fid.getValue(), "\n");

        PrintFieldAssignInfoList(indent + tab, "Input Value Fields : ", value.getInputValueFieldPairs());
        PrintFieldAssignInfoList(indent + tab, "Output Value Fields : ", value.getOutputValueFieldPairs());

        PrintString( indent + tab, "Sample Server Name: ", value.getSampleServer( ).toString( ), "\n" );
        PrintString( indent + tab, "Sample Guide Name: ", value.getSampleGuide( ).toString( ), "\n" );

        PrintNewLine( );
    }



    public static void PrintExitGuideInfo( String indent, String header, ExitGuideInfo value)
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null ExitGuide Info", "\n" );
            return;
        }

        PrintBoolean( indent + tab, "Close All Windows : ", value.getCloseAll( ), "\n" );

        PrintNewLine( );
    }


    public static void PrintGotoGuideLabelInfo( String indent, String header, GotoGuideLabelInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null GotoGuideLabel Info", "\n" );
            return;
        }

        PrintString( indent + tab, "Label: ", value.getLabel( ), "\n" );
        PrintNewLine( );
    }


    public static void PrintWaitInfo( String indent, String header, WaitInfo value)
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null WaitInfo....", "\n" );
            return;
        }

        PrintString( indent + tab, "Continue Button Title: ", value.getContinueButtonTitle( ), "\n" );

        PrintNewLine( );

    }


    public static void PrintCloseWindowInfo( String indent, String header, CloseWindowInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null Close Window Info....", "\n" );
            return;
        }

        PrintBoolean( indent + tab, "Close All: ", value.getCloseAll( ), "\n" );

        PrintNewLine( );
    }


    public static void PrintCommitChangesInfo( String indent, String header, CommitChangesInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null CommitChanges Info....", "\n" );
            return;
        }

        PrintString( indent + tab, "Schema Name: ", value.getSchemaName( ).toString( ), "\n" );

        PrintNewLine( );
    }

    public static void PrintActiveLinkActionName( String indent, String header, long value )
    {
        switch( (int)value )
        {
            case Constants.AR_ACTIVE_LINK_ACTION_MACRO   :
                PrintString( indent + "Action Name: RUN MACRO");
                break;
            case Constants.AR_ACTIVE_LINK_ACTION_FIELDS  :
                PrintString( indent + "Action Name: SET FIELDS");
                break;
            case Constants.AR_ACTIVE_LINK_ACTION_PROCESS :
                PrintString( indent + "Action Name: RUN PROCESS");
                break;
            case Constants.AR_ACTIVE_LINK_ACTION_MESSAGE :
                PrintString( indent + "Action Name: MESSAGE");
                break;
            case Constants.AR_ACTIVE_LINK_ACTION_SET_CHAR:
                PrintString( indent + "Action Name: CHANGE FILED");
                break;
            case Constants.AR_ACTIVE_LINK_ACTION_DDE     :
                PrintString( indent + "Action Name: DDE");
                break;
            case Constants.AR_ACTIVE_LINK_ACTION_FIELDP  :
                PrintString( indent + "Action Name: PUSH FIELDS");
                break;
            case Constants.AR_ACTIVE_LINK_ACTION_SQL     :
                PrintString( indent + "Action Name: DIRECT SQL");
                break;
            case Constants.AR_ACTIVE_LINK_ACTION_AUTO    :
                PrintString( indent + "Action Name: OLE AUTOMATION");
                break;
            case Constants.AR_ACTIVE_LINK_ACTION_OPENDLG   :
                PrintString( indent + "Action Name: OPEN DIALOG/WINDOW");
                break;
            case Constants.AR_ACTIVE_LINK_ACTION_COMMITC   :
                PrintString( indent + "Action Name: CCOMMIT CHANGES");
                break;
            case Constants.AR_ACTIVE_LINK_ACTION_CLOSEWND :
                PrintString( indent + "Action Name: CLOSE WINDOW");
                break;
            case Constants.AR_ACTIVE_LINK_ACTION_CALLGUIDE  :
                PrintString( indent + "Action Name: CALL GUIDE");
                break;
            case Constants.AR_ACTIVE_LINK_ACTION_EXITGUIDE  :
                PrintString( indent + "Action Name: EXIT GUIDE");
                break;
            case Constants.AR_ACTIVE_LINK_ACTION_GOTOGUIDELABEL :
                PrintString( indent + "Action Name: GOTO GUIDE LABEL");
                break;
            case Constants.AR_ACTIVE_LINK_ACTION_WAIT:
                PrintString( indent + "Action Name: WAIT");
                break;
            case Constants.AR_ACTIVE_LINK_ACTION_GOTOACTION:
                PrintString( indent + "Action Name: GOTO");
                break;
            default          :
                PrintString( indent + "Action Name:    <undefined action > " +  value );
                break;
       }
        PrintNewLine( );
    }

    public static void PrintActiveLinkActionInfo(  String indent, String header, ActiveLinkActionInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null ActiveLinkAction Info", "\n" );
            return;
        }

        PrintActiveLinkActionName( indent + tab, "Action : ", value.getAction( ) );

        PrintCallGuideInfo( indent + tab, "Call guide: ", value.getCallGuide( ) );

        PrintFieldCharacteristicsInfo( indent + tab, "Change Field: ", value.getCharacteristics( ) );

        PrintCloseWindowInfo( indent + tab, "Close Window: ", value.getCloseWnd( ) );

        PrintCommitChangesInfo( indent + tab, "Commit Changes: ", value.getCommitChanges( ) );

        PrintDDEInfo( indent + tab, "DDE : ", value.getDde( ) );

        PrintSQLInfo( indent + tab, "Direct SQL: ", value.getSqlCommand( ) );

        PrintExitGuideInfo( indent + tab, "Exit Guide: ", value.getExitGuide( ) );

        PrintGotoGuideLabelInfo( indent + tab, "Goto Guide Label: ", value.getGotoGuide( ) );

        PrintGotoActionInfo( indent + tab, "Goto: ", value.getGotoAction( ) );

        PrintMessageInfo( indent + tab, "Message: ", value.getMessage( ) );

        PrintAutomationInfo( indent + tab, "OLE Automation: ", value.getAutomation( ) );

        PrintOpenDialogInfo( indent + tab, "Open Dialog/Window: ", value.getOpenDlg( ) );

        PrintPushFieldsActionInfo( indent + tab, "Push Fields: ", value.getPushFields( ) );

        PrintActiveLinkMacroInfo( indent + tab, "Run Macro: ", value.getMacro( ) );

        PrintString( indent + tab, "Run Process: ", value.getProcess( ), "\n" );

        PrintSetFieldsActionInfo( indent + tab, "Set Fields: ", value.getSetFields( ) );

        PrintWaitInfo( indent + tab, "Wait: ", value.getWaitAction( ) );

        PrintNewLine( );
    }



    public static void PrintActiveLinkActionInfoList(  String indent, String header, ActiveLinkActionInfo[] value, boolean flag )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null ActiveLinkActionInfo list..", "\n" );
            return;
        }

        if( flag )
        {
            PrintInt( indent + tab, "Active Link Action List items: ", value.length, "\n" );
        }
        else
        {
            PrintInt( indent + tab, "Active Link Else List items: ", value.length, "\n" );
        }

        for( int i = 0; i < value.length; i++ )
        {
            PrintActiveLinkActionInfo( indent + tab, null, value[i] );
        }

        PrintNewLine( );
    }


    public static void PrintActiveLinkList(  String indent, String header, ActiveLink[] activeLinkList )
    {
        PrintHeader( indent, header, "\n" );

        if( activeLinkList == null )
        {
            PrintHeader( indent + tab, "Null ActiveLink list..", "\n" );
            return;
        }

        PrintInt( indent +tab,  "Number of Items : ", activeLinkList.length, "\n" );

        for( int i = 0; i < activeLinkList.length; i++ )
        {
            PrintActiveLink( indent + tab, "ActiveLink Info:", activeLinkList[i] );
        }

        PrintNewLine( );
    }

    public static void PrintWorkflowConnectInfo( String indent, String header, WorkflowConnectInfo workflow )
    {
        PrintHeader( indent, header, "\n" );

        if( workflow == null )
        {
            PrintHeader( indent + tab, " Null WorkflowConnectInfo...", "\n" );
            return;
        }

        PrintLong( indent + tab, "Workflow Type:", workflow.getType( ) , "\n" );

        PrintNameIDList( indent + tab, "Schemas List:", workflow.getSchemaList( ) );

        PrintNewLine( );
    }

    public static void PrintActiveLink(  String indent, String header, ActiveLink activeLink )
    {
        PrintHeader( indent, header, "\n" );

        if( activeLink == null )
        {
            PrintHeader( indent + tab, "Null ActiveLink...", "\n" );
            return;
        }

        if( activeLink.getName( ) != null )
        {
            PrintString( indent + tab, "Name: ", activeLink.getName( ).toString( ), "\n" );
        }
        else
        {
            PrintString( indent + tab, "Name: <null>", "", "\n" );
        }

        PrintLong( indent + tab, "Execution order: ", activeLink.getOrder( ), "\n" );

        // Print Workflow information
            PrintWorkflowConnectInfo( indent + tab, "Work flow information:", activeLink.getWorkflowConnect( ) );

        // Print Group list
            PrintInternalIDList( indent + tab, "Group List: ", activeLink.getGroupList( ) );

        PrintLong( indent + tab, "Execute bitmask: ", activeLink.getExecuteMask( ), "\n" );

        PrintLong( indent + tab, "Control Field: ", activeLink.getControlField( ), "\n" );

        PrintLong( indent + tab, "Cocus Field: ", activeLink.getFocusField( ), "\n" );

        PrintLong( indent + tab, "Enable flag: ", activeLink.getEnable( ), "\n" );

        // Print Qualifier
            PrintQualifierInfo( indent + tab, "", activeLink.getQualifier( ) );

        // Print Active Link action list
            PrintActiveLinkActionInfoList( indent + tab, "", activeLink.getActionList( ), true );

        // Print Active Link else action list
            PrintActiveLinkActionInfoList( indent + tab, "", activeLink.getElseList( ), false );

        if( activeLink.getHelpText( ) != null )
        {
            PrintString( indent + tab, "Help Text: ", activeLink.getHelpText( ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "HelpText: <null>"  );
        }

/*        if( activeLink.getLastUpdateTime( ) != null )
        {
            PrintString( indent + tab + "Last Update Time:" +  activeLink.getLastUpdateTime( ).getValue( )  );
        }
        else
        {
            PrintString( indent + tab + "Last Update Time: <null>"  );
        } */

        if( activeLink.getOwner( ) != null )
        {
            PrintString( indent + tab, "Owner: ", activeLink.getOwner( ).toString( ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "Owner: null"  );
        }

        if( activeLink.getLastChangedBy( ) != null )
        {
            PrintString( indent + tab + "Last Changed: " + activeLink.getLastChangedBy().toString( )  );
        }
        else
        {
            PrintString( indent + tab + "Last Changed: <null>"  );
        }

        if( activeLink.getDiary( ) != null )
        {
            PrintDiaryString( indent + tab, "Change Diary: ", activeLink.getDiary( ) );
        }
        else
        {
            PrintString( indent + tab + "Change Diary: null "  );
        }


        PrintPropInfoList( indent + tab, "Properties List: ", activeLink.getObjPropList( ) );

        PrintNewLine( );
    }

    public static void PrintPermissionInfo( String indent, String header, PermissionInfo value, boolean fieldFlag )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null Permission Info...", "\n" );
            return;
        }

        PrintLong( indent + tab, "Group id:", value.getGroupID( ).getValue( ) , "\n" );

        switch( value.getPermissionValue( ) )
        {
            case Constants.AR_PERMISSIONS_NONE :
                PrintString( indent + tab + "Permissions: NONE"  );
                break;

            case Constants.AR_PERMISSIONS_VIEW :
                if( fieldFlag )
                {
                    PrintString( indent + tab + "Permissions: VIEW" );
                }
                else
                {
                    PrintString( indent + tab + "Permissions: VISIBLE"  );
                }
                break;

            case Constants.AR_PERMISSIONS_CHANGE :
                if( fieldFlag )
                {
                    PrintString( indent + tab + "Permissions: CHANGE"  );
                }
                else
                {
                    PrintString( indent + tab + "Permissions: HIDDEN" );
                }
                break;
        }

        PrintNewLine( );
    }



    public static void PrintPermissionInfoList( String indent, String header, PermissionInfo[] value, boolean fieldFlag )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null PermissionInfo list..", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of Items: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintPermissionInfo( indent + tab, null, value[i], fieldFlag );
        }
        PrintNewLine( );
    }





    public static void PrintGroupInfo( String indent, String header, GroupInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null GroupInfo....", "\n" );
            return;
        }

        PrintLong( indent + tab, "Group ID: ", value.getGroupID( ).getValue( ), "\n" );

        PrintInt( indent + tab, "Group Type: ", value.getGroupType( ), "\n" );

        PrintInt( indent + tab, "Group Category: ", value.getGroupCategory( ), "\n" );

        PrintAccessNameIDList( indent+ tab, "Group name(s): ", value.getGroupName( ) );

        PrintNewLine( );
    }
    public static void PrintGroupInfoList( String indent, String header, GroupInfo[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null GroupInfo List..", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of Items: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintGroupInfo( indent + tab, null, value[i] );
        }
        PrintNewLine( );
    }

    public static void PrintRoleInfo( String indent, String header, RoleInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null RoleInfo....", "\n" );
            return;
        }

        PrintLong(indent + tab, "Role ID: ", value.getRoleID(), "\n");
        PrintString( indent + tab, "Role name: ", value.getRoleName().toString(), "\n" );
        PrintLong(indent + tab, "Role Type: ", value.getRoleType(), "\n");
    }

    public static void PrintRoleInfoList( String indent, String header, RoleInfo[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null RoleInfo List..", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of Items: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintRoleInfo( indent + tab, null, value[i] );
        }
        PrintNewLine( );
    }

    public static void PrintUserLicenseInfo( String indent, String header, UserLicenseInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null UserLicenseInfo.....", "\n" );
            return;
        }

        PrintInt( indent + tab, "License Tag: ", value.getLicenseTag( ), "\n" );

        PrintInt( indent + tab, "License Type: ", value.getLicenseType( ), "\n" );

        PrintInt( indent + tab, "Current License Type: ", value.getCurrentLicenseType( ), "\n" );

        PrintLong( indent + tab, "    License Pool: ", value.getLicensePool().getValue(), "\n" );

        PrintString( indent + tab, "License Descriptor: ", value.getAppLicenseDescriptor( ), "\n" );

        PrintNewLine( );
    }



    public static void PrintUserLicenseInfoList( String indent, String header, UserLicenseInfo[]  value )
    {

        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null UserLicenseInfo list..", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of Items: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintUserLicenseInfo( indent + tab, null, value[i] );
        }

        PrintNewLine( );
    }


    public static void PrintUserInfo( String indent, String header, UserInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null UserInfo....", "\n" );
            return;
        }

        PrintString( indent + tab, "User name: ", value.getUserName( ).toString( ), "\n" );

        PrintUserLicenseInfoList( indent + tab, "license List: ", value.getLicenseInfo( ) );

        PrintTimestamp( indent + tab, "Last Access Time: ", value.getLastAccessTime( ) );

        PrintString( indent + tab, "Email Address: ", value.getEmailAddress( ), "\n" );

        PrintInt( indent + tab, "Default notify mechanism: ", value.getDefaultNotifyMechanism( ), "\n" );

        PrintTimestamp( indent + tab, "Connection Time: ", value.getConnectionTime( ) );

        PrintNewLine( );
    }



    public static void PrintUserInfoList( String indent, String header, UserInfo[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null UserInfo list..", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of Items: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintUserInfo( indent + tab, null, value[i] );
        }

        PrintNewLine( );
   }



    public static void PrintIntegerLimitInfo( String indent, String header, IntegerLimitInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null IntegerLimitInfo.....", "\n" );
            return;
        }

        PrintLong( indent + tab, "High Range: ", value.getHighRange( ), "\n" );
        PrintLong( indent + tab, "Low Range : ", value.getLowRange( ), "\n" );

        PrintNewLine( );
    }



    public static void PrintRealLimitInfo( String indent, String header, RealLimitInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null RealLimits Info", "\n" );
            return;
        }

        PrintHeader( indent + tab, "High Range: " + value.getHighRange( ), "\n" );
        PrintHeader( indent + tab, "Low  Range: " + value.getLowRange( ), "\n" );

        PrintInt( indent + tab, "Precision: ", value.getPrecision( ), "\n" );
        PrintNewLine( );
    }



    public static void PrintCharLimitInfo( String indent, String header, CharLimitInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null Char Limit Info", "\n" );
            return;
        }

        PrintInt( indent + tab,"Maximum length: ", value.getMaxLength( ), "\n" );

        PrintInt( indent + tab,"Menu style: ", value.getMenuStyle( ), "\n" );

        PrintInt( indent + tab,"QBE match operation: ", value.getQBEMatch( ), "\n" );

        PrintInt( indent + tab,"FullText Options:", value.getFullTextOption( ), "\n" );

        PrintString( indent + tab,"Character menu:", value.getCharMenu( ).toString( ), "\n" );

        PrintString( indent + tab,"Pattern:", value.getPattern( ), "\n" );

        PrintNewLine( );
    }

    public static void PrintDiaryLimitInfo( String indent, String header, DiaryLimitInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null Diary Limit Info....", "\n" );
            return;
        }

        PrintInt( indent + tab,"FullText Options:", value.getFullTextOption( ), "\n" );

        PrintNewLine( );
    }

    public static void PrintAttachmentLimitInfo( String indent, String header, AttachmentLimitInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null AttachmentLimitInfo....", "\n" );
            return;
        }

        PrintLong( indent + tab,"Maximum Size: ", value.getMaxSize( ), "\n" );

        PrintInt( indent + tab,"Attachment Type: ", value.getAttachType( ), "\n" );

        PrintNewLine( );
    }


    public static void PrintTableLimitInfo( String indent, String header, TableLimitInfo value )
    {
        PrintHeader( indent, header, "\n" );
        if( value == null )
        {
            PrintHeader( indent + tab, " Null TableLimitInfo...", "\n" );
            return;
        }
        PrintString( indent + tab, "Schema: ", value.getSchema( ).toString( ), "\n" );
        PrintString( indent + tab, "Server: ", value.getServer( ).toString( ), "\n" );
        PrintQualifierInfo( indent + tab, "Qualifier: ", value.getQualifier( ) );
        PrintInt( indent + tab, "numColumns: ", value.getColumnCount( ), "\n" );
        PrintInt( indent + tab, "MaxRetrieve: ", value.getMaxRetrieve( ), "\n" );
        PrintString( indent + tab, "Sample Schema: ", value.getSampleSchema( ).toString( ), "\n" );
        PrintString( indent + tab, "Sample Server: ", value.getSampleServer( ).toString( ), "\n" );
        PrintNewLine( );
    }
    public static void PrintViewLimits( String indent, String header, ViewLimits value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null ViewLimits ...", "\n" );
            return;
        }

        PrintInt( indent + tab, "Maximum field Length: ", value.getMaxLength( ), "\n" );

        PrintNewLine( );
    }

    public static void PrintDisplayLimits( String indent, String header, DisplayLimits value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null DisplayLimits ...", "\n" );
            return;
        }

        PrintInt( indent + tab, "Maximum field Length: ", value.getMaxLength( ), "\n" );

        PrintNewLine( );
    }

    public static void PrintEnumLimitInfo( String indent, String header, EnumLimitInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null EnumLimitInfo ...", "\n" );
            return;
        }

        PrintNameIDList( indent + tab, "Enum Values: ", value.getEnumLimit( ) );

        PrintNewLine( );
    }
    public static void PrintColumnLimitInfo( String indent, String header, ColumnLimitInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null ColumnLimitInfo....", "\n" );
            return;
        }

        PrintInt( indent + tab, "Column Length: ", value.getColumnLength( ), "\n" );

        PrintLong( indent + tab, "Parent (Field ID ): ", value.getParent( ).getValue( ), "\n" );

        PrintLong( indent + tab, "Data Field: ", value.getDataField( ).getValue( ), "\n" );

        PrintNewLine( );
    }


    public static void PrintDecimalLimitInfo( String indent, String header, DecimalLimitInfo value  )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null DecimalLimitInfo...", "\n" );
            return;
        }

        PrintHeader( indent + tab, "Low Range: " + value.getLowRange( ), "\n" );

        PrintHeader( indent + tab, "High Range: " + value.getHighRange( ), "\n" );

        PrintInt( indent + tab, "Precision: ", value.getPrecision( ), "\n" );

        PrintNewLine( );
    }

    public static void PrintCurrencyLimitInfo( String indent, String header, CurrencyLimitInfo value  )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null CurrencyLimitInfo...", "\n" );
            return;
        }

        PrintHeader( indent + tab, "Low Range: " + value.getLowRange( ), "\n" );

        PrintHeader( indent + tab, "High Range: " + value.getHighRange( ), "\n" );

        PrintInt( indent + tab, "Precision: ", value.getPrecision( ), "\n" );

        CurrencyDetail[] functional = value.getFunctional();

        DriverPrintResult("   Functional Currencies: " + functional.length + "  items\n" );

        for (int i = 0; i < functional.length; i++)
        {
            PrintString(indent + tab, "  Currency Code: ", functional[i].getCurrencyCode(), "\n" );
            PrintInt( indent + tab, "   Precision:", functional[i].getPrecision(), "\n" );
        }


        CurrencyDetail[] allowable = value.getAllowable();
        DriverPrintResult("   Allowable Currencies: " + allowable.length + "  items\n" );
        for (int i = 0; i < allowable.length; i++)
        {
            PrintString( indent + tab, " Currency Code: ", allowable[i].getCurrencyCode(), "\n" );
            PrintInt( indent + tab, " Precision: ", allowable[i].getPrecision(), "\n" );
        }

        PrintNewLine( );
    }

    public static void PrintCharMenuQueryInfo( String indent, String header, CharMenuQueryInfo value )
    {
        PrintHeader( indent, header, "\n" );
        if( value == null )
        {
            PrintHeader( indent + tab, " Null CharMenuQueryInfo....", "\n" );
            return;
        }
        PrintString( indent + tab, "Schema name: ", value.getSchema( ).toString( ), "\n" );
        PrintString( indent + tab, "Server name: ", value.getServer( ).toString( ), "\n" );
        PrintFieldIDList( indent + tab, "Label Field Id: ", value.getLabelField( ) );
        PrintLong( indent + tab, "Value Field Id: ", value.getValueField( ).getValue( ), "\n" );
        PrintBoolean( indent + tab, "Sort on Label: ", value.getSortOnLabel( ), "\n" );
        PrintQualifierInfo( indent + tab, "Qualifier: ", value.getQualification( ) );
        PrintString( indent + tab, "Sample Schema name: ", value.getSampleSchema( ).toString( ), "\n" );
        PrintString( indent + tab, "Sample Server name: ", value.getSampleServer( ).toString( ), "\n" );
        PrintNewLine( );
    }


    public static void PrintCharMenuSQLInfo( String indent, String header, CharMenuSQLInfo value )
    {

        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null CharMenuSQLInfo....", "\n" );
            return;
        }

        PrintString( indent + tab, "Server name: ", value.getServer( ).toString( ), "\n" );
        PrintString( indent + tab, "Label Index: ", "", "");
        int[] LabelIndex = value.getLabelIndex();
        for (int i = 0; i < LabelIndex.length; i ++)
        {
           if (LabelIndex[i] != 0)
           {
              DriverPrintInt(LabelIndex[i]);
              PrintString(" ");
           }
        }
        PrintString("\n");

        PrintInt( indent + tab, "Value Index: ", value.getValueIndex( ), "\n" );

        PrintString( indent + tab, "SQL Command: ", value.getSQLCommand( ), "\n" );

        PrintNewLine( );
    }

    public static void PrintCharMenuItemInfo( String indent, String header, CharMenuItemInfo value )
    {

        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null Char Menu list Info..", "\n" );
            return;
        }

        PrintInt( indent + tab, "Type: ", value.getType( ), "\n" );

        PrintString( indent + tab, "Label: ", value.getLabel( ).toString( ), "\n" );

        switch( value.getType( ) )
        {
            case 1: String menuItem = ( String ) value.getContents( );
                    PrintString( indent + tab, "Menu Item: ", menuItem, "\n" );
                    break;

            case 2:
                    CharMenuInfo childMenu = ( CharMenuInfo ) value.getContents( );
                    switch( childMenu.getMenuType( ) )
                    {
                        case 1: PrintCharMenuListInfo( indent + tab, null, ( CharMenuListInfo ) childMenu );
                                break;

                        case 2: PrintCharMenuQueryInfo( indent + tab, null, ( CharMenuQueryInfo ) childMenu );
                                break;

                        case 3: PrintCharMenuFileInfo( indent + tab, null, ( CharMenuFileInfo ) childMenu );
                                break;

                        case 4: PrintCharMenuSQLInfo( indent + tab, null, ( CharMenuSQLInfo ) childMenu );
                                break;

                        default: PrintString( indent + tab + "Invalid child menu type : " + childMenu.getMenuType( ) );
                                 break;
                    }
                    break;

            default : PrintString( indent + tab + "Invalid Menu Type : " + value.getType( )  );
                      break;
        }

        PrintNewLine( );
    }


    public static void PrintCharMenuInfo( String indent, String header, CharMenuInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null CharMenuInfo..", "\n" );
            return;
        }

        PrintInt( indent + tab, "Menu Type: ", value.getMenuType( ), "\n" );

        switch( value.getMenuType( ) )
        {

            case 1: PrintCharMenuListInfo( indent + tab, null, ( CharMenuListInfo ) value );
                    break;

            case 2: PrintCharMenuQueryInfo( indent + tab, null, ( CharMenuQueryInfo ) value );
                    break;

            case 3: PrintCharMenuFileInfo( indent + tab, null, ( CharMenuFileInfo ) value );
                    break;

            case 4: PrintCharMenuSQLInfo( indent + tab, null, ( CharMenuSQLInfo ) value );
                    break;

            default: PrintString( indent + tab + "Invalid child menu type : " + value.getMenuType( )  );
                     break;
        }

        PrintNewLine( );
    }

    public static void PrintCharMenuItemInfoList( String indent, String header, CharMenuItemInfo[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null CharMenuItemInfo list..", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of Items: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintCharMenuItemInfo( indent + tab, null, value[i] );
        }

        PrintNewLine( );
    }

    public static void PrintCharMenuListInfo(String indent, String header, CharMenuListInfo value )
    {

        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null Char Menu list Info..", "\n" );
            return;
        }
        PrintCharMenuItemInfoList( indent + tab, "Char Menu List : ", value.getItems( ) );

        PrintNewLine( );
    }

    public static void PrintCharMenuFileInfo(String indent, String header, CharMenuFileInfo value )
    {

        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null Char Menu File Info..", "\n" );
            return;
        }

        PrintInt( indent + tab, "File Location: ", value.getLocation( ), "\n" );

        if( value.getFileName( ) != null )
        {
            PrintString( indent + tab, "File Name: ", value.getFileName( ), "\n" );
        }
        else
        {
            PrintString( indent + tab, "File Name: ", "Null", "\n" );
        }

        PrintNewLine( );
    }

    public static void PrintMenu( String indent, String header, Menu menu )
    {
        if( menu == null )
        {
            PrintString( indent + header + ": Null Menu" );
            return;
        }

        if( menu.getName( ) != null )
        {
            PrintString( indent + tab + "Menu name : " + menu.getName( ).toString( )  );
        }

        PrintString( indent + tab + "Refresh Code: " + menu.getRefreshCode( ) );

        PrintCharMenuInfo( indent + tab, "Menu Information: ", menu.getMenuDefinition( ) );

        if( menu.getHelpText( ) != null )
        {
            PrintString( indent + tab, "Help Text: ", menu.getHelpText( ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "Help Text: <null>"  );
        }

        if( menu.getOwner( ) != null )
        {
            PrintString( indent + tab, "Owner: ", menu.getOwner( ).toString( ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "Owner: null"  );
        }

        if( menu.getLastChangedBy( ) != null )
        {
            PrintString( indent + tab + "Last Changed: " + menu.getLastChangedBy().toString( )  );
        }
        else
        {
            PrintString( indent + tab + "Last Changed: <null>"   );
        }
    //    PrintString( indent + tab + "Last Update Time:" +  menu.getLastUpdateTime( ).getValue( )  );

        if( menu.getDiary( ) != null )
        {
            PrintDiaryString( indent + tab, "Change Diary: ", menu.getDiary( )  );
        }
        else
        {
            PrintString( indent + tab + "Change Diary: null "  );
        }

        PrintPropInfoList( indent + tab, "Properties: ", menu.getProperties( ) );

        PrintNewLine( );
    }

    public static void PrintMenuList( String indent, String header, Menu[] menuList )
    {
        PrintHeader( indent, header, "\n" );

        if( menuList == null )
        {
            PrintHeader( indent + tab, "Null Menu list..", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of Items: ", menuList.length, "\n" );

        for( int i = 0; i < menuList.length; i++ )
        {
            PrintMenu( indent + tab, null, menuList[i] );
        }

        PrintNewLine( );
    }

    public static void PrintServerInfo( String indent, String header, ServerInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null Server Info....", "\n" );
            return;
        }

        PrintInt( indent + tab, "Operation: ", value.getOperation( ), "\n" );

        PrintValue( indent + tab, "Value: ", value.getValue( ) );

        PrintNewLine( );
    }


    public static void PrintServerInfoList( String indent, String header, ServerInfo[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null ServerInfo list..", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of Items: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintServerInfo( indent + tab, null, value[i] );
        }

        PrintNewLine( );
    }


    public static void PrintProcessResult( String indent, String header, ProcessResult result )
    {
        PrintHeader( indent, header, "\n" );

        if( result == null )
        {
            PrintHeader( indent + tab, " Process Result is null....", "\n" );
            return;
        }

        PrintInt( indent + tab, "Operation Status: ", result.getStatus( ), "\n" );

        PrintString( indent + tab, "Process Output: ", result.getOutput( ), "\n" );

        PrintNewLine( );
    }



    public static void PrintFullTextInfo( String indent, String header, FullTextInfo value )
    {
        PrintHeader( indent, header, "\n" );

        PrintInt( indent + tab, "Text Info Type: ", value.getInfoType( ), "\n" );
        PrintValueList( indent + tab, "Value : ", value.getValue( ) );

        PrintNewLine( );
    }



    public static void PrintFullTextInfoList( String indent, String header, FullTextInfo[] value )
    {

        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null FullTextInfo list..", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of Items: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintFullTextInfo( indent + tab, null, value[i] );
        }

        PrintNewLine( );
   }


    public static void PrintFieldMappingInfo( String indent, String header, FieldMappingInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null FieldMappingInfo.....", "\n" );
            return;
        }

        switch( value.getFieldType( ) )
        {
            case 0       :  PrintHeader( indent + tab, "Field Type : NONE", "\n" );
                            break;
            case 1       :  PrintHeader( indent + tab, "Field Type : REGULAR", "\n" );
                            break;
            case 2       :  PrintHeader( indent + tab, "Field Type : JOIN", "\n" );
                            JoinMappingInfo joinMap = (JoinMappingInfo) value;
                            FieldID id = joinMap.getFieldID( );
                            PrintInt( indent + tab, "Schema Index : ", joinMap.getIndex( ), "\n");
                            PrintLong( indent + tab, "Field ID     : ", id.getValue( ), "\n" );
                            break;
            case 3       :  PrintHeader( indent + tab, "Field Type : VIEW", "\n" );
                            ViewMappingInfo viewMap = (ViewMappingInfo) value;
                            NameID viewFieldName = viewMap.getFieldName( );
                            PrintString( indent + tab, "Field Name : ", viewFieldName.toString( ), "\n" );
                            break;
            case 4       :  PrintHeader( indent + tab, "Field Type : VENDOR", "\n" );
                            VendorMappingInfo vendorMap = (VendorMappingInfo) value;
                            NameID vendorFieldName = vendorMap.getFieldName( );
                            PrintString( indent + tab, "Field Name : ", vendorFieldName.toString( ), "\n" );
                            break;
            default: PrintInt( indent + tab, " Field Type: bad type - ", value.getFieldType( ), "\n" );
                     break;
        }

        PrintNewLine( );
    }


    public static void PrintFieldMappingInfoList( String indent, String header, FieldMappingInfo[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null Field MappingInfo list..", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of Items: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintFieldMappingInfo( indent + tab, null, value[i] );
        }

        PrintNewLine( );
    }

    public static void PrintContainerType( String indent, String header, ContainerType value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null ContainerType....", "\n" );
            return;
        }
        PrintInt( indent + tab, "Container Type: ", value.toInt( ), "\n" );

        PrintNewLine( );
    }


    public static void PrintContainerKey( String indent, String header, ContainerKey value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null ContainerKey....", "\n" );
            return;
        }
        PrintString( indent + tab, "Name: ", value.toString( ), "\n" );

        PrintNewLine( );
    }

    public static void PrintContainer( String indent, String header, Container value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null Container....", "\n" );
            return;
        }

        if( value.getName( ) != null )
        {
            PrintString( indent + tab, "Container Name: ", value.getName( ).toString( ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "Container Name: <null>"  );
        }

        if( value.getLabel( ) != null )
        {
            PrintString( indent + tab, "Label: ", new String( value.getLabel( ) ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "Container Label:<null> "  );

        }

        if( value.getDescription( ) != null )
        {
            PrintString( indent + tab, "Description: ", new String( value.getDescription( ) ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "Container Description:<null> "  );
        }

        PrintPermissionInfoList( indent, "Permission List:", value.getPermissions( ), false );

        PrintInternalIDList( indent, "Sub Admin Group List: ", value.getAdminGroupList( ) );

        PrintBoolean( indent + tab, "Remove Flag: ", value.getRemoveFlag( ), "\n" );

        PrintContainerOwnerList( indent + tab, "Container Owner: ", value.getContainerOwner( ) );

        PrintContainerType( "", "", value.getType( ) );

        if( value.getHelpText( ) != null )
        {
            PrintString( indent + tab, "Help Text: ", value.getHelpText( ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "HelpText: <null>"  );
        }

        if( value.getOwner( ) != null )
        {
            PrintString( indent + tab, "Owner: ", value.getOwner( ).toString( ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "Owner: null" );
        }

        if( value.getLastChangedBy( ) != null )
        {
            PrintString( indent + tab + "Last Changed: " + value.getLastChangedBy().toString( )  );
        }
        else
        {
            PrintString( indent + tab + "Last Changed: <null>"  );
        }
    //    PrintString( indent + tab + "Last Update Time:" +  value.getLastUpdateTime( ).getValue( )  );

        if( value.getDiary( ) != null )
        {
            PrintDiaryString( indent + tab, "Change Diary: ", value.getDiary( ) );
        }
        else
        {
            PrintString( indent + tab + "Change Diary: null "  );
        }


        PrintPropInfoList( indent + tab, "Properties List: ", value.getProperties( ) );

        PrintReferenceBaseList( indent + tab, "Reference Base List: ", value.getReferences( ) );

        PrintNewLine( );
    }

    public static void PrintContainerList( String indent, String header, Container[] containerList )
    {
        PrintHeader( indent, header, "\n" );

        if( containerList == null )
        {
            PrintHeader( indent + tab, "No Containers...", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of Containers: ", containerList.length, "\n" );

        for( int i = 0; i < containerList.length; i++ )
        {
            PrintContainer( indent + tab, "Container " + i + ":", containerList[i] );
        }

        PrintNewLine( );
    }



    public static void PrintContainerOwner( String indent, String header, ContainerOwner value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null ContainerOwner....", "\n" );
            return;
        }

        PrintInt( indent + tab, "Owner Type: ", value.getType( ), "\n" );

        PrintString( indent + tab, "Owner Name: ", value.getName( ).toString( ), "\n" );

        PrintNewLine( );
    }


    public static void PrintContainerOwnerList( String indent, String header, ContainerOwner[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null ContainerOwner[]....", "\n" );
            return;
        }

        for( int i = 0; i < value.length; i++ )
        {
            PrintContainerOwner( indent + tab, "Container Owner" + i + ":", value[i] );
        }

        PrintNewLine( );
    }


    public static void PrintReferenceBase( String indent, String header, ReferenceBase value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null ReferenceBase....", "\n" );
            return;
        }

        if( value.getDataType( ) == ReferenceBase.SYSTEM_REFERENCE )
        {
            PrintReferenceInfo( indent, "Reference Info:", ( ReferenceInfo )value );
        }
        else if( value.getDataType( ) == ReferenceBase.EXTERNAL_REFERENCE )
        {
            PrintExternalReferenceInfo( indent, "External Reference Info:", ( ExternalReferenceInfo )value );
        }
        else
        {
            PrintString( indent + "Unknown Reference Info ( " + value.getDataType( ) + " )"  );
        }

        PrintNewLine( );
    }

    public static void PrintReferenceBaseList( String indent, String header, ReferenceBase[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null Reference Base list..", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of Items: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintReferenceBase( indent + tab, null, value[i] );
        }

        PrintNewLine( );
    }

    public static void PrintReferenceType( String indent, String header, ReferenceType value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null ReferenceType....", "\n" );
            return;
        }

        switch( value.toInt( ) )
        {
            case 0       :  PrintHeader( indent + tab, "Type: NONE", "\n" );
                            break;

            case 1       :  PrintHeader( indent + tab, "Type: ALL", "\n" );
                            break;

            case 2       :  PrintHeader( indent + tab, "Type: SCHEMA", "\n" );
                            break;

            case 3       :  PrintHeader( indent + tab, "Type: FILTER", "\n" );
                            break;

            case 4       :  PrintHeader( indent + tab, "Type: ESCALATION", "\n" );
                            break;

            case 5       :  PrintHeader( indent + tab, "Type: ACTIVELINK", "\n" );
                            break;

            case 6       :  PrintHeader( indent + tab, "Type: CONTAINER", "\n" );
                            break;

            case 7       :  PrintHeader( indent + tab, "Type: CHAR_MENU", "\n" );
                            break;

            case 32788   :  PrintHeader( indent + tab, "Type: APPLICATION_HAS_EXT_HELP", "\n" );
                            break;

            case 32787   :  PrintHeader( indent + tab, "Type: DISTMAPPING_DATA", "\n" );
                            break;

            case 32786   :  PrintHeader( indent + tab, "Type: GROUP_DATA", "\n" );
                            break;

            case 32785   :  PrintHeader( indent + tab, "Type: PACKINGLIST_PACK", "\n" );
                            break;

            case 32784   :  PrintHeader( indent + tab, "Type: PACKINGLIST_APP", "\n" );
                            break;

            case 32783   :  PrintHeader( indent + tab, "Type: PACKINGLIST_GUIDE", "\n" );
                            break;

	    case 32782   :  PrintHeader( indent + tab, "Type: APPLICATION_HELP_FILE_NAME", "\n" );
                            break;

            case 32781   :  PrintHeader( indent + tab, "Type: APPLICATION_HELP_INDEX_FILE", "\n" );
                            break;

            case 32780   :  PrintHeader( indent + tab, "Type: APPLICATION_HELP_INDEX_EXT", "\n" );
                            break;

            case 32779   :  PrintHeader( indent + tab, "Type: APPLICATION_DISABLE_BEGIN_TASK", "\n" );
                            break;

            case 32778   :  PrintHeader( indent + tab, "Type: APPLICATION_FORM_VUI", "\n" );
                            break;

            case 32777   :  PrintHeader( indent + tab, "Type: APPLICATION_PRIMARY_FORM", "\n" ) ;
                            break;

            case 32776   :  PrintHeader( indent + tab, "Type: APPLICATION_HELP_FILE", "\n" );
                            break;

            case 32775   :  PrintHeader( indent + tab, "Type: APPLICATION_HELP_EXT", "\n" );
                            break;

            case 32774   :  PrintHeader( indent + tab, "Type: NULL_STRING", "\n" );
                            break;

            case 32773   :  PrintHeader( indent + tab, "Type: ABOUT_BOX_FORM", "\n" );
                            break;

            case 32772   :  PrintHeader( indent + tab, "Type: ABOUT_BOX_IMAGE", "\n" );
                            break;

            case 32771   :  PrintHeader( indent + tab, "Type: APPLICATION_FORMS", "\n" );
                            break;

            case 32770   :  PrintHeader( indent + tab, "Type: MAXIMIZE_FORMS", "\n" );
                            break;

            case 32768   :  PrintHeader( indent + tab, "Type: ICON", "\n" );
                            break;

            case 32769   :  PrintHeader( indent + tab, "Type: SMALL_ICON", "\n" );
                            break;

			case Constants.ARREF_ENCAPSULATED_APP_DATA   :  PrintHeader( indent + tab, "Type: ARREF_ENCAPSULATED_APP_DATA", "\n" );
							break;

			case Constants.ARREF_APP_PACKING_LISTS   :  PrintHeader( indent + tab, "Type: ARREF_APP_PACKING_LISTS", "\n" );
							break;

			case Constants.ARREF_APP_DATA_MERGE_IMP_QUAL   :  PrintHeader( indent + tab, "Type: ARREF_APP_DATA_MERGE_IMP_QUAL", "\n" );
							break;

			case Constants.ARREF_APP_DATA_MERGE_IMP_OPTION   :  PrintHeader( indent + tab, "Type: ARREF_APP_DATA_MERGE_IMP_OPTION", "\n" );
							break;

            default: PrintInt( indent + tab, " Type: bad referencetype - ", value.toInt( ), "\n" );
                     break;

	}
    }

    public static void PrintReferenceInfo( String indent, String header, ReferenceInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null ReferenceInfo....", "\n" );
            return;
        }

        PrintString( indent + tab, "Name: ", value.getName( ).toString( ), "\n" );

        PrintString( indent + tab, "Label: ", new String( value.getLabel( ) ), "\n" );

        PrintString( indent + tab, "Description: ", new String( value.getDescription( ) ), "\n" );

        PrintInt( indent + tab, "Data Type: ", value.getDataType( ), "\n" );

        PrintReferenceType( indent + tab, "Reference Type : ",value.getReferenceType( ) );

        PrintNewLine( );
    }



    public static void PrintExternalReferenceInfo( String indent, String header, ExternalReferenceInfo value )
    {

        PrintHeader( indent, header, "\n" );


        if( value == null )
        {
            PrintHeader( indent + tab, " Null ExternalReferenceInfo....", "\n" );
            return;
        }

        PrintInternalIDList( indent, "Admin Group List: ", value.getAdminGroupList( ) );

        PrintValue( indent, "Value: ", value.getValue( ) );

        PrintString( indent + tab, "Label: ", new String( value.getLabel( ) ), "\n" );

        PrintString( indent + tab, "Description: ", new String( value.getDescription( ) ), "\n" );

        PrintInt( indent + tab, "Data Type: ", value.getDataType( ), "\n" );

        PrintReferenceType( indent + tab, "Reference Type : ",value.getReferenceType( ) );

        PrintNewLine( );
    }



    public static void PrintReferenceInfoList( String indent, String header, ReferenceInfo[] value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, "Null Reference list..", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of Items: ", value.length, "\n" );

        for( int i = 0; i < value.length; i++ )
        {
            PrintReferenceInfo( indent + tab, null, value[i] );
        }

        PrintNewLine( );
    }



    public static void PrintReturnCode( String indent, int returnCode )
    {
       PrintHeader( indent + tab, "ReturnCode:  ", "\n" );

       switch( returnCode )
       {
           case 0        :
               PrintHeader(indent + tab, "OK", "\n" );
               break;

           case 1    :
               PrintHeader( indent + tab, "WARNING", "\n" );
               break;

           case 2      :
               PrintHeader( indent + tab, "ERROR", "\n" ) ;
               break;

           case 3      :
               PrintHeader( indent + tab, "FATAL", "\n" );
               break;

           case 4 :
               PrintHeader( indent + tab, "BAD STATUS", "\n" );
               break;

           default                   :
               PrintInt( indent + tab, "<unknown return> : ", returnCode, "\n");
               break;
        }
    }

    public static void PrintVUIID( String indent, String header, FieldID id )
    {

        if( id != null )
        {
            PrintLong( indent, "VUI ID: ", id.getValue( ), "\n" );
        }
        else
        {
            PrintString( indent + "VUI ID: <null>"  );
        }
    }

    public static void PrintView( String indent, String header, View view )
    {
        PrintHeader( indent, header, "\n" );

        if( view == null )
        {
            PrintHeader( indent + tab, "Null View..", "\n" );
            return;
        }
        if( view.getName( ) != null )
        {
            PrintString( indent + tab, "View name: ", view.getName( ).toString( ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "View name: <null>"  );
        }

        PrintPropInfoList( indent + tab, "Properties List: ", view.getDisplayProperties( ) );

        if( view.getHelpText( ) != null )
        {
            PrintString( indent + tab, "Help Text: ", view.getHelpText( ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "Help Text: <null>"  );
        }
/*        if( view.getLastUpdateTime( ) == null )
        {
            PrintString( indent + tab + "Last Update Time: <null>"  );
        }
        else
        {
            PrintString( indent + tab + "Last Update Time:" +  view.getLastUpdateTime( ).getValue( )  );
        }
 */       if( view.getOwner( ) != null )
        {
            PrintString( indent + tab, "Owner: ", view.getOwner( ).toString( ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "Owner: null"  );
        }

        if( view.getLastChangedBy( ) != null )
        {
            PrintString( indent + tab + "Last Changed: " + view.getLastChangedBy().toString( )  );
        }
        else
        {
            PrintString( indent + tab + "Last Changed: <null>" );
        }

        if( view.getDiary( ) != null )
        {
            PrintDiaryString( indent + tab, "Change Diary: ", view.getDiary( ) );
        }
        else
        {
            PrintString( indent + tab + "Change Diary: null "  );
        }

        PrintNewLine( );

    }

    public static void PrintViewList( String indent, String header, View[] viewList )
    {
        PrintHeader( indent, header, "\n" );

        if( viewList == null )
        {
            PrintHeader( indent + tab, "Null View list..", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of Views: ", viewList.length, "\n" );

        for( int i = 0; i < viewList.length; i++ )
        {
            PrintView( indent + tab, "View (" + i + ") :", viewList[i] );
        }

        PrintNewLine( );
    }

    public static void PrintFilter(  String indent, String header, Filter filter )
    {
        PrintHeader( indent, header, "\n" );

        if( filter == null )
        {
            PrintHeader( indent + tab, "Null Filter...", "\n" );
            return;
        }

        if( filter.getName( ) != null )
        {
            PrintString( indent + tab, "Name: ", filter.getName( ).toString( ), "\n" );
        }
        else
        {
            PrintString( indent + tab, "Name: <null>", "", "\n" );
        }

        PrintLong( indent + tab, "Order: ", filter.getOrder( ), "\n" );

        // Print Workflow information
            PrintWorkflowConnectInfo( indent + tab, "Work flow information:", filter.getWorkflowConnect( ) );


        PrintLong( indent + tab, "Operation bit bitmask: ", filter.getOpSet( ), "\n" );

        PrintLong( indent + tab, "Enable flag: ", filter.getEnable( ), "\n" );

        // Print Qualifier
            PrintQualifierInfo( indent + tab, "", filter.getQualifier( ) );

        // Print Active Link action list
            PrintFilterActionInfoList( indent + tab, "Filter Action List:", filter.getActionList( ) );

        // Print Active Link else action list
            PrintFilterActionInfoList( indent + tab, "Filter Action else list:", filter.getElseList( ) );

        if( filter.getHelpText( ) != null )
        {
            PrintString( indent + tab, "Help Text: ", filter.getHelpText( ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "HelpText: <null>"  );
        }

 /*       if( filter.getLastUpdateTime( ) != null )
        {
            PrintString( indent + tab + "Last Update Time:" +  filter.getLastUpdateTime( ).getValue( )  );
        }
        else
        {
            PrintString( indent + tab + "Last Update Time: <null>"  );
        } */

        if( filter.getOwner( ) != null )
        {
            PrintString( indent + tab, "Owner: ", filter.getOwner( ).toString( ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "Owner: null"  );
        }

        if( filter.getLastChangedBy( ) != null )
        {
            PrintString( indent + tab + "Last Changed: " + filter.getLastChangedBy().toString( )  );
        }
        else
        {
            PrintString( indent + tab + "Last Changed: <null>"   );
        }

        if( filter.getDiary( ) != null )
        {
            PrintDiaryString( indent + tab, "Change Diary: ", filter.getDiary( ) );
        }
        else
        {
            PrintString( indent + tab + "Change Diary: null "  );
        }


        PrintPropInfoList( indent + tab, "Properties List: ", filter.getObjPropList( ) );

        PrintNewLine( );
    }

    public static void PrintFilterList( String indent, String header, Filter[] filterList )
    {
        PrintHeader( indent, header, "\n" );

        if( filterList == null )
        {
            PrintHeader( indent + tab, "Null Filter list..", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of Filters: ", filterList.length, "\n" );

        for( int i = 0; i < filterList.length; i++ )
        {
            PrintFilter( indent + tab, "Filter " + i + " :", filterList[i] );
        }

        PrintNewLine( );
    }

    public static void PrintEscalation(  String indent, String header, Escalation escalation )
    {
        PrintHeader( indent, header, "\n" );

        if( escalation == null )
        {
            PrintHeader( indent + tab, "Null Escalation...", "\n" );
            return;
        }

        if( escalation.getName( ) != null )
        {
            PrintString( indent + tab, "Name: ", escalation.getName( ).toString( ), "\n" );
        }
        else
        {
            PrintString( indent + tab, "Name: <null>", "", "\n" );
        }

        PrintEscalationTmInfo( indent + tab, "Escalation Time Information: ", escalation.getEscalationTm( ) );

        // Print Workflow information
            PrintWorkflowConnectInfo( indent + tab, "Work flow information:", escalation.getWorkflowConnect( ) );

        PrintLong( indent + tab, "Enable flag: ", escalation.getEnable( ), "\n" );

        // Print Qualifier
            PrintQualifierInfo( indent + tab, "", escalation.getQualifier( ) );

        // Print action list
            PrintFilterActionInfoList( indent + tab, "Filter Action List:", escalation.getActionList( ) );

        // Print Active Link else action list
            PrintFilterActionInfoList( indent + tab, "Filter Action else list:", escalation.getElseList( ) );

        if( escalation.getHelpText( ) != null )
        {
            PrintString( indent + tab, "Help Text: ", escalation.getHelpText( ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "HelpText: <null>"  );
        }

    /*    if( escalation.getLastUpdateTime( ) != null )
        {
            PrintString( indent + tab + "Last Update Time:" +  escalation.getLastUpdateTime( ).getValue( )  );
        }
        else
        {
            PrintString( indent + tab + "Last Update Time: <null>"  );
        } */

        if( escalation.getOwner( ) != null )
        {
            PrintString( indent + tab, "Owner: ", escalation.getOwner( ).toString( ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "Owner: null"  );
        }

        if( escalation.getLastChangedBy( ) != null )
        {
            PrintString( indent + tab + "Last Changed: " + escalation.getLastChangedBy().toString( )  );
        }
        else
        {
            PrintString( indent + tab + "Last Changed: <null>"   );
        }

        if( escalation.getDiary( ) != null )
        {
            PrintDiaryString( indent + tab, "Change Diary: ", escalation.getDiary( ) );
        }
        else
        {
            PrintString( indent + tab + "Change Diary: null "  );
        }


        PrintPropInfoList( indent + tab, "Properties List: ", escalation.getObjPropList( ) );

        PrintNewLine( );
    }

    public static void PrintEscalationList( String indent, String header, Escalation[] escalationList )
    {
        PrintHeader( indent, header, "\n" );

        if( escalationList == null )
        {
            PrintHeader( indent + tab, "Null Escalation list..", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of Escalations: ", escalationList.length, "\n" );

        for( int i = 0; i < escalationList.length; i++ )
        {
            PrintEscalation( indent + tab, "Escalation " + i + " :", escalationList[i] );
        }

        PrintNewLine( );
    }

    public static void PrintEntryKey( String indent, String header, EntryKey key )
    {
        PrintHeader( indent, header, "\n" );

        if( key == null )
        {
            PrintHeader( indent + tab, " Null EntryKey....", "\n" );
            return;
        }

        PrintString( indent + header + "Schema:  " + key.getSchemaID().toString( ) + "   EntryId: " +   key.getEntryID().toString( ) );

    }
    public static void PrintEntryKeyList( String indent, String header, EntryKey[] list )
    {
        PrintHeader( indent, header, "\n" );

        if( list == null )
        {
            PrintHeader( indent + tab, "Null EntryKey list..", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of Entries: ", list.length, "\n" );

        for( int i = 0; i < list.length; i++ )
        {
            PrintEntryKey( indent + tab, "EntryKey " + (i +1)+ " :", list[i] );
        }

        PrintNewLine( );
    }

    public static void PrintFieldLimitInfo( String indent, String header, FieldLimitInfo info )
    {
        PrintHeader( indent, header, "\n" );

        if( info == null )
        {
            PrintHeader( indent + tab, "Null FieldLimitInfo..", "\n" );
            return;
        }


       switch (info.getDataType( ))
       {
          case Constants.AR_FIELD_LIMIT_NONE  :
               PrintString( "   NO LIMITS\n" );
               break;
          case Constants.AR_DATA_TYPE_CURRENCY:
               PrintCurrencyLimitInfo( indent + tab, "Currency Field Limits:", (CurrencyLimitInfo) info );
               break;
          case Constants.AR_DATA_TYPE_INTEGER :
               PrintIntegerLimitInfo( indent + tab, "Integer Field Limits:", (IntegerLimitInfo) info );
               break;
          case Constants.AR_DATA_TYPE_REAL    :
               PrintRealLimitInfo( indent + tab, "Real Field Limits:", (RealLimitInfo) info );
               break;
          case Constants.AR_DATA_TYPE_CHAR    :
               PrintCharLimitInfo( indent + tab, "Char Field Limits:", (CharLimitInfo) info );
               break;
          case Constants.AR_DATA_TYPE_DIARY   :
               PrintDiaryLimitInfo( indent + tab, "Diary Field Limits:", (DiaryLimitInfo) info );
               break;
          case Constants.AR_DATA_TYPE_ENUM    :
               PrintEnumLimitInfo( indent + tab, "Enum Field Limits:", (EnumLimitInfo) info );
               break;
          case Constants.AR_DATA_TYPE_TIME    :
               PrintString( indent + tab + "TIMESTAMP" );
               break;
          case Constants.AR_DATA_TYPE_ATTACH :
               PrintAttachmentLimitInfo( indent + tab, "Attach Field Limits:", (AttachmentLimitInfo) info );
               break;
          case Constants.AR_DATA_TYPE_DECIMAL:
               PrintDecimalLimitInfo( indent + tab, "Decimal Field Limits:", (DecimalLimitInfo) info );
               break;
          case Constants.AR_DATA_TYPE_TABLE   :
               PrintTableLimitInfo( indent + tab, "Table Field Limits:", (TableLimitInfo) info);
               break;
          case Constants.AR_DATA_TYPE_COLUMN  :
               PrintColumnLimitInfo( indent + tab, "Column Field Limits:", (ColumnLimitInfo) info);
               break;
          case Constants.AR_DATA_TYPE_VIEW    :
               PrintViewLimits( indent + tab, "View Field Limits:", (ViewLimits) info );
               break;
          case Constants.AR_DATA_TYPE_DISPLAY  :
               PrintDisplayLimits( indent + tab, "Display Field Limits:", (DisplayLimits) info);
               break;
          default                   :
               PrintInt( indent + tab, "   <undefined datatype >:", info.getDataType( ), "\n" );
               break;
       }
       PrintNewLine( );
    }

    public static void PrintDayInfo( String indent, String header, DayInfo dateInfo )
    {
        PrintHeader( indent, header, "\n" );

        if( dateInfo == null )
        {
            PrintHeader( indent + tab, " Null DayInfo....", "\n" );
            return;
        }

        PrintLong( indent + tab, "Hour Mask: ", dateInfo.getHourmask( ), "\n" );

        PrintLong( indent + tab, "Minutes: ", dateInfo.getMinute( ), "\n" );

        PrintLong( indent + tab, "Month day: ", dateInfo.getMonthday( ), "\n" );

        PrintLong( indent + tab, "Week day: ", dateInfo.getWeekday( ), "\n" );

        PrintNewLine( );
    }

    public static void PrintEscalationTmInfo( String indent, String header, EscalationTmInfo timeInfo )
    {
        PrintHeader( indent, header, "\n" );

        if( timeInfo == null )
        {
            PrintHeader( indent + tab, " Null EscalationTmInfo....", "\n" );
            return;
        }

        if( timeInfo.getEscalationTmType( ) == Constants.AR_ESCALATION_TYPE_INTERVAL )
        {
            PrintLong( indent + tab, "Time Interval: ", timeInfo.getInterval( ), "\n" );
        }
        else if( timeInfo.getEscalationTmType( ) == Constants.AR_ESCALATION_TYPE_TIMEMARK )
        {
            PrintDayInfo( indent + tab, "Date Information:", timeInfo.getDate( ) );
        }
        else
        {
            PrintLong( indent + tab, "Wrong Time type: ", timeInfo.getEscalationTmType( ), "\n" );
        }

        PrintNewLine( );
    }


    public static void PrintSQLResult( String indent, String header, SQLResult result )
    {
        PrintHeader( indent, header, "\n" );

        if( result == null )
        {
            PrintHeader( indent + tab, " Null SQLResult....", "\n" );
            return;
        }

	PrintInt( indent + tab, "Number of Items: ", result.getTotalNumberOfMatches(), "\n" );
        Value valueListList[][] = result.getContents();
   	for(int i = 0; i < valueListList.length; i++)
        {
 	   PrintValueList( indent + tab, "ValueList " + i +": ", valueListList[i] );
           PrintNewLine( );
        }

        PrintNewLine( );
    }

    public static void PrintStatisticsResultInfo( String indent, String header, StatisticsResultInfo result )
    {
        PrintHeader( indent, header, "\n" );

        if( result == null )
        {
            PrintHeader( indent + tab, " Null StatisticsResultInfo....", "\n" );
            return;
        }
        PrintValue( indent + tab, "Stat value :" ,  result.getResult( ) );
        PrintValueList( indent + tab, "Grouped By :",  result.getGroupByValues( ) );

        PrintNewLine( );
    }

    public static void PrintStatisticsResultInfoList( String indent, String header, StatisticsResultInfo[] list )
    {
        PrintHeader( indent, header, "\n" );

        if( list == null )
        {
            PrintHeader( indent + tab, " Null StatisticsResultInfo List....", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of Items: ", list.length, "\n" );

        for( int i = 0; i < list.length; i++ )
        {
            PrintStatisticsResultInfo( indent + tab, "StatisticsResultInfo " + i + " :", list[i] );
        }

        PrintNewLine( );
    }
    public static void PrintEntryList( String indent, String header, Entry[] entryList )
    {
        PrintHeader( indent, header, "\n" );

        if( entryList == null )
        {
            PrintHeader( indent + tab, " Null Entry List....", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of Entries: ", entryList.length, "\n" );

        for( int i = 0; i < entryList.length;i++ )
        {
            if( entryList[i].isPresent( ) )
            {
               EntryID entryId = entryList[i].getKey().getEntryID();
               PrintEntryItemList( indent + tab, "Entry Items of entry Id " + entryId + " : ",
                                   entryList[i].getEntryItems( ) );
            }
            else
            {
               PrintString( indent + tab, "Entry Id ", entryList[i].getEntryID().toString( ) + "  is not present", "\n" );
            }
         }
    }

    public static void PrintStatusHistoryString( String indent, String header, String historyString )
    {
      try{
        PrintHeader( indent, header, "\n" );

        if( historyString == null )
        {
            PrintHeader( indent + tab, " Null status history String....", "\n" );
            return;
        }

        StatusHistory statHistory = new StatusHistory( historyString );
        StatusHistoryInfo[] statusHistoryList = statHistory.decode( JavaDriver.getControlStructObject( ) );

        if( statusHistoryList != null )
        {
            for( int i = 0; i < statusHistoryList.length; i++ )
            {
                PrintHeader( indent, "Status History Item " + i + " :", "\n" );
                if( statusHistoryList[i].getUser( ) != null )
                {
                    PrintString( indent + tab, "User: ", statusHistoryList[i].getUser( ).toString( ), "\n" );
                }
                else
                {
                    PrintString( indent + tab, "Null User Name ", "  ", "\n" );
                }
                PrintTimestamp( indent + tab, "Time stamp: ", statusHistoryList[i].getTimestamp( ) );
                PrintNewLine( );
            }
        }

        PrintNewLine( );
     }

     catch( ARException e )
     {
         e.describe( );
     }
   }
    public static void PrintDiaryString( String indent, String header, String diaryString )
    {
      try{
        PrintHeader( indent, header, "\n" );

        if( diaryString == null )
        {
            PrintHeader( indent + tab, " Null DiaryString....", "\n" );
            return;
        }

        Diary diary = new Diary( diaryString );
        DiaryInfo[] diaryList = diary.decode( JavaDriver.getControlStructObject( ) );

        if( diaryList != null )
        {
            for( int i = 0; i < diaryList.length; i++ )
            {
                PrintHeader( indent, "Diary Item " + i + " :", "\n" );
                if( diaryList[i].getUser( ) != null )
                {
                    PrintString( indent + tab, "User: ", diaryList[i].getUser( ).toString( ), "\n" );
                }
                else
                {
                    PrintString( indent + tab, "Null User Name ID", "  ", "\n" );
                }
                PrintString( indent + tab, "Diary String: ", diaryList[i].getDiaryInfo( ), "\n" );
                PrintTimestamp( indent + tab, "Time stamp: ", diaryList[i].getTimestamp( ) );
                PrintNewLine( );
            }
        }

        PrintNewLine( );
     }

     catch( ARException e )
     {
         e.describe( );
     }
   }

    public static void PrintSupportFileKey( String indent, String header, SupportFileKey key )
    {
        PrintHeader( indent, header, "\n" );

        if( key == null )
        {
            PrintHeader( indent + tab, " Null SupportFileKey...", "\n" );
            return;
        }

        PrintLong( indent + tab, "File Type:", key.getFileType( ) , "\n" );

         NameID	name = key.getName();
	 if( name != null )
         {
             PrintString( indent + tab, "Name ID: ", name.toString( ), "\n" );
         }
         else{
             PrintString( indent + tab, "Name ID: ", "null", "\n" );
         }

	 PrintInternalID ( indent + tab, "Field ID: ", key.getFieldId());

	 PrintLong ( indent + tab, "File ID: ", key.getFileId(), "\n" );

        PrintNewLine( );
    }


    public static void PrintSupportFile(  String indent, String header, SupportFile supportFile )
    {
        PrintHeader( indent, header, "\n" );

        if( supportFile == null )
        {
            PrintHeader( indent + tab, "Null supportFile...", "\n" );
            return;
        }

        // Print SupportFileKey information
            PrintSupportFileKey( indent + tab, "Support File Key:", supportFile.getKey( ) );

        if( supportFile.getFilePath( ) != null )
        {
            PrintString( indent + tab, "FilePath: ", supportFile.getFilePath( ).toString( ), "\n" );
        }
        else
        {
            PrintString( indent + tab, "FilePath: <null>", "", "\n" );
        }

        PrintNewLine( );
    }


    public static void PrintSupportFileList(  String indent, String header, SupportFile[] SupportFileList )
    {
        PrintHeader( indent, header, "\n" );

        if( SupportFileList == null )
        {
            PrintHeader( indent + tab, "Null SupportFile list..", "\n" );
            return;
        }

        PrintInt( indent +tab,  "Number of Items : ", SupportFileList.length, "\n" );

        for( int i = 0; i < SupportFileList.length; i++ )
        {
            PrintSupportFile( indent + tab, "SupportFile Info:", SupportFileList[i] );
        }

        PrintNewLine( );
    }


    public static void PrintEntryID( String indent, String header,  EntryID value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab,  " Null EntryID ", "\n" );
            return;
        }


        PrintString( indent + tab, "Entry ID: ", value.toString( ), "\n" );

        PrintNewLine( );
    }

    static void PrintJoinSchemaInfo( String indent, String header, JoinSchemaInfo schemaInfo )
    {
        PrintHeader( indent, header, "\n" );
        if( schemaInfo == null )
        {
            PrintHeader( indent + tab, "Join Schema Info is not present < NULL >", "\n" );
            return;
        }
        if( schemaInfo.getMemberA( ) == null )
        {
            PrintString( indent + tab +  "Join MemberA is not present < NULL > "  );
        }
        else
        {
            PrintString( indent + tab, "Join MemberA: ", schemaInfo.getMemberA( ).toString( ), "\n" );
        }
        if( schemaInfo.getMemberB( ) == null )
        {
            PrintString( indent + tab +  "Join MemberB is not present < NULL > " );
        }
        else
        {
            PrintString( indent + tab, "Join MemberB: ", schemaInfo.getMemberB( ).toString( ), "\n" );
        }

        PrintInt( indent + tab, "Join Option: ", schemaInfo.getJoinOption( ), "\n" );
        PrintQualifierInfo( indent + tab, "Join Qualification: ", schemaInfo.getJoinQualification( ) );

        PrintNewLine( );
    }
    static void PrintVendorSchemaInfo( String indent, String header, VendorSchemaInfo schemaInfo )
    {
        PrintHeader( indent, header, "\n" );
        if( schemaInfo == null )
        {
            PrintHeader( indent + tab, "Vendor Schema Info is not present < NULL >", "\n" );
            return;
        }

        if( schemaInfo.getVendorName( ) == null )
        {
            PrintString( indent + tab +  " Vendor Name is not present < NULL > "  );
        }
        else
        {
            PrintString( indent + tab, "Vendor Name: ", schemaInfo.getVendorName( ).toString( ), "\n" );
        }
        if( schemaInfo.getTableName( ) == null )
        {
            PrintString( indent + tab +  "Vendor Table Name is not present < NULL > "  );
        }
        else
        {
            PrintString( indent + tab, "Vendor Table Name: ", new String( schemaInfo.getTableName( ) ), "\n" );
        }

        PrintNewLine( );
    }

    static void PrintViewSchemaInfo( String indent, String header, ViewSchemaInfo schemaInfo )
    {
        PrintHeader( indent, header, "\n" );
        if( schemaInfo == null )
        {
            PrintHeader( indent + tab, "View Schema Info is not present < NULL >", "\n" );
            return;
        }
        if( schemaInfo.getTableName( ) == null )
        {
            PrintString( indent + tab +  "View Table Name is not present < NULL > " );
        }
        else
        {
            PrintString( indent + tab, "View Table Name: ", new String( schemaInfo.getTableName( ) ), "\n" );
        }
        if( schemaInfo.getKeyField( ) == null )
        {
            PrintString( indent + tab +  "KeyField is not present < NULL > "  );
        }
        else
        {
            PrintString( indent + tab, "KeyField: ", schemaInfo.getKeyField( ).toString( ), "\n" );
        }
        PrintNewLine( );
    }
    static void PrintSchema( String indent, String header, Schema schema )
    {
         PrintHeader( indent, header, "\n" );

         if( schema == null )
         {
             PrintHeader( indent + tab, "Schema is not present....", "\n" );
             return;
         }

         PrintString( "schema name is: " + schema.getName().toString( )  );

         // Print Schema Type information
             switch( schema.getSchemaType( ) )
             {
                 case Constants.AR_SCHEMA_REGULAR :
                     PrintString( "", "Schema Type: ", "<REGULAR>", "\n" );
                     break;

                 case Constants.AR_SCHEMA_JOIN :
                     PrintString( "", "Schema Type: ", "<JOIN>", "\n" );
                     PrintJoinSchemaInfo( "", "Join Schema Info:", (JoinSchemaInfo) schema.getCompoundSchema( ) );
                     break;

                 case Constants.AR_SCHEMA_VIEW :
                     PrintString( "", "Schema Type: ", "<VIEW>", "\n" );
                     PrintViewSchemaInfo( "", "View Schema Info:", ( ViewSchemaInfo) schema.getCompoundSchema( ) );
                     break;

                 case Constants.AR_SCHEMA_VENDOR :
                     PrintString( "", "Schema Type: ", "<VIEW>", "\n" );
                     PrintVendorSchemaInfo( "", "Vendor Schema Info:", (VendorSchemaInfo) schema.getCompoundSchema( ) );
                     break;

                 case Constants.AR_SCHEMA_DIALOG :
                     PrintString( "", "Schema Type: ", "<DIALOG>", "\n" );
                     break;
             }

         PermissionInfo[] permissionList = schema.getPermissions( );
         PrintPermissionInfoList( "", "Permission List: ", permissionList, false );

         InternalID[] admingrp = schema.getAdminGrpList( );
         PrintInternalIDList( "", "Sub Admin Group List :", admingrp );

         EntryListFieldInfo[] entrylist = schema.getEntryListFieldInfo();
         PrintEntryListFieldInfoList( "", "Entry List Field List: ", entrylist );

         SortInfo[] sort = schema.getSortInfo();
         PrintSortInfoList( "", "Sort List :", sort );

         IndexInfo[] index = schema.getIndexInfo();
         PrintIndexInfoList( "", "Index List : ", index );

         ArchiveInfo archive = schema.getArchiveInfo();
         PrintArchiveInfo( "", "Archive Info : ", archive );

         PrintString( "Help text: " + schema.getHelpText( )   );
         PrintNewLine( );

//         PrintTimestamp( );

         AccessNameID owner = schema.getOwner();
         PrintString( "Owner: " + owner.toString( ) );

         PrintString( "last changed by: " + schema.getLastChangedBy().toString()  );

         PrintDiaryString( "", "Change History:", schema.getDiary( ) );

         PropInfo[] props = schema.getProperties();
         PrintPropInfoList( "", "Prop List : ", props );
    }


    static void PrintField( String indent, String header, Field field )
    {
         PrintHeader( indent, header, "\n" );

         if( field == null )
         {
             PrintHeader( indent + tab, "Null Field....", "\n" );
             return;
         }
          // Print all the information
              NameID fieldName = field.getName( );
              PrintString( indent + tab, "Field Name: ", fieldName.toString( ), "\n" );

              FieldMappingInfo mapInfo = field.getFieldMap( );
              PrintFieldMappingInfo( indent + tab, "FieldMapping:", mapInfo );

              DataType type = field.getDataType( );
              PrintDataType( tab, "DataType:", type );

              PrintInt( indent + tab, "Field Option: ", field.getFieldOption( ), "\n" );

              PrintInt( indent + tab, "Field Create Mode: ", field.getCreateMode( ), "\n" );

              PrintFieldLimitInfo( indent + tab, "Field Limits:", field.getFieldLimit( )  );

              PrintValue( indent + tab, "Default Value: ", field.getDefaultValue( ) );

              PrintPermissionInfoList( indent + tab, "Permission List: ", field.getPermissions( ), true );

              PrintString( indent + tab, "Help Text: ", field.getHelpText( ), "\n" );

              PrintTimestamp( indent + tab, "Last changed: ", field.getLastUpdateTime( ) );

              PrintString( indent + tab, "Owner: ", field.getOwner( ).toString( ), "\n" );

              PrintDiaryString( indent + tab, "Diary: ", field.getDiary( )  );

              PrintDisplayInstanceList( indent + tab, "Display Instance List: ", field.getDisplayInstance( ) );
    }
    public static void PrintFieldList( String indent, String header, Field[] fieldList )
    {
        PrintHeader( indent, header, "\n" );

        if( fieldList == null )
        {
            PrintHeader( indent + tab, " Null Field List....", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of Fields: ", fieldList.length, "\n" );

        for( int i = 0; i < fieldList.length;i++ )
        {
            PrintField( indent + tab, "Field (" + i + ") Information: ", fieldList[i] );
        }
    }
    public static void PrintSchemaAliases(String indent, SchemaAliasInfo[] aliases)
    {
        PrintHeader(indent, "Schema Aliases:", "\n" );

        if (aliases == null )
        {
            PrintHeader(indent + tab,  " Null NameID/Alias list", "\n" );
            return;
        }

        PrintInt(indent + tab, "Number of Aliases: ", aliases.length, "\n" );
        for (int i = 0; i < aliases.length; i++ )
        {
            if (aliases[i] != null )
            {
                PrintString(indent + tab, "Name ID: ", aliases[i].getSchemaKey().toString( ), "\n" );
                PrintString(indent + tab, "Alias  : ", aliases[i].getAlias().toString( ), "\n" );
            }
            else{
                PrintString(indent + tab, "Name ID: ", "null", "\n" );
                PrintString(indent + tab, "Alias  : ", "null", "\n" );
            }
        }
        PrintNewLine( );
    }

   static void PrintAlertMessageInfo(String indent, String header, AlertMessageInfo message)
   {
       PrintHeader(indent, header, "\n");
       if (message == null)
       {
          PrintHeader(indent + tab, " NULL Message....", "\n");
          return;
       }
//       PrintTimestamp( indent + tab, "Timestamp: ", message.getTimestamp() );
       PrintInt( indent + tab, "sourceType: ", message.getSourceType(), "\n" );
       PrintInt( indent + tab, "priority: ", message.getPriority() , "\n" );
       PrintString( indent + tab, "  alertText: ", message.getAlertText(), "\n");
       PrintString( indent + tab, "  sourceTag: ", message.getSourceTag(),"\n");
       PrintString( indent + tab, "  serverName: ", message.getServerName(), "\n");
       PrintString(indent + tab, "ServerAddress: ", message.getServerAddr(), "\n");
       PrintString( indent + tab, "  formName : ", message.getFormName(), "\n");
       PrintString( indent + tab, "  objectId : ", message.getObjectId(), "\n");
       PrintNewLine( );
   }


    static void PrintCompoundSchemaInfo(String indent, String header,CompoundSchemaInfo schema)
    {
      PrintHeader(indent, header, "");
      if (schema == null)
      {
         PrintHeader(indent + tab, "CompoundSchemaInfo is NULL....", "\n");
         return;
      }
      switch (schema.getType() )
      {
         case Constants.AR_SCHEMA_NONE :
	    PrintHeader( indent + tab, "None", "\n" );
            break;
         case Constants.AR_SCHEMA_REGULAR :
	    PrintHeader( indent + tab, "REGULAR", "\n" );
            break;
         case Constants.AR_SCHEMA_DIALOG :
	    PrintHeader( indent + tab, "DIALOG", "\n" );
            break;
         case Constants.AR_SCHEMA_JOIN :
            PrintJoinSchemaInfo( indent + tab, "Join Schema Info:", (JoinSchemaInfo)schema );
            break;
         case Constants.AR_SCHEMA_VIEW :
            PrintViewSchemaInfo( indent + tab, "  View Schema INfo: ", (ViewSchemaInfo)schema );
	    break;
         case Constants.AR_SCHEMA_VENDOR :
            PrintVendorSchemaInfo( indent + tab, "  Vendor Schema INfo: ", (VendorSchemaInfo)schema );
            break;
         default             :
            PrintInt( indent + tab, "  undefined schemaType: ", schema.getType(), "\n");
            break;
      }
   }

    static void PrintCompoundSchemaInfoList(String indent, String header, CompoundSchemaInfo[] schema)
    {
      PrintHeader(indent, header, "\n");
      if (schema == null)
      {
         PrintHeader(indent + tab, "CompoundSchemaInfo is NULL....", "\n");
         return;
      }
      PrintInt( indent + tab, "Number of schemas: ", schema.length, "\n" );
      for( int i = 0; i < schema.length; i++ )
        {
           PrintCompoundSchemaInfo( indent + tab, "CompoundSchemaInfo( " + i + " ): ", schema[i] );
        }
     }
   static void PrintExtFieldCandidatesInfo(String indent, ExtFieldCandidatesInfo result)
   {
       if (result == null)
       {
          PrintHeader(indent + tab, " NULL result....", "\n");
          return;
       }
       PrintFieldMappingInfo( indent + tab, "FieldMapping:", result.getFieldMappingInfo() );
       PrintFieldLimitInfo( indent + tab, "Field Limit Info: ", result.getFieldLimitInfo());
       PrintDataType( tab, "DataType:", result.getDataType() );
   }

   static void PrintExtFieldCandidatesInfoList(String indent, String header, ExtFieldCandidatesInfo[] result)
   {
      PrintHeader(indent, header, "\n");
      if (result == null)
      {
         PrintHeader(indent + tab, " NULL result....", "\n");
         return;
      }
      PrintInt( indent + tab, "Number of Candidates: ", result.length, "\n" );
      for( int i = 0; i < result.length; i++ )
      {
         PrintExtFieldCandidatesInfo( indent + tab, result[i] );
      }
      PrintNewLine( );
    }

    static String ConvertToHexadecimalString( int number)
    throws IOException{
        if(   number < 0 )
        {
           throw new IOException( );
        }
        StringBuffer hexString = new StringBuffer();
        StringBuffer hexAlphas = new StringBuffer( "0123456789abcdef" );
        int modulus = 0;
        while( number > 15 )
        {
            modulus = number % 16;
            number = number / 16;
            hexString.append( hexAlphas.charAt( modulus ) );
        }
        hexString.insert( 0, hexAlphas.charAt( number ) );
        if( hexString.length() != 2 ) hexString.insert( 0, hexAlphas.charAt( 0 ) );
        return new String( hexString );
    }

   public static void PrintLicenseNameID( String indent, String header,  LicenseNameID value )
   {
      //   PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab,  " Null LicenseNameID ", "\n" );
         return;
      }

      PrintString( indent + tab, header, value.toString( ), "\n" );
   }

   public static void PrintLicenseNameIDList( String indent, String header,  LicenseNameID[] value )
   {
      // PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab,  " Null LicenseNameID list", "\n" );
         return;
      }


      PrintInt( indent + tab, "Number of values: ", value.length, "\n" );

      for( int i = 0; i < value.length; i++ )
      {
         PrintString( indent + tab, header, value[i].toString( ), "\n" );
      }
      PrintNewLine( );
   }

   public static void PrintLicenseKeyID( String indent, String header,  LicenseKeyID value )
   {
      // PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab,  " Null LicenseKeyID ", "\n" );
         return;
      }

      PrintString( indent + tab, header, value.toString( ), "\n" );
   }

   public static void PrintLicensKeyIDList( String indent, String header,  LicenseKeyID[] value )
   {
      //   PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab,  " Null LicenseKeyID list", "\n" );
         return;
      }


      PrintInt( indent + tab, header, value.length, "\n" );

      for( int i = 0; i < value.length; i++ )
      {
         PrintString( indent + tab, "License Key ID: ", value[i].toString( ), "\n" );
      }
      PrintNewLine( );
   }

   public static void PrintLicenseValidInfo( String indent, String header, LicenseValidInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, "Null LicenseValidInfo value...", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number Of Licenses: ", value.getNumLicenses(), "\n");
      PrintBoolean( indent + tab, "Is Demo: ", value.getIsDemo(), "\n");
      PrintInt( indent + tab, "Expire Date: month: ", value.getExpireDate().getMonth(), "\n");
      PrintInt( indent + tab, "               day: ", value.getExpireDate().getDay(), "\n");
      PrintInt( indent + tab, "              year: ", value.getExpireDate().getYear(), "\n");
      PrintString( indent + tab, "Token List: ", value.getTokenList( ), "\n" );

      PrintNewLine( );
   }

   public static void PrintLicenseValidList( String indent, String header, LicenseValidInfo[] value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab,  " Null LicenseValidInfo list", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of values: ", value.length, "\n" );

      for( int i = 0; i < value.length; i++ )
      {
         PrintLicenseValidInfo( indent + tab, "", value[i] );
      }

      PrintNewLine( );
   }

   public static void PrintLicenseInfo( String indent, String header, LicenseInfo value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab, "Null LicenseInfo value...", "\n" );
         return;
      }

      PrintLicenseNameID( indent, "License Type: ", value.getlicType( ));
      PrintLicenseKeyID ( indent, "License Key: ", value.getlicKey( ));
      PrintLicenseNameID( indent, "License Sub Type: ", value.getlicSubtype( ) );
      PrintInt( indent + tab, "Expire Date: month: ", value.getExpireDate().getMonth(), "\n");
      PrintInt( indent + tab, "               day: ", value.getExpireDate().getDay(), "\n");
      PrintInt( indent + tab, "              year: ", value.getExpireDate().getYear(), "\n");
      PrintInt( indent + tab, "Issued Date: month: ", value.getIssuedDate().getMonth(), "\n");
      PrintInt( indent + tab, "               day: ", value.getIssuedDate().getDay(), "\n");
      PrintInt( indent + tab, "              year: ", value.getIssuedDate().getYear(), "\n");
      PrintString( indent + tab, "Site Name: ", value.getSiteName( ), "\n" );
      PrintString( indent + tab, "Host ID: ", value.getHostId( ), "\n" );
      PrintInt( indent + tab, "Number Of Licenses: ", value.getNumLicenses(), "\n");
      PrintString( indent + tab, "Token List: ", value.getTokenList( ), "\n" );
      PrintString( indent + tab, "Comment: ", value.getComment( ), "\n" );
      PrintNewLine( );
   }

   public static void PrintLicenseInfoList( String indent, String header, LicenseInfo[] value )
   {
      PrintHeader( indent, header, "\n" );

      if( value == null )
      {
         PrintHeader( indent + tab,  " Null LicenseValidInfo list", "\n" );
         return;
      }

      PrintInt( indent + tab, "Number of values: ", value.length, "\n" );

      for( int i = 0; i < value.length; i++ )
      {
         PrintLicenseInfo( indent + tab, "", value[i] );
      }

      PrintNewLine( );
   }

   public static void PrintEntryPointInfoList( String indent, String header, EntryPointInfo[] entryPointInfoList)
   {
        PrintHeader( indent, header, "\n" );

        if( entryPointInfoList == null )
        {
            PrintHeader( indent + tab, "No entry points...", "\n" );
            return;
        }

        PrintInt( indent + tab, "Number of entry points: ", entryPointInfoList.length, "\n" );

        for( int i = 0; i < entryPointInfoList.length; i++ )
        {
            PrintEntryPoint( indent + tab, "Entry Point " + i + ":", entryPointInfoList[i] );
        }

        PrintNewLine( );
    }

    public static void PrintEntryPoint( String indent, String header, EntryPointInfo value )
    {
        PrintHeader( indent, header, "\n" );

        if( value == null )
        {
            PrintHeader( indent + tab, " Null Entry Point....", "\n" );
            return;
        }

        if( value.getName( ) != null )
        {
            PrintString( indent + tab, "Entry Point Name: ", value.getName( ).toString( ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "Entry Point Name: <null>\n"  );
        }

        PrintInt( indent + tab, "Entry Point Type: ", value.getType(), "\n" );
        if( value.getEntryPointDisplayLabel( ) != null )
        {
            PrintString( indent + tab, "Entry Point Display Label: ", new String( value.getEntryPointDisplayLabel( ) ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "Entry Point Display Label:<null> \n"  );
        }

        if( value.getOwnerAppName( ) != null )
        {
            PrintString( indent + tab, "Entry Point Owner Application Name: ", value.getOwnerAppName( ).toString( ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "Entry Point Owner Application Name: <null>\n"  );
        }

        if( value.getOwnerAppDisplayLabel( ) != null )
        {
            PrintString( indent + tab, "Entry Point Owner Application Display Label: ", new String( value.getOwnerAppDisplayLabel( ) ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "Entry Point Owner Application Display Label:<null>\n"  );
        }

        PrintPermissionInfoList( indent, "Permission List:", value.getPermissions( ), false );

        PrintContainerOwnerList( indent + tab, "Entry Point Owner: ", value.getOwnerObjList( ) );

        if( value.getDescription( ) != null )
        {
            PrintString( indent + tab, "Description: ", new String( value.getDescription( ) ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "Entry Point Description:<null>\n"  );
        }

        PrintReferenceBaseList( indent + tab, "Reference Base List: ", value.getReferences( ) );

        if( value.getHelpText( ) != null )
        {
            PrintString( indent + tab, "Help Text: ", value.getHelpText( ), "\n" );
        }
        else
        {
            PrintString( indent + tab + "HelpText: <null>\n"  );
        }

        PrintPropInfoList( indent + tab, "Properties List: ", value.getProps( ) );

        PrintNewLine( );
    }

    public static void PrintBulkEntryReturnList( String indent, String header, BulkEntryReturn[] returnList )
    {
        PrintHeader( indent, header, "\n" );

        if (returnList == null)
        {
            PrintHeader( indent + tab,  " Null BulkEntryReturn list", "\n" );
            return;
        }

        PrintInt( indent, "Number of calls: ", returnList.length, "\n" );

        for (int i = 0; i < returnList.length; i++)
        {
            StatusInfo[] statusList = returnList[i].getStatusList();

            PrintInt(indent, "Call type: ", returnList[i].getCallType(), "\n");
            switch( returnList[i].getCallType() )
            {
            case Constants.AR_BULK_ENTRY_CREATE    :
            case Constants.AR_BULK_ENTRY_MERGE     :
                PrintEntryReturn( indent + "   ", (EntryReturn) returnList[i] );
                PrintStatusInfoList( "      ", "Call Status", statusList );
                break;

            case Constants.AR_BULK_ENTRY_SET       :
            case Constants.AR_BULK_ENTRY_DELETE    :
            case Constants.AR_BULK_ENTRY_XMLDELETE :
                PrintStatusInfoList( "      ", "Call Status", statusList );
                break;

            case Constants.AR_BULK_ENTRY_XMLCREATE :
            case Constants.AR_BULK_ENTRY_XMLSET    :
                PrintXMLEntryReturn( indent + "   ", (XMLEntryReturn) returnList[i] );
                PrintStatusInfoList( "      ", "Call Status", statusList );

            default          :
                PrintString( indent + "<undefined call type> ");
                break;
            }
        }

        PrintNewLine( );
    }

    public static void PrintEntryReturn( String indent, EntryReturn value )
    {
       PrintString( indent + "Entry Id: " + value.getEntryId() );

       PrintNewLine( );
    }

    public static void PrintXMLEntryReturn( String indent, XMLEntryReturn value )
    {
       if (value.getOutputDoc() != null)
           PrintString( indent + "Output Doc: " + value.getOutputDoc() );
       else
           PrintString( indent + "Output Doc is null\n" );

       PrintNewLine( );
    }

}
