import java.io.*;
import java.math.*;
import java.util.*;
import com.remedy.arsys.api.*;
import java.math.BigDecimal;

class JavaDriver extends Thread{

   boolean executeCommand = true;
   Proxy pr = new Proxy( );

   static long    outputSetting;
   static long    quietMode = 0;
   static long    outputCount;
   static int     randomNumberSeed;
   private static long fileCount = 0;
   private static Date driverStartTime = null;
   static String  resultDirectory;
   boolean primaryThread;
   static String[] commandLineArgs = null;
   static ThreadControlLocalStorage localStorage = new ThreadControlLocalStorage( );
   static RandomNumberThread randomNumberGenerator = null;
   ThreadStartInfo threadStartInfoObject = null;

   static long    SUPPRESS_RESULTS = 0x0001;
   static long    SUPPRESS_HEADERS = 0x0002;
   static long    SUPPRESS_PROMPTS = 0x0004;
   static long    SUPPRESS_MENU    = 0x0008;
   static long    SUPPRESS_ERRORS  = 0x0010;
   static long    SUPPRESS_WARNINGS = 0x0020;
   static long    OUT_MODE_PERF_LOG =  0x0002;
   static long    OUT_MODE_PERF_LOG_MEM   = 0x0004;
   static long    OUT_MODE_ANY   =  0x0007;
   static long    MAX_NESTED_LOOP_DEPTH = 10;
   static int     RAND_MAX = 0x7fff;



   public static StatusInfo[] mergeStatusInfo(StatusInfo[] status1, StatusInfo[] status2)
   {
   	 int statusLen1 = 0;
   	 int statusLen2 = 0;

   	 if (status1 != null)
   	 	statusLen1 = status1.length;

   	 if (status2 != null)
   	 	statusLen2 = status2.length;

   	 StatusInfo[] combinedStatus = new StatusInfo[statusLen1 + statusLen2];
   	 if (status1 != null)
   	 {
	   	 for (int i = 0; i < status1.length; i++)
	   	 	combinedStatus[i] = status1[i];
   	 }

   	 if (status2 != null)
   	 {
	   	 for (int i = 0; i < status2.length; i++)
	   	 	combinedStatus[i + statusLen1 - 1] = status2[i];
   	 }

   	 return combinedStatus;
   }

   void  printAuxillaryStatus(  )
   {
        ThreadControlBlock threadControlBlockObj = JavaDriver.getThreadControlBlockPtr( );

        OutputWriter.DriverPrintResult( "Elapsed micro seconds: " + ( threadControlBlockObj.getAuxCount( ) * 1000 )+ "\n" );
   }

   public static synchronized long getAndIncrementTheFileCount( )
   {
       long count = fileCount;
       fileCount++;

       return count;
   }

   public static void initLogMethod( ThreadControlBlock threadControlBlockObj )
   throws IOException{
       if( ( JavaDriver.getOutputSetting( ) & JavaDriver.OUT_MODE_PERF_LOG_MEM )  != 0 )
       {
            threadControlBlockObj.setResultFile(  );
       }
       else
       {
            // increment the count for the number of files created so we
            // can have a unique number available for file name creation
               long fileCount = getAndIncrementTheFileCount( );
               String fileName = new String( "perf_" + fileCount );

            String fullFileName = fileName;
            if( getResultDirectory( ) != null )
            {
                fullFileName = getResultDirectory( ) + "\\" + fileName;
            }

            threadControlBlockObj.setResultFile( fullFileName );

            // write a comment into the file that allows this file to be
            // cross-referenced with its corresponding output file
               if(  threadControlBlockObj.getOutputFileName( ) != null  )
               {
                   threadControlBlockObj.writeInResultFile( "\n" + "Corresponding Output File: " + threadControlBlockObj.getOutputFileName( ) + "\n" );
               }
       }
   }

   public static boolean processCommentLine( String commentLine )
   throws IOException{
         ThreadControlBlock  threadControlBlockObj = JavaDriver.getThreadControlBlockPtr( );

         // determine if this comment is a special transaction begin/end
         // indicator in which case we need to echo it to the performance
         // log file

         if (commentLine.startsWith( "## transaction") )
        {
            // process if we are doing some form of performance logging
               if ( ( JavaDriver.getOutputSetting( )  & (JavaDriver.OUT_MODE_PERF_LOG | JavaDriver.OUT_MODE_PERF_LOG_MEM ) )  != 0  )
              {
                   // process if this is the first logging we've done for the current thread
                      if (  threadControlBlockObj.getResultFile( ) == null  )
                      {
                           initLogMethod( threadControlBlockObj );
                      }
                  threadControlBlockObj.writeInResultFile( commentLine );
             }
          //  indicate that we do not want this comment echoed in the
          //  result output file if there is one
             return  false;
      }

       return true;
   }


   public static void processResultFile( )
   throws IOException{
        if ( ( JavaDriver.getOutputSetting( )  & JavaDriver.OUT_MODE_PERF_LOG_MEM)  != 0 )
        {
            // get the control block pointer for the current thread
              ThreadControlBlock threadControlBlockObj = JavaDriver.getThreadControlBlockPtr( );

              Stack resultStack = threadControlBlockObj.getResultStack( );

           // return if there is no stack or the stack is empty
              if( ( resultStack == null ) ||  resultStack.empty( ) )
              {
                  return;
              }

           // Write the stack contents into file -

              // increment the count for the number of files created so we
              // can have a unique number available for file name creation
                 long fileCount = getAndIncrementTheFileCount( );
                 String fileName = new String( "perf_" + fileCount );

                 String fullFileName = fileName;
                 if( getResultDirectory( ) != null )
                 {
                    fullFileName = getResultDirectory( ) + "\\" + fileName;
                 }

                 threadControlBlockObj.setResultFile( fullFileName );

             // write a comment into the file that allows this file to be
             // cross-referenced with its corresponding output file
                PrintWriter fp = threadControlBlockObj.getResultFile( );
                if(  threadControlBlockObj.getOutputFileName( ) != null  )
                {
                    if( fp != null )
                    {
                        fp.println( );
                        fp.println( "Corresponding Output File: " + threadControlBlockObj.getOutputFileName( ) );
                        fp.flush( );
                    }
                }
             // write each of the log records we recorded in memory to the file
             // and then free the memory allocated for it
                String tmp = null;
                Stack newStack = new Stack( );
                while( !resultStack.empty( ) )
                {
                     tmp = (String) resultStack.pop( );
                     newStack.push( tmp );
                }
                while( !newStack.empty( ) )
                {
                     tmp = (String) newStack.pop( );
                     fp.println( tmp );
                }

             // Close the result file
                threadControlBlockObj.closeResultFile( );
                threadControlBlockObj.closeResultStack( );
        }
   }
   public void initCommandProcessing( )
   {
      JavaDriver.launchRandomNumberThread( );

      if( ( JavaDriver.getOutputSetting( ) & (OUT_MODE_PERF_LOG | OUT_MODE_PERF_LOG_MEM) ) != 0 )
      {
           // Set the start time
              driverStartTime = new Date( );

          // initialize the value that we use to generate suffixes for the
          // log file names because it may have been set with a command
          // line argument
             fileCount = JavaDriver.getOutputCount( );
      }
   }
   public void termCommandProcessing( )
   {
        // process if we have special output requirements
   }

   public void logPerfResults( ThreadControlBlock threadControlBlockObj, long errorCode, long startTime )
   throws IOException{
        // process if this is the first logging we've done for the
        // current thread
            if( !threadControlBlockObj.isResultFileOpened( ) )
            {
                initLogMethod( threadControlBlockObj );
            }

       // calculate the start time of the current operation which we are
       // representing as the elapsed time from the start of the test
          long startTimeMilliSec = startTime - driverStartTime.getTime( ) ;

      //  process depending if the intention is to log the results to memory
      //  or directly to a file

          String statString = getStatString( startTimeMilliSec, threadControlBlockObj.getCurrentCommand( ), errorCode, threadControlBlockObj.getAuxCount( ) );
          threadControlBlockObj.writeInResultFile( statString );
   }

   public String getStatString( long startTime, String command, long errorCode, long endTime )
   {
       String stTime = "" + startTime;
       int i = 0;
       for( i = stTime.length( ); i < 8; i++ )
       {
           stTime = "0" + stTime;
       }
       String statString = stTime + " " + command;;

       for( i = command.length( ); i < 6; i++ )
       {
           statString = statString + " ";
       }
       statString = statString + " ";

       String errString = "" + errorCode;
       for( i = errString.length( ); i < 10; i++ )
       {
           errString = " " + errString;
       }

       statString = statString + errString + " ";

       String endString = "" + endTime;
       for( i = endString.length( ); i < 10; i++ )
       {
           endString = " " + endString;
       }
       statString = statString + endString;

       return statString;
   }

   public void beginAPICall( )
   {
        if( ( JavaDriver.getOutputSetting( ) & JavaDriver.OUT_MODE_ANY ) != 0 )
       {
            ThreadControlBlock threadControlBlockObj = JavaDriver.getThreadControlBlockPtr( );
            Date currentTime = new Date( );
            threadControlBlockObj.setAuxCount( currentTime.getTime( ) );
       }
   }

   public void endAPICall( StatusInfo[] statusList )
   {
        try{
            if( ( JavaDriver.getOutputSetting( ) & JavaDriver.OUT_MODE_ANY ) != 0 )
            {
                // get the current time
                   Date endTime = new Date( );

               ThreadControlBlock threadControlBlockObj = JavaDriver.getThreadControlBlockPtr( );

               long startTime = threadControlBlockObj.getAuxCount( );

               // Set the time taken in the auxilary count
                  threadControlBlockObj.setAuxCount( endTime.getTime( ) - startTime );

               // process if we are to make a performance output file entry
                 if ( (JavaDriver.getOutputSetting( )  & (JavaDriver.OUT_MODE_PERF_LOG | JavaDriver.OUT_MODE_PERF_LOG_MEM) ) != 0 )
                 {
                     long errorCode = 0;
                     if ( (statusList != null) && (statusList.length != 0) )
                     {
                        if( statusList[0].getMessageType( ) == Constants.AR_RETURN_ERROR )
                        {
                             errorCode = statusList[0].getMessageNum( );
                        }
                     }
                     logPerfResults( threadControlBlockObj, errorCode, startTime );
                  }
              }
          }
          catch( Exception e )
          {
               System.out.println( "Problem in end API Call..." );
          }
   }

   public static void millisecondSleepTimer()
   throws IOException{

      OutputWriter.DriverPrintHeader("MILLISECOND SLEEP TIMER");
      long sleepMilliSeconds = InputReader.GetLong("Number of milliseconds (0): ", 0);

      JavaDriver.driverSleep( sleepMilliSeconds );

   }


   public static void randomSleepTimer( )
   throws IOException{
      long lowerBound =  InputReader.GetLong("Lower Bound (0): ", 0);
      long upperBound =  InputReader.GetLong("Upper Bound (0): ", 0);
      if (upperBound < lowerBound)
      {
         OutputWriter.DriverPrintError(" **** upper bound is less than lower bound\n");
         return;
      }
      JavaDriver.randomSleep( lowerBound, upperBound );
   }

   public static void sleepTimer( )
   throws IOException{
      long sleepSeconds =  InputReader.GetLong("Number of seconds (0): ", 0);
      OutputWriter.DriverPrintResult("\n   Sleeping for" + sleepSeconds +  " second(s) . . .\n" );
      JavaDriver.driverSleep( sleepSeconds * 1000 );
   }

   public static void driverSleep( long sleepTimeInMilliSeconds )
   {
      try{
         Thread.sleep( sleepTimeInMilliSeconds );
      }
      catch( InterruptedException e)
      {
      }
   }
   public static void releaseWaitingThreads( )
   {

       OutputWriter.DriverPrintHeader("RELEASE WAITING THREADS");

       ThreadControlBlock threadControlBlockObject = JavaDriver.getThreadControlBlockPtr();

       SyncObject releaseObject = threadControlBlockObject.getReleaseObject( );
       synchronized( releaseObject )
       {
          releaseObject.setFlag( true );
          releaseObject.notifyAll( );
       }
   }

   public static int getRandomNumber( )
   {
      if( randomNumberGenerator != null )
      {
         return randomNumberGenerator.getRandomNumber( );
      }

      return 0;
   }

   public void cleanupThreadEnvironment()
   {
      if( randomNumberGenerator != null )
      {
         randomNumberGenerator.interrupt( );
      }

      randomNumberGenerator.setWaitObjToNull( );
      randomNumberGenerator.setReplyObjToNull( );

      randomNumberGenerator = null;
   }

   public static void randomSleep( long lowerBound, long upperBound )
   {

      // Get a random number
         int randomValue = JavaDriver.getRandomNumber( );

         if( randomValue < 0 )
         {
             randomValue = randomValue * (-1);
         }

      // calculate the sleep seconds
         long sleepSeconds =  lowerBound + (randomValue * (upperBound - lowerBound) +
                                ((JavaDriver.RAND_MAX + 1) / 2)) / (JavaDriver.RAND_MAX + 1) ;


      try{
         OutputWriter.DriverPrintResult( "\n   Sleeping for " + sleepSeconds + "\n" );
         Thread.sleep( sleepSeconds * 1000 );
      }
      catch( InterruptedException e)
      {
      }

   }

   public void setThreadStartInfo( ThreadStartInfo infoObject )
   {
      threadStartInfoObject = infoObject;
   }
   public static ARServerUser getControlStructObject( )
   {
      ThreadControlBlock  threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();
      return threadControlBlockPtr.getContext( );
   }

   public static void launchRandomNumberThread( )
   {
      JavaDriver.randomNumberGenerator = new RandomNumberThread( JavaDriver.randomNumberSeed );
      randomNumberGenerator.start( );
   }

   public static void destroyThreadControlBlockPtr( )
   throws IOException{
      ThreadControlBlock  threadControlBlockObject = JavaDriver.getThreadControlBlockPtr();


      threadControlBlockObject.closeOutputFile( );

      threadControlBlockObject.closeInputFiles( );

      threadControlBlockObject.closeRecordFile( );

      // Wait for all the child threads to complete their execution
         Thread childThread = (Thread) threadControlBlockObject.getThreadHandle( );
         while(  childThread != null )
         {
            if( childThread.isAlive( ) )
            {
               try{
                  Thread.sleep( (long )30 ) ;
               }
               catch( InterruptedException e)
               {

               }
            }
            else
            {
               threadControlBlockObject.deleteThreadHandle( );
               childThread = (Thread) threadControlBlockObject.getThreadHandle( );
            }
         }
      // clean up the event objects
         threadControlBlockObject.setWaitObjectToNull( );
         threadControlBlockObject.setReleaseObjectToNull( );

      processResultFile( );
   }

   public static ThreadControlBlock getThreadControlBlockPtr( )
   {
      return (ThreadControlBlock)localStorage.get( );
   }

   public void setPrimaryThread( boolean primary )
   {
      primaryThread = primary;
   }
   public boolean isPrimaryThread( )
   {
      return primaryThread;
   }
   public static void setCommandLineArgs( String[] args )
   {
      commandLineArgs = args;
   }
   public static String[] getCommandLineArgs( )
   {
      return commandLineArgs;
   }
   public static void setOutputSetting( long value )
   {
      outputSetting = value;
   }

   public static long getOutputSetting( )
   {
      return outputSetting;
   }

   public static void setResultDirectory( String directory )
   {
      resultDirectory = directory;
   }

   public static String getResultDirectory( )
   {
      return resultDirectory;
   }

   public static void setQuietMode( long value )
   {
      quietMode = value;
   }
   public static long getQuietMode( )
   {
      return quietMode;
   }


   public static void setRandomNumberSeed( int value )
   {
      randomNumberSeed = value;
   }
   public static int getRandomNumberSeed( )
   {
      return randomNumberSeed;
   }

   public static void setOutputCount( long value )
   {
      outputCount = value;
   }
   public static long getOutputCount( )
   {
      return outputCount;
   }

   int GetNextCommand( String args )
   throws IOException{
      ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();
      threadControlBlockPtr.args = null;
      args = null;

      OutputWriter.DriverPrintPrompt("\nCommand: ");

      int commandCode = -99;
      while (commandCode == -99)
      {                               /* read and validate the command */
         InputReader.GetInputLine();
         String command = null;

         // Search for blank and if present copy the arguments
            boolean argumentsPresent = false;
            String buffer = threadControlBlockPtr.getBuffer();
            command = new String( buffer );
            for( int i = 0; i < buffer.length(); i++ )
            {
              if( buffer.charAt( i ) == ' ' )
              {
                 char[] tempArgs = new char[buffer.length( ) - i - 1];
                 buffer.getChars( i+1, buffer.length( ) , tempArgs, 0 );
                 threadControlBlockPtr.setArgs( new String( tempArgs ) );
                 args = new String( tempArgs );

                 char[] tempCmd = new char[i];
                 buffer.getChars( 0, i, tempCmd, 0 );
                 command = new String( tempCmd );
                 break;
              }
           }

          if( ( command.length( ) == 0 ) || (command.charAt(0) == '#' ) )
          {
              // blank line or comment
                 OutputWriter.DriverPrintPrompt( "\nCommand: " ); // blank line or comment
          }
          else if( command.length( ) > 5 )
          {
             OutputWriter.DriverPrintError( " ***Command too long, unrecognized ****\n" );
             OutputWriter.DriverPrintPrompt( "\nCommand: " );
          }
          else if( command.equals( "h" ) || command.equals( "?" ) )
          {
             OutputWriter.PrintHelp( );
             OutputWriter.DriverPrintPrompt( "\nCommand: " );
          }
          else if( command.equals( "e" ) || command.equals( "q" ) || command.equals( "x" ) )
          {
             commandCode = Commands.COMMAND_EXIT;
          }
          else
          {
             commandCode = Commands.getCommandCode( command );
             if (commandCode != Commands.UNKNOWN_COMMAND)
             {
                threadControlBlockPtr.setCurrentCommand( command );
             }
             else
             {
                OutputWriter.DriverPrintError(" *** Command not recognized ***\n");
                OutputWriter.DriverPrintPrompt("\nCommand: ");
             }
          }

        }

      return commandCode;
   }


   public void processCommands( )
   throws IOException{
      int  commandCode = Commands.COMMAND_EXIT;        /* code for the command requested */
      String args = null;              /* pointer to arguments */

      // process commands until exit specified

      while ((commandCode = GetNextCommand(args)) != Commands.COMMAND_EXIT)
      {
         switch (commandCode)
         {
            case Commands.COMMAND_LOGIN             :
               getARServerUser();
               break;
            case Commands.COMMAND_GET_ENTRY         :
               getEntry();
               break;
            case Commands.COMMAND_SET_ENTRY         :
               setEntry();
               break;
            case Commands.COMMAND_CREATE_ENTRY      :
               createEntry();
               break;
            case Commands.COMMAND_DELETE_ENTRY      :
               deleteEntry();
               break;
            case Commands.COMMAND_GETLIST_ENTRY     :
               getListEntry();
               break;
	    case Commands.COMMAND_COMPACT_GETLIST_ENTRY     :
	       compactGetListEntry();
	       break;
            case Commands.COMMAND_GETLIST_ENTRY_WITH_FIELDS     :
               getListEntryWithFields();
               break;
            case Commands.COMMAND_GETLIST_ENTRY_BLOCKS:
               getListEntryBlocks();
               break;
            case Commands.COMMAND_GET_FILTER        :
               getFilter();
               break;
            case Commands.COMMAND_SET_FILTER        :
               setFilter();
               break;
            case Commands.COMMAND_CREATE_FILTER     :
               createFilter();
               break;
            case Commands.COMMAND_DELETE_FILTER     :
               deleteFilter();
               break;
            case Commands.COMMAND_GETLIST_FILTER    :
               getListFilter();
               break;
            case Commands.COMMAND_GET_ESCALATION        :
               getEscalation();
               break;
            case Commands.COMMAND_SET_ESCALATION        :
               setEscalation();
               break;
            case Commands.COMMAND_CREATE_ESCALATION     :
               createEscalation();
               break;
            case Commands.COMMAND_DELETE_ESCALATION     :
               deleteEscalation();
               break;
            case Commands.COMMAND_GETLIST_ESCALATION    :
               getListEscalation();
               break;
            case Commands.COMMAND_GETLIST_GROUP     :
               getListGroup();
               break;
            case Commands.COMMAND_GET_SCHEMA        :
               getSchema();
               break;
            case Commands.COMMAND_SET_SCHEMA        :
               setSchema();
               break;
            case Commands.COMMAND_CREATE_SCHEMA     :
               createSchema();
               break;
            case Commands.COMMAND_DELETE_SCHEMA     :
               deleteSchema();
               break;
            case Commands.COMMAND_GETLIST_SCHEMA    :
               getListSchema();
               break;
            case Commands.COMMAND_GETMULT_SCHEMA    :
 //              getMultipleSchemas();
               break;
            case Commands.COMMAND_GET_SCH_FIELD     :
               getField();
               break;
            case Commands.COMMAND_SET_SCH_FIELD     :
               setField();
               break;
            case Commands.COMMAND_CREATE_SCH_FIELD  :
               createField();
               break;
            case Commands.COMMAND_DELETE_SCH_FIELD  :
               deleteField();
               break;
            case Commands.COMMAND_GETLIST_SCH_FIELD :
               getListField();
               break;
            case Commands.COMMAND_GET_CHAR_MENU     :
               getCharMenu();
               break;
            case Commands.COMMAND_SET_CHAR_MENU     :
               setCharMenu();
               break;
            case Commands.COMMAND_CREATE_CHAR_MENU  :
               createCharMenu();
               break;
            case Commands.COMMAND_DELETE_CHAR_MENU  :
               deleteCharMenu();
               break;
            case Commands.COMMAND_GETLIST_CHAR_MENU :
               getListCharMenu();
               break;
            case Commands.COMMAND_GET_VUI           :
               getVUI();
               break;
            case Commands.COMMAND_SET_VUI           :
               setVUI();
               break;
            case Commands.COMMAND_CREATE_VUI        :
               createVUI();
               break;
            case Commands.COMMAND_DELETE_VUI        :
               deleteVUI();
               break;
            case Commands.COMMAND_GETLIST_VUI       :
               getListVUI();
               break;
            case Commands.COMMAND_EXPORT            :
               export();
               break;
            case Commands.COMMAND_IMPORT            :
               arImport();
               break;
            case Commands.COMMAND_GET_SERVER_INFO   :
               getServerInfo();
               break;
            case Commands.COMMAND_VERIFY_USER       :
               verifyUser();
               break;
            case Commands.COMMAND_EXECUTE           :
               openInputFile(args);
               break;
            case Commands.COMMAND_OPEN_OUT          :
               openOutputFile();
               break;
            case Commands.COMMAND_CLOSE_OUT         :
               closeOutputFile();
               break;
            case Commands.COMMAND_RECORD            :
               startRecording();
               break;
            case Commands.COMMAND_STOP_RECORD       :
               stopRecording();
               break;
            case Commands.COMMAND_LAUNCH_THREAD :
               launchThread(false);
               break;
            case Commands.COMMAND_LAUNCH_WAITING_THREAD :
               launchThread(true);
               break;
            case Commands.COMMAND_RELEASE_WAITING_THREADS :
               releaseWaitingThreads();
               break;
            case Commands.COMMAND_SLEEP_TIMER       :
               sleepTimer();
               break;
            case Commands.COMMAND_RANDOM_SLEEP_TIMER:
               randomSleepTimer();
               break;
            case Commands.COMMAND_MILLISECOND_SLEEP_TIMER:
               millisecondSleepTimer();
               break;
            case Commands.COMMAND_BEGIN_LOOP:
               beginLoop();
               break;
            case Commands.COMMAND_END_LOOP:
               endLoop();
               break;
            case Commands.COMMAND_GETLIST_SERVER    :
               getListServer();
               break;
            case Commands.COMMAND_INITIALIZATION    :
   //           initialization();
               break;
            case Commands.COMMAND_TERMINATION       :
    //           termination();
               break;
            case Commands.COMMAND_GET_ACTIVE_LINK   :
               getActiveLink();
               break;
            case Commands.COMMAND_SET_ACTIVE_LINK   :
               setActiveLink();
               break;
            case Commands.COMMAND_CREATE_ACTIVE_LINK:
               createActiveLink();
               break;
            case Commands.COMMAND_DELETE_ACTIVE_LINK:
               deleteActiveLink();
               break;
            case Commands.COMMAND_GETLIST_ACTIVE_LINK:
               getListActiveLink();
               break;
            case Commands.COMMAND_GET_MULTIPLE_ACTIVE_LINKS:
    //           getMultipleActiveLinks();
               break;
            case Commands.COMMAND_MERGE_ENTRY       :
               mergeEntry();
               break;
            case Commands.COMMAND_LOAD_AR_QUAL_STRUCT:
               getQualifier();
               break;
            case Commands.COMMAND_EXPAND_CHAR_MENU   :
               expandCharMenu();
               break;
            case Commands.COMMAND_SET_SERVER_INFO    :
               setServerInfo();
               break;
            case Commands.COMMAND_GETLIST_USER      :
               getListUser();
               break;
            case Commands.COMMAND_ENTRY_STATISTICS  :
               getEntryStatistics();
               break;
            case Commands.COMMAND_SETFULLTEXT_INFO   :
               setFullTextInfo ();
               break;
            case Commands.COMMAND_GETFULLTEXT_INFO   :
               getFullTextInfo ();
               break;
            case Commands.COMMAND_GET_SERVER_STAT   :
               getServerStatistics();
               break;
            case Commands.COMMAND_GETLIST_SQL       :
               getListSQL();
               break;
            case Commands.COMMAND_DELETE_MULTI_FIELD:
               deleteMultipleFields();
               break;
            case Commands.COMMAND_EXECUTE_PROCESS   :
               executeProcess();
               break;
            case Commands.COMMAND_SET_SERVER_PORT   :
               setServerPort();
               break;
            case Commands.COMMAND_GET_MULTIPLE_ENTRY :
               getMultipleEntries();
               break;
            case Commands.COMMAND_GET_SUPPORT_FILE :
               getSupportFile();
               break;
            case Commands.COMMAND_SET_SUPPORT_FILE :
               setSupportFile();
               break;
            case Commands.COMMAND_CREATE_SUPPORT_FILE :
               createSupportFile();
               break;
            case Commands.COMMAND_DELETE_SUPPORT_FILE :
               deleteSupportFile();
               break;
            case Commands.COMMAND_GETLIST_SUPPORT_FILE :
               getListSupportFile();
               break;
            case Commands.COMMAND_GETENTRY_BLOB :
               getEntryBLOB();
               break;
            case Commands.COMMAND_GET_CONTAINER :
               getContainer();
               break;
            case Commands.COMMAND_SET_CONTAINER :
               setContainer();
               break;
            case Commands.COMMAND_CREATE_CONTAINER :
               createContainer();
               break;
            case Commands.COMMAND_DELETE_CONTAINER :
               deleteContainer();
               break;
            case Commands.COMMAND_GETLIST_CONTAINER :
               getListContainer();
               break;
            case Commands.COMMAND_GET_MULTIPLE_CONTAINER :
               getMultipleContainers();
               break;
            case Commands.COMMAND_GET_ERROR_MESSAGE :
               getTextForErrorMessage();
               break;
            case Commands.COMMAND_SET_LOGGING:
   //            setLogging();
               break;
            case Commands.COMMAND_CLOSE_NET_CONNECTIONS:
    //           closeNetworkConnections();
               break;
            case Commands.COMMAND_SIGNAL:
    //           signal();
               break;
            case Commands.COMMAND_VALIDATE_FORM_CACHE:
    //           validateFormCache();
               break;
            case Commands.COMMAND_GET_MULTIPLE_FIELDS:
               getMultipleFields();
               break;
            case Commands.COMMAND_GET_LOCALIZED_VALUE:
                 getLocalizedValue();
                 break;
            case Commands.COMMAND_GET_MULT_LOCALIZED_VALUES:
                 getMultipleLocalizedValues();
                 break;
            case Commands.COMMAND_GETLIST_SCHEMA_WITH_ALIAS:
                 getListSchemaWithAlias();
                 break;
            case Commands.COMMAND_CREATE_ALERT_EVENT:
                 createAlertEvent();
                 break;
            case Commands.COMMAND_REGISTER_ALERTS:
                 registerForAlerts();
                 break;
            case Commands.COMMAND_DEREGISTER_ALERTS:
                 deregisterForAlerts();
                 break;
            case Commands.COMMAND_GETLIST_ALERT_USER:
                 getListAlertUser();
	         break;
            case Commands.COMMAND_GET_ALERT_COUNT:
                 getAlertCount();
                 break;
            case Commands.COMMAND_DECODE_ALERT_MESSAGE:
                 decodeAlertMessage();
	         break;
            case Commands.COMMAND_ENCODE_QUALIFIER:
                 encodeARQualifierStruct();
	         break;
            case Commands.COMMAND_DECODE_QUALIFIER:
                 decodeARQualifierStruct();
                 break;
            case Commands.COMMAND_ENCODE_ASSIGN:
                 encodeARAssignStruct();
                 break;
            case Commands.COMMAND_DECODE_ASSIGN:
                 decodeARAssignStruct();
	         break;
            case Commands.COMMAND_ENCODE_HISTORY:
                 encodeStatusHistory();
                 break;
            case Commands.COMMAND_ENCODE_DIARY:
                 encodeDiary();
                 break;
            case Commands.COMMAND_GETLIST_EXT_SCHEMA_CANDS :
        //       getListExtSchemaCandidates();
               break;
            case Commands.COMMAND_GET_MULT_EXT_FIELD_CANDS :
        //       getMultipleExtFieldCandidates();
               break;
	    case Commands.COMMAND_EXPAND_SS_MENU:
	//       expandSSMenu();
	       break;
	    case Commands.COMMAND_VALIDATE_LICENSE:
	       validateLicense();
	       break;
	    case Commands.COMMAND_VALIDATE_MULTIPLE_LICENSES:
	       validateMultipleLicenses();
	       break;
	    case Commands.COMMAND_GETLIST_LICENSE:
	       getListLicense();
	       break;
	    case Commands.COMMAND_CREATE_LICENSE:
	//       createLicense();
	       break;
	    case Commands.COMMAND_DELETE_LICENSE:
	//       deleteLicense();
	       break;
            case Commands.COMMAND_GETLIST_SQL_FOR_AL:
               getListSQLForActiveLink();
               break;
            case Commands.COMMAND_EXECUTE_PROCESS_FOR_AL:
               executeProcessForActiveLink();
               break;
            case Commands.COMMAND_DRIVER_VERSION:
   //          printDriverVersion();
               break;
            case Commands.COMMAND_GET_SESSION_CONFIGURATION:
               getSessionConfiguration();
               break;
            case Commands.COMMAND_SET_SESSION_CONFIGURATION:
               setSessionConfiguration();
               break;
            case Commands.COMMAND_ENCODE_DATE:
             //  dateToJulianDate();
               break;
            case Commands.COMMAND_DECODE_DATE:
              // julianDateToDate();
               break;
   	    case Commands.COMMAND_XML_CREATE_ENTRY:
	       xmlCreateEntry();
	       break;
   	    case Commands.COMMAND_XML_GET_ENTRY:
	       xmlGetEntry();
	       break;
	    case Commands.COMMAND_XML_SET_ENTRY:
	       xmlSetEntry();
	       break;
            case Commands.COMMAND_GET_MULT_CURR_RATIO_SETS:
               getMultipleCurrencyRatioSets();
               break;
            case Commands.COMMAND_GET_CURRENCY_RATIO:
               getCurrencyRatio();
               break;
            case Commands.COMMAND_GET_CLIENT_TYPE:
   //          getClientType();
               break;
	    case Commands.COMMAND_SET_CLIENT_TYPE:
   //          setClientType();
               break;
            case Commands.COMMAND_GET_MULTIPLE_ENTRYPOINTS:
               getMultipleEntryPoints();
               break;
            case Commands.COMMAND_GET_LIST_ROLE:
               getListRole();
               break;
            case Commands.COMMAND_BEGIN_BULK_ENTRY_TRANS:
               beginBulkEntryTransaction();
               break;
            case Commands.COMMAND_END_BULK_ENTRY_TRANS:
               endBulkEntryTransaction();
               break;
            case Commands.COMMAND_DUMP_PROXY_INFO:
               dumpProxyInfo();
               break;
            case Commands.COMMAND_USE_CONNECTION_POOLING:
               setUseConnectionPooling();
               break;
            default                        :
               OutputWriter.DriverPrintError(" **** No support for this command in driver \n" );
            break;
         }
      }
   }

   boolean processCommandLine( )
   {
      int    maxArgumentLen = 0;
      char   option;
      String tempPtr = null;
      String cp;

      ThreadControlBlock threadControlBlockPtr = (ThreadControlBlock)JavaDriver.getThreadControlBlockPtr();
      String[] argv = JavaDriver.getCommandLineArgs( );

      int argc = 0;
      if( argv != null )
      {
         argc = argv.length;
      }
      for (int i = 0; i < argc; i++)
      {                              /* process each entry on the command line */
         if ((argv[i].charAt(0) == '-') &&
            (argv[i].charAt(1) == 'u' || argv[i].charAt(1) == 'p' || argv[i].charAt(1) == 'l' ||
             argv[i].charAt(1) == 's' || argv[i].charAt(1) == 'x' || argv[i].charAt(1) == 'o' ||
             argv[i].charAt(1) == 'd' || argv[i].charAt(1) == 'q' || argv[i].charAt(1) == 'g' ||
             argv[i].charAt(1) == 'c' || argv[i].charAt(1) == 'a'))
         {

            option = argv[i].charAt(1);
         }
         else
         {                           /* unrecognized option */
            OutputWriter.DriverPrintError("Unrecognized option " + argv[i] + "\n" );
            return false;
         }
                                  /* have option, load the value */
         if (argv[i].length() > 2)
         {
            int cmdLength = argv[i].length() - 2;
            char[] tempCmd = new char[cmdLength];
            argv[i].getChars( 2, argv[i].length( ), tempCmd, 0 );
            tempPtr = new String( tempCmd );
         }
         else
         {                           /* check next argument for name */
            i++;
            if (i < argc)
            {
               tempPtr = new String( argv[i] );
            }
            else
            {                        /* no next argument so error */
               OutputWriter.DriverPrintError("Missing value for -" + option + "  option\n");
               return false;
            }
         }
                                  /* get max argument length */
         switch (option)
         {
            case 'a' :
            case 'u' :
            case 'p' :
            case 'l' :
            case 's' :
               maxArgumentLen = 254;
               break;
            case 'x' :
            case 'd' :
               maxArgumentLen = 255;
               break;
            case 'o' :
            case 'q' :
               maxArgumentLen = 3;
               break;
            case 'g' :
               maxArgumentLen = 10;
               break;
            case 'c' :
               maxArgumentLen = 5;
               break;
          }

          if (tempPtr.length( ) > maxArgumentLen)
          {                           /* argument too long so error */
             OutputWriter.DriverPrintError("Value for -" + option + "  option is too long: " + tempPtr + "\n" );
             return false;
          }

                            /* take appropriate action */
          char[] tempCmd = null;
          switch (option)
          {
             case 'u' :
                boolean authStringFound = false;

                int j = 0;
                for( j = 0; j < tempPtr.length( ); j++ )
                {
                   if( tempPtr.charAt(j) == '\\' )
                   {
                      tempCmd = new char[j];
                      tempPtr.getChars( 0, j, tempCmd, 0 );
                      threadControlBlockPtr.setAuthentication( new String( tempCmd ) );
                      authStringFound = true;
                      break;
                   }
                }
                if( authStringFound )
                {
                   int cmdLength = tempPtr.length( ) - j - 1;
                   tempCmd = new char[cmdLength];
                   tempPtr.getChars( j+1, tempPtr.length(), tempCmd, 0 );
                   threadControlBlockPtr.setUser( new String( tempCmd ) );
                }
                else
                {
                   threadControlBlockPtr.setUser( tempPtr );
                }
                break;

             case 'a' :
                threadControlBlockPtr.setAuthentication( tempPtr );
                break;

             case 'p' :
                threadControlBlockPtr.setPassword( tempPtr );
                break;

             case 'l' :
                threadControlBlockPtr.setLocale( tempPtr );
                break;

             case 's' :
                threadControlBlockPtr.setServer( tempPtr );
                break;

             case 'x' :
                openInputFile(tempPtr);
                break;

             case 'o' :
                Long longValue = new Long( tempPtr );
                JavaDriver.setOutputSetting( longValue.longValue( ) );
                break;

             case 'd' :
                JavaDriver.setResultDirectory( tempPtr );
                break;

             case 'q' :
                Long quietMode = new Long( tempPtr );
                JavaDriver.setQuietMode( quietMode.longValue( ) );
                break;

             case 'g' :
                Integer randomNumberSeed = new Integer( tempPtr );
                JavaDriver.setRandomNumberSeed( randomNumberSeed.intValue( ) );
                break;

             case 'c' :
                Long outputCount = new Long( tempPtr );
                JavaDriver.setOutputCount( outputCount.longValue( ) ) ;
                break;
          }
      }
      return true;
   }

   void getARServerUser()
   {
      try{

         InputReader.GetARServerUser(  );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch (IllegalArgumentException e )
      {
		 OutputWriter.PrintString( "Bad User or Password...\n");
	  }
   }

   void openInputFile( String fileName )
   {

      try{
         InputReader.openInputFile( fileName );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
   }

   void closeOutputFile( )
   {
       OutputWriter.closeOutputFile( );
   }

   void openOutputFile( )
   {
      try{
         String fileName = InputReader.GetString("Filename of output file (): ", "");
         OutputWriter.openOutputFile( fileName );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
   }

   void startRecording( )
   {
      String fileName = null;
      try{
         ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();

         if( threadControlBlockPtr.getRecordFile( ) != null )
         {
            OutputWriter.DriverPrintWarning( " **** Recording already active; stop previous to start new\n");
         }
         else
         {
            // get a filename and open for recording
            fileName = InputReader.GetString( "Filename of record file (): ", "" );
            if( ( fileName == null ) || ( fileName.length( ) == 0 ) )
            {
               OutputWriter.DriverPrintError(" **** No filename specified so no recording started\n");
            }
            else
            {                          /* open the new file for write */
                threadControlBlockPtr.setRecordFile( new PrintWriter( new FileOutputStream( new File( fileName ) ) ) );
            }
         }
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...or opening the file " + fileName  + "  .\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
   }

   void stopRecording( )
   {
      try{
         ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();

         if( threadControlBlockPtr.getRecordFile() == null )
         {
             OutputWriter.DriverPrintWarning(" **** Recording is not active\n");
         }
         else
         {
             threadControlBlockPtr.setRecordFile( null );
         }
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
   }

   void beginLoop( ){

      try
      {
         OutputWriter.DriverPrintHeader( "BEGIN LOOP" );
         ThreadControlBlock threadControlBlockObject = JavaDriver.getThreadControlBlockPtr();
         if( threadControlBlockObject.isCurrentInputSourceStdInput( ) )
         {
            // print error and return
               OutputWriter.DriverPrintError("\n*** Command must be issued from input file\n");
               return;
         }

         long numIterations = InputReader.GetLong( "Number of iterations (1): ", 1 );
         if( numIterations <= 0 )
         {
             numIterations = 1;
         }

         if( threadControlBlockObject.getCurrentLoopDepth( ) == ( JavaDriver.MAX_NESTED_LOOP_DEPTH - 1) )
         {
            // print error and return
               OutputWriter.DriverPrintError("\n*** Maximum nested loop depth exceeded\n");
               threadControlBlockObject.incrementNumFailedBeginLoop();

            return;
         }
         threadControlBlockObject.incrementCurrentLoopDepth( );

         threadControlBlockObject.setNumberOfIterations( threadControlBlockObject.getCurrentLoopDepth( ), numIterations );

         threadControlBlockObject.setLoopBeginFilePos( threadControlBlockObject.getCurrentLoopDepth( ), threadControlBlockObject.getCurrentInputFilePos( ) );

      }

      catch( IOException e )
      {
          OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
          OutputWriter.PrintString( "Null Pointer exception...\n" );
      }

   }

   void endLoop( )
   throws IOException, FileNotFoundException{

      try
      {
         OutputWriter.DriverPrintHeader( "END LOOP" );

         ThreadControlBlock threadControlBlockObject = JavaDriver.getThreadControlBlockPtr();

         if( threadControlBlockObject.isCurrentInputSourceStdInput( ) )
         {
            // print error and return
               OutputWriter.DriverPrintError("\n*** Command must be issued from input file\n");
               return;
         }

         if( threadControlBlockObject.getCurrentLoopDepth( ) < 0 )
         {
            // print warning and return
               OutputWriter.DriverPrintWarning("\n*** Command ignored because no corresponding begin loop issued\n");
               return;
         }

         if( threadControlBlockObject.getNumFailedBeginLoop( ) > 0 )
         {
            // print warning and return
               OutputWriter.DriverPrintWarning("\n*** Command ignored because previous begin loop failed\n");
               threadControlBlockObject.reduceNumFailedBeginLoop( );
               return;
         }

         long numIterations = threadControlBlockObject.getNumberOfIterations( threadControlBlockObject.getCurrentLoopDepth( ) );
         threadControlBlockObject.reduceNumberOfIterations( threadControlBlockObject.getCurrentLoopDepth( ) );

         if( ( numIterations - 1 ) > 0)
         {
            int loopDepth = threadControlBlockObject.getCurrentLoopDepth( );
            long filePosition = threadControlBlockObject.getLoopBeginFilePos( loopDepth );
            threadControlBlockObject.setCurrentInputFileReadingPostion( filePosition );
         }
         else
         {
            threadControlBlockObject.reduceCurrentLoopDepth( );
         }

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
          OutputWriter.PrintString( "Null Pointer exception...\n" );
      }

   }


   void createSchema( )
   {
      try{

         NameID name = null;
         SchemaKey key = new SchemaKey( name );

         SchemaFactory schemaMan = SchemaFactory.getFactory( );
         Schema schema = (Schema)schemaMan.newInstance( );
         schema.setContext( getControlStructObject() );

         OutputWriter.DriverPrintHeader( "CREATE SCHEMA" );

         NameID schemaName = InputReader.GetNameID( "Schema Name" );

         schema.setName( schemaName );

        CompoundSchemaInfo cmpInfo = InputReader.GetCompoundSchemaInfo( );

        if( cmpInfo != null )
        {
            schema.setSchemaType(  cmpInfo.getType( ), cmpInfo );
        }

         PermissionInfo[] permissions = InputReader.GetPermissionInfoList( false );

         schema.setPermissions(permissions);

         OutputWriter.DriverPrintHeader("Ids of sub admin groups allowed to access schema:");
         InternalID[] id = InputReader.GetInternalIDList( );
         schema.setAdminGrpList(id);

         EntryListFieldInfo[] fldInfos = InputReader.GetEntryListFieldInfoList( );
         schema.setEntryListFieldInfo( fldInfos );

         SortInfo[] sortarr = InputReader.GetSortInfoList( );
         schema.setSortInfo( sortarr );

         IndexInfo[] index = InputReader.GetIndexInfoList( );
         schema.setIndexInfo( index );

         if( InputReader.GetBooleanForChangingInfo( "Change archive info? (F): ", false ) )
         {
               ArchiveInfo archive = InputReader.GetArchiveInfo( );
               schema.setArchiveInfo( archive );
         }

         NameID vuiName = InputReader.GetNameID("   Default VUI  " );
         schema.setDefaultVUI( vuiName );

         String helpText = InputReader.GetString( "Help Text:", "" );
         schema.setHelpText( helpText );

         AccessNameID ownerID =  InputReader.GetAccessNameID( "Owner" );
         schema.setOwner( ownerID );

         String diary = InputReader.GetString( "Change Diary:", "" );
         schema.setDiary( diary );


         PropInfo[] propList = InputReader.GetPropInfoList( );
         schema.setProperties( propList );


         beginAPICall( );
         schema.create();
         endAPICall( getControlStructObject().getLastStatus( ) );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Create Schema Status", statusList );


         schemaMan.releaseInstance(schema);

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
           endAPICall( getControlStructObject().getLastStatus( ) );
          OutputWriter.PrintARException( e );
      }
   }



   void deleteSchema( ){

      try{

         OutputWriter.DriverPrintHeader( "DELETE SCHEMA" );

         SchemaFactory schemaMan = SchemaFactory.getFactory();
         Schema schema = (Schema)schemaMan.newInstance();
         schema.setContext(JavaDriver.getControlStructObject( ));

         NameID schemaName = InputReader.GetNameID( "Schema Name" );

         schema.setName( schemaName );

         int deleteOption = InputReader.GetInt( "Delete option ? ( 0, 1, 2 ) ( 0 ):", 0 );
         schema.setDeleteOption( deleteOption );

         beginAPICall( );
         schema.remove( );
         endAPICall( getControlStructObject().getLastStatus( ) );

         // Success. Print the status
            StatusInfo[] statusList = JavaDriver.getControlStructObject( ).getLastStatus( );
            OutputWriter.PrintStatusInfoList( "", "Delete Schema Status", statusList );

         schemaMan.releaseInstance(schema);
      }

      catch( IOException e )
      {
          OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
          OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
           endAPICall( getControlStructObject().getLastStatus( ) );
          OutputWriter.PrintARException( e );
      }
   }


   void getSchema( ){
      try{

         SchemaFactory schemaMan = SchemaFactory.getFactory();


         SchemaKey key = InputReader.GetSchemaKey( );

         SchemaCriteria crit = new SchemaCriteria();
         crit.setRetrieveAll(true);

         beginAPICall( );
         Schema schema = (Schema)schemaMan.findByKey(JavaDriver.getControlStructObject( ), key, crit);
         endAPICall( getControlStructObject().getLastStatus( ) );

         OutputWriter.PrintSchema( "",  "Schema Information...", schema );

         // Success. Print the status
            StatusInfo[] statusList = getControlStructObject().getLastStatus( );
            OutputWriter.PrintStatusInfoList( "", "Get Schema Status", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
           endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void getListSchema( ){
      try{

         SchemaListCriteria criteria = InputReader.GetSchemaListCriteria( );

         SchemaFactory schemaMan = SchemaFactory.getFactory();

         beginAPICall( );
         NameID[] schemaList = schemaMan.find( getControlStructObject(), criteria);
         endAPICall( getControlStructObject().getLastStatus( ) );

         OutputWriter.PrintNameIDList( "", "Schama name List: ", schemaList );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "GetListSchema Status", statusList );
      }

      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
           endAPICall( getControlStructObject().getLastStatus( ) );
          OutputWriter.PrintARException( e );
      }
   }

   void setSchema( ){

      try{

         SchemaFactory schemaMan = SchemaFactory.getFactory();

         Schema schema = (Schema)schemaMan.newInstance();
         schema.setContext(getControlStructObject());


         NameID name = InputReader.GetNameID( "Schema Name" );
         schema.setName( name );


         if( InputReader.GetBooleanForChangingInfo("Change schema name? (F): ", false ) )
         {
               NameID newName = InputReader.GetNameID( "Schema name" );
               schema.setNewName( newName );
         }

         if( InputReader.GetBooleanForChangingInfo( "Change compound schema info? (F): ", false ) )
         {
               CompoundSchemaInfo cmpSchInfo = InputReader.GetCompoundSchemaInfo( );
               if( cmpSchInfo != null )
               {
                   schema.setSchemaType( cmpSchInfo.getType(), cmpSchInfo );
               }
         }

         if( InputReader.GetBooleanForChangingInfo( "Change group list? (F): ", false ) )
         {
               PermissionInfo[] permissions = InputReader.GetPermissionInfoList( true );
               schema.setPermissions( permissions );
         }

         if( InputReader.GetBooleanForChangingInfo( "Change sub admin group list? (F): ", false ) )
         {
               OutputWriter.DriverPrintHeader( "Ids of sub admin groups allowed to access schema:");
               InternalID[] id = InputReader.GetInternalIDList( );
               schema.setAdminGrpList(id);
         }

         if( InputReader.GetBooleanForChangingInfo("Change query list fields? (F): ", false ) )
         {
               EntryListFieldInfo[] fldInfos= InputReader.GetEntryListFieldInfoList( );
               schema.setEntryListFieldInfo( fldInfos );
         }

         if( InputReader.GetBooleanForChangingInfo( "Change sort list? (F): ", false ) )
         {
               SortInfo[] sortarr = InputReader.GetSortInfoList( );
               schema.setSortInfo( sortarr );
         }

         if( InputReader.GetBooleanForChangingInfo( "Change index list? (F): ", false ) )
         {
               IndexInfo[] index = InputReader.GetIndexInfoList( );
               schema.setIndexInfo( index );
         }

         if( InputReader.GetBooleanForChangingInfo( "Change archive info? (F): ", false ) )
         {
               ArchiveInfo archive = InputReader.GetArchiveInfo( );
               schema.setArchiveInfo( archive );
         }

         if (InputReader.GetBoolean("Change default VUI? (F): ", false))
        {
            NameID vuiName = InputReader.GetNameID("   Default VUI  " );
            schema.setDefaultVUI( vuiName );
        }
         if( InputReader.GetBooleanForChangingInfo("Change help text? (F): ", false ))
         {
               String help = InputReader.GetString( "Help Text (): ", "" );
               schema.setHelpText( help );
         }

         if( InputReader.GetBooleanForChangingInfo( "Change owner? (F): ", false ) )
         {
               AccessNameID owner = InputReader.GetAccessNameID( "New Owner" );
               schema.setOwner( owner );
         }

         if( InputReader.GetBooleanForChangingInfo( "Add to change diary? (F): ", false ) )
         {
               String diary = InputReader.GetString( "Change Diary (): ", "" );
               schema.setDiary( diary );
         }

         if (InputReader.GetBooleanForChangingInfo("Change object properties? (F): ", false))
         {
             PropInfo[] propList = InputReader.GetPropInfoList( );
             schema.setProperties( propList );
         }

         beginAPICall( );
         schema.store();
         endAPICall( getControlStructObject().getLastStatus( ) );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set Schema Status", statusList );

         schemaMan.releaseInstance(schema);
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
           endAPICall( getControlStructObject().getLastStatus( ) );
          OutputWriter.PrintARException( e );
      }
   }



   void getEntry( ){
      try {
      	 OutputWriter.DriverPrintHeader( "GET ENTRY" );

         EntryFactory entryMan = EntryFactory.getFactory( );
         EntryCriteria	entryCriteria = new EntryCriteria( );

         // Get the Entry Key
         EntryKey entryKey = InputReader.GetEntryKey( );

         // Get the fields information
	     FieldID[] fieldsList = InputReader.GetFieldIDList( );
         EntryListFieldInfo[]  entryList = null;
         if( fieldsList != null && fieldsList.length != 0 )
         {
            entryList = new EntryListFieldInfo[ fieldsList.length ];
            for( int i = 0; i < fieldsList.length; i++ )
            {
                  entryList[i] = new EntryListFieldInfo( fieldsList[i] );
            }
         }
         entryCriteria.setEntryListFieldInfo( entryList );

         beginAPICall( );
         Entry entry=entryMan.findByKey( getControlStructObject(), entryKey, entryCriteria );
         StatusInfo[] statusList1 = getControlStructObject().getLastStatus();
         endAPICall( statusList1 );

         // If there were diary field values, we call diary.decode()
         // which calls ARDecodeDiary. This wipes out the previous
         // status. So we merge the two status together if needed
         OutputWriter.PrintEntry( "", "Entry Information:", entry );

         // Success. Print the status
         StatusInfo[] statusList2 = getControlStructObject().getLastStatus( );
         StatusInfo[] combinedStat = mergeStatusInfo(statusList1, statusList2);
         OutputWriter.PrintStatusInfoList( "", "Get Entry Status", combinedStat );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e);
      }
   }



   void setEntry( )
   {
      try{

         OutputWriter.DriverPrintHeader( "SET  ENTRY" );
         EntryFactory entryMan = EntryFactory.getFactory( );
         EntryCriteria	entryCriteria = new EntryCriteria( );

         // Get the Entry Key
            EntryKey entryKey = InputReader.GetEntryKey( );

         // Get the entry items information
             OutputWriter.DriverPrintPrompt("Field/value pairs to set:\n");
             EntryItem[] entryItems = InputReader.GetEntryItemList( );

         // Get the time stamp and entry option
             Timestamp getTime = new Timestamp( InputReader.GetLong( "Time of Get operation (0): ", 0 ) );
             int option = InputReader.GetInt(  "SetEntry option ? (0): ", 0);

         Entry entry=entryMan.findByKey( getControlStructObject(), entryKey, entryCriteria );

         entry.setEntryItems( entryItems );

         beginAPICall( );
         entry.store( getTime, option );
         endAPICall( getControlStructObject().getLastStatus( ) );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "SetEntry Status", statusList );
      }
      catch( IOException x )
      {
         OutputWriter.PrintString( "Problem in getting the input for set entry...\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
           endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   public void createEntry( ){

      Entry entry=null;

      try{
         OutputWriter.DriverPrintHeader( "CREATE ENTRY" );

         EntryFactory entryMan=EntryFactory.getFactory( );
         entry= (Entry)entryMan.newInstance( );
         entry.setContext(getControlStructObject());

         // Get the schema name
               NameID name = InputReader.GetNameID( "Schema Name" );
               entry.setSchemaID( name  );

         // create entryItems
               OutputWriter.DriverPrintHeader( "Field/value pairs to create:" );
               EntryItem[] entryItems = InputReader.GetEntryItemList( );

         // set the entry items...
               entry.setEntryItems( entryItems );

         beginAPICall( );
         entry.create( );
         endAPICall( getControlStructObject().getLastStatus( ) );

         OutputWriter.PrintString( "Entry id: " + entry.getEntryID( ).toString( ) );
         OutputWriter.PrintNewLine( );
         entryMan.releaseInstance( entry );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Create Entry Status", statusList );
      }
      catch( IOException e )
      {
          OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
          OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
           endAPICall( getControlStructObject().getLastStatus( ) );
          OutputWriter.PrintARException( e );
      }
   }



   void deleteEntry( )
   {
      try{
         OutputWriter.DriverPrintHeader( "DELETE ENTRY" );

         EntryFactory entryMan = EntryFactory.getFactory( );

         // Create a new entry instance
            Entry entry = ( Entry )entryMan.newInstance( );

         // Get and set the entry key
            EntryKey key = InputReader.GetEntryKey( );
            entry.setKey( key );

        int option =  InputReader.GetInt("DeleteEntry option ? (0): ", 0);

         // Now set the context
            entry.setContext( getControlStructObject() );

         // Now remove the entry
            beginAPICall( );
            entry.remove( );
            endAPICall( getControlStructObject().getLastStatus( ) );

          // Success. Print the status
              StatusInfo[] statusList = getControlStructObject().getLastStatus( );
              OutputWriter.PrintStatusInfoList( "", "Delete Entry", statusList );

         entryMan.releaseInstance( entry );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
           endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

void getMultipleEntries( ){
   try{
         OutputWriter.DriverPrintHeader( "GET MULTIPLE ENTRIES" );

         EntryFactory entryMan = EntryFactory.getFactory( );
         EntryListCriteria entryListCriteria = new EntryListCriteria( );
         EntryCriteria	entryCriteria = new EntryCriteria( );

         // Get the schema Name
            NameID name = InputReader.GetNameID( "Schema Name" );
            entryListCriteria.setSchemaID( name );

         // Get Entry IDs to retrieve
            JoinEntryID[] entryIDs = InputReader.GetJoinEntryIDList( );
            entryListCriteria.setEntriesToRetrieve( entryIDs );

         // Get the fields information
            OutputWriter.DriverPrintPrompt("Ids of fields to retrieve:\n");
            FieldID[] fieldsList = InputReader.GetFieldIDList( );

            EntryListFieldInfo[]  entryList = null;
            if( fieldsList != null && fieldsList.length != 0 )
            {
               entryList = new EntryListFieldInfo[ fieldsList.length ];
               for( int i = 0; i < fieldsList.length; i++ )
               {
                     entryList[i] = new EntryListFieldInfo( fieldsList[i] );
               }
            }
            entryCriteria.setEntryListFieldInfo( entryList );

      beginAPICall( );
      Entry[] entries=entryMan.findObjects( getControlStructObject(), entryListCriteria, entryCriteria, false, null );
      endAPICall( getControlStructObject().getLastStatus( ) );

      OutputWriter.PrintEntryList( "", "Entry List: ", entries );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "GetMultipleEntries Status", statusList );
   }
   catch( IOException e )
   {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
   }
   catch( NullPointerException e )
   {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
   }
   catch( ARException e )
   {
      endAPICall( getControlStructObject().getLastStatus( ) );
      OutputWriter.PrintARException( e );
   }
}




void getListEntry( )
{
   try
   {
      OutputWriter.DriverPrintHeader( "GETLIST ENTRY");

      EntryFactory entryMan=EntryFactory.getFactory( );

      // Get the EntryListCriteria
         EntryListCriteria entryListCriteria = new EntryListCriteria( );

         // Set the schema Name
            entryListCriteria.setSchemaID(  InputReader.GetNameID( "Schema:"  ) );

         // Set the qualifier info
            entryListCriteria.setQualifier( InputReader.GetQualifierInfo( ) );

      // Get entry criteria
          EntryCriteria entCriteria = InputReader.GetEntryCriteria( );

       // Get and set the sort order info for entry list criteria
          SortInfo[] sortOrder = InputReader.GetSortInfoList( );
          entryListCriteria.setSortInfos( sortOrder );

       // Get and set the first retrieve option for entry list criteria
           int firstRetrieve = InputReader.GetInt("firstRetrieve (0): ", 0 );
           entryListCriteria.setFirstRetrieve( firstRetrieve );

       // Get and set the max number of entries to retrieve in entry list criteria
           int limit = InputReader.GetInt( "Maximum Number of Entries to retrieve (500):", 500 );
           entryListCriteria.setMaxLimit( limit );

      Integer matches = null;
       if ( InputReader.GetBooleanForChangingInfo( "Get number of matches? (F): ", false ) )
       {
           matches = new Integer( 0 );
       }
      // Get and set the useLocale flag
      boolean useLocaleFlag = InputReader.GetBooleanForChangingInfo( "Use Locale Sensitive Search( false ):", false );

      beginAPICall( );
      EntryListInfo[] entryInfoList = entryMan.findEntryListInfos( getControlStructObject(), entryListCriteria, entCriteria, useLocaleFlag, matches );
      endAPICall( getControlStructObject().getLastStatus( ) );

      OutputWriter.PrintInteger( "", "Number of Matches:", matches );
      OutputWriter.PrintEntryListInfoList( "", "Entry List:", entryInfoList );

      // Success. Print the status
          StatusInfo[] statusList = getControlStructObject().getLastStatus( );
          OutputWriter.PrintStatusInfoList( "", "GetListEntry Status", statusList );
   }
   catch( IOException e )
   {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
   }
   catch( NullPointerException e )
   {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
   }
   catch( ARException e )
   {
           endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
   }
}

void compactGetListEntry( )
{
   try
   {
	  OutputWriter.DriverPrintHeader( "COMPACT GETLIST ENTRY");

	  EntryFactory entryMan=EntryFactory.getFactory( );

	  // Get the EntryListCriteria
		 EntryListCriteria entryListCriteria = new EntryListCriteria( );

		 // Set the schema Name
			entryListCriteria.setSchemaID(  InputReader.GetNameID( "Schema:"  ) );

		 // Set the qualifier info
			entryListCriteria.setQualifier( InputReader.GetQualifierInfo( ) );

	  // Get entry criteria
		  EntryCriteria entCriteria = InputReader.GetEntryCriteria( );


	   // Get and set the first retrieve option for entry list criteria
		   int firstRetrieve = InputReader.GetInt("firstRetrieve (0): ", 0 );
		   entryListCriteria.setFirstRetrieve( firstRetrieve );

	   // Get and set the max number of entries to retrieve in entry list criteria
		   int limit = InputReader.GetInt( "Maximum Number of Entries to retrieve (500):", 500 );
		   entryListCriteria.setMaxLimit( limit );

	  Integer matches = null;
	   if ( InputReader.GetBooleanForChangingInfo( "Get number of matches? (F): ", false ) )
	   {
		   matches = new Integer( 0 );
	   }

	  beginAPICall( );
	  CompactQueryResult compactEntryList = Util.ARGetCompactEntryList( getControlStructObject(), entryListCriteria, entCriteria, matches );
	  endAPICall( getControlStructObject().getLastStatus( ) );

	  OutputWriter.PrintInteger( "", "Number of Matches:", matches );
	  OutputWriter.PrintCompactQueryResult("", "Entry List:", compactEntryList );

	  // Success. Print the status
		  StatusInfo[] statusList = getControlStructObject().getLastStatus( );
		  OutputWriter.PrintStatusInfoList( "", "GetListEntry Status", statusList );
   }
   catch( IOException e )
   {
		 OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
   }
   catch( NullPointerException e )
   {
		 OutputWriter.PrintString( "Null Pointer exception...\n" );
   }
   catch( ARException e )
   {
		   endAPICall( getControlStructObject().getLastStatus( ) );
		 OutputWriter.PrintARException( e );
   }
}


void getListEntryWithFields()
{
   try
   {
      OutputWriter.DriverPrintHeader( "GETLIST ENTRY WITH FIELDS" );

      EntryFactory entryMan = EntryFactory.getFactory( );

      // Get the EntryListCriteria
      EntryListCriteria entryListCriteria = new EntryListCriteria( );

      // Set the schema Name
      entryListCriteria.setSchemaID(  InputReader.GetNameID( "Schema:"  ) );

      // Set the qualifier info
      entryListCriteria.setQualifier( InputReader.GetQualifierInfo( ) );

      // Get entry criteria
      EntryCriteria entCriteria = InputReader.GetEntryCriteria( );

      // Get and set the sort order info for entry list criteria
      SortInfo[] sortOrder = InputReader.GetSortInfoList( );
      entryListCriteria.setSortInfos( sortOrder );

      // Get and set the first retrieve option for entry list criteria
      int firstRetrieve = InputReader.GetInt("firstRetrieve (0): ", 0 );
      entryListCriteria.setFirstRetrieve( firstRetrieve );

      // Get and set the max number of entries to retrieve in entry list criteria
      int limit = InputReader.GetInt( "Maximum Number of Entries to retrieve (500):", 500 );
      entryListCriteria.setMaxLimit( limit );

      // Get and set the useLocale flag
      boolean useLocaleFlag = InputReader.GetBooleanForChangingInfo( "Use Locale Sensitive Search( false ):", false );

      Integer matches = null;
      if ( InputReader.GetBooleanForChangingInfo( "Get number of matches? (F): ", false ) )
      {
        matches = new Integer( 0 );
      }

      beginAPICall( );
      Entry[] entries = entryMan.findObjects( getControlStructObject(), entryListCriteria, entCriteria, useLocaleFlag, matches );
      endAPICall( getControlStructObject().getLastStatus( ) );

      OutputWriter.PrintEntryList( "", "Entry List: ", entries );

      // Success. Print the status
          StatusInfo[] statusList = getControlStructObject().getLastStatus( );
          OutputWriter.PrintStatusInfoList( "", "GetListEntryWithFields Status", statusList );
   }
   catch( IOException e )
   {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
   }
   catch( NullPointerException e )
   {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
   }
   catch( ARException e )
   {
           endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
   }
}

void getListEntryBlocks()
{
   try
   {
      OutputWriter.DriverPrintHeader("GETLIST ENTRY BLOCKS");

      EntryFactory entryMan = EntryFactory.getFactory();

      // Get the EntryListCriteria
      EntryListCriteria entryListCriteria = new EntryListCriteria();

      // Set the schema Name
      entryListCriteria.setSchemaID(InputReader.GetNameID("Schema:"));

      // Set the qualifier info
      entryListCriteria.setQualifier(InputReader.GetQualifierInfo());

      // Get entry criteria
      EntryCriteria entCriteria = InputReader.GetEntryCriteria();

       // Get and set the sort order info for entry list criteria
      SortInfo[] sortOrder = InputReader.GetSortInfoList();
      entryListCriteria.setSortInfos(sortOrder);

      entryListCriteria.setFirstRetrieve(0);

      // Get and set the max number of entries to retrieve in entry list criteria
      int limit = InputReader.GetInt("Maximum Number of Entries to retrieve (500):", 500);
      entryListCriteria.setMaxLimit(limit);

      // Get and set the useLocale flag
      boolean useLocaleFlag = InputReader.GetBooleanForChangingInfo("Use Locale Sensitive Search(false):", false);

      //Get the number of matches
      Integer matches = null;
      if ( InputReader.GetBooleanForChangingInfo( "Get number of matches? (F): ", false ) )
      {
        matches = new Integer( 0 );
      }

      //get the Find mode
      int findMode = InputReader.GetInt("Find mode (0):", 0);

      beginAPICall( );

      IARRowIterator ri = new RowIterator();

      entryMan.findAndIterate(getControlStructObject(), entryListCriteria,
                              entCriteria, useLocaleFlag, matches, findMode, ri);

      endAPICall(getControlStructObject().getLastStatus());

      OutputWriter.PrintInteger( "", "Number of Matches:", matches );
   }
   catch( IOException e )
   {
      OutputWriter.PrintString("Problem in getting the input...Driver problem..\n");
   }
   catch(NullPointerException e)
   {
      OutputWriter.PrintString("Null Pointer exception...\n");
   }
   catch(ARException e)
   {
      endAPICall(getControlStructObject().getLastStatus());
      OutputWriter.PrintARException(e);
   }
}


   public void mergeEntry( ){

      Entry entry=null;

      try{
         OutputWriter.DriverPrintHeader( "MERGE ENTRY" );

         EntryFactory entryMan=EntryFactory.getFactory( );
         entry= (Entry)entryMan.newInstance( );
         entry.setContext(getControlStructObject());

         // Get the schema name
               NameID name = InputReader.GetNameID( "Schema Name" );
               SchemaKey schema = new SchemaKey( name );

         // create entryItems
               OutputWriter.DriverPrintHeader( "Field/value pairs to merge:" );
               EntryItem[] entryItems = InputReader.GetEntryItemList( );

         // set the entry items...
               entry.setEntryItems( entryItems );

         int  mergeType = InputReader.GetInt( "Operation on duplicate entry (error, new ID, overwrite, merge) (1-4): ", 4);

         beginAPICall( );
         entry.merge( schema, mergeType );
         endAPICall( getControlStructObject().getLastStatus( ) );

         OutputWriter.PrintString( "Entry id: " + entry.getEntryID( ).toString( ) );
         OutputWriter.PrintNewLine( );
         entryMan.releaseInstance( entry );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Merge Entry Status", statusList );
      }
      catch( IOException e )
      {
          OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
          OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
           endAPICall( getControlStructObject().getLastStatus( ) );
          OutputWriter.PrintARException( e );
      }
   }



   void createField( )
   {
      try{
         OutputWriter.DriverPrintHeader( "CREATE FIELD" );

         // Create an empty field
            FieldFactory fieldMan = FieldFactory.getFactory( );
            Field field = (Field)fieldMan.newInstance( );

         // Set the context ( user session )
            field.setContext( getControlStructObject() );

         // Set the schema name
            NameID schemaName = InputReader.GetNameID( "Schema Name" );
            field.setSchema( schemaName );

         // Set the Field ID
            FieldID id = InputReader.GetFieldID( );
            field.setFieldID( id );

         // Set the reserved id
            boolean reservedID = InputReader.GetBoolean( "Create even if ID is reserved? (F): ", false );
            field.setReservedIDOK( reservedID );

         // Set the Field Name
            NameID fieldName = InputReader.GetNameID( "Field Name" );
            field.setName( fieldName );

         // Set the field map if necessary.

         // Set the Data Type
            DataType type = InputReader.GetDataType( );
            field.setDataType( type );

         // Set the option for entering the value
            int option = InputReader.GetInt( "Required, Optional, System, or Display-only (1-4) (2): ", 2 );
            field.setFieldOption( option );

         // Set create mode
            int createMode = InputReader.GetInt( "Open or Protected at create (1 or 2) (1): ", 1 );
            field.setCreateMode( createMode );

         // Set default value
            if( type.equals( DataType.ATTACHMENT ) || type.equals( DataType.TABLE ) ||
                type.equals( DataType.COLUMN )  )
            {
            }
            else  if( InputReader.GetBooleanForChangingInfo( "Have new default value? (F): ", false ) )
            {
               Value val = InputReader.GetValue( type.toInt( )  );
               field.setDefaultValue( val );
            }

         // Set permissions
            PermissionInfo[] permissions = InputReader.GetPermissionInfoList( true );
            field.setPermissions( permissions );

         // Set limits
            if( InputReader.GetBooleanForChangingInfo( "Have field limits? (T): ", true ) )
            {
                 FieldLimitInfo limitInfo = InputReader.GetFieldLimitInfo( type.toInt( )  );
                 field.setFieldLimit( limitInfo );
            }

         // Set DisplayInstanceList
            DisplayInstanceList dispInstanceList = InputReader.GetDisplayInstanceList( );
            field.setDisplayInstance( dispInstanceList );

         // Set the help text
            String helpText = InputReader.GetString( "Help Text: ", "" );
            field.setHelpText( helpText );

         // Set the owner
            AccessNameID owner = InputReader.GetAccessNameID( "Owner" );
            field.setOwner( owner );

         // Set Change Diary
            String diary = InputReader.GetString( "Diary: ", "" );
            field.setDiary( diary );

         // Set the field mapping structure
            FieldMappingInfo mapInfo = InputReader.GetFieldMappingInfo( );
            field.setFieldMap( mapInfo );

         // Now create the field
            beginAPICall( );
            field.create( );
            endAPICall( getControlStructObject().getLastStatus( ) );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "CreateField Status", statusList );
      }

      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
           endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void deleteField( )
   {
      try{
         OutputWriter.DriverPrintHeader( "DELETE FIELD" );

         // Create an empty field
            FieldFactory fieldMan = FieldFactory.getFactory( );
            Field field = (Field)fieldMan.newInstance( );

         // Set the context ( user session )
            field.setContext( getControlStructObject() );

         // Set the schema name
            NameID schemaName = InputReader.GetNameID( "Schema Name" );
            field.setSchema( schemaName );

         // Set the Field ID
            FieldID id = InputReader.GetFieldID(  "Field id (0):", 0 );
            field.setFieldID( id );

         // set the delete option
            int deleteOption = InputReader.GetInt( "Delete option - clean, data, cascade (0 - 2) (0): ", 0 );
            field.setDeleteOption( deleteOption );

         // Now delete the field
            beginAPICall( );
            field.remove( );
            endAPICall( getControlStructObject().getLastStatus( ) );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "DeleteField Status", statusList );

      }

      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
           endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }


   void deleteMultipleFields( )
   {
      try{
         OutputWriter.DriverPrintHeader( "DELETE MULTIPLE FIELDS" );

         // Create Schema Factory
            SchemaFactory schemaMan = SchemaFactory.getFactory( );

         // Create a new schema object
            Schema schema = ( Schema )schemaMan.newInstance( );

         // Set the schema name
            NameID schemaName = InputReader.GetNameID( "Schema Name" );
            schema.setName( schemaName );

         // Get the Field IDs to be deleted
            OutputWriter.DriverPrintPrompt("Ids of fields to delete:\n");
            FieldID[] idList = InputReader.GetFieldIDList( );

         // Get the delete option
            int deleteOption = InputReader.GetInt( "Delete Option- clean, data, cascade (0, 1, 2 ) (0): ", 0 );

         // Set the context ( user session )
            schema.setContext( getControlStructObject() );

         // Now delete the fields
            beginAPICall( );
            schema.deleteFields( idList, deleteOption );
            endAPICall( getControlStructObject().getLastStatus( ) );

          // Success. Print the status
              StatusInfo[] statusList = getControlStructObject().getLastStatus( );
              OutputWriter.PrintStatusInfoList( "", "Delete Multiple Fields  Status", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
           endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void getField( )
   {
      try{
         OutputWriter.DriverPrintHeader( "GET FIELD" );

         // Create an empty field
            FieldFactory fieldMan = FieldFactory.getFactory( );

         // Set the schema name
            NameID schemaName = InputReader.GetNameID( "Schema Name" );

         // Set the Field ID
            FieldID id = InputReader.GetFieldID( "Field id (1): ", 1);

            FieldKey key = new FieldKey(  schemaName, id );

         // Set the field criteria to retrieve all
            FieldCriteria crit = new FieldCriteria( );
            crit.setRetrieveAll(true);


         // Find the field
            beginAPICall( );
            Field field = fieldMan.findByKey( getControlStructObject(), key, crit );
            endAPICall( getControlStructObject().getLastStatus( ) );

          // Print the field info
              OutputWriter.PrintField( "", "Field Information:", field );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Get Field Status", statusList );
     }
     catch( IOException e )
     {
        OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
     }
     catch( NullPointerException e )
     {
        OutputWriter.PrintString( "Null Pointer exception...\n" );
     }
     catch( ARException e )
     {
           endAPICall( getControlStructObject().getLastStatus( ) );
        OutputWriter.PrintARException( e );
     }
   }



   void getListField( )
   {
      try{
         OutputWriter.DriverPrintHeader( "GET LIST FIELD" );

         // Create an empty field
            FieldFactory fieldMan = FieldFactory.getFactory( );

         // Set the field List criteria
            FieldListCriteria listCriteria = InputReader.GetFieldListCriteria( );


         // Find the fields
            beginAPICall( );
            FieldKey[] fieldList = fieldMan.find( getControlStructObject(), listCriteria );
            endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the information
            OutputWriter.PrintFieldKeyList( "", "Field Key List Information:", fieldList );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Get List Field Status", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
           endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void setField( )
   {
      try{
         OutputWriter.DriverPrintHeader( "SET FIELD" );

         // Create an empty field
            FieldFactory fieldMan = FieldFactory.getFactory( );
            Field field = (Field)fieldMan.newInstance( );

         // Set the context ( user session )
            field.setContext( getControlStructObject() );

         // Set the Schema Name
            NameID  schemaName = InputReader.GetNameID( "Schema name" );
            field.setSchema(schemaName);

         // Set the Field ID
            FieldID id = InputReader.GetFieldID("Field id (1): ", 1);
            field.setFieldID( id );

         // Set the Datatype
            DataType type = InputReader.GetDataType( );
            field.setDataType( type );

         // Set the Field Name
            if( InputReader.GetBooleanForChangingInfo( "Change fieldName? (F): ", false ) )
            {
               NameID fieldName = InputReader.GetNameID( "field name" );
               field.setName( fieldName );
            }

         // Set the field mapping structure
            if( InputReader.GetBooleanForChangingInfo( "Change field mapping? (F): ", false ) )
            {
               FieldMappingInfo mapInfo = InputReader.GetFieldMappingInfo( );
               field.setFieldMap( mapInfo );
            }

         // Set the option for entering the value
            if( InputReader.GetBooleanForChangingInfo( "Have new option? (F): ", false ) )
            {
               int option = InputReader.GetInt( "Required, Optional, System, or Display-only (1-4) (2): ", 2 );
               field.setFieldOption( option );
            }

         // Set create mode
            if( InputReader.GetBooleanForChangingInfo( "Have new create mode? (F): ", false ) )
            {
               int createMode = InputReader.GetInt( "Open or Protected at create (1 or 2) (1) ", 1 );
               field.setCreateMode( createMode );
            }

         // Set default value
            if( type.equals( DataType.ATTACHMENT ) || type.equals( DataType.TABLE ) ||
                type.equals( DataType.COLUMN )  )
            {
            }
            else  if( InputReader.GetBooleanForChangingInfo( "Have new default value? (F): ", false ) )
            {
               Value val = InputReader.GetValue( type.toInt( )  );
               field.setDefaultValue( val );
            }

         // Set permissions
            if( InputReader.GetBooleanForChangingInfo( "Have new permissions? (F): ", false ) )
            {
               PermissionInfo[] permissions = InputReader.GetPermissionInfoList( true );
               field.setPermissions( permissions );
            }

         // Set limits
            if( InputReader.GetBooleanForChangingInfo( "Have new field limits? (F): ", false ) )
            {
                 FieldLimitInfo limitInfo = InputReader.GetFieldLimitInfo( type.toInt( )  );
                 field.setFieldLimit( limitInfo );
            }

         // Set DisplayInstanceList
            if( InputReader.GetBooleanForChangingInfo( "Have new display instance? (F): ", false ) )
            {
               DisplayInstanceList dispInstanceList = InputReader.GetDisplayInstanceList( );
               field.setDisplayInstance( dispInstanceList );
            }

         // Set the help text
            if( InputReader.GetBooleanForChangingInfo( "Change help text? (F): ", false ) )
            {
               String helpText = InputReader.GetString( "Help Text: ", "" );
               field.setHelpText( helpText );
            }

         // Set the owner
            if( InputReader.GetBooleanForChangingInfo( "Change owner? (F): ", false ) )
            {
               AccessNameID owner = InputReader.GetAccessNameID( "Owner" );
               field.setOwner(  owner );
            }

         // Set Change Diary
            if( InputReader.GetBooleanForChangingInfo( "Add to change diary? (F): ", false ) )
            {
               String diary = InputReader.GetString( "Diary: ", "" );
               field.setDiary( diary );
            }


         // Now store the new field information
            beginAPICall( );
            field.store( );
            endAPICall( getControlStructObject().getLastStatus( ) );

          // Success. Print the status
              StatusInfo[] statusList = getControlStructObject().getLastStatus( );
              OutputWriter.PrintStatusInfoList( "", "Set Field Status", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
           endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void createCharMenu( )
   {
      try{
         OutputWriter.DriverPrintHeader( "CREATE CHAR MENU" );

         // Create the menu factory
               MenuFactory menuFactory = MenuFactory.getFactory( );

         // Create a Menu (empty) instance
               Menu menu = (Menu)menuFactory.newInstance( );

         // Set the menu name
               NameID menuName = InputReader.GetNameID( "Character Menu Name" );
               menu.setName( menuName  );

         // Set refreshing code
               int refreshCode = InputReader.GetInt( "Refresh on connect, open, interval (1 - 3) (1): ", 1 );
               menu.setRefreshCode( refreshCode );

         // Set the Char menu item info
               OutputWriter.DriverPrintPrompt("Character menu Info:\n");
               CharMenuInfo menuInfo = InputReader.GetCharMenuInfo( );
               menu.setMenuDefinition( menuInfo );

         // Set help text
               String helpText = InputReader.GetString( "Help Text():", "" );
               menu.setHelpText( helpText );

         // Set Owner
               AccessNameID owner = InputReader.GetAccessNameID( "Owner" );
               menu.setOwner( owner );

         // Set Change diary
               String changeDiary = InputReader.GetString( "Change Diary():", "" );
               menu.setDiary( changeDiary );

         // Set the properties
               PropInfo[] props = InputReader.GetPropInfoList( );
               menu.setProperties( props );

         // Set context ( user session )
               menu.setContext( getControlStructObject() );

         // Now create the menu
             beginAPICall( );
             menu.create( );
             endAPICall( getControlStructObject().getLastStatus( ) );

         // release the menu instance
               menuFactory.releaseInstance( menu );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "CreateCharMenu Status", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void deleteCharMenu( )
   {
      try{
         OutputWriter.DriverPrintHeader( "DELETE CHAR MENU" );

         // Create the menu factory
               MenuFactory menuFactory = MenuFactory.getFactory( );

         // Create a Menu (empty) instance
               Menu menu = (Menu)menuFactory.newInstance( );

         // Set the menu name
               NameID menuName = InputReader.GetNameID( "Character Menu Name" );
               menu.setName( menuName );

         // Set context ( user session )
               menu.setContext( getControlStructObject() );

         // delete the menu
             beginAPICall( );
             menu.remove( );
             endAPICall( getControlStructObject().getLastStatus( ) );

         // release the menu instance
               menuFactory.releaseInstance( menu );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "DeleteCharMenu", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
           endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }


   void getCharMenu( )
   {
      try{
         OutputWriter.DriverPrintHeader( "GET CHAR MENU" );

         // Create the menu factory
               MenuFactory menuFactory = MenuFactory.getFactory( );

         // Get Menu Key
               MenuKey key = InputReader.GetMenuKey( );

         // Create MenuCriteria Object
            MenuCriteria crit = new MenuCriteria();
             crit.setRetrieveAll(true);

         // Find the menu
              beginAPICall( );
              Menu menu = menuFactory.findByKey( getControlStructObject(), key, crit );
             endAPICall( getControlStructObject().getLastStatus( ) );

         // Now print all the information
               OutputWriter.PrintMenu( "", "Menu Information: ", menu );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "GetCharMenu Status", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
           endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }

   }

   void getListCharMenu( )
   {
      try{
         OutputWriter.DriverPrintHeader( "GET LIST CHAR MENU" );

         // Create the menu factory
               MenuFactory menuFactory = MenuFactory.getFactory( );

         // Create MenuListCriteria Object
               MenuListCriteria listCrit = InputReader.GetMenuListCriteria( );

         // Create MenuCriteria Object
            MenuCriteria crit = new MenuCriteria( );
            crit.setRetrieveAll( true );

         // Find the menu objects
              beginAPICall( );
              Menu[] menuList = menuFactory.findObjects( getControlStructObject(), listCrit, crit );
             endAPICall( getControlStructObject().getLastStatus( ) );

         // Now print all the information
               OutputWriter.PrintMenuList( "", "Menu List Information: ", menuList );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Get List Char Menu Status", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
           endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }

   }

   void expandCharMenu( )
   {
      try{
         OutputWriter.DriverPrintHeader( "EXPAND CHAR MENU" );

         // Create the menu factory
               MenuFactory menuFactory = MenuFactory.getFactory( );

         // Create a Menu (empty) instance
               Menu menu = (Menu)menuFactory.newInstance( );


         // Set context ( user session )
               menu.setContext( getControlStructObject() );

         // Set the Char menu  info
               CharMenuInfo menuInfo = InputReader.GetCharMenuInfo( );
               menu.setMenuDefinition( menuInfo );


         // now expand the menu
             beginAPICall( );
             CharMenuInfo expandedMenuInfo = menu.expandMenu( );
             endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the expanded menu information
               OutputWriter.PrintCharMenuInfo( "", "Expanded char Menu Info:", expandedMenuInfo );

         // release the menu instance
               menuFactory.releaseInstance( menu );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ExpandCharMenu Status", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
                    endAPICall( getControlStructObject().getLastStatus( ) );
                   OutputWriter.PrintARException( e );
      }
   }

   void setCharMenu( )
   {
      try{
         OutputWriter.DriverPrintHeader( "SET CHAR MENU" );

         // Create the menu factory
               MenuFactory menuFactory = MenuFactory.getFactory( );

         // Create a new Menu instance
               Menu menu = ( Menu )menuFactory.newInstance( );

               NameID name = InputReader.GetNameID( "Character Menu Name" );
               menu.setName( name );

         // If needed get the information to change the menu name
               if( InputReader.GetBooleanForChangingInfo( "Change Character Menu Name? (F): ", false ) )
               {
                  NameID newName = InputReader.GetNameID( "New Name" );
                  menu.setNewName( newName );
               }

         // If needed get and Set new refreshing code
               if( InputReader.GetBooleanForChangingInfo( "Change Refresh Code? (F): ", false ) )
               {
                  int refreshCode = InputReader.GetInt( "Refresh on connect, open, interval (1 - 3) (1): ", 1 );
                  menu.setRefreshCode( refreshCode );
               }

         // If needed get the new menu definition
               if( InputReader.GetBooleanForChangingInfo( "Change Menu Definition(s)? (F): ", false ) )
               {
                  OutputWriter.DriverPrintPrompt("Character menu Info\n");
                  CharMenuInfo menuInfo = InputReader.GetCharMenuInfo( );
                  menu.setMenuDefinition( menuInfo );
               }

         // If needed get the new help text
               if( InputReader.GetBooleanForChangingInfo( "Change help text? (F): ", false ) )
               {
                  String helpText = InputReader.GetString( "    Help Text(): ", "" );
                  menu.setHelpText( helpText );
               }

         // If needed get the new Owner
               if( InputReader.GetBooleanForChangingInfo( "Change Owner? (F): ", false ) )
               {
                  AccessNameID owner = InputReader.GetAccessNameID( "Owner" );
                  menu.setOwner( owner );
               }

         // If needed get the new Owner
               if( InputReader.GetBooleanForChangingInfo( "Add to Change Diary? (F): ", false ) )
               {
                  String diary = InputReader.GetString( "    Change Diary (): ", "" );
                  menu.setDiary( diary );
               }

         // If needed get the new properties
               if( InputReader.GetBooleanForChangingInfo( "Change object properties? (F): ", false ) )
               {
                  PropInfo[] props = InputReader.GetPropInfoList( );
                  menu.setProperties( props );
               }

         // Set the context
               menu.setContext( getControlStructObject() );


         // Now store all the menu information
             beginAPICall( );
             menu.store( );
             endAPICall( getControlStructObject().getLastStatus( ) );

         // release the menu instance
               menuFactory.releaseInstance( menu );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set Char Menu Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }

   }


   void createContainer( )
   {
      try{
         OutputWriter.DriverPrintHeader( "CREATE CONTAINER" );

         ContainerFactory conFact = ContainerFactory.getFactory( );

         // Create a new container object
               Container container = ( Container )conFact.newInstance( );

         // Get and Set the container name
               NameID name = InputReader.GetNameID( "Container Name" );
               container.setName( name );

         // Get and Set the permissions information
               PermissionInfo[] permissionList = InputReader.GetPermissionInfoList( true );
               container.setPermissions( permissionList );

         // Get and Set sub admin groups allowed to access this container
               OutputWriter.DriverPrintPrompt("Ids of sub admin groups allowed to access container:\n");
               InternalID[] adminList = InputReader.GetInternalIDList( );
               container.setAdminGroupList( adminList );

         // Get and Set container owner
               ContainerOwner[] containerOwnerList = InputReader.GetContainerOwnerList( );
               container.setContainerOwner( containerOwnerList );

         // Get and Set the container Label
               String label = InputReader.GetString( "Label ():", "" );
               container.setLabel( label );

         // Get and set the description
               String desc = InputReader.GetString( "Description ():", "" );
               container.setDescription( desc );

         // Get and Set the container type
               ContainerType type = InputReader.GetContainerType( );
               container.setType( type );

         // Get and Set the reference list
               ReferenceBase[] references = InputReader.GetReferenceBaseList( );
               container.setReferences( references );

         // Get and set the remove flag
               boolean flag = InputReader.GetBooleanForChangingInfo( "Remove Invalid References( false ):", false );
               container.setRemoveFlag( flag );

         // Get and set the help text
               String help = InputReader.GetString( "Help Text ():", "" );
               container.setHelpText( help );

         // Get and Set the owner
               AccessNameID owner = InputReader.GetAccessNameID( "Owner" );
               container.setOwner( owner );

         // Get and Set change diary
               String diary = InputReader.GetString( "Change Diary ():", "" );
               container.setDiary( diary );

         // Get and set properties
               PropInfo[] propList = InputReader.GetPropInfoList( );
               container.setProperties( propList );

         // Set the context
               container.setContext( getControlStructObject() );

         // Now create the container in the database
             beginAPICall( );
             container.create( );
             endAPICall( getControlStructObject().getLastStatus( ) );

         // release the container instance
               conFact.releaseInstance( container );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Create Container Status", statusList );


      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }

   }


   void setContainer( )
   {
      try{
         OutputWriter.DriverPrintHeader( "SET CONTAINER" );

         ContainerFactory conFact = ContainerFactory.getFactory( );

         // Create a container instance
               Container container = ( Container )conFact.newInstance( );

         // Get and Set container key
               String name = InputReader.GetString( "Container Name:", "" );
               ContainerKey key = new ContainerKey( name );

         // Get and Set the container new name
               if( InputReader.GetBooleanForChangingInfo( "Change container name? (F): ", false ) )
               {
                  NameID newName = InputReader.GetNameID( "New Name" );
                  container.setName( newName );
               }

         // Get and Set new permission list
               if( InputReader.GetBooleanForChangingInfo( "Change group( permission ) list? (F): ", false ) )
               {
                  PermissionInfo[] permissionList = InputReader.GetPermissionInfoList( true );
                  container.setPermissions( permissionList );
               }

         // Get and Set sub admin groups allowed to access this container
               if( InputReader.GetBooleanForChangingInfo( "Change sub admin group list? (F): ", false ) )
               {
                  OutputWriter.DriverPrintPrompt("Ids of sub admin groups allowed to access container:\n");
                  InternalID[] adminList = InputReader.GetInternalIDList( );
                  container.setAdminGroupList( adminList );
               }

         // Get and Set new container owner
               if( InputReader.GetBooleanForChangingInfo( "Change container owner object? (F): ", false ) )
               {
                  ContainerOwner[] containerOwnerList = InputReader.GetContainerOwnerList( );
                  container.setContainerOwner( containerOwnerList );
               }

         // Get and Set the new container Label
               if( InputReader.GetBooleanForChangingInfo( "Change label? (F): ", false ) )
               {
                  String label = InputReader.GetString( "    Label ():", "" );
                  container.setLabel( label );
               }

         // Get and set the new description
               if( InputReader.GetBooleanForChangingInfo( "Change description? (F): ", false ) )
               {
                  String desc = InputReader.GetString( "    Description ():", "" );
                  container.setDescription( desc );
               }

         // Get and Set the new container type
               if( InputReader.GetBooleanForChangingInfo( "Change container type? (F): ", false ) )
               {
                  ContainerType type = InputReader.GetContainerType( );
                  container.setType( type );
               }

         // Get and Set the new reference list
               if( InputReader.GetBooleanForChangingInfo( "Change reference list? (F): ", false ) )
               {
                  ReferenceBase[] references = InputReader.GetReferenceBaseList( );
                  container.setReferences( references );
                  boolean flag = InputReader.GetBooleanForChangingInfo( "Remove invalid references? (F): ", false );
                  container.setRemoveFlag( flag );
               }

         // Get and set the new help text
               if( InputReader.GetBooleanForChangingInfo( "Change help text? (F): ", false ) )
               {
                  String help = InputReader.GetString( "    Help Text ():", "" );
                  container.setHelpText( help );
               }

         // Get and set the new owner
               if( InputReader.GetBooleanForChangingInfo( "Change owner? (F): ", false ) )
               {
                  AccessNameID owner = InputReader.GetAccessNameID( "Owner" );
                  container.setOwner(  owner );
               }

         // Get and Set addition to change diary
               if( InputReader.GetBooleanForChangingInfo( "Add to change diary? (F): ", false ) )
               {
                  String diary = InputReader.GetString( "    Change Diary ():", "" );
                  container.setDiary( diary );
               }

         // Get and set properties
               if( InputReader.GetBooleanForChangingInfo( "Change object properties? (F): ", false ) )
               {
                  PropInfo[] propList = InputReader.GetPropInfoList( );
                  container.setProperties( propList );
               }


         // Now update the container properties in the database
             beginAPICall( );
             container.store( );
             endAPICall( getControlStructObject().getLastStatus( ) );

         // release the container instance
               conFact.releaseInstance( container );

            // Success. Print the status
                StatusInfo[] statusList = getControlStructObject().getLastStatus( );
                OutputWriter.PrintStatusInfoList( "", "Set Container Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }

   }

   void deleteContainer( )
   {
      try{
         OutputWriter.DriverPrintHeader( "DELETE CONTAINER" );

         ContainerFactory conFact = ContainerFactory.getFactory( );

         // Create a new container instance
               Container container = ( Container )conFact.newInstance( );

         // Get and Set the container name
               NameID name = InputReader.GetNameID( "Container Name" );
               container.setName( name );

         // Set the context
               container.setContext( getControlStructObject() );


         // Now remove the container
             beginAPICall( );
             container.remove( );
             endAPICall( getControlStructObject().getLastStatus( ) );

         // release the container instance
               conFact.releaseInstance( container );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Delete Container Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }

   }


   void getContainer( ){
      try{
         OutputWriter.DriverPrintHeader( "GET CONTAINER" );

         ContainerFactory conFact=ContainerFactory.getFactory( );

         // Get  container key
               ContainerKey key = InputReader.GetContainerKey( );

         // Set the criteria to retrieve all
               ContainerCriteria criteria = new ContainerCriteria();
               criteria.setRetrieveAll( true );


         // Now get the container
              beginAPICall( );
              Container container = conFact.findByKey( getControlStructObject(), key, criteria );
             endAPICall( getControlStructObject().getLastStatus( ) );

         // Now print the container information
               OutputWriter.PrintContainer( "", "Container Information:", container );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "GetContainer Status", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void getListContainer( ){
      try{
         OutputWriter.DriverPrintHeader( "GET LIST CONTAINER" );
         ContainerFactory containerFactory=ContainerFactory.getFactory( );

         // Create a container list criteria object
               ContainerListCriteria listCriteria = new ContainerListCriteria();

         // Get the time stamp
               Timestamp time = InputReader.GetTimestamp( "Get all changed since ", new Timestamp(0) );
               listCriteria.setModifiedAfter( time );

         // Get and set container types information
               ContainerType[] types = InputReader.GetContainerTypeList( );
               listCriteria.setTypes( types );

         // Get and set attributes flag
               int flag = InputReader.GetInt( "Container attributes( none, hidden ) (0-1) (0):", 0 );
               if( flag == 0 ) // Don't show hidden and visible containers
               {
                  listCriteria.setAttribute( false );
               }
               else // show hidden and visible containers
               {
                  listCriteria.setAttribute( true );
               }

         // Get and set the container owner
               ContainerOwner[] containerOwnerList = InputReader.GetContainerOwnerList( );
               listCriteria.setOwner( containerOwnerList );

         // Create Container Criteria object
               ContainerCriteria containerCriteria = new ContainerCriteria( );

         // Set the flag to retrieve all the information
               containerCriteria.setRetrieveAll( true );


         // Now find all the container objects
             beginAPICall( );
             Container[] containers = containerFactory.findObjects( getControlStructObject(), listCriteria, containerCriteria );
             endAPICall( getControlStructObject().getLastStatus( ) );

         // Now print all the information about the containers
             OutputWriter.PrintContainerList( "", "Container List:", containers );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "GetListContainer Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void getMultipleContainers(){
      try{
         OutputWriter.DriverPrintHeader("GET MULTIPLE CONTAINERS");
         ContainerFactory containerFactory=ContainerFactory.getFactory();

         ContainerMultiCriteria multiCriteria = new ContainerMultiCriteria();

         // Create a container multi criteria object
               Timestamp time = InputReader.GetTimestamp("Get all changed since (0): ", new Timestamp(0));
               multiCriteria.setModifiedAfter(time);

         // Get and set container name list
               ContainerKey[] containerKeys = InputReader.GetContainerKeyList("");
               multiCriteria.setContainerKeys(containerKeys);

         // Get and set container types information
               ContainerType[] types = InputReader.GetContainerTypeList();
               multiCriteria.setTypes(types);

         // Get and set attributes flag
               int flag = InputReader.GetInt("Container attributes(none, hidden) (0-1) (0):", 0);
               if(flag == 0) // Don't show hidden and visible containers
               {
                  multiCriteria.setAttribute(false);
               }
               else // show hidden and visible containers
               {
                  multiCriteria.setAttribute(true);
               }

         // Get and set the container owner
               ContainerOwner[] containerOwnerList = InputReader.GetContainerOwnerList();
               multiCriteria.setOwner(containerOwnerList);

         // Create Container Criteria object
               ContainerCriteria containerCriteria = new ContainerCriteria();

         // Set the flag to retrieve all the information
               containerCriteria.setRetrieveAll(true);

         // Now find all the container objects
             Container[] containers = containerFactory.findObjects(getControlStructObject(), multiCriteria, containerCriteria);

         // Now print all the information about the containers
             OutputWriter.PrintContainerList("", "Container List:", containers);

      }
      catch(IOException e)
      {
         OutputWriter.PrintString("Problem in getting the input...Driver problem..\n");
      }
      catch(NullPointerException e)
      {
         OutputWriter.PrintString("Null Pointer exception...\n");
      }
      catch(ARException e)
      {
         OutputWriter.PrintARException(e);
      }
   }


   void createVUI( ){
      try{

         OutputWriter.DriverPrintHeader( "CREATE VIEW" );

         ViewFactory viewMan = ViewFactory.getFactory( );

         // Create a new view instance
               View view = ( View )viewMan.newInstance( );

         // Set the context
               view.setContext( getControlStructObject() );

         // Get and set the schema name
               NameID name = InputReader.GetNameID( "Schema Name" );
               view.setSchemaName(  name  );

         // Get and Set the VUI id
               FieldID id = InputReader.GetVUIID( "VUI id (0): ", 0 );
               view.setVUIId( id );

         // Get and set the VUI name
               NameID vuiName = InputReader.GetNameID( "VUI name" );
               view.setName(  vuiName  );

         // Get and set the locale
             String locale = InputReader.GetString( "Locale (): ", "" );
             view.setLocale( locale );

         // Get and set the VUI Type
             int type = InputReader.GetInt( "VUI-Type (0): ", 0 );
             view.setVUIType( type );

         // Get and set the properties
               PropInfo[] properties = InputReader.GetPropInfoList( );
               view.setDisplayProperties( properties );

         // Get and set help text
               String helpText = InputReader.GetString( "Help Text:", "" );
               view.setHelpText( helpText );

         // Get and Set owner
               AccessNameID owner = InputReader.GetAccessNameID( "Owner" );
               view.setOwner( owner );

         // Get and set the change diary
               String changeDiary = InputReader.GetString( "Change Diary:", "" );
               view.setDiary( changeDiary );


         // Now create the view
            beginAPICall( );
            view.create( );
            endAPICall( getControlStructObject().getLastStatus( ) );

        // release the view instance
               viewMan.releaseInstance( view );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "CreateView Status", statusList );


      }

      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
                    endAPICall( getControlStructObject().getLastStatus( ) );
                   OutputWriter.PrintARException( e );
      }
   }

   void deleteVUI( ){
      try{

         OutputWriter.DriverPrintHeader( "DELETE VIEW" );

         ViewFactory viewMan = ViewFactory.getFactory( );

         // Create a new view instance
               View view = ( View )viewMan.newInstance( );

         // Set the context
               view.setContext( getControlStructObject() );

         // Get and set the schema name
               NameID name = InputReader.GetNameID( "Schema Name" );
               view.setSchemaName( name );

         // Get and Set the VUI id
               FieldID id = InputReader.GetVUIID( "VUI id (0): ", 0);
               view.setVUIId( id );


         // Now delete the view
             beginAPICall( );
             view.remove( );
             endAPICall( getControlStructObject().getLastStatus( ) );

         // release the view instance
               viewMan.releaseInstance( view );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Delete View Status", statusList );


      }

      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void getVUI( ){
      try{

         OutputWriter.DriverPrintHeader( "GET VIEW" );

         ViewFactory viewMan = ViewFactory.getFactory( );

         // Get the View Key
               ViewKey key = InputReader.GetViewKey( );

         // Create the View Criteria and the flag to retrieve all the properties
               ViewCriteria criteria = new ViewCriteria();;
               criteria.setRetrieveAll( true );

         // Now get the view
               beginAPICall( );
               View view = viewMan.findByKey( getControlStructObject(), key, criteria );
               endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the view information
               OutputWriter.PrintView( "", "View Information:", view );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Get View STatus", statusList );


      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }


   void getListVUI( ){
      try{

         OutputWriter.DriverPrintHeader( "GET LIST VIEW" );

         ViewFactory viewMan = ViewFactory.getFactory( );

         // Create the View Criteria and the flag to retrieve all the properties
               ViewCriteria criteria = new ViewCriteria( );
                criteria.setRetrieveAll( true );

         // Get the View List Criteria
               ViewListCriteria listCriteria = InputReader.GetViewListCriteria( );

         // Now get the view
               beginAPICall( );
               View[] viewsList = viewMan.findObjects( getControlStructObject(), listCriteria, criteria );
               endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the all views information
               OutputWriter.PrintViewList( "", "Views Information:", viewsList );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "GetListView status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
                    endAPICall( getControlStructObject().getLastStatus( ) );
                   OutputWriter.PrintARException( e );
      }
   }


   void setVUI( ){
      try{

         OutputWriter.DriverPrintHeader( "SET VIEW" );

         ViewFactory viewMan = ViewFactory.getFactory( );

         // Create a new view instance
               View view = ( View )viewMan.newInstance( );

         // Set the context
               view.setContext( getControlStructObject() );

         // Get and set the schema name
               NameID name = InputReader.GetNameID( "Schema Name" );
               view.setSchemaName(  name );

         // Get and Set the VUI id
               FieldID id = InputReader.GetVUIID( " VUI id (1): ", 1 );
               view.setVUIId( id );

         // Get and set the VUI name
               if( InputReader.GetBooleanForChangingInfo( "Change VUI name? (F): ", false ) )
               {
                  NameID vuiName = InputReader.GetNameID( "VUI name" );
                  view.setName(  vuiName );
               }

          // Get and Set the locale
               if (InputReader.GetBooleanForChangingInfo("Change Locale? (F): ", false))
              {
                  view.setLocale( InputReader.GetString("Locale(): ", "") );
              }

          // Get and Set the type
               if (InputReader.GetBooleanForChangingInfo("Change VUI-Type? (F): ", false))
              {
                  view.setVUIType( InputReader.GetInt( "VUI-Type (0): ", 0 ) );
              }

         // Get and set the properties
               if( InputReader.GetBooleanForChangingInfo( "Have new Prop List Info? (F): ", false ) )
               {
                  PropInfo[] properties = InputReader.GetPropInfoList( );
                  view.setDisplayProperties( properties );
               }

         // Get and set help text
               if( InputReader.GetBooleanForChangingInfo( "Change Help Text? (F): ", false ) )
               {
                  String helpText = InputReader.GetString( "Help Text:", "" );
                  view.setHelpText( helpText );
               }

         // Get and Set owner
               if( InputReader.GetBooleanForChangingInfo( "Change Owner? (F): ", false ) )
               {
                  AccessNameID owner = InputReader.GetAccessNameID( "Owner"  );
                  view.setOwner( owner );
               }

         // Get and set the change diary
               if( InputReader.GetBooleanForChangingInfo( "Add to Change Diary? (F): ", false ) )
               {
                  String changeDiary = InputReader.GetString( "Change Diary (): ", "" );
                  view.setDiary( changeDiary );
               }

         // Now store the new view properties
              beginAPICall( );
              view.store( );
              endAPICall( getControlStructObject().getLastStatus( ) );

         // release the view instance
               viewMan.releaseInstance( view );


         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set View status", statusList );


      }

      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
                    endAPICall( getControlStructObject().getLastStatus( ) );
                   OutputWriter.PrintARException( e );
      }
   }


   void createActiveLink( )
   {
      try{
         OutputWriter.DriverPrintHeader( "CREATE ACTIVE LINK" );

         ActiveLinkFactory activeLinkFactory = ActiveLinkFactory.getFactory( );

         // Create a new activelink instance
               ActiveLink activeLink = ( ActiveLink )activeLinkFactory.newInstance( );

         // Get and Set the activelink name
               NameID name = InputReader.GetNameID( "Active link Name" );
               activeLink.setName( name );

         // Get and Set the Execution order
               long order = InputReader.GetLong( "Execution order (1-1000) (1):", 1 );
               activeLink.setOrder( order );

         // Get and Set Workflow information
               WorkflowConnectInfo workFlowInfo = InputReader.GetWorkflowConnectInfo( );
               activeLink.setWorkflowConnect( workFlowInfo );

         // Get and set ids ofgroups allowed to perform the active link
               OutputWriter.DriverPrintPrompt( "Ids of groups allowed to perform active link:\n" );
               InternalID[] idList = InputReader.GetInternalIDList( );
               activeLink.setGroupList( idList );

         // Get and Set the Execution mask
               long executeMask = InputReader.GetLong( "Execution bit mask (1):", 1 );
               activeLink.setExecuteMask( executeMask );

         // Get and Set the Control field
               long controlField = InputReader.GetLong( "Control Field to tie active link to (0):", 0 );
               activeLink.setControlField( controlField );

         // Get and Set the focus field
               long focusField = InputReader.GetLong( "Focus Field to tie active link to (0):", 0 );
               activeLink.setFocusField( focusField );

         // Get and Set the enable flag
               long enable = InputReader.GetLong( "Disable/Enable (0-1) (1):", 1 );
               activeLink.setEnable( enable );

         // Get and Set the QualifierInfo
               QualifierInfo qualifier = InputReader.GetQualifierInfo( );
               activeLink.setQualifier( qualifier );

         // Get and Set the action information
               ActiveLinkActionInfo[] actionList = InputReader.GetActiveLinkActionInfoList( true );
               activeLink.setActionList( actionList );

         // Get and Set the else action list
               ActiveLinkActionInfo[] elseActionList = InputReader.GetActiveLinkActionInfoList( false );
               activeLink.setElseList( elseActionList );

         // Get and set the help text
               String helpText = InputReader.GetString( "Help Text ():", "" );
               activeLink.setHelpText( helpText );

         // Get and Set the owner
               AccessNameID owner = InputReader.GetAccessNameID( "Owner" );
               activeLink.setOwner( owner );

         // Get and Set change diary
               String diary = InputReader.GetString( "Change Diary ():", "" );
               activeLink.setDiary( diary );

         // Get and set properties
               PropInfo[] propList = InputReader.GetPropInfoList( );
               activeLink.setObjPropList( propList );

         // Set the context
               activeLink.setContext( getControlStructObject() );

         // Now create the activelink in the database
               beginAPICall( );
               activeLink.create( );
              endAPICall( getControlStructObject().getLastStatus( ) );

         // release the activelink instance
               activeLinkFactory.releaseInstance( activeLink );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Create Active Link Status", statusList );


      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
                    endAPICall( getControlStructObject().getLastStatus( ) );
                   OutputWriter.PrintARException( e );
      }

   }

   void deleteActiveLink( ){
      try{

         OutputWriter.DriverPrintHeader( "DELETE ACTIVELINK" );

         ActiveLinkFactory activeLinkFactory = ActiveLinkFactory.getFactory( );

         // Create a new activelink instance
               ActiveLink activeLink = ( ActiveLink )activeLinkFactory.newInstance( );

         // Set the context
               activeLink.setContext( getControlStructObject() );

         // Get and set the activelink name  to be deleted
               NameID name = InputReader.GetNameID( "Active link name" );
               activeLink.setName( name );

         // Now delete the active link
               beginAPICall( );
               activeLink.remove( );
              endAPICall( getControlStructObject().getLastStatus( ) );

         // release the view instance
               activeLinkFactory.releaseInstance( activeLink );


         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Delete Active Link Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
                    endAPICall( getControlStructObject().getLastStatus( ) );
                   OutputWriter.PrintARException( e );
      }
   }

   void getActiveLink( ){
      try{

         OutputWriter.DriverPrintHeader( "GET ACTIVELINK" );

         ActiveLinkFactory activeLinkFactory = ActiveLinkFactory.getFactory( );

         // Get the Active link key
               ActiveLinkKey key = InputReader.GetActiveLinkKey( );

         // Create an Active link criteria and set the flag to retrieve all the properties
               ActiveLinkCriteria criteria = new ActiveLinkCriteria( );
               criteria.setRetrieveAll( true );

         // Now get the active link
               beginAPICall( );
               ActiveLink activeLink = activeLinkFactory.findByKey( getControlStructObject(), key, criteria );
              endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the active link information
               OutputWriter.PrintActiveLink( "", "Active Link:", activeLink );


         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Get Active Link Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
                    endAPICall( getControlStructObject().getLastStatus( ) );
                   OutputWriter.PrintARException( e );
      }
   }

   void getListActiveLink( ){
      try{

         OutputWriter.DriverPrintHeader( "GET ACTIVELINK LIST" );

         ActiveLinkFactory activeLinkFactory = ActiveLinkFactory.getFactory( );

         // Create an Active link criteria and set the flag to retrieve all the properties
               ActiveLinkCriteria criteria = new ActiveLinkCriteria( );
               criteria.setRetrieveAll( true );

         // Now create the workflow Object list criteria
               WorkflowObjectListCriteria listCriteria = InputReader.GetWorkflowObjectListCriteria( );

         // Now get the active links list
              beginAPICall( );
              ActiveLink[] activeLinkList = activeLinkFactory.findObjects(getControlStructObject(), listCriteria, criteria );

              endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the active link information
               OutputWriter.PrintActiveLinkList( "", "Active Link List:", activeLinkList );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Get Active Link List Status", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void setActiveLink( )
   {
      try{
         OutputWriter.DriverPrintHeader( "SET ACTIVE LINK" );

         ActiveLinkFactory activeLinkFactory = ActiveLinkFactory.getFactory( );

         // Create a new activelink instance
               ActiveLink activeLink = ( ActiveLink )activeLinkFactory.newInstance( );

            // Get and Set the activelink name
               NameID name = InputReader.GetNameID( "Active link Name" );
               activeLink.setName( name  );

         // Get and Set the activelink new name
               if( InputReader.GetBooleanForChangingInfo( "Change active link name? (F): ", false ) )
               {
                  NameID newName = InputReader.GetNameID( "New Name" );
                  activeLink.setNewName( newName );
               }

         // Get and Set the Execution order
               if( InputReader.GetBooleanForChangingInfo( "Change execution order? (F): ", false ) )
               {
                  long order = InputReader.GetLong( "Execution order (1-1000) (1):", 1 );
                  activeLink.setOrder( order );
               }

         // Get and Set Workflow information
               if( InputReader.GetBooleanForChangingInfo( "Change Work Flow information? (F): ", false ) )
               {
                  int type = InputReader.GetInt( "Workflow Type (1):", 1 );
                  NameID[] schemas = null;

                  if( (type == Constants.AR_WORKFLOW_CONN_SCHEMA_LIST ) &&
                       InputReader.GetBooleanForChangingInfo( "Change schemaList? (F): ", false ) )
                  {
                     int  numberOfSchemas = InputReader.GetInt( "Number of schemas (1):", 1 );
                     if( numberOfSchemas != 0 )
                     {
                           schemas = new NameID[ numberOfSchemas ];
                           for( int i = 0; i < numberOfSchemas; i++ )
                           {
                              schemas[ i] = InputReader.GetNameID( "Schema Name " + i );
                           }
                     }
                  }
                  WorkflowConnectInfo workflow = new WorkflowConnectInfo( );

                  workflow.setType( type );
                  workflow.setSchemaList( schemas );

                  activeLink.setWorkflowConnect( workflow );
               }

         // Get and set ids ofgroups allowed to perform the active link
               if( InputReader.GetBooleanForChangingInfo( "Change group List? (F): ", false ) )
               {
                  OutputWriter.DriverPrintPrompt( "Ids of groups allowed to perform active link:\n" );
                  InternalID[] idList = InputReader.GetInternalIDList( );
                  activeLink.setGroupList( idList );
               }

         // Get and Set the Execution mask
               if( InputReader.GetBooleanForChangingInfo( "Change execute mask? (F): ", false ) )
               {
                  long executeMask = InputReader.GetLong( "Execution bit mask (1):", 1 );
                  activeLink.setExecuteMask( executeMask );
               }

         // Get and Set the Control field
               if( InputReader.GetBooleanForChangingInfo( "Change control field? (F): ", false ) )
               {
                  long controlField = InputReader.GetLong( "Control Field to tie active link to (0):", 0 );
                  activeLink.setControlField( controlField );
               }

         // Get and Set the focus field
               if( InputReader.GetBooleanForChangingInfo( "Change focus field? (F): ", false ) )
               {
                  long focusField = InputReader.GetLong( "Focus Field to tie active link to (0):", 0 );
                  activeLink.setFocusField( focusField );
               }

         // Get and Set the enable flag
               if( InputReader.GetBooleanForChangingInfo( "Change enable/disable? (F): ", false ) )
               {
                  long enable = InputReader.GetLong( "Disable/Enable (0-1) (1):", 1 );
                  activeLink.setEnable( enable );
               }

         // Get and Set the QualifierInfo
               if( InputReader.GetBooleanForChangingInfo( "Change query? (F): ", false ) )
               {
                  QualifierInfo qualifier = InputReader.GetQualifierInfo( );
                  activeLink.setQualifier( qualifier );
               }

         // Get and Set the action information
               if( InputReader.GetBooleanForChangingInfo( "Change actions? (F): ", false ) )
               {
                  ActiveLinkActionInfo[] actionList = InputReader.GetActiveLinkActionInfoList( true );
                  activeLink.setActionList( actionList );
               }

         // Get and Set the else action list
               if( InputReader.GetBooleanForChangingInfo( "Change actions? (F): ", false ) )
               {
                  ActiveLinkActionInfo[] elseActionList = InputReader.GetActiveLinkActionInfoList( false );
                  activeLink.setElseList( elseActionList );
               }

         // Get and set the help text
               if( InputReader.GetBooleanForChangingInfo( "Change help text? (F): ", false ) )
               {
                  String helpText = InputReader.GetString( "Help Text ():", "" );
                  activeLink.setHelpText( helpText );
               }

         // Get and Set the owner
               if( InputReader.GetBooleanForChangingInfo( "Change owner? (F): ", false ) )
               {
                  AccessNameID owner = InputReader.GetAccessNameID( "Owner" );
                  activeLink.setOwner( owner );
               }

         // Get and Set change diary
               if( InputReader.GetBooleanForChangingInfo( "Add to change diary? (F): ", false ) )
               {
                  String diary = InputReader.GetString( "Change Diary ():", "" );
                  activeLink.setDiary( diary );
               }

         // Get and set properties
               if( InputReader.GetBooleanForChangingInfo( "Change object properties? (F): ", false ) )
               {
                  PropInfo[] propList = InputReader.GetPropInfoList( );
                  activeLink.setObjPropList( propList );
               }

         // Set the context
               activeLink.setContext( getControlStructObject() );

         // Now store the new properties in the database
              beginAPICall( );
               activeLink.store( );
              endAPICall( getControlStructObject().getLastStatus( ) );

         // release the container instance
               activeLinkFactory.releaseInstance( activeLink );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set Active Link Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }



   void createFilter( )
   {
      try{
         OutputWriter.DriverPrintHeader( "CREATE FILTER" );

         FilterFactory filterFactory = FilterFactory.getFactory( );

         // Create a new filter instance
               Filter filter = ( Filter )filterFactory.newInstance( );

         // Get and Set the filter name
               NameID name = InputReader.GetNameID( "Filter Name" );
               filter.setName( name );

         // Get and Set the  order
               long order = InputReader.GetLong( "Filter order (0-1000) (500):", 500 );
               filter.setOrder( order );

         // Get and Set Workflow information
               WorkflowConnectInfo workFlowInfo = InputReader.GetWorkflowConnectInfo( );
               filter.setWorkflowConnect( workFlowInfo );

         // Get and Set the operations bit mask
               long bitMask = InputReader.GetLong( "Operation bit mask (0):", 0 );
               filter.setOpSet( bitMask );

         // Get and Set the enable flag
               long enable = InputReader.GetLong( "Disable/Enable (0-1) (1):", 1 );
               filter.setEnable( enable );

         // Get and Set the QualifierInfo
               QualifierInfo qualifier = InputReader.GetQualifierInfo( );
               filter.setQualifier( qualifier );

         // Get and Set the action information
               FilterActionInfo[] actionList = InputReader.GetFilterActionInfoList( true );
               filter.setActionList( actionList );

         // Get and Set the else action list
               FilterActionInfo[] elseActionList = InputReader.GetFilterActionInfoList( false );
               filter.setElseList( elseActionList );

         // Get and set the help text
               String helpText = InputReader.GetString( "Help Text ():", "" );
               filter.setHelpText( helpText );

         // Get and Set the owner
               AccessNameID owner = InputReader.GetAccessNameID( "Owner" );
               filter.setOwner( owner );

         // Get and Set change diary
               String diary = InputReader.GetString( "Change Diary ():", "" );
               filter.setDiary( diary );

         // Get and set properties
               PropInfo[] propList = InputReader.GetPropInfoList( );
               filter.setObjPropList( propList );

         // Set the context
               filter.setContext( getControlStructObject() );

         // Now create the filter in the database
              beginAPICall( );
               filter.create( );
              endAPICall( getControlStructObject().getLastStatus( ) );

         // release the filter instance
               filterFactory.releaseInstance( filter );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Create Filter Status", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void deleteFilter( ){
      try{

         OutputWriter.DriverPrintHeader( "DELETE FILTER" );

         FilterFactory filterFactory = FilterFactory.getFactory( );

         // Create a new filter instance
               Filter filter = ( Filter )filterFactory.newInstance( );

         // Set the context
               filter.setContext( getControlStructObject() );

         // Get and set the filter name  to be deleted
               NameID name = InputReader.GetNameID( "Filter name" );
               filter.setName( name );

         // Now delete the Filter
            beginAPICall( );
            filter.remove( );
            endAPICall( getControlStructObject().getLastStatus( ) );

         // release the view instance
               filterFactory.releaseInstance( filter );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Delete Filter Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }



   void getFilter( ){
      try{

         OutputWriter.DriverPrintHeader( "GET FILTER" );

         FilterFactory filterFactory = FilterFactory.getFactory( );

         // Get the Filter key
               FilterKey key = InputReader.GetFilterKey( );

         // Create  Filter criteria object and set the flag to retrieve all the properties
            FilterCriteria criteria = new FilterCriteria( );
            criteria.setRetrieveAll( true );

         // Now get the filter
            beginAPICall( );
            Filter filter = filterFactory.findByKey( getControlStructObject(), key, criteria );
            endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the Filter information
               OutputWriter.PrintFilter( "", "Filter:", filter );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Get Filter Status", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void getListFilter( ){
      try{

         OutputWriter.DriverPrintHeader( "GET FILTER LIST" );

         FilterFactory filterFactory = FilterFactory.getFactory( );

         // Create  Filter criteria object and set the flag to retrieve all the properties
             FilterCriteria criteria =  new FilterCriteria( );
             criteria.setRetrieveAll( true );

         // Now create the workflow Object list criteria
               WorkflowObjectListCriteria listCriteria = InputReader.GetWorkflowObjectListCriteria( );

         // Now get the Filters list
              beginAPICall( );
               Filter[] filterList = filterFactory.findObjects( getControlStructObject(), listCriteria, criteria );
              endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the Filter information
               OutputWriter.PrintFilterList( "", "Filter List:", filterList );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Get List Filter status", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }


   void setFilter( )
   {
      try{
         OutputWriter.DriverPrintHeader( "SET FILTER" );

         FilterFactory filterFactory = FilterFactory.getFactory( );

         // Create a new filter instance
               Filter filter = ( Filter )filterFactory.newInstance( );

         // Get and Set the filter name
               NameID name = InputReader.GetNameID( "Filter Name" );
               filter.setName( name );

         // Get and Set the filter new name
               if( InputReader.GetBooleanForChangingInfo( "Change filter name? (F): ", false ) )
               {
                  NameID newName = InputReader.GetNameID( "New Name" );
                  filter.setNewName( newName );
               }

         // Get and Set the  order
               if( InputReader.GetBooleanForChangingInfo( "Change filter order? (F): ", false ) )
               {
                  long order = InputReader.GetLong( "Filter order (1-1000) (500):", 500 );
                  filter.setOrder( order );
               }

         // Get and Set Workflow information
            WorkflowConnectInfo workflow = new WorkflowConnectInfo( );
            int type = InputReader.GetInt( "Workflow Type (1):", 1 );
            workflow.setType( type );

            if( (type == Constants.AR_WORKFLOW_CONN_SCHEMA_LIST ) &&
                    InputReader.GetBooleanForChangingInfo( "Change schemaList? (F): ", false ) )
            {
                int  numberOfSchemas = InputReader.GetInt( "Number of schemas (1):", 1 );
                NameID[] schemas = null;
                if( numberOfSchemas != 0 )
                {
                    schemas = new NameID[ numberOfSchemas ];
                    for( int i = 0; i < numberOfSchemas; i++ )
                    {
                        schemas[ i] = InputReader.GetNameID( "Schema Name " + i );
                    }
                }
                workflow.setSchemaList( schemas );
             }

             filter.setWorkflowConnect( workflow );

         // Get and Set the operations bit mask
               if( InputReader.GetBooleanForChangingInfo( "Change operations mask? (F): ", false ) )
               {
                  long bitMask = InputReader.GetLong( "Operation bit mask (0):",0 );
                  filter.setOpSet( bitMask );
               }

         // Get and Set the enable flag
               if( InputReader.GetBooleanForChangingInfo( "Change enable/disable? (F): ", false ) )
               {
                  long enable = InputReader.GetLong( "Disable/Enable (0-1) (1):", 1 );
                  filter.setEnable( enable );
               }

         // Get and Set the QualifierInfo
               if( InputReader.GetBooleanForChangingInfo( "Change Query? (F): ", false ) )
               {
                  QualifierInfo qualifier = InputReader.GetQualifierInfo( );
                  filter.setQualifier( qualifier );
               }

         // Get and Set the action information
               if( InputReader.GetBooleanForChangingInfo( "Change action(s)? (F): ", false ) )
               {
                  FilterActionInfo[] actionList = InputReader.GetFilterActionInfoList( true );
                  filter.setActionList( actionList );
               }

         // Get and Set the else action list
               if( InputReader.GetBooleanForChangingInfo( "Change else(s)? (F): ", false ) )
               {
                  FilterActionInfo[] elseActionList = InputReader.GetFilterActionInfoList( false );
                  filter.setElseList( elseActionList );
               }

         // Get and set the help text
               if( InputReader.GetBooleanForChangingInfo( "Change help text? (F): ", false ) )
               {
                  String helpText = InputReader.GetString( "Help Text ():", "" );
                  filter.setHelpText( helpText );
               }

         // Get and Set the owner
               if( InputReader.GetBooleanForChangingInfo( "Change owner? (F): ", false ) )
               {
                  AccessNameID owner = InputReader.GetAccessNameID( "Owner" );
                  filter.setOwner(  owner );
               }

         // Get and Set change diary
               if( InputReader.GetBooleanForChangingInfo( "Add to Change Diary? (F): ", false ) )
               {
                  String diary = InputReader.GetString( "Change Diary (): ", "" );
                  filter.setDiary( diary );
               }

         // Get and set properties
               if( InputReader.GetBooleanForChangingInfo( "Change object properties? (F): ", false ) )
               {
                  PropInfo[] propList = InputReader.GetPropInfoList( );
                  filter.setObjPropList( propList );
               }

         // Set the context
               filter.setContext( getControlStructObject() );

         // Now create the filter in the database
              beginAPICall( );
               filter.store( );
              endAPICall( getControlStructObject().getLastStatus( ) );


         // release the filter instance
               filterFactory.releaseInstance( filter );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set Filter Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }



   void createEscalation( )
   {
      try{
         OutputWriter.DriverPrintHeader( "CREATE ESCALATION" );

         EscalationFactory escalationFactory = EscalationFactory.getFactory( );

         // Create a new escalation instance
               Escalation escalation = ( Escalation )escalationFactory.newInstance( );

         // Get and Set the escalation name
               NameID name = InputReader.GetNameID( "Escalation Name" );
               escalation.setName( name );

         // Get and Set the  Time information
               EscalationTmInfo timeInfo = InputReader.GetEsclationTmInfo( );
               escalation.setEscalationTm( timeInfo );

         // Get and Set Workflow information
               WorkflowConnectInfo workFlowInfo = InputReader.GetWorkflowConnectInfo( );
               escalation.setWorkflowConnect( workFlowInfo );

         // Get and Set the enable flag
               long enable = InputReader.GetLong( "Disable/Enable (0-1) (1):", 1 );
               escalation.setEnable( enable );

         // Get and Set the QualifierInfo
               QualifierInfo qualifier = InputReader.GetQualifierInfo( );
               escalation.setQualifier( qualifier );

         // Get and Set the action information
               FilterActionInfo[] actionList = InputReader.GetFilterActionInfoList( true );
               escalation.setActionList( actionList );

         // Get and Set the else action list
               FilterActionInfo[] elseActionList = InputReader.GetFilterActionInfoList( false );
               escalation.setElseList( elseActionList );

         // Get and set the help text
               String helpText = InputReader.GetString( "Help Text ():", "" );
               escalation.setHelpText( helpText );

         // Get and Set the owner
               AccessNameID owner = InputReader.GetAccessNameID( "Owner" );
               escalation.setOwner( owner );

         // Get and Set change diary
               String diary = InputReader.GetString( "Change Diary (): ", "" );
               escalation.setDiary( diary );

         // Get and set properties
               PropInfo[] propList = InputReader.GetPropInfoList( );
               escalation.setObjPropList( propList );

         // Set the context
               escalation.setContext( getControlStructObject() );

         // Now create the escalation in the database
               beginAPICall( );
               escalation.create( );
              endAPICall( getControlStructObject().getLastStatus( ) );

         // release the escalation instance
               escalationFactory.releaseInstance( escalation );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Create Escalation status", statusList );


      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }



   void deleteEscalation( )
   {
      try{
         OutputWriter.DriverPrintHeader( "DELETE ESCALATION" );

         EscalationFactory escalationFactory = EscalationFactory.getFactory( );

         // Create a new escalation instance
               Escalation escalation = ( Escalation )escalationFactory.newInstance( );

         // Get and Set the escalation name
               NameID name = InputReader.GetNameID( "Escalation Name" );
               escalation.setName( name );

         // Set the context
               escalation.setContext( getControlStructObject() );

         // Now delete the escalation from the database
             beginAPICall( );
             escalation.remove( );
             endAPICall( getControlStructObject().getLastStatus( ) );


         // release the escalation instance
               escalationFactory.releaseInstance( escalation );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Delete Escalation Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void getEscalation( )
   {
      try{
         OutputWriter.DriverPrintHeader( "GET ESCALATION" );

         EscalationFactory escalationFactory = EscalationFactory.getFactory( );

         // Create a  escalation Key
               EscalationKey key = InputReader.GetEscalationKey( );

         // Create a Escalation Criteria object set the flag to retrieve all the properties
            EscalationCriteria criteria = new EscalationCriteria( );
            criteria.setRetrieveAll( true );

         // Get the escalation now
            beginAPICall( );
            Escalation escalation = escalationFactory.findByKey( getControlStructObject(), key, criteria );             endAPICall( getControlStructObject().getLastStatus( ) );

         // print the esclation data
               OutputWriter.PrintEscalation( "", "Esclation Data:", escalation );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Get Escalation Status", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }


   void getListEscalation( )
   {
      try{
         OutputWriter.DriverPrintHeader( "GET LIST ESCALATION" );

         EscalationFactory escalationFactory = EscalationFactory.getFactory( );

         // Create a Escalation Criteria object set the flag to retrieve all the properties
            EscalationCriteria criteria =  new EscalationCriteria( );
            criteria.setRetrieveAll( true );

         // Create a WorkflowObjectList Criteria object
               WorkflowObjectListCriteria listCriteria = InputReader.GetWorkflowObjectListCriteria( );

         // Get the escalations now
               beginAPICall( );
               Escalation[] escalationList = escalationFactory.findObjects( getControlStructObject(), listCriteria, criteria );
              endAPICall( getControlStructObject().getLastStatus( ) );

         // print the esclation data
               OutputWriter.PrintEscalationList( "", "Esclation Data:", escalationList );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "GetListEscalation status", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }



   void setEscalation( )
   {
      try{
         OutputWriter.DriverPrintHeader("SET ESCALATION");

         EscalationFactory escalationFactory = EscalationFactory.getFactory( );

         // Create a new escalation instance
               Escalation escalation = ( Escalation )escalationFactory.newInstance( );

         // Get and Set the escalation name
               NameID name = InputReader.GetNameID( "Escalation Name" );
               escalation.setName( name );

         // Get and Set the escalation new name
               if( InputReader.GetBooleanForChangingInfo( "Change escalation name? (F): ", false ) )
               {
                  NameID newName = InputReader.GetNameID( "New Name" );
                  escalation.setNewName(  newName );
               }

         // Get and Set the  order
               if( InputReader.GetBooleanForChangingInfo( "Change escalation Time? (F): ", false ) )
               {
                  EscalationTmInfo timeInfo = InputReader.GetEsclationTmInfo( );
                  escalation.setEscalationTm( timeInfo );
               }

         // Get and Set Workflow information
               if( InputReader.GetBooleanForChangingInfo( "Change Work Flow information? (F): ", false ) )
               {
                  int type = InputReader.GetInt( "Workflow Type (1):", 1 );
                  NameID[] schemas = null;
                  if( InputReader.GetBooleanForChangingInfo( "Change schemaList? (F): ", false ) )
                  {
                     int  numberOfSchemas = InputReader.GetInt( "Number of schemas (1):", 1 );
                     if( numberOfSchemas != 0 )
                     {
                           schemas = new NameID[ numberOfSchemas ];
                           for( int i = 0; i < numberOfSchemas; i++ )
                           {
                              schemas[ i] = InputReader.GetNameID( "Schema Name " + i );
                           }
                     }
                  }
                  WorkflowConnectInfo workflow = new WorkflowConnectInfo( );

                  workflow.setType( type );
                  workflow.setSchemaList( schemas );

                  escalation.setWorkflowConnect( workflow );
               }


         // Get and Set the enable flag
               if( InputReader.GetBooleanForChangingInfo( "Change enable/disable? (F): ", false ) )
               {
                  long enable = InputReader.GetLong( "Disable/Enable (0-1) (1):", 1 );
                  escalation.setEnable( enable );
               }

         // Get and Set the QualifierInfo
               if( InputReader.GetBooleanForChangingInfo( "Change Query? (F): ", false ) )
               {
                  QualifierInfo qualifier = InputReader.GetQualifierInfo( );
                  escalation.setQualifier( qualifier );
               }

         // Get and Set the action information
               if( InputReader.GetBooleanForChangingInfo( "Change action(s)? (F): ", false ) )
               {
                  FilterActionInfo[] actionList = InputReader.GetFilterActionInfoList( true );
                  escalation.setActionList( actionList );
               }

         // Get and Set the else action list
               if( InputReader.GetBooleanForChangingInfo( "Change else(s)? (F): ", false ) )
               {
                  FilterActionInfo[] elseActionList = InputReader.GetFilterActionInfoList( false );
                  escalation.setElseList( elseActionList );
               }

         // Get and set the help text
               if( InputReader.GetBooleanForChangingInfo( "Change help text? (F): ", false ) )
               {
                  String helpText = InputReader.GetString( "Help Text (): ", "" );
                  escalation.setHelpText( helpText );
               }

         // Get and Set the owner
               if( InputReader.GetBooleanForChangingInfo( "Change owner? (F): ", false ) )
               {
                  AccessNameID owner = InputReader.GetAccessNameID( "Owner" );
                  escalation.setOwner(  owner  );
               }

         // Get and Set change diary
               if( InputReader.GetBooleanForChangingInfo( "Add to Change Diary? (F): ", false ) )
               {
                  String diary = InputReader.GetString( "Change Diary (): ", "" );
                  escalation.setDiary( diary );
               }

         // Get and set properties
               if( InputReader.GetBooleanForChangingInfo( "Change object properties? (F): ", false ) )
               {
                  PropInfo[] propList = InputReader.GetPropInfoList( );
                  escalation.setObjPropList( propList );
               }

         // Set the context
               escalation.setContext( getControlStructObject() );

         // Now store the new properties in the database
               beginAPICall( );
               escalation.store( );
              endAPICall( getControlStructObject().getLastStatus( ) );

         // release the escalation instance
               escalationFactory.releaseInstance( escalation );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set Escalation Status", statusList );


      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }



   void createSupportFile( )
   {
      try{
         OutputWriter.DriverPrintHeader( "CREATE SUPPORT FILE" );

         SupportFileFactory factory = SupportFileFactory.getFactory( );

         // Create an instance of a Support File
            SupportFile supportFile = ( SupportFile )factory.newInstance( );

         // Get and Set Support File key
            SupportFileKey key = InputReader.GetSupportFileKey( );
            supportFile.setKey( key );

         // Get and set the file name
            String fileName = InputReader.GetString( "File name ():", "" );
            supportFile.setFilePath( fileName );

         // Set the context
            supportFile.setContext( getControlStructObject() );

         // Create the support file
            beginAPICall( );
            supportFile.create( );
            endAPICall( getControlStructObject().getLastStatus( ) );

         // Release the instance
            factory.releaseInstance( supportFile );


         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Create Support File Status", statusList );       }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
          endAPICall( getControlStructObject().getLastStatus( ) );
          OutputWriter.PrintARException( e );
      }
   }

   void deleteSupportFile( )
   {
      try{
         OutputWriter.DriverPrintHeader( "DELETE SUPPORT FILE" );

         SupportFileFactory factory = SupportFileFactory.getFactory( );

         // Create an instance of a Support File
            SupportFile supportFile = ( SupportFile )factory.newInstance( );

         // Get and Set Support File key
            SupportFileKey key = InputReader.GetSupportFileKey( );
            supportFile.setKey( key );

         // Set the context
            supportFile.setContext( getControlStructObject() );

         // delete the support file
            beginAPICall( );
            supportFile.remove( );
            endAPICall( getControlStructObject().getLastStatus( ) );

         // Release the instance
            factory.releaseInstance( supportFile );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Delete Support File Status", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void getSupportFile( )
   {
      try{
         OutputWriter.DriverPrintHeader( "GET SUPPORT FILE" );

      SupportFileFactory supportFileMan = SupportFileFactory.getFactory();

      SupportFileKey key = InputReader.GetSupportFileKey( );

      String  fileName = InputReader.GetString("Filename to hold returned file: ", "");
      SupportFileCriteria crit = new SupportFileCriteria();
      crit.setRetrieveAll(true);

      beginAPICall( );
      SupportFile supportFile = ( SupportFile )supportFileMan.findByKey(getControlStructObject(), key, crit);
      endAPICall( getControlStructObject().getLastStatus( ) );

      // print the SupportFile data
         OutputWriter.PrintSupportFile( "", "SupportFile Data:", supportFile );

      // Store the support file data in the given location
         if( supportFile != null )
         {
            String tempPath = supportFile.getFilePath( );
            String contents = InputReader.GetFileContents( tempPath );
            FileWriter newFp = new FileWriter( tempPath );
            newFp.write( contents, 0, contents.length( ) );
         }
      // Release the instance
         supportFileMan.releaseInstance( supportFile );

      // Success. Print the status
         StatusInfo[] statusList = getControlStructObject().getLastStatus( );
         OutputWriter.PrintStatusInfoList( "", "Get Support File Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void setSupportFile( )
   {
      try{
         OutputWriter.DriverPrintHeader( "SET SUPPORT FILE" );

         SupportFileFactory factory = SupportFileFactory.getFactory( );

         // Create an instance of a Support File
               SupportFile supportFile = ( SupportFile )factory.newInstance( );

         // Get and Set Support File key
               SupportFileKey key = InputReader.GetSupportFileKey( );
               supportFile.setKey( key );

         // Get and set the file name
               String fileName = InputReader.GetString( "File name to load to server():", "" );
               supportFile.setFilePath( fileName );

         // Set the context
               supportFile.setContext( getControlStructObject() );

         // Create the support file
               beginAPICall( );
               supportFile.store( );
              endAPICall( getControlStructObject().getLastStatus( ) );

         // Release the instance
               factory.releaseInstance( supportFile );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set SupportFile Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void getListSupportFile( )
   {
      try{
         OutputWriter.DriverPrintHeader( "GET List SUPPORT FILE" );

         SupportFileFactory factory = SupportFileFactory.getFactory( );


         // Get the SupportfileListCriteria
            SupportFileListCriteria  listCriteria = InputReader.GetSupportFileListCriteria( );

         // Get the supportfileCriteria
               SupportFileCriteria  criteria = new SupportFileCriteria();
               criteria.setRetrieveAll(true);

         // Get the list of support files
               beginAPICall( );
               SupportFile[] fileList = factory.findObjects( getControlStructObject(), listCriteria, criteria );
               endAPICall( getControlStructObject().getLastStatus( ) );

         // Now print the support files
               OutputWriter.PrintSupportFileList( "", "Support Files:", fileList );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Get List SupportFile STatus", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
                    endAPICall( getControlStructObject().getLastStatus( ) );
                   OutputWriter.PrintARException( e );
      }
   }

   void getListGroup( ){
      try{

         OutputWriter.DriverPrintHeader( "GET LIST GROUP" );

         AccessNameID user = null;
         AccessNameID password = null;
         if( InputReader.GetBooleanForChangingInfo( "For a specific user? (F): ", false ) )
         {
               user = InputReader.GetAccessNameID( "Name of the user" );
               password = InputReader.GetAccessNameID( "Password of the User" );
         }

         // Get the Group list
               beginAPICall( );
               GroupInfo[] groupList = Util.ARGetListGroup( getControlStructObject(), user, password );
               endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the group Information
               OutputWriter.PrintGroupInfoList( "", "ARGetListGroup Results:", groupList );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARGetListGroup Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void getListRole( )
   {
      try{

         OutputWriter.DriverPrintHeader( "GET LIST ROLE" );
         NameID application = null;
         AccessNameID user = null;
         AccessNameID password = null;

         application = InputReader.GetNameID();

         if( InputReader.GetBooleanForChangingInfo( "For a specific user? (F): ", false ) )
         {
               user = InputReader.GetAccessNameID( "Name of the user" );
               password = InputReader.GetAccessNameID( "Password of the User" );
         }

         // Get the Role list
               beginAPICall( );
               RoleInfo[] roleList = Util.ARGetListRole( getControlStructObject(), application, user, password );
               endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the role Information
               OutputWriter.PrintRoleInfoList( "", "ARGetListRole Results:", roleList );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARGetListGroup Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void getListUser( ){
      try{

         OutputWriter.DriverPrintHeader( "GET LIST USER" );

         // Get the type
               int type = InputReader.GetInt( "User List Type (myself, registered or current (0-2)(1): ", 1 );

         // Get the changed since parameter
               Timestamp changedSince = InputReader.GetTimestamp( "Get registered users changed since (0 means all) ", new Timestamp( ) );

         // Get the Users information
               beginAPICall( );
               UserInfo[] userList = Util.ARGetListUser( getControlStructObject(), type, changedSince );
               endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the group Information
               OutputWriter.PrintUserInfoList( "", "    ARGetListUser Results:", userList );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARGetListUser Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }


   void getListServer( ){
      try{

         OutputWriter.DriverPrintHeader( "GET LIST SERVER" );

         // Get the Servers list
               beginAPICall( );
               ServerNameID[] serverList = Util.ARGetListServer( getControlStructObject() );
               endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the servers names
               OutputWriter.PrintServerNameIDList( "", "    ARGetListServer Results:", serverList );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "    ARGetListServer Status", statusList );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
                    endAPICall( getControlStructObject().getLastStatus( ) );
                   OutputWriter.PrintARException( e );
      }
   }


   void getServerInfo( ){
      try{

         OutputWriter.DriverPrintHeader( "GET SERVER INFO" );

         // Get the request list
               int[] requestList = null;


         int total = InputReader.GetInt( "Number of server info operations (0): ", 0 );
         if( total > 0 )
         {
             requestList = new int[total];
             for( int j = 0; j < total; j++ )
             {
                 requestList[j] = InputReader.GetInt( "   Operation (1-" + Constants.AR_MAX_SERVER_INFO_USED + ") (1): ", 1 );
             }
         }

         // Get the Server information
               beginAPICall( );
               ServerInfo[] serverInfoList = Util.ARGetServerInfo( getControlStructObject(), requestList );
               endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the server information
               OutputWriter.PrintServerInfoList( "", "    ARGetServerInfo Results:", serverInfoList );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "    ARGetServerInfo Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
                    endAPICall( getControlStructObject().getLastStatus( ) );
                   OutputWriter.PrintARException( e );
      }
   }

   void setServerInfo( ){
      try{

         OutputWriter.DriverPrintHeader( "SET SERVER INFO" );

         // Get the Server information
               ServerInfo[] serverInfoList = InputReader.GetServerInfoList( );

         // Call ARSetServerInfo method
               beginAPICall( );
               Util.ARSetServerInfo( getControlStructObject(), serverInfoList );
               endAPICall( getControlStructObject().getLastStatus( ) );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set Server Information Status", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
                    endAPICall( getControlStructObject().getLastStatus( ) );
                   OutputWriter.PrintARException( e );
      }
   }

   void setServerPort( ){
      try{

         OutputWriter.DriverPrintHeader( "SET SERVER PORT" );

         // Get the Server information
             ARServerUser tempContext = getControlStructObject( );
             NameID serverName = null;
             if( tempContext != null )
             {
                 serverName = new NameID( tempContext.getServer() );
             }

         // Get the port number
               int portNumber = InputReader.GetInt( "The port number of server (0):", 0 );

         // Get the rpc number
               int progNumber = InputReader.GetInt( "The RPC program number of Server (0):", 0 );

         // Call ARSetServerPort method
               beginAPICall( );
               Util.ARSetServerPort( getControlStructObject(), serverName, portNumber, progNumber );
               endAPICall( getControlStructObject().getLastStatus( ) );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set Server Port Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
                    endAPICall( getControlStructObject().getLastStatus( ) );
                   OutputWriter.PrintARException( e );
      }
   }
   void export( ){
      try{

         OutputWriter.DriverPrintHeader( "ARExport" );

         // Get the items
               StructItemInfo[] items = InputReader.GetStructItemInfoList( );

         // If exporting any VIEWs, prompt for the display tag and vui-type
            NameID displayTag = null;
            int vuiType = 0;

            WorkflowLockInfo lockInfo = InputReader.GetWorkflowLockInfo( );
            if( items != null )
            {
                for( int i = 0; i < items.length; i++ )
               {
                     if( items[i].getType( ) == StructItemInfo.SCHEMA_VIEW ||
                         items[i].getType( ) == StructItemInfo.VUI_2)
                     {
                           displayTag = InputReader.GetNameID( "Display Tag" );
                           vuiType = InputReader.GetInt("VUI- Type (0): ", 0);
                           break;
                     }
               }
            }

           String fileName = InputReader.GetString( "Filename for exported data: ", "");

           FileWriter fp = new FileWriter( fileName );

         // Call the ARExport method
               beginAPICall( );
               String definitionText = Util.ARExport( getControlStructObject(), items, displayTag, vuiType, lockInfo );
               endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the information in the file
               if( definitionText != null )
               {
                   fp.write( definitionText );
                   fp.flush( );
               }
               fp.close( );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARExport Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
                    endAPICall( getControlStructObject().getLastStatus( ) );
                   OutputWriter.PrintARException( e );
      }
   }

   void getServerStatistics( ){
      try{

         OutputWriter.DriverPrintHeader( "GET SERVER STATISTICS" );

         // Get the number of serverInfo operations
               int numberOfOperations = InputReader.GetInt( "Number Of server info Operations (0):", 0 );

         // Get the operations
               int[] requestList = null;
               if( numberOfOperations != 0 )
               {
                  requestList = new int[ numberOfOperations ];

                  for( int i = 0; i < numberOfOperations; i++ )
                  {
                     requestList[i] = InputReader.GetInt( "Operation (1-" +                                                     Constants.AR_MAX_SERVER_STAT_USED + " ):", 1 );
                  }
               }

         // Call the ARGetServerStatistics method
               beginAPICall( );
               ServerInfo[] serverInfoList = Util.ARGetServerStatistics( getControlStructObject(), requestList );
               endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the information
               OutputWriter.PrintString( "ARGetServerStatistics RESULTS\n" );
               OutputWriter.PrintServerInfoList( "", "Server Information", serverInfoList );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARGetServerStatistics Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
                    endAPICall( getControlStructObject().getLastStatus( ) );
                   OutputWriter.PrintARException( e );
      }
   }


   void executeProcess( ){
      try{

         OutputWriter.DriverPrintHeader( "EXECUTE PROCESS" );

         // Get the command
               String command = InputReader.GetString( "Command:", "" );

         // Get the flag whether to wait for the process or not
               boolean waitFlag = InputReader.GetBooleanForChangingInfo( "Wait For process to complete (F): ", false );

         // Call the ARExecuteProcess Method
               beginAPICall( );
               ProcessResult result = Util.ARExecuteProcess( getControlStructObject(), command, waitFlag );
              endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the result
               OutputWriter.PrintProcessResult( "", "ARExecuteProcess RESULTS:", result );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ExecuteProcess Status", statusList );


      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
                    endAPICall( getControlStructObject().getLastStatus( ) );
                   OutputWriter.PrintARException( e );
      }
   }

   void getFullTextInfo( ){
      try{

         OutputWriter.DriverPrintHeader( "GET FULL TEXT INFO" );

         // Get the number of FTS Opeations
               int numberOfOperations = InputReader.GetInt( "    Number Of fulltext info types (0)", 0 );

         // Get the operations
               int[] requestList = null;
               if( numberOfOperations != 0 )
               {
                  requestList = new int[ numberOfOperations ];

                  for( int i = 0; i < numberOfOperations; i++ )
                  {
                     requestList[i] = InputReader.GetInt( "    InfoType (1-6):", 1 );
                  }
               }

         // Call the ARGetFullTextInfo method
               beginAPICall( );
               FullTextInfo[] fullTextInfoList = Util.ARGetFullTextInfo( getControlStructObject(), requestList );
              endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the information
               OutputWriter.PrintFullTextInfoList( "", "ARFullTextInfo RESULTS", fullTextInfoList );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARFullTextInfo Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
                    endAPICall( getControlStructObject().getLastStatus( ) );
                   OutputWriter.PrintARException( e );
      }
   }


   void setFullTextInfo( ){
      try{

         OutputWriter.DriverPrintHeader( "SET FULL TEXT INFO" );

         // Get FullTextInfo List
               FullTextInfo[] fullTextInfoList = InputReader.GetFullTextInfoList( );

         // Call the ARSetFullTextInfo method
               beginAPICall( );
               Util.ARSetFullTextInfo( getControlStructObject(), fullTextInfoList );
              endAPICall( getControlStructObject().getLastStatus( ) );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set FullTextInfo Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }


   void getListSQL( ){
      try{

         OutputWriter.DriverPrintHeader( "GETLIST SQL" );

         // Get the SQL Command
            String command = InputReader.GetString( "SQL Command:", "" );

         // Get Maximum number of entries to retrieve
            int numberOfEntries = InputReader.GetInt( "Maximum number of entries to retrieve (500):", 500 );

         // Get the flag to return the number of matches
            boolean flag = InputReader.GetBooleanForChangingInfo( "Get Number Of Matches? (F): ", false );

         // Call the ARGetListSQL
              beginAPICall( );
             SQLResult result = Util.ARGetListSQL( getControlStructObject(), command, numberOfEntries, flag );
              endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the result
            //   OutputWriter.PrintSQLResult( "", "ARGetListSQL Results:", result );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }


   void getTextForErrorMessage( ){
      try{

         OutputWriter.DriverPrintHeader( "GET TEXT FOR ERROR MESSAGE" );

         // Get the
            int msgNumber = InputReader.GetInt( "The message identifier for the message (0):", 0 );


         // Call the ARGetTextForErrorMessage method
            beginAPICall( );
            String message = Util.ARGetTextForErrorMessage( getControlStructObject(), msgNumber );
             endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the message
               OutputWriter.PrintString( "", "ARGetTextForErrorMessage Results:", message, "\n" );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARGetTextForErrorMessage Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }
   void getEntryBLOB( ){
      try{

         OutputWriter.DriverPrintHeader( "GET ENTRY BLOB" );

         // Get the Schema Name
             NameID schema = InputReader.GetNameID( "SchemaName"  );

         // Get Entry ID
             JoinEntryID entryId = InputReader.GetJoinEntryID( );

         // Get Field ID
             FieldID fieldId = InputReader.GetFieldID( "Field ID (1):", 1 );

         // Get Attachment Info
             AttachmentInfo attach = InputReader.GetAttachmentInfo( );


         // Call ARGetEntryBlob method
            beginAPICall( );
            Util.ARGetEntryBlob( getControlStructObject(), schema, entryId, fieldId, attach );
            endAPICall( getControlStructObject().getLastStatus( ) );

         // Check if the content is brought correctly if it is a buffer
            if( attach.getLocationType( ) == AttachmentInfo.AR_LOC_BUFFER )
            {
                byte[] content = ( byte[] )attach.getValue( );
                if( content != null )
                {
                    OutputWriter.PrintString( "Buffer size is: " + content.length + "\n" );
                }
                else
                {
                    OutputWriter.PrintString( "Empty buffer...\n" );
                }
            }
         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set Server Information Status", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }


   void verifyUser( ){
      try{

         OutputWriter.DriverPrintHeader( "VERIFY USER" );

         // Create a VerifyUserCrteria object
               VerifyUserCriteria criteria = new VerifyUserCriteria( );
               criteria.setRetrieveAll( true );

         // Now call the verifyUser method
            beginAPICall( );
            getControlStructObject().verifyUser( criteria );
            endAPICall( getControlStructObject().getLastStatus( ) );

            // Print the information
               if( getControlStructObject().getAdminFlag( ) )
               {
                   OutputWriter.PrintString( "", "Admin Flag: ", "TRUE", "\n" );
                }
                else
                {
                    OutputWriter.PrintString( "", "Admin Flag: ", "FALSE", "\n" );
                }

                if( getControlStructObject().getSubAdminFlag( ) )
                {
                    OutputWriter.PrintString( "", "SubAdmin Flag: ", "TRUE", "\n" );
                }
                else
                {
                   OutputWriter.PrintString( "", "SubAdmin Flag: ", "FALSE", "\n" );
                }

                if( getControlStructObject().getCustomFlag( ) )
                {
                    OutputWriter.PrintString( "", "Custom Flag: ", "TRUE", "\n" );
                }
                else
                {
                    OutputWriter.PrintString( "", "Custom Flag: ", "FALSE", "\n" );
                 }

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Verify User Status", statusList );

      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void encodeARQualifierStruct( ){
      try
      {
         OutputWriter.DriverPrintHeader("ENCODE ARQUALIFIER STRUCT TO STRING");
         QualifierInfo qal = InputReader.GetQualifierInfo();

         beginAPICall( );
         String qaltxt = Util.AREncodeARQualifierStruct(getControlStructObject(), qal);
         endAPICall( getControlStructObject().getLastStatus( ) );


         if(qaltxt != null)
         {
            OutputWriter.PrintHeader("", "Qualifier Text: ", "\n");
            OutputWriter.PrintString(qaltxt);
         }

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "EncodeQualifier Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString("Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void decodeARQualifierStruct(){
      try
      {
         OutputWriter.DriverPrintHeader("DECODE STRING TO ARQUALIFIER STRUCT");
         String qaltxt = InputReader.GetString( "Qualifier Text: ", "" );

         beginAPICall( );
         QualifierInfo qal = Util.ARDecodeARQualifierStruct(getControlStructObject(), qaltxt);
         endAPICall( getControlStructObject().getLastStatus( ) );

         if(qal != null)
            OutputWriter.PrintQualifierInfo("", "ARDecodeARQualifierStruct: ", qal);

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARDecodeARQualifierStruct  Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void encodeARAssignStruct(){
      try {
         OutputWriter.DriverPrintHeader("ENCODE ARASSIGN STRUCT TO STRING");
         AssignInfo asn = InputReader.GetAssignInfo();

         beginAPICall( );
         String asntxt = Util.AREncodeARAssignStruct(getControlStructObject(), asn);
         endAPICall( getControlStructObject().getLastStatus( ) );

         OutputWriter.PrintHeader("", "Assign Text: ", "\n");
         if(asntxt != null)
         {
            OutputWriter.PrintString(asntxt);
            OutputWriter.PrintNewLine( );
         }

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "AREncodeARAssignStruct Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
                    endAPICall( getControlStructObject().getLastStatus( ) );
                   OutputWriter.PrintARException( e );
      }
   }

   void decodeARAssignStruct( ){
      try
      {
         OutputWriter.DriverPrintHeader("DECODE STRING TO ARASSIGN STRUCT");
         String asntxt = InputReader.GetString( "Assign Text: ", "" );

         beginAPICall( );
         AssignInfo asn = Util.ARDecodeARAssignStruct(getControlStructObject(), asntxt);
         endAPICall( getControlStructObject().getLastStatus( ) );

         if(asn != null)
            OutputWriter.PrintAssignInfo("", "ARDecodeARAssignStruct: ", asn);

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARDecodeARAssignStruct Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void encodeStatusHistory(){
      try
      {
         OutputWriter.DriverPrintHeader("ENCODE STATUS HISTORY ARRAY TO STRING");
         StatusHistoryInfo[] statHist = InputReader.GetStatusHistoryInfoList();

         beginAPICall( );
         String statHistTxt = Util.AREncodeStatusHistory(getControlStructObject(), statHist);
         endAPICall( getControlStructObject().getLastStatus( ) );

         if(statHistTxt != null)
         {
            OutputWriter.PrintString( "Status History String: " + "\n");
            OutputWriter.PrintString(statHistTxt);

            // Decode the status history and print the decoded status history items
            //   This is to check whether the encode is properly done or not

            OutputWriter.PrintStatusHistoryString( "", "Status History Items:", statHistTxt );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "AREncodeStatusHistory Status", statusList );
        }
        else
        {
            OutputWriter.PrintString( "Status History String: Null\n");
        }
     }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void encodeDiary(){
      try
      {
         OutputWriter.DriverPrintHeader("ENCODE DIARY ARRAY TO STRING");
         DiaryInfo[] diary = InputReader.GetDiaryInfoList();

         beginAPICall( );
         String diarytxt = Util.AREncodeDiary(getControlStructObject(), diary);
         endAPICall( getControlStructObject().getLastStatus( ) );

         OutputWriter.PrintHeader("", "Diary Text: ", "\n");
         if(diarytxt != null)
         {
            OutputWriter.PrintString(diarytxt);

            // Decode the diary string and print the decoded diary items
            //   This is to check whether the encode is properly done or not

            OutputWriter.PrintDiaryString( "", "Diary Items:", diarytxt );

         }
         else
         {
            OutputWriter.PrintString( "Encoded diary String: Null\n");
         }

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "AREncodeDiary Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }


      void createAlertEvent( ){
      try{

         OutputWriter.DriverPrintHeader( "CREATE ALERT EVENT");



         // Get the User information
            AccessNameID user = InputReader.GetAccessNameID( "User" );

         // Get the alert Text
            String alertText = InputReader.GetString( "Alert Text(): ", "" );

         // Get the alert Priority
            int alertPriority = InputReader.GetInt( "Alert Priority (0):", 0 );

         // Get the alert Source
            NameID alertSource = InputReader.GetNameID( "Alert Source" );
         // Get the Server information
            String serverName = InputReader.GetString( "Server Name: ", "" );

         // Get the Form information
            NameID formName = InputReader.GetNameID( "Form Name" );
         // Get the Object Id
            String objectId = InputReader.GetString( "Object Id(): ", "" );

         beginAPICall( );
         EntryID entryId = Util.ARCreateAlertEvent( getControlStructObject(), user,alertText,
                              alertPriority, alertSource, new ServerNameID( serverName ),
                              formName, objectId );
         endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the EntryID
            OutputWriter.PrintEntryID( "", "EntryID:", entryId );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARCreateAlertEvent Status", statusList );


      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void registerForAlerts( ){
      try{

         OutputWriter.DriverPrintHeader( "REGISTER FOR ALERTS");

            int clientPort = InputReader.GetInt( "clientPort (0):", 0 );
            int registrationFlags = InputReader.GetInt( "registrationFlags (0):", 0 );

         // Call ARRegisterForAlerts method
            beginAPICall( );
            Util.ARRegisterForAlerts( getControlStructObject(), clientPort, registrationFlags );
             endAPICall( getControlStructObject().getLastStatus( ) );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARRegisterForAlerts Status", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
                    endAPICall( getControlStructObject().getLastStatus( ) );
                   OutputWriter.PrintARException( e );
      }
   }

   void deregisterForAlerts( ){
      try{

         OutputWriter.DriverPrintHeader( "Deregister For Alerts" );

         // Get the
            int clientPort = InputReader.GetInt( "clientPort (0):", 0 );

         // Call ARDeregisterForAlerts method
            beginAPICall( );
            Util.ARDeregisterForAlerts( getControlStructObject(), clientPort );
             endAPICall( getControlStructObject().getLastStatus( ) );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARDeregisterForAlerts STatus", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void getListAlertUser(){
      try{

         OutputWriter.DriverPrintHeader( "GET LIST ALERT USER");

         // Call ARGetListAlertUser method
         beginAPICall( );
         AccessNameID[] users = Util.ARGetListAlertUser( getControlStructObject() );
          endAPICall( getControlStructObject().getLastStatus( ) );

         OutputWriter.PrintAccessNameIDList( "", "users List: ", users );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARGetListAlertUser Status", statusList );

      }
      catch( NullPointerException e )
      {
            OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void getAlertCount(){
      try{

         OutputWriter.DriverPrintHeader( "GET ALERT COUNT");
         QualifierInfo qal = InputReader.GetQualifierInfo();

         beginAPICall( );
         int count = Util.ARGetAlertCount(getControlStructObject(), qal);
         endAPICall( getControlStructObject().getLastStatus( ) );

         OutputWriter.PrintInt( "", "ALert Count = ", count, "\n");

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARGetAlertCount Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
            OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
          endAPICall( getControlStructObject().getLastStatus( ) );
          OutputWriter.PrintARException( e );
      }
   }
   void getLocalizedValue()
   {
      try
      {
         OutputWriter.DriverPrintHeader("GET LOCALIZED VALUE");

         LocalizedRequestInfo request = InputReader.GetLocalizedRequestInfo();

         LocalizedValueCriteria criteria = InputReader.GetLocalizedValueCriteria();

         LocalizedValueInfo localizedValue;

         beginAPICall( );
         localizedValue = Util.ARGetLocalizedValue(getControlStructObject(), criteria, request);
         endAPICall( getControlStructObject().getLastStatus( ) );

         if (localizedValue != null)
         {
            if (localizedValue.getValue() != null)
                OutputWriter.PrintValue("   ", "Localized Value: ", localizedValue.getValue());

            if (localizedValue.getTimestamp() != null)
            {
            //    OutputWriter.PrintLong("   ", "Timestamp: ", localizedValue.getTimestamp().getValue(), "\n");
                OutputWriter.PrintString( "Got the time stamp" );
            }
            OutputWriter.PrintNewLine( );
         }

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARGetLocalizedValue Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
            OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
                    endAPICall( getControlStructObject().getLastStatus( ) );
                   OutputWriter.PrintARException( e );
      }
   }
   void getMultipleLocalizedValues()
   {
      try
      {
         OutputWriter.DriverPrintHeader("GET LOCALIZED VALUES");


         int numRequests = InputReader.GetInt("Number of requests (1): ", 1);
         LocalizedRequestInfo requests[] = null;
         if (numRequests > 0)
         {
             requests = new LocalizedRequestInfo[numRequests];
             for (int i=0; i < numRequests; i++)
             {
                  requests[i] = InputReader.GetLocalizedRequestInfo();
             }
         }

         LocalizedValueCriteria criteria = InputReader.GetLocalizedValueCriteria();

         beginAPICall( );
         LocalizedValueInfo localizedValues[] = Util.ARGetMultipleLocalizedValues(getControlStructObject(), criteria, requests);
         endAPICall( getControlStructObject().getLastStatus( ) );

         for (int i=0; i < localizedValues.length; i++)
         {
            if (localizedValues[i].getValue() != null)
                OutputWriter.PrintValue("   ", "Localized Request " + i + ": ", localizedValues[i].getValue());
            if (localizedValues[i].getTimestamp() != null)
                OutputWriter.PrintLong("   ", "Timestamp: ", localizedValues[i].getTimestamp().getValue(), "\n");
         }

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARGetMultipleLocalizedValues Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
            OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
                    endAPICall( getControlStructObject().getLastStatus( ) );
                   OutputWriter.PrintARException( e );
      }
   }
   void getListSchemaWithAlias( )
   {
      try{
         SchemaAliasesCriteria criteria = InputReader.GetSchemaAliasesCriteria( );

         SchemaFactory schemaMan = SchemaFactory.getFactory();

         beginAPICall( );
         SchemaAliasInfo[] schemaAliases = schemaMan.findAliases(getControlStructObject(), criteria);
         endAPICall( getControlStructObject().getLastStatus( ) );

         OutputWriter.PrintSchemaAliases( "", schemaAliases);

          // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "findAliases Status", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }
   void decodeAlertMessage()
   {
      try
      {
         OutputWriter.DriverPrintHeader("DECODE ALERT MESSAGE");

         AlertMessageCriteria criteria = new AlertMessageCriteria( );

	 String message = InputReader.GetString( " Message (): ", "" );

	 int len = message.length();

         // This function expects binary data so we are not expecting this to work with character input

         beginAPICall( );
	 AlertMessageInfo result = Util.ARDecodeAlertMessage(getControlStructObject(), criteria, message.getBytes(), len);
         endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the result
            OutputWriter.PrintAlertMessageInfo( "", "DecodeAlertMessage Results: ", result );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }
   void executeProcessForActiveLink()
   {
      try
      {
         OutputWriter.DriverPrintHeader("EXECUTE PROCESS FOR ACTIVE LINK");

      // Get the Active Link Name
          NameID actlinkName = InputReader.GetNameID( "Name of Active Link" );

         int actionIndex = InputReader.GetInt("Action Index (0): ", 0);

         int actionType = InputReader.GetInt("actionType (0): ", 0);

         InternalID fieldID = InputReader.GetInternalID( "fieldid(0):", 0 );

         Timestamp time = InputReader.GetTimestamp( "timestamp", new Timestamp( ) );

    // Get the Keyword list
        OutputWriter.DriverPrintPrompt( "Keyword List: \n" );
        EntryItem[] keywordsList = InputReader.GetEntryItemList( );

    // Get Parameter List
        OutputWriter.DriverPrintPrompt( "Parameter List:\n" );
        EntryItem[] parametersList = InputReader.GetEntryItemList( );

    // Get the flag whether to wait for the process or not
         boolean waitFlag = InputReader.GetBooleanForChangingInfo( "Wait For process to complete (F): ", false );


   // Not implemented in Java.  Just for the sake of making the C And Java Driver Equal.
        boolean returnCommand = InputReader.GetBooleanForChangingInfo("Get return command? (F): ", false );

    // Call the ARExecuteProcess Method
         beginAPICall( );
         ProcessResult result = Util.ARExecuteProcessForActiveLink( getControlStructObject(), actlinkName, actionIndex,
   				       actionType, fieldID, time, keywordsList, parametersList, waitFlag);
         endAPICall( getControlStructObject().getLastStatus( ) );

    // Print the result
         OutputWriter.PrintProcessResult( "", "ARExecuteProcessForActiveLink RESULTS:", result );

          // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARExecuteProcessForActiveLink Status", statusList );


      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
                    endAPICall( getControlStructObject().getLastStatus( ) );
                   OutputWriter.PrintARException( e );
      }
   }

   void getListSQLForActiveLink()
   {
      try
      {
         OutputWriter.DriverPrintHeader("GETLIST SQL FOR ACTIVE LINK");

         // Get the Active Link Name
             NameID actlinkName = InputReader.GetNameID( "Name of Active Link " );

         int actionIndex = InputReader.GetInt("Action Index (0): ", 0);

         int actionType = InputReader.GetInt("action type (0): ", 0);

         Timestamp time = InputReader.GetTimestamp( "timestamp", new Timestamp( ) );

    // Get the Keyword list
        OutputWriter.DriverPrintPrompt( "Keyword List: " );
        EntryItem[] keywordsList = InputReader.GetEntryItemList( );

    // Get Parameter List
        OutputWriter.DriverPrintPrompt( "Parameter List:" );
        EntryItem[] parametersList = InputReader.GetEntryItemList( );


         int maxRetrieve = InputReader.GetInt("Maximum number of entries to retrieve (500): ", 500);

         // Get the flag whether to get number of matches or not
             boolean retrieveTotalMatches = InputReader.GetBoolean( "Get Number of Matches (F): ", false );

         // Not implemented in Java.  Just for the sake of making the C And Java Driver Equal.
            boolean returnCommand = InputReader.GetBooleanForChangingInfo("Get return command? (F): ", false );

         beginAPICall( );
         SQLResult result = Util.ARGetListSQLForActiveLink(getControlStructObject(), actlinkName, actionIndex, actionType, time,
				   keywordsList, parametersList, maxRetrieve, retrieveTotalMatches);
          endAPICall( getControlStructObject().getLastStatus( ) );

        // Print the result
            OutputWriter.PrintSQLResult( "", "ARGetListSQLForActiveLink Results:", result );

          // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARGetListSQLForActiveLink Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }
   void getListExtSchemaCandidates()
   {
      try
      {
          OutputWriter.DriverPrintHeader("GET LIST EXTERNAL SCHEMA CANDIDATES");

           int schemaType = InputReader.GetInt("schemaType (0): ", 0);

          beginAPICall( );
          CompoundSchemaInfo[] result = Util.ARGetListExtSchemaCandidates(getControlStructObject(), schemaType);
          endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the result
             OutputWriter.PrintCompoundSchemaInfoList( "", "ARGetListExtSchemaCandidates Results: ", result );

          // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARGetListExtSchemaCandidates Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void getMultipleExtFieldCandidates()
   {
      try
      {
         OutputWriter.DriverPrintHeader("GET MULTIPLE EXTERNAL FIELD CANDIDATES");
        CompoundSchemaInfo comSchema = InputReader.GetCompoundSchemaInfo();

         beginAPICall( );
         ExtFieldCandidatesInfo[] result = Util.ARGetMultipleExtFieldCandidates(getControlStructObject(), comSchema);
         endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the result
         OutputWriter.PrintExtFieldCandidatesInfoList( "", "ARGetListExtSchemaCandidates Results: ", result );

          // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARGetListExtSchemaCandidates Status", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }
   void getEntryStatistics()
   {
      try
      {
         OutputWriter.DriverPrintHeader( "GET ENTRY STATISTICS" );

         SchemaKey schemaKey = InputReader.GetSchemaKey( );

         QualifierInfo qualifier = InputReader.GetQualifierInfo( );

         // Get the target expression
             OutputWriter.DriverPrintHeader( "Target Expression:" );
             ArithmeticOrRelationalOperand target = InputReader.GetArithmeticOrRelationalOperand( );

        int type = InputReader.GetInt( "Statistic Operation to Perform (Count,Sum,Avg,Min,Max) (1-5)(1):", 1 );

        OutputWriter.DriverPrintPrompt( "Ids of fields to group statistics by:\n " );
        InternalID[] idList = InputReader.GetInternalIDList( );

        // Call the ARGetEntryStatistics method
           beginAPICall( );
           StatisticsResultInfo[] statResInfoList = Util.ARGetEntryStatistics( getControlStructObject(), schemaKey, qualifier, target, type, idList );
           endAPICall( getControlStructObject().getLastStatus( ) );


            OutputWriter.PrintStatisticsResultInfoList( "", "GET ENTRY STATISTICS RESULTS:", statResInfoList );

          // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARGetEntryStatistics Status", statusList );


      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void validateLicense( ){
      try{
        // print header
           OutputWriter.DriverPrintHeader( "VALIDATE LICENSE" );

        // Get the license type
           LicenseNameID licType = InputReader.GetLicenseNameID("License Type: ");

        // validate the license
           beginAPICall( );
           LicenseValidInfo licValidInfo = Util.ARValidateLicense( getControlStructObject( ), licType );
           endAPICall( getControlStructObject().getLastStatus( ) );

        // Print the validate info
           OutputWriter.PrintLicenseValidInfo( "", "    ARValidateLicense Results:", licValidInfo );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }
 void getMultipleFields( )
   {
      try{
         OutputWriter.DriverPrintHeader( "GET MULTIPLE FIELDS" );

         // Create an empty field
            FieldFactory fieldMan = FieldFactory.getFactory( );

         // Set the field List criteria
            FieldListCriteria listCriteria = InputReader.GetFieldListCriteria( );

         // Set the field criteria to retrieve all
            FieldCriteria criteria = new FieldCriteria( );
            criteria.setRetrieveAll(true);


         // Find the fields
            beginAPICall( );
            Field[] fieldList = fieldMan.findObjects( getControlStructObject( ), listCriteria, criteria );
            endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the information
            OutputWriter.PrintFieldList( "", "Field List Information:", fieldList );
            OutputWriter.PrintStatusInfoList("", "Status", getControlStructObject().getLastStatus());

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void getListLicense( ){
      try{
         // print header
            OutputWriter.DriverPrintHeader( "GET LIST LICENSE" );

         // Get the license type
            LicenseNameID licType = InputReader.GetLicenseNameID("License Type: ");

         // validate the license
            beginAPICall( );
            LicenseInfo[] licInfo = Util.ARGetListLicense( getControlStructObject(), licType );
            endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the validate info
            OutputWriter.PrintLicenseInfoList( "", "    ARGetListLicense Results:", licInfo );
            OutputWriter.PrintStatusInfoList("", "Status", getControlStructObject().getLastStatus());
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }
   void validateMultipleLicenses( ){
      try{
         // print header
            OutputWriter.DriverPrintHeader( "VALIDATE MULTIPLE LICENSE" );

         // Get the license type
            LicenseNameID[] licTypeList = InputReader.GetLicenseNameIDList();

         // validate the license
            beginAPICall( );
            LicenseValidInfo[] licValidList = Util.ARValidateMultipleLicense( getControlStructObject(), licTypeList );
            endAPICall( getControlStructObject().getLastStatus( ) );

         // Print the license info
            OutputWriter.PrintLicenseValidList( "", "    ARValidateMultipleLicenses Results:", licValidList );
            OutputWriter.PrintStatusInfoList("", "Status", getControlStructObject().getLastStatus());
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void getSessionConfiguration()
   {
       try{
         OutputWriter.DriverPrintHeader("GET SESSION CONFIGURATION");

         int variableId = InputReader.GetInt("Session Variable Id (0): ", 0);

         beginAPICall( );
         Value variableValue = Util.ARGetSessionConfiguration(getControlStructObject( ), variableId);
         endAPICall( getControlStructObject().getLastStatus( ) );

         OutputWriter.PrintValue("   ", "Session Variable", variableValue);
         OutputWriter.PrintStatusInfoList("", "Status", getControlStructObject( ).getLastStatus());
       }
       catch (IOException e)
       {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
       }
       catch( NullPointerException e )
       {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
       }
       catch( ARException e )
       {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
       }
   }

   void setSessionConfiguration()
   {
       try{
         OutputWriter.DriverPrintHeader("SET SESSION CONFIGURATION");

         int variableId = InputReader.GetInt("Variable Id (0): ", 0);
         Value variableValue = InputReader.GetValue();

         beginAPICall( );
         Util.ARSetSessionConfiguration(getControlStructObject( ), variableId, variableValue);
         endAPICall( getControlStructObject().getLastStatus( ) );

         StatusInfo[] statusList = getControlStructObject( ).getLastStatus( );
         OutputWriter.PrintStatusInfoList( "", "Set Session Results", statusList );
       }
       catch (IOException e)
       {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
       }
       catch( NullPointerException e )
       {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
       }
       catch( ARException e )
       {
          endAPICall( getControlStructObject( ).getLastStatus( ) );
          OutputWriter.PrintARException( e );
       }
   }

   public void xmlCreateEntry()
   {
      int bytesRead = 0;

      try
      {
	   OutputWriter.DriverPrintHeader("XML CREATE ENTRY");

         // Get the file name for xml input mapping
	    String fileName = null;
	    FileReader fileReader = null;
	    for (int i=0; i < 3; i++)
	    {
	       fileName = InputReader.GetString("Filename containing XML input mapping: ", "");
	       if (fileName == null)
	       {
		  OutputWriter.PrintString("Input file not found\n");
		  continue;
	       }
	       try
	       {
		  fileReader = new FileReader(fileName);
		  break;
	       }
	       catch (FileNotFoundException e)
	       {
		  OutputWriter.PrintString("Input file not found\n");
		  fileName = null;
	       }
	    }
	    if (fileName == null)
	       return;

	    String xmlInputMapping = new String();
	    StringBuffer stringInputMappingBuffer = new StringBuffer();
	    char   readBuffer[] = new char[1024];
	    while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length-1)) >= 0)
	       stringInputMappingBuffer.append(readBuffer, 0, bytesRead);

	    xmlInputMapping = stringInputMappingBuffer.toString();

         // Get the file name for input document
	    fileName = null;
	    fileReader = null;
	    for (int i=0; i < 3; i++)
	    {
	       fileName = InputReader.GetString("Filename containing XML input document: ", "");
	       if (fileName == null)
	       {
		  OutputWriter.PrintString("Input file not found\n");
		  continue;
	       }
	       try
	       {
		  fileReader = new FileReader(fileName);
		  break;
	       }
	       catch (FileNotFoundException e)
	       {
		  OutputWriter.PrintString("Input file not found\n");
		  fileName = null;
	       }
	    }
	    if (fileName == null)
	       return;

	    String xmlInputDoc = new String();
	    StringBuffer stringInputDocBuffer = new StringBuffer();
	    while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length-1)) >= 0)
	       stringInputDocBuffer.append(readBuffer, 0, bytesRead);

	    xmlInputDoc = stringInputDocBuffer.toString();

	 // Get the file name for output mapping
	    fileName = null;
	    fileReader = null;
	    for( int i=0; i < 3; i++ )
	    {
	       fileName = InputReader.GetString("Filename containing XML output mapping: ", "");
	       if (fileName == null)
	       {
	          OutputWriter.PrintString("Input file not found\n");
	          continue;
	       }
	       try
	       {
	          fileReader = new FileReader(fileName);
	          break;
	       }
	       catch (FileNotFoundException e)
	       {
	          OutputWriter.PrintString("Input file not found\n");
	          fileName = null;
               }
	    }
	    if (fileName == null)
            {
               return;
            }

	 String outputMapping = new String();
	 StringBuffer stringOutputMappingBuffer = new StringBuffer();
	 while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length-1)) >= 0)
	    stringOutputMappingBuffer.append(readBuffer, 0, bytesRead);

	 outputMapping = stringOutputMappingBuffer.toString();

	 // Get the file name for option document
	    fileName = null;
	    fileReader = null;
	    for (int i=0; i < 3; i++)
	    {
	       fileName = InputReader.GetString("Filename containing XML option document: ", "");
	       if (fileName == null)
	       {
	          OutputWriter.PrintString("Input file not found\n");
	          continue;
	       }
	       try
	       {
	          fileReader = new FileReader(fileName);
	          break;
	       }
	       catch (FileNotFoundException e)
	       {
	          OutputWriter.PrintString("Input file not found\n");
	          fileName = null;
	       }
	    }
	    if (fileName == null)
	       return;

	 String optionDoc = new String();
	 StringBuffer stringOptionDocBuffer = new StringBuffer();
	 while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length-1)) >= 0)
	    stringOptionDocBuffer.append(readBuffer, 0, bytesRead);

	 optionDoc = stringOptionDocBuffer.toString();

	 String xmlOutputDoc = null;


         beginAPICall( );
         xmlOutputDoc = Util.ARXMLCreateEntry(getControlStructObject( ), xmlInputMapping, xmlInputDoc,
	                                      outputMapping, optionDoc);
         endAPICall( getControlStructObject().getLastStatus( ) );

         StatusInfo[] statusList = getControlStructObject( ).getLastStatus( );
         OutputWriter.PrintStatusInfoList( "", "XMLCreateEntry Results", statusList );

	 if (xmlOutputDoc != null)
	    OutputWriter.PrintString(xmlOutputDoc);
         else
	    OutputWriter.PrintString("xmlOutputDoc is null...\n");
      }
      catch (IOException e)
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   public void xmlGetEntry()
   {
      int bytesRead = 0;
      try
      {
         OutputWriter.DriverPrintHeader( "XML GET ENTRY" );

	 // Get the file name for xml query mapping
	 String fileName = null;
	 FileReader fileReader = null;
	 for (int i=0; i < 3; i++)
	 {
	    fileName = InputReader.GetString("Filename containing XML query mapping: ", "");
	    if (fileName == null)
	    {
	       OutputWriter.PrintString("Input file not found\n");
	       continue;
	    }
	    try
	    {
	       fileReader = new FileReader(fileName);
	       break;
	    }
	    catch (FileNotFoundException e)
	    {
	       OutputWriter.PrintString("Input file not found\n");
	       fileName = null;
	    }
	 }
	 if (fileName == null)
	    return;

	 String xmlQueryMapping = new String();
	 StringBuffer stringQueryMappingBuffer = new StringBuffer();
	 char   readBuffer[] = new char[1024];
	 while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length-1)) >= 0)
	    stringQueryMappingBuffer.append(readBuffer, 0, bytesRead);

	 xmlQueryMapping = stringQueryMappingBuffer.toString();

         // Get the file name for query document
	 fileName = null;
	 fileReader = null;
	 for (int i=0; i < 3; i++)
	 {
	    fileName = InputReader.GetString("Filename containing XML query document: ", "");
	    if (fileName == null)
	    {
	       OutputWriter.PrintString("Input file not found\n");
	       continue;
	    }
	    try
	    {
	       fileReader = new FileReader(fileName);
	       break;
	    }
	    catch (FileNotFoundException e)
	    {
	       OutputWriter.PrintString("Input file not found\n");
	       fileName = null;
	    }
	 }
	 if (fileName == null)
	    return;

	 String xmlQueryDoc = new String();
	 StringBuffer stringQueryDocBuffer = new StringBuffer();
	 while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length-1)) >= 0)
	    stringQueryDocBuffer.append(readBuffer, 0, bytesRead);

	 xmlQueryDoc = stringQueryDocBuffer.toString();

	 // Get the file name for output mapping
	 fileName = null;
	 fileReader = null;
	 for (int i=0; i < 3; i++)
	 {
	    fileName = InputReader.GetString("Filename containing XML output mapping: ", "");
	    if (fileName == null)
	    {
	       OutputWriter.PrintString("Input file not found\n");
	       continue;
	    }
	    try
	    {
	       fileReader = new FileReader(fileName);
	       break;
	    }
	    catch (FileNotFoundException e)
	    {
	       OutputWriter.PrintString("Input file not found\n");
	       fileName = null;
	    }
	 }
	 if (fileName == null)
	    return;

	 String outputMapping = new String();
	 StringBuffer stringOutputMappingBuffer = new StringBuffer();
	 while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length-1)) >= 0)
	    stringOutputMappingBuffer.append(readBuffer, 0, bytesRead);

	 outputMapping = stringOutputMappingBuffer.toString();

	 // Get the file name for option document
	 fileName = null;
	 fileReader = null;
	 for (int i=0; i < 3; i++)
	 {
	    fileName = InputReader.GetString("Filename containing XML option document: ", "");
	    if (fileName == null)
	    {
	       OutputWriter.PrintString("Input file not found\n");
	       continue;
	    }
	    try
	    {
	       fileReader = new FileReader(fileName);
	       break;
	    }
	    catch (FileNotFoundException e)
	    {
	       OutputWriter.PrintString("Input file not found\n");
	       fileName = null;
	    }
	 }
	 if (fileName == null)
	    return;

	 String optionDoc = new String();
	 StringBuffer stringOptionDocBuffer = new StringBuffer();
	 while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length-1)) >= 0)
	    stringOptionDocBuffer.append(readBuffer, 0, bytesRead);

	 optionDoc = stringOptionDocBuffer.toString();

	 String xmlOutputDoc = null;


         beginAPICall( );
	 xmlOutputDoc = Util.ARXMLGetEntry(getControlStructObject( ), xmlQueryMapping, xmlQueryDoc,
	                                   outputMapping, optionDoc);
         endAPICall( getControlStructObject().getLastStatus( ) );

         StatusInfo[] statusList = getControlStructObject( ).getLastStatus( );
         OutputWriter.PrintStatusInfoList( "", "XMLGetEntry Results", statusList );

	 if (xmlOutputDoc != null)
	    OutputWriter.PrintString(xmlOutputDoc);
         else
	    OutputWriter.PrintString("xmlOutputDoc is null...\n");
      }
      catch (IOException e)
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   public void xmlSetEntry()
   {
      int bytesRead = 0;
      try
      {
         OutputWriter.DriverPrintHeader( "XML SET ENTRY" );

	 // Get the file name for xml query mapping
	 String fileName = null;
	 FileReader fileReader = null;
	 for (int i=0; i < 3; i++)
	 {
	    fileName = InputReader.GetString("Filename containing XML query mapping: ", "");
	    if (fileName == null)
	    {
	       OutputWriter.PrintString("Input file not found\n");
	       continue;
	    }
	    try
	    {
	       fileReader = new FileReader(fileName);
	       break;
	    }
	    catch (FileNotFoundException e)
	    {
	       OutputWriter.PrintString("Input file not found\n");
	       fileName = null;
	    }
	 }
	 if (fileName == null)
	    return;

	 String xmlQueryMapping = new String();
	 StringBuffer stringQueryMappingBuffer = new StringBuffer();
	 char   readBuffer[] = new char[1024];
	 while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length-1)) >= 0)
	    stringQueryMappingBuffer.append(readBuffer, 0, bytesRead);

	 xmlQueryMapping = stringQueryMappingBuffer.toString();

         // Get the file name for query document
	 fileName = null;
	 fileReader = null;
	 for (int i=0; i < 3; i++)
	 {
	    fileName = InputReader.GetString("Filename containing XML query document: ", "");
	    if (fileName == null)
	    {
	       OutputWriter.PrintString("Input file not found\n");
	       continue;
	    }
	    try
	    {
	       fileReader = new FileReader(fileName);
	       break;
	    }
	    catch (FileNotFoundException e)
	    {
	       OutputWriter.PrintString("Input file not found\n");
	       fileName = null;
	    }
	 }
	 if (fileName == null)
	    return;

	 String xmlQueryDoc = new String();
	 StringBuffer stringQueryDocBuffer = new StringBuffer();
	 while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length-1)) >= 0)
	    stringQueryDocBuffer.append(readBuffer, 0, bytesRead);

	 xmlQueryDoc = stringQueryDocBuffer.toString();

            // Get the file name for xml input mapping
	    fileName = null;
	    fileReader = null;
	    for (int i=0; i < 3; i++)
	    {
	       fileName = InputReader.GetString("Filename containing XML input mapping: ", "");
	       if (fileName == null)
	       {
		  OutputWriter.PrintString("Input file not found\n");
		  continue;
	       }
	       try
	       {
		  fileReader = new FileReader(fileName);
		  break;
	       }
	       catch (FileNotFoundException e)
	       {
		  OutputWriter.PrintString("Input file not found\n");
		  fileName = null;
	       }
	    }
	    if (fileName == null)
	       return;

	    String xmlInputMapping = new String();
	    StringBuffer stringInputMappingBuffer = new StringBuffer();
	    while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length-1)) >= 0)
	       stringInputMappingBuffer.append(readBuffer, 0, bytesRead);

	    xmlInputMapping = stringInputMappingBuffer.toString();

            // Get the file name for input document
	    fileName = null;
	    fileReader = null;
	    for (int i=0; i < 3; i++)
	    {
	       fileName = InputReader.GetString("Filename containing XML input document: ", "");
	       if (fileName == null)
	       {
		  OutputWriter.PrintString("Input file not found\n");
		  continue;
	       }
	       try
	       {
		  fileReader = new FileReader(fileName);
		  break;
	       }
	       catch (FileNotFoundException e)
	       {
		  OutputWriter.PrintString("Input file not found\n");
		  fileName = null;
	       }
	    }
	    if (fileName == null)
	       return;

	    String xmlInputDoc = new String();
	    StringBuffer stringInputDocBuffer = new StringBuffer();
	    while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length-1)) >= 0)
	       stringInputDocBuffer.append(readBuffer, 0, bytesRead);

	    xmlInputDoc = stringInputDocBuffer.toString();

	 // Get the file name for output mapping
	 fileName = null;
	 fileReader = null;
	 for (int i=0; i < 3; i++)
	 {
	    fileName = InputReader.GetString("Filename containing XML output mapping: ", "");
	    if (fileName == null)
	    {
	       OutputWriter.PrintString("Input file not found\n");
	       continue;
	    }
	    try
	    {
	       fileReader = new FileReader(fileName);
	       break;
	    }
	    catch (FileNotFoundException e)
	    {
	       OutputWriter.PrintString("Input file not found\n");
	       fileName = null;
	    }
	 }
	 if (fileName == null)
	    return;

	 String outputMapping = new String();
	 StringBuffer stringOutputMappingBuffer = new StringBuffer();
	 while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length-1)) >= 0)
	    stringOutputMappingBuffer.append(readBuffer, 0, bytesRead);

	 outputMapping = stringOutputMappingBuffer.toString();

	 // Get the file name for option document
	 fileName = null;
	 fileReader = null;
	 for (int i=0; i < 3; i++)
	 {
	    fileName = InputReader.GetString("Filename containing XML option document: ", "");
	    if (fileName == null)
	    {
	       OutputWriter.PrintString("Input file not found\n");
	       continue;
	    }
	    try
	    {
	       fileReader = new FileReader(fileName);
	       break;
	    }
	    catch (FileNotFoundException e)
	    {
	       OutputWriter.PrintString("Input file not found\n");
	       fileName = null;
	    }
	 }
	 if (fileName == null)
	    return;

	 String optionDoc = new String();
	 StringBuffer stringOptionDocBuffer = new StringBuffer();
	 while ((bytesRead = fileReader.read(readBuffer, 0, readBuffer.length-1)) >= 0)
	    stringOptionDocBuffer.append(readBuffer, 0, bytesRead);

	 optionDoc = stringOptionDocBuffer.toString();

	 String xmlOutputDoc = null;

         beginAPICall( );
	 xmlOutputDoc = Util.ARXMLSetEntry(getControlStructObject( ), xmlQueryMapping, xmlQueryDoc,
	                                   xmlInputMapping, xmlInputDoc, outputMapping, optionDoc);
         endAPICall( getControlStructObject().getLastStatus( ) );

         StatusInfo[] statusList = getControlStructObject( ).getLastStatus( );
         OutputWriter.PrintStatusInfoList( "", "XMLSetEntry Results", statusList );

      }
      catch (IOException e)
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void getMultipleCurrencyRatioSets()
   {
       try{
         OutputWriter.DriverPrintHeader("GET MULTIPLE CURRENCY RATIO SETS");

         Timestamp[] timestampList = InputReader.GetTimestampList();

         beginAPICall( );
         String[] currencyRatioSets = Util.ARGetMultipleCurrencyRatioSets(getControlStructObject( ), timestampList);
         endAPICall( getControlStructObject().getLastStatus( ) );

         StatusInfo[] statusList = getControlStructObject( ).getLastStatus( );
         OutputWriter.PrintStatusInfoList( "", "GetMultipleCurrencyRatioSets Results", statusList );

         for (int i=0;i<currencyRatioSets.length;i++)
         {
            OutputWriter.PrintString(currencyRatioSets[i] + "\n");
         }
       }
      catch (IOException e)
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void getCurrencyRatio()
   {
       try{
         OutputWriter.DriverPrintHeader("GET CURRENCY RATIO");

         String currencyRatioString = InputReader.GetString("Currency ratios string:", "");
         String fromCurrencyCode = InputReader.GetString("From Currency Code:", "");
         System.out.println(fromCurrencyCode);
         String toCurrencyCode = InputReader.GetString("To Currency Code:", "");
         System.out.println(toCurrencyCode);

         beginAPICall( );
         BigDecimal currencyRatio = Util.ARGetCurrencyRatio(currencyRatioString.trim(), fromCurrencyCode.trim(), toCurrencyCode.trim());
         endAPICall( getControlStructObject().getLastStatus( ) );

         StatusInfo[] statusList = getControlStructObject( ).getLastStatus( );
         OutputWriter.PrintStatusInfoList( "", "GetCurrencyRadio Results", statusList );

         OutputWriter.PrintString("Currency Ratio: " + currencyRatio.toString());
       }
      catch (IOException e)
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void  getQualifier()
   {
      try {
         FieldFactory fieldMan = FieldFactory.getFactory();
         NameID schemaName = InputReader.GetNameID("Local Schema Name: ");
         boolean x = InputReader.GetNullPromptOption();
         InputReader.SetNullPromptOption(true);
         NameID remoteSchemaName = InputReader.GetNameID("Remote Schema Name: ");
         InputReader.SetNullPromptOption(x);
         FieldListCriteria localListcrit = new FieldListCriteria(schemaName, new Timestamp(0), FieldType.AR_ALL_FIELD);
		 FieldListCriteria remoteListcrit = null;
         if (remoteSchemaName != null)
		    remoteListcrit = new FieldListCriteria(remoteSchemaName, new Timestamp(0), FieldType.AR_ALL_FIELD);
         FieldCriteria crit = new FieldCriteria();
         crit.setRetrieveAll(true);

         Field[] fieldList = fieldMan.findObjects( getControlStructObject( ), localListcrit, crit);
		 Field[] remoteFieldList = null;
         if (remoteSchemaName != null)
            remoteFieldList = fieldMan.findObjects( getControlStructObject( ), remoteListcrit, crit);
         long vuiId = InputReader.GetInt("Enter ViewID (0):", 0 );
         int opt = InputReader.GetInt("Customized? (0):", 0);
	 String szQual = InputReader.GetString("Qualifier String: ", "");

	 QualifierInfo qual;
     if (opt == 0)
     {
		if (remoteFieldList == null)
	       qual = Util.ARGetQualifier(getControlStructObject(), szQual, fieldList, null, 0);
        else
	       qual = Util.ARGetQualifier(getControlStructObject(), szQual, remoteFieldList, fieldList, 0);
     }
	 else
	 {
		ARQualifierHelper qualHelper = new ARQualifierHelper();
		qualHelper.generateFieldMaps(fieldList, vuiId, null, remoteFieldList);
		qual = qualHelper.getQualifier(getControlStructObject(), szQual);
	 }

     OutputWriter.PrintQualifierInfo("", "", qual);


	 String szQualNew = Util.ARGetQualifierString(getControlStructObject(),qual, fieldList, remoteFieldList,0, false);

	 System.out.println("\nOriginal Query : " + szQual);
	 System.out.println("\nRebuilt Query : " + szQualNew);
      }
      catch (IOException e)
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void dumpProxyInfo()
   {


	   ProxyManager.PoolInfo ppi[] = ProxyManager.getPoolInformation();

       OutputWriter.PrintString("Pooling Info:\n");
	   for(int i = 0; i < ppi.length; i++)
	   {
		   StringBuffer sb = new StringBuffer();
		   sb.append(ppi[i].getServerName()).append(" * ").append(new Integer(ppi[i].getInUse())).append(" * ").append(new Integer(ppi[i].getFree())).append(" * ").append(new Integer(ppi[i].getNotCreated()));
		   OutputWriter.PrintString(sb.toString());
           OutputWriter.PrintString( "\n" );
	   }
   }

   void setUseConnectionPooling()
   {
	   ProxyManager.setUseConnectionPooling(true);
   }

   void arImport()
   {
      try
      {
         OutputWriter.DriverPrintHeader( "IMPORT" );

         StructItemInfo[] itemsList = InputReader.GetStructItemInfoList( );

         String fileName = InputReader.GetString( "Filename containing import data:", "" );

         String contents = InputReader.GetFileContents( fileName );

         int importOption =  InputReader.GetInt( "The import option (0):", 0 );

         beginAPICall( );
         Util.ARImport( getControlStructObject(), itemsList, importOption, contents );
         endAPICall( getControlStructObject().getLastStatus( ) );

         // Success. Print the status
             StatusInfo[] statusList = getControlStructObject().getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARImport ", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void getMultipleEntryPoints(){
      try{
         OutputWriter.DriverPrintHeader("GET MULTIPLE ENTRYPOINTS");

         EntryPointMultiListCriteria multiListCriteria = new EntryPointMultiListCriteria();
         EntryPointMultiCriteria multiCriteria = new EntryPointMultiCriteria();

         Timestamp time = InputReader.GetTimestamp("Get all changed since (0): ", new Timestamp(0));
         multiListCriteria.setModifiedAfter(time);

         ContainerKey[] applicationKeys = InputReader.GetApplicationKeyList("");
         multiListCriteria.setApplicationKeys(applicationKeys);

         ReferenceType[] refTypes = InputReader.GetReferenceTypeList();
         multiCriteria.setReferenceTypes(refTypes);

         String displayTag = InputReader.GetString( "Display Tag ():", "" );
         multiListCriteria.setDisplayTag( new NameID(displayTag));

         multiListCriteria.setVUIType(InputReader.GetInt("VUI Type (1-4) (0): ", 0));

         multiListCriteria.setAttribute(InputReader.GetInt("Attribute (visible, hidden) (0-1) (0): ", 0));

         multiCriteria.setRetrieveAll(true);

         beginAPICall( );
         EntryPointInfo entryPointInfoList[];

         entryPointInfoList = Util.ARGetMultipleEntryPoints( getControlStructObject(), multiListCriteria, multiCriteria);

         endAPICall( getControlStructObject().getLastStatus( ) );

         StatusInfo[] statusList = getControlStructObject().getLastStatus( );
         OutputWriter.PrintStatusInfoList( "", "ARGetMultipleEntryPoints ", statusList );

         // Now print all the information about the containers
         OutputWriter.PrintEntryPointInfoList("", "Entry Points List:", entryPointInfoList);

      }
      catch(IOException e)
      {
         OutputWriter.PrintString("Problem in getting the input...Driver problem..\n");
      }
      catch(NullPointerException e)
      {
         OutputWriter.PrintString("Null Pointer exception...\n");
      }
      catch(ARException e)
      {
         OutputWriter.PrintARException(e);
      }
   }

   void beginBulkEntryTransaction()
   {
      try
      {
         OutputWriter.DriverPrintHeader("BEGIN BULK ENTRY TRANSACTION");
         beginAPICall( );
         Util.ARBeginBulkEntryTransaction(getControlStructObject( ));
         endAPICall( getControlStructObject().getLastStatus( ) );

         OutputWriter.PrintStatusInfoList("", "BeginBulkEntryTransaction Results",
                                          getControlStructObject( ).getLastStatus());
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject().getLastStatus( ) );
         OutputWriter.PrintARException( e );
      }
   }

   void endBulkEntryTransaction()
   {
      BulkEntryReturn[] bulkEntryReturnList = null;

      try
      {
         OutputWriter.DriverPrintHeader("END BULK ENTRY TRANSACTION");

         int actionType = InputReader.GetInt("Action Type (1): ", 1);

         beginAPICall( );
         bulkEntryReturnList = Util.AREndBulkEntryTransaction(getControlStructObject( ), actionType);
         endAPICall( getControlStructObject().getLastStatus( ) );

         OutputWriter.PrintBulkEntryReturnList("   ", "Bulk Entry Return", bulkEntryReturnList);

         OutputWriter.PrintStatusInfoList("", "EndBulkEntryTransaction Results",
                                          getControlStructObject( ).getLastStatus());
      }
      catch (IOException e)
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         endAPICall( getControlStructObject( ).getLastStatus( ) );
         if (e.getClass() == ARBulkException.class)
         {
            bulkEntryReturnList = ((ARBulkException) e).getBulkEntryReturn();
            OutputWriter.PrintBulkEntryReturnList("   ", "Bulk Entry Return", bulkEntryReturnList);
         }
         OutputWriter.PrintARException( e );
      }
   }

   public void launchThread( boolean flag )
   {

      ThreadStartInfo threadStartInfo = new ThreadStartInfo( );
      try{
         ThreadControlBlock  threadControlBlockPtr =  JavaDriver.getThreadControlBlockPtr();

         String inputValue =  InputReader.GetString( "Filename of input file (): ", "" );
         if ( (inputValue == null ) || inputValue.length( ) == 0 )
         {
            OutputWriter.DriverPrintError(" **** An input file is required to launch a thread\n");
            return;
         }
         threadStartInfo.setInputFile( new InputFile( inputValue ) );


         /* get the filename of the optional output file */

         String outputValue = InputReader.GetString("Filename of output file (): ", "");
         boolean isStdout = false;
         if ( (outputValue == null) || ( ( JavaDriver.quietMode & JavaDriver.SUPPRESS_RESULTS) >  0 ) )
         {
              isStdout = true;
         }
         else
         {
             if( outputValue.length( ) == 0 )
             {
                isStdout = true;
             }
         }

         if ( isStdout )
         {
            threadStartInfo.setOutputToStdOut( );
         }
         else
         {
            /* build a file name */
               String fileName = null;
               if( ( JavaDriver.getResultDirectory( ) == null ) || ( JavaDriver.getResultDirectory( ).length( ) == 0 ) )
               {
                  fileName = outputValue;
               }
               else
               {
                  fileName = JavaDriver.getResultDirectory( ) + "\\" + outputValue;
               }

            /* open the output file for writing */
               threadStartInfo.setOutputFile( new PrintWriter( new FileOutputStream( new File( fileName ) ) ) );
               threadStartInfo.setOutputFileName( fileName );
          }

          /* get the optional authentication string that the launched thread will login with */
             String authString = InputReader.GetString("Authentication string (): ", "");
             threadStartInfo.setAuthentication( authString );

          /* get the optional user name that the launched thread will login with */
             String userName = InputReader.GetString("User name (): ", "");
             threadStartInfo.setUser( userName );

          /* get the optional password that the launched thread will login with */
             String password = InputReader.GetString("Password (): ", "");
             threadStartInfo.setPassword( password );

          /* get the optional locale that the launched thread will login with */
             String locale = InputReader.GetString( "Locale (): ", "");
             threadStartInfo.setLocale( locale );

          /* get the optional server that the launched thread will login with */
             String server = InputReader.GetString( "Server (): ", "" );
             threadStartInfo.setServer( server );

          /* get the optional upper range value for a delay at the start of the */
          /* launched thread                                                    */
             long upperBound = InputReader.GetLong( "Thread startup sleep range (0): ", 0);
             threadStartInfo.setUpperBound( upperBound );

          // Set the wait information depending on the wait flag
             threadStartInfo.setWaitFlag( flag );

             if( flag )
             {
                threadStartInfo.setWaitObject( threadControlBlockPtr.getWaitObject( ) );
                threadStartInfo.setReleaseObject( threadControlBlockPtr.getReleaseObject( ) );
             }

          // Create another JavaDriver thread
              JavaDriver driver = new JavaDriver( );
              driver.setThreadStartInfo( threadStartInfo );
              driver.setPrimaryThread( false );

          // Now start the thread
              driver.start( );

          // Add this thread to the children list
              threadControlBlockPtr.addThreadHandle( driver );


          // if wait flag is true wait till the waitobject is notified
              if( flag )
              {
                 SyncObject waitObject = threadControlBlockPtr.getWaitObject( );
                 synchronized( waitObject )
                 {
                    try{
                       while( waitObject.getFlag( ) != true )
                       {
                          waitObject.wait( );
                       }
                    }
                    catch( InterruptedException e )
                    {
                       System.out.println( "Interrupted Exception ...in simplethread run");
                    }
                 }
              }

      }
      catch( IOException e )
      {
         try{
            threadStartInfo.cleanUp( );
            OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
         }
         catch( IOException ex )
         {
            OutputWriter.PrintString( "Problem in cleaning up the thread start info..\n" );
         }
      }
      catch( NullPointerException e )
      {
         try{
            threadStartInfo.cleanUp( );
            OutputWriter.PrintString( "Null Pointer exception...\n" );
         }
         catch( IOException ex )
         {
            OutputWriter.PrintString( "Problem in cleaning up the thread start info..\n" );
         }

      }
   }


   public void threadStartFunction( )
   throws IOException{
      ThreadControlBlock threadControlBlockObject = JavaDriver.getThreadControlBlockPtr( );

      threadControlBlockObject.setCurrentInputFile( threadStartInfoObject.getInputFile( ) );

      threadControlBlockObject.setOutputFile( threadStartInfoObject.getOutputFile( ), threadStartInfoObject.getOutputFileName( ),
                                              threadStartInfoObject.getIsStdOut( )  );
      threadControlBlockObject.setAuthentication( threadStartInfoObject.getAuthentication( ) );
      threadControlBlockObject.setUser( threadStartInfoObject.getUser( ) );
      threadControlBlockObject.setPassword( threadStartInfoObject.getPassword( ) );
      threadControlBlockObject.setLocale( threadStartInfoObject.getLocale( ) );
      threadControlBlockObject.setServer( threadStartInfoObject.getServer( ) );
      threadControlBlockObject.setPrimaryThread( false );
      if( threadStartInfoObject.getWaitFlag( ) )
      {
         SyncObject waitObject = threadStartInfoObject.getWaitObject( );
         synchronized( waitObject )
         {
            waitObject.flag = true;
            waitObject.notify( );
         }
         SyncObject releaseObject = threadStartInfoObject.getReleaseObject( );
         synchronized( releaseObject )
         {
            try{
               while( releaseObject.getFlag( ) == false )
               {
                  releaseObject.wait( );
               }
            }
            catch( InterruptedException e )
            {
               System.out.println( "Interrupted Exception ...in simplethread run");
            }
         }
      }

      /* if requested we delay the processing of commands by a random length */
      /* sleep that is between zero and the provided number of seconds       */

         if (threadStartInfoObject.getUpperBound() > 0)
         {
            threadControlBlockObject.setCurrentCommand ( "rst");
            randomSleep(0, threadStartInfoObject.getUpperBound( ));
         }

      // Cleanup the threadstartup information
          threadStartInfoObject.cleanUp( );
          threadStartInfoObject = null;
   }
   public synchronized void run( )
   {
      try{
         ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr( );
         if( this.isPrimaryThread( ) )
         {
            threadControlBlockPtr.setPrimaryThread( true );
            threadControlBlockPtr.setCurrentInputToStdIn( );
            threadControlBlockPtr.setOutputToStdOut( );
            if ( !processCommandLine( ) )
            {
                 System.exit( 1 );
             }
            OutputWriter.PrintHelp( );
            initCommandProcessing( );
         }
         else
         {
            threadStartFunction( );
         }

         processCommands( );
         destroyThreadControlBlockPtr( );
         termCommandProcessing( );
         if( this.isPrimaryThread( ) )
         {
            cleanupThreadEnvironment( );
         }
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "IOException caught\n" );
      }
   }

   public static void main( String[] args ) {
      try {
         JavaDriver driver = new JavaDriver( );
         driver.setCommandLineArgs( args );
         driver.setPrimaryThread( true );
         driver.start( );
      }
      catch( Exception e ) {
         OutputWriter.PrintString( "Error in executing the command\n" );
      }
      finally
      {
          if( JavaDriver.getControlStructObject() != null )
          {
              JavaDriver.getControlStructObject().clear( );
          }
      }
   }

}

class ThreadControlLocalStorage extends ThreadLocal{

   protected Object initialValue( )
   {
      super.initialValue( );
      ThreadControlBlock threadControlBlockPtr = new ThreadControlBlock( );
      set( threadControlBlockPtr );
      return get( );
   }
}



class RandomNumberThread extends Thread{
   Object waitObj;
   Object replyObj;
   boolean needNumber = false;
   boolean numberAvailable = false;
   int value;
   Random rd;

     public RandomNumberThread( int randomNumberSeed )
     {
        waitObj = new Object( );
        replyObj = new Object( );
        rd = new Random( (long) randomNumberSeed );
     }
     public void setWaitObjToNull( )
     {
        waitObj = null;
     }
     public void setReplyObjToNull( )
     {
        replyObj = null;
     }
     public void run()
     {
         try
         {
            while( true )
            {
               synchronized( waitObj )
               {
                  while( !needNumber ) waitObj.wait( );
                  needNumber = false;
               }
               value = rd.nextInt( JavaDriver.RAND_MAX );
               synchronized( replyObj )
               {
                  numberAvailable = true;
                  replyObj.notify( );
               }
            }
         }
         catch( InterruptedException e )
         {
           // System.out.println( "Interrupted Exception ...in simplethread run");
         }

     }


     public  synchronized int getRandomNumber()
     {
         int val = 0;
          try{
             synchronized( waitObj )
             {
                needNumber = true;
                waitObj.notify( );
             }
             synchronized( replyObj )
             {
                while( !numberAvailable ) replyObj.wait( );
                val = value;
                numberAvailable = false;
             }
         }
         catch( InterruptedException e )
         {
            System.out.println( "Interrupted Exception ...in simplethread run");
         }
         return val;

     }
}
