/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.ARServerUser;
import com.remedy.arsys.api.NameID;
import com.remedy.arsys.api.Proxy;
import com.remedy.arsys.api.ProxyManager;
import com.remedy.arsys.api.ProxyPool;
import com.remedy.arsys.api.Value;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class PoolingProxyManager
extends ProxyManager {
    private int maxProxiesPerServer;
    private Hashtable serverProxyPools = new Hashtable();

    PoolingProxyManager(int n) {
        this.maxProxiesPerServer = n;
    }

    public Proxy getProxy(ARServerUser aRServerUser, boolean bl) throws ARException {
        Proxy proxy;
        if (aRServerUser.isProxyInContext()) {
            proxy = aRServerUser.getProxy();
        } else {
            String string = this.getKeyForServer(aRServerUser);
            ProxyPool proxyPool = this.getServerPool(string);
            proxy = proxyPool.get(aRServerUser);
            Value value = proxy.ARGetSessionConfiguration(aRServerUser, 6);
            if (value.getIntValue() == 1) {
                this.setProxyProperties(aRServerUser, proxy);
            }
        }
        return proxy;
    }

    private void setProxyProperties(ARServerUser aRServerUser, Proxy proxy) throws ARException {
        if (proxy == null || aRServerUser == null) {
            return;
        }
        if (aRServerUser.getPort() != 0 || aRServerUser.getLockToSocketNumber() != 0L) {
            proxy.ARSetServerPort(aRServerUser, new NameID(aRServerUser.getServer()), aRServerUser.getPort(), (int)aRServerUser.getLockToSocketNumber());
        }
        proxy.ARSetSessionConfiguration(aRServerUser, 1, new Value(aRServerUser.getChunkResponseSize()));
        proxy.ARSetSessionConfiguration(aRServerUser, 2, new Value(aRServerUser.getTimeoutNormal()));
        proxy.ARSetSessionConfiguration(aRServerUser, 3, new Value(aRServerUser.getTimeoutLong()));
        proxy.ARSetSessionConfiguration(aRServerUser, 4, new Value(aRServerUser.getTimeoutXLong()));
        proxy.ARSetSessionConfiguration(aRServerUser, 5, new Value(aRServerUser.getLockToSocketNumber()));
        proxy.ARSetSessionConfiguration(aRServerUser, 7, new Value(aRServerUser.getClientType()));
        proxy.ARSetSessionConfiguration(aRServerUser, 8, new Value(aRServerUser.getVUIType()));
        proxy.ARSetSessionConfiguration(aRServerUser, 9, new Value(aRServerUser.getOverridePrevIP()));
        proxy.ARSetSessionConfiguration(aRServerUser, 1960, new Value(aRServerUser.getReservedParam1()));
    }

    private synchronized ProxyPool getServerPool(String string) throws ARException {
        ProxyPool proxyPool = (ProxyPool)this.serverProxyPools.get(string);
        if (proxyPool == null) {
            proxyPool = new ProxyPool(this.maxProxiesPerServer);
            this.serverProxyPools.put(string, proxyPool);
        }
        return proxyPool;
    }

    public void releaseProxy(Proxy proxy, ARServerUser aRServerUser, boolean bl) {
        if (!aRServerUser.isProxyInContext()) {
            String string = this.getKeyForServer(aRServerUser);
            try {
                ProxyPool proxyPool = this.getServerPool(string);
                proxyPool.put(proxy);
            }
            catch (ARException aRException) {
                // empty catch block
            }
        }
    }

    synchronized void clear() {
        Enumeration enumeration = this.serverProxyPools.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ProxyPool proxyPool = (ProxyPool)this.serverProxyPools.get(string);
            proxyPool.clear();
        }
        this.serverProxyPools.clear();
    }

    synchronized ProxyManager.PoolInfo[] getInfo() {
        ArrayList<ProxyManager.PoolInfo> arrayList = new ArrayList<ProxyManager.PoolInfo>();
        Enumeration enumeration = this.serverProxyPools.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ProxyPool proxyPool = (ProxyPool)this.serverProxyPools.get(string);
            if (proxyPool == null) continue;
            ProxyManager.PoolInfo poolInfo = proxyPool.getInfo(string);
            arrayList.add(poolInfo);
        }
        return arrayList.toArray(new ProxyManager.PoolInfo[0]);
    }

    protected void finalize() {
        this.clear();
    }

    private String getKeyForServer(ARServerUser aRServerUser) {
        String string = aRServerUser.getServer();
        int n = aRServerUser.getPort();
        if (n != 0) {
            string = string + ":" + n;
        }
        return string;
    }
}

