import java.io.*;
import java.util.*;
import java.math.*;
import com.remedy.arsys.api.*;

public class InputReader{

    static Stack         inputSources = new Stack( );
    static BufferedReader  currentInputSource = new BufferedReader( new InputStreamReader( System.in ) );
    static boolean  nullPromptOption = false;
   
    
    public static void SetNullPromptOption( boolean value )
    {
        nullPromptOption = value;
    }

    public static boolean GetNullPromptOption( )
    {
        return nullPromptOption;
    }


    public static void GetInputLine( )
    throws IOException{

        String inputLine = null;
        ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr( );
        BufferedReader currentInputFile = threadControlBlockPtr.getCurrentInputFile( );

        inputLine = currentInputFile.readLine( );

        if( inputLine == null )  /* eof; print error and exit */
        {
           if( threadControlBlockPtr.isCurrentInputSourceStdInput( ) )
           {
              OutputWriter.DriverPrintError("\n*** EOF on input file; exiting\n");
              System.exit(1);
           } 
           // nested file; return to previous 
           threadControlBlockPtr.closeCurrentInputFile( );
           GetInputLine( );
           return;
        }
        threadControlBlockPtr.addToCurrentInputFilePosition( inputLine.length( ) );

        // record command if recording is active
           PrintWriter fp = threadControlBlockPtr.getRecordFile( );
           if( fp != null )
           {
              if( !inputLine.equals( "srec" ) )                    
              {
                    fp.write( inputLine );
                    fp.write( "\n" );
              }       
           }

        // remove any trailing white spaces
           int index = 0;
           for( index = inputLine.length( ) - 1; index >=0; index-- )
           {
               if( (inputLine.charAt( index ) != ' ' ) || (inputLine.charAt( index ) != '\t' ) ||
                   (inputLine.charAt( index ) != '\n' ) )
               {
                   break;
               }
           }
                 
        threadControlBlockPtr.setBuffer(  inputLine.substring( 0, index+1 ) );
     
        // Process if it is a comment           
           if( ( inputLine.length( ) >=  1 ) && (inputLine.charAt( 0 ) == '#' ))
           {
               if( JavaDriver.processCommentLine( inputLine ) &&
                  ( threadControlBlockPtr.getIsStdOut( ) == false ) )
               {
                   OutputWriter.DriverPrintResult( inputLine + "\n" );
               }
           }
           
        return;
    }
   

    public static boolean GetBoolean( String prompt, boolean defaultVal)
    throws IOException{      
 
        if( !GetNullPromptOption( ) )
        {
            return defaultVal;
        }

        OutputWriter.DriverPrintPrompt( prompt );

        boolean         val = defaultVal;
        GetInputLine( );
  
        ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr( );
        String input = threadControlBlockPtr.getBuffer( );

        if( input.length( ) != 0 )
        {
            if( input.equals( "t" ) || input.equals( "true" ) || input.equals( "T" ) )
            {
                val =  true;
            }
            else
            {
                val = false;
            }
        }       

        return val;
    }  

    public static boolean GetBooleanForChangingInfo( String prompt, boolean defaultVal)
    throws IOException{      

        OutputWriter.DriverPrintPrompt( prompt );

        boolean         val = defaultVal;
        GetInputLine( );  

        ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr( );
        String input = threadControlBlockPtr.getBuffer( );

        if( input.length( ) != 0 )
        {
            if( input.equals( "t" ) || input.equals( "true" ) || input.equals( "T" ) )
            {
                val =  true;
            }
            else
            {
                val = false;
            }
        }       

        return val;
    }  
    public static int GetInt(int defaultVal)
    throws IOException {

       GetInputLine();      
       ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr( );
       String input = threadControlBlockPtr.getBuffer( );

       int value = defaultVal;

       if( input.length() != 0)
       {
          Integer val = new Integer( input );
          value = val.intValue();
       }
       return value;
    }

    public static int GetInt(String prompt, int defaultVal) 
    throws IOException{      

        OutputWriter.DriverPrintPrompt( prompt );

        return GetInt(defaultVal);
    }  

    public static long GetLong( String prompt, long defaultVal )
    throws IOException{       

       OutputWriter.DriverPrintPrompt( prompt );

       long value = defaultVal;
       GetInputLine( );

       ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr( );
       String input = threadControlBlockPtr.getBuffer( );

       if( input.length( ) != 0 )
       {
           Long val = new Long( input );
           value =  val.longValue( );
       }

       return value;   
    }  


    public static float GetFloat(String prompt, float defaultVal)
    throws IOException{      

        OutputWriter.DriverPrintPrompt( prompt );

        float value = defaultVal;
        GetInputLine( );

       ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr( );
       String input = threadControlBlockPtr.getBuffer( );

       if( input.length( ) != 0 )
       {
          Float val = new Float( input );

          value = val.floatValue( );
       } 
       return value;
    }  

    public static char GetChar( String prompt, char defaultVal )
    throws IOException{      

       OutputWriter.DriverPrintPrompt( prompt );

       char value = defaultVal;
       GetInputLine( );

       ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr( );
       String input = threadControlBlockPtr.getBuffer( );

       if( input.length( ) != 0 )
       {
           value =  input.charAt( 0 );
       }

       return value; 
    }  



    public static String GetString(String prompt, String defaultVal)
    throws IOException{      

       OutputWriter.DriverPrintPrompt( prompt );
       GetInputLine( );     

       ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr( );
       String value = threadControlBlockPtr.getBuffer( );

       if( ( value == null ) || (value.length( ) == 0 ) )
       {
            return defaultVal;
       }
      
      ARServerUser  tmpContext = threadControlBlockPtr.getContext( );
      if( tmpContext != null )
      {
          if( value.equals(  "$USER$") )
          {
               if( tmpContext.getUser( ) != null )
               {
                   threadControlBlockPtr.setBuffer( tmpContext.getUser( ).getValue( ) );
               }
           }
           if( value.equals( "$SERVER$" ) )
           {
               threadControlBlockPtr.setBuffer( tmpContext.getServer( ) );
           }
           if( value.equals( "$FIRST_LIST_ID$" ) )
           {
               threadControlBlockPtr.setBuffer( threadControlBlockPtr.getFirstListId ( ) );
           }
           if( value.equals( "$SECOND_LIST_ID$" ) )
           {
               threadControlBlockPtr.setBuffer( threadControlBlockPtr.getSecondListId ( ) );
           }
           if( value.equals( "$LAST_LIST_ID$" ) )
           {
               threadControlBlockPtr.setBuffer( threadControlBlockPtr.getLastListId ( ) );
           }
      }
      value = new String( threadControlBlockPtr.getBuffer( ) );
      return value;
    }  

    public static Time GetTimeOfDay(String prompt, Time defaultTime)
    throws IOException{  

      OutputWriter.DriverPrintPrompt(prompt + "(" + defaultTime.getValue() + "): ");

      Time timeOfDay = new Time(defaultTime.getValue());

      GetInputLine(); 
      ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr( );
      String s = threadControlBlockPtr.getBuffer( );              

      if(s.length() != 0)
      {
         Long val = new Long(s);
         timeOfDay.setValue(val.longValue());
      }

      return timeOfDay;
    }

    public static Timestamp GetTimestamp( String prompt, Timestamp defaultTime )
    throws IOException{  

        if( GetBoolean( "Null Timestamp (F): ", false ) )
        {
            return null;
        }

        String input = GetString( prompt , "" );

        Timestamp time = new Timestamp( defaultTime.getValue( ) );              

        if( input.length( ) != 0 )
        {
            Long val = new Long( input );
            time.setValue( val.longValue( ) );
        }

        return time;
    }

    public static Timestamp[] GetTimestampList()
    throws IOException{  

      Timestamp[]   timestampList = null;
      int numItems = GetInt("Number of Timestamps (0): ", 0);
      if(numItems != 0)
      {
         timestampList = new Timestamp[numItems];
         for(int i = 0; i < numItems; i++)
         {
            timestampList[i] = GetTimestamp("   Timestamp: (0)", new Timestamp(0));            
         }
      }
            
      return timestampList;
   }
    public static EntryID[] GetEntryIDList( )
    throws IOException{ 

        int numEntries = GetInt( "   Number of entry ids(0): ", 0 );
    
        EntryID[] idList = null;

        if( numEntries != 0 )
        {
            idList = new EntryID[ numEntries ];

            String s;
            for( int i = 0; i < numEntries; i++ )
            {
                s = GetString( "   Entry Id " + i + "(): ", "" );
                idList[i] = new EntryID( s );                     
            }
        }
        return idList;        
    }

    public static InternalID[] GetInternalIDList( )
    throws IOException{     

        InternalID[]  idList = null;       

        int  numItems = GetInt( "  Number of ids( 0 ): ", 0 );
              
        if( numItems != 0 )
        {            
            idList = new InternalID[ numItems ];                                
            for( int  i = 0; i < numItems; i++ )
            {          
                idList[i] = new InternalID( GetLong( "    Id  " + i  + " ( 1 ): ", 1 ) );
            }
        }

        return idList;
    }
    public static SchemaType[] GetSchemaTypeList( )
    throws IOException{     

        SchemaType[]  schemaTypeList = null;       

        int  numItems = GetInt( "  Number of  Values( 0 ): ", 0 );
              
        if( numItems != 0 )
        {            
            schemaTypeList = new SchemaType[ numItems ];                                
            for( int  i = 0; i < numItems; i++ )
            {          
                schemaTypeList[i] = GetSchemaType( );
            }
        }

        return schemaTypeList;
    }

    public static NameID[] GetNameIDList(  String indent )
    throws IOException{
 
        NameID[]   nameList = null;

        int numItems = GetInt(  indent + "   Number of names (0): ", 0);
        if( numItems != 0)
        {     
            nameList = new NameID[ numItems ];

            for( int i = 0; i < numItems; i++ )
            {               
                nameList[i] = new NameID( GetString(  indent + "   Name " + "(" + i + "): ", "" ) );
            }
        }

        return nameList;
    }

    public static ContainerKey[] GetContainerKeyList(  String indent )
    throws IOException{
 
        ContainerKey[]   nameList = null;

        int numItems = GetInt(  indent + "Number of container Keys (0): ", 0);
        if( numItems != 0)
        {     
            nameList = new ContainerKey[ numItems ];

            for( int i = 0; i < numItems; i++ )
            {               
                nameList[i] = new ContainerKey( GetString(  indent + "Name " + "(" + i + "): ", "" ) );
            }
        }

        return nameList;
    }

    public static ContainerKey[] GetApplicationKeyList(  String indent )
    throws IOException{
 
        ContainerKey[]   nameList = null;

        int numItems = GetInt(  indent + "Number of application keys (0): ", 0);
        if( numItems != 0)
        {     
            nameList = new ContainerKey[ numItems ];

            for( int i = 0; i < numItems; i++ )
            {               
                nameList[i] = new ContainerKey( GetString(  indent + "Name " + "(" + i + "): ", "" ) );
            }
        }

        return nameList;
    }



    public static void GetARServerUser(  )
    throws IOException{

        OutputWriter.DriverPrintPrompt( "Control record:\n" );

        ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();        
        
        ARServerUser serverUser = threadControlBlockPtr.getContext( );
        String authentication = null;
        if( (serverUser.getAuthentication( ) != null)  )
        {
            authentication = GetString(  "   Authentication String (" + serverUser.getAuthentication() + "): ", serverUser.getAuthentication( ) );
        }
        else
        {
            authentication = GetString(  "   Authentication String (): ", "" );
        }
         serverUser.setAuthentication( authentication );

        String name = null;
        if( (serverUser.getUser( ) != null) && (serverUser.getUser().getValue( ) != null ) )
        {
            name = GetString(  "   User name (" + serverUser.getUser( ).getValue( ) + "): ", serverUser.getUser( ).getValue( ) );
        }
        else
        {
            name = GetString(  "   User name (): ", "" );
        }
        serverUser.setUser( new AccessNameID( name ) );

        String password = null;
        if( (serverUser.getPassword( ) != null) && (serverUser.getPassword().getValue( ) != null ) )
        {
            password = GetString(  "   Password (" + serverUser.getPassword( ).getValue( ) + "): ", serverUser.getPassword( ).getValue( ) );
        }
        else
        {
           password = GetString(  "   Password(): ", "" );
        }

        serverUser.setPassword(new AccessNameID(password));

        String locale = null;
        if( serverUser.getLocale( ) != null )
        {
           locale = GetString( "   Locale (" + serverUser.getLocale( ) + "): ", serverUser.getLocale( ) ); 
        }
        else
        {
           locale = GetString( "   Locale () : ", "" );
        }
        serverUser.setLocale( locale );

        String timeZone = null;
        if( serverUser.getTimeZone( ) != null )
        {
           timeZone = GetString( "   TimeZone (" + serverUser.getTimeZone( ) + "): ", serverUser.getTimeZone( ) ); 
        }
        else
        {
           timeZone = GetString( "   TimeZone () : ", "" );
        }
        serverUser.setTimeZone( timeZone );

        String server = null;
        if( serverUser.getServer( ) != null )
        {
           server = GetString( "   Server (" + serverUser.getServer( ) + "): ", serverUser.getServer( ) ); 
        }
        else
        {
           server = GetString( "   Server () : ", "" );
        }
        serverUser.setServer( server );                    
    }


    public static FilterStatusInfo GetFilterStatusInfo( )
    throws IOException{

        OutputWriter.DriverPrintPrompt( "Status Info:\n" );  

        if( GetBoolean( "Null Filter Status Info (F): ", false ) )
        {
            return null;
        }    

        long messageType   = GetLong( "   Note, Warning, or Error (0, 1, 2) (2) : ",2 );
        long messageNumber = GetLong( "   Message number (0): ", 0 );
        String messageText   = GetString( "   Message Text( ):  ", "" );
       
        return new FilterStatusInfo( messageType, messageNumber, messageText );
    }

    public static MessageInfo GetMessageInfo( )
    throws IOException{

        OutputWriter.DriverPrintPrompt( "Message Info:\n" );

        if( GetBoolean( "Null Message Info (F): ", false ) )
        {
            return null;
        }     

        long messageType   = GetLong( "   Note, Warning, or Error (0, 1, 2) (2) : ",2 );

        long messageNumber = GetLong( "   Message number (10000): ", 10000 );

        String messageText   = GetString( "   Message Text( ):  ", "" );

        boolean usePane       = GetBooleanForChangingInfo( "   Use Prompting Pane? (T): ", true );
       
        return new MessageInfo( messageType, messageNumber, messageText, usePane );
    }

    public static CoordinateInfo[] GetCoordinateInfoList( )
    throws IOException{

        CoordinateInfo[] coordinates = null;

        int  numberOfItems = GetInt( "Number of Items in the List (0): ", 0 );
        if( numberOfItems != 0 )
        {
            coordinates = new CoordinateInfo[ numberOfItems ];

            int   i;
            long  x;
            long  y;

            for( i = 0; i < numberOfItems; i++ )
            {
                x = GetLong("x (" + i + "): ",  0 );                  
                y = GetLong("y (" + i + "): ",  0 );
                 
                coordinates[i] = new CoordinateInfo( x, y );
            }
        }
        
        return coordinates;   
    }

    public static ByteListInfo GetByteListInfo( )
    throws IOException{

        if( GetBoolean( "Null ByteListInfo (F): ", false ) )
        {
            return null;
        }

        byte[]   byteArray = null;

        int type = GetInt( "Byte List Type (0): ", 0 );

        int numberOfBytes = GetInt( "Number of Items in the List (0): ", 0 );
        if( numberOfBytes != 0 )
        {
            byteArray = new byte[numberOfBytes];
            for( int i = 0; i < numberOfBytes; i++ )
            {  
               byteArray[ i ] =  ( byte )GetChar( "Byte (" + i + "): ",  '0' );               
            }
        }
        
        return new ByteListInfo( type, byteArray );       
    }

    public static AttachmentInfo GetAttachmentInfo( )
    throws IOException{

        if( GetBoolean( "Null AttachmentInfo (F): ", false ) )
        {
            return null;
        }

        String name =  GetString( "Attachment Name(): ", "" );


        int choice = GetInt( "Choose:\n" +
                        "   1 - prompt for filename,\n" +
                        "   2 - prompt for string\n" +
                        "   default (1): ", 1 );

        if( ( choice < 1 ) || ( choice > 2 ) )
        {
            OutputWriter.DriverPrintWarning( "   ERROR: choice outside range 1-4; defaulting to prompt for filename(1)" );
            choice = 1;
        }



        if(  choice == 1 )
        {
             String cname = null;
             if( GetBoolean( "Null FileName? (F):", false ) == false )
             {
                  cname = GetString( "File Name ():", "" );
              }

            File fp = new File( cname );
            if( fp.exists( )  && fp.canRead( ) )
            {
                return new AttachmentInfo( name, fp.length( ), fp.length( ), cname );
            }
            else
            {
                 OutputWriter.DriverPrintError("  ERROR: failed to open file\n");
                 return null;
            }
        }
        else
        {
            String content = GetString( "Enter String(): ", "" );
            byte[] loc = content.getBytes();
            return new AttachmentInfo( name, loc.length, loc.length, content.getBytes( ) );
        }
    }

    public static Value GetValue( )
    throws IOException{
               
        if( GetBoolean( "Null Value (F): ", false ) )
        {
            return null;
        }

        int dataType = GetInt(  "Datatype Null/Key/Int/Real/Char/Diary/Enum/Time/Bitmask/Byte\n    Decimal/attach/currency/date/timeofday/join/trim/control/Table/Column/ulong/coords/view/display (0 - 14, 30-34, 40-43) (0): ", 0 );
     
        Value val = GetValue( dataType );
        
        return val;
    }

    public static Value GetValue( int dataType )
    throws IOException{               
     
        Value val = null;
        switch( dataType )
        {
            case Constants.AR_DATA_TYPE_NULL :  
                val =  new Value( );
                break;

            case Constants.AR_DATA_TYPE_KEYWORD:              
                int keycode = GetInt("Keyword Code (0): ", 0);
                val = new Value( Keyword.toKeyword(keycode ) );                
                break;  
        
            case Constants.AR_DATA_TYPE_INTEGER:  
                int intVal = GetInt( "Integer Value (0): ", 0 );
                val =  new Value( intVal );       
                break;

            case Constants.AR_DATA_TYPE_REAL:
                double doubleVal = (double) GetFloat("Real Value (0.0): ", (float)0.0 );
                val = new Value( doubleVal );
                break;

            case Constants.AR_DATA_TYPE_CHAR  :
                String name = GetString( "Char Value (): ", "" );
                val = new Value( name );
                break;

            case Constants.AR_DATA_TYPE_DIARY  :
                String dairyValue = GetString( "Diary Value (): ", "" );
                val = new Value( new Diary( dairyValue ) );
                break;

            case Constants.AR_DATA_TYPE_ENUM:
                long enumVal = GetLong( "Enum Value( 0 ): ", 0 );
                val =  new Value( DataType.ENUM, enumVal );
                break;

            case Constants.AR_DATA_TYPE_TIME:
                Timestamp timeStamp = GetTimestamp("Time Value (0):", new Timestamp( 0 ) );
                val = new Value( timeStamp );
                break;
            case Constants.AR_DATA_TYPE_TIME_OF_DAY:
               Time timeOfDay = GetTimeOfDay("Time Of Day Value(0):", new Time(0));
               val = new Value(timeOfDay);
               break;
            
            case Constants.AR_DATA_TYPE_BITMASK:
                long maskVal = GetLong("Bitmask Value (0): ", 0);
                val = new Value( DataType.BITMASK, maskVal );
                break;

            case Constants.AR_DATA_TYPE_BYTES :
                ByteListInfo byteList = GetByteListInfo(  );
                val = new Value( byteList );
                break;

            case Constants.AR_DATA_TYPE_JOIN    :
                 val = new Value(  null, DataType.JOIN );
                 break;

            case Constants.AR_DATA_TYPE_TRIM    :
                 val = new Value(  null, DataType.TRIM );
                 break;

            case Constants.AR_DATA_TYPE_CONTROL :
                 val = new Value(  null, DataType.CONTROL );
                 break;

            case Constants.AR_DATA_TYPE_PAGE    :
                 val = new Value(  null, DataType.PAGE );
                 break;

           case Constants.AR_DATA_TYPE_PAGE_HOLDER :
                val = new Value( null, DataType.PAGE_HOLDER );
                break;

           case Constants.AR_DATA_TYPE_ATTACH_POOL :
                 val = new Value(  null, DataType.ATTACHMENT_POOL );              
                 break;

            case Constants.AR_DATA_TYPE_ULONG :
                long ulongVal = GetLong( "Ulong Value (0): ", 0 ); 
                val = new Value( DataType.ULONG, ulongVal );
                break;

            case Constants.AR_DATA_TYPE_COORDS  :
                CoordinateInfo[] coords = GetCoordinateInfoList( );                
                val =  new Value( coords );
                break;

            case Constants.AR_DATA_TYPE_ATTACH  :
                AttachmentInfo attach = GetAttachmentInfo( );                
                val = new Value( attach );
                break;

            case Constants.AR_DATA_TYPE_DECIMAL :
                String decimalString = GetString("Decimal Value ():", "" );
                BigDecimal decimalValue = new BigDecimal( decimalString );
                val = new Value(  decimalValue );
                break;

            case Constants.AR_DATA_TYPE_CURRENCY:
                String value = GetString("Value (0.0):", "");
                String currencyCode = GetString("CurrencyCode (USD):", "USD");
                Timestamp conversionDate = GetTimestamp("Conversion Date (0):", new Timestamp(0));
                CurrencyInfo currencyInfo = new CurrencyInfo(value, currencyCode, conversionDate, null);
                val = new Value(currencyInfo);
                break;

            case Constants.AR_DATA_TYPE_VIEW  :
                 String view = GetString( "View Value (): ", "" );
                 val = new Value( view, DataType.VIEW );
                 break;

            case Constants.AR_DATA_TYPE_DISPLAY  :
                 String display = GetString( "Display Value (): ", "" );
                 val = new Value(  display, DataType.DISPLAY  );
                 break;

            default :
                 break;
        }
        
        return val;
    }


    static public Value[] GetValueList( )
    throws IOException{

        Value[] valueList = null;

        int   numberOfValues = GetInt("   Number of values (0): ", 0 );

        if( numberOfValues != 0 )  
        {
            valueList = new Value[ numberOfValues ];
            for( int i = 0; i < numberOfValues; i++ )
            {
               valueList[i] = GetValue( );            
            }
        }

        return valueList;
    }

    static public EntryListFieldInfo GetEntryListFieldInfo( )
    throws IOException{

        OutputWriter.DriverPrintPrompt( "   Entry list field Info\n" );

        if( GetBoolean( "Null EntryListFieldInfo (F): ", false ) )
        {
            return null;
        }

        long  id = GetLong( "      Field id (0): ", 0 );
        FieldID fieldId = new FieldID( id );

        int columnWidth = GetInt( "      Column width (20): ", 20 );

        String separator = GetString( "      Separator(  ): ", "  " );

        return new EntryListFieldInfo( fieldId, columnWidth, separator );
    }


    public static EntryListFieldInfo[] GetEntryListFieldInfoList( )
    throws IOException{
        EntryListFieldInfo[] entryListFieldList = null;

        int numItems = GetInt("Number of  query list fields (0): ", 0);
        if(numItems != 0 )
        {
            entryListFieldList = new EntryListFieldInfo[ numItems ];   
            for( int i = 0; i < numItems; i++ )
            {
                 entryListFieldList[i] = GetEntryListFieldInfo( );
            }
        }
       
        return entryListFieldList;
    }


    public static StatusHistoryValue GetStatusHistoryValue( )
    throws IOException{

        if( GetBoolean( "Null StatusHistoryValue (F): ", false ) )
        {
            return null;
        }

        int index =  GetInt( "Enumerated value index (0): ", 0 );
        int userOrTime = GetInt( "User or Time field (1 or 2) (2): ", 2 );  
  
        boolean type = true;

        if( userOrTime ==  2 )
        {
            type = false;
        }

        return new StatusHistoryValue( type, index );
    }

    public static CurrencyPartInfo GetCurrencyPartInfo() 
    throws IOException{

       InternalID internalID = new InternalID(GetLong("Currency Field Id (0): ", 0));
       int partTag = GetInt("Currency Part - Field,Value,Type,Date,Functional (0-4) (0): ", 0);
       String currencyCode = null;

       if (partTag == Constants.AR_CURRENCY_PART_FUNCTIONAL)
          currencyCode = GetString("Functional currency code:", "");

       return new CurrencyPartInfo(internalID, partTag, currencyCode);
    }

    public static ArithmeticOrRelationalOperand GetArithmeticOrRelationalOperand( )
    throws IOException{

        if( GetBoolean( "Null ArithmeticOrRelationalOperand (F): ", false ) )
        {
            return null;
        }
        OperandType opType = null;     

        int operation = GetInt( "Fld,Value,Arith,Stat-Hist,Val-Set,Currency,Fld-Tran,Fld-DB,L-Var,\nQuery,Currency-Tran,Currency-DB,Currency-Current,Fld-Current (1-6,50-56,99): ",0 );
   

            
        ArithmeticOrRelationalOperand arithOrRlOperand = null;
        opType = OperandType.getOperandType( operation );
        switch( operation )
        {
            case Constants.AR_FIELD:
            case Constants.AR_FIELD_TRAN: 
            case Constants.AR_FIELD_DB:
            case Constants.AR_FIELD_CURRENT: 
                long field = GetLong( "Field id (0): ", 0 );
                FieldID fldId = new FieldID( field );
                arithOrRlOperand =  new ArithmeticOrRelationalOperand( opType, fldId );
                break;

            case Constants.AR_VALUE: 
                Value val = GetValue( );
                arithOrRlOperand =  new ArithmeticOrRelationalOperand( val );
                break;

            case Constants.AR_ARITHMETIC:
                ArithmeticOperationInfo aropInfo = GetArithmeticOperationInfo( );
                arithOrRlOperand =  new ArithmeticOrRelationalOperand( aropInfo );                    
                break;

            case Constants.AR_STAT_HISTORY: 
                StatusHistoryValue stHistoryVal = GetStatusHistoryValue( );
                arithOrRlOperand =  new ArithmeticOrRelationalOperand( stHistoryVal );                     
                break;

            case Constants.AR_VALUE_SET :
                Value[] valList = GetValueList( );
                arithOrRlOperand =  new ArithmeticOrRelationalOperand( valList );                    
                break;

            case Constants.AR_CURRENCY_FLD:
            case Constants.AR_CURRENCY_FLD_TRAN:
            case Constants.AR_CURRENCY_FLD_DB:
            case Constants.AR_CURRENCY_FLD_CURRENT:
                CurrencyPartInfo currencyPartInfo = GetCurrencyPartInfo();
                arithOrRlOperand =  new ArithmeticOrRelationalOperand(opType, currencyPartInfo);
                break;

            case Constants.AR_LOCAL_VARIABLE: 
                int variable = GetInt( "Local Variable number (0 to 10) (0): ", 0 );
                arithOrRlOperand =  new ArithmeticOrRelationalOperand( variable );
                break;

            case Constants.AR_QUERY: 
                QueryInfo qInfo = GetQueryInfo( );
                arithOrRlOperand =  new ArithmeticOrRelationalOperand( qInfo );
                break;
            
            default: OutputWriter.DriverPrintWarning( "Invalid operation.." );
                     break;
        } 

        return arithOrRlOperand;               

    }

    public static ArithmeticOperationInfo GetArithmeticOperationInfo( )
    throws IOException{ 

        if( GetBoolean( "Null ArithmeticOperationInfo (F): ", false ) )
        {
            return null;
        }

        ArithmeticOrRelationalOperand  leftOperand = null;
        ArithmeticOrRelationalOperand  rightOperand = null;      

        int operation =  GetInt("Arithmetic op code -- +, -, *, /, %, unary - (1 - 6): ", 1);

        if( operation != 6 ) // 6 for unary negation
        {
            OutputWriter.DriverPrintPrompt( "Left Operand - " );
            leftOperand = GetArithmeticOrRelationalOperand( );
        }

        OutputWriter.DriverPrintPrompt( "Right Operand - " );

        rightOperand = GetArithmeticOrRelationalOperand( );
 
        return new ArithmeticOperationInfo( operation, leftOperand, rightOperand );
    }

    public static RelationalOperationInfo GetRelationalOperationInfo( )
    throws IOException{

        if( GetBoolean( "Null RelationalOperationInfo (F): ", false ) )
        {
            return null;
        }
        int operation =  GetInt( "Relational op code - EQ, GT, GE, LT, LE, NE, LIKE, IN (1 - 8): ", 1 );

        OutputWriter.DriverPrintPrompt( "Left operand - " );
        ArithmeticOrRelationalOperand leftOperand = GetArithmeticOrRelationalOperand( ); 

        OutputWriter.DriverPrintPrompt( "Right operand - " );
        ArithmeticOrRelationalOperand rightOperand = GetArithmeticOrRelationalOperand( ); 
        
        return new RelationalOperationInfo( operation, leftOperand, rightOperand );
    }

    public static QualifierInfo GetQualifierInfo( )
    throws IOException{

        OutputWriter.DriverPrintPrompt( "Qualifier Info: \n" );

        if( GetBoolean( "Null QualifierInfo (F): ", false ) )
        {
            return null;
        }

      int operation = GetInt( "None, And, Or, Not, Relop or FromField (0, 1, 2, 3, 4, 5) (0): ", 0 );

        IARQualifierOperand opLeft = null;
        IARQualifierOperand opRight = null;
      
        QualifierInfo qInfo = null;

        switch( operation )
        {
            case QualifierInfo.AR_COND_OP_NONE   :
                // nothing to load if no qualifier
                break;

            case QualifierInfo.AR_COND_OP_AND    :
                opLeft = GetQualifierInfo( );
                OutputWriter.DriverPrintPrompt("AND\n");
                opRight = GetQualifierInfo( );
                qInfo = new QualifierInfo( QualifierInfo.AR_COND_OP_AND, ( QualifierInfo )opLeft, ( QualifierInfo )opRight );
                break;

            case QualifierInfo.AR_COND_OP_OR     :
                opLeft = GetQualifierInfo( );
                OutputWriter.DriverPrintPrompt("OR\n");
                opRight = GetQualifierInfo( );
                qInfo = new QualifierInfo( QualifierInfo.AR_COND_OP_OR, ( QualifierInfo )opLeft, ( QualifierInfo )opRight );
                break;
  
            case QualifierInfo.AR_COND_OP_NOT    :
                opLeft = GetQualifierInfo( );
                qInfo = new QualifierInfo( QualifierInfo.AR_COND_OP_NOT, ( QualifierInfo )opLeft, null );
                break;

            case QualifierInfo.AR_COND_OP_REL_OP :
                RelationalOperationInfo rOpInfo = GetRelationalOperationInfo( );
                qInfo = new QualifierInfo( rOpInfo );
                break;

         case QualifierInfo.AR_COND_OP_FROM_FIELD:
               long field = GetLong( "Field id (1):", 1 );
               FieldID fid = new FieldID( field);
               QualifierFromFieldInfo fromFidInfo = new QualifierFromFieldInfo(fid);
               qInfo = new QualifierInfo(fromFidInfo);
               break;

            default  :
                break;
        }               
        return qInfo;    
    }


   public static QualifierInfo[] GetQualifierInfoList( )
   throws IOException{

       QualifierInfo[] qualifierInfoList = null;

        int numItems = GetInt("Number of  qualifierInfo objects(0): ", 0);
        if(numItems != 0 )
        {
            qualifierInfoList = new QualifierInfo[ numItems ];   
            for( int i = 0; i < numItems; i++ )
            {
                 qualifierInfoList[i] = GetQualifierInfo( );
            }
        }
        return qualifierInfoList;
  }

    public static SortInfo GetSortInfo( )
    throws IOException{

        OutputWriter.DriverPrintPrompt( "   Sort list entry\n" );

        if( GetBoolean( "Null SortInfo (F): ", false ) )
        {
            return null;
        }

        InternalID id = new InternalID( GetLong( "      Internal id of field to sort on (0): ", 0 ) );
        int  order =  GetInt( "      Ascending or Descending (1 or 2) (1): ", 1 );     

        return new SortInfo( id, order );  
    }

    public static SortInfo[] GetSortInfoList( )
    throws IOException{  

        SortInfo[]   sortInfoList = null;
        int numItems = GetInt( "Number of sort fields (0): ", 0 );
        if( numItems != 0 )
        {
            sortInfoList = new SortInfo[ numItems ];
            for( int i = 0; i < numItems; i++ )
            {
                sortInfoList[i] = GetSortInfo( );            
            }
        }
         
        return sortInfoList;
    }

   public static IndexInfo GetIndexInfo( )
    throws IOException{

        long id;
        InternalID[] fieldIds;

        OutputWriter.DriverPrintPrompt( "   Index list entry\n" );

        if( GetBoolean( "Null IndexInfo (F): ", false ) )
        {
            return null;
        }

        int numFields = GetInt( "      Number of fields in index (1): ", 1 );

        fieldIds = new InternalID[ numFields ];
        for( int i = 0; i < numFields; i++ )
        {
            id = GetLong( "      Internal id of field to index on (0): ", 0 );
            fieldIds[i] = new InternalID( id );            
        }
        
        boolean unique = GetBooleanForChangingInfo("      Unique index (F): ", false );        

        NameID nameId = GetNameID( "Name" );

        return new IndexInfo( fieldIds, unique, nameId );
    }

    public static IndexInfo[] GetIndexInfoList( )
    throws IOException{  

        IndexInfo[]  indexList = null;
           
        int numItems = GetInt( "Number of indexes (0): ", 0 );

        if( numItems != 0 )
        {
            indexList = new IndexInfo[ numItems ];
            for( int i = 0; i < numItems; i++ )
            {   
                indexList[i] = GetIndexInfo( );
            }
        }

        return indexList;
    }

    public static ArchiveInfo GetArchiveInfo( )
    throws IOException{  

        ArchiveInfo  archive = new ArchiveInfo();
      
        int enable = GetInt( "Enable (0): ", 0 );
        int type = GetInt ( "Archive Type (0-None, 1-form, 2-delete, 3-form&delete): ", 0);
        String form = null;
        if (type == 1 || type == 3)
           form = GetString( "Archive Form Name ():", "" );
           
        QualifierInfo qualifierInfo = GetQualifierInfo( );
        DayInfo di = GetDayInfo();
        archive.setEnable(enable);
        archive.setArchiveType(type);
        archive.setQualifier(qualifierInfo);
        archive.setArchiveDest(form);
        archive.setArchiveTmInfo(di);
        return archive;
    }

    public static CompoundSchemaInfo GetCompoundSchemaInfo( )
     throws IOException{

        if( GetBoolean( "Null CompoundSchemaInfo (F): ", false ) )
        {
            return null;
        }

        int type = GetInt("Schema Type (1): ", 1);

        switch (type) {
           case Constants.AR_SCHEMA_REGULAR:
                return new CompoundSchemaInfo( Constants.AR_SCHEMA_REGULAR ); 
          case Constants.AR_SCHEMA_DIALOG:
                return new CompoundSchemaInfo( Constants.AR_SCHEMA_DIALOG ); 
          case Constants.AR_SCHEMA_JOIN :
                return (CompoundSchemaInfo) GetJoinSchemaInfo( );
           case Constants.AR_SCHEMA_VIEW:
                return (CompoundSchemaInfo) GetViewSchemaInfo( );
           case Constants.AR_SCHEMA_VENDOR:
                return (CompoundSchemaInfo) GetVendorSchemaInfo( );
           default :
                return new CompoundSchemaInfo( type );
        }
    }

    public static FieldMappingInfo GetFieldMappingInfo( )
    throws IOException{
        
        int fieldType = GetInt( "Field Type (1): ", 1 );
        switch( fieldType )
        {
            case Constants.AR_FIELD_NONE    :
                 return new FieldMappingInfo( Constants.AR_FIELD_NONE );

            case Constants.AR_FIELD_REGULAR :
                 return new FieldMappingInfo( Constants.AR_FIELD_REGULAR );

            case Constants.AR_FIELD_JOIN    :
                 int index = GetInt( "   schema index (0): ", 0);
                 long field = GetLong("   real Id (0): ", 0);
              
                return new JoinMappingInfo( index, new FieldID( field ) );

            case Constants.AR_FIELD_VIEW    :
                return new ViewMappingInfo(GetNameID("Field Name"));

            case Constants.AR_FIELD_VENDOR  :
                return new VendorMappingInfo(GetNameID("Field Name"));

            default:
                return null;
        }
    }

    public static PropInfo GetPropInfo( )
    throws IOException{       

        if( GetBoolean( "Null PropInfo (F): ", false ) )
        {
            return null;
        }
        int tag = GetInt( "Prop Tag - ( 0-500 ): ", 0 );
        
        Value val = GetValue( );
        
        return new PropInfo( tag, val );        
    }

    public static PropInfo[]  GetPropInfoList( )
    throws IOException{

        PropInfo[]   propList = null;

        int numItems = GetInt( "Number of Properties (0): ", 0 );

        if( numItems != 0 )   
        {
            propList = new PropInfo[ numItems ];
            for( int i = 0; i < numItems; i++ )
            {
                propList[i] = GetPropInfo( );
            }
        }

        return propList;
    }
 

    public static DisplayInstanceInfo GetDisplayInstanceInfo( )
    throws IOException{

        if( GetBoolean( "Null DisplayInstanceInfo (F): ", false ) )
        {
            return null;
        }
        InternalID id = new InternalID( GetLong( " VUI id ( 0 ): ", 0 ) );              

        PropInfo[] propList = GetPropInfoList( );

        return new DisplayInstanceInfo( id, propList );
    }
  
   
    public static DisplayInstanceList GetDisplayInstanceList( )
    throws IOException{    

        DisplayInstanceInfo[] dispInstanceInfoList = null;

        OutputWriter.DriverPrintPrompt( "Getting the Common Properties for this field\n" );

        PropInfo[] propList =  GetPropInfoList( );

        int numItems = GetInt( "Number of display Instances (0): ", 0 );

        if( numItems != 0 )
        {
            dispInstanceInfoList = new DisplayInstanceInfo[ numItems ];
            for( int  i = 0; i <  numItems; i++ )
            {
                dispInstanceInfoList[i] = GetDisplayInstanceInfo( );
            }
        }
       
        return new DisplayInstanceList( propList, dispInstanceInfoList );
    }

    public static AssignFieldInfo GetAssignFieldInfo( )
    throws IOException{

        if( GetBoolean( "Null AssignFieldInfo (F): ", false ) )
        {
            return null;
        }

        Object obj = null;

        String serverName = GetString( "Server name (): ", "" );
        String schemaName = GetString( "Schema name (): ", "" );

        int tag = GetInt( "Field, status history, currency field (1, 4, 6) (1): ", 1 );

        if (tag == 1)
        {
            obj = new FieldID(GetLong("Field id (0): ", 0 ));
        }
        else if (tag == 4)
        {
            obj = GetStatusHistoryValue( );
        }
        else if (tag == 6)
        {
            obj = GetCurrencyPartInfo( );
        }

        QualifierInfo qualifierInfo = GetQualifierInfo( );

        long noMatchOption = GetInt( "No match action -- error, null, no action, submit (1-4) (2): ", 2 );
        long multiMatchOption = GetInt(
         "Multi match action -- error, null, first, picklist, mod all, no action, submit (1-7) (4): ",
         4);

        return new AssignFieldInfo( serverName, schemaName, qualifierInfo, tag, 
                                    obj, noMatchOption, multiMatchOption );
    }

    public static DDEInfo GetDDEInfo( )
    throws IOException{

        OutputWriter.DriverPrintPrompt( "   Active Link DDE Info:\n" );

        if( GetBoolean( "Null DDEInfo (F): ", false ) )
        {
            return null;
        }

        String serviceName = GetString( "      Service name (): ", "" );

        String topic = GetString( "      Topic (): ", "" );

        long action = GetLong( "      Action (execute, poke, request) (1-3) (1): ", 1 );

        String pathToProgram = GetString( "      Path To Program (): ", "" );
        
        String command = null;
        if( action != 3)
        {
            command = GetString( "      Command (): ", "" );
        }
        else
        {
            command = null;
        }

        String item = null;
        if( GetBooleanForChangingInfo( "      Set an item string? (F): ", false ) )
        {
            item = GetString( "      Item text (): ", "" );
        }
        else
        {
            item = null;
        }

        return new DDEInfo( serviceName, topic, item, action, pathToProgram, command );
    }
    public static AutomationInfo GetAutomationInfo( )
    throws IOException{

        OutputWriter.DriverPrintPrompt( "   Active Link Automation Info:\n" );

        if( GetBoolean( "Null AutomationInfo (F): ", false ) )
        {
            return null;
        }
        
        String serverName = GetString( "      Auto Server name (): ", "" );
        boolean   isVisible = GetBooleanForChangingInfo( "      Showing Automation Server? (T): ", true );

        String classId = GetString( "      Class  Id (): ", "" );
        String action =  GetString( "      Automation Action (): ", "" );
        COMMethodInfo[]  comMethodList = GetCOMMethodInfoList( );

        return new AutomationInfo( serverName, classId, action, isVisible, comMethodList );        
    }
    public static COMValueInfo GetCOMValueInfo( )
    throws IOException{

        if( GetBoolean( "Null COMValueInfo (F): ", false ) )
        {
            return null;
        }
        long transId  = GetLong( "      Transient Id (1): ", 1 );

        String valueId = GetString( "      Value IId (used for method only)(): ", "" );
                
        int valueType = GetInt( "      COM [Method( null -0, fieldId - 1)/Parm( null -0, value - 2)] Type (0): ", 0 );

        long     fieldId = 0;
        Value    val = null;
        switch( valueType ) 
        {
            case Constants.AR_COM_METHOD_FIELDID: 
               fieldId = GetLong( "      FieldId (1): ", 1L );
               break;
 
            case Constants.AR_COM_PARM_VALUE:
              val = GetValue( );
              break;

            default:  break;
        }       
        return new COMValueInfo( valueId, transId, valueType, fieldId, val );
    }

    public static COMMethodParmInfo GetCOMMethodParmInfo(  )
    throws IOException{

        if( GetBoolean( "Null COMMethodParmInfo (F): ", false ) )
        {
            return null;
        }

        String name = GetString( "      Parameter Name (): ", "" );

        long parmType = GetLong( "      COM Parameter Type (VT_EMPTY/VT_NULL/VT_I2/VT_I4/VT_R4/VT_R8/VT_CY/VT_DATE/VT_BSTR/VT_DISPATCH/VT_ERROR/VT_BOOL/VT_VIANT/VT_UNKNOWN/VT_WBSTR) (0-14) (VT_I1/VT_UI1/VT_UI2/VT_UI4/VT_I8/VT_UI8/VT_INT/VT_UINT/VT_VOID/VT_HRESULT/VT_PTR) (16-26) (VT_LPSTR/VT_LPWSTR) (30-31) (VT_BLOB_OBJECT -- 70) (0): ", 0);

        COMValueInfo val = GetCOMValueInfo( );
        
        return new COMMethodParmInfo( name, parmType, val ); 
    }


    public static COMMethodParmInfo[] GetCOMMethodParmInfoList( )
    throws IOException{

       COMMethodParmInfo[]  parmList = null;
 
       int numItems = GetInt( "      Number of Parameters (0): ", 0 );
       if( numItems != 0 )
       {
           parmList = new COMMethodParmInfo[ numItems ];
           for( int i = 0; i < numItems; i++ )
           { 
               parmList[i] = GetCOMMethodParmInfo( ); 
           }
       }

       return parmList;
    }


   public static COMMethodInfo GetCOMMethodInfo( ) 
    throws IOException{

        if( GetBoolean( "Null COMMethodInfo (F): ", false ) )
        {
            return null;
        }
        String name = GetString( "      Method Name (): ", "" );

        String methodId = GetString( "      Method Interface Id (): ", "" );

        long methodType = GetInt( "      COM Method Type (VT_EMPTY/VT_NULL/VT_I2/VT_I4/VT_R4/VT_R8/VT_CY/VT_DATE/VT_BSTR/VT_DISPATCH/VT_ERROR/VT_BOOL/VT_VIANT/VT_UNKNOWN/VT_WBSTR) (0-14) (VT_I1/VT_UI1/VT_UI2/VT_UI4/VT_I8/VT_UI8/VT_INT/VT_UINT/VT_VOID/VT_HRESULT/VT_PTR) (16-26) (VT_LPSTR/VT_LPWSTR) (30-31) (VT_BLOB_OBJECT -- 70) (0): ", 0);

        COMValueInfo value = GetCOMValueInfo( );

        COMMethodParmInfo[ ] paramList = GetCOMMethodParmInfoList( ); 
 
        return new COMMethodInfo( name, methodId, methodType, value, paramList );
    }

    public static COMMethodInfo[] GetCOMMethodInfoList( )
    throws IOException{

        COMMethodInfo[] methodList = null;
 
        int numItems = GetInt( "      Number of Methods (1): ", 1 );
  
        if( numItems != 0 )
        {
            methodList = new COMMethodInfo[ numItems ];
            for( int i = 0; i < numItems; i++ )
            {
                methodList[i] = GetCOMMethodInfo( );
            }
        }
 
        return methodList;
    }

    public static OpenDialogInfo GetOpenDialogInfo( )
    throws IOException{

        OutputWriter.DriverPrintPrompt( "   Active Link Open Dialog Info:\n" );

        if( GetBoolean( "Null OpenDlgInfo (F): ", false ) )
        {
            return null;
        }

        OpenDialogInfo openDlg = new OpenDialogInfo( );

        String serverName =  GetString( "Server Name ():", "" );
        openDlg.setServerName( new ServerNameID( serverName ) );

        NameID schemaName =  GetNameID( "Schema Name" );
        openDlg.setSchemaName( schemaName );

        NameID vuiLabel   =  GetNameID( "Vui Label" );
        openDlg.setVuiLabel( vuiLabel );

        boolean   closeBox   = GetBooleanForChangingInfo( "Close Box? (T): ", true );
        openDlg.setCloseBox( closeBox );

        FieldAssignInfo[] inputFields  = GetFieldAssignInfoList( );
        openDlg.setInputValueFieldPairs( inputFields );

        FieldAssignInfo[] outputFields = GetFieldAssignInfoList( );
        openDlg.setOutputValueFieldPairs( outputFields );

        int mode = GetInt( "Window Mode( 0-9)(0):", 0  );
        openDlg.setWindowMode( mode );

        String targetLocation = GetString( "Target Location ():", "");
        openDlg.setTargetLocation(targetLocation);

        QualifierInfo  query = GetQualifierInfo( );
        openDlg.setQuery( query );

        boolean noMatchContinue = GetBooleanForChangingInfo( "   No Match Continue?(F):", false );
        openDlg.setNoMatchContinue( noMatchContinue );
       
        boolean suppressEmptyLst = GetBooleanForChangingInfo( "Suppress Empty List ? (F):", false );
        openDlg.setSuppressEmptyLst(suppressEmptyLst);

        MessageInfo msg = GetMessageInfo( );
        openDlg.setMsg( msg );

        long interval = GetLong( "Polling interval (0):", 0 );
        openDlg.setPollinginterval( interval );
       
        String reportString = GetString( "Report String ():", "" );
        openDlg.setReportString( reportString );

        SortInfo[] sortOrderList = GetSortInfoList( );
        openDlg.setSortOrderList( sortOrderList );

        return openDlg;
    }

    public static CloseWindowInfo GetCloseWindowInfo( )
    throws IOException{

        OutputWriter.DriverPrintPrompt( "   Active Link Close Window Info :\n" );

        if( GetBoolean( "Null CloseWindowInfo (F): ", false ) )
        {
            return null;
        }
                
        boolean closeAll = GetBooleanForChangingInfo( "Close All? (t): ", true );  

        return new CloseWindowInfo( closeAll );         
    }


    public static CallGuideInfo GetCallGuideInfo( )
    throws IOException{

        OutputWriter.DriverPrintPrompt( "   Active Link Call Guide Info:\n" );

        if( GetBoolean( "Null CallGuideInfo (F): ", false ) )
        {
            return null;
        }

        String name = GetString( "      Server Name: " , "" );

        String guideName =  GetString( "      Guide Name: ", "" );

        int guideMode = GetInt( "      Guide Mode: (0): ", 0 );

        FieldID guideTableId = null;
        if( GetBoolean( "Null FieldID for guideTableID (F):", false ) == false )
        {
            guideTableId = new FieldID( GetLong( "      Guide Table Id (0): ", 0 ) );
        }

        FieldAssignInfo[] inputFields  = GetFieldAssignInfoList();

        FieldAssignInfo[] outputFields = GetFieldAssignInfoList();

        String sampleServer = GetString( "      Sample Server Name: " , "" );

        String sampleGuide =  GetString( "      Sample Guide Name: ", "" );
        
        return new CallGuideInfo( name, guideName, guideMode, guideTableId,
                                  inputFields, outputFields, sampleServer,
                                  sampleGuide );
    }

    public static ExitGuideInfo GetExitGuideInfo( )
    throws IOException{

        OutputWriter.DriverPrintPrompt( "   Active Link Exit Guide Info:\n" );

        if( GetBoolean( "Null ExitGuideInfo (F): ", false ) )
        {
            return null;
        }

        boolean closeAll = GetBooleanForChangingInfo( "      Close All? (T): ", true );  
    
        return new ExitGuideInfo( closeAll );
    }

   public static GotoGuideLabelInfo GetGotoGuideLabelInfo( )
    throws IOException{

        OutputWriter.DriverPrintPrompt( "   Active Link Goto Guide Label Info:\n" );

        if( GetBoolean( "Null GotoGuideLabelInfo (F): ", false ) )
        {
            return null;
        }
 
        String label = GetString( "      Label (): ", "" );  

        return new GotoGuideLabelInfo( label );
    }

    public static WaitInfo GetWaitInfo( )
    throws IOException {

        OutputWriter.DriverPrintHeader( "   Active Link Wait Info:" );

        if( GetBoolean( "Null WaitInfo (F): ", false ) )
        {
            return null;
        }

        String title = GetString("      Continue Button Title ( Continue ): ", "Continue" );

        return new WaitInfo( title );
    } 

    public static AssignSQLInfo GetAssignSQLInfo( )
    throws IOException{


        if( GetBoolean( "Null AssignSQLInfo (F): ", false ) )
        {
            return null;
        }

        String server = GetString( "Server name (): ", "" );

        String command = GetString( "SQL command (): ", "" );

        int valueIndex = GetInt( "Index of returned value to select (1): ", 1 );

        int noMatchOption = GetInt( "No match action -- error, null (1, 2) (2): ",2 );

        int multiMatchOption = GetInt( "Multi match action -- error, null, first, picklist (1, 2, 3, 4) (4): ", 4 );

        return new AssignSQLInfo( server, command, valueIndex, noMatchOption, multiMatchOption );
    }

    public static AssignFilterApiInfo GetAssignFilterApiInfo( )
    throws IOException{

        if( GetBoolean( "Null AssignFilterApiInfo (F): ", false ) )
        {
            return null;
        }
 
        String name = GetString(  "      Service Name: ", "" );
        OutputWriter.DriverPrintPrompt( "      Input Value List:\n" );

        AssignInfo[] list = null;
         int numItems = GetInt( "      Number of Assignments (0): ", 0 );
       
         if( numItems > 0 )
         {
             list = new AssignInfo[numItems];
             for( int i = 0; i < numItems; i++ )
            {
                 list[i] = GetAssignInfo( );
            }
         }

         long index = GetLong( "      Index of the value field (1): ", 1 );

         return new AssignFilterApiInfo( name, list, index );
    }




    
    public static AssignInfo GetAssignInfo( )
    throws IOException{

        if( GetBoolean( "Null AssignInfo (F): ", false ) )
        {
            return null;
        }

        AssignInfo asnInfo = new AssignInfo( );

        int type =  GetInt("Assign type:  None, Value, Field, Process, Arith, Function, DDE, SQL, Filter API (0 - 8): ", 0);

        asnInfo.setAssignType( type );

        switch( type )
        {
            case AssignInfo.AR_ASSIGN_TYPE_VALUE   :
                Value val = GetValue( );
                asnInfo.setValue( val );
                break;

            case AssignInfo.AR_ASSIGN_TYPE_FIELD   :
                AssignFieldInfo fldInfo = GetAssignFieldInfo( );
                asnInfo.setField( fldInfo );
                break;

            case AssignInfo.AR_ASSIGN_TYPE_PROCESS :
                String process = GetString(  "Process to run (): ", ""  );
                asnInfo.setProcess( process );
                break;

            case AssignInfo.AR_ASSIGN_TYPE_ARITH   :
                ArithOpAssignInfo arAsnInfo = GetArithOpAssignInfo( );
                asnInfo.setArithOp( arAsnInfo );
                break;

            case AssignInfo.AR_ASSIGN_TYPE_FUNCTION:
                FunctionAssignInfo fnInfo = GetFunctionAssignInfo( );
                asnInfo.setFunction( fnInfo );
                break;

            case AssignInfo.AR_ASSIGN_TYPE_DDE     :
                DDEInfo  ddeInfo = GetDDEInfo( );
                asnInfo.setDde( ddeInfo ); 
                break;

            case AssignInfo.AR_ASSIGN_TYPE_SQL     :
                AssignSQLInfo sqlInfo = GetAssignSQLInfo( );
                asnInfo.setSql( sqlInfo );
                break;

           case AssignInfo.AR_ASSIGN_TYPE_FILTER_API:
                asnInfo.setFilterApi( GetAssignFilterApiInfo( ) );
                break;

            default                     :
               break;
        }

        return asnInfo;
    }
        
    public static ArithOpAssignInfo GetArithOpAssignInfo( )
    throws IOException{

        if( GetBoolean( "Null ArithOpAssignInfo (F): ", false ) )
        {
            return null;
        }

        AssignInfo leftOperand = null;
        AssignInfo rightOperand = null;
     
        int operation =  GetInt("Arithmetic op code(+): +, -, *, /, %, unary - (1 - 6): ", 1);
        if( operation != 6 )
        {
           OutputWriter.DriverPrintPrompt( "Left Operand - " );

           leftOperand = GetAssignInfo( );
        }

        OutputWriter.DriverPrintPrompt( "Right Operand - " );

        rightOperand = GetAssignInfo( );

        ArithOpAssignInfo asnInfo = new ArithOpAssignInfo( );

        asnInfo.setOperation( (long) operation );
        asnInfo.setOperandLeft( leftOperand );
        asnInfo.setOperandRight( rightOperand );

        return asnInfo;
   }


    public static FunctionAssignInfo GetFunctionAssignInfo( )
    throws IOException{

        if( GetBoolean( "Null FunctionAssignInfo (F): ", false ) )
        {
            return null;
        }
        FunctionAssignInfo fnAssignInfo = new FunctionAssignInfo( );
        
        int functionCode =  GetInt( "Function code -- (1 - 26): ", 1 );

        fnAssignInfo.setFunctionCode( (long) functionCode );

        int numItems = GetInt( "Number of parameters (0): ", 0 );

     
        if( numItems != 0 )
        {
           AssignInfo[]  paramList = new AssignInfo[ numItems ];
           for( int i = 0; i < numItems; i++ )
           {
              OutputWriter.DriverPrintPrompt( "Parameter[" + i + "] - " );
              paramList[i] = GetAssignInfo( );
           }    
           
           fnAssignInfo.setParameterList( paramList );
        }

        return fnAssignInfo;
    }

    public static FieldAssignInfo GetFieldAssignInfo( )
    throws IOException{

        if( GetBoolean( "Null FieldAssignInfo (F): ", false ) )
        {
            return null;
        }

        FieldAssignInfo fldAsnInfo =  new FieldAssignInfo( );

        long fieldId = GetLong( "Field id: ", 0 );
        fldAsnInfo.setFieldId( new InternalID( fieldId ) );

        AssignInfo asnInfo = GetAssignInfo( );
        fldAsnInfo.setAssignment( asnInfo );

        return fldAsnInfo;
    }

    public static FieldAssignInfo[] GetFieldAssignInfoList( )
    throws IOException{

        int numItems = GetInt( "   Number of field/assign pairs (0): ", 0 );
 
        FieldAssignInfo[] fldAssignInfoList = null;

        if( numItems != 0 )
        {
            fldAssignInfoList = new FieldAssignInfo[ numItems ];
            for( int i = 0; i < numItems; i++ )
            {
                fldAssignInfoList[i] = GetFieldAssignInfo( );
            }
        }     

        return fldAssignInfoList;
    }
    
    public static SetFieldsActionInfo GetSetFieldsActionInfo()
    throws IOException {
        NameID sampleSchema =  GetNameID( "   Sample Schema Name: " );
        ServerNameID sampleServer =  new ServerNameID( GetString( "   Sample Server Name : ", "" ) );
        FieldAssignInfo[] setFields = GetFieldAssignInfoList();
        return new SetFieldsActionInfo(sampleSchema, sampleServer, setFields);
    }

    public static PushFieldsActionInfo GetPushFieldsActionInfo() throws IOException {
        NameID sampleSchema =  GetNameID( "   Sample Schema Name: " );
        ServerNameID sampleServer =  new ServerNameID( GetString( "   Sample Server Name : ", "" ) );
        PushFieldsInfo[] fieldList = GetPushFieldsInfoList();
        return new PushFieldsActionInfo(sampleSchema, sampleServer, fieldList);
    }

    public static PushFieldsInfo[] GetPushFieldsInfoList( )
    throws IOException{

        int numItems = GetInt( "   Number of field/assign pairs (0): ", 0 );

        PushFieldsInfo[] fieldList = null;

        if( numItems != 0 )
        {
            fieldList = new PushFieldsInfo[ numItems ];

            for( int i = 0; i < numItems; i++ )
            {
                fieldList[ i ] = new PushFieldsInfo( );

                fieldList[i].setField( GetAssignFieldInfo( ) );
                fieldList[i].setAssign( GetAssignInfo( ) );           
            }
        }  
     
        return fieldList;
    }


   public static SQLInfo GetSQLInfo( )
    throws IOException{

        OutputWriter.DriverPrintPrompt( "Action Direct SQL:\n" );

        if( GetBoolean( "Null SQLInfo (F): ", false ) )
        {
            return null;
        }

        String server = GetString( "      Server (): ", "" );

        String command = GetString( "      SQL command (): ", "" );

        return new SQLInfo( server, command );
    }


   public static  GotoActionInfo GetGotoActionInfo( )
    throws IOException{

        OutputWriter.DriverPrintPrompt( "   Goto Action Info:\n" );

        if( GetBoolean( "Null GotoActionInfo (F): ", false ) )
        {
            return null;
        }
         
        long fieldIdOrValue = 0;

        int tag = GetInt( "      Field, Value, Forward, Backup (1-4): ", 1 );

       switch( tag )
       {
            case 1:
                 fieldIdOrValue = GetLong( "      FieldId (0): ", 0 );
                 break;

            case 2:
                 fieldIdOrValue = GetLong( "      Execution Order (0): ", 0 );  
                 break;

            case 3:
                 fieldIdOrValue = GetLong( "    Execution Order Advance By(1): ", 1 );
                 break;

            case 4:
                 fieldIdOrValue = GetLong( "      Execution Order Backup By (0): ", 1 );  
                 break;              

            default:
                 break;
       }

        return new GotoActionInfo( tag, fieldIdOrValue );
        
    }


    public static FilterActionInfo GetFilterActionInfo( )
    throws IOException{

        OutputWriter.DriverPrintHeader( "Filter Action Info:" );

        if( GetBoolean( "Null FilterActionInfo (F): ", false ) )
        {
            return null;
        }

        FilterActionInfo filterAction = new FilterActionInfo( );

        int action= GetInt(  "   Notify, Message, Log, Fields, Process, Push, SQL, Goto Action, Call Guide, Exit Guide, Goto Guide Label(1-11): ", 0 );

        switch( action )
        {
            case Constants.AR_FILTER_ACTION_NOTIFY:
                NotifyActionInfo notify = GetNotifyActionInfo( );
                filterAction.setNotify( notify );
                break;

            case Constants.AR_FILTER_ACTION_MESSAGE:
                FilterStatusInfo message = GetFilterStatusInfo( );
                filterAction.setMessage( message );
                break;

            case Constants.AR_FILTER_ACTION_LOG:
                String file = GetString( "  Log File name(): ", "" );
                filterAction.setLogFile( file );
                break;

            case Constants.AR_FILTER_ACTION_FIELDS:
                SetFieldsActionInfo fields = GetSetFieldsActionInfo( );
                filterAction.setSetFields( fields );
                break;

            case Constants.AR_FILTER_ACTION_PROCESS:
                String process = GetString( "    Process ():", "" );
                filterAction.setProcess( process );
                break;

            case Constants.AR_FILTER_ACTION_FIELDP:
                PushFieldsActionInfo  push = GetPushFieldsActionInfo( );
                filterAction.setPushFields( push );
                break;

            case Constants.AR_FILTER_ACTION_SQL:
                SQLInfo sqlCommand = GetSQLInfo( );
                filterAction.setSqlCommand( sqlCommand );
                break;

            case Constants.AR_FILTER_ACTION_GOTOACTION:
                GotoActionInfo gotoAction = GetGotoActionInfo( );
                filterAction.setGotoAction( gotoAction );
                break;

            case Constants.AR_FILTER_ACTION_CALLGUIDE:
                filterAction.setCallGuide( GetCallGuideInfo( ) );
                break;

            case Constants.AR_FILTER_ACTION_EXITGUIDE:
                filterAction.setExitGuide( GetExitGuideInfo( ) );
                break;

            case Constants.AR_FILTER_ACTION_GOTOGUIDELABEL:
                filterAction.setGotoGuide( GetGotoGuideLabelInfo( ) );
                break;

            default:
                break;
        }
        return filterAction;
    }

    public static FilterActionInfo[] GetFilterActionInfoList( boolean actionFlag )
    throws IOException{

        int numItems = 0;

        if( actionFlag )
        {
            numItems = GetInt( "Number of actions for the filter (1): ", 1 );
        }
        else
        {
            numItems = GetInt( "Number of elses for the filter (0): ", 0 );
        }

        FilterActionInfo[] list = null;

        if( numItems != 0 )
        {
            list = new FilterActionInfo[ numItems ];
            for( int i = 0; i < numItems; i++ )
            {
                list[i] = GetFilterActionInfo( );
            }
        }
	
        return list;
    }



    public static ActiveLinkMacroInfo GetActiveLinkMacroInfo( )
    throws IOException{  

       OutputWriter.DriverPrintPrompt( "   Active Link Macro Info:\n" );

        if( GetBoolean( "Null ActiveLinkMacroInfo (F): ", false ) )
        {
            return null;
        }

        String macroName = GetString( "      Macro name (): ", "" );

        String text = GetString( "      Macro text(): ", "" );

        MacroParmInfo[] list = null;

        int numItems = GetInt( "      Number of macro parms (0): ", 0 );

        if( numItems != 0 )
        {
            list = new MacroParmInfo[ numItems ];

            String name = null;
            String val  = null;
            for( int i = 0; i < numItems; i++ )
            {
                name =  GetString("         Parm Name (): ", "" );
                val  =  GetString("         Parm Value (): ", "" );

                list[i] = new MacroParmInfo( name, val );
            }
        }

        return new ActiveLinkMacroInfo( macroName, text, list ); 
    }

   public static FieldCharacteristicsInfo GetFieldCharacteristicsInfo( )
    throws IOException{

       OutputWriter.DriverPrintPrompt( "   Active Link Field Characteristics:\n" );

        int option = GetInt( "      Option (bitmask - 1 field reference) (0): ", 0 );

        if( GetBoolean( "Null FieldCharacteristicsInfo (F): ", false ) )
        {
            return null;
        }

        long fieldId = GetLong( "      Field Id (0): ", 0 );
        
        String menu = null;
        if( GetBooleanForChangingInfo( "      Change menu? (F): ", false ) )
        {
            menu = GetString( "      Char menu (): ", "" );
        }

        PropInfo[] propList = null;
        if( GetBooleanForChangingInfo( "      Change display Properties? (F): ", false ) )
        {
            propList = GetPropInfoList( );
        }

        long focus = 0; // unchanged
        if( GetBooleanForChangingInfo( "      Change focus to this field? (F): ", false ) )
        {
            focus = 1;
        }

        int accessOption = GetInt( "      Access option (unchanged, read-only, read/write, disable) (0-3) (0): ", 0 );

        return new FieldCharacteristicsInfo( option, fieldId, menu, propList, focus, accessOption );
    }

    public static ActiveLinkActionInfo GetActiveLinkActionInfo( )
    throws IOException{

        OutputWriter.DriverPrintPrompt( "Active Link Action Info:\n" );

        if( GetBoolean( "Null ActiveLinkActionInfo (F): ", false ) )
        {
            return null;
        }

        ActiveLinkActionInfo action = new ActiveLinkActionInfo( );

        int type= GetInt( " Macro, Fields, Process, Message, Field Characteristics, DDE, Push, SQL, Automation, Open Dialog, Commit Changes, Close Window, Call Guide, Exit Guide, Goto Guide, Wait, Goto Action(1-17): ", 1 );

        switch( type )
        {
            case 1  :
                ActiveLinkMacroInfo activeLinkMacro = GetActiveLinkMacroInfo( );
                action.setMacro( activeLinkMacro );
                break;

            case 2  :
                SetFieldsActionInfo fieldList = GetSetFieldsActionInfo( );
                action.setSetFields( fieldList );
                break;

            case 3 :
                String process = GetString( "   Command string (): ", "" );
                action.setProcess( process );
                break;

            case 4 :
                MessageInfo message = GetMessageInfo( );
                action.setMessage( message );
                break;

            case 5 :
                FieldCharacteristicsInfo field = GetFieldCharacteristicsInfo( );
                action.setCharacteristics( field );
                break;

            case 6     :
                DDEInfo  dde = GetDDEInfo( );
                action.setDde( dde );
                break;

            case 7  :
                PushFieldsActionInfo push = GetPushFieldsActionInfo( );
                action.setPushFields( push );
                break;

            case 8  :
                SQLInfo sql = GetSQLInfo( );
                action.setSqlCommand( sql );
                break;

            case 9  :
                AutomationInfo auto = GetAutomationInfo( );
                action.setAutomation( auto );
                break;

            case 10  :
                OpenDialogInfo openDlg = GetOpenDialogInfo( );
                action.setOpenDlg( openDlg );
                break;

            case 11  :
                CommitChangesInfo commit = GetCommitChangesInfo( );
                action.setCommitChanges( commit );
                break;

            case 12 :
                CloseWindowInfo closeWnd = GetCloseWindowInfo( );
                action.setCloseWnd( closeWnd);
                break;

            case 13 :
                CallGuideInfo callGuide = GetCallGuideInfo( );
                action.setCallGuide( callGuide );
                break;

            case 14 :
                ExitGuideInfo exitGuide = GetExitGuideInfo( );  
                action.setExitGuide( exitGuide );    
                break;

            case 15 :
                GotoGuideLabelInfo guideLabel = GetGotoGuideLabelInfo( );
                action.setGotoGuide( guideLabel );
                break;

            case 16 :
                WaitInfo wait = GetWaitInfo( );
                action.setWaitAction( wait );
                break;

            case 17 :
                GotoActionInfo gotoAction = GetGotoActionInfo( );
                action.setGotoAction( gotoAction );
                break;
      
            default:
                break;
       }

        return action;

    }

    public static ActiveLinkActionInfo[] GetActiveLinkActionInfoList( boolean actionFlag )
    throws IOException{

        int numItems = 0;

        if( actionFlag )
        {
            numItems = GetInt("Number of actions for the active link (1): ",1);
        }
        else
        {
            numItems = GetInt("Number of elses for the active link (0): ", 0);
        }

        ActiveLinkActionInfo[] list = null;

        if( numItems != 0 )
        {
            list = new ActiveLinkActionInfo[ numItems ];
            for( int i = 0; i < numItems; i++ )
            {
                list[i] = GetActiveLinkActionInfo( );
            }
        }
       
        return list;
    }

   public static PermissionInfo GetPermissionInfo( boolean fieldFlag )
    throws IOException{

       OutputWriter.DriverPrintPrompt( "   Permission Info:\n" );

        if( GetBoolean( "Null PermissionInfo (F): ", false ) )
        {
            return null;
        }

        int groupId = GetInt("      Group id (3): ", 0);

        int permissions = 0;

        if( fieldFlag )
        {
            permissions = GetInt( "      None, View, or Change (0, 1, 2): ", 0 );
        }
        else
        {
            permissions = GetInt("      None, Visible, or Hidden(0, 1, 2): ", 0 );
        }

        return new PermissionInfo( new InternalID( groupId ), permissions );
    }




    public static PermissionInfo[] GetPermissionInfoList( boolean fieldFlag )
    throws IOException{

        OutputWriter.DriverPrintPrompt( "Permission List:\n" );

        int numItems = GetInt( "   Number of permission defns (0): ", 0 );

        PermissionInfo[] list = null;
 
        if( numItems != 0 )
        {
            list = new PermissionInfo[ numItems ];
 
            for( int i = 0; i < numItems; i++ )
            {
                list[i] = GetPermissionInfo( fieldFlag );            
            }
        }
        return list;
    }

    public static IntegerLimitInfo GetIntegerLimitInfo( )
    throws IOException{

        if( GetBoolean( "Null Schema List Criteria (F): ", false ) )
        {
            return null;
        }
    
        long low = GetLong("   Integer range low (0): ", 0 );
        long high = GetLong("   Integer range high (5000): ", 5000 );

        return new IntegerLimitInfo(   low, high );     
    }


    public static RealLimitInfo GetRealLimitInfo( )
    throws IOException{

        if( GetBoolean( "Null RealLimitInfo (F): ", false ) )
        {
            return null;
        }
        float rangeLow = GetFloat("   Real range low (0): ", (float) 0);
        float rangeHigh = GetFloat("   Real range high (5000): ", (float) 5000);
        int   precision = GetInt("   Precision (-1 is no precision) (-1): ", -1);
        
        return new RealLimitInfo( rangeLow, rangeHigh, precision );
    }

    public static CharLimitInfo GetCharLimitInfo( )
    throws IOException{   

        if( GetBoolean( "Null CharLimitInfo (F): ", false ) )
        {
            return null;
        }
        int maxLength = GetInt( "   Maximum length (128): ", 128 );
        int menuStyle = GetInt( "   Menu style - Append or Overwrite (1 or 2) (1): ", 1 );
        int qbe = GetInt( "   Match operation - Anywhere, Leading match, or Equal (1 - 3) (1): ", 1 );

        NameID charMenu = GetNameID( "Character menu" );

        String pattern = GetString( "   Pattern (): ", "" );

        int option = GetInt( "   FullText Options(0): ", 0 );

        return new CharLimitInfo( maxLength, menuStyle, qbe, charMenu, pattern, option );
    }  

    public static DiaryLimitInfo GetDiaryLimitInfo()
    throws IOException{

        if( GetBoolean( "Null DiaryLimitInfo (F): ", false ) )
        {
            return null;
        }
        int fullTextOptions = GetInt( "   FullText Options(0): ", 0 );

        return new DiaryLimitInfo( fullTextOptions );
    }


    public static EnumLimitInfo GetEnumLimitInfo( )
    throws IOException{

         if( GetBoolean( "Null EnumLimitInfo (F): ", false ) )
        {
            return null;
        }

         NameID[] list = GetNameIDList( "" );
 
         return new EnumLimitInfo( list );
    }

    public static AttachmentLimitInfo GetAttachmentLimitInfo( )
    throws IOException{

        if( GetBoolean( "Null AttachmentLimitInfo (F): ", false ) )
        {
            return null;
        }

        int maxSize = GetInt( "   maxSize(0): ", 0 );
//        int    type = GetInt( "   attachment Type(1)", 1 );
       
        int type = Constants.AR_ATTACH_FIELD_TYPE_EMBED;
        return new AttachmentLimitInfo( maxSize, type );
    }

    public static TableLimitInfo GetTableLimitInfo( )
    throws IOException{

        if( GetBoolean( "Null TableLimitInfo (F): ", false ) )
        {
            return null;
        }
        NameID schema =  GetNameID( "   schema name" );

        ServerNameID server =  new ServerNameID( GetString( "   server name : ", "" ) );

        QualifierInfo qualifier = GetQualifierInfo( );

        int maxRetrieve = GetInt( "  Max rows to retrieve (10): ", 10 );
 //       int numColumns  = GetInt( "  Number of Columns(0)", 0 );
        int numColumns = 0;

        NameID sampleSchema =  GetNameID( "   sample schema name" );

        ServerNameID sampleServer =  new ServerNameID( GetString( "   sample server name : ", "" ) );
        
        return new TableLimitInfo( numColumns, qualifier, maxRetrieve,
                                   schema, server, sampleSchema,
                                   sampleServer ); 
    }

   public static ColumnLimitInfo GetColumnLimitInfo( )
    throws IOException{

        if( GetBoolean( "Null ColumnLimitInfo (F): ", false ) )
        {
            return null;
        }
        FieldID parentID = null;
        if( GetBoolean( "Null FieldID for parent (F): ", false ) == false )
        {
            long parent = GetLong( "   Parent Table field Id (0): ", 0 );
            parentID = new FieldID( parent );
        }

        FieldID dataFieldID = null;
        if( GetBoolean( "Null FieldID for Data Field (F): ", false ) == false )
        {
            long dataField = GetLong( "   Data field Id (0): ", 0 );
            dataFieldID = new FieldID( dataField );
        }
        int dataSource= GetInt("   Data Source(0): ", 0);
        int colLength = GetInt( "   Length to display(10) : ", 10 );
 
        return new ColumnLimitInfo( parentID, dataFieldID, dataSource, colLength );
    }

    public static DecimalLimitInfo GetDecimalLimitInfo( )
    throws IOException{

        if( GetBoolean( "Null DecimalLimitInfo (F): ", false ) )
        {
            return null;
        }

        String low = GetString( "   Decimal range low (0.0): ", "0.0" );
        String high = GetString( "   Decimal range high (5000.0): ", "5000.0" );
        int precision = GetInt( "   Precision (0): ", 0 );

        return new DecimalLimitInfo( low, high, precision );
    }

  public static CurrencyDetail[] GetCurrencyDetail(String prompt, int defaultOccurances)
   throws IOException
   {
      CurrencyDetail[] currencyDetail = null;
      int i;
      int numCurrencies =   GetInt( prompt + "(" + defaultOccurances + "):", defaultOccurances );
      if (numCurrencies > 0)
      {
         currencyDetail = new CurrencyDetail[numCurrencies];
      }

      for (i=0 ; i < numCurrencies; i++)
      {
         String currencyCode = GetString("   Currency Code (USD): ", "USD");
         int precision = GetInt("   Precision (0): ", 0);
         currencyDetail[i] = new CurrencyDetail(currencyCode, precision);
      } 

      return currencyDetail;
   }

   public static CurrencyLimitInfo GetCurrencyLimitInfo()
   throws IOException{

      String low    =   GetString("   Currency range low (0.0): ", "0.0");
      String high   =   GetString("   Currency range high (5000.0): ", "5000.0");
      int precision =   GetInt("   Precision (0): ", 0);
      CurrencyDetail[] functional = GetCurrencyDetail( "    Number of functional Currencies", 1 );
      CurrencyDetail[] allowable = GetCurrencyDetail( "   Number of Allowable Currencies", 1);

      return new CurrencyLimitInfo(low, high, precision, functional, allowable);
   }

    public static ViewLimits GetViewLimits( )
    throws IOException{
        if( GetBoolean( "Null ViewLimits (F): ", false ) )
        {
            return null;
        }
         int maxLength = GetInt("   Maximum length (128): ", 128);

         return new ViewLimits( maxLength );
    }

    public static DisplayLimits GetDisplayLimits( )
    throws IOException{
        if( GetBoolean( "Null DisplayLimits (F): ", false ) )
        {
            return null;
        }
         int maxLength = GetInt("   Maximum length (128): ", 128);

         return new DisplayLimits( maxLength );
    }

   public static CharMenuItemInfo GetCharMenuItemInfo( )
    throws IOException{

       OutputWriter.DriverPrintPrompt( "Char Menu Item Info:\n" );

        if( GetBoolean( "Null CharMenuItemInfo (F): ", false ) )
        {
            return null;
        }

        NameID menuLabel =  GetNameID( "    Menu Label" );
        int menuType = GetInt( "    Menu type - Value Or Menu (1, 2) (1):", 1 );

        CharMenuItemInfo charMenuItem = null;     
        switch( menuType )
        {
            case 1 :
                String menuItem = GetString( "    Char menu text(): ", "" );
                charMenuItem = new CharMenuItemInfo( menuLabel, menuItem );
                break;

            case 2:               
                CharMenuInfo menuInfo = GetCharMenuInfo( );
                charMenuItem = new CharMenuItemInfo( menuLabel, menuInfo );
                break;
 
            default :              
                break;
        }

        return charMenuItem;
    }

    public static CharMenuQueryInfo GetCharMenuQueryInfo( )
    throws IOException{

        OutputWriter.DriverPrintPrompt( "    Char Menu Query Info:\n" );

        if( GetBoolean( "Null CharMenuQueryInfo (F): ", false ) )
        {
            return null;
        }

        NameID schema = GetNameID( "    Schema Name" );

        ServerNameID server =  new ServerNameID( GetString( "      Server (): ", "" ) );

        QualifierInfo qualifier = GetQualifierInfo( );

        FieldID labelField = new FieldID( GetLong("      Id of the label field (0): ", 0 ) );

        FieldID valueField = new FieldID( GetLong("      Id of the value field (0): ", 0 ) );
   
        boolean sortOnLabel = GetBooleanForChangingInfo( "      Sort the label field (T): ", true );

        NameID sampleSchema = GetNameID( "    Sample Schema Name" );

        ServerNameID sampleServer =  new ServerNameID( GetString( "      Sample Server (): ", "" ) );

        return new CharMenuQueryInfo( schema, server, qualifier, labelField,
                                      valueField, sortOnLabel,
                                      sampleSchema, sampleServer ); 
    }

   public static CharMenuSQLInfo GetCharMenuSQLInfo( )
   throws IOException{

      OutputWriter.DriverPrintPrompt( "Char Menu SQL INFO:\n" );

      if( GetBoolean( "Null CharMenuSQLInfo (F): ", false ) )
      {
         return null;
      }
      ServerNameID server =  new ServerNameID( GetString( "      Server (): ", "" ) );

      String command = GetString( "      SQL command (): ", "" );

      int  labelIndex = GetInt( "      Index of the label field (1): ", 1 );
 
      int  valueIndex = GetInt( "      Index of the value field (1): ", 1);

      return new CharMenuSQLInfo( server, command, labelIndex, valueIndex );
   }

   public static CharMenuItemInfo[] GetCharMenuItemInfoList( )
   throws IOException{
        int numItems = GetInt("   Number of char menu items (0): ", 0);     

       CharMenuItemInfo[] list = null;
       if( numItems > 0 )
       {
           list = new CharMenuItemInfo[ numItems ];
           for( int i = 0; i < numItems; i++ )
           {
               list[i] = GetCharMenuItemInfo( );  
           }
       }

        return list;
   }

   public static CharMenuDDInfo GetCharMenuDDInfo( )
   throws IOException{

      OutputWriter.DriverPrintPrompt( "   Char Menu Data-Dictionary info:\n");

      if( GetBoolean( "Null CharMenuDDInfo (F): ", false ) )
      {
         return null;
      }
      ServerNameID server =  new ServerNameID( GetString( "      Server name (): ", "" ) );
      int nameType = GetInt("      Name type (0 - 2) (0): ", 0);
      int valueFormat = GetInt("      Value format (1 - 11) (2): ", 2);

      int structType = GetInt("      Struct type ( 1(form) - 2(field) ) (1): ", 1);

     CharMenuDDInfo menu = null;
     switch( structType )
     {
          case 1:
               OutputWriter.DriverPrintPrompt("      Data-Dictionary Form Info :\n");
               int  schemaType = GetInt( "        Type of schema (all,regular,join,view,uplink,downlink,dialog,vendor) (0-6,8) (0): ", 0);    
               boolean includeHidden =  GetBooleanForChangingInfo( "        Include hidden schemas (T): ", true );

               menu = (CharMenuDDInfo) new CharMenuDDFormInfo( server, nameType, valueFormat, schemaType, includeHidden );
               break;

          case 2:
               OutputWriter.DriverPrintPrompt("        Data-Dictionary Field Info :\n");
                int fieldType = GetInt( "        Field Type - data, trim, control, page, pholder, table,\n " +
                                                          " column, attach, attachpool  (1, 2, 4, 8, 16, 32, 64, 128, 256) (129): ", 129);
                String name =  GetString( "        Schema name (): ", "" );

                menu =  (CharMenuDDInfo) new CharMenuDDFieldInfo( server, nameType, valueFormat, fieldType, new NameID( name ) );
                break;

          default:
               break;
     }

      return menu;
   }

    public static CharMenuInfo GetCharMenuInfo( )
    throws IOException{

       OutputWriter.DriverPrintPrompt( "Char Menu Info:\n" );

        int menuType = GetInt( "    Menu type - None, List, Query, File, SQL (0 - 4) ( 1 ):", 1 );

        CharMenuInfo menuInfo = null;

        switch( menuType )
        {
            case 1:               
                menuInfo = ( CharMenuInfo )GetCharMenuListInfo( );
                break;
 
            case 2:
                menuInfo = ( CharMenuInfo )GetCharMenuQueryInfo( );
                break;
            
            case 3:
                menuInfo = ( CharMenuInfo )GetCharMenuFileInfo( );
                break;

            case 4:
                menuInfo = ( CharMenuInfo )GetCharMenuSQLInfo( );
                break;

            default :              
                break;
        }

        return menuInfo;
    }


    public static StructItemInfo GetStructItemInfo( )
    throws IOException{

        if( GetBoolean( "Null StructItemInfo (F): ", false ) )
        {
            return null;
        }

        int type = GetInt( "   Schema(full,defn,view,mail),Filter,ActLink,<7-obsolete>,CharMenu,\n " +
                           "     Escalation,Dist Map, Schema(min view), Container, DistPool, VUI (1 - 6, 8 - 14): ", 0 );

        NameID name = GetNameID( "Structure name " );

        NameID selectedElements[] = null;
        if (type == StructItemInfo.VUI || type == StructItemInfo.SCHEMA_MAIL)
        {
            OutputWriter.DriverPrintPrompt("   VUIs to select (supply VUI's DB name):\n");
            selectedElements = GetNameIDList( "" );
        }
     
        return new StructItemInfo( type, name, selectedElements );
    }


    public static StructItemInfo[] GetStructItemInfoList( )
    throws IOException{

        OutputWriter.DriverPrintPrompt( "Struct ItemInfo List:\n" );

        int numItems = GetInt( "   Number of structure items (0): ", 0 );

        StructItemInfo[] list = null;

        if( numItems != 0 )
        {
            list = new StructItemInfo[numItems];
            for( int i = 0; i < numItems; i++ )
            {
               list[i] = GetStructItemInfo( );
            }
        }

        return list;
    }



    public static ServerInfo GetServerInfo( )
    throws IOException{
        if( GetBoolean( "Null ServerInfo (F): ", false ) )
        {
            return null;
        }
        int operation = GetInt( "    Operation (1-188) (1):", 1);
        Value val = GetValue( );

        return new ServerInfo( operation, val );
    }

    public static ServerInfo[] GetServerInfoList( )
    throws IOException{

        int numItems = GetInt( "   Number of server info operations (0): ", 0 );

        ServerInfo[] list = null;

        if( numItems != 0 ) 
        {
            list = new ServerInfo[numItems];
            for( int i = 0; i < numItems; i++ )
            {
                list[i] = GetServerInfo( );            
            }
        }
   
        return list;
    }
    public static FullTextInfo GetFullTextInfo( )
    throws IOException{

        OutputWriter.DriverPrintPrompt( "FullText info list entry:\n" );

        if( GetBoolean( "Null FullTextInfo (F): ", false ) )
        {
            return null;
        }
        int infoType = GetInt( "InfoType (1-6) (1): ", 1 );

        Value val = null;
        Value[] valList = null;
        FullTextInfo fullText = null;

        switch( infoType )
        {
            case 1:
                val = GetValue( );
                fullText = new FullTextInfo( infoType, val );                
                break;

            case 2 : //_FULLTEXTINFO_STOPWORD:
                valList = GetValueList( );
                fullText = new FullTextInfo( infoType, valList ); 
                break;

            case 3: //_FULLTEXTINFO_REINDEX:
                val = GetValue( );
                fullText = new FullTextInfo( infoType, val ); 
                break;

            case 4: // _FULLTEXTINFO_CASE_SENSITIVE_SRCH:
                val = GetValue( );
                fullText = new FullTextInfo( infoType, val ); 
                break;

            case 5: //_FULLTEXTINFO_STATE:
                val = GetValue( );
                fullText = new FullTextInfo( infoType, val ); 
                break;

            case 6: //_FULLTEXTINFO_FTS_MATCH_OP:
                val = GetValue( );
                fullText = new FullTextInfo( infoType, val ); 
                break;
        }

        return fullText; 
    }

    public static FullTextInfo[] GetFullTextInfoList( )
    throws IOException{

        int numItems = GetInt("   Number of fulltext info types (0): ", 0);

        FullTextInfo[] list = null;

        if( numItems != 0 )
        {
            list = new FullTextInfo[ numItems ];

            for( int i = 0; i < numItems; i++ )
            {
                list[i] = GetFullTextInfo( );
            }
        }  

        return list;
    }

    public static ReferenceBase[] GetReferenceBaseList( )
    throws IOException{
        int numItems = GetInt( "   Number of References (0): ", 0 );

        ReferenceBase[] list = null;

        if( numItems != 0 )
        {
            list = new ReferenceBase[numItems];

            for( int i = 0; i < numItems; i++ )
            {
               list[i] = GetReferenceBase( );
            }
        }

        return list;
    }

    public static ReferenceBase GetReferenceBase( )
    throws IOException{

        if( GetBoolean( "Null ReferenceBase (F): ", false ) )
        {
            return null;
        }
        
        String label = GetString( "Reference Label ():", "" );
        
        String desc = GetString( "Reference Description ():", "" );

        ReferenceType type = GetReferenceType( );

        int dataType = GetInt( "References Data Type AR, EXTERNAL (0, 1) (0):", 0 );

        if( dataType == 0 ) // System reference
        {
            NameID name = GetNameID( "ARS reference name" );

            return new ReferenceInfo( label, desc, type, name );   
        }
        else  // External reference
        {
            OutputWriter.DriverPrintPrompt("   External reference access group ids: \n");
            InternalID[] idList = GetInternalIDList( );
            OutputWriter.DriverPrintPrompt( "External Reference Value :\n" );
            Value val = GetValue( );

            return new ExternalReferenceInfo( label, desc, type, idList, val );    
        }                       
    }


    public static ReferenceType GetReferenceType( )
    throws IOException{

        if( GetBoolean( "Null ReferenceType (F): ", false ) )
        {
            return null;
        }
        
        OutputWriter.DriverPrintPrompt("   Reference type none, schema, filter, esc,actlink,\n");
        int type = GetInt("      container,charmenu (0,2-7) (0): ", 0);

        return ReferenceType.toReferenceType(type);
    }

    public static ContainerOwner[] GetContainerOwnerList( )
    throws IOException{

        if( GetBoolean( "Null ContainerOwnerList (F): ", false ) )
        {
            return null;
        }

        int numItems =  GetInt( "Number of container owner objects (0): ", 0 );

        ContainerOwner[] list = null;
        if( numItems != 0 )
        {
            list = new ContainerOwner[ numItems ];
            for( int i = 0; i < numItems; i++ )
            {
                list[i] = GetContainerOwner( );
            }
        }
        return list;
    }

    public static ContainerOwner GetContainerOwner( )
    throws IOException{

        if( GetBoolean( "Null ContainerOwnerInfo (F): ", false ) )
        {
            return null;
        }

        int type = GetInt( "Container owner type (unowned, all, owned) (0-2) (0): ", 0 );
  
        if( type == 0 || type == 1 )
        {
            return new ContainerOwner( type );
        }
        else
        {
            NameID ownerName =  GetNameID( "Container Owner Name" );
            return new ContainerOwner( type, ownerName );
        }
    }


    public static ContainerType GetContainerType( )
    throws IOException{

        if( GetBoolean( "Null ContainerType (F): ", false ) )
        {
            return null;
        }

        int type =  GetInt("Active Link Guide, Application, Packing List, Filter Guide, Web Service(1-5) (2): ", 2);
        
        switch( type )
        {
            case 1 : return ContainerType.GUIDE;
            case 2 : return ContainerType.APPLICATION;
            case 3 : return ContainerType.PACKINGLIST;
            case 4 : return ContainerType.FILTERGUIDE;
      //      case 5 : return ContainerType.WEBSERVICE;
            default : return null;
        }        
    }
    public static ContainerType[] GetContainerTypeList( )
    throws IOException{

        int numItems =  GetInt( "Number of container types (0): ", 0 );

        ContainerType[] list = null;
        if( numItems != 0 )
        {
            list = new ContainerType[ numItems ];

            for( int i = 0; i < numItems; i++ )
            {
                list[i] = GetContainerType( );
            }
        }
       
        return list;
    }


   public static LocalizedRequestInfo GetLocalizedRequestInfo()
    throws IOException
    {

       OutputWriter.DriverPrintPrompt("   Localized Message Request Info:\n");
        if( GetBoolean( "Null GetLocalizedRequest Object? (F):", false ) )
        {
            return null;
        }
        LocalizedRequestInfo req;
        InternalID internalID = new InternalID(0);
        int workflowIfElse = 0;
        int workflowAction = 0;
         

        int messageType = GetInt(" Message Type:  System, Active Link, Filter, Active Link Help,\n" +
                                 "   Form Help, Field Help, Container Desc., List Menu Defn,\n" +
                                 "   External Report ,Container Label, Application Help, \n" +
                                  "  Application About, Application Help Index   (0 - 13) (0): ", 0);

        NameID name = GetNameID("     name: ");

        switch (messageType)
        {    
            case Constants.AR_LOCAL_TEXT_FIELD_HELP:
            case Constants.AR_LOCAL_TEXT_EXTERN_REPORT:
                internalID = new InternalID(GetInt("Internal ID (0): ", 0));
                break;
            
            case Constants.AR_LOCAL_TEXT_ACT_LINK_MESSAGE:
            case Constants.AR_LOCAL_TEXT_FILTER_MESSAGE:           
                workflowIfElse = GetInt("If/Else (0): ", 0);
                workflowAction = GetInt("Action (0): ", 0);
                break;
            
            case Constants.AR_LOCAL_TEXT_SYSTEM_MESSAGE:
            case Constants.AR_LOCAL_TEXT_ACT_LINK_HELP:
            case Constants.AR_LOCAL_TEXT_FORM_HELP:
            case Constants.AR_LOCAL_TEXT_CONTAIN_DESC:
            case Constants.AR_LOCAL_TEXT_LIST_MENU_DEFN:

            default:
                break;
        }

        return new LocalizedRequestInfo(name, messageType, workflowIfElse, workflowAction, internalID);
    }


    public static LocalizedRequestInfo[] GetLocalizedRequestInfoList( )
    throws IOException{

        int numItems =  GetInt( "Number of localized value operations (0): ", 0);

        LocalizedRequestInfo[] list = null;
        if( numItems != 0 )
        {
            list = new LocalizedRequestInfo[ numItems ];

            for( int i = 0; i < numItems; i++ )
            {
                list[i] = GetLocalizedRequestInfo( );
            }
        }
       
        return list;
    }

   public static StatusHistoryInfo GetStatusHistoryInfo()
   throws IOException{
      OutputWriter.DriverPrintPrompt("   Status History Info:\n");
      AccessNameID user = GetAccessNameID( "   User: " );
      Timestamp timestamp = new Timestamp(GetLong("   TimeStamp(0): ", 0)); 
      
      return new StatusHistoryInfo(user, timestamp);     
   }
       
   public static StatusHistoryInfo[] GetStatusHistoryInfoList()
   throws IOException{
      StatusHistoryInfo[] list = null;
      
      int numItems = GetInt("Number of Status History Info Objects(0): ",0);  
      if(numItems != 0)
      {
         list = new StatusHistoryInfo[numItems];
         for(int i = 0; i < numItems; i++)
            list[i] = GetStatusHistoryInfo();
      }
      return list;
   }


   public static DiaryInfo GetDiaryInfo()
   throws IOException{
      OutputWriter.DriverPrintPrompt("   Diary Info:\n");
      AccessNameID user = GetAccessNameID( "   User: " );
      Timestamp timestamp = new Timestamp(GetLong("   TimeStamp: ", 0));
      String diaryItemString = GetString("     Text () ", "");
      
      return new DiaryInfo(user, diaryItemString, timestamp);     
   }
       
   public static DiaryInfo[] GetDiaryInfoList()
   throws IOException{
      DiaryInfo[] list = null;
      
      int numItems = GetInt("Number of Diary Info Objects(0): ",0);   
      if(numItems != 0)
      {
         list = new DiaryInfo[numItems];
         for(int i = 0; i < numItems; i++)
            list[i] = GetDiaryInfo();
      }
      return list;
   }
       
    public static FilterKey GetFilterKey( )
    throws IOException{

        if( GetBoolean( "Null FilterKey (F): ", false ) )
        {
            return null;
        }

        NameID name = GetNameID( "Filter name" );       
        return new FilterKey( name );
    }

    public static EscalationKey GetEscalationKey( )
    throws IOException{

        if( GetBoolean( "Null EscalationKey (F): ", false ) )
        {
            return null;
        }

        NameID name = GetNameID( "Escalation name" );       
        return new EscalationKey( name );
    }

    public static SchemaKey GetSchemaKey( )
    throws IOException{

        if( GetBoolean( "Null SchemaKey (F): ", false ) )
        {
            return null;
        }

        NameID name = GetNameID( "Schema name" );       
        return new SchemaKey( name );
    }

    public static EscalationTmInfo GetEsclationTmInfo( )
    throws IOException{

        if( GetBoolean( "Null EsclationTmInfo (F): ", false ) )
        {
            return null;
        }
        
        EscalationTmInfo timeInfo = new EscalationTmInfo( );

        int type = GetInt( "Escalation Time Format (1-interval /2) (1) :", 1 );
        timeInfo.setEscalationTmType( type );
    
        if( type == 1 ) 
        {
            long interval = GetLong( "Escalation Interval ( >0 ) (300):", 300 );  
            timeInfo.setInterval( interval );
        }
        else
        {
            DayInfo day = GetDayInfo( );
            timeInfo.setDate( day );  
        }

        return timeInfo;
    }

    public static DayInfo GetDayInfo( )
    throws IOException{

        if( GetBoolean( "Null DayInfo (F): ", false ) )
        {
            return null;
        }
        long day = GetLong( "Day (0):", 0 );
        long hourMask = GetLong( "HourMask (0):", 0 );
        long minutes = GetLong( "Minutes (0):", 0 );
        long weekDay = GetLong( "Week day (0):", 0 );

        return new DayInfo( day, weekDay, hourMask, minutes );
    }

    public static SchemaListCriteria GetSchemaListCriteria( )
    throws IOException{ 
        
        if( GetBoolean( "Null Schema List Criteria (F): ", false ) )
        {
            return null;
        }

        Timestamp  ts = GetTimestamp( "Get all changed since:", new Timestamp( 0 ) );        

        SchemaType type = GetSchemaType( );

        boolean    hidden = GetBooleanForChangingInfo( "Include hidden schemas (T):", true );

        NameID name = null;

        if( (type != null ) && ( type.equals( SchemaType.UPLINK ) || type.equals( SchemaType.DOWNLINK ) ) )
        {
            String id = GetString( "Schema name ():", "" );
            name = new NameID( id );
        }

        OutputWriter.DriverPrintPrompt("Ids of fields, which must be on the schema:\n");
        InternalID[] idList = GetInternalIDList( );
        return  new SchemaListCriteria( type, hidden, ts, name, idList );
        
    }


   public static FieldLimitInfo GetFieldLimitInfo( int dataType )
   throws IOException{
       if ( GetBoolean("Set to NO LIMITS? (F): ", false ) )
       {
            return null;
       }
      
          switch (dataType)
          {
              case Constants.AR_DATA_TYPE_INTEGER :
                    return GetIntegerLimitInfo( );

              case Constants.AR_DATA_TYPE_REAL    :
                   return GetRealLimitInfo( );

              case Constants.AR_DATA_TYPE_CHAR    :
                   return GetCharLimitInfo( );

              case Constants.AR_DATA_TYPE_DIARY   :
                   return GetDiaryLimitInfo( );

              case Constants.AR_DATA_TYPE_TIME    :
                    return null;

              case Constants.AR_DATA_TYPE_ENUM    :
                   return GetEnumLimitInfo( );

              case Constants.AR_DATA_TYPE_BITMASK :
                   return GetEnumLimitInfo( );

              case Constants.AR_DATA_TYPE_ATTACH :
                   return GetAttachmentLimitInfo( );

              case Constants.AR_DATA_TYPE_DECIMAL:
                   return GetDecimalLimitInfo( );

              case Constants.AR_DATA_TYPE_CURRENCY :
                   return GetCurrencyLimitInfo();

              case Constants.AR_DATA_TYPE_TABLE :
                   return GetTableLimitInfo( );

              case Constants.AR_DATA_TYPE_COLUMN :
                   return GetColumnLimitInfo( );

              case Constants.AR_DATA_TYPE_VIEW :
                   return GetViewLimits( );

              case Constants.AR_DATA_TYPE_DISPLAY :
                   return GetDisplayLimits( );
            
               default : return null;
          }
   }

    public static MenuListCriteria GetMenuListCriteria( )
    throws IOException{

        if( GetBoolean( "Null MenuListCriteria (F): ", false ) )
        {
            return null;
        }

        Timestamp changedTime = GetTimestamp( "Get all changed since (0): ", new Timestamp( 0 ) );

        int numItems;
        SchemaKey[] schemaKeys = null;
        ActiveLinkKey[] activeLinkKeys = null;
        
        numItems = GetInt("   Number of schema Keys (0): ", 0);
        if( numItems != 0)
        {     
            schemaKeys = new SchemaKey[ numItems ];

            for( int i = 0; i < numItems; i++ )
            {               
                schemaKeys[i] = new SchemaKey( GetString(  "   Name " + "(" + i + "): ", "" ) );
            }
        }

        numItems = GetInt("   Number of active link Keys (0): ", 0);
        if( numItems != 0)
        {     
            activeLinkKeys = new ActiveLinkKey[ numItems ];

            for( int i = 0; i < numItems; i++ )
            {               
                activeLinkKeys[i] = new ActiveLinkKey( GetString(  "   Name " + "(" + i + "): ", "" ) );
            }
        }

        return new MenuListCriteria( changedTime, schemaKeys, activeLinkKeys);

    }
    public static DataType GetDataType( )
    throws IOException{

        if( GetBoolean( "Null Data Type (F): ", false ) )
        {
            return null;
        }

        OutputWriter.DriverPrintPrompt( "Datatype Null/Key/Int/Real/Char/Diary/Enum/Time/Bitmask/Byte/Decimal\n" );

        int type = GetInt( "    attach/currency/date/timeofday/join/trim/control/table/column/ulong/coords/view/display (0 - 14, 30-34, 40-43) (2): ", 2 );

        return DataType.toDataType( type );
        
    }


    public static SchemaType GetSchemaType( )
    throws IOException{ 

        if( GetBoolean( "Null Schema Type (F): ", false ) )
        {
            return null;
        }

        int type = GetInt( "Type of schema (all, regular, join, view, uplink, downlink, dialog, vendor, all_with_data) (0-6,8-9)(0):", 0 );

        switch( type )
        {
            case 0: return SchemaType.ALL;
            case 1: return SchemaType.REGULAR;   
            case 2: return SchemaType.JOIN;
            case 3: return SchemaType.VIEW; 
            case 4: return SchemaType.UPLINK;
            case 5: return SchemaType.DOWNLINK;   
            case 6: return SchemaType.DIALOG;
            case 8: return SchemaType.VENDOR;
            case 9: return SchemaType.ALL_WITH_DATA; 
            default: return null;
        }
    }


    public static EntryCriteria GetEntryCriteria( )
    throws IOException{

        if( GetBoolean( "Null EntryCriteria (F): ", false ) )
        {
            return null;
        }     
        
        EntryCriteria criteria = new EntryCriteria( );

        EntryListFieldInfo[] fieldsList = GetEntryListFieldInfoList( );

        criteria.setEntryListFieldInfo( fieldsList );

        return criteria;
    }


    public static EntryListCriteria GetEntryListCriteria( )
    throws IOException{

        if( GetBoolean( "Null EntryListCriteria (F): ", false ) )
        {
            return null;
        }     
        
        EntryListCriteria listCriteria = new EntryListCriteria( );

        NameID schemaName = GetNameID( "Schema Name" );
        listCriteria.setSchemaID( schemaName );

        QualifierInfo qualifier = GetQualifierInfo( );
        listCriteria.setQualifier( qualifier );
        
        SortInfo[] sortOrder = GetSortInfoList( );
        listCriteria.setSortInfos( sortOrder );

        int firstRetrieve = GetInt("firstRetrieve (0): ", 0 );
        listCriteria.setFirstRetrieve( firstRetrieve );
        
        int limit = GetInt( "Maximum Number of Entries to retrieve (500):", 500 );
        listCriteria.setMaxLimit( limit );

        return listCriteria;
    }

    public static EntryID GetEntryID( )
    throws IOException{

       if( GetBoolean( "Null EntryID (F): ", false ) )
       {
           return null;
       }     
       
       String entry = GetString( "Entry Id:", "" );
       return new EntryID( entry );
    }





    public static InternalID GetInternalID( String prompt, long defaultVal)
    throws IOException {

        if(GetBoolean("Null InternalID? (F): ", false))
        {
            return null;
        }

        return new InternalID( GetLong( prompt, defaultVal ) );
    }

    public static NameID GetNameID()
    throws IOException {

        if(GetBoolean("Null NameID? (F): ", false))
        {
            return null;
        }

        String name = GetString("Name", "");

        return new NameID(name);
    }
    








    public static EntryKey GetEntryKey( )
    throws IOException{

        OutputWriter.DriverPrintHeader( "Entry Key:" ); 
     
        if( GetBoolean( "Null Entry key (F): ", false ) )
        {
            return null;
        }
        NameID schemaName = GetNameID( "Schema Name" );

        int  numItems = GetInt( "Number of Items in EntryId ? (1): ", 1 );

        if( numItems <= 0 )
        {
            return null;
        }

        EntryID[] entryIDList = new EntryID[ numItems ];        
        for(  int i = 0; i < numItems; i++ )
        {
             entryIDList[i] = new EntryID (GetString( "EntryID: ", "" ) );
        }
    
        if( numItems == 1 )
        {
            return new EntryKey( schemaName, entryIDList[0] );
        }
        else
        {
            return new EntryKey( schemaName, new JoinEntryID( entryIDList ) );
        }
    }



    public static ByteListInfo[] GetByteListInfoList( )
    throws IOException{

        ByteListInfo[]  byteList = null;

        int   numberOfValues = GetInt("   Number of items (0): ", 0 );

        if( numberOfValues != 0 )  
        {
            byteList = new ByteListInfo[ numberOfValues ];

            for( int i = 0; i < numberOfValues; i++ )
            {
               byteList[i] = GetByteListInfo( );            
            }
        }

        return byteList;          
    }








    public static EntryItem[] GetEntryItemList( )
    throws IOException{

        EntryItem[] entryList = null;

        int numItems = GetInt( "  Number of Field/value pairs (0): ", 0 );
        if(numItems != 0 )
        {
            entryList = new EntryItem[ numItems ];   
            for( int i = 0; i < numItems; i++ )
            {
                 entryList[i] = GetEntryItem( );
            }
        }
       
        return entryList;
    }

   static public EntryItem GetEntryItem( )
    throws IOException{

        if( GetBoolean( "Null EntryItem (F): ", false ) )
        {
            return null;
        }

        long  id = GetLong( "Field id (0): ", 0 );
        FieldID fieldId = new FieldID( id );

        Value val = GetValue( );

        return new EntryItem( fieldId, val );
    }   


    public static ViewKey GetViewKey( )
    throws IOException{

        if( GetBoolean( "Null ViewKey (F): ", false ) )
        {
            return null;
        }

        // Get the Schema Name
            NameID schemaName = GetNameID( "Schema Name" );

        // Get the VUI id
            FieldID vuiId = GetVUIID( );

        return new ViewKey( schemaName, vuiId );
    }
   public static FieldID GetVUIID( )
   throws IOException
      {
      if( GetBoolean( "Null VUI ID( f ): ", false ) )
      {
         return null;
      }      
      long  id = GetLong( "VUI id (1): ", 1 );
      return new FieldID( id );
   }

    public static ViewListCriteria GetViewListCriteria( )
    throws IOException{

        if( GetBoolean( "Null ViewListCriteria (F): ", false ) )
        {
            return null;
        }
    
        NameID schemaName = GetNameID( "Schema Name" );
        
        Timestamp timeModifiedAfter = GetTimestamp( "Get All changed since (0) ", new Timestamp( 0 ) );

        return new ViewListCriteria( schemaName, timeModifiedAfter );
    } 

   public static FieldID GetVUIID(  String prompt, long defValue )
   throws IOException{

      if( GetBoolean( "Null VUI ID (F): ", false ) )
      {
         return null;
      }
      long  id = GetLong( prompt, defValue  );
      return new FieldID( id );
   }

    public static FieldID GetFieldID(String prompt, long defaultVal)
    throws IOException {
       long id = GetLong(prompt, defaultVal);
       return new FieldID(id);
    }

    public static FieldID GetFieldID( )
    throws IOException{

        if( GetBoolean( "Null FieldID (F): ", false ) )
        {
            return null;
        }
        long  id = GetLong( "      Field id (0): ", 0 );
        return new FieldID( id );
    }

    public static FieldID[] GetFieldIDList( )
    throws IOException{     

        FieldID[]  fieldIdList = null;

        int numItems = GetInt( "   Number of field IDs (0): ", 0 );

        if( numItems != 0 )
        {
            fieldIdList = new FieldID[ numItems ];
            for( int i = 0; i < numItems; i++ )
            {
                fieldIdList[i] =  GetFieldID( );
            }
        }

        return fieldIdList;
    }






   
    public static QueryInfo GetQueryInfo( )
    throws IOException{

        if( GetBoolean( "Null QueryInfo (F): ", false ) )
        {
            return null;
        }
        NameID schema = GetNameID( "Schema" );

        ServerNameID server =  new ServerNameID( GetString( "Server: ", "" ) );

        QualifierInfo qualifier = GetQualifierInfo( );

        long field = GetLong( "Field id (0): ", 0L);
        FieldID fieldId =  new FieldID( field );

        int multiMatchCode =  GetInt( "Multi-Match code (error, first, set) (1, 2, 3) (1): ", 1 ); 

        return new QueryInfo( schema, server, qualifier, fieldId, multiMatchCode );
     
    }

    public static NotifyActionInfo GetNotifyActionInfo( )
    throws IOException{

        if( GetBoolean( "Null NotifyActionInfo (F): ", false ) )
        {
            return null;
        }

        NotifyActionInfo info = new NotifyActionInfo( );

        OutputWriter.DriverPrintHeader( "Filter Action Notify:" );

        int notifyMechanism = GetInt( "   Notifier, Email, Default, other, or XRef (1, 2, 3, 4-98, 99): ", 0);
        info.setNotifyMechanism( (long) notifyMechanism );
         
        if( notifyMechanism == 99 )
        {
            InternalID  ref = new InternalID( GetLong("   Cross-reference field id: ", 0 ) );
            info.setNotifyMechanismXRef( ref );
        }

        String user =  GetString( "   User name: ", "" );
        info.setUser( user );
        
        String text = GetString( "   Notify text (): ", "" );
        info.setNotifyText( text );

        int notifyPriority = GetInt( "   Notify priority (1 to 10) (1): ", 1 );
        info.setNotifyPriority( notifyPriority );

        String subject = GetString( "   Notify subject (): ", "" );
        info.setSubjectText( subject );

        String from = GetString( "   From user: ", "" );
        String replyTo = GetString( "   Reply To: ", "" );
        String cc = GetString( "   Cc user: ", "" );
        String bcc = GetString( "   Bcc user: ", "" );
        String organization = GetString( "   Organization: ", "" );
        String mailboxName = GetString( "   Mailbox name: ", "" );
        String headerTemplate = GetString( "   Header template: ", "" );
        String footerTemplate = GetString( "   Footer template: ", "" );
        String contentTemplate = GetString( "   Content template: ", "" );
        
	NotifyActionInfoAdvanced advinfo = new NotifyActionInfoAdvanced(from, replyTo , cc , bcc ,organization , mailboxName ,headerTemplate , footerTemplate , contentTemplate );
	info.setNotifyInfoAdvanced(advinfo);
        int fieldIdListType = GetInt("   None, All, specific list, or changed (0, 1, 2, 3) (0): ", 0 );
        info.setFieldIdListType( fieldIdListType );
         
        if( fieldIdListType == 2 )
        {
           InternalID[] idList = GetInternalIDList( );
           info.setFieldIdList( idList );
        }

        return info;
    }






    public static StatusInfo GetStatusInfo( )
    throws IOException{

        OutputWriter.DriverPrintHeader( "Status Info:" );

        if( GetBoolean( "Null StatusInfo (F): ", false ) )
        {
            return null;
        }

        int messageType = GetInt( "   Note, Warning, or Error (0, 1, 2) (2) : ",2 );
        long messageNum = GetLong( "   Message number (0): ", 0 );
        String text = GetString( "   Message text (): ", "" );
        String appendedText = GetString( "Appended Text():", "" );

        return new StatusInfo( messageType, messageNum, text, appendedText );
    }

    public static WorkflowObjectListCriteria GetWorkflowObjectListCriteria( )
    throws IOException{

        if( GetBoolean( "Null WorkflowObjectListCriteria (F): ", false ) )
        {
            return null;
        }
        
        String schemaName = null;
        if( GetBooleanForChangingInfo( "For a specific schema? (F):", false ) )
        {
            schemaName = GetString( "Schema Name:", "" );
        }

        long changedSince = GetLong( "Get all changed since (0):", 0 );

       
        return new WorkflowObjectListCriteria( schemaName, changedSince );
    }  
 











    public static CommitChangesInfo GetCommitChangesInfo( )
    throws IOException{

       OutputWriter.DriverPrintHeader( "   Active Link Commit Changes Info :" );

        if( GetBoolean( "Null CommitChangesInfo (F): ", false ) )
        {
            return null;
        }

        String schemaName = GetString( "      Schema Name (): ", "" );  

        return new CommitChangesInfo( schemaName );         
    }


   public static CharMenuFileInfo GetCharMenuFileInfo( )
    throws IOException{

        OutputWriter.DriverPrintHeader( "Char Menu FILE INFO:" );

        if( GetBoolean( "Null CharMenuFileInfo (F): ", false ) )
        {
            return null;
        }

        int type = GetInt( "       File location  Server or Client (1 or 2) (1): ", 1);
        String name = GetString( "      File Name():", "" );

        return new CharMenuFileInfo( type, name );
    }

    public static MenuKey GetMenuKey( )
    throws IOException{

        if( GetBoolean( "Null Menu key (F): ", false ) )
        {
            return null;
        }

        String name = GetString( "Menu Name():", "" );
        return new MenuKey( name );
    }



     public static CharMenuListInfo  GetCharMenuListInfo( )
    throws IOException{

        if( GetBoolean( "Null CharMenuListInfo (F): ", false ) )
        {
            return null;
        }

        int numItems = GetInt( "   Number of char menu items (0): ", 0 );
        CharMenuItemInfo[] list = null;
        if( numItems != 0 )
        {
            list = new CharMenuItemInfo[ numItems ];
            for( int i = 0; i < numItems; i++ )
            {
                list[i] = GetCharMenuItemInfo( );           
            }
        }
        
        return new CharMenuListInfo( list );
    }




    public  static String GetFileContents( String fileName)
    throws IOException, FileNotFoundException{

         File file             = new File( fileName );
         FileReader fileReader = new FileReader( file );         
         long length            = file.length( );         
         char[] buffer         = new char[(int)length + 1];  
         String contents       = null;
       
         if( fileReader.read( buffer, 0, (int)length ) != length )
         {
             OutputWriter.DriverPrintWarning( "Not able to read the entire file..\n" );
             throw new IOException( "Not able to read the entire file..\n" ) ;  
         }
         else
         {
             contents = new String( buffer );
         }
         return contents;
     }



    public static ReferenceType[] GetReferenceTypeList( )
    throws IOException{

        int numItems = GetInt( "   Number of reference types (0): ", 0 );
        
        ReferenceType[] list = null;

        if( numItems != 0 )
        {
            list = new ReferenceType[ numItems ];

            for( int i = 0; i < numItems; i++ )
            {
                list[i] = GetReferenceType( );
            }
        }
        return list;
    }




    public static ReferenceInfo GetReferenceInfo( )
    throws IOException{

        if( GetBoolean( "Null ReferenceInfo (F): ", false ) )
        {
            return null;
        }
        String label = GetString( "   Reference label (): ", "" );

        String description = GetString( "   Reference description (): ", "" );

        ReferenceType refType = GetReferenceType( );

        NameID name = GetNameID( "Reference name" );

        return new ReferenceInfo( label, description, refType, name );
    }

    public static FieldListCriteria GetFieldListCriteria( )
    throws IOException{

        if( GetBoolean( "Null FieldListCriteria (F): ", false ) )
        {
            return null;
        }
        NameID name = GetNameID( "Schema Name" );

        Timestamp changedTime = GetTimestamp( "Get all changed since ", new Timestamp( 0 ) );

        int type = GetInt(  "Field Type - data, trim, control, page, page holder, table, column, attach,\n " +
                                   "attach pool  (1, 2, 4, 8, 16, 32, 64, 128, 256) (1): ", 1 );

        return new FieldListCriteria( name, changedTime, type );

    }


    public static ActiveLinkKey GetActiveLinkKey( )
    throws IOException{
        NameID name = GetNameID( "Active Link name" );       
        return new ActiveLinkKey( name );
    }





    public static ContainerKey GetContainerKey( )
    throws IOException{

        if( GetBoolean( "Null ContainerKey (F): ", false ) )
        {
            return null;
        }

        NameID name = GetNameID( "Container Name" );
        
        return new ContainerKey( name );
    }
 


    public static NameID GetNameID(String prompt)
    throws IOException {

       if( GetBoolean( " Null NameID for " + prompt + "? (F) :", false ) )
       {
           return null;
       }
       String name = GetString( prompt + "():", "" );

       return new NameID(name);
    }

    public static AccessNameID GetAccessNameID(String prompt)
    throws IOException {

       if( GetBoolean( " Null AccessNameID for " + prompt + "? (F) :", false ) )
       {
           return null;
       }
       String name = GetString( prompt + "():", "" );

       return new AccessNameID(name);
    }

    public static WorkflowConnectInfo GetWorkflowConnectInfo( )
    throws IOException{

        if( GetBoolean( "Null WorkflowConnectInfo (F): ", false ) )
        {
            return null;
        }
  
        WorkflowConnectInfo workflow = new WorkflowConnectInfo( );      

        int type = GetInt( "Workflow Type (1):", 1 );
        workflow.setType( type );


       if( type == Constants.AR_WORKFLOW_CONN_SCHEMA_LIST )
       {
           int  numberOfSchemas = GetInt( "Number of schemas (1):", 1 );  
           NameID[] schemas = null;          
           if( numberOfSchemas != 0 )
          {        
              schemas = new NameID[ numberOfSchemas ];          
              for( int i = 0; i < numberOfSchemas; i++ )
              {
                  schemas[ i] = GetNameID( "Schema Name " + ( i + 1 ) );
              }
           }
           workflow.setSchemaList( schemas );
        }
        return workflow;
    }


    public static VerifyUserCriteria GetVerifyUserCriteria( )
    throws IOException{

        if( GetBoolean( "Null VerifyUserCriteria? (F): ", false ) )
        {
            return null;
        }
         
        VerifyUserCriteria criteria = new VerifyUserCriteria( );
       
        if( GetBooleanForChangingInfo( "Want to retrieve all the properties? (F): ", false ) )
        {
            criteria.setRetrieveAll( true );
        }         
        else
        {

   /*         if( GetBoolean( "Want to Set ADMIN_FLAG? (F): ", false ) )
            {
                criteria.setPropertiesToRetrieve( criteria.getParameters( ) || VerifyUserCriteria.ADMIN_FLAG );   
            }
            if( GetBoolean( "Want to Set CUSTOM_FLAG? (F): ", false ) )
            {
                criteria.setPropertiesToRetrieve( criteria.getParameters( ) || VerifyUserCriteria.CUSTOM_FLAG );   
            }
            if( GetBoolean( "Want to Set SUBADMIN_FLAG? (F): ", false ) )
            {
                criteria.setPropertiesToRetrieve( criteria.getParameters( ) || VerifyUserCriteria.SUBADMIN_FLAG );   
            } */
        }

        return criteria;
    }

    public static SupportFileKey GetSupportFileKey( )
    throws IOException{

        if( GetBoolean( "Null SupportFileKey? (F): ", false ) )
        {
            return null;
        }
         
        SupportFileKey key = new SupportFileKey( );
        
        long fileType = GetLong( "File type -- external report (1) (1):", 1 );
        NameID name = GetNameID( "Name of associated object" );
        InternalID fieldID = new InternalID( GetLong( "Supporting ID for object (0):", 0 ) );
        InternalID fileID = new InternalID( GetLong("ID for the file (1): ", 1) ); 
         
        return  new SupportFileKey( fileType, name, fieldID, fileID );
    }
 
   public static SupportFileListCriteria GetSupportFileListCriteria( )
    throws IOException{ 
        
        if( GetBoolean( "Null SupportFile List Criteria (F): ", false ) )
        {
            return null;
        }

        long fileType = GetLong("File type -- external report (1) (1): ", 1);

        String name = GetString( "Nameof associated object ():", "" );

        long  fieldId = GetLong("   Supporting ID for object (0): ", 0 );

        long changedSince = GetLong( "Get all changed since (0):", 0 );

      return  new SupportFileListCriteria( fileType, name, fieldId, changedSince );
        
    }
    public static LocalizedValueCriteria GetLocalizedValueCriteria( )
     throws IOException{ 
        
        if( GetBoolean( "Null LocalizedValueCriteria? (F):", false ) )
        {
            return null;
        }
        LocalizedValueCriteria criteria = new LocalizedValueCriteria();
        criteria.setRetrieveAll(false);
        
        if (GetBooleanForChangingInfo( "Get Localized Values? (T): ", true))
            criteria.setPropertiesToRetrieve(LocalizedValueCriteria.VALUE | criteria.getPropertiesToRetrieve());
        
        if (GetBooleanForChangingInfo( "Get Timestamps? (T): ", true))
            criteria.setPropertiesToRetrieve(LocalizedValueCriteria.TIMESTAMP | criteria.getPropertiesToRetrieve());
               
        return criteria;
    }


    public static SchemaAliasesCriteria GetSchemaAliasesCriteria( )
    throws IOException{ 
        
        if( GetBoolean( "Null Schema Aliases Criteria (F): ", false ) )
        {
            return null;
        }

        Timestamp  ts = GetTimestamp( "Get all changed since: ", new Timestamp( 0 ) );        
        SchemaType type = GetSchemaType( );

        NameID name = null;

        boolean    hidden = GetBooleanForChangingInfo( "Include hidden schemas (T): ", true );

        if( (type != null ) && ( type.equals( SchemaType.UPLINK ) || type.equals( SchemaType.DOWNLINK ) ) )
        {
            String id = GetString( "Enter Schema name (): ", "" );
            name = new NameID( id );
        }

        NameID vuiLabel = null;        
        if( !GetBooleanForChangingInfo( "Null Vui Label (F): ", false ) )
        { 
            vuiLabel = new NameID( GetString( " Vui desired(): ", "" ));
        }

        OutputWriter.DriverPrintHeader( "Ids of fields, which must be on the schema:\n");
        FieldID[] fids = GetFieldIDList();

        return new SchemaAliasesCriteria( type, hidden, ts, name, fids, vuiLabel );
    }

   public static AlertMessageCriteria GetAlertMessageCriteria( )
   throws IOException{ 
           
      AlertMessageCriteria criteria = new AlertMessageCriteria();
      criteria.setRetrieveAll(false);
           
      if (GetBoolean( "Get Timestamp? (T): ", true))
         criteria.setPropertiesToRetrieve(AlertMessageCriteria.TIMESTAMP | criteria.getPropertiesToRetrieve());
           
      if (GetBoolean( "Get sourceType? (T): ", true))
         criteria.setPropertiesToRetrieve(AlertMessageCriteria.SOURCETYPE | criteria.getPropertiesToRetrieve());
               
      if (GetBoolean( "Get priority? (T): ", true))
         criteria.setPropertiesToRetrieve(AlertMessageCriteria.PRIORITY | criteria.getPropertiesToRetrieve());
               
      if (GetBoolean( "Get alertText? (T): ", true))
         criteria.setPropertiesToRetrieve(AlertMessageCriteria.ALERTTEXT | criteria.getPropertiesToRetrieve());
               
      if (GetBoolean( "Get sourceTag? (T): ", true))
         criteria.setPropertiesToRetrieve(AlertMessageCriteria.SOURCETAG | criteria.getPropertiesToRetrieve());
               
      if (GetBoolean( "Get serverName? (T): ", true))
         criteria.setPropertiesToRetrieve(AlertMessageCriteria.SERVERNAME | criteria.getPropertiesToRetrieve());
         
      if (GetBoolean("Get serverAddress? (T): ", true))
         criteria.setPropertiesToRetrieve(AlertMessageCriteria.SERVERADDR | criteria.getPropertiesToRetrieve());
       
      if (GetBoolean( "Get formName? (T): ", true))
         criteria.setPropertiesToRetrieve(AlertMessageCriteria.FORMNAME | criteria.getPropertiesToRetrieve());
               
      if (GetBoolean( "Get objectId? (T): ", true))
         criteria.setPropertiesToRetrieve(AlertMessageCriteria.OBJECTID | criteria.getPropertiesToRetrieve());
                  
      return criteria;
   }    

   public static LicenseNameID GetLicenseNameID(String prompt)
   throws IOException {
      String name = GetString(prompt, "");

      return new LicenseNameID(name);
   }
   public static LicenseNameID[] GetLicenseNameIDList()
   throws IOException{
    
      LicenseNameID[]   nameList = null;

      int numItems = GetInt("Number of licenses to validate (1): ", 1);
      if( numItems != 0)
      {     
         nameList = new LicenseNameID[ numItems ];

         for( int i = 0; i < numItems; i++ )
         {               
            nameList[i] = new LicenseNameID( GetString( "License Type " + "(" + i + ")", "" ) );
         }
      }

      return nameList;
   }
    public static JoinSchemaInfo GetJoinSchemaInfo( )
       throws IOException{
          if( GetBoolean( "Null JoinSchemaInfo (F): ", false ) )
          {
             return null;
          }
          NameID memberA = GetNameID( "Join member A name"  );
          NameID memberB = GetNameID( "Join member B name"  );
          QualifierInfo joinQual = GetQualifierInfo();
          int option = GetInt("   Join option(0): ", 0);

          return new JoinSchemaInfo(memberA, memberB, joinQual, option);
    }
    public static ViewSchemaInfo GetViewSchemaInfo( )
       throws IOException{
          if( GetBoolean( "Null ViewSchemaInfo (F): ", false ) )
          {
             return null;
          }
          String tableName = GetString("   View table name : ", "");
          NameID keyField = GetNameID("   Key Field ");

          return new ViewSchemaInfo(tableName, keyField);    
    }
    public static VendorSchemaInfo GetVendorSchemaInfo( )
       throws IOException{
          if( GetBoolean( "Null VendorSchemaInfo (F): ", false ) )
          {
              return null;
          }
          NameID vendorName = GetNameID("   Vendor name " );
          String vtableName =  GetString("   Vendor table name : ", "");

          return new VendorSchemaInfo(vendorName, vtableName); 
    }


    public static void openInputFile( String inputFileName )
     throws IOException{

        String fileName = null;
        if( inputFileName == null )
        {
           fileName = GetString( "File name of input file ()", "" );  
        }
        else
        {
           fileName = inputFileName;
        }
        
        if( ( fileName == null ) || ( fileName.length( ) == 0 ) )
        {
             OutputWriter.DriverPrintWarning( "****No filename specified so no change to input file\n");           
        }
        else
        {
            ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr( );
            try
           {
                 threadControlBlockPtr.setCurrentInputFile( fileName );
            }
            catch( FileNotFoundException e )
            {
                OutputWriter.PrintString( "**** File error during open; no change to input file\n" );
             }
         }
    }
    public static JoinEntryID GetJoinEntryID( )
       throws IOException{
          if( GetBoolean( "Null JoinEntryID (F): ", false ) )
          {
              return null;
          }
          EntryID[] entryList = null;
          int numEntries = GetInt( "Number Of items in the Entry (1):", 1 );
          if( numEntries > 0 )
          {
             entryList = new EntryID[ numEntries ];
             for( int i = 0; i < numEntries; i++ )
             {
                 String id = GetString("   Entry ID:", "" );
                 entryList[i] = new EntryID( id );
             }
          }
          return new JoinEntryID( entryList );
    }

    public static JoinEntryID[] GetJoinEntryIDList( )
       throws IOException{
          if( GetBoolean( "Null JoinEntryID List (F): ", false ) )
          {
              return null;
          }

          JoinEntryID[] joinEntryList = null;

          int numEntries = GetInt( "Number Of Entries (1):", 1 );
          if( numEntries > 0 )
          {
             joinEntryList = new JoinEntryID[ numEntries ];
             for( int i = 0; i < numEntries; i++ )
             {
                 joinEntryList[i] = GetJoinEntryID( );
             }
          }
          return joinEntryList;
    }
    public static WorkflowLockInfo GetWorkflowLockInfo( )
       throws IOException{
          if( GetBoolean( "Null WorkflowLockInfo (F): ", false ) )
          {
              return null;
          }
          int lockType = GetInt("   Lock type (0-None, 1-Read, 2-Hidden) (0): ", 0);
          AccessNameID lockKey = null;
		  if (lockType > 0)
			lockKey = GetAccessNameID( "   Lock Key: " );

          return new WorkflowLockInfo(lockType, lockKey); 
    }

}
