/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.ARServerUser;
import com.remedy.arsys.api.ActiveLink;
import com.remedy.arsys.api.ActiveLinkCriteria;
import com.remedy.arsys.api.ActiveLinkKey;
import com.remedy.arsys.api.IARObjectFactory;
import com.remedy.arsys.api.Proxy;
import com.remedy.arsys.api.ProxyManager;
import com.remedy.arsys.api.WorkflowObjectListCriteria;

public class ActiveLinkFactory
implements IARObjectFactory {
    private static final ActiveLinkFactory activeLinkFactory = new ActiveLinkFactory();

    protected ActiveLinkFactory() {
    }

    public static ActiveLinkFactory getFactory() {
        return activeLinkFactory;
    }

    public Object newInstance() {
        ActiveLink activeLink = new ActiveLink();
        return activeLink;
    }

    public boolean releaseInstance(Object object) {
        return true;
    }

    public static ActiveLink findByKey(ARServerUser aRServerUser, ActiveLinkKey activeLinkKey, ActiveLinkCriteria activeLinkCriteria) throws ARException {
        if (null == aRServerUser) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        if (activeLinkCriteria == null) {
            activeLinkCriteria = new ActiveLinkCriteria();
        }
        ActiveLink activeLink = new ActiveLink();
        boolean bl = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl);
        try {
            proxy.ARGetActiveLink(aRServerUser, activeLinkKey, activeLinkCriteria, activeLink);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
        }
        return activeLink;
    }

    public static ActiveLinkKey[] find(ARServerUser aRServerUser, WorkflowObjectListCriteria workflowObjectListCriteria) throws ARException {
        if (null == aRServerUser) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl);
        ActiveLinkKey[] activeLinkKeyArray = null;
        try {
            activeLinkKeyArray = proxy.ARGetListActiveLink(aRServerUser, workflowObjectListCriteria);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
        }
        int n = activeLinkKeyArray != null ? activeLinkKeyArray.length : 0;
        ActiveLinkKey[] activeLinkKeyArray2 = new ActiveLinkKey[n];
        for (int i = 0; i < n; ++i) {
            activeLinkKeyArray2[i] = new ActiveLinkKey(activeLinkKeyArray[i]);
        }
        return activeLinkKeyArray2;
    }

    public static ActiveLink[] findObjects(ARServerUser aRServerUser, WorkflowObjectListCriteria workflowObjectListCriteria, ActiveLinkCriteria activeLinkCriteria) throws ARException {
        if (null == aRServerUser) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        if (activeLinkCriteria == null) {
            activeLinkCriteria = new ActiveLinkCriteria();
        }
        aRServerUser.getVersionString();
        boolean bl = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl);
        ActiveLink[] activeLinkArray = null;
        try {
            activeLinkArray = proxy.ARGetListActiveLinkObjects(aRServerUser, workflowObjectListCriteria, activeLinkCriteria);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
        }
        return activeLinkArray;
    }
}

