/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.ARServerUser;
import com.remedy.arsys.api.FieldID;
import com.remedy.arsys.api.IARObjectFactory;
import com.remedy.arsys.api.NameID;
import com.remedy.arsys.api.Proxy;
import com.remedy.arsys.api.ProxyManager;
import com.remedy.arsys.api.View;
import com.remedy.arsys.api.ViewCriteria;
import com.remedy.arsys.api.ViewKey;
import com.remedy.arsys.api.ViewListCriteria;

public class ViewFactory
implements IARObjectFactory {
    private static final ViewFactory viewFactory = new ViewFactory();

    protected ViewFactory() {
    }

    public static ViewFactory getFactory() {
        return viewFactory;
    }

    public Object newInstance() {
        View view = new View();
        return view;
    }

    public boolean releaseInstance(Object object) {
        return true;
    }

    public static View findByKey(ARServerUser aRServerUser, ViewKey viewKey, ViewCriteria viewCriteria) throws ARException {
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        if (viewCriteria == null) {
            viewCriteria = new ViewCriteria();
        }
        View view = new View();
        boolean bl = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl);
        try {
            proxy.ARGetView(aRServerUser, viewKey, viewCriteria, view);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
        }
        view.setVUIId(viewKey.getVUIId());
        view.setSchemaName(viewKey.getSchemaName());
        view.resetChangeFlags();
        return view;
    }

    public static ViewKey[] find(ARServerUser aRServerUser, ViewListCriteria viewListCriteria) throws ARException {
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl);
        FieldID[] fieldIDArray = null;
        try {
            fieldIDArray = proxy.ARGetListView(aRServerUser, viewListCriteria);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
        }
        if (fieldIDArray == null) {
            return null;
        }
        int n = fieldIDArray.length;
        ViewKey[] viewKeyArray = new ViewKey[n];
        NameID nameID = viewListCriteria.getSchemaName();
        for (int i = 0; i < n; ++i) {
            viewKeyArray[i] = new ViewKey(nameID, fieldIDArray[i]);
        }
        return viewKeyArray;
    }

    public static View[] findObjects(ARServerUser aRServerUser, ViewListCriteria viewListCriteria, ViewCriteria viewCriteria) throws ARException {
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        if (viewCriteria == null) {
            viewCriteria = new ViewCriteria();
        }
        View[] viewArray = null;
        boolean bl = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl);
        try {
            viewArray = proxy.ARGetListViewObjects(aRServerUser, viewListCriteria, viewCriteria);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
        }
        if (viewArray == null) {
            return null;
        }
        for (int i = 0; i < viewArray.length; ++i) {
            viewArray[i].resetChangeFlags();
        }
        return viewArray;
    }
}

