/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.AccessNameID;
import com.remedy.arsys.api.LoggingInfo;
import com.remedy.arsys.api.Proxy;
import com.remedy.arsys.api.ProxyManager;
import com.remedy.arsys.api.ServerInfo;
import com.remedy.arsys.api.StatusInfo;
import com.remedy.arsys.api.Timestamp;
import com.remedy.arsys.api.Util;
import com.remedy.arsys.api.VerifyUserCriteria;

public class ARServerUser {
    private long m_cacheId;
    private Timestamp m_operationTime;
    private AccessNameID m_user;
    private AccessNameID m_password;
    private String m_authentication;
    private String m_locale;
    private String m_timeZone;
    private String m_customDateFormat;
    private String m_customTimeFormat;
    private String m_server;
    private int m_port;
    private StatusInfo[] m_lastStatus;
    private boolean m_adminFlag;
    private boolean m_subAdminFlag;
    private boolean m_customFlag;
    private LoggingInfo m_loggingInfo;
    private StringBuffer m_logBuffer;
    private int m_isGetMultipleFieldSupported = -1;
    private int m_isGetMultipleActlinkSupported = -1;
    private int m_isGetMultipleContainersSupported = -1;
    private int m_isPooledSessionSupported = -1;
    private String m_versionString = null;
    private Proxy m_proxy = null;
    private int m_chunkResponseSize = 500000;
    private int m_timeoutNormal = 120;
    private int m_timeoutLong = 300;
    private int m_timeoutXLong = 1800;
    private long m_lockToSocketNumber = 0L;
    private int m_clientType = 0;
    private int m_vuiType = 0;
    private int m_overridePrevIP = 0;
    private String m_reservedParam1 = null;

    public ARServerUser() {
        this.init();
    }

    public ARServerUser(String string, String string2, String string3, String string4) {
        this.init();
        this.setUser(new AccessNameID(string));
        this.setPassword(new AccessNameID(string2));
        this.setAuthentication("");
        this.setLocale(string3);
        this.setServer(string4);
        this.setLastStatus(null);
    }

    public ARServerUser(String string, String string2, String string3, String string4, long l) {
        this.init();
        this.setCacheId(l);
        this.setUser(new AccessNameID(string));
        this.setPassword(new AccessNameID(string2));
        this.setAuthentication("");
        this.setLocale(string3);
        this.setServer(string4);
        this.setLastStatus(null);
    }

    public ARServerUser(String string, String string2, String string3, String string4, String string5, long l) {
        this.init();
        this.setCacheId(l);
        this.setUser(new AccessNameID(string));
        this.setPassword(new AccessNameID(string2));
        this.setAuthentication(string3);
        this.setLocale(string4);
        this.setServer(string5);
        this.setLastStatus(null);
    }

    public ARServerUser(String string, String string2, String string3, String string4, int n) {
        this.init();
        this.setUser(new AccessNameID(string));
        this.setPassword(new AccessNameID(string2));
        this.setAuthentication("");
        this.setLocale(string3);
        this.setServer(string4);
        this.setPort(n);
        this.setLastStatus(null);
    }

    public ARServerUser(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, long l) {
        this.init();
        this.setCacheId(l);
        this.setUser(new AccessNameID(string));
        this.setPassword(new AccessNameID(string2));
        this.setAuthentication(string3);
        this.setLocale(string4);
        this.setServer(string8);
        this.setLastStatus(null);
        this.setCustomDateFormat(string6);
        this.setCustomTimeFormat(string7);
    }

    public void login() throws ARException {
        this.verifyUser(new VerifyUserCriteria());
    }

    public void logout() {
        this.clear();
    }

    private void init() {
        this.m_proxy = null;
        this.m_timeZone = null;
        this.m_locale = null;
        this.m_customDateFormat = null;
        this.m_customTimeFormat = null;
        this.m_logBuffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Proxy proxy = null;
        boolean bl = this.isProxyInContext();
        try {
            proxy = ProxyManager.getProxyManager().getProxy(this, bl);
            proxy.releaseARServerUser(this);
        }
        catch (ARException aRException) {
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, this, bl);
        }
        this.m_cacheId = 0L;
        this.m_operationTime = null;
        this.m_user = null;
        this.m_password = null;
        this.m_locale = null;
        this.m_authentication = null;
        this.m_server = null;
        this.m_lastStatus = null;
        this.m_logBuffer = null;
        this.m_proxy = null;
        this.m_customDateFormat = null;
        this.m_customTimeFormat = null;
        this.m_reservedParam1 = null;
    }

    public long getCacheId() {
        return this.m_cacheId;
    }

    void setCacheId(long l) {
        this.m_cacheId = l;
    }

    public Timestamp getOperationTime() {
        return this.m_operationTime;
    }

    void setOperationTime(Timestamp timestamp) {
        this.m_operationTime.setValue(timestamp);
    }

    public AccessNameID getUser() {
        return this.m_user;
    }

    public void setUser(AccessNameID accessNameID) {
        this.m_user = accessNameID;
    }

    public AccessNameID getPassword() {
        return this.m_password;
    }

    public void setPassword(AccessNameID accessNameID) {
        this.m_password = accessNameID;
    }

    public String getAuthentication() {
        return this.m_authentication;
    }

    public void setAuthentication(String string) {
        this.m_authentication = string;
    }

    public String getLocale() {
        return this.m_locale;
    }

    public void setLocale(String string) {
        this.m_locale = string;
    }

    public String getTimeZone() {
        return this.m_timeZone;
    }

    public void setTimeZone(String string) {
        this.m_timeZone = string;
    }

    public String getCustomDateFormat() {
        return this.m_customDateFormat;
    }

    public void setCustomDateFormat(String string) {
        this.m_customDateFormat = string;
    }

    public String getCustomTimeFormat() {
        return this.m_customTimeFormat;
    }

    public void setCustomTimeFormat(String string) {
        this.m_customTimeFormat = string;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int n) {
        this.m_port = n;
    }

    public String getServer() {
        return this.m_server;
    }

    public void setServer(String string) {
        this.m_server = string;
        this.m_versionString = null;
        this.m_isGetMultipleFieldSupported = -1;
        this.m_isGetMultipleActlinkSupported = -1;
        this.m_isGetMultipleContainersSupported = -1;
        this.m_isPooledSessionSupported = -1;
    }

    public void setVersionString(String string) {
        this.m_versionString = string;
    }

    public void setIsGetMultipleFieldSupported(int n) {
        this.m_isGetMultipleFieldSupported = n;
    }

    public void setIsGetMultipleActlinkSupported(int n) {
        this.m_isGetMultipleActlinkSupported = n;
    }

    public void setIsGetMultipleContainersSupported(int n) {
        this.m_isGetMultipleContainersSupported = n;
    }

    public StatusInfo[] getLastStatus() {
        return this.m_lastStatus;
    }

    void setLastStatus(StatusInfo[] statusInfoArray) {
        this.m_lastStatus = statusInfoArray;
        if (statusInfoArray != null && statusInfoArray.length > 0) {
            if (this.m_logBuffer == null) {
                this.m_logBuffer = new StringBuffer();
            }
            if (this.m_logBuffer != null) {
                for (int i = 0; i < statusInfoArray.length; ++i) {
                    if (statusInfoArray[i].getMessageNum() != 8914L) continue;
                    this.m_logBuffer.append(statusInfoArray[i].getMessageText());
                }
            }
        }
    }

    public boolean getAdminFlag() {
        return this.m_adminFlag;
    }

    void setAdminFlag(boolean bl) {
        this.m_adminFlag = bl;
    }

    public boolean getSubAdminFlag() {
        return this.m_subAdminFlag;
    }

    void setSubAdminFlag(boolean bl) {
        this.m_subAdminFlag = bl;
    }

    public boolean getCustomFlag() {
        return this.m_customFlag;
    }

    void setCustomFlag(boolean bl) {
        this.m_customFlag = bl;
    }

    public LoggingInfo getLogging() {
        return this.m_loggingInfo;
    }

    public void setLogging(LoggingInfo loggingInfo) {
        this.m_loggingInfo = loggingInfo;
    }

    public StringBuffer getLogBuffer() {
        return this.m_logBuffer;
    }

    public void clearLogBuffer() {
        this.m_logBuffer = null;
    }

    private int isGetMultipleFieldSupported() {
        return this.m_isGetMultipleFieldSupported;
    }

    private int isGetMultipleActlinkSupported() {
        return this.m_isGetMultipleActlinkSupported;
    }

    private int isGetMultipleContainersSupported() {
        return this.m_isGetMultipleContainersSupported;
    }

    public Proxy getProxy() {
        return this.m_proxy;
    }

    public void setProxy(Proxy proxy) {
        this.m_proxy = proxy;
    }

    protected boolean isProxyInContext() {
        return this.m_proxy != null;
    }

    private int isPooledSessionSupported() {
        return this.m_isPooledSessionSupported;
    }

    public String getVersionString() {
        return this.m_versionString;
    }

    public String getVersionStringFromServer() {
        if (this.m_versionString == null) {
            int[] nArray = new int[]{4};
            ServerInfo[] serverInfoArray = null;
            try {
                serverInfoArray = Util.ARGetServerInfo(this, nArray);
            }
            catch (ARException aRException) {
                // empty catch block
            }
            if (serverInfoArray != null) {
                this.m_versionString = serverInfoArray[0].getValue().toString();
            }
        }
        return this.m_versionString;
    }

    public void verifyUser(VerifyUserCriteria verifyUserCriteria) throws ARException {
        boolean bl = this.isProxyInContext();
        boolean[] blArray = verifyUserCriteria.getParameters();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this, bl);
        try {
            proxy.ARVerifyUser(this, blArray);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, this, bl);
        }
    }

    public void finalize() {
        if (this.m_cacheId != 0L) {
            this.clear();
        }
    }

    public void setChunkResponseSize(int n) {
        this.m_chunkResponseSize = n;
    }

    public int getChunkResponseSize() {
        return this.m_chunkResponseSize;
    }

    public void setTimeoutNormal(int n) {
        this.m_timeoutNormal = n;
    }

    public int getTimeoutNormal() {
        return this.m_timeoutNormal;
    }

    public void setTimeoutLong(int n) {
        this.m_timeoutLong = n;
    }

    public int getTimeoutLong() {
        return this.m_timeoutLong;
    }

    public void setTimeoutXLong(int n) {
        this.m_timeoutXLong = n;
    }

    public int getTimeoutXLong() {
        return this.m_timeoutXLong;
    }

    public void setLockToSocketNumber(long l) {
        this.m_lockToSocketNumber = l;
    }

    public long getLockToSocketNumber() {
        return this.m_lockToSocketNumber;
    }

    public void setClientType(int n) {
        this.m_clientType = n;
    }

    public int getClientType() {
        return this.m_clientType;
    }

    public void setVUIType(int n) {
        this.m_vuiType = n;
    }

    public int getVUIType() {
        return this.m_vuiType;
    }

    public void setOverridePrevIP(int n) {
        this.m_overridePrevIP = n;
    }

    public int getOverridePrevIP() {
        return this.m_overridePrevIP;
    }

    public void setReservedParam1(String string) {
        this.m_reservedParam1 = string;
    }

    public String getReservedParam1() {
        return this.m_reservedParam1;
    }
}

