/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.DisplayInstanceInfo;
import com.remedy.arsys.api.InternalID;
import com.remedy.arsys.api.PropInfo;
import com.remedy.arsys.api.Value;
import java.util.HashMap;
import java.util.Map;

public class DisplayInstanceList
implements Cloneable {
    private PropInfo[] m_commonProps;
    private DisplayInstanceInfo[] m_dInstanceList;
    private Map m_hash_dInstanceMap = null;

    private DisplayInstanceList() {
    }

    public DisplayInstanceList(PropInfo[] propInfoArray, DisplayInstanceInfo[] displayInstanceInfoArray) {
        this.m_commonProps = propInfoArray;
        this.m_dInstanceList = displayInstanceInfoArray;
    }

    public PropInfo[] getCommonProperties() {
        return this.m_commonProps;
    }

    public DisplayInstanceInfo[] getDisplayInstances() {
        return this.m_dInstanceList;
    }

    public Value getProperty(InternalID internalID, Integer n) {
        HashMap<Integer, Value> hashMap;
        if (this.m_hash_dInstanceMap == null && this.m_dInstanceList != null) {
            this.m_hash_dInstanceMap = new HashMap();
            for (int i = 0; i < this.m_dInstanceList.length; ++i) {
                PropInfo[] propInfoArray = this.m_dInstanceList[i].getVUIProperties();
                if (propInfoArray == null || propInfoArray.length <= 0) continue;
                hashMap = new HashMap<Integer, Value>(propInfoArray.length);
                for (int j = 0; j < propInfoArray.length; ++j) {
                    hashMap.put(new Integer(propInfoArray[j].getPropertyTag()), propInfoArray[j].getPropertyValue());
                }
                this.m_hash_dInstanceMap.put(this.m_dInstanceList[i].getVUIId(), hashMap);
            }
        }
        if (this.m_hash_dInstanceMap != null && this.m_hash_dInstanceMap.containsKey(internalID) && (hashMap = (HashMap<Integer, Value>)this.m_hash_dInstanceMap.get(internalID)) != null) {
            return (Value)hashMap.get(n);
        }
        if (this.m_commonProps != null) {
            for (int i = 0; i < this.m_commonProps.length; ++i) {
                if (this.m_commonProps[i].getPropertyTag() != n.intValue()) continue;
                return this.m_commonProps[i].getPropertyValue();
            }
        }
        return null;
    }

    public void setProperty(InternalID internalID, int n, Value value) {
        int n2;
        Map map;
        Value value2 = this.getProperty(internalID, new Integer(n));
        if (this.m_hash_dInstanceMap != null && this.m_hash_dInstanceMap.containsKey(internalID) && (map = (Map)this.m_hash_dInstanceMap.get(internalID)) != null) {
            map.put(new Integer(n), value);
        }
        for (n2 = 0; n2 < this.m_dInstanceList.length; ++n2) {
            if (!this.m_dInstanceList[n2].getVUIId().equals(internalID)) continue;
            PropInfo[] propInfoArray = this.m_dInstanceList[n2].getVUIProperties();
            for (int i = 0; i < propInfoArray.length; ++i) {
                if (propInfoArray[i].getPropertyTag() != n) continue;
                propInfoArray[i].setPropertyValue(value);
                return;
            }
        }
        if (this.m_commonProps != null) {
            for (n2 = 0; n2 < this.m_commonProps.length; ++n2) {
                if (this.m_commonProps[n2].getPropertyTag() != n) continue;
                this.m_commonProps[n2].setPropertyValue(value);
                return;
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        int n;
        DisplayInstanceList displayInstanceList = null;
        displayInstanceList = (DisplayInstanceList)super.clone();
        if (this.m_commonProps != null) {
            displayInstanceList.m_commonProps = new PropInfo[this.m_commonProps.length];
            for (n = 0; n < this.m_commonProps.length; ++n) {
                displayInstanceList.m_commonProps[n] = (PropInfo)this.m_commonProps[n].clone();
            }
        }
        if (this.m_dInstanceList != null) {
            displayInstanceList.m_dInstanceList = new DisplayInstanceInfo[this.m_dInstanceList.length];
            for (n = 0; n < this.m_dInstanceList.length; ++n) {
                displayInstanceList.m_dInstanceList[n] = (DisplayInstanceInfo)this.m_dInstanceList[n].clone();
            }
        }
        return displayInstanceList;
    }
}

