/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.ARServerUser;
import com.remedy.arsys.api.IARObjectFactory;
import com.remedy.arsys.api.InternalID;
import com.remedy.arsys.api.Proxy;
import com.remedy.arsys.api.ProxyManager;
import com.remedy.arsys.api.SupportFile;
import com.remedy.arsys.api.SupportFileCriteria;
import com.remedy.arsys.api.SupportFileKey;
import com.remedy.arsys.api.SupportFileListCriteria;

public class SupportFileFactory
implements IARObjectFactory {
    private static final SupportFileFactory SupportFileFactory = new SupportFileFactory();
    private String m_defaultOutputDirectory;

    protected SupportFileFactory() {
    }

    public static SupportFileFactory getFactory() {
        return SupportFileFactory;
    }

    public Object newInstance() {
        SupportFile supportFile = new SupportFile();
        return supportFile;
    }

    public boolean releaseInstance(Object object) {
        return true;
    }

    public static SupportFile findByKey(ARServerUser aRServerUser, SupportFileKey supportFileKey, SupportFileCriteria supportFileCriteria) throws ARException {
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        if (supportFileCriteria == null) {
            supportFileCriteria = new SupportFileCriteria();
        }
        SupportFile supportFile = new SupportFile();
        boolean bl = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl);
        try {
            proxy.ARGetSupportFile(aRServerUser, supportFileKey, supportFileCriteria, supportFile);
            supportFile.setKey(new SupportFileKey(supportFileKey.getFileType(), supportFileKey.getName().toString(), supportFileKey.getFieldId() != null ? supportFileKey.getFieldId().getValue() : 0L, supportFileKey.getFileId()));
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
        }
        return supportFile;
    }

    public static SupportFileKey[] find(ARServerUser aRServerUser, SupportFileListCriteria supportFileListCriteria) throws ARException {
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl);
        InternalID[] internalIDArray = null;
        try {
            internalIDArray = proxy.ARGetListSupportFile(aRServerUser, supportFileListCriteria);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
        }
        int n = internalIDArray != null ? internalIDArray.length : 0;
        SupportFileKey[] supportFileKeyArray = new SupportFileKey[n];
        for (int i = 0; i < n; ++i) {
            supportFileKeyArray[i] = new SupportFileKey(supportFileListCriteria.getFileType(), supportFileListCriteria.getName(), supportFileListCriteria.getFieldId(), internalIDArray[i]);
        }
        return supportFileKeyArray;
    }

    public String getDefaultOutputDirectory() {
        return this.m_defaultOutputDirectory;
    }

    public void setDefaultOutputDirectory(String string) {
        this.m_defaultOutputDirectory = string;
    }

    public static SupportFile[] findObjects(ARServerUser aRServerUser, SupportFileListCriteria supportFileListCriteria, SupportFileCriteria supportFileCriteria) throws ARException {
        if (aRServerUser == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        if (null == supportFileCriteria) {
            supportFileCriteria = new SupportFileCriteria();
        }
        boolean bl = aRServerUser.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(aRServerUser, bl);
        SupportFile[] supportFileArray = null;
        try {
            supportFileArray = proxy.ARGetListSupportFileObjects(aRServerUser, supportFileListCriteria, supportFileCriteria);
        }
        catch (ARException aRException) {
            throw aRException;
        }
        finally {
            ProxyManager.getProxyManager().releaseProxy(proxy, aRServerUser, bl);
        }
        return supportFileArray;
    }
}

