/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.ARServerUser;
import com.remedy.arsys.api.ArchiveInfo;
import com.remedy.arsys.api.CompoundSchemaInfo;
import com.remedy.arsys.api.CriteriaFlags;
import com.remedy.arsys.api.EntryListFieldInfo;
import com.remedy.arsys.api.FieldID;
import com.remedy.arsys.api.IARPersistentObject;
import com.remedy.arsys.api.IndexInfo;
import com.remedy.arsys.api.InternalID;
import com.remedy.arsys.api.NameID;
import com.remedy.arsys.api.ObjectBase;
import com.remedy.arsys.api.PermissionInfo;
import com.remedy.arsys.api.PropInfo;
import com.remedy.arsys.api.Proxy;
import com.remedy.arsys.api.ProxyManager;
import com.remedy.arsys.api.SchemaCriteria;
import com.remedy.arsys.api.SchemaKey;
import com.remedy.arsys.api.SortInfo;
import com.remedy.arsys.api.Util;

public class Schema
extends ObjectBase
implements IARPersistentObject,
Cloneable {
    private ARServerUser m_context;
    private CompoundSchemaInfo m_compoundSchema;
    private EntryListFieldInfo[] m_getListFields = null;
    private InternalID[] m_adminGrpList;
    private SortInfo[] m_sortInfo;
    private IndexInfo[] m_indexInfo;
    private ArchiveInfo m_archiveInfo;
    private int m_deleteOption;
    private PropInfo[] m_props;
    private NameID m_defaultVUI;
    private static final int TOTAL_PARAMS = 13;
    private static final int NEW_COMPOUND_SCHEMA = 5;
    private static final int NEW_INTERNALID = 6;
    private static final int NEW_ENTRY_LIST_FIELD = 7;
    private static final int NEW_SORT_LIST = 8;
    private static final int NEW_INDEX_LIST = 9;
    private static final int NEW_ARCHIVE_INFO = 10;
    private static final int NEW_PROPERTIES = 11;
    private static final int NEW_DEFAULTVIEW = 12;

    Schema() {
        this.m_compoundSchema = new CompoundSchemaInfo();
        this.m_compoundSchema.m_type = 1;
        this.m_changeFlags = new CriteriaFlags(13);
    }

    Schema(NameID nameID) {
        this.setName(nameID);
        this.m_compoundSchema = new CompoundSchemaInfo();
        this.m_compoundSchema.m_type = 1;
        this.m_changeFlags = new CriteriaFlags(13);
    }

    protected Schema(String string, PermissionInfo[] permissionInfoArray, String string2, long l, String string3, String string4, String string5) {
        super(string, null, string2, l, string3, string4, string5);
        if (permissionInfoArray == null) {
            this.m_permissionList = null;
        } else {
            this.m_permissionList = new PermissionInfo[permissionInfoArray.length];
            int n = 0;
            while (n < permissionInfoArray.length) {
                long l2 = permissionInfoArray[n].getGroupID().getValue();
                int n2 = new Long(l2).intValue();
                this.m_permissionList[n] = new PermissionInfo(n2, permissionInfoArray[n].getPermissionValue());
                ++n;
            }
        }
    }

    public void setAdminGrpList(InternalID[] internalIDArray) {
        this.m_adminGrpList = internalIDArray;
        if (this.m_adminGrpList != null) {
            int n = 0;
            while (n < this.m_adminGrpList.length) {
                long l = this.m_adminGrpList[n].getValue();
                int n2 = new Long(l).intValue();
                this.m_adminGrpList[n] = new InternalID(n2);
                ++n;
            }
        }
        this.m_changeFlags.setParameter(6L, true);
    }

    public void setPermissions(PermissionInfo[] permissionInfoArray) {
        if (permissionInfoArray == null) {
            this.m_permissionList = null;
        } else {
            this.m_permissionList = new PermissionInfo[permissionInfoArray.length];
            int n = 0;
            while (n < permissionInfoArray.length) {
                long l = permissionInfoArray[n].getGroupID().getValue();
                int n2 = new Long(l).intValue();
                this.m_permissionList[n] = new PermissionInfo(n2, permissionInfoArray[n].getPermissionValue());
                ++n;
            }
        }
        this.m_changeFlags.setParameter(1L, true);
    }

    public InternalID[] getAdminGrpList() {
        return this.m_adminGrpList;
    }

    public SortInfo[] getSortInfo() {
        return this.m_sortInfo;
    }

    public void setSortInfo(SortInfo[] sortInfoArray) {
        this.m_sortInfo = sortInfoArray;
        this.m_changeFlags.setParameter(8L, true);
    }

    public void setIndexInfo(IndexInfo[] indexInfoArray) {
        this.m_indexInfo = indexInfoArray;
        this.m_changeFlags.setParameter(9L, true);
    }

    public IndexInfo[] getIndexInfo() {
        return this.m_indexInfo;
    }

    public void setArchiveInfo(ArchiveInfo archiveInfo) {
        this.m_archiveInfo = archiveInfo;
        this.m_changeFlags.setParameter(10L, true);
    }

    public ArchiveInfo getArchiveInfo() {
        return this.m_archiveInfo;
    }

    public void setEntryListFieldInfo(EntryListFieldInfo[] entryListFieldInfoArray) {
        this.m_getListFields = entryListFieldInfoArray;
        this.m_changeFlags.setParameter(7L, true);
    }

    public EntryListFieldInfo[] getEntryListFieldInfo() {
        return this.m_getListFields;
    }

    public void setDeleteOption(int n) {
        this.m_deleteOption = n;
    }

    int getDeleteOption() {
        return this.m_deleteOption;
    }

    public void setSchemaType(int n, CompoundSchemaInfo compoundSchemaInfo) {
        if (n != 1 && n != 0 && n != 4) {
            this.m_compoundSchema = compoundSchemaInfo;
        }
        this.m_compoundSchema.m_type = n;
        this.m_changeFlags.setParameter(5L, true);
    }

    private void setSchemaType(int n) {
        this.m_compoundSchema.m_type = n;
        this.m_changeFlags.setParameter(5L, true);
    }

    private void setCompoundSchema(CompoundSchemaInfo compoundSchemaInfo) {
        this.m_compoundSchema = compoundSchemaInfo;
        this.m_changeFlags.setParameter(5L, true);
    }

    public int getSchemaType() {
        return this.m_compoundSchema.m_type;
    }

    public CompoundSchemaInfo getCompoundSchema() {
        return this.m_compoundSchema;
    }

    public void setProperties(PropInfo[] propInfoArray) {
        this.m_props = propInfoArray;
        this.m_changeFlags.setParameter(11L, true);
    }

    public PropInfo[] getProperties() {
        return this.m_props;
    }

    public SchemaKey getKey() {
        return new SchemaKey(this.getName());
    }

    public void setKey(SchemaKey schemaKey) {
        this.setName(schemaKey);
    }

    public void setDefaultVUI(NameID nameID) {
        this.m_defaultVUI = nameID;
        this.m_changeFlags.setParameter(12L, true);
    }

    public NameID getDefaultVUI() {
        return this.m_defaultVUI;
    }

    public void deleteFields(FieldID[] fieldIDArray, int n) throws ARException {
        long[] lArray = new long[fieldIDArray.length];
        int n2 = 0;
        while (n2 < fieldIDArray.length) {
            lArray[n2] = fieldIDArray[n2].toLong();
            ++n2;
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        try {
            proxy.ARDeleteMultipleFields(this.m_context, this.getName(), lArray, this.m_deleteOption);
            Object var9_7 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Schema schema = null;
        schema = (Schema)super.clone();
        schema.m_compoundSchema = (CompoundSchemaInfo)this.m_compoundSchema.clone();
        schema.m_defaultVUI = (NameID)this.m_defaultVUI.clone();
        int n = this.m_getListFields.length;
        schema.m_getListFields = new EntryListFieldInfo[n];
        int n2 = 0;
        while (n2 < n) {
            schema.m_getListFields[n2] = (EntryListFieldInfo)this.m_getListFields[n2].clone();
            ++n2;
        }
        n = this.m_adminGrpList.length;
        schema.m_adminGrpList = new InternalID[n];
        n2 = 0;
        while (n2 < n) {
            schema.m_adminGrpList[n2] = (InternalID)this.m_adminGrpList[n2].clone();
            ++n2;
        }
        n = this.m_sortInfo.length;
        schema.m_sortInfo = new SortInfo[n];
        n2 = 0;
        while (n2 < n) {
            schema.m_sortInfo[n2] = (SortInfo)this.m_sortInfo[n2].clone();
            ++n2;
        }
        n = this.m_indexInfo.length;
        schema.m_indexInfo = new IndexInfo[n];
        n2 = 0;
        while (n2 < n) {
            schema.m_indexInfo[n2] = (IndexInfo)this.m_indexInfo[n2].clone();
            ++n2;
        }
        n = this.m_props.length;
        schema.m_props = new PropInfo[n];
        n2 = 0;
        while (n2 < n) {
            schema.m_props[n2] = (PropInfo)this.m_props[n2].clone();
            ++n2;
        }
        return schema;
    }

    public void create() throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        try {
            proxy.ARCreateSchema(this.m_context, this);
            Object var5_3 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
        this.resetChangeFlags();
    }

    public void remove() throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        try {
            proxy.ARDeleteSchema(this.m_context, this.getName(), this.m_deleteOption);
            Object var5_3 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
    }

    public void load(SchemaCriteria schemaCriteria) throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        SchemaKey schemaKey = new SchemaKey(this.getName());
        try {
            proxy.ARGetSchema(this.m_context, schemaKey, schemaCriteria, this);
            Object var7_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
        this.resetChangeFlags();
    }

    public void load() throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        SchemaCriteria schemaCriteria = new SchemaCriteria();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        SchemaKey schemaKey = new SchemaKey(this.getName());
        try {
            proxy.ARGetSchema(this.m_context, schemaKey, schemaCriteria, this);
            Object var7_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
        this.resetChangeFlags();
    }

    public void store() throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        try {
            proxy.ARSetSchema(this.m_context, this, this.m_changeFlags.getParameters());
            Object var5_3 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
        this.resetChangeFlags();
    }

    public void activate() {
    }

    public void passivate() {
    }

    public void setContext(ARServerUser aRServerUser) {
        this.m_context = aRServerUser;
    }

    public void unsetContext() {
        this.m_context = null;
    }

    public void clear() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (object == null) return false;
        if (!(object instanceof Schema)) {
            return false;
        }
        Schema schema = (Schema)object;
        if (!super.equals(schema)) return false;
        if (this.m_compoundSchema == null) {
            if (schema.m_compoundSchema != null) return false;
            bl = true;
        } else {
            bl = this.m_compoundSchema.equals(schema.m_compoundSchema);
        }
        if (!bl) return false;
        if (!Util.equals(this.m_getListFields, schema.m_getListFields)) return false;
        if (!Util.equals(this.m_adminGrpList, schema.m_adminGrpList)) return false;
        if (!Util.equals(this.m_sortInfo, schema.m_sortInfo)) return false;
        if (!Util.equals(this.m_indexInfo, schema.m_indexInfo)) return false;
        if (this.m_deleteOption != schema.m_deleteOption) return false;
        if (!Util.equals(this.m_props, schema.m_props)) return false;
        if (this.m_defaultVUI == null) {
            if (schema.m_defaultVUI != null) return false;
            return true;
        }
        boolean bl2 = this.m_defaultVUI.equals(schema.m_defaultVUI);
        if (!bl2) return false;
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

