/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.ARServerUser;
import com.remedy.arsys.api.DefaultProxyManager;
import com.remedy.arsys.api.PoolingProxyManager;
import com.remedy.arsys.api.Proxy;

public abstract class ProxyManager {
    private static int maxProxiesPerServer;
    private static int maxTotalProxies;
    private static ProxyManager currentManager;
    private static boolean useConnectionPooling;

    public static ProxyManager getProxyManager() {
        return currentManager;
    }

    public static void setConnectionLimits(int n, int n2) {
        maxProxiesPerServer = n;
        maxTotalProxies = n2;
    }

    public static void setUseConnectionPooling(boolean bl) {
        if (useConnectionPooling == bl) {
            return;
        }
        ProxyManager proxyManager = currentManager;
        synchronized (proxyManager) {
            if (bl) {
                currentManager = new PoolingProxyManager(maxProxiesPerServer, maxTotalProxies);
                useConnectionPooling = true;
            } else {
                currentManager.clear();
                currentManager = new DefaultProxyManager();
                useConnectionPooling = false;
            }
        }
    }

    public abstract Proxy getProxy(ARServerUser var1, boolean var2) throws ARException;

    public abstract void releaseProxy(Proxy var1, ARServerUser var2, boolean var3);

    synchronized void clear() {
    }

    static {
        currentManager = new DefaultProxyManager();
        useConnectionPooling = false;
        maxProxiesPerServer = 10;
        maxTotalProxies = 100;
    }
}

