/*  File: main.h  */

#define COMMAND_EXIT                       -1
#define COMMAND_LOGIN                       0
#define COMMAND_GET_ENTRY                   1
#define COMMAND_SET_ENTRY                   2
#define COMMAND_CREATE_ENTRY                3
#define COMMAND_DELETE_ENTRY                4
#define COMMAND_GETLIST_ENTRY               5
#define COMMAND_GET_FILTER                  6
#define COMMAND_SET_FILTER                  7
#define COMMAND_CREATE_FILTER               8
#define COMMAND_DELETE_FILTER               9
#define COMMAND_GETLIST_FILTER             10
#define COMMAND_GETLIST_GROUP              11
#define COMMAND_GET_SCHEMA                 12
#define COMMAND_SET_SCHEMA                 13
#define COMMAND_CREATE_SCHEMA              14
#define COMMAND_DELETE_SCHEMA              15
#define COMMAND_GETLIST_SCHEMA             16
#define COMMAND_GETMULT_SCHEMA             17
#define COMMAND_GET_SCH_FIELD              18
#define COMMAND_SET_SCH_FIELD              19
#define COMMAND_CREATE_SCH_FIELD           20
#define COMMAND_DELETE_SCH_FIELD           21
#define COMMAND_GETLIST_SCH_FIELD          22
#define COMMAND_GET_CHAR_MENU              23
#define COMMAND_SET_CHAR_MENU              24
#define COMMAND_CREATE_CHAR_MENU           25
#define COMMAND_DELETE_CHAR_MENU           26
#define COMMAND_GETLIST_CHAR_MENU          27
#define COMMAND_EXPORT                     28
#define COMMAND_IMPORT                     29
#define COMMAND_GET_SERVER_INFO            30
#define COMMAND_VERIFY_USER                31
#define COMMAND_EXECUTE                    32
#define COMMAND_OPEN_OUT                   33
#define COMMAND_CLOSE_OUT                  34
#define COMMAND_RECORD                     35
#define COMMAND_STOP_RECORD                36
#define COMMAND_GETLIST_SERVER             37
#define COMMAND_INITIALIZATION             38
#define COMMAND_TERMINATION                39
#define COMMAND_GET_ACTIVE_LINK            40
#define COMMAND_SET_ACTIVE_LINK            41
#define COMMAND_CREATE_ACTIVE_LINK         42
#define COMMAND_DELETE_ACTIVE_LINK         43
#define COMMAND_GETLIST_ACTIVE_LINK        44
#define COMMAND_GET_MULTIPLE_ACTIVE_LINKS  45
#define COMMAND_MERGE_ENTRY                46
#define COMMAND_LOAD_AR_QUAL_STRUCT        47
#define COMMAND_EXPAND_CHAR_MENU           48
#define COMMAND_SET_SERVER_INFO            49
#define COMMAND_GETLIST_USER               50
#define COMMAND_GET_ESCALATION             51
#define COMMAND_SET_ESCALATION             52
#define COMMAND_CREATE_ESCALATION          53
#define COMMAND_DELETE_ESCALATION          54
#define COMMAND_GETLIST_ESCALATION         55
#define COMMAND_ENTRY_STATISTICS           56
#define COMMAND_SETFULLTEXT_INFO           57
#define COMMAND_GETFULLTEXT_INFO           58
#define COMMAND_GET_SERVER_STAT            59
#define COMMAND_GETLIST_SQL                60
#define COMMAND_DELETE_MULTI_FIELD         61
#define COMMAND_EXECUTE_PROCESS            62
#define COMMAND_GET_VUI                    63
#define COMMAND_SET_VUI                    64
#define COMMAND_CREATE_VUI                 65
#define COMMAND_DELETE_VUI                 66
#define COMMAND_GETLIST_VUI                67
#define COMMAND_SET_SERVER_PORT            68
#define COMMAND_GET_MULTIPLE_ENTRY         69
#define COMMAND_GET_SUPPORT_FILE           70
#define COMMAND_SET_SUPPORT_FILE           71
#define COMMAND_CREATE_SUPPORT_FILE        72
#define COMMAND_DELETE_SUPPORT_FILE        73
#define COMMAND_GETLIST_SUPPORT_FILE       74
#define COMMAND_LAUNCH_THREAD              75
#define COMMAND_LAUNCH_WAITING_THREAD      76
#define COMMAND_RELEASE_WAITING_THREADS    77
#define COMMAND_SLEEP_TIMER                78
#define COMMAND_RANDOM_SLEEP_TIMER         79
#define COMMAND_MILLISECOND_SLEEP_TIMER    80
#define COMMAND_BEGIN_LOOP                 81
#define COMMAND_END_LOOP                   82
#define COMMAND_GETLIST_ENTRY_WITH_FIELDS  83
#define COMMAND_GETENTRY_BLOB              84
#define COMMAND_GET_CONTAINER              85
#define COMMAND_SET_CONTAINER              86
#define COMMAND_CREATE_CONTAINER           87
#define COMMAND_DELETE_CONTAINER           88
#define COMMAND_GETLIST_CONTAINER          89
#define COMMAND_GET_ERROR_MESSAGE          90
#define COMMAND_SET_LOGGING                91
#define COMMAND_CLOSE_NET_CONNECTIONS      92
#define COMMAND_SIGNAL                     93
#define COMMAND_VALIDATE_FORM_CACHE        94
#define COMMAND_GET_MULTIPLE_FIELDS        95
#define COMMAND_GETLIST_SCHEMA_WITH_ALIAS  96
#define COMMAND_GET_LOCALIZED_VALUE        97
#define COMMAND_CREATE_ALERT_EVENT         98
#define COMMAND_REGISTER_ALERTS            99
#define COMMAND_DEREGISTER_ALERTS          100
#define COMMAND_GETLIST_ALERT_USER         101
#define COMMAND_GET_ALERT_COUNT            102
#define COMMAND_DECODE_ALERT_MESSAGE       103
#define COMMAND_ENCODE_QUALIFIER           104
#define COMMAND_DECODE_QUALIFIER           105
#define COMMAND_ENCODE_ASSIGN              106
#define COMMAND_DECODE_ASSIGN              107
#define COMMAND_ENCODE_HISTORY             108
#define COMMAND_ENCODE_DIARY               109
#define COMMAND_GETLIST_EXT_SCHEMA_CANDS   110
#define COMMAND_GET_MULT_EXT_FIELD_CANDS   111
#define COMMAND_EXPAND_SS_MENU             112
#define COMMAND_VALIDATE_LICENSE           113
#define COMMAND_VALIDATE_MULTIPLE_LICENSES 114
#define COMMAND_GETLIST_LICENSE            115
#define COMMAND_CREATE_LICENSE             116
#define COMMAND_DELETE_LICENSE             117
#define COMMAND_GET_MULT_LOCALIZED_VALUES  118
#define COMMAND_GETLIST_SQL_FOR_AL         119
#define COMMAND_EXECUTE_PROCESS_FOR_AL     120
#define COMMAND_DRIVER_VERSION             121
#define COMMAND_GET_SESSION_CONFIGURATION  122
#define COMMAND_SET_SESSION_CONFIGURATION  123
#define COMMAND_ENCODE_DATE                124
#define COMMAND_DECODE_DATE                125
#define COMMAND_XML_CREATE_ENTRY           126
#define COMMAND_XML_GET_ENTRY              127
#define COMMAND_XML_SET_ENTRY              128
#define COMMAND_GET_MULT_CURR_RATIO_SETS   129
#define COMMAND_GET_CURRENCY_RATIO         130

#define MAX_COMMAND                        130

typedef char CommandType[6];  /* buffer to hold a command */

#ifdef MAIN
CommandType commands[MAX_COMMAND + 1] =
   {
      /* COMMAND_LOGIN                     */ "log",
      /* COMMAND_GET_ENTRY                 */ "ge",
      /* COMMAND_SET_ENTRY                 */ "se",
      /* COMMAND_CREATE_ENTRY              */ "ce",
      /* COMMAND_DELETE_ENTRY              */ "de",
      /* COMMAND_GETLIST_ENTRY             */ "gle",
      /* COMMAND_GET_FILTER                */ "gf",
      /* COMMAND_SET_FILTER                */ "sf",
      /* COMMAND_CREATE_FILTER             */ "cf",
      /* COMMAND_DELETE_FILTER             */ "df",
      /* COMMAND_GETLIST_FILTER            */ "glf",
      /* COMMAND_GETLIST_GROUP             */ "glg",
      /* COMMAND_GET_SCHEMA                */ "gs",
      /* COMMAND_SET_SCHEMA                */ "ss",
      /* COMMAND_CREATE_SCHEMA             */ "cs",
      /* COMMAND_DELETE_SCHEMA             */ "ds",
      /* COMMAND_GETLIST_SCHEMA            */ "gls",
      /* COMMAND_GETMULT_SCHEMA            */ "gms",
      /* COMMAND_GET_SCH_FIELD             */ "gsf",
      /* COMMAND_SET_SCH_FIELD             */ "ssf",
      /* COMMAND_CREATE_SCH_FIELD          */ "csf",
      /* COMMAND_DELETE_SCH_FIELD          */ "dsf",
      /* COMMAND_GETLIST_SCH_FIELD         */ "glsf",
      /* COMMAND_GET_CHAR_MENU             */ "gc",
      /* COMMAND_SET_CHAR_MENU             */ "sc",
      /* COMMAND_CREATE_CHAR_MENU          */ "cc",
      /* COMMAND_DELETE_CHAR_MENU          */ "dc",
      /* COMMAND_GETLIST_CHAR_MENU         */ "glc",
      /* COMMAND_EXPORT                    */ "exp",
      /* COMMAND_IMPORT                    */ "imp",
      /* COMMAND_GET_SERVER_INFO           */ "gsi",
      /* COMMAND_VERIFY_USER               */ "ver",
      /* COMMAND_EXECUTE                   */ "ex",
      /* COMMAND_OPEN_OUT                  */ "oout",
      /* COMMAND_CLOSE_OUT                 */ "cout",
      /* COMMAND_RECORD                    */ "rec",
      /* COMMAND_STOP_RECORD               */ "srec",
      /* COMMAND_GETLIST_SERVER            */ "svr",
      /* COMMAND_INITIALIZATION            */ "init",
      /* COMMAND_TERMINATION               */ "term",
      /* COMMAND_GET_ACTIVE_LINK           */ "gal",
      /* COMMAND_SET_ACTIVE_LINK           */ "sal",
      /* COMMAND_CREATE_ACTIVE_LINK        */ "cal",
      /* COMMAND_DELETE_ACTIVE_LINK        */ "dal",
      /* COMMAND_GETLIST_ACTIVE_LINK       */ "glal",
      /* COMMAND_GET_MULTIPLE_ACTIVE_LINKS */ "gmal",
      /* COMMAND_MERGE_ENTRY               */ "me",
      /* COMMAND_LOAD_AR_QUAL_STRUCT       */ "lqs",
      /* COMMAND_EXPAND_CHAR_MENU          */ "ec",
      /* COMMAND_SET_SERVER_INFO           */ "ssi",
      /* COMMAND_GETLIST_USER              */ "glu",
      /* COMMAND_GET_ESCALATION            */ "ges",
      /* COMMAND_SET_ESCALATION            */ "ses",
      /* COMMAND_CREATE_ESCALATION         */ "ces",
      /* COMMAND_DELETE_ESCALATION         */ "des",
      /* COMMAND_GETLIST_ESCALATION        */ "gles",
      /* COMMAND_ENTRY_STATISTICS          */ "stat",
      /* COMMAND_SETFULLTEXT_INFO          */ "sft",
      /* COMMAND_GETFULLTEXT_INFO          */ "gft",
      /* COMMAND_GET_SERVER_STAT           */ "gss",
      /* COMMAND_GETLIST_SQL               */ "glsql",
      /* COMMAND_DELETE_MULTI_FIELD        */ "dmsf",
      /* COMMAND_EXECUTE_PROCESS           */ "proc",
      /* COMMAND_GET_VUI                   */ "gv",
      /* COMMAND_SET_VUI                   */ "sv",
      /* COMMAND_CREATE_VUI                */ "cv",
      /* COMMAND_DELETE_VUI                */ "dv",
      /* COMMAND_GETLIST_VUI               */ "glsv",
      /* COMMAND_SET_SERVER_PORT           */ "ssp",
      /* COMMAND_GET_MULTIPLE_ENTRY        */ "gme",
      /* COMMAND_GET_SUPPORT_FILE          */ "gfl",
      /* COMMAND_SET_SUPPORT_FILE          */ "sfl",
      /* COMMAND_CREATE_SUPPORT_FILE       */ "cfl",
      /* COMMAND_DELETE_SUPPORT_FILE       */ "dfl",
      /* COMMAND_GETLIST_SUPPORT_FILE      */ "glfl",
      /* COMMAND_LAUNCH_THREAD             */ "lt",
      /* COMMAND_LAUNCH_WAITING_THREAD     */ "lwt",
      /* COMMAND_RELEASE_WAITING_THREADS   */ "rwt",
      /* COMMAND_SLEEP_TIMER               */ "st",
      /* COMMAND_RANDOM_SLEEP_TIMER        */ "rst",
      /* COMMAND_MILLISECOND_SLEEP_TIMER   */ "msst",
      /* COMMAND_BEGIN_LOOP                */ "bl",
      /* COMMAND_END_LOOP                  */ "el",
      /* COMMAND_GETLIST_ENTRY_WITH_FIELDS */ "glewf",
      /* COMMAND_GETENTRY_ATTACH           */ "geb",
      /* COMMAND_GET_CONTAINER             */ "gco",
      /* COMMAND_SET_CONTAINER             */ "sco",
      /* COMMAND_CREATE_CONTAINER          */ "cco",
      /* COMMAND_DELETE_CONTAINER          */ "dco",
      /* COMMAND_GETLIST_CONTAINER         */ "glco",
      /* COMMAND_GET_ERROR_MESSAGE         */ "gem",
      /* COMMAND_SET_LOGGING               */ "slog",
      /* COMMAND_CLOSE_NET_CONNECTIONS     */ "cnc",
      /* COMMAND_SIGNAL                    */ "sig",
      /* COMMAND_VALIDATE_FORM_CACHE       */ "vfc",
      /* COMMAND_GET_MULTIPLE_FIELDS       */ "gmsf",
      /* COMMAND_GETLIST_SCHEMA_WITH_ALIAS */ "glsa",
      /* COMMAND_GET_LOCALIZED_VALUE       */ "glv",
      /* COMMAND_CREATE_ALERT_EVENT        */ "cae",
      /* COMMAND_REGISTER_ALERTS           */ "rfa",
      /* COMMAND_DEREGISTER_ALERTS         */ "dfa",
      /* COMMAND_GETLIST_ALERT_USER        */ "glau",
      /* COMMAND_GET_ALERT_COUNT           */ "gac",
      /* COMMAND_DECODE_ALERT_MESSAGE      */ "dcam",
      /* COMMAND_ENCODE_QUALIFIER          */ "ecqal",
      /* COMMAND_DECODE_QUALIFIER          */ "dcqal",
      /* COMMAND_ENCODE_ASSIGN             */ "ecasn",
      /* COMMAND_DECODE_ASSIGN             */ "dcasn",
      /* COMMAND_ENCODE_HISTORY            */ "echst", 
      /* COMMAND_ENCODE_DIARY              */ "ecdia",
      /* COMMAND_GETLIST_EXT_SCHEMA_CANDS  */ "glxsc",
      /* COMMAND_GET_MULT_EXT_FIELD_CANDS  */ "gmxfc",
      /* COMMAND_EXPAND_SS_MENU            */ "essm",
      /* COMMAND_VALIDATE_LICENSE          */ "vl",
      /* COMMAND_VALIDATE_MULTIPLE_LICENSES*/ "vml",
      /* COMMAND_GETLIST_LICENSE           */ "gll",
      /* COMMAND_CREATE_LICENSE            */ "cl",
      /* COMMAND_DELETE_LICENSE            */ "dl",
      /* COMMAND_GET_MULT_LOCALIZED_VALUES */ "gmlv",
      /* COMMAND_GETLIST_SQL_FOR_AL        */ "sqlal",
      /* COMMAND_EXECUTE_PROCESS_FOR_AL    */ "epal",
      /* COMMAND_DRIVER_VERSION            */ "dver",
      /* COMMAND_GET_SESSION_CONFIGURATION */ "gsc",
      /* COMMAND_SET_SESSION_CONFIGURATION */ "ssc",
      /* COMMAND_ENCODE_DATE               */ "ecdat",
      /* COMMAND_DECODE_DATE               */ "dcdat",
      /* COMMAND_XML_CREATE_ENTRY          */ "xmlce",
      /* COMMAND_XML_GET_ENTRY             */ "xmlge",
      /* COMMAND_XML_SET_ENTRY             */ "xmlse",
      /* COMMAND_GET_MULT_CURR_RATIO_SETS  */ "gmcrs",
      /* COMMAND_GET_CURRENCY_RATIO        */ "gcr"
   };
#else
extern CommandType commands[MAX_COMMAND + 1];
#endif
