/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.ARServerUser;
import com.remedy.arsys.api.EntryID;
import com.remedy.arsys.api.EntryItem;
import com.remedy.arsys.api.EntryKey;
import com.remedy.arsys.api.IARPersistentObject;
import com.remedy.arsys.api.JoinEntryID;
import com.remedy.arsys.api.NameID;
import com.remedy.arsys.api.Proxy;
import com.remedy.arsys.api.ProxyManager;
import com.remedy.arsys.api.SchemaKey;
import com.remedy.arsys.api.Timestamp;
import java.io.Serializable;

public class Entry
implements IARPersistentObject,
Cloneable,
Serializable {
    public static final int AR_MERGE_ENTRY_DUP_ERROR = 1;
    public static final int AR_MERGE_ENTRY_DUP_NEW_ID = 2;
    public static final int AR_MERGE_ENTRY_DUP_OVERWRITE = 3;
    public static final int AR_MERGE_ENTRY_DUP_MERGE = 4;
    public static final int AR_MERGE_NO_REQUIRED_INCREMENT = 1024;
    public static final int AR_MERGE_NO_PATTERNS_INCREMENT = 2048;
    public static final int AR_JOIN_SETOPTION_NONE = 0;
    public static final int AR_JOIN_SETOPTION_REF = 1;
    private ARServerUser _context;
    private EntryKey _entryKey;
    private EntryItem[] _entryItems;
    private boolean _present;

    Entry() {
        this._present = true;
    }

    Entry(NameID nameID, EntryID entryID, EntryItem[] entryItemArray) {
        this._entryKey = new EntryKey(nameID, entryID);
        this._entryItems = entryItemArray;
        this._present = true;
    }

    Entry(NameID nameID, JoinEntryID joinEntryID, EntryItem[] entryItemArray) {
        this._entryKey = new EntryKey(nameID, joinEntryID);
        this._entryItems = entryItemArray;
        this._present = true;
    }

    public void setKey(EntryKey entryKey) {
        this._entryKey = entryKey;
    }

    public EntryKey getKey() {
        return this._entryKey;
    }

    public boolean isPresent() {
        return this._present;
    }

    void setPresent(boolean bl) {
        this._present = bl;
    }

    public Object clone() throws CloneNotSupportedException {
        Entry entry = (Entry)super.clone();
        entry.setKey((EntryKey)this._entryKey.clone());
        EntryItem[] entryItemArray = new EntryItem[this._entryItems.length];
        int n = 0;
        while (n < this._entryItems.length) {
            entryItemArray[n] = (EntryItem)this._entryItems[n].clone();
            ++n;
        }
        entry.setEntryItems(entryItemArray);
        return entry;
    }

    public void create() throws ARException {
        if (this._context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this._context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this._context, bl);
        try {
            proxy.ARCreateEntry(this._context, this);
            Object var5_3 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this._context, bl);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this._context, bl);
            throw throwable;
        }
    }

    public void remove() throws ARException {
        if (this._context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this._context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this._context, bl);
        try {
            proxy.ARDeleteEntry(this._context, this._entryKey);
            Object var5_3 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this._context, bl);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this._context, bl);
            throw throwable;
        }
    }

    public void load() throws ARException {
        if (this._context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this._context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this._context, bl);
        try {
            proxy.ARGetEntry(this._context, this._entryKey, null, this);
            Object var5_3 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this._context, bl);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this._context, bl);
            throw throwable;
        }
    }

    public void store() throws ARException {
        this.store(null, 0);
    }

    public void store(Timestamp timestamp, int n) throws ARException {
        if (this._context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this._context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this._context, bl);
        try {
            proxy.ARSetEntry(this._context, this, timestamp, n);
            Object var7_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this._context, bl);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this._context, bl);
            throw throwable;
        }
    }

    public void merge(SchemaKey schemaKey, int n) throws ARException {
        if (this._context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this._context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this._context, bl);
        try {
            proxy.ARMergeEntry(this._context, this, schemaKey, n);
            Object var7_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this._context, bl);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this._context, bl);
            throw throwable;
        }
    }

    public void setEntryItems(EntryItem[] entryItemArray) {
        this._entryItems = entryItemArray;
    }

    public EntryItem[] getEntryItems() {
        return this._entryItems;
    }

    public void setSchemaID(NameID nameID) {
        if (null == this._entryKey) {
            this._entryKey = new EntryKey();
        }
        this._entryKey.setSchemaID(nameID);
    }

    public NameID getSchemaID() {
        if (null == this._entryKey) {
            return null;
        }
        return this._entryKey.getSchemaID();
    }

    public EntryID getEntryID() {
        if (null == this._entryKey) {
            return null;
        }
        return this._entryKey.getEntryID();
    }

    public void setEntryID(EntryID entryID) {
        if (null == this._entryKey) {
            this._entryKey = new EntryKey();
        }
        this._entryKey.setEntryID(entryID);
    }

    public void describe() {
        int n = 0;
        while (n < this._entryItems.length) {
            this._entryItems[n].describe();
            ++n;
        }
    }

    public void activate() {
    }

    public void passivate() {
    }

    public void setContext(ARServerUser aRServerUser) {
        this._context = aRServerUser;
    }

    public void unsetContext() {
        this._context = null;
    }

    public void clear() {
        this._entryKey = null;
        this._entryItems = null;
    }
}

