/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import java.io.Serializable;
import java.util.GregorianCalendar;

public class DateInfo
implements Cloneable,
Serializable {
    private int m_numberOfDays;
    private final int GREGORGIAN_CHANGEOVER = 2299161;

    public DateInfo() {
        this.m_numberOfDays = 0;
    }

    public DateInfo(int n) {
        this.m_numberOfDays = n;
    }

    public DateInfo(String string) {
        this.m_numberOfDays = Integer.parseInt(string);
    }

    public DateInfo(int n, int n2, int n3) {
        this.setDate(n, n2, n3);
    }

    public void setValue(int n) {
        this.m_numberOfDays = n;
    }

    public void setValue(DateInfo dateInfo) {
        this.m_numberOfDays = dateInfo.getValue();
    }

    public int getValue() {
        return this.m_numberOfDays;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DateInfo dateInfo = (DateInfo)object;
        return this.m_numberOfDays == dateInfo.getValue();
    }

    public Object clone() throws CloneNotSupportedException {
        return new DateInfo(this.m_numberOfDays);
    }

    public String toString() {
        return Integer.toString(this.m_numberOfDays);
    }

    public GregorianCalendar GetDate() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (this.m_numberOfDays < 2299161) {
            n3 = this.m_numberOfDays + 32082;
        } else {
            n = this.m_numberOfDays + 32044;
            n2 = (4 * n + 3) / 146097;
            n3 = n - n2 * 146097 / 4;
        }
        n4 = (4 * n3 + 3) / 1461;
        n5 = n3 - 1461 * n4 / 4;
        n6 = (5 * n5 + 2) / 153;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n7 = 2000;
        int n8 = n2 * 100 + n4 - 4800 + n6 / 10;
        int n9 = n6 + 3 - 12 * (n6 / 10);
        int n10 = n5 - (153 * n6 + 2) / 5 + 1;
        gregorianCalendar.set(n8, n9 - 1, n10);
        return gregorianCalendar;
    }

    public void setDate(int n, int n2, int n3) {
        this.m_numberOfDays = this.dateToJulianDate(n, n2, n3);
    }

    public boolean validateDate() {
        int[] nArray = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        GregorianCalendar gregorianCalendar = this.GetDate();
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2);
        ++n2;
        int n3 = gregorianCalendar.get(5);
        if (n < -4712 || n > 9999) {
            return false;
        }
        if (n2 < 1 || n3 < 1) {
            return false;
        }
        if (n2 > 12 || n3 > 31) {
            return false;
        }
        if (n == 1582 && n2 == 8 && n3 > 4 && n3 < 15) {
            return false;
        }
        if (n2 == 2) {
            if (this.isLeapYear(n, n2, n3)) {
                return n3 <= 29;
            }
            return n3 <= 28;
        }
        return n3 <= nArray[n2];
    }

    private int dateToJulianDate(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        n4 = (14 - n2) / 12;
        n5 = n + 4800 - n4;
        n6 = n2 + 12 * n4 - 3;
        n7 = n < 1582 || n == 1582 && n2 < 10 || n == 1582 && n2 == 10 && n3 <= 4 ? n3 + (153 * n6 + 2) / 5 + n5 * 365 + n5 / 4 - 32083 : n3 + (153 * n6 + 2) / 5 + n5 * 365 + n5 / 4 - n5 / 100 + n5 / 400 - 32045;
        return n7;
    }

    private boolean isLeapYear(int n, int n2, int n3) {
        if (n >= 1582 && n2 >= 10 && n3 >= 15) {
            return n % 4 == 0 && n % 100 != 0 || n % 400 == 0;
        }
        return n % 4 == 0 && n % 100 != 0;
    }
}

