/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ArithmeticOrRelationalOperand;

public class ArithmeticOperationInfo
implements Cloneable {
    private int m_operation;
    private ArithmeticOrRelationalOperand m_operandLeft;
    private ArithmeticOrRelationalOperand m_operandRight;
    public static final int AR_ARITH_OP_ADD = 1;
    public static final int AR_ARITH_OP_SUBTRACT = 2;
    public static final int AR_ARITH_OP_MULTIPLY = 3;
    public static final int AR_ARITH_OP_DIVIDE = 4;
    public static final int AR_ARITH_OP_MODULO = 5;
    public static final int AR_ARITH_OP_NEGATE = 6;

    public ArithmeticOperationInfo() {
        this.m_operation = 0;
        this.m_operandLeft = null;
        this.m_operandRight = null;
    }

    public ArithmeticOperationInfo(int n, ArithmeticOrRelationalOperand arithmeticOrRelationalOperand, ArithmeticOrRelationalOperand arithmeticOrRelationalOperand2) throws IllegalArgumentException {
        if (!this.validate(n)) {
            throw new IllegalArgumentException("invalid operation in ArithmeticOperationInfo constructor");
        }
        this.m_operation = n;
        this.m_operandLeft = arithmeticOrRelationalOperand;
        this.m_operandRight = arithmeticOrRelationalOperand2;
    }

    public ArithmeticOrRelationalOperand getLeftOperand() {
        return this.m_operandLeft;
    }

    public ArithmeticOrRelationalOperand getRightOperand() {
        return this.m_operandRight;
    }

    public int getOperation() {
        return this.m_operation;
    }

    private boolean validate(int n) {
        return n >= 1 && n <= 6;
    }

    public Object clone() throws CloneNotSupportedException {
        ArithmeticOperationInfo arithmeticOperationInfo = (ArithmeticOperationInfo)super.clone();
        arithmeticOperationInfo.m_operandLeft = (ArithmeticOrRelationalOperand)this.m_operandLeft.clone();
        arithmeticOperationInfo.m_operandRight = (ArithmeticOrRelationalOperand)this.m_operandRight.clone();
        return arithmeticOperationInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (object == null) return false;
        if (!(object instanceof ArithmeticOperationInfo)) {
            return false;
        }
        ArithmeticOperationInfo arithmeticOperationInfo = (ArithmeticOperationInfo)object;
        if (this.m_operation != arithmeticOperationInfo.m_operation) return false;
        if (this.m_operandLeft == null) {
            if (arithmeticOperationInfo.m_operandLeft != null) return false;
            bl = true;
        } else {
            bl = this.m_operandLeft.equals(arithmeticOperationInfo.m_operandLeft);
        }
        if (!bl) return false;
        if (this.m_operandRight == null) {
            if (arithmeticOperationInfo.m_operandRight != null) return false;
            return true;
        }
        boolean bl2 = this.m_operandRight.equals(arithmeticOperationInfo.m_operandRight);
        if (!bl2) return false;
        return true;
    }

    public int hashCode() {
        return this.m_operation;
    }
}

