/*  File: arplugin.h  */

#ifndef arplugin_h
#define arplugin_h

#include "ar.h"

#ifndef C_VARIETIES_H
#define C_VARIETIES_H

/* external definition macros extracted from the c_variables.h include file  */
/* Builds the correct external reference for the type of compiler being used */

#if defined(__cplusplus)
    /* Definitions for C++ 2.0 and later */
#   define EXTERN_FUNCTION( rtn, args ) extern "C" { rtn args; }
#   define STRUCT_TAG( tag_name ) /* the tag disappears */
#   define ENUM_BITFIELD( enum_type ) unsigned
#   define ENUM_TYPE( enum_sp, enum_ty ) enum_ty
#   define NAME_CONFLICT( name ) _/**/name
#   define DOTDOTDOT ...
#   define _VOID_ /* anachronism */

#else
#if defined(c_plusplus)
    /* Definitions for C++ 1.2 */
#   define EXTERN_FUNCTION( rtn, args ) rtn args
#   define STRUCT_TAG( tag_name )  /* the tag disappears */
#   define ENUM_BITFIELD( enum_type ) unsigned
#   define ENUM_TYPE( enum_sp, enum_ty ) enum_ty
#   define NAME_CONFLICT( name ) _/**/name
#   define DOTDOTDOT ...
#   define _VOID_ /* anachronism */

#else
#if defined(__STDC__) || defined(_WIN32)
    /* Definitions for ANSI C and Win32 .c files */
#   define EXTERN_FUNCTION( rtn, args ) rtn args
#   define STRUCT_TAG( tag_name ) tag_name
#   define ENUM_BITFIELD( enum_type ) unsigned
#   define ENUM_TYPE( enum_sp, enum_ty ) enum_sp enum_ty
#   define NAME_CONFLICT( name ) name
#   define DOTDOTDOT ...
#   define _VOID_ void

#else
    /* Definitions for Sun/K&R C */
#   define EXTERN_FUNCTION( rtn, args ) rtn()
#   define STRUCT_TAG( tag_name ) tag_name
#   define ENUM_BITFIELD( enum_type ) enum_type
#   define ENUM_TYPE( enum_sp, enum_ty ) enum_sp enum_ty
#   define NAME_CONFLICT( name ) name
#   define DOTDOTDOT
#   define _VOID_

#endif

#endif

#endif

#endif

#define AR_PLUGIN_TYPE_ARDBC  1
#define AR_PLUGIN_TYPE_FILTER 2
#define AR_PLUGIN_TYPE_AREA   3

typedef struct {
   unsigned int type;      /* AR_PLUGIN_TYPE_...*/
   ARNameType   name;      /* name of plugin    */
   unsigned int version;   /* version of plugin */
} ARPluginIdentification;

#ifdef _WIN32
#define ARPLUGIN_EXPORT __declspec(dllexport)
#else /* UNIX */
#define ARPLUGIN_EXPORT   
#endif

EXTERN_FUNCTION(ARPLUGIN_EXPORT int ARPluginIdentify, (
                     ARPluginIdentification* id,   /* OUT; info about plugin */
                     ARStatusList* status          /* OUT; error message(s)*/));

EXTERN_FUNCTION(ARPLUGIN_EXPORT int ARPluginInitialization, (
                             int argc,             /*  IN; argc from main() */
                             char **argv,          /*  IN; argv from main() */
                             ARStatusList* status  /* OUT; error message(s)*/));

EXTERN_FUNCTION(ARPLUGIN_EXPORT int ARPluginTermination, (
                             ARStatusList* status  /* OUT; error message(s)*/));

EXTERN_FUNCTION(ARPLUGIN_EXPORT int ARPluginCreateInstance, (
                             void** object,        /* OUT; object created */
                             ARStatusList* status  /* OUT; error message(s)*/));

EXTERN_FUNCTION(ARPLUGIN_EXPORT int ARPluginDeleteInstance, (
                             void* object,         /* IN; object to delete */
                             ARStatusList* status  /* OUT; error message(s)*/));


#endif /* arplugin_h */
