
import OutputWriter.*;
import InputReader.*;
import java.io.*;
import com.remedy.arsys.api.*;


class JavaDriver{

   static ARServerUser context = null;

   Proxy pr = new Proxy( );

   void GetAndExecuteCommand( )
   throws IOException{
      boolean executeCommand = true;
      String  command = null;
      OutputWriter.PrintHelp( );

      while( executeCommand )
      {
         command = InputReader.GetString( "Enter the command : ", "" );

         if( command != null )
         {
               if( command.startsWith( InputReader.commentPrefix )  )
               {
                        // Comment don't do any thing
               }
               else if( command.equals( "init" ) )
               {
                  // nothing to do here
               }
               else if( command.equals( "log" ) )
               {
                  context = InputReader.GetARServerUser( "CONTROL RECORD" );
               }
               else if( command.equals( "rec" ) )
               {
                  InputReader.RecordInput( );;
               }
                else if( command.equals( "srec" ) )
                {
                    InputReader.StopRecordingInput( );;
                }
                else if( command.equals( "oout" ) )
                {
                    OutputWriter.RecordOutput( );;
                }
                else if( command.equals( "cout" ) )
                {
                    OutputWriter.StopRecordingOutput( );;
                }
                else if( command.equals( "recPrompt" ) )
                {
                    InputReader.SetRecordingPrompt( );
                }
                else if( command.equals( "srecPrompt" ) )
                {
                    InputReader.StopRecordingPrompt( );;
                }
               else if( command.equals( "cs" ) )
               {
                  createSchema( );
               }
               else if( command.equals( "ds" ) )
               {
                  deleteSchema( );
               }
               else if( command.equals( "gs" ) )
               {
                  getSchema( );
               }
               else if( command.equals( "gls" ) )
               {
                  getListSchema( );
               }
               else if( command.equals( "glsa" ) )
               {
                  getListSchemaWithAlias( );
               }
               else if( command.equals( "ss" ) )
               {
                  setSchema( );
               }
               else if( command.equals( "ce" ) )
               {
                  createEntry( );
               }
               else if( command.equals( "ge" ) )
               {
                  getEntry( );
               }
               else if( command.equals( "de" ) )
               {
                  deleteEntry( );
               }
               else if( command.equals( "gme" ) )
               {
                  getMultipleEntries( );
               }
               else if( command.equals( "se" ) )
               {
                  setEntry( );
               }
               else if( command.equals( "gle" ) )
               {
                  getListEntry( );
               }
               else if( command.equals("glewf"))
               {
                  getListEntryWithFields();
               }
               else if( command.equals( "csf" ) )
               {
                  createField( );
               }
               else if( command.equals( "ssf" ) )
               {
                  setField( );
               }
               else if( command.equals( "dsf" ) )
               {
                  deleteField( );
               }
               else if( command.equals( "gsf" ) )
               {
                  getField( );
               }
               else if( command.equals( "glsf" ) )
               {
                  getListField( );
               }
               else if( command.equals( "gmsf" ) )
               {
                  getMultipleField();
               }
               else if( command.equals( "dmsf" ) )
               {
                  deleteMultipleFields( );
               }
               else if( command.equals( "cc" ) )
               {
                  createCharMenu( );
               }
               else if( command.equals( "dc" ) )
               {
                  deleteCharMenu( );
               }
               else if( command.equals( "gc" ) )
               {
                  getCharMenu( );
               }
               else if( command.equals( "glc" ) )
               {
                  getListCharMenu( );
               }
               else if( command.equals( "sc" ) )
               {
                  setCharMenu( );
               }
               else if( command.equals( "ec" ) )
               {
                  expandCharMenu( );
               }
               else if( command.equals( "cco" ) )
               {
                  createContainer( );
               }
               else if( command.equals( "sco" ) )
               {
                  setContainer( );
               }
               else if( command.equals( "dco" ) )
               {
                  deleteContainer( );
               }
               else if( command.equals( "gco" ) )
               {
                  getContainer( );
               }
               else if( command.equals( "glco" ) )
               {
                  getListContainer( );
               }
               else if( command.equals( "cv" ) )
               {
                  createView( );
               }
               else if( command.equals( "sv" ) )
               {
                  setView( );
               }
               else if( command.equals( "dv" ) )
               {
                  deleteView( );
               }
               else if( command.equals( "gv" ) )
               {
                  getView( );
               }
               else if( command.equals( "glsv" ) )
               {
                  getListView( );
               }
               else if( command.equals( "cal" ) )
               {
                  createActiveLink( );
               }
               else if( command.equals( "sal" ) )
               {
                  setActiveLink( );
               }
               else if( command.equals( "dal" ) )
               {
                  deleteActiveLink( );
               }
               else if( command.equals( "gal" ) )
               {
                  getActiveLink( );
               }
               else if( command.equals( "glal" ) )
               {
                  getListActiveLink( );
               }
               else if( command.equals("gmal"))
               {
                  getMultipleActiveLink();
               }
               else if( command.equals( "cf" ) )
               {
                  createFilter( );
               }
               else if( command.equals( "sf" ) )
               {
                  setFilter( );
               }
               else if( command.equals( "df" ) )
               {
                  deleteFilter( );
               }
               else if( command.equals( "gf" ) )
               {
                  getFilter( );
               }
               else if( command.equals( "glf" ) )
               {
                  getListFilter( );
               }
               else if( command.equals( "ces" ) )
               {
                  createEscalation( );
               }
               else if( command.equals( "ses" ) )
               {
                  setEscalation( );
               }
               else if( command.equals( "des" ) )
               {
                  deleteEscalation( );
               }
               else if( command.equals( "ges" ) )
               {
                  getEscalation( );
               }
               else if( command.equals( "gles" ) )
               {
                  getListEscalation( );
               }
               else if( command.equals( "cfl" ) )
               {
                  createSupportFile( );
               }
               else if( command.equals( "dfl" ) )
               {
                  deleteSupportFile( );
               }
               else if( command.equals( "glfl" ) )
               {
                  getListSupportFile( );
               }
               else if( command.equals( "gfl" ) )
               {
                  getSupportFile( );
               }
               else if( command.equals( "sfl" ) )
               {
                  setSupportFile( );
               }
               else if( command.equals( "glg" ) )
               {
                  getListGroup( );
               }
               else if( command.equals( "glu" ) )
               {
                  getListUser( );
               }
               else if( command.equals( "svr" ) )
               {
                  getListServer( );
               }
               else if( command.equals( "gsi" ) )
               {
                  getServerInfo( );
               }
               else if( command.equals( "ssi" ) )
               {
                  setServerInfo( );
               }
               else if( command.equals( "ssp" ) )
               {
                  setServerPort( );
               }
               else if( command.equals( "exp" ) )
               {
                  export( );
               }
               else if( command.equals( "imp" ) )
               {
                  ARImport( );
               }
               else if( command.equals( "gft" ) )
               {
                  getFullTextInfo( );
               }
               else if( command.equals( "sft" ) )
               {
                  setFullTextInfo( );
               }
               else if( command.equals( "gss" ) )
               {
                  getServerStatistics( );
               }
               else if( command.equals( "proc" ) )
               {
                  executeProcess( );
               }
               else if( command.equals( "glsql" ) )
               {
                  getListSQL( );
               }
               else if( command.equals( "gem" ) )
               {
                  getTextForErrorMessage( );
               }
               else if( command.equals( "ver" ) )
               {
                  verifyUser( );
               }
               else if( command.equals( "cae" ) )
               {
                  CreateAlertEvent( );
               }
               else if( command.equals( "rfa" ) )
               {
                  RegisterForAlerts( );
               }
               else if( command.equals( "dfa" ) )
               {
                  DeregisterForAlerts( );
               }
               else if( command.equals( "glau" ) )
               {
                  GetListAlertUser( );
               }
               else if( command.equals( "gac" ) )
               {
                  GetAlertCount( );
               }
               else if(command.equals("dcam"))  /* ARDecodeAlertMessage */
               {
                  decodeAlertMessage( );
               }
               else if(command.equals("ecqal"))
               {
                  EncodeQualifier();
               }
               else if(command.equals("dcqal"))
               {
                  DecodeQualifier();
               }
               else if(command.equals("ecasn"))
               {
                  EncodeAssign();
               }
               else if(command.equals("dcasn"))
               {
                  DecodeAssign();
               }
               else if(command.equals("echst"))
               {
                  EncodeStatusHistory();
               }
               else if(command.equals("ecdia"))
               {
                  EncodeDiary();
               }
               else if(command.equals("glt"))
               {
                  getLocalizedValue();
               }
               else if(command.equals("gmlt"))
               {
                  getMultipleLocalizedValues();
               }
               else if(command.equals("epal"))  /* ARExecuteProcessForActiveLink  */
               {
                  executeProcessForActiveLink();
               }
               else if(command.equals("sqlal")) /* ARGetListSQLForActiveLink  */
               {
                  getListSQLForActiveLink();
               }
               else if(command.equals("glxsc")) /* ARGetListExtSchemaCandidates */
               {
                  getListExtSchemaCandidates();
               }
               else if(command.equals("gmxfc")) /* ARGetMultipleExtFieldCandidates */
               {
                  getMultipleExtFieldCandidates();
               }
               else if(command.equals("vl"))
               {
                  validateLicense();
               }
               else if(command.equals("vml"))
               {
                  validateMultipleLicenses();
               }
               else if(command.equals("gll"))
               {
                  getListLicense();
               }
               else if(command.equals("cl"))
               {
                 // createLicense();
               }
               else if(command.equals("dl"))
               {
                 // deleteLicense();
               }
               else if (command.equals("gsc"))
               {
                  getSessionConfiguration();
               }
               else if (command.equals("ssc"))
               {
                  setSessionConfiguration();
               }
               else if( command.equals( "quit" ) || command.equals( "q" ) ||
                        command.equals( "x" ) )
               {
                  executeCommand = false;
                  if( context != null )
                  {
                      context.clear( );
                      context = null;
                  }
               }
               else if( command.equals( "h" ) || command.equals( "?" ) )
               {
                   OutputWriter.PrintHelp( );
               }
               else
               {
                  System.out.println( "Not a valid command..." );
               }
               System.out.println( );
               System.out.println( );
         }
      }
   }

   void createSchema( )
   {
      try{
         SchemaFactory schemaMan = SchemaFactory.getFactory( );
         Schema schema = (Schema)schemaMan.newInstance( );
         schema.setContext( context );

         InputReader.PrintHeader( "CREATE SCHEMA" );

         NameID schemaName = InputReader.GetNameID( "Schema Name: ", true );

         schema.setName( schemaName );

         int type = InputReader.GetInt("Schema Type: ", 1);
	 schema.setSchemaType( type, null );

         PermissionInfo[] permissions = InputReader.GetPermissionInfoList( true );

         schema.setPermissions(permissions);

         InputReader.PrintHeader("Ids of sub admin groups allowed to access schema:\n");
         InternalID[] id = InputReader.GetInternalIDList( );
         schema.setAdminGrpList(id);

         EntryListFieldInfo[] fldInfos = InputReader.GetEntryListFieldInfoList( );
         schema.setEntryListFieldInfo( fldInfos );

         SortInfo[] sortarr = InputReader.GetSortInfoList( );
         schema.setSortInfo( sortarr );

         IndexInfo[] index = InputReader.GetIndexInfoList( );;
	 schema.setIndexInfo( index );

         String helpText = InputReader.GetString( "Help Text: ", "" );
	 schema.setHelpText( helpText );


         AccessNameID ownerID =  InputReader.GetAccessNameID( "Onwer: ", true );

	 schema.setOwner( ownerID );

         String diary = InputReader.GetString( "Change Diary: ", "" );
	 schema.setDiary( diary );


         PropInfo[] propList = InputReader.GetPropInfoList( );
         schema.setProperties( propList );

         schema.create();

         // Success. Print the status
            StatusInfo[] statusList = context.getLastStatus( );
            OutputWriter.PrintStatusInfoList( "", "Create Schema Resulsts", statusList );


         schemaMan.releaseInstance(schema);

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
          OutputWriter.PrintARException( e );
      }
   }



   void deleteSchema( ){

      try{

      InputReader.PrintHeader( "DELETE SCHEMA" );

      SchemaFactory schemaMan = SchemaFactory.getFactory();
      Schema schema = (Schema)schemaMan.newInstance();
      schema.setContext(context);

      NameID schemaName = InputReader.GetNameID( "Schema Name:", true );

      schema.setName( schemaName );

      int deleteOption = InputReader.GetInt( "Delete option ? ( 0, 1, 2 ) ( 0 ):", 0 );
      schema.setDeleteOption( deleteOption );

      schema.remove( );

      // Success. Print the status
          StatusInfo[] statusList = context.getLastStatus( );
          OutputWriter.PrintStatusInfoList( "", "Delete Schema Resulsts", statusList );

      schemaMan.releaseInstance(schema);
   }

      catch( IOException e )
      {
          OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
          OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
          OutputWriter.PrintARException( e );
      }
}


void getSchema( ){
   try{

      SchemaFactory schemaMan = SchemaFactory.getFactory();


      SchemaKey key = InputReader.GetSchemaKey( );

      SchemaCriteria crit = new SchemaCriteria();
      crit.setRetrieveAll(true);

      Schema schema = (Schema)schemaMan.findByKey(context, key, crit);

      OutputWriter.PrintSchema( "",  "Schema Information...", schema );
   }
   catch( IOException e )
   {
      OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
   }
   catch( NullPointerException e )
   {
      OutputWriter.PrintString( "Null Pointer exception...\n" );
   }
   catch( ARException e )
   {
      OutputWriter.PrintARException( e );
   }
}

   void getListSchema( ){
      try{

         SchemaListCriteria criteria = InputReader.GetSchemaListCriteria( );

         SchemaFactory schemaMan = SchemaFactory.getFactory();

         NameID[] schemaList = schemaMan.find( context, criteria);

         OutputWriter.PrintNameIDList( "", "Schama name List: ", schemaList );
         OutputWriter.PrintStatusInfoList("", "Status:", context.getLastStatus());
      }

      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
          OutputWriter.PrintARException( e );
      }
   }

   void getListSchemaWithAlias( )
   {
      try{
         SchemaAliasesCriteria criteria = InputReader.GetSchemaAliasesCriteria( );

         SchemaFactory schemaMan = SchemaFactory.getFactory();
         SchemaAliasInfo[] schemaAliases = schemaMan.findAliases(context, criteria);

         OutputWriter.PrintSchemaAliases( "", schemaAliases);
         OutputWriter.PrintStatusInfoList("", "Status:", context.getLastStatus());
      }

      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
          OutputWriter.PrintARException( e );
      }
   }

   void setSchema( ){

      try{

         SchemaFactory schemaMan = SchemaFactory.getFactory();

         Schema schema = (Schema)schemaMan.newInstance();
         schema.setContext(context);


         NameID name = InputReader.GetNameID( "Schema Name", true );
         schema.setName( name );


         if( InputReader.GetBoolean("Change schema name? (F): ", false ) )
         {
               NameID newName = InputReader.GetNameID( "Schema name (): " );
               schema.setNewName( newName );
         }

         if( InputReader.GetBoolean( "Change compound schema info? (F): ", false ) )
         {
               int type = InputReader.GetInt( "Schema Type: ", 1 );
               schema.setSchemaType( type, null );
         }

         if( InputReader.GetBoolean( "Change group list? (F): ", false ) )
         {
               PermissionInfo[] permissions = InputReader.GetPermissionInfoList( true );
               schema.setPermissions( permissions );
         }

         if( InputReader.GetBoolean( "Change sub admin group list? (F): ", false ) )
         {
               InputReader.PrintHeader( "Ids of sub admin groups allowed to access schema:");
               InternalID[] id = InputReader.GetInternalIDList( );
               schema.setAdminGrpList(id);
         }

         if( InputReader.GetBoolean( "Change sort list? (F): ", false ) )
         {
               SortInfo[] sortarr = InputReader.GetSortInfoList( );
               schema.setSortInfo( sortarr );
         }

         if( InputReader.GetBoolean("Change query list fields? (F): ", false ) )
         {
               EntryListFieldInfo[] fldInfos= InputReader.GetEntryListFieldInfoList( );
               schema.setEntryListFieldInfo( fldInfos );
         }

         if( InputReader.GetBoolean( "Change index list? (F): ", false ) )
         {
               IndexInfo[] index = InputReader.GetIndexInfoList( );
               schema.setIndexInfo( index );
         }

         if( InputReader.GetBoolean("Change help text? (F): ", false ))
         {
               String help = InputReader.GetString( "Help Text (): ", "" );
               schema.setHelpText( help );
         }

         if( InputReader.GetBoolean( "Change owner? (F): ", false ) )
         {
               AccessNameID owner = InputReader.GetAccessNameID( "New Owner (): " );
               schema.setOwner( owner );
         }

         if( InputReader.GetBoolean( "Add to change diary? (F): ", false ) )
         {
               String diary = InputReader.GetString( "Change Diary (): ", "" );
               schema.setDiary( diary );
         }

         schema.store();

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set Schema Results", statusList );

         schemaMan.releaseInstance(schema);
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
          OutputWriter.PrintARException( e );
      }
   }


   public void createEntry( ){

      Entry entry=null;

      try{
         InputReader.PrintHeader( "CREATE ENTRY" );

         EntryFactory entryMan=EntryFactory.getFactory( );
         entry= (Entry)entryMan.newInstance( );
         entry.setContext(context);

         // Get the schema name
               NameID name = InputReader.GetNameID( "Schema:", true );
               entry.setSchemaID( name  );

         // create entryItems
               InputReader.PrintHeader( "Field/value pairs to create:" );
               EntryItem[] entryItems = InputReader.GetEntryItemList( );

         // set the entry items...
               entry.setEntryItems( entryItems );

         entry.create( );

         OutputWriter.PrintString( "Entry id: " + entry.getEntryID( ).toString( ) );
         entryMan.releaseInstance( entry );
      }
      catch( IOException e )
      {
          OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
          OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
          OutputWriter.PrintARException( e );
      }
   }



void getEntry( ){
   try{
         InputReader.PrintHeader( "Get Entry" );

         EntryFactory entryMan = EntryFactory.getFactory( );
         EntryCriteria	entryCriteria = new EntryCriteria( );

         // Get the Entry Key
            EntryKey entryKey = InputReader.GetEntryKey( );

         // Get the fields information
            FieldID[] fieldsList = InputReader.GetFieldIDList( );

            EntryListFieldInfo[]  entryList = null;
            if( fieldsList != null && fieldsList.length != 0 )
            {
               entryList = new EntryListFieldInfo[ fieldsList.length ];
               for( int i = 0; i < fieldsList.length; i++ )
               {
                     entryList[i] = new EntryListFieldInfo( fieldsList[i] );
               }
            }
            entryCriteria.setEntryListFieldInfo( entryList );


      Entry entry=entryMan.findByKey( context, entryKey, entryCriteria );

      OutputWriter.PrintEntry( "", "Entry Information:", entry );
   }
   catch( IOException e )
   {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
   }
   catch( NullPointerException e )
   {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
   }
   catch( ARException e )
   {
         OutputWriter.PrintARException( e);
   }
}


void getMultipleEntries( ){
   try{
         InputReader.PrintHeader( "GET MULTIPLE ENTRIES" );

         EntryFactory entryMan = EntryFactory.getFactory( );
         EntryListCriteria entryListCriteria = new EntryListCriteria( );
         EntryCriteria	entryCriteria = new EntryCriteria( );

         // Get the schema Name
            NameID name = InputReader.GetNameID( "Schema Name: ", true );
            entryListCriteria.setSchemaID( name );

         // Get Entry IDs to retrieve
            EntryID[] entryIDs = InputReader.GetEntryIDList( );
            entryListCriteria.setEntriesToRetrieve( entryIDs );

         // Get the fields information
            FieldID[] fieldsList = InputReader.GetFieldIDList( );

            EntryListFieldInfo[]  entryList = null;
            if( fieldsList != null && fieldsList.length != 0 )
            {
               entryList = new EntryListFieldInfo[ fieldsList.length ];
               for( int i = 0; i < fieldsList.length; i++ )
               {
                     entryList[i] = new EntryListFieldInfo( fieldsList[i] );
               }
            }
            entryCriteria.setEntryListFieldInfo( entryList );


      Entry[] entries=entryMan.findObjects( context, entryListCriteria, entryCriteria, null );

      OutputWriter.PrintEntryList( "", "Entry List: ", entries );
   }
   catch( IOException e )
   {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
   }
   catch( NullPointerException e )
   {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
   }
   catch( ARException e )
   {
         OutputWriter.PrintARException( e );
   }
}



   void setEntry( )
   {
      try{

         InputReader.PrintHeader( "Set Entry" );
         EntryFactory entryMan = EntryFactory.getFactory( );
         EntryCriteria	entryCriteria = new EntryCriteria( );

         // Get the Entry Key
            EntryKey entryKey = InputReader.GetEntryKey( );

         // Get the fields information
            FieldID[] fieldsList = null;

            EntryListFieldInfo[]  entryList = null;
            if( fieldsList != null && fieldsList.length != 0 )
            {
               entryList = new EntryListFieldInfo[ fieldsList.length ];
               for( int i = 0; i < fieldsList.length; i++ )
               {
                     entryList[i] = new EntryListFieldInfo( fieldsList[i] );
               }
            }
            entryCriteria.setEntryListFieldInfo( entryList );


         Entry entry=entryMan.findByKey( context, entryKey, entryCriteria );

         EntryItem[] entryItems = InputReader.GetEntryItemList( );

         entry.setEntryItems( entryItems );

         entry.store( );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set Entry Results", statusList );
      }
      catch( IOException x )
      {
         OutputWriter.PrintString( "Problem in getting the input for set entry...\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void deleteEntry( )
   {
      try{
         InputReader.PrintHeader( "DELETE ENTRY" );

         EntryFactory entryMan = EntryFactory.getFactory( );

         // Create a new entry instance
            Entry entry = ( Entry )entryMan.newInstance( );

         // Get and set the entry key
            EntryKey key = InputReader.GetEntryKey( );
            entry.setKey( key );

         // Now set the context
            entry.setContext( context );

         // Now remove the entry
            entry.remove( );

          // Success. Print the status
              StatusInfo[] statusList = context.getLastStatus( );
              OutputWriter.PrintStatusInfoList( "", "Delete Entry Results", statusList );

         entryMan.releaseInstance( entry );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

void getListEntry( )
{
   try
   {
      InputReader.PrintHeader( "Get LIST Entry" );

      EntryFactory entryMan=EntryFactory.getFactory( );

      // Get the EntryListCriteria
      EntryListCriteria entryListCriteria = InputReader.GetEntryListCriteria( );

      // Get the entry criteria
      EntryCriteria entryCriteria = InputReader.GetEntryCriteria( );

      Integer nMatches = null;

      if (InputReader.GetBoolean( "Get number of matches? (F):", false ) == true)
      {
         nMatches = new Integer(0);
      }

      EntryListInfo[] entryInfos = entryMan.findEntryListInfos( context, entryListCriteria, entryCriteria, nMatches );

      OutputWriter.PrintEntryListInfoList( "    ", "Entry List Information:", entryInfos );

      if (nMatches != null)
      {
        OutputWriter.PrintInteger("", "Number of matches: ", nMatches);
      }
   }
   catch( IOException e )
   {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
   }
   catch( NullPointerException e )
   {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
   }
   catch( ARException e )
   {
         OutputWriter.PrintARException( e );
   }
}

void getListEntryWithFields()
{
   try
   {
      InputReader.PrintHeader( "Get LIST ENTRY WITH FIELDS" );

      EntryFactory entryMan = EntryFactory.getFactory( );

      // Get the EntryListCriteria
      EntryListCriteria entryListCriteria = InputReader.GetEntryListCriteria( );

      // Get the entry criteria
      EntryCriteria entryCriteria = InputReader.GetEntryCriteria( );

      Integer nMatches = null;

      if (InputReader.GetBoolean( "Get number of matches? (F):", false ) == true)
      {
         nMatches = new Integer(0);
      }

      Entry[] entries = entryMan.findObjects( context, entryListCriteria, entryCriteria, nMatches);

      OutputWriter.PrintEntryList( "", "Entry List: ", entries );

      if (nMatches != null)
      {
        OutputWriter.PrintInteger("", "Number of matches: ", nMatches);
      }
   }
   catch( IOException e )
   {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
   }
   catch( NullPointerException e )
   {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
   }
   catch( ARException e )
   {
         OutputWriter.PrintARException( e );
   }
}

   void createField( )
   {
      try{
         InputReader.PrintHeader( "CREATE FIELD" );

         // Create an empty field
            FieldFactory fieldMan = FieldFactory.getFactory( );
            Field field = (Field)fieldMan.newInstance( );

         // Set the context ( user session )
            field.setContext( context );

         // Set the schema name
            NameID schemaName = InputReader.GetNameID( "Schema Name: ", true  );
            field.setSchema( schemaName );

         // Set the Field ID
            FieldID id = InputReader.GetFieldID( );
            field.setFieldID( id );

         // Set the reserved id
            boolean reservedID = InputReader.GetBoolean( "Create even if ID is reserved? (F): ", false );
            field.setReservedIDOK( reservedID );

         // Set the Field Name
            NameID fieldName = InputReader.GetNameID( "Field Name: ", true );
            field.setName( fieldName );

         // Set the field map if necessary.

         // Set the Data Type
            DataType dataType = InputReader.GetDataType( );
            field.setDataType( dataType );

         // Set the option for entering the value
            int option = InputReader.GetInt( "Required, Optional, System, or Display-only (1-4) (2): ", 2 );
            field.setFieldOption( option );

         // Set create mode
            int createMode = InputReader.GetInt( "Open or Protected at create (1 or 2) (1): ", 1 );
            field.setCreateMode( createMode );

         // Set default value
            if( InputReader.GetBoolean( "Have default value ( false ):", false ) )
            {
               Value val = InputReader.GetValue( );
               field.setDefaultValue( val );
            }

         // Set permissions
            PermissionInfo[] permissions = InputReader.GetPermissionInfoList( true );
            field.setPermissions( permissions );

         // Set limits
            FieldLimitInfo limitInfo = InputReader.GetFieldLimitInfo();
            field.setFieldLimit(limitInfo);

         // Set DisplayInstanceList
            DisplayInstanceList dispInstanceList = InputReader.GetDisplayInstanceList( );
            field.setDisplayInstance( dispInstanceList );

         // Set the help text
            String helpText = InputReader.GetString( "Help Text: ", "" );
            field.setHelpText( helpText );

         // Set the owner
            AccessNameID owner = InputReader.GetAccessNameID( "Owner: ", true );
            field.setOwner( owner );

         // Set Change Diary
            String diary = InputReader.GetString( "Diary: ", "" );
            field.setDiary( diary );

         // Set the field mapping structure
            FieldMappingInfo mapInfo = InputReader.GetFieldMappingInfo( );
            field.setFieldMap( mapInfo );

         // Now create the field
            field.create( );

            OutputWriter.PrintStatusInfoList("", "Status:", context.getLastStatus());
      }

      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void deleteField( )
   {
      try{
         InputReader.PrintHeader( "DELETE FIELD" );

         // Create an empty field
            FieldFactory fieldMan = FieldFactory.getFactory( );
            Field field = (Field)fieldMan.newInstance( );

         // Set the context ( user session )
            field.setContext( context );

         // Set the schema name
            NameID schemaName = InputReader.GetNameID( "Schema Name: ", true );
            field.setSchema( schemaName );

         // Set the Field ID
            FieldID id = InputReader.GetFieldID( );
            field.setFieldID( id );

         // set the delete option
            int deleteOption = InputReader.GetInt( "Delete option - clean, data, cascade (0 - 2) (0): ", 0 );
            field.setDeleteOption( deleteOption );

         // Now delete the field
            field.remove( );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set Entry Results", statusList );

      }

      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }


   void deleteMultipleFields( )
   {
      try{
         InputReader.PrintHeader( "DELETE MULTIPLE FIELDS" );

         // Create Schema Factory
            SchemaFactory schemaMan = SchemaFactory.getFactory( );

         // Create a new schema object
            Schema schema = ( Schema )schemaMan.newInstance( );

         // Set the schema name
            NameID schemaName = InputReader.GetNameID( "Schema Name: ", true );
            schema.setName( schemaName );

         // Set the context ( user session )
            schema.setContext( context );

         // Get the Field IDs to be deleted
            FieldID[] idList = InputReader.GetFieldIDList( );

         // Get the delete option
            int deleteOption = InputReader.GetInt( "Delete Option (0, 1, 2 ) (0): ", 0 );

         // Now delete the fields
            schema.deleteFields( idList, deleteOption );

          // Success. Print the status
              StatusInfo[] statusList = context.getLastStatus( );
              OutputWriter.PrintStatusInfoList( "", "Delete Multiple Fields Results", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void getField( )
   {
      try{
         InputReader.PrintHeader( "GET FIELD" );

         // Create an empty field
            FieldFactory fieldMan = FieldFactory.getFactory( );

         // Set the schema name
            NameID schemaName = InputReader.GetNameID( "Schema Name: ", true );

         // Set the Field ID
            FieldID id = InputReader.GetFieldID( );
            FieldKey key = new FieldKey(  schemaName, id );

         // Set the field criteria to retrieve all
            FieldCriteria crit = new FieldCriteria( );
            crit.setRetrieveAll(true);

         // Find the field
            Field field = fieldMan.findByKey( context, key, crit );

          // Print the field info
              OutputWriter.PrintField( "", "Field Information:", field );
     }
     catch( IOException e )
     {
        OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
     }
     catch( NullPointerException e )
     {
        OutputWriter.PrintString( "Null Pointer exception...\n" );
     }
     catch( ARException e )
     {
        OutputWriter.PrintARException( e );
     }
   }

   void getListField( )
   {
      try{
         InputReader.PrintHeader( "GET LIST FIELD" );

         // Create an empty field
            FieldFactory fieldMan = FieldFactory.getFactory( );

         // Set the field List criteria
            FieldListCriteria listCriteria = InputReader.GetFieldListCriteria( );

         // Find the fields
            FieldKey[] fieldList = fieldMan.find( context, listCriteria );

         // Print the information
            OutputWriter.PrintFieldKeyList( "", "Field Key List Information:", fieldList );
            OutputWriter.PrintStatusInfoList("", "Status", context.getLastStatus());

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void getMultipleField( )
   {
      try{
         InputReader.PrintHeader( "GET MULTIPLE FIELD" );

         // Create an empty field
            FieldFactory fieldMan = FieldFactory.getFactory( );

         // Set the field List criteria
            FieldListCriteria listCriteria = InputReader.GetFieldListCriteria( );

         // Set the field criteria to retrieve all
            FieldCriteria criteria = new FieldCriteria( );
            criteria.setRetrieveAll(true);

         // Find the fields
            Field[] fieldList = fieldMan.findObjects( context, listCriteria, criteria );

         // Print the information
            OutputWriter.PrintFieldList( "", "Field List Information:", fieldList );
            OutputWriter.PrintStatusInfoList("", "Status", context.getLastStatus());

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void setField( )
   {
      try{
         InputReader.PrintHeader( "SET FIELD" );

         // Create an empty field
            FieldFactory fieldMan = FieldFactory.getFactory( );
            Field field = (Field)fieldMan.newInstance( );

         // Set the context ( user session )
            field.setContext( context );

         // Request the Schema Name
            NameID  schemaName = InputReader.GetNameID("Schema name: ");
            field.setSchema(schemaName);

         // Request the Field ID
            FieldID id = InputReader.GetFieldID("Field id (1): ", 1);
            field.setFieldID( id );

         // Request the Datatype
            DataType dataType = InputReader.GetDataType( );
            field.setDataType( dataType );

         // Set the Field Name
            if( InputReader.GetBoolean( "Change fieldName? (F): ", false ) )
            {
               NameID fieldName = InputReader.GetNameID( "field name: " );
               field.setName( fieldName );
            }

         // Set the field mapping structure
            if( InputReader.GetBoolean( "Change field mapping? (F): ", false ) )
            {
               FieldMappingInfo mapInfo = InputReader.GetFieldMappingInfo( );
               field.setFieldMap( mapInfo );
            }

         // Set the option for entering the value
            if( InputReader.GetBoolean( "Change option? (F): ", false ) )
            {
               int option = InputReader.GetInt( "Required, Optional, System, or Display-only (1-4) (2): ", 2 );
               field.setFieldOption( option );
            }

         // Set create mode
            if( InputReader.GetBoolean( "Change create mode? (F): ", false ) )
            {
               int createMode = InputReader.GetInt( "Open or Protected at create (1 or 2) (1) ", 1 );
               field.setCreateMode( createMode );
            }

         // Set default value
            if( InputReader.GetBoolean( "Change default value? (F): ", false ) )
            {
               Value val = InputReader.GetValue( );
               field.setDefaultValue( val );
            }

         // Set permissions
            if( InputReader.GetBoolean( "Change permissions? (F): ", false ) )
            {
               PermissionInfo[] permissions = InputReader.GetPermissionInfoList( true );
               field.setPermissions( permissions );
            }

         // Set limits
            if( InputReader.GetBoolean( "Change field limits? (F): ", false ) )
            {
                FieldLimitInfo limitInfo = InputReader.GetFieldLimitInfo();
                field.setFieldLimit(limitInfo);
            }

         // Set DisplayInstanceList
            if( InputReader.GetBoolean( "Change display instance? (F): ", false ) )
            {
               DisplayInstanceList dispInstanceList = InputReader.GetDisplayInstanceList( );
               field.setDisplayInstance( dispInstanceList );
            }

         // Set the help text
            if( InputReader.GetBoolean( "Change help text? (F): ", false ) )
            {
               String helpText = InputReader.GetString( "Help Text: ", "" );
               field.setHelpText( helpText );
            }

         // Set the owner
            if( InputReader.GetBoolean( "Change owner? (F): ", false ) )
            {
               AccessNameID owner = InputReader.GetAccessNameID( "Owner: " );
               field.setOwner(  owner );
            }

         // Set Change Diary
            if( InputReader.GetBoolean( "Add to change diary? (F): ", false ) )
            {
               String diary = InputReader.GetString( "Diary: ", "" );
               field.setDiary( diary );
            }

         // Now store the new field information
            field.store( );

          // Success. Print the status
              StatusInfo[] statusList = context.getLastStatus( );
              OutputWriter.PrintStatusInfoList( "", "   ARSetField results", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void createCharMenu( )
   {
      try{
         InputReader.PrintHeader( "CREATE CHAR MENU" );

         // Create the menu factory
               MenuFactory menuFactory = MenuFactory.getFactory( );

         // Create a Menu (empty) instance
               Menu menu = (Menu)menuFactory.newInstance( );

         // Set the menu name
               NameID menuName = InputReader.GetNameID( "Character Menu Name():", true );
               menu.setName( menuName  );

         // Set refreshing code
               int refreshCode = InputReader.GetInt( "Refresh on connect, open, interval (1 - 3) (1): ", 1 );
               menu.setRefreshCode( refreshCode );

         // Set the Char menu item info
               CharMenuInfo menuInfo = InputReader.GetCharMenuInfo( );
               menu.setMenuDefinition( menuInfo );

         // Set the properties
               PropInfo[] props = InputReader.GetPropInfoList( );

         // Set help text
               String helpText = InputReader.GetString( "Help Text():", "" );
               menu.setHelpText( helpText );

         // Set Owner
               AccessNameID owner = InputReader.GetAccessNameID( "Owner():", true );
               menu.setOwner( owner );

         // Set Change diary
               String changeDiary = InputReader.GetString( "Change Diary():", "" );
               menu.setDiary( changeDiary );

         // Set context ( user session )
               menu.setContext( context );

         // Now create the menu
               menu.create( );

          // Success. Print the status
              StatusInfo[] statusList = context.getLastStatus( );
              OutputWriter.PrintStatusInfoList( "", "Set Field Results", statusList );

         // release the menu instance
               menuFactory.releaseInstance( menu );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void deleteCharMenu( )
   {
      try{
         InputReader.PrintHeader( "DELETE CHAR MENU" );

         // Create the menu factory
               MenuFactory menuFactory = MenuFactory.getFactory( );

         // Create a Menu (empty) instance
               Menu menu = (Menu)menuFactory.newInstance( );

         // Set the menu name
               NameID menuName = InputReader.GetNameID( "Character Menu Name():", true );
               menu.setName( menuName );

         // Set context ( user session )
               menu.setContext( context );

         // delete the menu
               menu.remove( );

          // Success. Print the status
              StatusInfo[] statusList = context.getLastStatus( );
              OutputWriter.PrintStatusInfoList( "", "Set Field Results", statusList );

         // release the menu instance
               menuFactory.releaseInstance( menu );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }


   void getCharMenu( )
   {
      try{
         InputReader.PrintHeader( "GET CHAR MENU" );

         // Create the menu factory
               MenuFactory menuFactory = MenuFactory.getFactory( );

         // Get Menu Key
               MenuKey key = InputReader.GetMenuKey( );

         // Create MenuCriteria Object
            MenuCriteria crit = new MenuCriteria();
            if( crit != null )
            {
                  crit.setRetrieveAll(true);
            }

         // Find the menu
               Menu menu = menuFactory.findByKey( context, key, crit );

         // Now print all the information
               OutputWriter.PrintMenu( "", "Menu Information: ", menu );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }

   }

   void getListCharMenu( )
   {
      try{
         InputReader.PrintHeader( "GET LIST CHAR MENU" );

         // Create the menu factory
               MenuFactory menuFactory = MenuFactory.getFactory( );

         // Create MenuListCriteria Object
               MenuListCriteria listCrit = InputReader.GetMenuListCriteria( );

         // Create MenuCriteria Object
            MenuCriteria crit = new MenuCriteria( );
            if( crit != null )
            {
                  crit.setRetrieveAll( true );
            }

         // Find the menu objects
               Menu[] menuList = menuFactory.findObjects( context, listCrit, crit );

         // Now print all the information
               OutputWriter.PrintMenuList( "", "Menu List Information: ", menuList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }

   }

   void expandCharMenu( )
   {
      try{
         InputReader.PrintHeader( "EXPAND CHAR MENU" );

         // Create the menu factory
               MenuFactory menuFactory = MenuFactory.getFactory( );

         // Create a Menu (empty) instance
               Menu menu = (Menu)menuFactory.newInstance( );


         // Set context ( user session )
               menu.setContext( context );

         // Set the Char menu  info
               CharMenuInfo menuInfo = InputReader.GetCharMenuInfo( );
               menu.setMenuDefinition( menuInfo );

         // now expand the menu
               CharMenuInfo expandedMenuInfo = menu.expandMenu( );

         // Print the expanded menu information
               OutputWriter.PrintCharMenuInfo( "", "Expanded char Menu Info:", expandedMenuInfo );

         // release the menu instance
               menuFactory.releaseInstance( menu );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void setCharMenu( )
   {
      try{
         InputReader.PrintHeader( "SET CHAR MENU" );

         // Create the menu factory
               MenuFactory menuFactory = MenuFactory.getFactory( );

         // Create a new Menu instance
               Menu menu = ( Menu )menuFactory.newInstance( );

               NameID name = InputReader.GetNameID( "Menu Name():", true );
               menu.setName( name );

         // If needed get the information to change the menu name
               if( InputReader.GetBoolean( "Change Character Menu Name? (F): ", false ) )
               {
                  NameID newName = InputReader.GetNameID( "New Name ():" );
                  menu.setNewName( newName );
               }

         // If needed get and Set new refreshing code
               if( InputReader.GetBoolean( "Change Refresh Code? (F): ", false ) )
               {
                  int refreshCode = InputReader.GetInt( "Refresh on connect, open, interval (1 - 3) (1): ", 1 );
                  menu.setRefreshCode( refreshCode );
               }

         // If needed get the new menu definition
               if( InputReader.GetBoolean( "Change Menu Definition? (F): ", false ) )
               {
                  CharMenuInfo menuInfo = InputReader.GetCharMenuInfo( );
                  menu.setMenuDefinition( menuInfo );
               }

         // If needed get the new help text
               if( InputReader.GetBoolean( "Change help text? (F): ", false ) )
               {
                  String helpText = InputReader.GetString( "    Help Text(): ", "" );
                  menu.setHelpText( helpText );
               }

         // If needed get the new Owner
               if( InputReader.GetBoolean( "Change Owner? (F): ", false ) )
               {
                  AccessNameID owner = InputReader.GetAccessNameID( "Owner (): ", true  );
                  menu.setOwner( owner );
               }

         // If needed get the new Owner
               if( InputReader.GetBoolean( "Add to Change Diary? (F): ", false ) )
               {
                  String diary = InputReader.GetString( "    Change Diary (): ", "" );
                  menu.setDiary( diary );
               }

         // If needed get the new properties
               if( InputReader.GetBoolean( "Change object properties? (F): ", false ) )
               {
                  PropInfo[] props = InputReader.GetPropInfoList( );
                  menu.setProperties( props );
               }

         // Set the context
               menu.setContext( context );

         // Now store all the menu information
               menu.store( );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set Char Menu Results", statusList );

         // release the menu instance
               menuFactory.releaseInstance( menu );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }

   }


   void createContainer( )
   {
      try{
         InputReader.PrintHeader( "CREATE CONTAINER" );

         ContainerFactory conFact = ContainerFactory.getFactory( );

         // Create a new container object
               Container container = ( Container )conFact.newInstance( );

         // Get and Set the container name
               NameID name = InputReader.GetNameID( "Container Name:", true );
               container.setName( name );

         // Get and Set the permissions information
               PermissionInfo[] permissionList = InputReader.GetPermissionInfoList( true );
               container.setPermissions( permissionList );

         // Get and Set sub admin groups allowed to access this container
               InternalID[] adminList = InputReader.GetInternalIDList( );
               container.setAdminGroupList( adminList );

         // Get and Set container owner
               ContainerOwner[] containerOwnerList = InputReader.GetContainerOwnerList( );
               container.setContainerOwner( containerOwnerList );

         // Get and Set the container Label
               String label = InputReader.GetString( "Label ():", "" );
               container.setLabel( label );

         // Get and set the description
               String desc = InputReader.GetString( "Description ():", "" );
               container.setDescription( desc );

         // Get and Set the container type
               ContainerType type = InputReader.GetContainerType( );
               container.setType( type );

         // Get and Set the reference list
               ReferenceBase[] references = InputReader.GetReferenceBaseList( );
               container.setReferences( references );

         // Get and set the remove flag
               boolean flag = InputReader.GetBoolean( "Remove Invalid References( false ):", false );
               container.setRemoveFlag( flag );

         // Get and set the help text
               String help = InputReader.GetString( "Help Text ():", "" );
               container.setHelpText( help );

         // Get and Set the owner
               AccessNameID owner = InputReader.GetAccessNameID( "Owner ():", true );
               container.setOwner( owner );

         // Get and Set change diary
               String diary = InputReader.GetString( "Change Diary ():", "" );
               container.setDiary( diary );

         // Get and set properties
               PropInfo[] propList = InputReader.GetPropInfoList( );
               container.setProperties( propList );

         // Set the context
               container.setContext( context );

         // Now create the container in the database
               container.create( );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Create Container Results", statusList );

         // release the container instance
               conFact.releaseInstance( container );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }

   }


   void setContainer( )
   {
      try{
         InputReader.PrintHeader( "SET CONTAINER" );

         ContainerFactory conFact = ContainerFactory.getFactory( );

         // Create a container instance
               Container container = ( Container )conFact.newInstance( );

         // Get and Set container key
               String name = InputReader.GetString( "Container Name:", "" );
               ContainerKey key = new ContainerKey( name );

         // Get and Set the container new name
               if( InputReader.GetBoolean( "Change container name? (F): ", false ) )
               {
                  NameID newName = InputReader.GetNameID( "    New Name ():" );
                  container.setName( newName );
               }

         // Get and Set new permission list
               if( InputReader.GetBoolean( "Change group( permission ) list? (F): ", false ) )
               {
                  PermissionInfo[] permissionList = InputReader.GetPermissionInfoList( true );
                  container.setPermissions( permissionList );
               }

         // Get and Set sub admin groups allowed to access this container
               if( InputReader.GetBoolean( "Change sub admin group list? (F): ", false ) )
               {
                  InternalID[] adminList = InputReader.GetInternalIDList( );
                  container.setAdminGroupList( adminList );
               }

         // Get and Set new container owner
               if( InputReader.GetBoolean( "Change container owner object? (F): ", false ) )
               {
                  ContainerOwner[] containerOwnerList = InputReader.GetContainerOwnerList( );
                  container.setContainerOwner( containerOwnerList );
               }

         // Get and Set the new container Label
               if( InputReader.GetBoolean( "Change label? (F): ", false ) )
               {
                  String label = InputReader.GetString( "    Label ():", "" );
                  container.setLabel( label );
               }

         // Get and set the new description
               if( InputReader.GetBoolean( "Change description? (F): ", false ) )
               {
                  String desc = InputReader.GetString( "    Description ():", "" );
                  container.setDescription( desc );
               }

         // Get and Set the new container type
               if( InputReader.GetBoolean( "Change container type? (F): ", false ) )
               {
                  ContainerType type = InputReader.GetContainerType( );
                  container.setType( type );
               }

         // Get and Set the new reference list
               if( InputReader.GetBoolean( "Change reference list? (F): ", false ) )
               {
                  ReferenceBase[] references = InputReader.GetReferenceBaseList( );
                  container.setReferences( references );
               }

         // Get and set the new help text
               if( InputReader.GetBoolean( "Change help text? (F): ", false ) )
               {
                  String help = InputReader.GetString( "    Help Text ():", "" );
                  container.setHelpText( help );
               }

         // Get and set the new owner
               if( InputReader.GetBoolean( "Change owner? (F): ", false ) )
               {
                  AccessNameID owner = InputReader.GetAccessNameID( "    Owner ():" );
                  container.setOwner(  owner );
               }

         // Get and Set addition to change diary
               if( InputReader.GetBoolean( "Add to change diary? (F): ", false ) )
               {
                  String diary = InputReader.GetString( "    Change Diary ():", "" );
                  container.setDiary( diary );
               }

         // Get and set properties
               if( InputReader.GetBoolean( "Change object properties? (F): ", false ) )
               {
                  PropInfo[] propList = InputReader.GetPropInfoList( );
                  container.setProperties( propList );
               }

         // Now update the container properties in the database
               container.store( );

            // Success. Print the status
                StatusInfo[] statusList = context.getLastStatus( );
                OutputWriter.PrintStatusInfoList( "", "Set Container Results", statusList );

         // release the container instance
               conFact.releaseInstance( container );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }

   }

   void deleteContainer( )
   {
      try{
         InputReader.PrintHeader( "DELETE CONTAINER" );

         ContainerFactory conFact = ContainerFactory.getFactory( );

         // Create a new container instance
               Container container = ( Container )conFact.newInstance( );

         // Get and Set the container name
               NameID name = InputReader.GetNameID( "Container Name:", true );
               container.setName( name );

         // Set the context
               container.setContext( context );

         // Now remove the container
               container.remove( );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Delete Container Results", statusList );

         // release the container instance
               conFact.releaseInstance( container );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }

   }


   void getContainer( ){
      try{
         InputReader.PrintHeader( "GET CONTAINER" );

         ContainerFactory conFact=ContainerFactory.getFactory( );

         // Get  container key
               ContainerKey key = InputReader.GetContainerKey( );

         // Set the criteria to retrieve all
               ContainerCriteria criteria = new ContainerCriteria();
               criteria.setRetrieveAll( true );

         // Now get the container
               Container container = conFact.findByKey( context, key, criteria );

         // Now print the container information
               OutputWriter.PrintContainer( "", "Container Information:", container );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void getListContainer( ){
      try{
         InputReader.PrintHeader( "GET LIST CONTAINER" );
         ContainerFactory containerFactory=ContainerFactory.getFactory( );

         // Create a container list criteria object
               Timestamp time = InputReader.GetTimestamp( "Get all changed since ", new Timestamp(0) );
               ContainerListCriteria listCriteria = new ContainerListCriteria();

         // Get and set container types information
               ContainerType[] types = InputReader.GetContainerTypeList( );
               listCriteria.setTypes( types );

         // Get and set attributes flag
               int flag = InputReader.GetInt( "Container attributes( none, hidden ) (0-1) (0):", 0 );
               if( flag == 0 ) // Don't show hidden and visible containers
               {
                  listCriteria.setAttribute( false );
               }
               else // show hidden and visible containers
               {
                  listCriteria.setAttribute( true );
               }

         // Get and set the container owner
               ContainerOwner[] containerOwnerList = InputReader.GetContainerOwnerList( );
               listCriteria.setOwner( containerOwnerList );

         // Create Container Criteria object
               ContainerCriteria containerCriteria = new ContainerCriteria( );

         // Set the flag to retrieve all the information
               containerCriteria.setRetrieveAll( true );

         // Now find all the container objects
             Container[] containers = containerFactory.findObjects( context, listCriteria, containerCriteria );

         // Now print all the information about the containers
             OutputWriter.PrintContainerList( "", "Container List:", containers );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }


   void createView( ){
      try{

         InputReader.PrintHeader( "CREATE VIEW" );

         ViewFactory viewMan = ViewFactory.getFactory( );

         // Create a new view instance
               View view = ( View )viewMan.newInstance( );

         // Set the context
               view.setContext( context );

         // Get and set the schema name
               NameID name = InputReader.GetNameID( "Schema Name ():", true );
               view.setSchemaName(  name  );

         // Get and Set the VUI id
               FieldID id = InputReader.GetVUIID( );
               view.setVUIId( id );

         // Get and set the VUI name
               NameID vuiName = InputReader.GetNameID( "VUI name (): ", true  );
               view.setName(  vuiName  );

         // Get and set the locale
               String locale = InputReader.GetString("Locale (): ", "");
               view.setLocale(locale);

         // Get and set the vui-type
               int vuiType = InputReader.GetInt("Vui-type (0): ", 0);
               view.setVUIType(vuiType);

         // Get and set the properties
               PropInfo[] properties = InputReader.GetPropInfoList( );
               view.setDisplayProperties( properties );

         // Get and set help text
               String helpText = InputReader.GetString( "Help Text:", "" );
               view.setHelpText( helpText );

         // Get and Set owner
               AccessNameID owner = InputReader.GetAccessNameID( "Owner:", true );
               view.setOwner( owner );

         // Get and set the change diary
               String changeDiary = InputReader.GetString( "Change Diary:", "" );
               view.setDiary( changeDiary );

         // Now create the view
               view.create( );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Create View Results", statusList );

         // release the view instance
               viewMan.releaseInstance( view );
      }

      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void deleteView( ){
      try{

         InputReader.PrintHeader( "DELETE VIEW" );

         ViewFactory viewMan = ViewFactory.getFactory( );

         // Create a new view instance
               View view = ( View )viewMan.newInstance( );

         // Set the context
               view.setContext( context );

         // Get and set the schema name
               NameID name = InputReader.GetNameID( "Schema Name ():", true );
               view.setSchemaName( name );

         // Get and Set the VUI id
               FieldID id = InputReader.GetVUIID( );
               view.setVUIId( id );

         // Now delete the view
               view.remove( );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Delete View Results", statusList );

         // release the view instance
               viewMan.releaseInstance( view );
      }

      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void getView( ){
      try{

         InputReader.PrintHeader( "GET VIEW" );

         ViewFactory viewMan = ViewFactory.getFactory( );

         // Get the View Key
               ViewKey key = InputReader.GetViewKey( );

         // Create the View Criteria and the flag to retrieve all the properties
               ViewCriteria criteria = null;
               if( !InputReader.GetBoolean( "Need a null ViewCriteria object? (F): ", false ) )
               {
                  criteria = new ViewCriteria( );
                  criteria.setRetrieveAll( true );
               }

         // Now get the view
               View view = viewMan.findByKey( context, key, criteria );

         // Print the view information
               OutputWriter.PrintView( "", "View Information:", view );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }


   void getListView( ){
      try{
         InputReader.PrintHeader( "GET LIST VIEW" );

         ViewFactory viewMan = ViewFactory.getFactory( );


         // Create the View Criteria and the flag to retrieve all the properties
               ViewCriteria criteria = null;
               if( !InputReader.GetBoolean( "Need a null ViewCriteria object? (F): ", false ) )
               {
                  criteria = new ViewCriteria( );
                  criteria.setRetrieveAll( true );
               }

         // Get the View List Criteria
               ViewListCriteria listCriteria = InputReader.GetViewListCriteria( );

         // Now get the view
               View[] viewsList = viewMan.findObjects( context, listCriteria, criteria );

         // Print the all views information
               OutputWriter.PrintViewList( "", "Views Information:", viewsList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }


   void setView( ){
      try{

         InputReader.PrintHeader( "SET VIEW" );

         ViewFactory viewMan = ViewFactory.getFactory( );

         // Create a new view instance
               View view = ( View )viewMan.newInstance( );

         // Set the context
               view.setContext( context );

         // Get and set the schema name
               NameID name = InputReader.GetNameID( "Schema Name (): ", true );
               view.setSchemaName(  name );

         // Get and Set the VUI id
               FieldID id = InputReader.GetVUIID( );
               view.setVUIId( id );

         // Get and set the VUI name
               if( InputReader.GetBoolean( "Change VUI name? (F): ", false ) )
               {
                  NameID vuiName = InputReader.GetNameID( "VUI name (): " );
                  view.setNewName(  vuiName );
               }

         // Get and set the locale
               if( InputReader.GetBoolean( "Change locale? (F): ", false ) )
               {
                  String locale = InputReader.GetString("Locale: ", "");
                  view.setLocale(locale);
               }

         // Get and set the vui-type
               if( InputReader.GetBoolean( "Change vui-type? (F): ", false ) )
               {
                  int vuiType = InputReader.GetInt("Vui-type: ", 0);
                  view.setVUIType(vuiType);
               }

         // Get and set the properties
               if( InputReader.GetBoolean( "Have new Prop List Info? (F): ", false ) )
               {
                  PropInfo[] properties = InputReader.GetPropInfoList( );
                  view.setDisplayProperties( properties );
               }

         // Get and set help text
               if( InputReader.GetBoolean( "Change Help Text? (F): ", false ) )
               {
                  String helpText = InputReader.GetString( "Help Text:", "" );
                  view.setHelpText( helpText );
               }

         // Get and Set owner
               if( InputReader.GetBoolean( "Change Owner? (F): ", false ) )
               {
                  AccessNameID owner = InputReader.GetAccessNameID( "Owner (): "  );
                  view.setOwner( owner );
               }

         // Get and set the change diary
               if( InputReader.GetBoolean( "Add to Change Diary? (F): ", false ) )
               {
                  String changeDiary = InputReader.GetString( "Change Diary (): ", "" );
                  view.setDiary( changeDiary );
               }

         // Now store the new view properties
               view.store( );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set View Results", statusList );

         // release the view instance
               viewMan.releaseInstance( view );
      }

      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }


   void createActiveLink( )
   {
      try{
         InputReader.PrintHeader( "CREATE ACTIVE LINK" );

         ActiveLinkFactory activeLinkFactory = ActiveLinkFactory.getFactory( );

         // Create a new activelink instance
               ActiveLink activeLink = ( ActiveLink )activeLinkFactory.newInstance( );

         // Get and Set the activelink name
               NameID name = InputReader.GetNameID( "Active link Name:", true );
               activeLink.setName( name );

         // Get and Set the Execution order
               long order = InputReader.GetLong( "Execution order (1-1000) (1):", 1 );
               activeLink.setOrder( order );

         // Get and Set Workflow information
               WorkflowConnectInfo workFlowInfo = InputReader.GetWorkflowConnectInfo( );
               activeLink.setWorkflowConnect( workFlowInfo );

         // Get and set ids ofgroups allowed to perform the active link
               InputReader.PrintHeader( "Ids of groups allowed to perform active link:" );
               InternalID[] idList = InputReader.GetInternalIDList( );
               activeLink.setGroupList( idList );

         // Get and Set the Execution mask
               long executeMask = InputReader.GetLong( "Execution bit mask (1):", 1 );
               activeLink.setExecuteMask( executeMask );

         // Get and Set the Control field
               long controlField = InputReader.GetLong( "Control Field to tie active link to (0):", 0 );
               activeLink.setControlField( controlField );

         // Get and Set the focus field
               long focusField = InputReader.GetLong( "Focus Field to tie active link to (0):", 0 );
               activeLink.setFocusField( focusField );

         // Get and Set the enable flag
               long enable = InputReader.GetLong( "Disable/Enable (0-1) (1):", 1 );
               activeLink.setEnable( enable );

         // Get and Set the QualifierInfo
               QualifierInfo qualifier = InputReader.GetQualifierInfo( );
               activeLink.setQualifier( qualifier );

         // Get and Set the action information
               ActiveLinkActionInfo[] actionList = InputReader.GetActiveLinkActionInfoList( true );
               activeLink.setActionList( actionList );

         // Get and Set the else action list
               ActiveLinkActionInfo[] elseActionList = InputReader.GetActiveLinkActionInfoList( false );
               activeLink.setElseList( elseActionList );

         // Get and set the help text
               String helpText = InputReader.GetString( "Help Text ():", "" );
               activeLink.setHelpText( helpText );

         // Get and Set the owner
               AccessNameID owner = InputReader.GetAccessNameID( "Owner ():", true );
               activeLink.setOwner( owner );

         // Get and Set change diary
               String diary = InputReader.GetString( "Change Diary ():", "" );
               activeLink.setDiary( diary );

         // Get and set properties
               PropInfo[] propList = InputReader.GetPropInfoList( );
               activeLink.setObjPropList( propList );

         // Set the context
               activeLink.setContext( context );

         // Now create the activelink in the database
               activeLink.create( );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Create ActiveLink Results", statusList );

         // release the activelink instance
               activeLinkFactory.releaseInstance( activeLink );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }

   }

   void deleteActiveLink( ){
      try{

         InputReader.PrintHeader( "DELETE ACTIVELINK" );

         ActiveLinkFactory activeLinkFactory = ActiveLinkFactory.getFactory( );

         // Create a new activelink instance
               ActiveLink activeLink = ( ActiveLink )activeLinkFactory.newInstance( );

         // Set the context
               activeLink.setContext( context );

         // Get and set the activelink name  to be deleted
               NameID name = InputReader.GetNameID( "Active link name:", true );
               activeLink.setName( name );

         // Now delete the active link
               activeLink.remove( );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Delete Active Link Results", statusList );


         // release the view instance
               activeLinkFactory.releaseInstance( activeLink );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void getActiveLink( ){
      try{

         InputReader.PrintHeader( "GET ACTIVELINK" );

         ActiveLinkFactory activeLinkFactory = ActiveLinkFactory.getFactory( );

         // Get the Active link key
         ActiveLinkKey key = InputReader.GetActiveLinkKey( );

         // Create an Active link criteria and set the flag to retrieve all the properties
         ActiveLinkCriteria criteria = new ActiveLinkCriteria( );
         criteria.setRetrieveAll( true );

         // Now get the active link
         ActiveLink activeLink = activeLinkFactory.findByKey( context, key, criteria );

         // Print the active link information
         OutputWriter.PrintActiveLink( "", "Active Link:", activeLink );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void getListActiveLink( ){
      try{

         InputReader.PrintHeader( "GET ACTIVELINK LIST" );

         ActiveLinkFactory activeLinkFactory = ActiveLinkFactory.getFactory( );

         // Create an Active link criteria and set the flag to retrieve all the properties
         ActiveLinkCriteria criteria = null;
         if( InputReader.GetBoolean( "Null ActiveLinkCriteria? (F): ", false ) == false )
         {
            criteria = new ActiveLinkCriteria( );
            criteria.setRetrieveAll( true );
         }

         // Now create the workflow Object list criteria
         WorkflowObjectListCriteria listCriteria = InputReader.GetWorkflowObjectListCriteria(false);

         // Now get the active links list
         if (criteria != null)
         {
            ActiveLink[] activeLinkList = activeLinkFactory.findObjects( context, listCriteria, criteria );

            // Print the active link information
            OutputWriter.PrintActiveLinkList( "", "Active Link List:", activeLinkList );
         }
         else
         {
	    NameID[] names= activeLinkFactory.find(context, listCriteria);
	    OutputWriter.PrintNameIDList("", "Active Link Name List", names);
	 }

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void getMultipleActiveLink( ){
      try{

         InputReader.PrintHeader( "GET MULTIPLE ACTIVELINK LIST" );

         ActiveLinkFactory activeLinkFactory = ActiveLinkFactory.getFactory( );

         // Create an Active link criteria and set the flag to retrieve all the properties
         ActiveLinkCriteria criteria = new ActiveLinkCriteria( );
         criteria.setRetrieveAll( true );

         // Now create the workflow Object list criteria. True for retrive by name.
         WorkflowObjectListCriteria listCriteria = InputReader.GetWorkflowObjectListCriteria(true);

         // Now get the active links list
         ActiveLink[] activeLinkList = activeLinkFactory.findObjects( context, listCriteria, criteria );

         // Print the active link information
         OutputWriter.PrintActiveLinkList( "", "Multiple Active Link List:", activeLinkList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void setActiveLink( )
   {
      try{
         InputReader.PrintHeader( "CREATE ACTIVE LINK" );

         ActiveLinkFactory activeLinkFactory = ActiveLinkFactory.getFactory( );

         // Create a new activelink instance
               ActiveLink activeLink = ( ActiveLink )activeLinkFactory.newInstance( );

            // Get and Set the activelink name
               NameID name = InputReader.GetNameID( "Active link Name:", true  );
               activeLink.setName( name  );

         // Get and Set the activelink new name
               if( InputReader.GetBoolean( "Change active link name? (F): ", false ) )
               {
                  NameID newName = InputReader.GetNameID( "New Name:", true );
                  activeLink.setNewName( newName );
               }

         // Get and Set the Execution order
               if( InputReader.GetBoolean( "Change execution order? (F): ", false ) )
               {
                  long order = InputReader.GetLong( "Execution order (1-1000) (1):", 1 );
                  activeLink.setOrder( order );
               }

         // Get and Set Workflow information
               if( InputReader.GetBoolean( "Change Work Flow information? (F): ", false ) )
               {
                  int type = InputReader.GetInt( "Workflow Type (1):", 1 );
                  NameID[] schemas = null;
                  if( InputReader.GetBoolean( "Change schemaList? (F): ", false ) )
                  {
                     int  numberOfSchemas = InputReader.GetInt( "Number of schemas (1):", 1 );
                     if( numberOfSchemas != 0 )
                     {
                           schemas = new NameID[ numberOfSchemas ];
                           for( int i = 0; i < numberOfSchemas; i++ )
                           {
                              schemas[ i] = InputReader.GetNameID( "Schema Name " + i + " :", true );
                           }
                     }
                  }
                  WorkflowConnectInfo workflow = new WorkflowConnectInfo( );

                  workflow.setType( type );
                  workflow.setSchemaList( schemas );

                  activeLink.setWorkflowConnect( workflow );
               }

         // Get and set ids ofgroups allowed to perform the active link
               if( InputReader.GetBoolean( "Change group List? (F): ", false ) )
               {
                  OutputWriter.PrintString( "Ids of groups allowed to perform active link:\n" );
                  InternalID[] idList = InputReader.GetInternalIDList( );
                  activeLink.setGroupList( idList );
               }

         // Get and Set the Execution mask
               if( InputReader.GetBoolean( "Change execute mask? (F): ", false ) )
               {
                  long executeMask = InputReader.GetLong( "Execution bit mask (1):", 1 );
                  activeLink.setExecuteMask( executeMask );
               }

         // Get and Set the Control field
               if( InputReader.GetBoolean( "Change control field? (F): ", false ) )
               {
                  long controlField = InputReader.GetLong( "Control Field to tie active link to (0):", 0 );
                  activeLink.setControlField( controlField );
               }

         // Get and Set the focus field
               if( InputReader.GetBoolean( "Change focus field? (F): ", false ) )
               {
                  long focusField = InputReader.GetLong( "Focus Field to tie active link to (0):", 0 );
                  activeLink.setFocusField( focusField );
               }

         // Get and Set the enable flag
               if( InputReader.GetBoolean( "Change enable/disable? (F): ", false ) )
               {
                  long enable = InputReader.GetLong( "Disable/Enable (0-1) (1):", 1 );
                  activeLink.setEnable( enable );
               }

         // Get and Set the QualifierInfo
               if( InputReader.GetBoolean( "Change query? (F): ", false ) )
               {
                  QualifierInfo qualifier = InputReader.GetQualifierInfo( );
                  activeLink.setQualifier( qualifier );
               }

         // Get and Set the action information
               if( InputReader.GetBoolean( "Change actions? (F): ", false ) )
               {
                  ActiveLinkActionInfo[] actionList = InputReader.GetActiveLinkActionInfoList( true );
                  activeLink.setActionList( actionList );
               }

         // Get and Set the else action list
               if( InputReader.GetBoolean( "Change actions? (F): ", false ) )
               {
                  ActiveLinkActionInfo[] elseActionList = InputReader.GetActiveLinkActionInfoList( false );
                  activeLink.setElseList( elseActionList );
               }

         // Get and set the help text
               if( InputReader.GetBoolean( "Change help text? (F): ", false ) )
               {
                  String helpText = InputReader.GetString( "Help Text ():", "" );
                  activeLink.setHelpText( helpText );
               }

         // Get and Set the owner
               if( InputReader.GetBoolean( "Change owner? (F): ", false ) )
               {
                  AccessNameID owner = InputReader.GetAccessNameID( "Owner () : " );
                  activeLink.setOwner( owner );
               }

         // Get and Set change diary
               if( InputReader.GetBoolean( "Add to change diary? (F): ", false ) )
               {
                  String diary = InputReader.GetString( "Change Diary ():", "" );
                  activeLink.setDiary( diary );
               }

         // Get and set properties
               if( InputReader.GetBoolean( "Change object properties? (F): ", false ) )
               {
                  PropInfo[] propList = InputReader.GetPropInfoList( );
                  activeLink.setObjPropList( propList );
               }

         // Set the context
               activeLink.setContext( context );

         // Now store the new properties in the database
               activeLink.store( );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set ActiveLink Results", statusList );

         // release the container instance
               activeLinkFactory.releaseInstance( activeLink );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }



   void createFilter( )
   {
      try{
         InputReader.PrintHeader( "CREATE FILTER" );

         FilterFactory filterFactory = FilterFactory.getFactory( );

         // Create a new filter instance
               Filter filter = ( Filter )filterFactory.newInstance( );

         // Get and Set the filter name
               NameID name = InputReader.GetNameID( "Filter Name:", true  );
               filter.setName( name );

         // Get and Set the  order
               long order = InputReader.GetLong( "Filter order (1-1000) (500):", 500 );
               filter.setOrder( order );

         // Get and Set Workflow information
               WorkflowConnectInfo workFlowInfo = InputReader.GetWorkflowConnectInfo( );
               filter.setWorkflowConnect( workFlowInfo );

         // Get and Set the operations bit mask
               long bitMask = InputReader.GetLong( "Operation bit mask (1):", 1 );
               filter.setOpSet( bitMask );

         // Get and Set the enable flag
               long enable = InputReader.GetLong( "Disable/Enable (0-1) (1):", 1 );
               filter.setEnable( enable );

         // Get and Set the QualifierInfo
               QualifierInfo qualifier = InputReader.GetQualifierInfo( );
               filter.setQualifier( qualifier );

         // Get and Set the action information
               FilterActionInfo[] actionList = InputReader.GetFilterActionInfoList( true );
               filter.setActionList( actionList );

         // Get and Set the else action list
               FilterActionInfo[] elseActionList = InputReader.GetFilterActionInfoList( false );
               filter.setElseList( elseActionList );

         // Get and set the help text
               String helpText = InputReader.GetString( "Help Text ():", "" );
               filter.setHelpText( helpText );

         // Get and Set the owner
               AccessNameID owner = InputReader.GetAccessNameID( "Owner ():", true );
               filter.setOwner( owner );

         // Get and Set change diary
               String diary = InputReader.GetString( "Change Diary ():", "" );
               filter.setDiary( diary );

         // Get and set properties
               PropInfo[] propList = InputReader.GetPropInfoList( );
               filter.setObjPropList( propList );

         // Set the context
               filter.setContext( context );

         // Now create the filter in the database
               filter.create( );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Create Filter Results", statusList );

         // release the filter instance
               filterFactory.releaseInstance( filter );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void deleteFilter( ){
      try{

         InputReader.PrintHeader( "DELETE FILTER" );

         FilterFactory filterFactory = FilterFactory.getFactory( );

         // Create a new filter instance
               Filter filter = ( Filter )filterFactory.newInstance( );

         // Set the context
               filter.setContext( context );

         // Get and set the filter name  to be deleted
               NameID name = InputReader.GetNameID( "Filter name:", true );
               filter.setName( name );

         // Now delete the Filter
               filter.remove( );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Delete Filter Results", statusList );

         // release the view instance
               filterFactory.releaseInstance( filter );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }



   void getFilter( ){
      try{

         InputReader.PrintHeader( "GET FILTER" );

         FilterFactory filterFactory = FilterFactory.getFactory( );

         // Get the Filter key
               FilterKey key = InputReader.GetFilterKey( );

         // Create  Filter criteria object and set the flag to retrieve all the properties
               FilterCriteria criteria = null;
               if( InputReader.GetBoolean( "Need a Null FilterCriteria? (F): ", false ) == false )
               {
                  criteria = new FilterCriteria( );
                  criteria.setRetrieveAll( true );
               }

         // Now get the filter
               Filter filter = filterFactory.findByKey( context, key, criteria );

         // Print the Filter information
               OutputWriter.PrintFilter( "", "Filter:", filter );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void getListFilter( ){
      try{

         InputReader.PrintHeader( "GET FILTER LIST" );

         FilterFactory filterFactory = FilterFactory.getFactory( );

         // Create  Filter criteria object and set the flag to retrieve all the properties
         FilterCriteria criteria = null;
         if( InputReader.GetBoolean( "Need a Null FilterCriteria? (F): ", false ) == false )
         {
            criteria = new FilterCriteria( );
            criteria.setRetrieveAll( true );
         }

         // Now create the workflow Object list criteria
         WorkflowObjectListCriteria listCriteria = InputReader.GetWorkflowObjectListCriteria(false);

         // Now get the Filters list
         Filter[] filterList = filterFactory.findObjects( context, listCriteria, criteria );

         // Print the Filter information
         OutputWriter.PrintFilterList( "", "Filter List:", filterList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }


   void setFilter( )
   {
      try{
         InputReader.PrintHeader( "SET FILTER" );

         FilterFactory filterFactory = FilterFactory.getFactory( );

         // Create a new filter instance
               Filter filter = ( Filter )filterFactory.newInstance( );

         // Get and Set the filter name
               NameID name = InputReader.GetNameID( "Filter Name:", true  );
               filter.setName( name );

         // Get and Set the filter new name
               if( InputReader.GetBoolean( "Change filter name? (F): ", false ) )
               {
                  NameID newName = InputReader.GetNameID( "New Name (): " );
                  filter.setNewName( newName );
               }

         // Get and Set the  order
               if( InputReader.GetBoolean( "Change filter order? (F): ", false ) )
               {
                  long order = InputReader.GetLong( "Filter order (1-1000) (500):", 500 );
                  filter.setOrder( order );
               }

         // Get and Set Workflow information
               if( InputReader.GetBoolean( "Change Work Flow information? (F): ", false ) )
               {
                  int type = InputReader.GetInt( "Workflow Type (1):", 1 );
                  NameID[] schemas = null;
                  if( InputReader.GetBoolean( "Change schemaList? (F): ", false ) )
                  {
                     int  numberOfSchemas = InputReader.GetInt( "Number of schemas (1):", 1 );
                     if( numberOfSchemas != 0 )
                     {
                           schemas = new NameID[ numberOfSchemas ];
                           for( int i = 0; i < numberOfSchemas; i++ )
                           {
                              schemas[ i] = InputReader.GetNameID( "Schema Name " + i + " :", true );
                           }
                     }
                  }
                  WorkflowConnectInfo workflow = new WorkflowConnectInfo( );

                  workflow.setType( type );
                  workflow.setSchemaList( schemas );

                  filter.setWorkflowConnect( workflow );
               }

         // Get and Set the operations bit mask
               if( InputReader.GetBoolean( "Change operations mask? (F): ", false ) )
               {
                  long bitMask = InputReader.GetLong( "Operation bit mask (1):", 1 );
                  filter.setOpSet( bitMask );
               }

         // Get and Set the enable flag
               if( InputReader.GetBoolean( "Change enable/disable? (F): ", false ) )
               {
                  long enable = InputReader.GetLong( "Disable/Enable (0-1) (1):", 1 );
                  filter.setEnable( enable );
               }

         // Get and Set the QualifierInfo
               if( InputReader.GetBoolean( "Query? (F): ", false ) )
               {
                  QualifierInfo qualifier = InputReader.GetQualifierInfo( );
                  filter.setQualifier( qualifier );
               }

         // Get and Set the action information
               if( InputReader.GetBoolean( "Change action(s)? (F): ", false ) )
               {
                  FilterActionInfo[] actionList = InputReader.GetFilterActionInfoList( true );
                  filter.setActionList( actionList );
               }

         // Get and Set the else action list
               if( InputReader.GetBoolean( "Change else(s)? (F): ", false ) )
               {
                  FilterActionInfo[] elseActionList = InputReader.GetFilterActionInfoList( false );
                  filter.setElseList( elseActionList );
               }

         // Get and set the help text
               if( InputReader.GetBoolean( "Change help text? (F): ", false ) )
               {
                  String helpText = InputReader.GetString( "Help Text ():", "" );
                  filter.setHelpText( helpText );
               }

         // Get and Set the owner
               if( InputReader.GetBoolean( "Change owner? (F): ", false ) )
               {
                  AccessNameID owner = InputReader.GetAccessNameID( "Owner (): " );
                  filter.setOwner(  owner );
               }

         // Get and Set change diary
               if( InputReader.GetBoolean( "Add to Change Diary? (F): ", false ) )
               {
                  String diary = InputReader.GetString( "Change Diary (): ", "" );
                  filter.setDiary( diary );
               }

         // Get and set properties
               if( InputReader.GetBoolean( "Change object properties? (F): ", false ) )
               {
                  PropInfo[] propList = InputReader.GetPropInfoList( );
                  filter.setObjPropList( propList );
               }

         // Set the context
               filter.setContext( context );

         // Now create the filter in the database
               filter.store( );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set Filter Results", statusList );

         // release the filter instance
               filterFactory.releaseInstance( filter );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }



   void createEscalation( )
   {
      try{
         InputReader.PrintHeader( "CREATE ESCALATION" );

         EscalationFactory escalationFactory = EscalationFactory.getFactory( );

         // Create a new escalation instance
               Escalation escalation = ( Escalation )escalationFactory.newInstance( );

         // Get and Set the escalation name
               NameID name = InputReader.GetNameID( "Escalation Name:", true );
               escalation.setName( name );

         // Get and Set the  Time information
               EscalationTmInfo timeInfo = InputReader.GetEsclationTmInfo( );
               escalation.setEscalationTm( timeInfo );

         // Get and Set Workflow information
               WorkflowConnectInfo workFlowInfo = InputReader.GetWorkflowConnectInfo( );
               escalation.setWorkflowConnect( workFlowInfo );

         // Get and Set the enable flag
               long enable = InputReader.GetLong( "Disable/Enable (0-1) (1):", 1 );
               escalation.setEnable( enable );

         // Get and Set the QualifierInfo
               QualifierInfo qualifier = InputReader.GetQualifierInfo( );
               escalation.setQualifier( qualifier );

         // Get and Set the action information
               FilterActionInfo[] actionList = InputReader.GetFilterActionInfoList( true );
               escalation.setActionList( actionList );

         // Get and Set the else action list
               FilterActionInfo[] elseActionList = InputReader.GetFilterActionInfoList( false );
               escalation.setElseList( elseActionList );

         // Get and set the help text
               String helpText = InputReader.GetString( "Help Text ():", "" );
               escalation.setHelpText( helpText );

         // Get and Set the owner
               AccessNameID owner = InputReader.GetAccessNameID( "Owner (): ", true  );
               escalation.setOwner( owner );

         // Get and Set change diary
               String diary = InputReader.GetString( "Change Diary (): ", "" );
               escalation.setDiary( diary );

         // Get and set properties
               PropInfo[] propList = InputReader.GetPropInfoList( );
               escalation.setObjPropList( propList );

         // Set the context
               escalation.setContext( context );

         // Now create the escalation in the database
               escalation.create( );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Create Escalation Results", statusList );

         // release the escalation instance
               escalationFactory.releaseInstance( escalation );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }



   void deleteEscalation( )
   {
      try{
         InputReader.PrintHeader( "DELETE ESCALATION" );

         EscalationFactory escalationFactory = EscalationFactory.getFactory( );

         // Create a new escalation instance
               Escalation escalation = ( Escalation )escalationFactory.newInstance( );

         // Get and Set the escalation name
               NameID name = InputReader.GetNameID( "Escalation Name:", true );
               escalation.setName( name );

         // Set the context
               escalation.setContext( context );

         // Now delete the escalation from the database
               escalation.remove( );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Delete Escalation Results", statusList );

         // release the escalation instance
               escalationFactory.releaseInstance( escalation );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void getEscalation( )
   {
      try{
         InputReader.PrintHeader( "GET ESCALATION" );

         EscalationFactory escalationFactory = EscalationFactory.getFactory( );

         // Create a  escalation Key
               EscalationKey key = InputReader.GetEscalationKey( );

         // Create a Escalation Criteria object set the flag to retrieve all the properties
               EscalationCriteria criteria = null;
               if( InputReader.GetBoolean( "null EscationCriteria? (F): ", false ) == false )
               {
                  criteria = new EscalationCriteria( );
                  criteria.setRetrieveAll( true );
               }

         // Get the escalation now
               Escalation escalation = escalationFactory.findByKey( context, key, criteria );

         // print the esclation data
               OutputWriter.PrintEscalation( "", "Esclation Data:", escalation );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }


   void getListEscalation( )
   {
      try{
         InputReader.PrintHeader( "GET LIST ESCALATION" );

         EscalationFactory escalationFactory = EscalationFactory.getFactory( );

         // Create a Escalation Criteria object set the flag to retrieve all the properties
         EscalationCriteria criteria = null;
         if( InputReader.GetBoolean( "null EscationCriteria? (F): ", false ) == false )
         {
            criteria = new EscalationCriteria( );
            criteria.setRetrieveAll( true );
         }

         // Create a WorkflowObjectList Criteria object
         WorkflowObjectListCriteria listCriteria = InputReader.GetWorkflowObjectListCriteria(false);

         // Get the escalations now
         Escalation[] escalationList = escalationFactory.findObjects( context, listCriteria, criteria );

         // print the esclation data
         OutputWriter.PrintEscalationList( "", "Esclation Data:", escalationList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }



   void setEscalation( )
   {
      try{
         InputReader.PrintHeader( "SET Escalation" );

         EscalationFactory escalationFactory = EscalationFactory.getFactory( );

         // Create a new escalation instance
               Escalation escalation = ( Escalation )escalationFactory.newInstance( );

         // Get and Set the escalation name
               NameID name = InputReader.GetNameID( "Escalation Name:", true );
               escalation.setName( name );

         // Get and Set the escalation new name
               if( InputReader.GetBoolean( "Change escalation name? (F): ", false ) )
               {
                  NameID newName = InputReader.GetNameID( "New Name (): " );
                  escalation.setNewName(  newName );
               }

         // Get and Set the  order
               if( InputReader.GetBoolean( "Change escalation Time? (F): ", false ) )
               {
                  EscalationTmInfo timeInfo = InputReader.GetEsclationTmInfo( );
                  escalation.setEscalationTm( timeInfo );
               }

         // Get and Set Workflow information
               if( InputReader.GetBoolean( "Change Work Flow information? (F): ", false ) )
               {
                  int type = InputReader.GetInt( "Workflow Type (1):", 1 );
                  NameID[] schemas = null;
                  if( InputReader.GetBoolean( "Change schemaList? (F): ", false ) )
                  {
                     int  numberOfSchemas = InputReader.GetInt( "Number of schemas (1):", 1 );
                     if( numberOfSchemas != 0 )
                     {
                           schemas = new NameID[ numberOfSchemas ];
                           for( int i = 0; i < numberOfSchemas; i++ )
                           {
                              schemas[ i] = InputReader.GetNameID( "Schema Name " + i + " :", true );
                           }
                     }
                  }
                  WorkflowConnectInfo workflow = new WorkflowConnectInfo( );

                  workflow.setType( type );
                  workflow.setSchemaList( schemas );

                  escalation.setWorkflowConnect( workflow );
               }


         // Get and Set the enable flag
               if( InputReader.GetBoolean( "Change enable/disable? (F): ", false ) )
               {
                  long enable = InputReader.GetLong( "Disable/Enable (0-1) (1):", 1 );
                  escalation.setEnable( enable );
               }

         // Get and Set the QualifierInfo
               if( InputReader.GetBoolean( "Change Query? (F): ", false ) )
               {
                  QualifierInfo qualifier = InputReader.GetQualifierInfo( );
                  escalation.setQualifier( qualifier );
               }

         // Get and Set the action information
               if( InputReader.GetBoolean( "Change action(s)? (F): ", false ) )
               {
                  FilterActionInfo[] actionList = InputReader.GetFilterActionInfoList( true );
                  escalation.setActionList( actionList );
               }

         // Get and Set the else action list
               if( InputReader.GetBoolean( "Change else(s)? (F): ", false ) )
               {
                  FilterActionInfo[] elseActionList = InputReader.GetFilterActionInfoList( false );
                  escalation.setElseList( elseActionList );
               }

         // Get and set the help text
               if( InputReader.GetBoolean( "Change help text? (F): ", false ) )
               {
                  String helpText = InputReader.GetString( "Help Text (): ", "" );
                  escalation.setHelpText( helpText );
               }

         // Get and Set the owner
               if( InputReader.GetBoolean( "Change owner? (F): ", false ) )
               {
                  AccessNameID owner = InputReader.GetAccessNameID( "Owner (): " );
                  escalation.setOwner(  owner  );
               }

         // Get and Set change diary
               if( InputReader.GetBoolean( "Add to Change Diary? (F): ", false ) )
               {
                  String diary = InputReader.GetString( "Change Diary (): ", "" );
                  escalation.setDiary( diary );
               }

         // Get and set properties
               if( InputReader.GetBoolean( "Change object properties? (F): ", false ) )
               {
                  PropInfo[] propList = InputReader.GetPropInfoList( );
                  escalation.setObjPropList( propList );
               }

         // Set the context
               escalation.setContext( context );

         // Now store the new properties in the database
               escalation.store( );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set Escalation Results", statusList );

         // release the escalation instance
               escalationFactory.releaseInstance( escalation );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }



   void createSupportFile( )
   {
      try{
         InputReader.PrintHeader( "CREATE SUPPORT FILE" );

         SupportFileFactory factory = SupportFileFactory.getFactory( );

         // Create an instance of a Support File
               SupportFile supportFile = ( SupportFile )factory.newInstance( );

         // Get and Set Support File key
               SupportFileKey key = InputReader.GetSupportFileKey( );
               supportFile.setKey( key );

         // Get and set the file name
               String fileName = InputReader.GetString( "File name ():", "" );
               supportFile.setFilePath( fileName );

         // Set the context
               supportFile.setContext( context );

         // Create the support file
               supportFile.create( );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Create SupportFile Results", statusList );

         // Release the instance
               factory.releaseInstance( supportFile );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void deleteSupportFile( )
   {
      try{
         InputReader.PrintHeader( "DELETE SUPPORT FILE" );

         SupportFileFactory factory = SupportFileFactory.getFactory( );

         // Create an instance of a Support File
               SupportFile supportFile = ( SupportFile )factory.newInstance( );

         // Get and Set Support File key
               SupportFileKey key = InputReader.GetSupportFileKey( );
               supportFile.setKey( key );

         // Set the context
               supportFile.setContext( context );

         // delete the support file
               supportFile.remove( );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Delete Support File Results", statusList );

         // Release the instance
               factory.releaseInstance( supportFile );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void getSupportFile( )
   {
      try{
         InputReader.PrintHeader( "GET SUPPORT FILE" );

      SupportFileFactory supportFileMan = SupportFileFactory.getFactory();

      SupportFileKey key = InputReader.GetSupportFileKey( );

      SupportFileCriteria crit = new SupportFileCriteria();
      crit.setRetrieveAll(true);

      SupportFile supportFile = (SupportFile)supportFileMan.findByKey(context, key, crit);

         // print the SupportFile data
               OutputWriter.PrintSupportFile( "", "SupportFile Data:", supportFile );

         // Release the instance
               supportFileMan.releaseInstance( supportFile );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void setSupportFile( )
   {
      try{
         InputReader.PrintHeader( "SET SUPPORT FILE" );

         SupportFileFactory factory = SupportFileFactory.getFactory( );

         // Create an instance of a Support File
               SupportFile supportFile = ( SupportFile )factory.newInstance( );

         // Get and Set Support File key
               SupportFileKey key = InputReader.GetSupportFileKey( );
               supportFile.setKey( key );

         // Get and set the file name
               String fileName = InputReader.GetString( "File name ():", "" );
               supportFile.setFilePath( fileName );

         // Set the context
               supportFile.setContext( context );

         // Create the support file
               supportFile.store( );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set SupportFile Results", statusList );

         // Release the instance
               factory.releaseInstance( supportFile );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void getListSupportFile( )
   {
      try{
         InputReader.PrintHeader( "GET List SUPPORT FILE" );

         SupportFileFactory factory = SupportFileFactory.getFactory( );


         // Get the SupportfileListCriteria
               SupportFileListCriteria  listCriteria = InputReader.GetSupportFileListCriteria( );

         // Get the supportfileCriteria
               SupportFileCriteria  criteria = new SupportFileCriteria();
	       criteria.setRetrieveAll(true);

         // Get the list of support files
               SupportFile[] fileList = factory.findObjects( context, listCriteria, criteria );

         // Now print the support files
               OutputWriter.PrintSupportFileList( "", "Support Files:", fileList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }
   void getListGroup( ){
      try{

         InputReader.PrintHeader( "GET LIST GROUP" );

         AccessNameID user = null;
         AccessNameID password = null;
         if( InputReader.GetBoolean( "For a specific user? (F): ", false ) )
         {
               user = InputReader.GetAccessNameID( "Name of the user (): " );
               password = InputReader.GetAccessNameID( "Password: ", true  );
         }

         // Get the Group list
               GroupInfo[] groupList = Util.ARGetListGroup( context, user, password );

         // Print the group Information
               OutputWriter.PrintGroupInfoList( "", "ARGetListGroup Results:", groupList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }


   void getListUser( ){
      try{

         InputReader.PrintHeader( "GET LIST USER" );

         // Get the type
               int type = InputReader.GetInt( "User List Type (myself, registered or current (0-2)(1): ", 1 );

         // Create a container list criteria object
               Timestamp changedSince = InputReader.GetTimestamp( "Get registered users changed since (0 means all): ", new Timestamp(0) );

         // Get the Users information
               UserInfo[] userList = Util.ARGetListUser( context, type, changedSince );

         // Print the group Information
               OutputWriter.PrintUserInfoList( "", "    ARGetListUser Results:", userList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }


   void getListServer( ){
      try{

         InputReader.PrintHeader( "GET LIST SERVER" );

         // Get the Servers list
               ServerNameID[] serverList = Util.ARGetListServer( context );

         // Print the servers names
               OutputWriter.PrintServerNameIDList( "", "    ARGetListServer Results:", serverList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }


   void getServerInfo( ){
      try{

         InputReader.PrintHeader( "GET SERVER INFO" );

         // Get the request list
               int[] requestList = null;


               int total = InputReader.GetInt( "Number of server info operations (0): ", 0 );
               if( total > 0 )
               {
                  requestList = new int[total];
                  for( int j = 0; j < total; j++ )
                  {
                     requestList[j] = InputReader.GetInt( "Operation (1-164) (1): ", 1 );
                  }
               }

         // Get the Server information
               ServerInfo[] serverInfoList = Util.ARGetServerInfo( context, requestList );

         // Print the server information
               OutputWriter.PrintServerInfoList( "", "    ARGetServerInfo Results:", serverInfoList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void setServerInfo( ){
      try{

         InputReader.PrintHeader( "SET SERVER INFO" );

         // Get the Server information
               InputReader.PrintHeader( "Server Info List Entry:" );
               ServerInfo[] serverInfoList = InputReader.GetServerInfoList( );

         // Call ARSetServerInfo method
               Util.ARSetServerInfo( context, serverInfoList );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set Server Information Results", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void setServerPort( ){
      try{

         InputReader.PrintHeader( "SET SERVER PORT" );

         // Get the Server information
               String serverName = InputReader.GetString( "Name of server to update: ", "" );

         // Get the port number
               int portNumber = InputReader.GetInt( "The port number of server (0):", 0 );

         // Get the rpc number
               int progNumber = InputReader.GetInt( "The RPC program number of Server (0):", 0 );

         // Call ARSetServerPort method
               Util.ARSetServerPort( context, new NameID( serverName ), portNumber, progNumber );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set Server Port Results", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }
   void export( ){
      try{

         // Get the items
         StructItemInfo[] items = InputReader.GetStructItemInfoList( );

         NameID displayTag = null;
         int vuiType = 0;
         for (int i=0; i < items.length; i++)
         {
            if (items[i].getType() == StructItemInfo.SCHEMA_VIEW || items[i].getType() == StructItemInfo.VUI_2)
            {
                displayTag = InputReader.GetNameID("Display Tag: ", true);
                vuiType = InputReader.GetInt("Vui Type (0): ", 0);
                break;
            }
         }

         // Get the file name, make 3 attempts and return if no file is given.
         String fileName = null;
         for (int i=0; i < 3 && fileName == null; i++)
         {
            fileName = InputReader.GetString( "Filename for exported data: ", "" );
         }
         if (fileName == null)
            return;

         // Call the ARExport method
         String definitionText = Util.ARExport( context, items, displayTag, vuiType );

         // Save the information
         if( definitionText != null )
         {
            File file = new File(fileName);
            PrintWriter out = new PrintWriter(new FileWriter(file) );
            out.print(definitionText);
            out.close();
         }
         else
         {
            OutputWriter.PrintString( "Return Value: < null > \n" );
         }

         OutputWriter.PrintStatusInfoList( "", "Status", context.getLastStatus());
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void ARImport( ){
      try{

         InputReader.PrintHeader( "ARImport RESULTS" );

         // Get the items
               StructItemInfo[] items = InputReader.GetStructItemInfoList( );

         // Get the Servers list
               String fileName = null;
               FileReader fileReader = null;
               for (int i=0; i < 3; i++)
               {
                  fileName = InputReader.GetString( "Filename containing import data: ", "" );
                  if (fileName == null)
                  {
                     OutputWriter.PrintString( "Input file not found\n" );
                     continue;
                  }
                  try
                  {
                     fileReader = new FileReader(fileName);
                     break;
                  }
                  catch (FileNotFoundException e)
                  {
                     OutputWriter.PrintString( "Input file not found\n" );
                     fileName = null;
                  }
               }
               if (fileName == null)
                  return;

               String importDefn = new String();
               StringBuffer stringBuffer = new StringBuffer();
               char   readBuffer[] = new char[1024];
               while (fileReader.read(readBuffer, 0, readBuffer.length) >= 0)
                  stringBuffer.append(readBuffer);

               importDefn = stringBuffer.toString();


         // Get the import option
               int importOption = InputReader.GetInt( "The import option (0): ", 0 );

         // Call the ARImport method
               Util.ARImport( context, items, importOption, importDefn );

         // Success. Print the status
             OutputWriter.PrintStatusInfoList("", "Status", context.getLastStatus());

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void getServerStatistics( ){
      try{

         InputReader.PrintHeader( "GET SERVER STATISTICS" );

         // Get the number of serverInfo operations
         int numberOfOperations = InputReader.GetInt( "Number Of server info Operations (0):", 0 );

         // Get the operations
         int[] requestList = null;
         requestList = new int[ numberOfOperations ];

         for( int i = 0; i < numberOfOperations; i++ )
         {
            requestList[i] = InputReader.GetInt( "Operation (1-121):", 1 );
         }

         // Call the ARGetServerStatistics method
         ServerInfo[] serverInfoList = Util.ARGetServerStatistics( context, requestList );

         // Print the information
         OutputWriter.PrintString( "ARGetServerStatistics RESULTS\n" );
         OutputWriter.PrintServerInfoList( "", "", serverInfoList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }


   void executeProcess( ){
      try{

         InputReader.PrintHeader( "EXECUTE PROCESS" );

         // Get the command
               String command = InputReader.GetString( "Command:", "" );

         // Get the flag whether to wait for the process or not
               boolean waitFlag = InputReader.GetBoolean( "Wait For process to complete (F): ", false );

         // Call the ARExecuteProcess Method
               ProcessResult result = Util.ARExecuteProcess( context, command, waitFlag );

         // Print the result
               OutputWriter.PrintProcessResult( "", "ARExecuteProcess RESULTS:", result );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void getFullTextInfo( ){
      try{

         InputReader.PrintHeader( "GET FULL TEXT INFO" );

         // Get the number of FTS Opeations
               int numberOfOperations = InputReader.GetInt( "Number Of fulltext info types (0)", 0 );

         // Get the operations
               int[] requestList = null;
               if( numberOfOperations != 0 )
               {
                  requestList = new int[ numberOfOperations ];

                  for( int i = 0; i < numberOfOperations; i++ )
                  {
                     requestList[i] = InputReader.GetInt( "InfoType (1-6):", 1 );
                  }
               }

         // Call the ARGetFullTextInfo method
               FullTextInfo[] fullTextInfoList = Util.ARGetFullTextInfo( context, requestList );

         // Print the information
               OutputWriter.PrintFullTextInfoList( "", "ARFullTextInfo RESULTS", fullTextInfoList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }


   void setFullTextInfo( ){
      try{

         InputReader.PrintHeader( "GET FULL TEXT INFO" );

         // Get FullTextInfo List
               FullTextInfo[] fullTextInfoList = InputReader.GetFullTextInfoList( );

         // Call the ARSetFullTextInfo method
               Util.ARSetFullTextInfo( context, fullTextInfoList );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "Set FullTextInfo Results", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }


   void getListSQL( ){
      try{

         InputReader.PrintHeader( "GETLIST SQL" );

         // Get the SQL Command
            String command = InputReader.GetString( "SQL Command:", "" );

         // Get Maximum number of entries to retrieve
            int numberOfEntries = InputReader.GetInt( "Maximum number of entries to retrieve (500):", 500 );

         // Get the flag to return the number of matches
            boolean flag = InputReader.GetBoolean( "Get Number Of Matches? (F): ", false );

         // Call the ARGetListSQL
         //   SQLResult result = Util.ARGetListSQL( context, command, numberOfEntries, flag );

         // Print the result
            //   OutputWriter.PrintSQLResult( "", "ARGetListSQL Results:", result );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
   }


   void getTextForErrorMessage( ){
      try{

         InputReader.PrintHeader( "GET TEXT FOR ERROR MESSAGE" );

         // Get the
            int msgNumber = InputReader.GetInt( "The message identifier for the message (0):", 0 );


         // Call the ARSetFullTextInfo method
            String message = Util.ARGetTextForErrorMessage( context, msgNumber );

         // Print the message
               OutputWriter.PrintString( "", "ARGetTextForErrorMessage Results:", message, "\n" );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }


   void verifyUser( ){
      try{

         InputReader.PrintHeader( "VERIFY USER" );

         // Create a VerifyUserCrteria object
               VerifyUserCriteria criteria = InputReader.GetVerifyUserCriteria( );

         // Now call the verifyUser method
               if( context != null )
               {
                  context.verifyUser( criteria );

                  // Print the information
                     if( context.getAdminFlag( ) )
                     {
                           OutputWriter.PrintString( "", "Admin Flag: ", "TRUE", "\n" );
                     }
                     else
                     {
                           OutputWriter.PrintString( "", "Admin Flag: ", "FALSE", "\n" );
                     }

                     if( context.getSubAdminFlag( ) )
                     {
                           OutputWriter.PrintString( "", "SubAdmin Flag: ", "TRUE", "\n" );
                     }
                     else
                     {
                           OutputWriter.PrintString( "", "SubAdmin Flag: ", "FALSE", "\n" );
                     }

                     if( context.getCustomFlag( ) )
                     {
                           OutputWriter.PrintString( "", "Custom Flag: ", "TRUE", "\n" );
                     }
                     else
                     {
                           OutputWriter.PrintString( "", "Custom Flag: ", "FALSE", "\n" );
                     }
               }
               else
               {
                  OutputWriter.PrintString( "",  "Null Context.  ", "Can't verify user...", "\n" );
               }
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void RegisterForAlerts( ){
      try{

         InputReader.PrintHeader( "Register For Alerts" );

         // Get the
            int clientPort = InputReader.GetInt( "clientPort (0):", 0 );

	    // Get the
            int registrationFlags = InputReader.GetInt( "registrationFlags (0):", 0 );

         // Call ARRegisterForAlerts method
            Util.ARRegisterForAlerts( context, clientPort, registrationFlags );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARRegisterForAlerts Results", statusList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void DeregisterForAlerts( ){
      try{

         InputReader.PrintHeader( "Deregister For Alerts" );

         // Get the
            int clientPort = InputReader.GetInt( "clientPort (0):", 0 );

         // Call ARDeregisterForAlerts method
            Util.ARDeregisterForAlerts( context, clientPort );

         // Success. Print the status
             StatusInfo[] statusList = context.getLastStatus( );
             OutputWriter.PrintStatusInfoList( "", "ARDeregisterForAlerts Results", statusList );

      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }



   void CreateAlertEvent( ){
      try{

         InputReader.PrintHeader( "Create Alert Event" );

         // Get the Server information
            String serverName = InputReader.GetString( "Name of server: ", "" );

         // Get the User information
            AccessNameID user = InputReader.GetAccessNameID( "Name of User:", true );

         // Get the Form information
            NameID formName = InputReader.GetNameID( "Name of Form:", true );

         // Get the alert Text
            String alertText = InputReader.GetString( "Alert Text: ", "" );

         // Get the Object Id
            String objectId = InputReader.GetString( "Object Id: ", "" );


         // Get the alert Priority
            int alertPriority = InputReader.GetInt( "Alert Priority (0):", 0 );

         // Get the alert Source
            NameID alertSource = InputReader.GetNameID( "Alert Source Tag:", true );


	    EntryID entryId = Util.ARCreateAlertEvent( context, user,alertText,
                              alertPriority, alertSource, new ServerNameID( serverName ),
                              formName, objectId );

         // Print the EntryID
            OutputWriter.PrintEntryID( "", "EntryID:", entryId );

      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void GetListAlertUser(){
      try{

         InputReader.PrintHeader( "Get List of Alert Users" );

         // Call ARGetListAlertUser method
         AccessNameID[] users = Util.ARGetListAlertUser( context );

         OutputWriter.PrintAccessNameIDList( "", "users List: ", users );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
            OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
            OutputWriter.PrintARException( e );
      }
   }

   void GetAlertCount(){
      try{

         InputReader.PrintHeader( "Get Number of Alerts" );
         QualifierInfo qal = InputReader.GetQualifierInfo();
         int count = Util.ARGetAlertCount(context, qal);
         OutputWriter.PrintInt( "", "ALert Count = ", count, "\n");
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
            OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
            OutputWriter.PrintARException( e );
      }
   }



   void EncodeQualifier(){
      try
      {
         InputReader.PrintHeader("ENCODE ARQUALIFIER STRUCT TO STRING");
         QualifierInfo qal = InputReader.GetQualifierInfo();

         String qaltxt = Util.AREncodeARQualifierStruct(context, qal);
         if(qaltxt != null)
         {
            OutputWriter.PrintHeader("", "Qualifier Text: ", "\n");
            OutputWriter.PrintString(qaltxt);
         }
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString("Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void DecodeQualifier(){
      try
      {
         InputReader.PrintHeader("DECODE STRING TO ARQUALIFIER STRUCT\n");
         String qaltxt = InputReader.GetString( "Qualifier Text: ", "" );

         QualifierInfo qal = Util.ARDecodeARQualifierStruct(context, qaltxt);
         if(qal != null)
            OutputWriter.PrintQualifierInfo("", "ARDecodeARQualifierStruct: ", qal);
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void EncodeAssign(){
      try {
         InputReader.PrintHeader("ENCODE ARASSIGN STRUCT TO STRING");
         AssignInfo asn = InputReader.GetAssignInfo();

         String asntxt = Util.AREncodeARAssignStruct(context, asn);
         if(asntxt != null)
         {
            OutputWriter.PrintHeader("", "Assign Text: ", "\n");
            OutputWriter.PrintString(asntxt);
         }
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void DecodeAssign(){
      try
      {
         InputReader.PrintHeader("DECODE STRING TO ARASSIGN STRUCT");
         String asntxt = InputReader.GetString( "Assign Text: ", "" );

         AssignInfo asn = Util.ARDecodeARAssignStruct(context, asntxt);
         if(asn != null)
            OutputWriter.PrintAssignInfo("", "ARDecodeARAssignStruct: ", asn);
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void EncodeStatusHistory(){
      try
      {
         InputReader.PrintHeader("ENCODE STATUS HISTORY ARRAY TO STRING");
         StatusHistoryInfo[] statHist = InputReader.GetStatusHistoryInfoList();

         String statHistTxt = Util.AREncodeStatusHistory(context, statHist);
         if(statHistTxt != null)
         {
            OutputWriter.PrintString( "Status History String: " + "\n");
            OutputWriter.PrintString(statHistTxt);
         }
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void EncodeDiary(){
      try
      {
         InputReader.PrintHeader("ENCODE DIARY ARRAY TO STRING\n");
         DiaryInfo[] diary = InputReader.GetDiaryInfoList();

         String diarytxt = Util.AREncodeDiary(context, diary);
         if (diarytxt != null)
         {
            OutputWriter.PrintHeader("", "Diary Text: ", "\n");
            OutputWriter.PrintString(diarytxt);
         }
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void getLocalizedValue()
   {
      try
      {
         InputReader.PrintHeader("GET LOCALIZED VALUE\n");
         LocalizedValueCriteria criteria = InputReader.GetLocalizedValueCriteria();
         LocalizedRequestInfo request = InputReader.GetLocalizedRequest();

         LocalizedValueInfo localizedValue;
         localizedValue = Util.ARGetLocalizedValue(context, criteria, request);

         if (localizedValue != null)
         {
            if (localizedValue.getValue() != null)
                OutputWriter.PrintValue("   ", "Localized Request: ", localizedValue.getValue());

            if (localizedValue.getTimestamp() != null)
                OutputWriter.PrintLong("   ", "Timestamp: ", localizedValue.getTimestamp().getValue(), "\n");
         }
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void getMultipleLocalizedValues()
   {
      try
      {
         InputReader.PrintHeader("GET LOCALIZED VALUES\n");
         LocalizedValueCriteria criteria = InputReader.GetLocalizedValueCriteria();

         int numRequests = InputReader.GetInt("Number of requests (1): ", 1);
         if (numRequests <= 0)
            return;

         LocalizedRequestInfo requests[] = new LocalizedRequestInfo[numRequests];
         for (int i=0; i < numRequests; i++)
            requests[i] = InputReader.GetLocalizedRequest();

         LocalizedValueInfo localizedValues[];
         localizedValues = Util.ARGetMultipleLocalizedValues(context, criteria, requests);

         for (int i=0; i < localizedValues.length; i++)
         {
            if (localizedValues[i].getValue() != null)
                OutputWriter.PrintValue("   ", "Localized Request " + i + ": ", localizedValues[i].getValue());
            if (localizedValues[i].getTimestamp() != null)
                OutputWriter.PrintLong("   ", "Timestamp: ", localizedValues[i].getTimestamp().getValue(), "\n");
         }
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void executeProcessForActiveLink()
   {
      try
      {
         InputReader.PrintHeader("EXECUTE PROCESS FOR ACTIVE LINK\n");

         // Get the Active Link Name
         NameID actlinkName = InputReader.GetNameID( "Name of Active Link: ", true );
	 int actionIndex = InputReader.GetInt("Action Index (0): ", 0);
	 int actionType = InputReader.GetInt("Action Type (0): ", 0);
         InternalID fieldId =  new InternalID(InputReader.GetLong("Field ID (0): ", 0));
	 Timestamp timestamp = InputReader.GetTimestamp("timestamp (0): ", new Timestamp(0));
	 int  numberOfKeywords = InputReader.GetInt( "Number of Keywords (0): ", 0);
	 EntryItem[] keywordsList = null;
         EntryItem[] parametersList = null;

         if( numberOfKeywords != 0 )
         {
            keywordsList = InputReader.GetEntryItemList();
         }

	 int  numberOfParameters = InputReader.GetInt( "Number of Parameters (0): ", 0);
         if (numberOfParameters != 0)
         {
            parametersList = InputReader.GetEntryItemList();
         }
         // Get the flag whether to wait for the process or not
         boolean waitFlag = InputReader.GetBoolean( "Wait For process to complete (F): ", false );

         // Call the ARExecuteProcess Method
         ProcessResult result = Util.ARExecuteProcessForActiveLink( context, actlinkName, actionIndex,
   				       actionType, fieldId, timestamp, keywordsList, parametersList, waitFlag);
         // Print the result
         OutputWriter.PrintProcessResult( "", "ARExecuteProcessForActiveLink RESULTS:", result );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void getListSQLForActiveLink()
   {
      try
      {
         InputReader.PrintHeader("GETLIST SQL FOR ACTIVE LINK\n");
         // Get the Active Link Name
         NameID actlinkName = InputReader.GetNameID( "Name of Active Link: ", true );
	 int actionIndex = InputReader.GetInt("Action Index (0): ", 0);
	 int actionType = InputReader.GetInt("Action Type (0): ", 0);
	 Timestamp timestamp = InputReader.GetTimestamp("Timestamp (0): ", new Timestamp(0));

	 EntryItem[] keywordsList = null;
	 EntryItem[] parametersList = null;

	 int  numberOfKeywords = InputReader.GetInt( "Number of Keywords (0): ", 0);
         if( numberOfKeywords != 0 )
         {
            keywordsList = InputReader.GetEntryItemList();
         }
	 int  numberOfParameters = InputReader.GetInt( "Number of Parameters (0): ", 0);
         if( numberOfParameters != 0 )
         {
            parametersList = InputReader.GetEntryItemList();
         }

 	 int maxRetrieve = InputReader.GetInt("Maximum number of entries to retrieve (500): ", 500);
         // Get the flag whether to get number of matches or not
         boolean retrieveTotalMatches = InputReader.GetBoolean( "Get Number of Matches (F): ", false );

	 SQLResult result = Util.ARGetListSQLForActiveLink(context, actlinkName, actionIndex, actionType,
			      timestamp, keywordsList, parametersList, maxRetrieve, retrieveTotalMatches);

         // Print the result
         OutputWriter.PrintSQLResult( "", "ARGetListSQLForActiveLink Results:", result );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void getListExtSchemaCandidates()
   {
      try
      {
         InputReader.PrintHeader("GET LIST EXTERNAL SCHEMA CANDIDATES\n");
	     int schemaType = InputReader.GetInt("schemaType (0): ", 0);
	     CompoundSchemaInfo[] result = Util.ARGetListExtSchemaCandidates(context, schemaType);
    // Print the result
         OutputWriter.PrintCompoundSchemaInfoList( "", "ARGetListExtSchemaCandidates Results: ", result );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void getMultipleExtFieldCandidates()
   {
      try
      {
         InputReader.PrintHeader("GET MULTIPLE EXTERNAL FIELD CANDIDATES\n");
	     CompoundSchemaInfo comSchema = InputReader.GetCompoundSchemaInfo();

	     ExtFieldCandidatesInfo[] result = Util.ARGetMultipleExtFieldCandidates(context, comSchema);
    // Print the result
         OutputWriter.PrintExtFieldCandidatesInfoList( "", "ARGetListExtSchemaCandidates Results: ", result );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void decodeAlertMessage()
   {
      try
      {
         InputReader.PrintHeader("DECODE ALERT MESSAGE\n");
         AlertMessageCriteria criteria = InputReader.GetAlertMessageCriteria();
	     String message = InputReader.GetString( " Message (): ", "" );
	     int len = message.length();
	     AlertMessageInfo result = Util.ARDecodeAlertMessage(context, criteria, message, len + 1);
    // Print the result
         OutputWriter.PrintAlertMessageInfo( "", "DecodeAlertMessage Results: ", result );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void validateLicense( ){
      try{
                            // print header
        InputReader.PrintHeader( "VALIDATE LICENSE" );

                            // Get the license type
        LicenseNameID licType = InputReader.GetLicenseNameID("License Type: ");

                            // validate the license
        LicenseValidInfo licValidInfo = Util.ARValidateLicense( context, licType );

                            // Print the validate info
        OutputWriter.PrintLicenseValidInfo( "", "    ARValidateLicense Results:", licValidInfo );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void validateMultipleLicenses( ){
      try{
                            // print header
        InputReader.PrintHeader( "VALIDATE MULTIPLE LICENSE" );

                            // Get the license type
        LicenseNameID[] licTypeList = InputReader.GetLicenseNameIDList();

                            // validate the license
        LicenseValidInfo[] licValidList = Util.ARValidateMultipleLicense( context, licTypeList );

                            // Print the license info
        OutputWriter.PrintLicenseValidList( "", "    ARValidateMultipleLicenses Results:", licValidList );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void getListLicense( ){
      try{
                            // print header
        InputReader.PrintHeader( "GET LIST LICENSE" );

                            // Get the license type
        LicenseNameID licType = InputReader.GetLicenseNameID("License Type: ");

                            // validate the license
        LicenseInfo[] licInfo = Util.ARGetListLicense( context, licType );

                            // Print the validate info
        OutputWriter.PrintLicenseInfoList( "", "    ARGetListLicense Results:", licInfo );
      }
      catch( IOException e )
      {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
      }
      catch( NullPointerException e )
      {
         OutputWriter.PrintString( "Null Pointer exception...\n" );
      }
      catch( ARException e )
      {
         OutputWriter.PrintARException( e );
      }
   }

   void getSessionConfiguration()
   {
       try{
         InputReader.PrintHeader("GET SESSION CONFIGURATION");

         int variableId = InputReader.GetInt("Variable Id (0): ", 0);
         Value variableValue = Util.ARGetSessionConfiguration(context, variableId);
         OutputWriter.PrintValue("   ", "Session Variable", variableValue);
       }
       catch (IOException e)
       {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
       }
       catch( ARException e )
       {
         OutputWriter.PrintARException( e );
       }
   }

   void setSessionConfiguration()
   {
       try{
         InputReader.PrintHeader("SET SESSION CONFIGURATION");

         int variableId = InputReader.GetInt("Variable Id (0): ", 0);
         Value variableValue = InputReader.GetValue();
         Util.ARSetSessionConfiguration(context, variableId, variableValue);

         StatusInfo[] statusList = context.getLastStatus( );
         OutputWriter.PrintStatusInfoList( "", "Set Session Results", statusList );
       }
       catch (IOException e)
       {
         OutputWriter.PrintString( "Problem in getting the input...Driver problem..\n" );
       }
       catch( ARException e )
       {
         OutputWriter.PrintARException( e );
       }
   }


   public static void main( String[] args ) {
      try {
         JavaDriver driver = new JavaDriver( );
         driver.GetAndExecuteCommand( );
      }
      catch( IOException e ) {
         OutputWriter.PrintString( "Error in executing the command\n" );
      }
      finally
      {
          InputReader.StopRecordingInput( );
          OutputWriter.StopRecordingOutput( );
          if( context != null )
          {
              context.clear( );
          }
      }
   }
}

