/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.ARServerUser;
import com.remedy.arsys.api.CharMenuInfo;
import com.remedy.arsys.api.CriteriaFlags;
import com.remedy.arsys.api.IARPersistentObject;
import com.remedy.arsys.api.MenuCriteria;
import com.remedy.arsys.api.MenuKey;
import com.remedy.arsys.api.NameID;
import com.remedy.arsys.api.ObjectBase;
import com.remedy.arsys.api.PropInfo;
import com.remedy.arsys.api.Proxy;
import com.remedy.arsys.api.ProxyManager;

public class Menu
extends ObjectBase
implements IARPersistentObject,
Cloneable {
    private ARServerUser m_context;
    private int m_refreshCode;
    private CharMenuInfo m_menu;
    private PropInfo[] m_properties;
    private NameID m_newName;
    private static final int TOTAL_PARAMS = 8;
    private final int NEW_REFRESH_CODE = 5;
    private final int NEW_MENU_DEF = 6;
    private final int NEW_PROPERTIES = 7;

    Menu() {
        this.m_changeFlags = new CriteriaFlags(8);
    }

    Menu(NameID nameID) {
        this.setName(nameID);
        this.m_changeFlags = new CriteriaFlags(8);
    }

    public void activate() {
    }

    public void clear() {
    }

    public Object clone() throws CloneNotSupportedException {
        Menu menu = null;
        menu = (Menu)super.clone();
        menu.m_newName = (NameID)this.m_newName.clone();
        int n = this.m_properties.length;
        menu.m_properties = new PropInfo[n];
        int n2 = 0;
        while (n2 < n) {
            menu.m_properties[n2] = (PropInfo)this.m_properties[n2].clone();
            ++n2;
        }
        return menu;
    }

    public void create() throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        try {
            proxy.ARCreateMenu(this.m_context, this);
            Object var4_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
        this.resetChangeFlags();
    }

    public CharMenuInfo expandMenu() throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        CharMenuInfo charMenuInfo = null;
        try {
            charMenuInfo = proxy.ARExpandMenu(this.m_context, this.m_menu);
            Object var5_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
        return charMenuInfo;
    }

    public MenuKey getKey() {
        return new MenuKey(this.getName());
    }

    public CharMenuInfo getMenuDefinition() {
        return this.m_menu;
    }

    public PropInfo[] getProperties() {
        return this.m_properties;
    }

    public int getRefreshCode() {
        return this.m_refreshCode;
    }

    public void load() throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        MenuCriteria menuCriteria = new MenuCriteria();
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        MenuKey menuKey = new MenuKey(this.getName());
        try {
            proxy.ARGetMenu(this.m_context, menuKey, menuCriteria, this);
            Object var6_6 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
        this.resetChangeFlags();
    }

    public void load(MenuCriteria menuCriteria) throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        MenuKey menuKey = new MenuKey(this.getName());
        try {
            proxy.ARGetMenu(this.m_context, menuKey, menuCriteria, this);
            Object var6_6 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
        this.resetChangeFlags();
    }

    public void passivate() {
    }

    public void remove() throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        try {
            proxy.ARDeleteMenu(this.m_context, this.getName());
            Object var4_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
    }

    public void setContext(ARServerUser aRServerUser) {
        this.m_context = aRServerUser;
    }

    public void setKey(MenuKey menuKey) {
        this.setName(menuKey);
    }

    public void setMenuDefinition(CharMenuInfo charMenuInfo) {
        this.m_menu = charMenuInfo;
        this.m_changeFlags.setParameter(6L, true);
    }

    public void setProperties(PropInfo[] propInfoArray) {
        this.m_properties = propInfoArray;
        this.m_changeFlags.setParameter(7L, true);
    }

    public void setRefreshCode(int n) {
        this.m_refreshCode = n;
        this.m_changeFlags.setParameter(5L, true);
    }

    public void store() throws ARException {
        if (this.m_context == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_context.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_context, bl);
        try {
            proxy.ARSetMenu(this.m_context, this, this.m_changeFlags.getParameters());
            Object var4_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_context, bl);
            throw throwable;
        }
        this.resetChangeFlags();
    }

    public void unsetContext() {
        this.m_context = null;
    }
}

