/*
 * Decompiled with CFR 0.152.
 */
package com.remedy.arsys.api;

import com.remedy.arsys.api.ARException;
import com.remedy.arsys.api.ARServerUser;
import com.remedy.arsys.api.ContainerCriteria;
import com.remedy.arsys.api.ContainerKey;
import com.remedy.arsys.api.ContainerOwner;
import com.remedy.arsys.api.ContainerType;
import com.remedy.arsys.api.CriteriaFlags;
import com.remedy.arsys.api.IARPersistentObject;
import com.remedy.arsys.api.InternalID;
import com.remedy.arsys.api.NameID;
import com.remedy.arsys.api.ObjectBase;
import com.remedy.arsys.api.PropInfo;
import com.remedy.arsys.api.Proxy;
import com.remedy.arsys.api.ProxyManager;
import com.remedy.arsys.api.ReferenceBase;
import com.remedy.arsys.api.StringHelper;

public class Container
extends ObjectBase
implements IARPersistentObject,
Cloneable {
    private ARServerUser m_session;
    private InternalID[] m_adminGrpList;
    private char[] m_label;
    private char[] m_description;
    private ContainerType m_type;
    private ReferenceBase[] m_references;
    private ContainerOwner[] m_containerOwner;
    private PropInfo[] m_props;
    private boolean m_removeFlag;
    private NameID m_newName;
    private static final int TOTAL_PARAMS = 5;

    Container() {
        this.m_changeFlags = new CriteriaFlags(5);
    }

    Container(NameID nameID) {
        this.m_changeFlags = new CriteriaFlags(5);
        this.setName(nameID);
        this.setKey(new ContainerKey(nameID));
    }

    public void activate() {
    }

    public void clear() {
        super.clear();
        this.m_adminGrpList = null;
        this.m_label = null;
        this.m_description = null;
        this.m_type = null;
        this.m_references = null;
        this.m_containerOwner = null;
        this.m_props = null;
        this.m_newName = null;
    }

    public Object clone() throws CloneNotSupportedException {
        Container container = (Container)super.clone();
        int n = this.m_adminGrpList.length;
        container.m_adminGrpList = new InternalID[n];
        int n2 = 0;
        while (n2 < n) {
            container.m_adminGrpList[n2] = (InternalID)this.m_adminGrpList[n2].clone();
            ++n2;
        }
        n = this.m_label.length;
        container.m_label = new char[n];
        System.arraycopy(this.m_label, 0, container.m_label, 0, n);
        n = this.m_description.length;
        container.m_description = new char[n];
        System.arraycopy(this.m_description, 0, container.m_description, 0, n);
        container.m_type = (ContainerType)this.m_type.clone();
        n = this.m_references.length;
        container.m_references = new ReferenceBase[n];
        int n3 = 0;
        while (n3 < n) {
            container.m_references[n3] = (ReferenceBase)this.m_references[n3].clone();
            ++n3;
        }
        container.m_containerOwner = (ContainerOwner[])this.m_containerOwner.clone();
        n = this.m_props.length;
        container.m_props = new PropInfo[n];
        n3 = 0;
        while (n3 < n) {
            container.m_props[n3] = (PropInfo)this.m_props[n3].clone();
            ++n3;
        }
        container.m_newName = (NameID)this.m_newName.clone();
        return container;
    }

    public void create() throws ARException {
        if (this.m_session == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_session.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_session, bl);
        try {
            proxy.ARCreateContainer(this.m_session, this);
            Object var4_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
            throw throwable;
        }
    }

    public InternalID[] getAdminGroupList() {
        return this.m_adminGrpList;
    }

    public ContainerOwner[] getContainerOwner() {
        return this.m_containerOwner;
    }

    int getContainerTypeInt() {
        return this.m_type.toInt();
    }

    public char[] getDescription() {
        return this.m_description;
    }

    public ContainerKey getKey() {
        return new ContainerKey(this.getName());
    }

    public char[] getLabel() {
        return this.m_label;
    }

    public NameID getNewname() {
        return this.m_newName;
    }

    public PropInfo[] getProperties() {
        return this.m_props;
    }

    public ReferenceBase[] getReferences() {
        return this.m_references;
    }

    public boolean getRemoveFlag() {
        return this.m_removeFlag;
    }

    public ContainerType getType() {
        return this.m_type;
    }

    public void load() throws ARException {
        if (this.m_session == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_session.isProxyInContext();
        ContainerCriteria containerCriteria = new ContainerCriteria();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_session, bl);
        try {
            proxy.ARGetContainer(this.m_session, this.getKey(), containerCriteria, this);
            Object var5_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
            throw throwable;
        }
    }

    public void load(ContainerCriteria containerCriteria) throws ARException {
        if (this.m_session == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_session.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_session, bl);
        try {
            proxy.ARGetContainer(this.m_session, this.getKey(), containerCriteria, this);
            Object var5_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
            throw throwable;
        }
    }

    public void passivate() {
    }

    public void remove() throws ARException {
        if (this.m_session == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_session.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_session, bl);
        try {
            proxy.ARDeleteContainer(this.m_session, this.getKey());
            Object var4_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
            throw throwable;
        }
    }

    public void setAdminGroupList(InternalID[] internalIDArray) {
        this.m_adminGrpList = internalIDArray;
    }

    public void setContainerOwner(ContainerOwner[] containerOwnerArray) {
        this.m_containerOwner = containerOwnerArray;
    }

    void setContainerTypeInt(int n) {
        this.m_type = ContainerType.toContainerType(n);
    }

    public void setContext(ARServerUser aRServerUser) {
        this.m_session = aRServerUser;
    }

    public void setDescription(String string) {
        if (this.m_description == null) {
            this.m_description = new char[2000];
        }
        StringHelper.toChars(string, this.m_description, 2000);
    }

    public void setKey(ContainerKey containerKey) {
        this.setName(containerKey);
    }

    public void setLabel(String string) {
        if (this.m_label == null) {
            this.m_label = new char[255];
        }
        StringHelper.toChars(string, this.m_label, 255);
    }

    public void setNewname(NameID nameID) {
        this.m_newName = nameID;
    }

    public void setProperties(PropInfo[] propInfoArray) {
        this.m_props = propInfoArray;
    }

    public void setReferences(ReferenceBase[] referenceBaseArray) {
        this.m_references = referenceBaseArray;
    }

    public void setRemoveFlag(boolean bl) {
        this.m_removeFlag = bl;
    }

    public void setType(ContainerType containerType) {
        this.m_type = containerType;
    }

    public void store() throws ARException {
        if (this.m_session == null) {
            throw new NullPointerException("Invalid ARServerUser object");
        }
        boolean bl = this.m_session.isProxyInContext();
        Proxy proxy = ProxyManager.getProxyManager().getProxy(this.m_session, bl);
        try {
            proxy.ARSetContainer(this.m_session, this);
            Object var4_4 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ProxyManager.getProxyManager().releaseProxy(proxy, this.m_session, bl);
            throw throwable;
        }
    }

    public void unsetContext() {
        this.m_session = null;
    }
}

