
/*  File: arextern.h  */

/* External declarations of the API for the AR System */

#ifndef AR_EXTERN_DEFINED
#define AR_EXTERN_DEFINED

#ifndef C_VARIETIES_H
#define C_VARIETIES_H

/* external definition macros extracted from the c_variables.h include file  */
/* Builds the correct external reference for the type of compiler being used */

#if defined(__cplusplus)
    /* Definitions for C++ 2.0 and later */
#   define EXTERN_FUNCTION( rtn, args ) extern "C" { rtn args; }
#   define STRUCT_TAG( tag_name ) /* the tag disappears */
#   define ENUM_BITFIELD( enum_type ) unsigned
#   define ENUM_TYPE( enum_sp, enum_ty ) enum_ty
#   define NAME_CONFLICT( name ) _/**/name
#   define DOTDOTDOT ...
#   define _VOID_ /* anachronism */

#else
#if defined(c_plusplus)
    /* Definitions for C++ 1.2 */
#   define EXTERN_FUNCTION( rtn, args ) rtn args
#   define STRUCT_TAG( tag_name )  /* the tag disappears */
#   define ENUM_BITFIELD( enum_type ) unsigned
#   define ENUM_TYPE( enum_sp, enum_ty ) enum_ty
#   define NAME_CONFLICT( name ) _/**/name
#   define DOTDOTDOT ...
#   define _VOID_ /* anachronism */

#else
#if defined(__STDC__) || defined(_WIN32)
    /* Definitions for ANSI C and Win32 .c files */
#   define EXTERN_FUNCTION( rtn, args ) rtn args
#   define STRUCT_TAG( tag_name ) tag_name
#   define ENUM_BITFIELD( enum_type ) unsigned
#   define ENUM_TYPE( enum_sp, enum_ty ) enum_sp enum_ty
#   define NAME_CONFLICT( name ) name
#   define DOTDOTDOT ...
#   define _VOID_ void

#else
    /* Definitions for Sun/K&R C */
#   define EXTERN_FUNCTION( rtn, args ) rtn()
#   define STRUCT_TAG( tag_name ) tag_name
#   define ENUM_BITFIELD( enum_type ) enum_type
#   define ENUM_TYPE( enum_sp, enum_ty ) enum_sp enum_ty
#   define NAME_CONFLICT( name ) name
#   define DOTDOTDOT
#   define _VOID_

#endif

#endif

#endif

#endif

#include <stdio.h>
#include "ar.h"

                         /**  Entry  **/
EXTERN_FUNCTION (int ARGetEntry, (ARControlStruct *, ARNameType, 
                       AREntryIdList *, ARInternalIdList *, ARFieldValueList *,
                       ARStatusList *));
EXTERN_FUNCTION (int ARSetEntry, (ARControlStruct *, ARNameType, 
                       AREntryIdList *, ARFieldValueList *, ARTimestamp,
                       unsigned int, ARStatusList *));
EXTERN_FUNCTION (int ARCreateEntry, (ARControlStruct *, ARNameType, 
                       ARFieldValueList *, AREntryIdType, ARStatusList *));
EXTERN_FUNCTION (int ARDeleteEntry, (ARControlStruct *, ARNameType,
                       AREntryIdList *, unsigned int, ARStatusList *));
EXTERN_FUNCTION (int ARCloseNetworkConnections, (ARControlStruct *,
                       ARStatusList *));
EXTERN_FUNCTION (int ARMergeEntry, (ARControlStruct *, ARNameType,
                       ARFieldValueList *, unsigned int, AREntryIdType,
                       ARStatusList *));
EXTERN_FUNCTION (int ARGetListEntry, (ARControlStruct *, ARNameType,
                       ARQualifierStruct *, AREntryListFieldList *,
                       ARSortList *, unsigned int, AREntryListList *,
                       unsigned int *, ARStatusList *));
EXTERN_FUNCTION (int ARGetListEntryWithFields, (ARControlStruct *, ARNameType,
                       ARQualifierStruct *, AREntryListFieldList *,
                       ARSortList *, unsigned int, AREntryListFieldValueList *,
                       unsigned int *, ARStatusList *));
EXTERN_FUNCTION (int ARGetEntryStatistics, (ARControlStruct *, ARNameType,
                       ARQualifierStruct *, ARFieldValueOrArithStruct *,
                       unsigned int, ARInternalIdList *,
                       ARStatisticsResultList *, ARStatusList *));
EXTERN_FUNCTION (int ARGetMultipleEntries, (ARControlStruct *, ARNameType, 
                       AREntryIdListList *, ARInternalIdList *, ARBooleanList *,
                       ARFieldValueListList *, ARStatusList *));
EXTERN_FUNCTION (int ARGetEntryBLOB, (ARControlStruct *, ARNameType, 
                       AREntryIdList *, ARInternalId, ARLocStruct *,
                       ARStatusList *));
                         /**  Help with data structures  **/
EXTERN_FUNCTION (int ARLoadARQualifierStruct, (ARControlStruct *, ARNameType,
                       ARNameType, char *, ARQualifierStruct *,
                       ARStatusList *));
EXTERN_FUNCTION (int ARDecodeStatusHistory, (ARControlStruct *, char *,
                       ARStatusHistoryList *, ARStatusList *));
EXTERN_FUNCTION (int ARDecodeDiary, (ARControlStruct *, char *, ARDiaryList *,
                       ARStatusList *));
                         /**  Schema  **/
EXTERN_FUNCTION (int ARGetSchema, (ARControlStruct *, ARNameType,
                       ARCompoundSchema *, ARPermissionList *,
                       ARInternalIdList *, AREntryListFieldList *, ARSortList *,
                       ARIndexList *, char **, ARTimestamp *, ARNameType,
                       ARNameType, char **,
                       ARPropList *, ARStatusList *));
EXTERN_FUNCTION (int ARSetSchema, (ARControlStruct *, ARNameType, ARNameType,
                       ARCompoundSchema *, ARPermissionList *,
                       ARInternalIdList *, AREntryListFieldList *, ARSortList *,
                       ARIndexList *, char *, ARNameType, char *,
                       ARPropList *,
                       ARStatusList *));
EXTERN_FUNCTION (int ARCreateSchema, (ARControlStruct *, ARNameType,
                       ARCompoundSchema *, ARPermissionList *,
                       ARInternalIdList *, AREntryListFieldList *, ARSortList *,
                       ARIndexList *, char *, ARNameType, char *,
                       ARPropList *,
                       ARStatusList *));
EXTERN_FUNCTION (int ARDeleteSchema, (ARControlStruct *, ARNameType, 
                       unsigned int, ARStatusList *));
EXTERN_FUNCTION (int ARGetListSchema, (ARControlStruct *, ARTimestamp,
                       unsigned int, ARNameType, ARNameList *, ARStatusList *));
                         /**  Field  **/
EXTERN_FUNCTION (int ARGetField, (ARControlStruct *, ARNameType, ARInternalId,
                       ARNameType, ARFieldMappingStruct *, unsigned int *,
                       unsigned int *, unsigned int *, ARValueStruct *,
                       ARPermissionList *,ARFieldLimitStruct *,
                       ARDisplayInstanceList *, char **, ARTimestamp *,
                       ARNameType, ARNameType, char **, ARStatusList *));
EXTERN_FUNCTION (int ARSetField, (ARControlStruct *, ARNameType, ARInternalId,
                       ARNameType, unsigned int *, unsigned int *,
                       ARValueStruct *, ARPermissionList *,
                       ARFieldLimitStruct *, ARDisplayInstanceList *, char *,
                       ARNameType, char *, ARStatusList *));
EXTERN_FUNCTION (int ARCreateField, (ARControlStruct *, ARNameType,
                       ARInternalId *, ARBoolean, ARNameType,
                       ARFieldMappingStruct *, unsigned int, unsigned int,
                       unsigned int, ARValueStruct *, ARPermissionList *,
                       ARFieldLimitStruct *, ARDisplayInstanceList *, char *,
                       ARNameType, char *, ARStatusList *));
EXTERN_FUNCTION (int ARDeleteField, (ARControlStruct *, ARNameType,
                       ARInternalId, unsigned int, ARStatusList *));
EXTERN_FUNCTION (int ARDeleteMultipleFields, (ARControlStruct *, ARNameType,
                       ARInternalIdList *, unsigned int, ARStatusList *));
EXTERN_FUNCTION (int ARGetListField, (ARControlStruct *, ARNameType,
                       unsigned long, ARTimestamp, ARInternalIdList *,
                       ARStatusList *));
EXTERN_FUNCTION (int ARGetMultipleFields, (ARControlStruct *, ARNameType,
                       ARInternalIdList *, ARBooleanList *, ARInternalIdList *,
                       ARNameList *, ARFieldMappingList *, ARUnsignedIntList *,
                       ARUnsignedIntList *, ARUnsignedIntList *, ARValueList *,
                       ARPermissionListList *,ARFieldLimitList *,
                       ARDisplayInstanceListList *, ARTextStringList *,
                       ARTimestampList *, ARNameList *, ARNameList *,
                       ARTextStringList *, ARStatusList *));
                         /**  Character Menu **/
EXTERN_FUNCTION (int ARGetCharMenu, (ARControlStruct *, ARNameType,
                       unsigned int *, ARCharMenuStruct *, char **,
                       ARTimestamp *, ARNameType, ARNameType, char **,
                       ARPropList *, ARStatusList *));
EXTERN_FUNCTION (int ARSetCharMenu, (ARControlStruct *, ARNameType, ARNameType,
                       unsigned int *, ARCharMenuStruct *, char *, ARNameType,
                       char *, ARPropList *, ARStatusList *));
EXTERN_FUNCTION (int ARCreateCharMenu, (ARControlStruct *, ARNameType,
                       unsigned int, ARCharMenuStruct *, char *, ARNameType,
                       char *, ARPropList *, ARStatusList *));
EXTERN_FUNCTION (int ARDeleteCharMenu, (ARControlStruct *, ARNameType,
                       ARStatusList *));
EXTERN_FUNCTION (int ARGetListCharMenu, (ARControlStruct *, ARTimestamp,
                       ARNameList *, ARStatusList *));
EXTERN_FUNCTION (int ARExpandCharMenu, (ARControlStruct *, ARCharMenuStruct *,
                       ARCharMenuStruct *, ARStatusList *));
                         /**  Filter  **/
EXTERN_FUNCTION (int ARGetFilter, (ARControlStruct *, ARNameType,
                       unsigned int *, ARWorkflowConnectStruct *,unsigned int *,
                       unsigned int *, ARQualifierStruct *,
                       ARFilterActionList *, ARFilterActionList *, char **,
                       ARTimestamp *, ARNameType, ARNameType, char **,
                       ARPropList *, ARStatusList *));
EXTERN_FUNCTION (int ARSetFilter, (ARControlStruct *, ARNameType, ARNameType,
                       unsigned int *, ARWorkflowConnectStruct *,unsigned int *,
                       unsigned int *, ARQualifierStruct *,
                       ARFilterActionList *, ARFilterActionList *, char *,
                       ARNameType, char *, ARPropList *, ARStatusList *));
EXTERN_FUNCTION (int ARCreateFilter, (ARControlStruct *, ARNameType,
                       unsigned int, ARWorkflowConnectStruct *, unsigned int,
                       unsigned int, ARQualifierStruct *, ARFilterActionList *,
                       ARFilterActionList *, char *, ARNameType, char *,
                       ARPropList *, ARStatusList *));
EXTERN_FUNCTION (int ARDeleteFilter, (ARControlStruct *, ARNameType,
                       ARStatusList *));
EXTERN_FUNCTION (int ARGetListFilter, (ARControlStruct *, ARNameType,
                       ARTimestamp, ARNameList *, ARStatusList *));
                         /**  Escalation  **/
EXTERN_FUNCTION (int ARGetEscalation, (ARControlStruct *, ARNameType,
                       AREscalationTmStruct *, ARWorkflowConnectStruct *,
                       unsigned int *, ARQualifierStruct *,ARFilterActionList *,
                       ARFilterActionList *, char **, ARTimestamp *, ARNameType,
                       ARNameType, char **, ARPropList *, ARStatusList *));
EXTERN_FUNCTION (int ARSetEscalation, (ARControlStruct *, ARNameType,
                       ARNameType, AREscalationTmStruct *,
                       ARWorkflowConnectStruct *, unsigned int *,
                       ARQualifierStruct *, ARFilterActionList *,
                       ARFilterActionList *, char *, ARNameType, char *,
                       ARPropList *, ARStatusList *));
EXTERN_FUNCTION (int ARCreateEscalation, (ARControlStruct *, ARNameType,
                       AREscalationTmStruct *, ARWorkflowConnectStruct *,
                       unsigned int, ARQualifierStruct *, ARFilterActionList *,
                       ARFilterActionList *, char *, ARNameType, char *,
                       ARPropList *, ARStatusList *));
EXTERN_FUNCTION (int ARDeleteEscalation, (ARControlStruct *, ARNameType,
                       ARStatusList *));
EXTERN_FUNCTION (int ARGetListEscalation, (ARControlStruct *, ARNameType,
                       ARTimestamp, ARNameList *, ARStatusList *));
                         /**  Active Link  **/
EXTERN_FUNCTION (int ARGetActiveLink, (ARControlStruct *, ARNameType,
                       unsigned int *, ARWorkflowConnectStruct *,
                       ARInternalIdList *, unsigned int *, ARInternalId *,
                       ARInternalId *, unsigned int *, ARQualifierStruct *,
                       ARActiveLinkActionList *, ARActiveLinkActionList *,
                       char **, ARTimestamp *, ARNameType, ARNameType, char **,
                       ARPropList *, ARStatusList *));
EXTERN_FUNCTION (int ARSetActiveLink, (ARControlStruct *, ARNameType,
                       ARNameType, unsigned int *, ARWorkflowConnectStruct *,
                       ARInternalIdList *, unsigned int *, ARInternalId *,
                       ARInternalId *, unsigned int *, ARQualifierStruct *,
                       ARActiveLinkActionList *, ARActiveLinkActionList *,
                       char *, ARNameType, char *, ARPropList *,
                       ARStatusList *));
EXTERN_FUNCTION (int ARCreateActiveLink, (ARControlStruct *, ARNameType,
                       unsigned int, ARWorkflowConnectStruct *,
                       ARInternalIdList *, unsigned int, ARInternalId *,
                       ARInternalId *, unsigned int, ARQualifierStruct *,
                       ARActiveLinkActionList *, ARActiveLinkActionList *,
                       char *, ARNameType, char *, ARPropList *,
                       ARStatusList *));
EXTERN_FUNCTION (int ARDeleteActiveLink, (ARControlStruct *, ARNameType,
                       ARStatusList *));
EXTERN_FUNCTION (int ARGetListActiveLink, (ARControlStruct *, ARNameType,
                       ARTimestamp, ARNameList *, ARStatusList *));
                         /**  VUI  **/
EXTERN_FUNCTION (int ARGetVUI, (ARControlStruct *, ARNameType, ARInternalId,
                       ARNameType, ARPropList *, char **, ARTimestamp *,
                       ARNameType, ARNameType, char **, ARStatusList *));
EXTERN_FUNCTION (int ARSetVUI, (ARControlStruct *, ARNameType, ARInternalId,
                       ARNameType, ARPropList *, char *, ARNameType, char *,
                       ARStatusList *));
EXTERN_FUNCTION (int ARCreateVUI, (ARControlStruct *, ARNameType,
                       ARInternalId *, ARNameType, ARPropList *, char *,
                       ARNameType, char *, ARStatusList *));
EXTERN_FUNCTION (int ARDeleteVUI, (ARControlStruct *, ARNameType, ARInternalId,
                       ARStatusList *));
EXTERN_FUNCTION (int ARGetListVUI, (ARControlStruct *, ARNameType, ARTimestamp,
                       ARInternalIdList *, ARStatusList *));
                         /**  Support File  **/
EXTERN_FUNCTION (int ARGetSupportFile, (ARControlStruct *, unsigned int,
                       ARNameType, ARInternalId, ARInternalId, FILE *,
                       ARTimestamp *, ARStatusList *));
EXTERN_FUNCTION (int ARSetSupportFile, (ARControlStruct *, unsigned int,
                       ARNameType, ARInternalId, ARInternalId, FILE *,
                       ARStatusList *));
EXTERN_FUNCTION (int ARCreateSupportFile, (ARControlStruct *, unsigned int,
                       ARNameType, ARInternalId, ARInternalId, FILE *,
                       ARStatusList *));
EXTERN_FUNCTION (int ARDeleteSupportFile, (ARControlStruct *, unsigned int,
                       ARNameType, ARInternalId, ARInternalId, ARStatusList *));
EXTERN_FUNCTION (int ARGetListSupportFile, (ARControlStruct *, unsigned int,
                       ARNameType, ARInternalId, ARTimestamp,
                       ARInternalIdList *, ARStatusList *));
                         /**  Container  **/
EXTERN_FUNCTION (int ARGetContainer, (ARControlStruct *, ARNameType,
                       ARReferenceTypeList *, ARPermissionList *,
                       ARInternalIdList *, ARContainerOwnerObj *, char **,
                       char **, unsigned int *, ARReferenceList *, char **,
                       ARNameType, ARTimestamp *, ARNameType, char **,
                       ARPropList *, ARStatusList *));
EXTERN_FUNCTION (int ARSetContainer, (ARControlStruct *, ARNameType, ARNameType,
                       ARPermissionList *, ARInternalIdList *,
                       ARContainerOwnerObj *, char *, char *, unsigned int *,
                       ARReferenceList *, ARBoolean, char *, ARNameType, char *,
                       ARPropList *, ARStatusList *));
EXTERN_FUNCTION (int ARCreateContainer, (ARControlStruct *, ARNameType,
                       ARPermissionList *, ARInternalIdList *,
                       ARContainerOwnerObj *, char *, char *, unsigned int,
                       ARReferenceList *, ARBoolean, char *, ARNameType, char *,
                       ARPropList *, ARStatusList *));
EXTERN_FUNCTION (int ARGetListContainer, (ARControlStruct *, ARTimestamp,
                       ARContainerTypeList *, unsigned int,
                       ARContainerOwnerObj *, ARContainerInfoList *,
                       ARStatusList *));
EXTERN_FUNCTION (int ARDeleteContainer, (ARControlStruct *, ARNameType,
                       ARStatusList *));
                         /**  Miscellaneous  **/
EXTERN_FUNCTION (int ARVerifyUser, (ARControlStruct *, ARBoolean *, ARBoolean *,
                       ARBoolean *, ARStatusList *));
EXTERN_FUNCTION (int ARGetListServer, (ARControlStruct *, ARServerNameList *,
                       ARStatusList *));
EXTERN_FUNCTION (int ARGetListGroup, (ARControlStruct *, ARNameType,
                       ARGroupInfoList *, ARStatusList *));
EXTERN_FUNCTION (int ARGetListUser, (ARControlStruct *, unsigned int,
                       ARUserInfoList *, ARStatusList *));
EXTERN_FUNCTION (int ARExport, (ARControlStruct *, ARStructItemList *,
                       ARNameType, char **, ARStatusList *));
EXTERN_FUNCTION (int ARImport, (ARControlStruct *, ARStructItemList *, char *,
                       unsigned int, ARStatusList *));
EXTERN_FUNCTION (int ARGetServerInfo, (ARControlStruct *,
                       ARServerInfoRequestList *, ARServerInfoList *,
                       ARStatusList *));
EXTERN_FUNCTION (int ARSetServerInfo, (ARControlStruct *, ARServerInfoList *,
                       ARStatusList *));
EXTERN_FUNCTION (int ARSignal, (ARControlStruct *, ARSignalList *,
                       ARStatusList *));
EXTERN_FUNCTION (int ARGetFullTextInfo, (ARControlStruct *,
                       ARFullTextInfoRequestList *, ARFullTextInfoList *,
                       ARStatusList *));
EXTERN_FUNCTION (int ARSetFullTextInfo, (ARControlStruct *,
                       ARFullTextInfoList *, ARStatusList *));
EXTERN_FUNCTION (int ARGetServerStatistics, (ARControlStruct *,
                       ARServerInfoRequestList *, ARServerInfoList *,
                       ARStatusList *));
EXTERN_FUNCTION (int ARGetListSQL, (ARControlStruct *, char *, unsigned int,
                       ARValueListList *, unsigned int *, ARStatusList *));
EXTERN_FUNCTION (int ARExecuteProcess, (ARControlStruct *, char *, int *,
                       char **, ARStatusList *));
EXTERN_FUNCTION (int ARSetServerPort, (ARControlStruct *, ARNameType,
                       int, int, ARStatusList *));
EXTERN_FUNCTION (char *ARGetTextForErrorMessage, (int));
EXTERN_FUNCTION (int ARSetLogging, (ARControlStruct *, unsigned long,
                       unsigned long, FILE *, ARStatusList *));
EXTERN_FUNCTION (int ARValidateFormCache, (ARControlStruct *, ARNameType,
                       ARTimestamp, ARTimestamp, ARTimestamp *, int *, int *,
                       ARNameList *, ARTimestamp *, ARTimestamp *,
                       ARStatusList *));
                         /**  Startup/Shutdown  **/
EXTERN_FUNCTION (int ARInitialization, (ARControlStruct *, ARStatusList *));
EXTERN_FUNCTION (int ARTermination, (ARControlStruct *, ARStatusList *));


#endif  /* ifndef AR_EXTERN_DEFINED */
