
/*  File: nt.h  */

#ifndef NT_SYSTEM_DEFINED
#define NT_SYSTEM_DEFINED
                               /* Name for the system */
#define NT_SYSTEM_NAME       "Notification System"

                               /* environment variable for alt config dir */
#define NT_ENV_CONFIGDIR     "NTCONFIGDIR"
                               /* environment variable for alt config dir */
                               /*  (backup to sync with the AR System)    */
#define NT_ENV_CONFIGDIR_2   "ARCONFIGDIR"
                               /* directory containing config files */
#define NT_HOME_CONFIGDIR    "/etc"
                               /* 'directory' file identifying NT servers */
#define NT_DIRECTORY_FILE    "ar"

                               /* tag for NT entries in directory file */
#define NT_DIRECTORY_NT_TAG  "NT"

#define NT_DEFN_FILE_COMMENT '#'  /* comment line in server file */

#define NT_TAG_THREAD_LOG      "<THREAD>"   /* tag for thread log file */
#define NT_DEBUG_THREAD_LOG_FILE  "thread.log"  /* thread log file name */

                               /* target user to indicate send broadcast to */
                               /*  all currently connected users            */
#define NT_REGISTERED_BROADCAST "*"

#define NT_MAX_CODE_TEXT_SIZE 1024/* maximum size of notify code text message */
#define NT_MAX_MESSAGE_SIZE    256/* maximum size of a status message */
#define NT_MAX_NAME_SIZE        30/* maximum size of a name in the system */
#define NT_MAX_NOTIFY_SIZE     255/* maximum size of a notify text line */
#define NT_MAX_SERVER_SIZE     255/* maximum size of a server name */
#define NT_MAX_LANG_SIZE       16 /* maximum size of a language name */
#define NT_DEBUG_THREAD        32 /* debug flag for thread debugging */

#define NT_MAX_FULL_MESSAGE  NT_MAX_NOTIFY_SIZE + NT_MAX_CODE_TEXT_SIZE + 40
                                  /* max size of a message in "pipe" */
#define NT_MAX_COM_ID_SIZE  128   /* maximum size of a COM clsId/methodIId   */

                                /* constants for support of NTBoolean type */
#ifndef FALSE
#define FALSE                0
#endif
#ifndef TRUE
#define TRUE                 1
#endif

                               /* codes for return values from API routines */
#define NT_RETURN_OK         0 /*   successful; status may contain notes */
#define NT_RETURN_WARNING    1 /*   successful?; status contains details */
#define NT_RETURN_ERROR      2 /*   failure; status contains details */
#define NT_RETURN_FATAL      3 /*   failure; status may or may not contain */
                               /*            any details                  */
#define NT_RETURN_BAD_STATUS 4 /*   status structure is invalid */

#define NT_NOTIFY_STRING_SEP '\\' /* separator used in notify string */
#define NT_NOTIFY_RETURN_TAG '\01'/* ascii char to use for returns within text*/
                                  /*  that is stored as an undelivered message*/

#define NT_NOTIFY_ACK        "ack"/* ack used in socket communication */

                               /* notify codes for the system */
#define NT_CODE_HEARTBEAT     0
#define NT_CODE_NT_SYSTEM     1
#define NT_CODE_AR_SYSTEM     2
#define NT_CODE_FIRST_CONTACT 3
#define NT_CODE_CHECK_USER    4
#define NT_CODE_FB_SYSTEM     5

                               /* codes for types of registrations supported */
#define NT_DEREGISTER         0   /* OBSOLETE */
#define NT_REGISTER_PIPE      1   /* OBSOLETE */

typedef unsigned char NTBoolean;    /* boolean flag set to TRUE or FALSE */

                                    /* structure to hold an entry id value */
typedef char          NTNameType[NT_MAX_NAME_SIZE + 1];
typedef char          NTServerNameType[NT_MAX_SERVER_SIZE + 1];


typedef struct {               /* list of 0 or more names */
                  unsigned int  numItems;
                  NTNameType   *nameList;
               } NTNameList;

typedef struct NTServerNameList {               /* list of 0 or more names */
                  unsigned int        numItems;
                  NTServerNameType   *nameList;
               } NTServerNameList;

typedef struct {               /* type of error (see return values) */
                  unsigned int  messageType;
                  int           messageNum;
                  char         *messageText;
                  char         *appendedText;
               } NTStatusStruct;

typedef struct {               /* list of 0 or more status messages */
                  unsigned int    numItems;
                  NTStatusStruct *statusList;
               } NTStatusList;

typedef struct {               /* client notification structure -- OBSOLETE */
                  int    flags;
                  char  *user;
                  char  *notify;
               } NTNotification;

#define NT_CLIENT_COMMUNICATION_RPC     1  /* Communication mechanism to */
#define NT_CLIENT_COMMUNICATION_SOCKET  2  /*  client process            */

#define NT_PROTOCOL_TCP                 1  /* Protocol used by client */
#define NT_PROTOCOL_SPX                 2

typedef unsigned long NTPortAddr;

#endif
