#ifndef AREA_H
#define AREA_H

#include "ar.h"

#ifndef C_VARIETIES_H
#define C_VARIETIES_H

/* external definition macros extracted from the c_variables.h include file  */
/* Builds the correct external reference for the type of compiler being used */

#if defined(__cplusplus)
    /* Definitions for C++ 2.0 and later */
#   define EXTERN_FUNCTION( rtn, args ) extern "C" { rtn args; }
#   define STRUCT_TAG( tag_name ) /* the tag disappears */
#   define ENUM_BITFIELD( enum_type ) unsigned
#   define ENUM_TYPE( enum_sp, enum_ty ) enum_ty
#   define NAME_CONFLICT( name ) _/**/name
#   define DOTDOTDOT ...
#   define _VOID_ /* anachronism */

#else
#if defined(c_plusplus)
    /* Definitions for C++ 1.2 */
#   define EXTERN_FUNCTION( rtn, args ) rtn args
#   define STRUCT_TAG( tag_name )  /* the tag disappears */
#   define ENUM_BITFIELD( enum_type ) unsigned
#   define ENUM_TYPE( enum_sp, enum_ty ) enum_ty
#   define NAME_CONFLICT( name ) _/**/name
#   define DOTDOTDOT ...
#   define _VOID_ /* anachronism */

#else
#if defined(__STDC__) || defined(_WIN32)
    /* Definitions for ANSI C and Win32 .c files */
#   define EXTERN_FUNCTION( rtn, args ) rtn args
#   define STRUCT_TAG( tag_name ) tag_name
#   define ENUM_BITFIELD( enum_type ) unsigned
#   define ENUM_TYPE( enum_sp, enum_ty ) enum_sp enum_ty
#   define NAME_CONFLICT( name ) name
#   define DOTDOTDOT ...
#   define _VOID_ void

#else
    /* Definitions for Sun/K&R C */
#   define EXTERN_FUNCTION( rtn, args ) rtn()
#   define STRUCT_TAG( tag_name ) tag_name
#   define ENUM_BITFIELD( enum_type ) enum_type
#   define ENUM_TYPE( enum_sp, enum_ty ) enum_sp enum_ty
#   define NAME_CONFLICT( name ) name
#   define DOTDOTDOT
#   define _VOID_

#endif

#endif

#endif

#endif /* C_VARIETIES_H */

                                       /* loginStatus                       */
#define AREA_LOGIN_SUCCESS         0   /* Successful login                  */
#define AREA_LOGIN_UNKNOWN_USER    1   /* User not known to the system      */
#define AREA_LOGIN_FAILED          2   /* Login failed to authenticate      */

                                        /* licenseMask                      */
#define AREA_LICENSE_MASK_WRITE     0x1 /* Setting write license            */
#define AREA_LICENSE_MASK_FULL_TEXT 0x2 /* Setting Full Text Search license */
#define AREA_LICENSE_MASK_RESERVED1 0x4
#define AREA_LICENSE_MASK_ALL       0x7

typedef struct AREAResponseStruct {
         unsigned int  licenseMask;        /* AREA_LICENSE_MASK_*           */
         unsigned int  licenseWrite;       /* AR_LICENSE_TYPE_* from AR API */
         unsigned int  licenseFTS;         /* AR_LICENSE_TYPE_* from AR API */
         unsigned int  licenseRes1;        /* AR_LICENSE_TYPE_* from AR API */
         char         *groups;             /* semi-colon separated list     */
         unsigned int  notifyMech;         /* AR_NOTIFY_* from AR API       */
         char         *email;
         unsigned int  loginStatus;        /* AREA_LOGIN_*                  */
         char         *messageText;
         char         *logText;
         ARTimestamp   modTime;
} AREAResponseStruct;

EXTERN_FUNCTION (int AREAInitializationCallback, (
	                            int argc,
	                            char *argv[]));

EXTERN_FUNCTION (void AREAVerifyLoginCallback, (
	                            ARNameType user,
	                            ARNameType password,
	                            ARNameType networkAddr,
	                            AREAResponseStruct **response));

EXTERN_FUNCTION (int AREANeedToSyncCallback, (void));

EXTERN_FUNCTION (void AREAFreeCallback, (
	                            AREAResponseStruct *response));

EXTERN_FUNCTION (void AREATerminationCallback, (void));
#endif /* AREA_H */
