
/*  File: ar.h  */

#ifndef AR_SYSTEM_DEFINED
#define AR_SYSTEM_DEFINED

#define AR_SYSTEM_NAME  "Action Request System"


#ifdef _WIN32
                               /* directory containing config files */
#define AR_HOME_CONFIGDIR     "conf"
                               /* system server configuration filename */
#define AR_HOME_CONFIGFILE    "ar.cfg"
                               /* database configuration filename */
#define AR_HOME_DB_CONFIGFILE "ardb.cfg"
                               /* audit configuration filename */
#define AR_HOME_AUDIT_CONFIGFILE "araudit.cfg"
                               /* notification configuration filename */
#define AR_HOME_NFY_CONFIGFILE    "nfy.cfg"
                               /* default home directory */
#define AR_HOME_DEFAULT       "c:\\arservdb"

#else /* _WIN32 */
                               /* directory containing config files */
#define AR_HOME_CONFIGDIR     "/etc"
                               /* system server configuration filename */
#define AR_HOME_CONFIGFILE    "ar.conf"
                               /* database configuration filename */
#define AR_HOME_DB_CONFIGFILE  "ardb.conf"
                               /* default home directory */
#define AR_HOME_DEFAULT       "/usr/ar"
                               /* notification configuration filename */
#define AR_HOME_NFY_CONFIGFILE    "nfy.conf"
                               /* audit configuration filename */
#define AR_HOME_AUDIT_CONFIGFILE "araudit.conf"

#endif /* _WIN32 */
                               /* environment variable for alt config dir */
#define AR_ENV_CONFIGDIR      "ARCONFIGDIR"
                               /* default server stop file */
#define AR_MONITOR_PID        "armonitor.pid"
                               /* default filter log file */
#define AR_LOG_FILE           "ar.log"
                               /* default server directory file */
#define AR_DIRECTORY_FILE     "ar"
                               /* application audit file */
#define AR_APPL_AUDIT_FILE    "appl.aud"
                               /* application audit violation file */
#define AR_APPL_VIOLATION_FILE "appl.vio"
                               /* tag for AR server */
#define AR_DIRECTORY_AR_TAG   "AR"

#define AR_MAX_ACTIONS            25/* max actions for 1 filter/active link */
#define AR_MAX_AL_MESSAGE_SIZE  4095/* max size of an active link message */
#define AR_MAX_AUTOMATION_SIZE  2000/* max size of an auto item string */
#define AR_MAX_BUFFER_SIZE       128
#define AR_MAX_CMENU_SIZE        255/* max size of a character menu value */
#define AR_MAX_COMMAND_SIZE      255/* max size of a user command string */
#define AR_MAX_DDE_ITEM        32767/* max size of a dde item string */
#define AR_MAX_DDE_NAME           64/* max size of a dde service/topic name */
#define AR_MAX_COM_NAME         1024/* max size of a COM name */
#define AR_MAX_COM_METHOD_NAME   128/* max size of a method string */
#define AR_MAX_COM_ID_SIZE       128/* max size of a COM clsId/methodIId */
#define AR_MAX_DEFAULT_SIZE      255/* max size of a character type default */
#define AR_MAX_EMAIL_ADDR        255/* max size of a notify email address */
#define AR_MAX_ENTRYID_SIZE       15/* max size of an entry id in the system */
#define AR_MAX_GROUPLIST_SIZE    255/* max size of the group list field */
#define AR_MAX_INDEX_BYTES       255/* max bytes in ALL columns in an index */
#define AR_MAX_INDEX_FIELDS       16/* max fields in an index */
#define AR_MAX_LANG_SIZE          15/* max size of a language name */
#define AR_MAX_MACRO_VALUE       255/* max size of a macro value */
#define AR_MAX_MENU_ITEMS         99/* max menu items in any single menu for */
                                    /*   char field default sets             */
#define AR_MAX_MENU_LEVELS        15/* max menu levels for char field default */
                                    /*   sets                                 */
#define AR_MAX_MESSAGE_SIZE      255/* max size of a status message */
#define AR_MAX_MULT_ENTRIES      100/* max entries that can be handled by a */
                                    /*   multiple entries call              */
#define AR_MAX_NAME_SIZE          30/* max size of a name in the system */
#define AR_MAX_NOTIFY_SIZE       255/* max size of a notify text line */
#define AR_MAX_NOTIFY_LINE      1024/* max size of a value line when values */
                                    /*   formatted for a notification       */
#define AR_MAX_NOTIFY_USER       255/* max size of a notify user line */
#define AR_MAX_PATTERN_SIZE      255/* max size of a character limit pattern */
#define AR_MAX_RELATED_SIZE      128/* max size of related to field */
#define AR_MAX_SCHEMAID_SIZE       5/* max size schemaid in flat file schema */
                                    /*   cache                               */
#define AR_MAX_SERVER_SIZE        64/* max size of a server name */
#define AR_MAX_SDESC_SIZE        128/* max size of a short description */
#define AR_MAX_SUBJECT_SIZE      255/* max size of a notify subject line */

                                /* filename limits; are restrictive so the */
#define AR_MAX_FILENAME_SIZE  12/*   names will be legal on any target     */
#define AR_MAX_FILENAME_BASE   8/*   system and these limits are smallest  */
#define AR_MAX_FULL_FILENAME 255

                                    /* table and column field size limits */
#define AR_MAX_TBLFLD_NUMCOLS    255/* max columns in a table field */
#define AR_MAX_TBLFLD_RETROWS   9999/* max rows returned in a refresh */
#define AR_MAX_COLFLD_COLLENGTH  255/* max data size displayed in a column */

#ifdef _WIN32
#define MAXHOSTNAMELEN      255/* maximum size of a server name */
                               /*  same as MAXHOSTNAMELEN from <sys/param.h> */
#endif
                               /* maximum if using flatfile server */
#define AR_MAX_FLATFILE_LIMIT  10000000
#define AR_WARN_FLATFILE_LIMIT  9000000

                               /* maximum size of attachment BLOB */
#define AR_MAX_BLOB_SIZE       2147483647L

                               /* maximum if the server doesn't have license */
#define AR_NO_LICENSE_DB_LIMIT 2000000 /* max bytes for flat file solution */
#define AR_NO_LICENSE_DB_COUNT  2000   /* max entries for SQL solution */

#define AR_LICENSE_TYPE_NONE       0   /* types of user licenses supported by */
#define AR_LICENSE_TYPE_FIXED      1   /*  the AR System                      */
#define AR_LICENSE_TYPE_FLOATING   2
#define AR_LICENSE_TYPE_FIXED2     3   /*  Fix license type 2 */

#define AR_DEFAULT_INTERVAL   300  /* default time interval for escalation */

#define AR_MAX_GOTOGUIDE_LABEL_SIZE  128
#define AR_MAX_WAIT_CONT_TITLE_SIZE  64

#define AR_CURRENT_API_VERSION       7  /* current api version */

#define AR_NATIVE_ENCRYPTION        '0'
#define AR_UNICODE_ENCRYPTION       '1'

#define AR_ENCRYPTION_VERSION       '0'
#define AR_ENCRYPTION_VERSION_2     '1'

#define AR_SERVER_INFO_MIN_AUDIT_LOG_FILE_SIZE 100000 /*Set minimum audit file
                                                        size to 100 kB*/

#ifdef __cplusplus
/* This is needed so C++ applications don't compile these structures as C++. */
extern "C" {
#endif
                               /* Name for the system constants for support */
                               /*   of ARBoolean type                       */
#ifndef FALSE
#define FALSE                0
#endif
#ifndef False
#define False                0
#endif
#ifndef TRUE
#define TRUE                 1
#endif
#ifndef True
#define True                 1
#endif

                               /* codes for return values from API routines */
#define AR_RETURN_OK         0 /*   successful; status may contain notes */
#define AR_RETURN_WARNING    1 /*   successful?; status contains details */
#define AR_RETURN_ERROR      2 /*   failure; status contains details */
#define AR_RETURN_FATAL      3 /*   failure; status may or may not contain */
                               /*            any details                   */
#define AR_RETURN_BAD_STATUS 4 /*   status structure is invalid */
#define AR_RETURN_PROMPT     5 /*   status for the active link action */

typedef unsigned char ARBoolean;   /* boolean flag set to TRUE or FALSE */

                                   /* structure to hold an entry id value */
typedef char          AREntryIdType[AR_MAX_ENTRYID_SIZE + 1];

typedef unsigned long ARInternalId;/* structure to hold an internal id */
                                   /* structure to hold an object name */
typedef char          ARNameType[AR_MAX_NAME_SIZE + 1];
typedef char          ARServerNameType[AR_MAX_SERVER_SIZE + 1];
typedef long          ARTimestamp; /* timestamp; Unix style timestamp */
                                   /*  (seconds since Jan. 1, 1970)   */

typedef struct {               /* list of 0 or more entry ids */
                  unsigned int   numItems;
                  AREntryIdType *entryIdList;
               } AREntryIdList;

typedef struct {               /* list of 0 or more internal ids */
                  unsigned int  numItems;
                  ARInternalId *internalIdList;
               } ARInternalIdList;

typedef struct {               /* list of 0 or more names */
                  unsigned int  numItems;
                  ARNameType   *nameList;
               } ARNameList;

typedef struct {               /* list of 0 or more names */
                  unsigned int      numItems;
                  ARServerNameType *nameList;
               } ARServerNameList;

typedef struct {               /* list of 0 or more character strings */
                  unsigned int  numItems;
                  char        **stringList;
               } ARTextStringList;

typedef struct {               /* list of 0 or more timestamps */
                  unsigned int  numItems;
                  ARTimestamp  *timestampList;
               } ARTimestampList;

typedef struct {               /* list of 0 or more unsigned integers */
                  unsigned int  numItems;
                  unsigned int *intList;
               } ARUnsignedIntList;

#define AR_BYTE_LIST_SELF_DEFINED   0 /* byte list is self typed via the  */
                                      /*  first bytes; i.e. "GIF" at head */
#define AR_BYTE_LIST_WIN30_BITMAP   1 /* Windows 3.0 bitmap format */
#define AR_BYTE_LIST_JPEG           2
#define AR_BYTE_LIST_TIFF           3
#define AR_BYTE_LIST_TARGA          4
#define AR_BYTE_LIST_PCX            5

typedef struct {               /* byte stream */
                  unsigned long   type;     /* type of list */
                  unsigned int    numItems; /* length of bytes */
                  unsigned char  *bytes;    /* not NULL terminated */
               } ARByteList;

/* Control record containing information about the user and the environment.  */
/* An instance of this structure will be the first parameter of all the calls */
/* supported by the AR system.                                                */
/*  NOTE that server is listed last in the structure below as it is not passed*/
/*     in the RPC call.  It is not needed on the server (who already knows    */
/*     who he is).  By placing it last, there can still be a "clean" mapping  */
/*     of the first part of the record with the RPC structure.                */

typedef struct {               /* id assigned and used by the system for */
                               /*  efficient cache access                */
                  long          cacheId;
                               /* time at which the operation was performed */
                  ARTimestamp   operationTime;
                               /* username and password for access control */
                  ARNameType    user;
                  ARNameType    password;
                               /* language user is speaking; if empty, use */
                               /*  default defined for the user            */
                  char          language[AR_MAX_LANG_SIZE + 1];
                               /* API session identifier */
                  unsigned long sessionId;
                               /* server currently accessing */
                  char          server[AR_MAX_SERVER_SIZE + 1];
               } ARControlStruct;


typedef struct {               /* type of error (see return values) */
                  unsigned int  messageType;
                  long          messageNum;
                  char         *messageText;
                  char         *appendedText;
               } ARStatusStruct;

typedef struct {               /* list of 0 or more status messages */
                  unsigned int    numItems;
                  ARStatusStruct *statusList;
               } ARStatusList;

typedef struct {
                  unsigned int  messageType;
                  long          messageNum;
                  char         *messageText;
                  ARBoolean     usePromptingPane;
               } ARMessageStruct;


#define AR_DATA_TYPE_NULL           0 /* code for a NULL value */
#define AR_DATA_TYPE_KEYWORD        1 /* code indicating a keyword setting */
#define AR_DATA_TYPE_INTEGER        2 /* codes for the data type of a value */
#define AR_DATA_TYPE_REAL           3
#define AR_DATA_TYPE_CHAR           4
#define AR_DATA_TYPE_DIARY          5
#define AR_DATA_TYPE_ENUM           6
#define AR_DATA_TYPE_TIME           7
#define AR_DATA_TYPE_BITMASK        8
#define AR_DATA_TYPE_BYTES          9
#define AR_DATA_TYPE_DECIMAL       10 /* code for decimal field */
#define AR_DATA_TYPE_ATTACH        11 /* code for attachment field */

#define AR_DATA_TYPE_JOIN          30
#define AR_DATA_TYPE_TRIM          31 /* code for any visual trim field */
#define AR_DATA_TYPE_CONTROL       32 /* code for any control field */
#define AR_DATA_TYPE_TABLE         33 /* code for table and column fields */
#define AR_DATA_TYPE_COLUMN        34
#define AR_DATA_TYPE_PAGE          35 /* code for page field */
#define AR_DATA_TYPE_PAGE_HOLDER   36 /* code for page holder field */

#define AR_DATA_TYPE_ULONG         40
#define AR_DATA_TYPE_COORDS        41

#define AR_FIELD_TYPE_DATA          1 /* per record stored data field type */
#define AR_FIELD_TYPE_TRIM          2 /* visual trim field type */
#define AR_FIELD_TYPE_CONTROL       4 /* GUI control field type */
#define AR_FIELD_TYPE_PAGE          8 /* page field type */
#define AR_FIELD_TYPE_PAGE_HOLDER  16 /* page holder field type */
#define AR_FIELD_TYPE_TABLE        32 /* table field type */
#define AR_FIELD_TYPE_COLUMN       64 /* column field (in a table field) type */
#define AR_FIELD_TYPE_ATTACH      128 /* attachment field type */

#define AR_FIELD_TYPE_ALL   (AR_FIELD_TYPE_DATA | AR_FIELD_TYPE_TRIM | \
                             AR_FIELD_TYPE_CONTROL | AR_FIELD_TYPE_PAGE | \
                             AR_FIELD_TYPE_PAGE_HOLDER | AR_FIELD_TYPE_TABLE | \
                             AR_FIELD_TYPE_COLUMN | AR_FIELD_TYPE_ATTACH)

#define AR_DEFAULT_VALUE_NONE 0 /* code used to indicate that there is no */
                                /*   default value for this field         */

/* an additional AR_KEYWORD_NULL concept is mapped to AR_DATA_TYPE_NULL */
                                /* codes for keywords supported */
#define AR_KEYWORD_DEFAULT      0  /* admin defined default for the field */
#define AR_KEYWORD_USER         1  /* login name of the current user */
#define AR_KEYWORD_TIMESTAMP    2  /* current date/time */
#define AR_KEYWORD_TIME_ONLY    3  /* current time (date defaults to today) */
#define AR_KEYWORD_DATE_ONLY    4  /* current date (time defaults to midnight)*/
#define AR_KEYWORD_SCHEMA       5  /* schema currently being worked on */
#define AR_KEYWORD_SERVER       6  /* server currently being accessed */
#define AR_KEYWORD_WEEKDAY      7  /* current day of the week */
#define AR_KEYWORD_GROUPS       8  /* set of groups current user is member of */
#define AR_KEYWORD_OPERATION    9  /* operation being performed (see defines) */
#define AR_KEYWORD_HARDWARE    10  /* hardware operating on (see uname) */
#define AR_KEYWORD_OS          11  /* OS and release of OS (see uname) */
#define AR_KEYWORD_DATABASE    12  /* Database and version of database */
#define AR_KEYWORD_LASTID      13  /* EntryID of most recently created entry */
#define AR_KEYWORD_LASTCOUNT   14  /* Number of matches to most recent search */
#define AR_KEYWORD_VERSION     15  /* Version of current environment */
#define AR_KEYWORD_VUI         16  /* current VUI (client only) */
#define AR_KEYWORD_GUIDETEXT   17  /* current Guide Text (client only) */
#define AR_KEYWORD_FIELDHELP   18  /* current Field Help  (client only) */
#define AR_KEYWORD_GUIDE       19  /* current guide (client only) */
#define AR_KEYWORD_APPLICATION 20  /* current application (client only) */
#define AR_KEYWORD_NO          21  /* No more keywords !! Returns NO */

#define AR_MAX_KEYWORD_USED    21  /* set to code for "highest" keyword */

#define AR_KEY_OPERATION_CREATE  "CREATE"    /* User Tool - Submit */
#define AR_KEY_OPERATION_DELETE  "DELETE"    /* User Tool - Delete */
#define AR_KEY_OPERATION_GET     "GET"       /* User Tool - Display */
#define AR_KEY_OPERATION_GETLIST "GETLIST"   /* User Tool - Query List */
#define AR_KEY_OPERATION_MERGE   "MERGE"     /* User Tool - N/A */
#define AR_KEY_OPERATION_SET     "SET"       /* User Tool - Modify */
#define AR_KEY_OPERATION_SET_ALL "SET ALL"   /* User Tool - Modify All */
#define AR_KEY_OPERATION_QUERY   "QUERY"     /* User Tool - Query */

#define AR_PATTERN_KEY_DIGIT  101 /* codes for keyword in char patterns */
#define AR_PATTERN_KEY_ALPHA  102
#define AR_PATTERN_KEY_ALNUM  103
#define AR_PATTERN_KEY_PRINT  104
#define AR_PATTERN_KEY_UPPER  105
#define AR_PATTERN_KEY_LOWER  106
#define AR_PATTERN_KEY_MENU   107

typedef struct {               /* in typographic points (i.e., pixels) */
                  long  x;
                  long  y;
               } ARCoordStruct;

typedef struct {               /* ordered list of 0 or more coordinates */
                  unsigned int    numItems;
                  ARCoordStruct  *coords;
               } ARCoordList;


#define AR_LOC_NULL      0 /* RESERVED for future use */
#define AR_LOC_FILENAME  1 /* store and retrieve via filename */
#define AR_LOC_BUFFER    2 /* store and retrieve via memory buffer */

typedef struct {
                  unsigned long  bufSize;
                  unsigned char *buffer;
               } ARBufStruct;

typedef struct {     /* how to locate blob */
                  unsigned long  locType;  /* locator: AR_LOC_FD | AR_LOC_BUF */
                  union {
                           char        *filename; /* filename to open */
                           ARBufStruct  buf;      /* memory buffer */
                  } u;
               } ARLocStruct;

typedef struct {
                  char        *name;     /* name of attachment */
                  long         origSize; /* pre-compression number of bytes */
                  long         compSize; /* post-compression number of bytes */
                  ARLocStruct  loc;      /* how to locate attachment content */
               } ARAttachStruct;

                               /* Structure used to hold a value.  There is */
                               /*   one branch for each datatype/property   */
typedef struct {               /*   that is supported by the system.        */
                  unsigned int dataType;  /* AR_DATA_TYPE_xxx */
                  union {
                           unsigned int    keyNum;
                           long            intVal;
                           double          realVal;
                           char           *charVal;
                           char           *diaryVal;
                           unsigned long   enumVal;
                           ARTimestamp     timeVal;
                           unsigned long   maskVal;
                           ARByteList     *byteListVal;
                           char           *decimalVal;
                           ARAttachStruct *attachVal;
                           unsigned long   ulongVal;
                           ARCoordList    *coordListVal;
                        } u;
               } ARValueStruct;

typedef struct {               /* list of 0 or more values */
                  unsigned int   numItems;
                  ARValueStruct *valueList;
               } ARValueList;

typedef struct {               /* list of 0 or more value lists */
                  unsigned int   numItems;
                  ARValueList   *valueListList;
               } ARValueListList;

#define AR_NO_MAX_LIST_RETRIEVE 0 /* code to indicate no maximum limit for the*/
                                  /*  number of entries retrieved by get list */

typedef struct {               /* definition for a field in the Entry list */
                  ARInternalId fieldId;
                  unsigned int columnWidth;
                  char         separator[10];
               } AREntryListFieldStruct;

typedef struct {               /* list of 0 or more fields to put in entrylist*/
                  unsigned int            numItems;
                  AREntryListFieldStruct *fieldsList;
               } AREntryListFieldList;

typedef struct {               /* key to an entry */
                  AREntryIdList  entryId;
                               /* short description of the entry that contains*/
                               /*  data from selected fields of the entry     */
                  char          *shortDesc;                  
               } AREntryListStruct;

typedef struct {               /* list of 0 or more entries */
                  unsigned int       numItems;
                  AREntryListStruct *entryList;
               } AREntryListList;

typedef struct {               /* list of 0 or more entryIds */
                  unsigned int       numItems;
                  AREntryIdList     *entryIdList;
               } AREntryIdListList;

typedef struct {               /* id and value for a single field */
                  ARInternalId       fieldId;
                  ARValueStruct      value;
               } ARFieldValueStruct;

typedef struct {               /* list of 0 or more field/value pairs */
                  unsigned int        numItems;
                  ARFieldValueStruct *fieldValueList;
               } ARFieldValueList;

                               /* parallel entry list structures which are */
                               /* used to return entryList as a list of    */
                               /* entryId and entry as field/value pairs   */
typedef struct {               /* key to an entry,  */
                  AREntryIdList       entryId;
                  ARFieldValueList   *entryValues;
               } AREntryListFieldValueStruct;
                  
typedef struct {               /* list of 0 or more entries */
                  unsigned int                 numItems;
                  AREntryListFieldValueStruct *entryList;
               } AREntryListFieldValueList;

typedef struct {               /* list of 0 or more ARBoolean */
                  unsigned int        numItems;
                  ARBoolean          *booleanList;
               } ARBooleanList;

typedef struct {               /* list of 0 or more ARBooleanList */
                  unsigned int        numItems;
                  ARBooleanList      *booleanList;
               } ARBooleanMatrix;

typedef struct {               /* list of 0 or more ARFieldValueList */
                  unsigned int       numItems;
                  ARFieldValueList  *valueListList;
               } ARFieldValueListList;

#define AR_MERGE_ENTRY_DUP_ERROR     1
#define AR_MERGE_ENTRY_DUP_NEW_ID    2
#define AR_MERGE_ENTRY_DUP_OVERWRITE 3
#define AR_MERGE_ENTRY_DUP_MERGE     4

#define AR_MERGE_NO_REQUIRED_INCREMENT 1024 /* code added to above to "ignore */
                                            /*  required" during merge        */
#define AR_MERGE_NO_PATTERNS_INCREMENT 2048 /* code added to above to "ignore */
                                            /*  patterns" during merge        */


/* Structures used to specify qualifying criteria for a set of entries. */

#define AR_STAT_HISTORY_USER  1 /* tags to indicate user or time field */
#define AR_STAT_HISTORY_TIME  2

typedef struct {
                  unsigned long enumVal;
                  unsigned int  userOrTime;
               } ARStatHistoryValue;

#define AR_MAX_LOCAL_VARIABLES  10  /* maximum number of local variables */

#define AR_QUERY_VALUE_MULTI_ERROR 1  /* tags for what to do with multiple */
#define AR_QUERY_VALUE_MULTI_FIRST 2  /*  matches on a Query Value         */
#define AR_QUERY_VALUE_MULTI_SET   3

typedef struct {
                  ARNameType                schema;
                  char                      server[AR_MAX_SERVER_SIZE + 1];
                  struct ARQualifierStruct *qualifier;
                  ARInternalId              valueField;
                  unsigned int              multiMatchCode;
               } ARQueryValueStruct;

#define AR_FIELD            1 /* tags to indicate field or value */
#define AR_VALUE            2 /* general tags used for all instances */
#define AR_ARITHMETIC       3
#define AR_STAT_HISTORY     4
#define AR_VALUE_SET        5 /* set of values used for the "IN" operator */

                              /* options from here down are used only by */
                              /*  filters and active links               */
#define AR_FIELD_TRAN      50 /* tags used for filters to indicate value in */
#define AR_FIELD_DB        51 /*  transaction or database only, use "CURRENT" */
                              /*  if value in tran or if not there in db      */
                              /*  (use fieldId branch of the structure)       */
#define AR_LOCAL_VARIABLE  52 /* local variable for filter/active link */
#define AR_QUERY           53 /* query another schema for filter/active link */

#define AR_FIELD_CURRENT   99 /* tag used for active links to indicate     */
                              /*  a field reference to the screen the      */
                              /*  active link is being fired from and for  */
                              /*  filters to indicate use of the value in  */
                              /*  the transaction if present and db if not */
                              /*  (use fieldId branch of the structure)    */

typedef struct {
                  unsigned int tag;
                  union {
                           ARInternalId             fieldId;
                           ARValueStruct            value;
                           struct ARArithOpStruct  *arithOp;
                           ARStatHistoryValue       statHistory;
                           ARValueList              valueSet;
                           unsigned int             variable;
                           ARQueryValueStruct      *queryValue;
                        } u;
               } ARFieldValueOrArithStruct;

#define AR_ARITH_OP_ADD      1 /* tags for type of arithmetic operation */
#define AR_ARITH_OP_SUBTRACT 2
#define AR_ARITH_OP_MULTIPLY 3
#define AR_ARITH_OP_DIVIDE   4
#define AR_ARITH_OP_MODULO   5
#define AR_ARITH_OP_NEGATE   6    /* unary minus; operandLeft is unused */

typedef struct ARArithOpStruct {
                  unsigned int              operation;
                  ARFieldValueOrArithStruct operandLeft;
                  ARFieldValueOrArithStruct operandRight;
               } ARArithOpStruct;

#define AR_REL_OP_EQUAL         1 /* tags for type of relational operation */
#define AR_REL_OP_GREATER       2
#define AR_REL_OP_GREATER_EQUAL 3
#define AR_REL_OP_LESS          4
#define AR_REL_OP_LESS_EQUAL    5
#define AR_REL_OP_NOT_EQUAL     6
#define AR_REL_OP_LIKE          7
#define AR_REL_OP_IN            8

typedef struct {
                  unsigned int              operation;
                  ARFieldValueOrArithStruct operandLeft;
                  ARFieldValueOrArithStruct operandRight;
               } ARRelOpStruct;

#define AR_COND_OP_NONE         0 /* indicates no qualifier */
#define AR_COND_OP_AND          1 /* tags for type of conditional operation */
#define AR_COND_OP_OR           2
#define AR_COND_OP_NOT          3
#define AR_COND_OP_REL_OP       4

/* For compatibility with strict ANSI C compilation modes, use the         */
/* "notQual" data member name rather than "not", and define AR_STRICT_ANSI */
/* in your project  The words "and", "or", and "not" have become ANSI C    */
/* reserved keyword, and will eventually be phased out of the AR API.      */

typedef struct ARQualifierStruct {
                  unsigned int  operation;
                  union {
                           struct {
                                     struct ARQualifierStruct *operandLeft;
                                     struct ARQualifierStruct *operandRight;
                                  } andor;
#ifndef AR_STRICT_ANSI
                           struct ARQualifierStruct *not;
#else
                           struct ARQualifierStruct *notQual;
#endif
                           ARRelOpStruct            *relOp;
                        } u;
               } ARQualifierStruct;

#define AR_SORT_ASCENDING       1 /* tags for sort order */
#define AR_SORT_DESCENDING      2

typedef struct {
                  ARInternalId  fieldId;
                  unsigned int  sortOrder;
               } ARSortStruct;

typedef struct {               /* list of 0 or more sort criteria */
                  unsigned int  numItems;
                  ARSortStruct *sortList;
               } ARSortList;


#define AR_STAT_OP_COUNT        1 /* tags for type of statistical op */
#define AR_STAT_OP_SUM          2
#define AR_STAT_OP_AVERAGE      3
#define AR_STAT_OP_MINIMUM      4
#define AR_STAT_OP_MAXIMUM      5

typedef struct {
                  ARValueList   groupByValues;
                  ARValueStruct result;
               } ARStatisticsResultStruct;

typedef struct {               /* list of 0 or more results from stat request */
                  unsigned int              numItems;
                  ARStatisticsResultStruct *resultList;
               } ARStatisticsResultList;

typedef struct {               /* field(s) to specify an index */
                  unsigned int  numFields;
                  ARInternalId  fieldIds[AR_MAX_INDEX_FIELDS];
                  ARBoolean     unique;
                  ARNameType    indexName;
               } ARIndexStruct;

typedef struct {               /* list of 0 or more indexes */
                  unsigned int   numItems;
                  ARIndexStruct *indexList;
               } ARIndexList;

#define AR_FIELD_OPTION_REQUIRED 1 /* tags for field definition option */
#define AR_FIELD_OPTION_OPTIONAL 2
#define AR_FIELD_OPTION_SYSTEM   3    /* system field; read-only to ALL users */
                                      /*  NOTE that fields cannot be created  */
                                      /*   with nor set to this option        */
#define AR_FIELD_OPTION_DISPLAY  4    /* display-only field; no data will be */
                                      /*  stored for this field in the DB    */

#define AR_FIELD_OPEN_AT_CREATE      1 /* tags for field create mode */
#define AR_FIELD_PROTECTED_AT_CREATE 2


#define AR_DISPLAY_TAG_SQL   "SQL" /* tag used to identify SQL view display */

typedef struct {  /* display/object property */
                  unsigned long  prop;      /* AR_*PROP_*; property tag */
                  ARValueStruct  value;
               } ARPropStruct;

typedef struct {  /* list of 0 or more display/object properties */
                  unsigned int  numItems;
                  ARPropStruct *props;
               } ARPropList;

typedef struct {  /* display instance */
                  ARInternalId vui;    /* VUI to which display belongs */
                  ARPropList   props;  /* properties specific to the vui */
               } ARDisplayInstanceStruct;

typedef struct {                       /* properties common across displays */
                  ARPropList               commonProps;
                                       /* properties specific to one display */
                  unsigned int             numItems;
                  ARDisplayInstanceStruct *dInstanceList;
               } ARDisplayInstanceList;

typedef struct {               /* list of 0 or more display instance lists */
                  unsigned int           numItems;
                  ARDisplayInstanceList *dInstanceList;
               } ARDisplayInstanceListList;

/* Display property and value definitions.  [0..16K] reserved by Remedy. */
/*                                                                       */
/*      NAME                    VALUE    TYPE; DEFAULT; COMMENT          */
/*                                                                       */
/*     *** ONLY PROPERTIES DOCUMENTED IN MANUAL ARE SUPPORTED ***        */
#define AR_DPROP_NONE               0 /* NULL; no property */

/* Types of trim fields */
#define AR_DPROP_TRIM_TYPE          1 /* ENUM; no trim */
#define   AR_DVAL_TRIM_NONE           0 /* unknown trim */
#define   AR_DVAL_TRIM_LINE           1 /* polyline */
#define   AR_DVAL_TRIM_SHAPE          2 /* polygon */
#define   AR_DVAL_TRIM_TEXT           3 /* multi-row text */
#define   AR_DVAL_TRIM_IMAGE          4 /* static image */

/* Types of control fields */
#define AR_DPROP_CNTL_TYPE          2 /* BITMASK; no control */
#define   AR_DVAL_CNTL_BUTTON         1 /* button on view */
#define   AR_DVAL_CNTL_MENU           2 /* menu item */
#define   AR_DVAL_CNTL_TOOLBAR        4 /* toolbar item */
#define   AR_DVAL_CNTL_TAB_SWITCH     8 /* tabbed dialog switch */

/*
 * Generic visual properties and values
 */

#define AR_FIXED_POINT_PRECISION    100 /* Precision of coordinate values */

#define AR_DPROP_BBOX               3 /* COORDS (box); no data area; */
                                      /*   context dependent         */
#define AR_DPROP_VISIBLE            4 /* ENUM (bool); visible */
#define AR_DPROP_ENABLE             5 /* ENUM; enabled */
#define   AR_DVAL_ENABLE_DEFAULT      0  /* default - probably read-write */
#define   AR_DVAL_ENABLE_READ_ONLY    1  /* make field read-only */
#define   AR_DVAL_ENABLE_READ_WRITE   2  /* make field read-write */
#define   AR_DVAL_ENABLE_DISABLE      3  /* make field disabled */
#define AR_DPROP_HELP               6 /* CHAR; use field/vui help */
#define AR_DPROP_Z_ORDER            7 /* ULONG; create on top */
#define AR_DPROP_COLOR_FILL         8 /* CHAR (name); */
#define   AR_DVAL_COLOR_NONE          "none"    /* transparent */
#define   AR_DVAL_COLOR_BG            "bg"      /* background */
#define   AR_DVAL_COLOR_FG            "fg"      /* foreground */
#define   AR_DVAL_COLOR_EDIT_BG       "edit_bg" /* text edit background */
#define   AR_DVAL_COLOR_EDIT_FG       "edit_fg" /* text edit foreground */
#define   AR_DVAL_COLOR_FOCUS         "focus"   /* input focus highlight */
#define   AR_DVAL_COLOR_INSET1        "inset1"  /* 1st level group */
#define   AR_DVAL_COLOR_INSET2        "inset2"  /* 2nd level group */
                                      /* custom color is "#BBGGRR" style tag */
#define AR_DPROP_DEPTH_EFFECT       9 /* ENUM; depends on field type */
#define   AR_DVAL_DEPTH_EFFECT_FLAT         0
#define   AR_DVAL_DEPTH_EFFECT_RAISED       1
#define   AR_DVAL_DEPTH_EFFECT_SUNKEN       2
#define   AR_DVAL_DEPTH_EFFECT_FLOATING     3
#define   AR_DVAL_DEPTH_EFFECT_ETCHED       4
#define AR_DPROP_DEPTH_AMOUNT      10 /* ULONG; depends on field type */
#define AR_DPROP_COLOR_LINE        11 /* CHAR (name); context dependent; */
#define AR_DPROP_COLOR_TEXT        12 /* CHAR (name); context dependent; */
#define AR_DPROP_PROMPT            13 /* CHAR; no prompt; this form of help is*/
                                      /* displayed on status line in Windows  */

/* Every field has a label display property */
#define AR_DPROP_LABEL             20 /* CHAR (name); no label;      */
                                      /*   field ID used if no label */
#define AR_DPROP_LABEL_BBOX        21 /* COORDS (box); no label */
#define AR_DPROP_LABEL_FONT_STYLE  22 /* CHAR (name); derive from field */
                                      /*   type/option                  */
#define AR_DPROP_LABEL_FONT_SIZE   23 /* ULONG; derive from field setting */
#define AR_DPROP_LABEL_COLOR_TEXT  24 /* CHAR (name)(AR_DVAL_COLOR_*); */
                                      /*   foreground; */
#define AR_DPROP_LABEL_JUSTIFY     25 /* ENUM; depends on field setting */
#define   AR_DVAL_JUSTIFY_DEFAULT     0 /* default based on situation */
#define   AR_DVAL_JUSTIFY_LEFT        1 /* left justified */
#define   AR_DVAL_JUSTIFY_CENTER      2 /* centered */
#define   AR_DVAL_JUSTIFY_FILL        3 /* fill to both sides */
#define   AR_DVAL_JUSTIFY_RIGHT       4 /* right justified */
#define   AR_DVAL_JUSTIFY_TILE        5 /* tile to fill both sides */
#define AR_DPROP_LABEL_ALIGN       26 /* ENUM; derive from field setting */
#define   AR_DVAL_ALIGN_DEFAULT       0 /* default based on situation */
#define   AR_DVAL_ALIGN_TOP           1 /* top aligned */
#define   AR_DVAL_ALIGN_MIDDLE        2 /* middle aligned */
#define   AR_DVAL_ALIGN_FILL          3 /* expand height to fill */
#define   AR_DVAL_ALIGN_BOTTOM        4 /* bottom aligned */
#define   AR_DVAL_ALIGN_TILE          5 /* tile to fill height */
#define AR_DPROP_LABEL_POS_SECTOR  27 /* BITMASK; depends on field setting */
#define   AR_DVAL_SECTOR_NONE         0 /* Label not auto positioned */
#define   AR_DVAL_SECTOR_CENTER       1 /* Inside field data area */
#define   AR_DVAL_SECTOR_NORTH        2 /* On top of field data area */
#define   AR_DVAL_SECTOR_EAST         4 /* To the right of field data area */
#define   AR_DVAL_SECTOR_SOUTH        8 /* Below field data area */
#define   AR_DVAL_SECTOR_WEST        16 /* To the left of field data area */
#define AR_DPROP_LABEL_POS_JUSTIFY 28 /* ENUM (AR_DVAL_JUSTIFY_*); not auto */
                                      /*  positioned                        */
#define AR_DPROP_LABEL_POS_ALIGN   29 /* ENUM (AR_DVAL_ALIGN_*); not auto */
                                      /*   positioned                     */
#define AR_DPROP_LABEL_COLOR_FILL  30 /* CHAR (name)(AR_DVAL_COLOR_*); */
                                      /* context dependent             */
#define AR_DPROP_LABEL_COLOR_LINE  31 /* CHAR (name)(AR_DVAL_COLOR_*); */
                                      /* context dependent             */

/* Shared between lines and shapes */
#define AR_DPROP_COORDS            40 /* COORDS; required shapes default to */
                                      /* non-zero winding number rule       */
#define AR_DPROP_LINE_WIDTH        41 /* ULONG; 3; points */
#define AR_DPROP_LINE_PATTERN      42 /* CHAR (name); NULL;              */
                                      /* -(dash), *(dot), =(double)      */
                                      /*   Can arrange to convey pattern */
                                      /*   single dash means solid */
#define AR_DPROP_JOINT_STYLE       43 /* ENUM; rounded */
#define   AR_DVAL_JOINT_EXTENDED      0 /* small angles with long point */
#define   AR_DVAL_JOINT_SHARP         1 /* angles w/ point, trunc small angles*/
#define   AR_DVAL_JOINT_ROUNDED       2 /* rounded corners */
#define   AR_DVAL_JOINT_SMOOTH        3 /* between ROUNDED and MAX_SMOOTH */
#define   AR_DVAL_JOINT_MAX_SMOOTH    4 /* all straight lines smoothed */

/* Line specific display properties */
#define AR_DPROP_ENDCAP_START      44 /* ENUM; rounded */
#define AR_DPROP_ENDCAP_END        45 /* ENUM; rounded */
#define   AR_DVAL_ENDCAP_ROUND        0 /* rounded */
#define   AR_DVAL_ENDCAP_FLUSH        1 /* flush */
#define   AR_DVAL_ENDCAP_EXTENDED     2 /* extended past coord */
#define   AR_DVAL_ENDCAP_ARROW1       3 /* arrow 1 style */

/* Field "dimension" semantic properties, not to be used for gfx positionning */
#define AR_DPROP_DATA_ROWS         60 /* ULONG; base on BBOX; legacy usage */
#define AR_DPROP_DATA_COLS         61 /* ULONG; base on BBOX; legacy usage */

/* Data field editing display properties */
#define AR_DPROP_DATA_SPIN         62 /* ENUM (bool); no spinner; */
                                      /*   part of data gfx       */
#define AR_DPROP_DATA_MENU         63 /* ENUM (bool); no menu; */
                                      /*   may be separate gfx */
#define AR_DPROP_DATA_RADIO        64 /* ENUM (bool); not radio button style */

/* Location of subcomponents in data fields, relative to field's parent */
#define AR_DPROP_DATA_MENU_BBOX    65 /* COORDS (box); no menu accel */
#define AR_DPROP_DATA_EXPAND_BBOX  66 /* COORDS (box); no expanded editor */

/* Multi-row text specific display properties (which may have label, too) */
#define AR_DPROP_TEXT              80 /* CHAR; font style name */
#define AR_DPROP_TEXT_FONT_STYLE   81 /* CHAR (name); derive from field */
                                      /*  type/option                   */
#define AR_DPROP_TEXT_FONT_SIZE    82 /* ULONG; derive from field type/option */

/* HTML Properties */
#define AR_DPROP_HTML_TEXT         83 /* CHAR; HTML Text */
#define AR_DPROP_HTML_TEXT_COLOR   84 /* ULONG; RGB in ColorRef */

/* Shared between image and text trim fields */
#define AR_DPROP_JUSTIFY           90 /* ENUM (AR_DVAL_JUSTIFY_*); field */
                                      /*   type/option derived           */
#define AR_DPROP_ALIGN             91 /* ENUM (AR_DVAL_ALIGN_*); field */
                                      /*   type/option derived         */

/* Button, toolbar, image specific */
#define AR_DPROP_IMAGE            100 /* BYTES; unknown; GIF format */
                                      /* toolbar icons              */

#define AR_DPROP_PUSH_BUTTON_IMAGE      101 /* BYTES; unknown; GIF format */
                                            /* image on a push button field */

/* Button control */
#define AR_DPROP_BUTTON_TEXT            110 /* CHAR (name); use label */
#define AR_DPROP_BUTTON_2D              111 /* ENUM (bool); display button */
                                            /*        as 2D image          */
#define AR_DPROP_BUTTON_IMAGE_POSITION  112 /* ENUM */
#define   AR_DVAL_IMAGE_CENTER              0 /* no label visible */
#define   AR_DVAL_IMAGE_LEFT                1 /* image to the left of label */
#define   AR_DVAL_IMAGE_RIGHT               2 /* image to the right of label */
#define   AR_DVAL_IMAGE_ABOVE               3 /* image above the label */
#define   AR_DVAL_IMAGE_BELOW               4 /* image below the label */
#define AR_DPROP_BUTTON_SCALE_IMAGE     113 /* ENUM (bool); scale image to */
                                            /*      fit button             */
#define AR_DPROP_BUTTON_MAINTAIN_RATIO  114 /* ENUM (bool); maintain ratio */
                                            /*      of image if scaled     */

/* Menu item control */
#define AR_DPROP_MENU_TEXT        120 /* CHAR (name); use label */
#define AR_DPROP_MENU_POS         121 /* ULONG; 0-not specified; top to */
                                      /*   bottom starting at 1         */
#define AR_DPROP_MENU_MODE        122 /* ENUM; leaf */
#define   AR_DVAL_CNTL_ITEM           0 /* leaf node */
#define   AR_DVAL_CNTL_ON             1 /* yes|on (checked,depressed) */
#define   AR_DVAL_CNTL_SEPARATOR      2 /* separator (-, blank space) */
#define   AR_DVAL_CNTL_CHOICE         3 /* chosen, 1 of many (dot,depressed) */
#define   AR_DVAL_CNTL_DIALOG         4 /* dialog will pop up */
#define   AR_DVAL_CNTL_A_MENU         5 /* top level or sub menu(>,down arrow)*/

#define AR_DPROP_MENU_PARENT      123 /* ULONG (ARInternalId); 0 os top level */
#define AR_DPROP_MENU_HELP        124 /* CHAR (name); use for menu help*/

/* Toolbar control */
#define AR_DPROP_TOOLTIP          130 /* CHAR (name); use label */
#define AR_DPROP_TOOLBAR_POS      131 /* ULONG; 0-not specified; left to */
                                      /*   right starting at 1           */
#define AR_DPROP_TOOLBAR_MODE     132 /* ENUM (AR_DPROP_CNTL_*); */
                                      /*   AR_DPROP_MENU_MODE    */
#define AR_DPROP_TOOLBAR_TEXT     133 /* CHAR (name); nothing; over image */

/* Tab switch control */
#define AR_DPROP_TAB_MODE         140 /* ENUM (AR_DPROP_CNTL_*); */
                                      /*   AR_DPROP_MENU_MODE    */
#define AR_DPROP_TAB_COORD        141 /* COORDS (1); (0,0)-not specified; */
                                      /* x is horizontal (left to right   */
                                      /*                  starting at 1); */
                                      /* y is vertical (bottom to top     */
                                      /*                starting at 1);   */
#define AR_DPROP_TAB_TEXT         142 /* CHAR (name); use label */
#define AR_DPROP_TAB_ORDER        143 /* ULONG - number for tab order of  */
                                      /*   the field on the view          */

#define AR_DPROP_DATETIME_POPUP   144 /* ENUM (AR_DVAL_DATETIME_*) */
#define   AR_DVAL_DATETIME_BOTH       0 /* default: both date & time oriented */
#define   AR_DVAL_DATETIME_TIME       1 /* time only */
#define   AR_DVAL_DATETIME_DATE       2 /* date only */

/* background mode of a field (i.e. trim box or text) */
#define AR_DPROP_BACKGROUND_MODE  145 /* ENUM (AR_DVAL_BKG_MODE_*) */
#define   AR_DVAL_BKG_MODE_OPAQUE      0 /* default: */
#define   AR_DVAL_BKG_MODE_TRANSPARENT 1 /* transparent */

/* Inter field keyboard relationships */
#define AR_DPROP_TAB_NEXT         150 /* ULONG (ARInternalId); x,y order; */
                                      /*   can include tab switch         */
#define AR_DPROP_DATA_BBOX        151 /* COORDS sub-bounding box for data area*/

/* VUI specific */
#define AR_DPROP_VIEW_GRID_BBOX   160 /* COORDS (box); (0,0),(25,25) to match */
                                      /*   2.* default; suggest (0,0),(2x,2x) */
#define AR_DPROP_VUI_DEFAULT      161 /* ENUM (bool); 0;                 */
                                      /*   1st VUI is default, otherwise */

#define AR_DPROP_PANE_LAYOUT      162 /* INTEGER: 1 through 8 for layout      */
                                      /*     option negative if locked layout */
#define AR_DPROP_DETAIL_PANE_VISIBILITY 163 /* INTEGER: detail pane visibility*/
#define   AR_DVAL_PANE_ALWAYS_HIDDEN  3     /* pane always hidden */
#define   AR_DVAL_PANE_HIDDEN         0     /* pane hidden but can be visible */
#define   AR_DVAL_PANE_VISIBLE        1     /* pane visible but can be hidden */
#define   AR_DVAL_PANE_ALWAYS_VISIBLE 2     /* pane always visible */

#define AR_DPROP_PROMPT_PANE_VISIBILITY 164 /* INTEGER: AR_DVAL_PANE_* */
#define AR_DPROP_RESULT_PANE_VISIBILITY 165 /* INTEGER: AR_DVAL_PANE_* */

/* See AR_DPROP_PANE_VISIBILITY_OPTION (214) below - this determines whether */
/*   the above 3 properties (detail pane, result pane, and prompt pane */
/*   visibility) are used or not. */

#define AR_DPROP_DETAIL_PANE_COLOR 166      /* CHAR: #BBGGRR custom color */
#define AR_DPROP_DETAIL_PANE_IMAGE 167      /* BYTELIST: image for view */
                                            /*           background     */
#define AR_DPROP_IMAGE_ALIGN       168      /* ULONG: alignment of image */
                                            /*        AR_DVAL_ALIGN_*    */
#define AR_DPROP_IMAGE_JUSTIFY     169      /* ULONG: justification of   */
                                            /*   image AR_DVAL_JUSTIFY_* */

/* Specific to fields that are children of another field */
#define AR_DPROP_DISPLAY_PARENT   170   /* ULONG (ARInternalId); FieldId of */
                                        /* parent field */

/* Page Field Specific Properties */
#define AR_DPROP_PAGE_ORDER       180 /* ULONG; order of appearence of a page */

/* Page Holder Specific Properties */
#define AR_DPROP_PAGE_LABEL_DISPLAY  190  /* ENUM (bool); 0; Position on */
                                          /* page holder where page      */
                                          /* labels should appear        */
#define   AR_DVAL_PAGE_DISPLAY_TOP        0 /* top */
#define   AR_DVAL_PAGE_DISPLAY_BOTTOM     1 /* bottom */
#define   AR_DVAL_PAGE_DISPLAY_LEFT       2 /* left */
#define   AR_DVAL_PAGE_DISPLAY_RIGHT      3 /* right */
#define   AR_DVAL_PAGE_DISPLAY_NONE       4 /* only one page exposed without */
                                            /*   any label                   */

#define AR_DPROP_PAGE_ARRANGEMENT     191 /* ENUM (bool); 0;                  */
                                          /* how pages should be displayed if */
                                          /* pages cannot fit in page holder  */
#define   AR_DVAL_PAGE_SCROLL             0 /* scroll to view the pages */
#define   AR_DVAL_PAGE_LAYER              1 /* view as layers of pages */

#define AR_DPROP_DEFAULT_PAGE         192 /* ULONG; FieldId of page field   */
                                          /* 1st page is default, otherwise */


/* More VUI specific properties */

#define AR_DPROP_TITLE_BAR_ICON_IMAGE 200
                                     /* BYTELIST: image for icon in title bar */
                                     /* size of image is determined by Win32  */
                                     /* SDK call GetSystemMetrics(SM_CXSMICON)*/
                                     /* and GetSystemMetrics(SM_CYICON)       */
#define AR_DPROP_DETAIL_PANE_WIDTH    201
                                     /* INTEGER: width in schema coordinates  */
                                     /* of the detail pane.  Negative numbers */
                                     /* reserved for future use */
#define AR_DPROP_DETAIL_PANE_HEIGHT   202   /* INTEGER: height of detail pane */
#define AR_DPROP_DETAIL_BANNER_VISIBILITY 203
                                     /* ULONG: boolean - detail banner visible*/
#define AR_DPROP_PROMPT_BANNER_VISIBILITY 204
                                     /* ULONG: boolean - prompt banner visible*/
#define AR_DPROP_RESULT_BANNER_VISIBILITY 205
                                     /* ULONG: boolean - result banner visible*/
#define AR_DPROP_ALIAS_SINGULAR 206  /* CHAR: alias for singular, ie "Child" */
#define AR_DPROP_ALIAS_PLURAL 207    /* CHAR: alias for plural, ie "Children" */
#define AR_DPROP_ALIAS_SHORT_SINGULAR 208 /* CHAR: alias for short singular,*/
                                          /*        i.e. "Kid"              */
#define AR_DPROP_ALIAS_SHORT_PLURAL 209   /* CHAR: alias for short plural,  */
                                          /*       i.e. "Kids"              */
#define AR_DPROP_ALIAS_ABBREV_SINGULAR 210/* CHAR: alias for short sing abbr */
#define AR_DPROP_ALIAS_ABBREV_PLURAL 211  /* CHAR: alias for short plural abbr*/
#define AR_DPROP_NAMED_SEARCHES 212       /* CHAR: predefined named searches. */
                                          /* format is count\length\name\     */
                                          /* length\description\qualification\*/
#define AR_DPROP_MENU_ACCESS    213
                         /* CHAR: encoded menu access, format is */
                         /*  length\field-id\state\field-id\state\etc...*/
                         /* field-id is AR_RESERV_*, a       */
                         /* reserved menu field id           */
                         /* from arstruct.h.  State is a bitmask, where */
                         /* the lowest-order bit is enabled/disabled (boolean)*/
                         /* and the bit above that (bit 1) specifies */
                         /* whether the enabled/disabled bit (bit 0) is */
                         /* used.  Higher order bits are reserved for future */
                         /* settings, and must be zero. */
/* Macro to decode menu access state from the 'state' encoding described for */
/* AR_DPROP_MENU_ACCESS.  This macro will return TRUE (enabled, the default) */
/* if the enabled flag (bit 1) isn't set, Otherwise it will return TRUE      */
/* (enabled) or FALSE (disabled) based on bit 0, the state bit               */
#define AR_GET_MENU_ACCESS_ENABLED(x)      (x & 0x2) ? (x & 0x1) : TRUE
/* Set menu access to enabled */
#define AR_SET_MENU_ACCESS_ENABLED(x)      (x |= 0x3)
/* Set menu access to disabled */
#define AR_SET_MENU_ACCESS_DISABLED(x)     (x = (x | 0x2) & ~0x1)

#define AR_DPROP_PANE_VISIBILITY_OPTION 214 /* ENUM (bool): determines whether*/
                                            /* pane visibility for view is    */
                                            /* determined by admin or by user */
#define AR_DVAL_PANE_VISIBILITY_USER_CHOICE 0 /* default: user decides */
#define AR_DVAL_PANE_VISIBILITY_ADMIN       1 /* admin defined */

#define AR_DPROP_REQUEST_IDENTIFIER      215/* ULONG: field id of field to use*/
                                            /* for 'id' of this ticket for    */
                                            /* display purposes               */
#define AR_DPROP_QUERY_LIST_COLOR        216 /* CHAR: encoded: query list color by */
                                             /* priority -- format is */
                                             /* fieldid\numvalues\value\color\value\color... */

                                          /* table and column field specific */
#define AR_DPROP_COLUMN_WIDTH       220   /* INTEGER; col width in table field*/
#define AR_DPROP_COLUMN_ORDER       221   /* INTEGER; col order in table field*/
#define AR_DPROP_SORT_SEQ           222   /* INTEGER; col seq in sort order */

#define AR_DPROP_SORT_DIR           223   /* ENUM; sort direction - ascending */
                                          /*       or dec                     */
#define AR_DVAL_SORT_DIR_ASCENDING      0 /* lowest to highest */
#define AR_DVAL_SORT_DIR_DESCENDING     1 /* highest to lowest */

#define AR_DPROP_DRILL_DOWN         224   /* ULONG (bitmask); row drill down */
                                          /*                  for details    */
#define AR_DVAL_DRILL_DOWN_NONE       0x0 /* DRILL_DOWN not allowed */     
#define AR_DVAL_DRILL_DOWN_ENABLE     0x1 /* DRILL_DOWN is enabled */

#define AR_DPROP_REFRESH            225   /* ENUM; table field refresh enabled*/
#define AR_DVAL_REFRESH_NONE            0 /* No REFRESH of data               */
#define AR_DVAL_REFRESH_TABLE_MAX       1 /* REFRESH according to max defined */
                                          /* for table field                  */
#define AR_DPROP_AUTO_REFRESH       226   /* ENUM; table field refresh enabled*/
#define AR_DVAL_AUTO_REFRESH_NONE       0 /* No AUTO REFRESH of data          */
#define AR_DVAL_AUTO_REFRESH_TABLE_MAX  1 /* AUTO REFRESH according to max    */
                                          /* defined for table field          */
#define AR_DPROP_AUTOFIT_COLUMNS    227   /* ENUM; Allow horizontal scrollbar */
                                          /* in table field                   */
#define AR_DVAL_AUTOFIT_COLUMNS_NONE    0 /* No Scrollbar. User Tool will auto*/
                                          /* scale the column width           */
#define AR_DVAL_AUTOFIT_COLUMNS_SET     1 /* Scrollbar will be enabled in the */
                                          /* Table Field                      */
                                          /* when displayed in User Tool      */
#define AR_DPROP_APPLY_DIRTY        228   /* ENUM; Apply to Dirty Bit         */
#define AR_DPROP_IMAGE_CACHE        229   /* ULONG: runtime cache of internal */
                                          /* image format, not a design time  */
                                          /* property, client specific format */

/* Object property and value definitions.                                */
/*   0..60000       reserved property numbers for display properties.    */
/*   60001..120000  reserved for object properties by Remedy             */
/*   120001..180000 available for object properties                      */
/*                                                                       */
/*      NAME                    VALUE    TYPE; DEFAULT; COMMENT          */
/*                                                                       */
/*     *** ONLY PROPERTIES DOCUMENTED IN MANUAL ARE SUPPORTED ***        */

#define AR_OPROP_VENDOR_NAME        60001 /* CHAR; Name of company that  */
                                          /*       produces the product  */
#define AR_OPROP_VENDOR_PRODUCT     60002 /* CHAR; Name of product       */
#define AR_OPROP_VENDOR_VERSION     60003 /* CHAR; Version of product    */
#define AR_OPROP_GUID               60004 /* CHAR; unique identifier for */
                                          /*       this object           */
#define AR_OPROP_COPYRIGHT          60005 /* CHAR; Copyright information */
#define AR_OPROP_SCC_LOCKED_BY      60006 /* CHAR; User who has this     */
                                          /*       object locked in      */
                                          /*       source code control   */
                                          /*       (SCC)                 */
#define AR_OPROP_SCC_VERSION        60007 /* CHAR; SCC version number    */
#define AR_OPROP_SCC_TIMESTAMP      60008 /* TIME; SCC last mod timestamp*/
#define AR_OPROP_SCC_USER           60009 /* CHAR; SCC last mod by user  */
#define AR_OPROP_SCC_LOCATION       60010 /* CHAR; Location in SCC DB    */
#define AR_OPROP_SCC_DATA_LOCKED_BY 60011 /* CHAR; User who has this     */
                                          /*       data locked in        */
                                          /*       source code control   */
                                          /*       (SCC)                 */
#define AR_OPROP_SCC_DATA_VERSION   60012 /* CHAR; SCC version num (data)*/
#define AR_OPROP_SCC_DATA_TIMESTAMP 60013 /* TIME; SCC mod time (data)   */
#define AR_OPROP_SCC_DATA_USER      60014 /* CHAR; SCC mod by user (data)*/
#define AR_OPROP_SCC_DATA_LOCATION  60015 /* CHAR; Loc in SCC DB (data)  */

/* see ARFieldValueOrArithStruct above for tag defines -- */
/*   AR_FIELD and AR_STAT_HISTORY                         */

#define AR_CURRENT_SERVER_TAG    "@" /* set server to this to indicate use */
                                     /*  "current" server (import/filter)  */
#define AR_CURRENT_SCHEMA_TAG    "@" /* set schema to this to indicate use */
                                     /*  "current" schema in db (filter)   */
#define AR_CURRENT_SCREEN_TAG    "*" /* set server and schema name to this */
#define AR_CURRENT_TRAN_TAG      "*" /*  tag to indicate get value from    */
                                     /*  "current working screen" not DB   */

#define AR_NO_MATCH_ERROR         1  /* codes for action if no match */
#define AR_NO_MATCH_SET_NULL      2  /* only if Set Fields action;  if set */
                                     /*    in Push Fields, ERROR           */
#define AR_NO_MATCH_NO_ACTION     3  /* only if Push Fields action; if set */
                                     /*    in Set Fields, ERROR            */
#define AR_NO_MATCH_SUBMIT        4  /* only if Push Fields action; if set */
                                     /*    in Set Fields, ERROR            */

#define AR_MULTI_MATCH_ERROR      1  /* codes for action if 2+ matches        */
#define AR_MULTI_MATCH_SET_NULL   2  /* only if Set Fields action; if set     */
                                     /*    in Push Fields, ERROR              */
#define AR_MULTI_MATCH_USE_FIRST  3
#define AR_MULTI_MATCH_PICKLIST   4  /* only if active link; if set in filter */
                                     /*  or escalation, USE_FIRST             */
#define AR_MULTI_MATCH_MODIFY_ALL 5  /* only if Push Fields action; if set    */
                                     /*    in Set Fields, ERROR               */
#define AR_MULTI_MATCH_NO_ACTION  6  /* only if Push Fields action; if set    */
                                     /*    in Set Fields, ERROR               */

   /* NOTE: When used with filters, the server setting MUST be one of the */
   /*   above settings.  The values for filters can only be pulled from   */
   /*   the current server or the current "screen" (current operation).   */

typedef struct {
                  char               server[AR_MAX_SERVER_SIZE + 1];
                  ARNameType         schema;
                  ARQualifierStruct  qualifier;
                  unsigned int       tag;
                  union {
                           ARInternalId       fieldId;
                           ARStatHistoryValue statHistory;
                        } u;
                  unsigned int       noMatchOption;   /* action if no match */
                  unsigned int       multiMatchOption;/* action if 2+ matches */
               } ARAssignFieldStruct;

#define AR_DDE_EXECUTE   1       /* first two used only with   */
#define AR_DDE_POKE      2       /*   ARActiveLinkActionStruct */
#define AR_DDE_REQUEST   3       /* used only with ARAssignStruct */

typedef struct {
                  char         *serviceName;
                  char         *topic;
                  char         *item;         /* NULL if EXECUTE */
                  unsigned int  action;
                  char         *pathToProgram;
                  char         *command;      /* NULL if REQUEST */
               } ARDDEStruct;

typedef struct {
                  char          server[AR_MAX_SERVER_SIZE + 1];
                  char         *sqlCommand;      /* SQL command to execute */
                  unsigned int  valueIndex;      /* index of value in sql cmd */
                  unsigned int  noMatchOption;   /* action if no match */
                  unsigned int  multiMatchOption;/* action if 2+ matches */
               } ARAssignSQLStruct;

                        /* For a parameter, it's simply a value */
#define AR_COM_PARM_NULL      0  /* invalid parameter value        */
#define AR_COM_PARM_FIELDID   1  /* a fieldId                      */
#define AR_COM_PARM_VALUE     2  /* value of ARValueStruct type    */
                                 /* Note that value is ALWAYS a string, */
                                 /* its true value type is specified in */
                                 /* parmType, a COM VARIANT type        */
 
                        /* For a method, it's a return value */
#define AR_COM_METHOD_NULL    0  /* invalid value               */
#define AR_COM_METHOD_FIELDID 1  /* value of fieldId            */
 
                /* This ARCOMValueStruct applies for COM method/parm  */
typedef struct {
                  char                  *valueIId;
                  ARInternalId           transId;
                  unsigned int           valueType;
                  union {
                     ARInternalId        fieldId;
                     ARValueStruct       value;
                  } u;
                } ARCOMValueStruct;
 
typedef struct {
                  char                  *parmName;      /* not null */
                  unsigned int           parmType;
                  ARCOMValueStruct       parmValue;
               } ARCOMMethodParmStruct;
 
typedef struct {               /* list of parameters in a COM method*/
                  unsigned int           numItems;
                  ARCOMMethodParmStruct *parameterList;
               } ARCOMMethodParmList;
 
typedef struct {
                  char                  *methodName;
                  char                  *methodIId;
                  unsigned int           methodType;
                  ARCOMValueStruct       methodValue;
                  ARCOMMethodParmList    parameterList;
               } ARCOMMethodStruct;
 
typedef struct {               /* list of 0 or more methods */
                  unsigned int           numItems;
                  ARCOMMethodStruct     *methodList;
               } ARCOMMethodList;
 
typedef struct {
                  char                  *autoServerName;
                  char                  *clsId;
                  char                  *action;
                  ARBoolean              isVisible; /* showing auto. server? */
                  ARCOMMethodList        methodList;
               } ARAutomationStruct;
 
#define AR_ASSIGN_TYPE_NONE     0
#define AR_ASSIGN_TYPE_VALUE    1 /* codes for the assign type to a field */
#define AR_ASSIGN_TYPE_FIELD    2
#define AR_ASSIGN_TYPE_PROCESS  3
#define AR_ASSIGN_TYPE_ARITH    4
#define AR_ASSIGN_TYPE_FUNCTION 5
#define AR_ASSIGN_TYPE_DDE      6    /* used only in active links */
#define AR_ASSIGN_TYPE_SQL      7

typedef struct {
                  unsigned int assignType;
                  union {
                           ARValueStruct                  value;
                           ARAssignFieldStruct           *field;
                           char                          *process;
                           struct ARArithOpAssignStruct  *arithOp;
                           struct ARFunctionAssignStruct *function;
                           ARDDEStruct                   *dde;
                           ARAssignSQLStruct             *sql;
                        } u;
               } ARAssignStruct;

typedef struct {               /* id and assignment for a single field */
                  ARInternalId   fieldId;
                  ARAssignStruct assignment;
               } ARFieldAssignStruct;

typedef struct {               /* list of 0 or more field/value assign pairs */
                  unsigned int         numItems;
                  ARFieldAssignStruct *fieldAssignList;
               } ARFieldAssignList;

/* see ARArithOpStruct above for the AR_ARITH_OP defines */

typedef struct ARArithOpAssignStruct {
                  unsigned int    operation;
                  ARAssignStruct  operandLeft;
                  ARAssignStruct  operandRight;
               } ARArithOpAssignStruct;

                                   /* Return   Parameters    Description      */
#define AR_FUNCTION_DATE       1   /* char date(timestamp)   Date part of time*/
#define AR_FUNCTION_TIME       2   /* char time(timestamp)   Time part of time*/
#define AR_FUNCTION_MONTH      3   /* long month(timestamp)  Month (1 to 12)  */
#define AR_FUNCTION_DAY        4   /* long day(timestamp)    Day (1 to 31)    */
#define AR_FUNCTION_YEAR       5   /* long year(timestamp)   Year             */
#define AR_FUNCTION_WEEKDAY    6   /* long weekday(timestamp)Weekday (1 to 7) */
#define AR_FUNCTION_HOUR       7   /* long hour(timestamp)   Hour (0 to 23)   */
#define AR_FUNCTION_MINUTE     8   /* long minute(timestamp) Minute (0 to 59) */
#define AR_FUNCTION_SECOND     9   /* long second(timestamp) Second (0 to 59) */
#define AR_FUNCTION_TRUNC     10   /* long trunc(real)       Truncate real    */
#define AR_FUNCTION_ROUND     11   /* long round(real)       Round real       */
#define AR_FUNCTION_CONVERT   12   /* char convert(???,long[,long])  Convert  */
                                   /*            ??? to type with code long1  */
                                   /*            with format qualifer long2   */
#define AR_FUNCTION_LENGTH    13   /* long length(char)      Length of string */
#define AR_FUNCTION_UPPER     14   /* char upper(char)       Upshift string   */
#define AR_FUNCTION_LOWER     15   /* char lower(char)       Downshift string */
#define AR_FUNCTION_SUBSTR    16   /* char substr(char,long[,long]) Substring */
                                   /*            in char starting at long1,   */
                                   /*            ending at long2, inclusive   */
#define AR_FUNCTION_LEFT      17   /* char left(char,long)   Leftmost x bytes */
#define AR_FUNCTION_RIGHT     18   /* char right(char,long)  Rightmost x bytes*/
#define AR_FUNCTION_LTRIM     19   /* char ltrim(char)       Trim blanks left */
#define AR_FUNCTION_RTRIM     20   /* char rtrim(char)       Trim blanks right*/
#define AR_FUNCTION_LPAD      21   /* char lpad(char,long,char)  Pad char1 on */
                                   /*            left with char2 to long      */
#define AR_FUNCTION_RPAD      22   /* char rpad(char,long,char)  Pad char1 on */
                                   /*            right with char2 to long     */
#define AR_FUNCTION_REPLACE   23   /* char replace(char,char,char)  Replace   */
                                   /*            char2 with char3 in char1    */
#define AR_FUNCTION_STRSTR    24   /* int  strstr(char,char)  Position of     */
                                   /*            char2 in char 1 (-1 not in)  */
#define AR_FUNCTION_MIN       25   /* ???  min(???,???[,???]...)  Min value   */
#define AR_FUNCTION_MAX       26   /* ???  max(???,???[,???]...)  Max value   */

#define AR_FUNCTION_COLSUM    27   /* sum a table column                      */
#define AR_FUNCTION_COLCOUNT  28   /* number of non null values in a table column */
#define AR_FUNCTION_COLAVG    29   /* average of non-null values              */
#define AR_FUNCTION_COLMIN    30   /* average of non-null values              */
#define AR_FUNCTION_COLMAX    31   /* average of non-null values              */

#define AR_MAX_FUNCTION_USED  31   /* set to code for "highest" function */

typedef struct ARFunctionAssignStruct {
                  unsigned int    functionCode;
                  unsigned int    numItems;
                  ARAssignStruct *parameterList;
               } ARFunctionAssignStruct;


#define AR_ORDER_MAX          1000 /* max value allowed as filter/active link */
                                   /*  order value                            */

#define AR_OPERATION_NONE        0
#define AR_OPERATION_GET         1 /* tags for operations being performed  */
#define AR_OPERATION_SET         2 /*  ORed together to form mask for mask */
#define AR_OPERATION_CREATE      4 /*  of operations to apply filter on    */
#define AR_OPERATION_DELETE      8
#define AR_OPERATION_MERGE      16

#define AR_NOTIFY_NONE           0
#define AR_NOTIFY_VIA_NOTIFIER   1 /* tags for notify mechanism */
#define AR_NOTIFY_VIA_EMAIL      2
#define AR_NOTIFY_VIA_DEFAULT    3

#define AR_NOTIFY_VIA_XREF      99 /* tag to indicate look at a specified    */
                                   /*  field cross-reference for notify mech */

#define AR_NOTIFY_PRIORITY_MAX  10 /* maximum notify priority */

#define AR_FILTER_FIELD_IDS_NONE    0
#define AR_FILTER_FIELD_IDS_ALL     1 /* tags for which field ids for notify */
#define AR_FILTER_FIELD_IDS_LIST    2
#define AR_FILTER_FIELD_IDS_CHANGED 3

typedef struct {
                  char            *user;
                  char            *notifyText;
                  unsigned int     notifyPriority;
                  unsigned int     notifyMechanism;
                  ARInternalId     notifyMechanismXRef;/*if AR_NOTIFY_VIA_XREF*/
                  char            *subjectText;
                  unsigned int     fieldIdListType;
                  ARInternalIdList fieldIdList; /* unused if NONE/ALL fields */
               } ARFilterActionNotify;

typedef struct {               /* type of error (see return values) */
                  unsigned int  messageType;
                  long          messageNum;
                  char         *messageText;
               } ARFilterStatusStruct;

typedef struct {
                  ARAssignFieldStruct  field;   /* target of push */
                  ARAssignStruct       assign;  /* value assigned to target */
               } ARPushFieldsStruct;

typedef struct {           /* list of 0 or more push fields */
                  unsigned int        numItems;
                  ARPushFieldsStruct *pushFieldsList;
               } ARPushFieldsList;

typedef struct {
                  char server[AR_MAX_SERVER_SIZE + 1];
                  char *command;
               } ARSQLStruct;

#define AR_GOTO_FIELD_XREF          1
#define AR_GOTO_ABSOLUTE_ORDER      2
#define AR_GOTO_OFFSET_FORWARD      3
#define AR_GOTO_OFFSET_BACKWARD     4

typedef struct {
                  unsigned int      tag;
                  unsigned long     fieldIdOrValue;
               } ARGotoActionStruct;

#define AR_FILTER_ACTION_NONE       0
#define AR_FILTER_ACTION_NOTIFY     1 /* tags for types of filter actions */
#define AR_FILTER_ACTION_MESSAGE    2
#define AR_FILTER_ACTION_LOG        3
#define AR_FILTER_ACTION_FIELDS     4
#define AR_FILTER_ACTION_PROCESS    5
#define AR_FILTER_ACTION_FIELDP     6
#define AR_FILTER_ACTION_SQL        7
#define AR_FILTER_ACTION_GOTOACTION 8

typedef struct {
                  unsigned int  action;
                  union {
                           ARFilterActionNotify   notify;
                           ARFilterStatusStruct   message;
                           char                  *logFile;
                           ARFieldAssignList      fieldList;
                           char                  *process;
                           ARPushFieldsList       pushFieldsList;
                           ARSQLStruct            sqlCommand;
                           ARGotoActionStruct     gotoAction;
                  } u;
               } ARFilterActionStruct;

typedef struct {               /* list of 0 or more filter actions */
                  unsigned int          numItems;
                  ARFilterActionStruct *actionList;
               } ARFilterActionList;

#define AR_EXECUTE_ON_NONE              0
#define AR_EXECUTE_ON_BUTTON            1/* tags for when to execute an active*/
#define AR_EXECUTE_ON_RETURN            2/*  link ORed together to form mask  */
#define AR_EXECUTE_ON_SUBMIT            4/*  for mask of conditions to execute*/
#define AR_EXECUTE_ON_MODIFY            8/*  active link on                   */
#define AR_EXECUTE_ON_DISPLAY          16
#define AR_EXECUTE_ON_MODIFY_ALL       32
#define AR_EXECUTE_ON_MENU_OPEN        64
#define AR_EXECUTE_ON_MENU_CHOICE     128
#define AR_EXECUTE_ON_LOSE_FOCUS      256
#define AR_EXECUTE_ON_SET_DEFAULT     512
#define AR_EXECUTE_ON_QUERY          1024
#define AR_EXECUTE_ON_AFTER_MODIFY   2048
#define AR_EXECUTE_ON_AFTER_SUBMIT   4096
#define AR_EXECUTE_ON_GAIN_FOCUS     8192
#define AR_EXECUTE_ON_WINDOW_OPEN   16384
#define AR_EXECUTE_ON_WINDOW_CLOSE  32768
#define AR_EXECUTE_ON_UNDISPLAY     65536
#define AR_EXECUTE_ON_COPY_SUBMIT  131072

typedef struct {
                  ARNameType  name;
                  char       *value;
               } ARMacroParmStruct;

typedef struct {
                  unsigned int       numItems;
                  ARMacroParmStruct *parms;
               } ARMacroParmList;

typedef struct {
                  ARNameType       macroName;
                  char            *macroText;
                  ARMacroParmList  macroParms;
               } ARActiveLinkMacroStruct;

#define AR_FOCUS_UNCHANGED          0
#define AR_FOCUS_SET_TO_FIELD       1

#define AR_ACCESS_OPTION_UNCHANGED  0
#define AR_ACCESS_OPTION_READ_ONLY  AR_DVAL_ENABLE_READ_ONLY
#define AR_ACCESS_OPTION_READ_WRITE AR_DVAL_ENABLE_READ_WRITE
#define AR_ACCESS_OPTION_DISABLE    AR_DVAL_ENABLE_DISABLE

typedef struct {
                  ARInternalId  fieldId;
                  char         *charMenu;
                  ARPropList    props;
                  unsigned int  focus;
                  unsigned int  accessOption;
               } ARFieldCharacteristics;

typedef struct {
                  ARServerNameType   serverName;
                  ARNameType         schemaName;
                  ARNameType         vuiLabel;
                  ARBoolean          closeBox;
                  ARFieldAssignList  inputValueFieldPairs;
                  ARFieldAssignList  outputValueFieldPairs;
               }  AROpenDlgStruct;


typedef struct {
                  ARNameType   schemaName;
               } ARCommitChangesStruct;

typedef struct {
                  ARNameType   schemaName;
               } ARCloseWndStruct;

typedef struct {
                  ARServerNameType   serverName;
                  ARNameType         guideName;
                  int                guideMode; 
               } ARCallGuideStruct;

typedef struct {
                  ARBoolean   closeAll;
               } ARExitGuideStruct;

typedef struct {
                  char  *label;
               } ARGotoGuideLabelStruct;


typedef struct {
                  char  *continueButtonTitle;
               } ARWaitStruct;

                                    /* tags for types of active link actions */
#define AR_ACTIVE_LINK_ACTION_NONE            0
#define AR_ACTIVE_LINK_ACTION_MACRO           1
#define AR_ACTIVE_LINK_ACTION_FIELDS          2
#define AR_ACTIVE_LINK_ACTION_PROCESS         3
#define AR_ACTIVE_LINK_ACTION_MESSAGE         4
#define AR_ACTIVE_LINK_ACTION_SET_CHAR        5
#define AR_ACTIVE_LINK_ACTION_DDE             6
#define AR_ACTIVE_LINK_ACTION_FIELDP          7
#define AR_ACTIVE_LINK_ACTION_SQL             8
#define AR_ACTIVE_LINK_ACTION_AUTO            9
#define AR_ACTIVE_LINK_ACTION_OPENDLG        10
#define AR_ACTIVE_LINK_ACTION_COMMITC        11
#define AR_ACTIVE_LINK_ACTION_CLOSEWND       12
#define AR_ACTIVE_LINK_ACTION_CALLGUIDE      13
#define AR_ACTIVE_LINK_ACTION_EXITGUIDE      14
#define AR_ACTIVE_LINK_ACTION_GOTOGUIDELABEL 15
#define AR_ACTIVE_LINK_ACTION_WAIT           16
#define AR_ACTIVE_LINK_ACTION_GOTOACTION     17

typedef struct {
                  unsigned int  action;
                  union {
                           ARActiveLinkMacroStruct  macro;
                           ARFieldAssignList        fieldList;
                           char                    *process;
                           ARMessageStruct          message;
                           ARFieldCharacteristics   characteristics;
                           ARDDEStruct              dde;
                           ARPushFieldsList         pushFieldsList;
                           ARSQLStruct              sqlCommand;
                           ARAutomationStruct       automation;
                           AROpenDlgStruct          openDlg;
                           ARCommitChangesStruct    commitChanges;
                           ARCloseWndStruct         closeWnd;
                           ARCallGuideStruct        callGuide;
                           ARExitGuideStruct        exitGuide;
                           ARGotoGuideLabelStruct   gotoGuide;
                           ARWaitStruct             waitAction;
                           ARGotoActionStruct       gotoAction;
                        } u;
               } ARActiveLinkActionStruct;

typedef struct {               /* list of 0 or more active link actions */
                  unsigned int              numItems;
                  ARActiveLinkActionStruct *actionList;
               } ARActiveLinkActionList;


#define AR_PERMISSIONS_NONE      0 /* tags for permissions allowed to group */

#define AR_PERMISSIONS_VISIBLE   1 /* tags for schema level permissions */
#define AR_PERMISSIONS_HIDDEN    2

#define AR_PERMISSIONS_VIEW      1 /* tags for field level permissions */
#define AR_PERMISSIONS_CHANGE    2 /* note that change includes view */

typedef struct {               /* a group and the permissions defined */
                  ARInternalId  groupId;
                  unsigned int  permissions;
               } ARPermissionStruct;

typedef struct {               /* list of 0 or more permission entries */
                  unsigned int        numItems;
                  ARPermissionStruct *permissionList;
               } ARPermissionList;

typedef struct {               /* list of 0 or more permission lists */
                  unsigned int        numItems;
                  ARPermissionList   *permissionList;
               } ARPermissionListList;

#define AR_GROUP_TYPE_VIEW       1 /* tags for types of groups */
#define AR_GROUP_TYPE_CHANGE     2

                           /* holds information about groups used with */
typedef struct {           /*  field permissions                       */
                  ARInternalId  groupId;
                  unsigned int  groupType;
                  ARNameList    groupName;
               } ARGroupInfoStruct;

typedef struct {               /* list of 0 or more groups */
                  unsigned int       numItems;
                  ARGroupInfoStruct *groupList;
               } ARGroupInfoList;


#define AR_LICENSE_TAG_WRITE       1  /* codes for licenses that could be */
#define AR_LICENSE_TAG_FULL_TEXT   2  /*  held by a user                  */
#define AR_LICENSE_TAG_RESERVED1   3

typedef struct {           /* holds information about user's licenses */
                  unsigned int  licenseTag;
                  unsigned int  licenseType;
                  unsigned int  currentLicenseType;
               } ARUserLicenseStruct;

typedef struct {               /* list of 0 or more users */
                  unsigned int         numItems;
                  ARUserLicenseStruct *licenseList;
               } ARUserLicenseList;

#define AR_USER_LIST_MYSELF      0 /* tags for type of user list wanted */
#define AR_USER_LIST_REGISTERED  1
#define AR_USER_LIST_CURRENT     2

typedef struct {           /* holds information about users in the system */
                  ARNameType         userName;
                  ARUserLicenseList  licenseInfo;
                  ARTimestamp        connectTime;
                  ARTimestamp        lastAccess;
                  unsigned int       defaultNotifyMech;
                  char              *emailAddr;
               } ARUserInfoStruct;

typedef struct {               /* list of 0 or more users */
                  unsigned int      numItems;
                  ARUserInfoStruct *userList;
               } ARUserInfoList;


typedef struct {
                  long  rangeLow;
                  long  rangeHigh;
               } ARIntegerLimitsStruct;

#define AR_PRECISION_NONE    -1  /* code for no precision setting */

typedef struct {
                  double  rangeLow;
                  double  rangeHigh;
                  int     precision;
               } ARRealLimitsStruct;

#define AR_MENU_APPEND         1 /* code indicating append/overwrite */
#define AR_MENU_OVERWRITE      2 /*  new items dropped from menu     */

                                 /* operation to perform on QBE screen */
#define AR_QBE_MATCH_ANYWHERE  1 /* LIKE "%value%" */
#define AR_QBE_MATCH_LEADING   2 /* LIKE "value%"  */
#define AR_QBE_MATCH_EQUAL     3 /* = "value"      */

                                 /* Full text options */
#define AR_FULLTEXT_OPTIONS_NONE      0x0  /* No FT options */
#define AR_FULLTEXT_OPTIONS_INDEXED   0x1  /* Field is ft indexed */

typedef struct {               /* 0 for maxLength means unlimited length */
                  unsigned int  maxLength;
                               /* append or overwrite with new menu selections*/
                  unsigned int  menuStyle;
                               /* operation to use from QBE type operation */
                  unsigned int  qbeMatchOperation;
                               /* name of character menu associated to field */
                  ARNameType    charMenu;
                               /* pattern, incl wildcards, value must match */
                  char         *pattern;
                               /* Full Text options */
                  unsigned int  fullTextOptions;
               } ARCharLimitsStruct;

/* Refer to CharLimits above for full text options flags */
typedef struct {
                  unsigned int  fullTextOptions;
               } ARDiaryLimitsStruct;

#define AR_ATTACH_FIELD_TYPE_EMBED    0x1   /* embedded type; file is stored */   
#define AR_ATTACH_FIELD_TYPE_LINK     0x2   /* RESERVED for future use */

typedef struct {
                  /* 0 for maxSize means unlimited size */
                  unsigned long   maxSize;
                  unsigned int    attachType;  /* embedded type */
               } ARAttachLimitsStruct;

typedef struct ARTableLimitsStruct {
                                    /* number of columns in table field */
                  unsigned int       numColumns;
                                    /* qualification for table field */
                  ARQualifierStruct  qualifier;
                                    /* max rows to retrieve */
                  unsigned int       maxRetrieve;
                                    /* data fields belong to this schema */
                  ARNameType         schema;
                                    /* that schema is in this server */
                  ARServerNameType   server;
} ARTableLimitsStruct;

typedef struct ARColumnLimitsStruct {
                  ARInternalId  parent;
                                    /* parent field column field belongs to */
                  ARInternalId  dataField;
                                    /* remote fieldId form which data comes */
                  unsigned int  colLength;
                                    /* column length to display - char fields */
               } ARColumnLimitsStruct;

typedef struct ARDecimalLimitsStruct {
                  char *rangeLow;
                  char *rangeHigh;
                  int   precision; /* number of places to right of dec point */
               } ARDecimalLimitsStruct;

#define AR_FIELD_LIMIT_NONE    0 /* code for no limits for this field */

typedef struct {
                  unsigned int dataType;
                  union {
                           ARIntegerLimitsStruct intLimits;
                           ARRealLimitsStruct    realLimits;
                           ARCharLimitsStruct    charLimits;
                           ARDiaryLimitsStruct   diaryLimits;
                           ARNameList            enumLimits;
                           /* time has no external limits */
                           ARNameList            maskLimits;
                           /* bytes has no external limits */
                           ARAttachLimitsStruct  attachLimits;
                           /* table and column fields specific information */
                           ARTableLimitsStruct   tableLimits;
                           ARColumnLimitsStruct  columnLimits;
                           ARDecimalLimitsStruct decimalLimits;
                        } u;
               } ARFieldLimitStruct;

typedef struct {                   /* list of 0 or more FieldLimitStructs */
                  unsigned int        numItems;
                  ARFieldLimitStruct *fieldLimitList;
               } ARFieldLimitList;


#define AR_MENU_REFRESH_CONNECT  1 /* codes for when to refresh menu */
#define AR_MENU_REFRESH_OPEN     2
#define AR_MENU_REFRESH_INTERVAL 3

#define AR_MENU_TYPE_NONE        0
#define AR_MENU_TYPE_VALUE       1 /* tags for type of char menu item */
#define AR_MENU_TYPE_MENU        2

typedef struct {               /* defines a label and value or child menu */
                  ARNameType     menuLabel;
                  unsigned int   menuType;
                  union {      /* actual default value to load */
                           char                    *menuValue;
                               /* pointer to a child menu */
                           struct ARCharMenuStruct *childMenu;
                  } u;
               } ARCharMenuItemStruct;

typedef struct {               /* menu built using a query to the AR System */
                  ARNameType         schema;
                  char               server[AR_MAX_SERVER_SIZE + 1];
                  ARQualifierStruct  qualifier;
                  ARInternalId       labelField;
                  ARInternalId       valueField;
                  ARBoolean          sortOnLabel;
               } ARCharMenuQueryStruct;

#define AR_MENU_FILE_SERVER   1/* tags for location of menu file */
#define AR_MENU_FILE_CLIENT   2

typedef struct {               /* menu built using contents of a file */
                  unsigned int  fileLocation;
                  char         *filename;
               } ARCharMenuFileStruct;

typedef struct {               /* menu built using a direct SQL command */
                  char  server[AR_MAX_SERVER_SIZE + 1];
                  char *sqlCommand;
                  int   labelIndex;
                  int   valueIndex;
               } ARCharMenuSQLStruct;

typedef struct {               /* list of 0 or more char menu entries */
                  unsigned int          numItems;
                  ARCharMenuItemStruct *charMenuList;
               } ARCharMenuList;

#define AR_CHAR_MENU_NONE     0
#define AR_CHAR_MENU_LIST     1/* tags for type of character menu */
#define AR_CHAR_MENU_QUERY    2
#define AR_CHAR_MENU_FILE     3
#define AR_CHAR_MENU_SQL      4

typedef struct ARCharMenuStruct {
                  unsigned int  menuType;
                  union {
                           ARCharMenuList         menuList;
                           ARCharMenuQueryStruct  menuQuery;
                           ARCharMenuFileStruct   menuFile;
                           ARCharMenuSQLStruct    menuSQL;
                         } u;
               } ARCharMenuStruct;


#define AR_STRUCT_ITEM_SCHEMA            1 /* tags for structure item types */
#define AR_STRUCT_ITEM_SCHEMA_DEFN       2
#define AR_STRUCT_ITEM_SCHEMA_VIEW       3
#define AR_STRUCT_ITEM_SCHEMA_MAIL       4
#define AR_STRUCT_ITEM_FILTER            5
#define AR_STRUCT_ITEM_ACTIVE_LINK       6
#define AR_STRUCT_ITEM_ADMIN_EXT         7
#define AR_STRUCT_ITEM_CHAR_MENU         8
#define AR_STRUCT_ITEM_ESCALATION        9
#define AR_STRUCT_ITEM_DIST_MAP         10
#define AR_STRUCT_ITEM_SCHEMA_VIEW_MIN  11
#define AR_STRUCT_ITEM_CONTAINER        12
#define AR_STRUCT_ITEM_DIST_POOL        13

                              /* special tag for ALL VUIs instead of just one */
#define AR_STRUCT_ITEM_SCHEMA_VIEW_2   103

#define EXPORT_OPTION_NONE         0 /* additional option to Export call */
#define EXPORT_VUI_MINIMUM         1 /* basic vui - w/o bitmaps, etc */

                                     /* importOptions for ARImport()          */
#define AR_IMPORT_OPT_CREATE       0 /* create; error if item already exists  */
#define AR_IMPORT_OPT_OVERWRITE    1 /* overwrite if item exists              */

typedef struct {               /* type and name of a structure item */
                  unsigned int  type;
                  ARNameType    name;
               } ARStructItemStruct;

typedef struct {               /* list of 0 or more struct item entries */
                  unsigned int        numItems;
                  ARStructItemStruct *structItemList;
               } ARStructItemList;

                               /* tags for server info operations */
#define AR_SERVER_INFO_DB_TYPE          1/*    char - type of DB used by server*/
#define AR_SERVER_INFO_SERVER_LICENSE   2/*    char - type of server license   */
#define AR_SERVER_INFO_FIXED_LICENSE    3/*    int  - number of fixed user lic */
#define AR_SERVER_INFO_VERSION          4/*    char - version string for server*/
#define AR_SERVER_INFO_ALLOW_GUESTS     5/*    int  - allow guest users (0/1)  */
#define AR_SERVER_INFO_USE_ETC_PASSWD   6/*    int  - ref passwd file (0/1)    */
#define AR_SERVER_INFO_XREF_PASSWORDS   7/*    int  - ref passwd for blank     */
                                         /*           passwords (0/1)          */
#define AR_SERVER_INFO_DEBUG_MODE       8/*    int  - bitmask for debug type   */
#define AR_SERVER_INFO_DB_NAME          9/*    char - name of the underlying DB*/
#define AR_SERVER_INFO_DB_PASSWORD     10/*    char - password for underlying  */
#define AR_SERVER_INFO_HARDWARE        11/*    char - server hardware platform */
#define AR_SERVER_INFO_OS              12/*    char - server OS (incl version) */
#define AR_SERVER_INFO_SERVER_DIR      13/*    char - server directory         */
#define AR_SERVER_INFO_DBHOME_DIR      14/*    char - SQL DB home directory    */
#define AR_SERVER_INFO_SET_PROC_TIME   15/*    int  - set fields proc timeout  */
                                         /*           1 to 20                  */
#define AR_SERVER_INFO_EMAIL_FROM      16/*    char - user email notifies from */
#define AR_SERVER_INFO_SQL_LOG_FILE    17/*    char - file used for SQL log    */
#define AR_SERVER_INFO_FLOAT_LICENSE   18/*    int  - number of float user lic */
#define AR_SERVER_INFO_FLOAT_TIMEOUT   19/*    int  - hours without access     */
                                         /*           before license times out */
#define AR_SERVER_INFO_UNQUAL_QUERIES  20/*    int  - allow unqual queries(0/1)*/
#define AR_SERVER_INFO_FILTER_LOG_FILE 21/*    char - file used for filter log */
#define AR_SERVER_INFO_USER_LOG_FILE   22/*    char - file used for user log   */
#define AR_SERVER_INFO_REM_SERV_ID     23/*    char - Remedy server id string  */
#define AR_SERVER_INFO_MULTI_SERVER    24/*    int  - 0 if single; 1 if multi  */
#define AR_SERVER_INFO_EMBEDDED_SQL    25/*    int  - 0 if not; 1 if embedded  */
#define AR_SERVER_INFO_MAX_SCHEMAS     26/*    int  - 0 if no max; else maximum*/
                                         /*           number allowed on server */
#define AR_SERVER_INFO_DB_VERSION      27/*    char - version string for DB    */
#define AR_SERVER_INFO_MAX_ENTRIES     28/*    int  - max entries return in    */
                                         /*           getlistentry; 0=unlimited*/
#define AR_SERVER_INFO_MAX_F_DAEMONS   29/*    int  - max number of fast AR    */
                                         /*           server daemons allowed   */
#define AR_SERVER_INFO_MAX_L_DAEMONS   30/*    int  - max number of list AR    */
                                         /*           server daemons allowed   */
#define AR_SERVER_INFO_ESCALATION_LOG_FILE 31
                                         /*    char - file used for esc log    */
#define AR_SERVER_INFO_ESCL_DAEMON     32/*    int  - have escal server (0/1)  */
#define AR_SERVER_INFO_SUBMITTER_MODE  33/*    int  - submitter mode for system*/
#define AR_SERVER_INFO_API_LOG_FILE    34/*    char - file used for API log    */
#define AR_SERVER_INFO_FTEXT_FIXED     35/*    int  - number of fixed ftext lic*/
#define AR_SERVER_INFO_FTEXT_FLOAT     36/*    int  - number of float ftext lic*/
#define AR_SERVER_INFO_FTEXT_TIMEOUT   37/*    int  - hours without access     */
                                         /*           before license times out */
#define AR_SERVER_INFO_RESERV1_A       38/*    int  - number of fixed reserv li*/
#define AR_SERVER_INFO_RESERV1_B       39/*    int  - number of float reserv li*/
#define AR_SERVER_INFO_RESERV1_C       40/*    int  - number of admin reserv li*/
#define AR_SERVER_INFO_SERVER_IDENT    41/*    char - unique identifier of the */
                                         /*           machine running server   */
#define AR_SERVER_INFO_DS_SVR_LICENSE  42/*    char - type of DS server license*/
#define AR_SERVER_INFO_DS_MAPPING      43/*    char - name of schema holding   */
                                         /*           distributed mappings     */
#define AR_SERVER_INFO_DS_PENDING      44/*    char - name of schema holding   */
                                         /*           distributed pending items*/
#define AR_SERVER_INFO_DS_RPC_SOCKET   45/*    int  - RPC socket for DS server */
#define AR_SERVER_INFO_DS_LOG_FILE     46/*    char - file used for DS log     */
#define AR_SERVER_INFO_SUPPRESS_WARN   47/*    char - list of note/warning msg */
                                         /*           numbers to be suppressed */
#define AR_SERVER_INFO_HOSTNAME        48/*    char - hostname of server       */
#define AR_SERVER_INFO_FULL_HOSTNAME   49/*    char - DNS hostname of server   */
#define AR_SERVER_INFO_SAVE_LOGIN      50/*    int  - admin override for saving*/
                                         /*           login info on client     */
#define AR_SERVER_INFO_U_CACHE_CHANGE  51/*    int  - last user cache change   */
#define AR_SERVER_INFO_G_CACHE_CHANGE  52/*    int  - last group cache change  */
#define AR_SERVER_INFO_STRUCT_CHANGE   53/*    int  - last structure change    */
                                         /*           (for this run of server) */
#define AR_SERVER_INFO_CASE_SENSITIVE  54/*    int  - case sensitivity of DB   */
#define AR_SERVER_INFO_SERVER_LANG     55/*    char - server language setting  */
#define AR_SERVER_INFO_ADMIN_ONLY      56/*    int  - Admin Only Mode (0/1)    */
#define AR_SERVER_INFO_CACHE_LOG_FILE  57/*    char - file used for cache log  */
#define AR_SERVER_INFO_FLASH_DAEMON    58/*    int  - have flash server (0/1)  */
#define AR_SERVER_INFO_THREAD_LOG_FILE 59/*    char - file used for thread log */
#define AR_SERVER_INFO_ADMIN_TCP_PORT  60/*    int  - TCP port for Admin thread*/
#define AR_SERVER_INFO_ESCL_TCP_PORT   61/*    int  - TCP port for Escl thread */
#define AR_SERVER_INFO_FAST_TCP_PORT   62/*    int  - TCP port for Fast threads*/
#define AR_SERVER_INFO_LIST_TCP_PORT   63/*    int  - TCP port for List threads*/
#define AR_SERVER_INFO_FLASH_TCP_PORT  64/*    int  - TCP port for Flash thread*/
#define AR_SERVER_INFO_TCD_TCP_PORT    65/*    int  - TCP port for TCD thread  */
#define AR_SERVER_INFO_DSO_DEST_PORT   66/*    int  - TCP port DSO uses to talk*/
#define AR_SERVER_INFO_INFORMIX_DBN    67/*    char - Informix DB server name  */
#define AR_SERVER_INFO_INFORMIX_TBC    68/*    char - Informix TBConfig        */
#define AR_SERVER_INFO_INGRES_VNODE    69/*    char - Ingres VNode setting     */
#define AR_SERVER_INFO_ORACLE_SID      70/*    char - Oracle SID               */
#define AR_SERVER_INFO_ORACLE_TWO_T    71/*    char - Oracle Two Task setting  */
#define AR_SERVER_INFO_SYBASE_CHARSET  72/*    char - Sybase character set     */
#define AR_SERVER_INFO_SYBASE_SERV     73/*    char - Sybase server name       */
#define AR_SERVER_INFO_SHARED_MEM      74/*    int  - 0 - disabled; 1 - enabled*/
#define AR_SERVER_INFO_SHARED_CACHE    75/*    int  - 0 - disabled; 1 - enabled*/
#define AR_SERVER_INFO_CACHE_SEG_SIZE  76/*    int  - cache seg size (UNIX)    */
#define AR_SERVER_INFO_DB_USER         77/*    char - user to access DB as     */
#define AR_SERVER_INFO_NFY_TCP_PORT    78/*    int  - TCP port for Notifier Svr*/
#define AR_SERVER_INFO_FILT_MAX_TOTAL  79/*    int  - max filters for an op    */
#define AR_SERVER_INFO_FILT_MAX_STACK  80/*    int  - max stack of filters     */
#define AR_SERVER_INFO_DEFAULT_ORDER_BY 81/*   int  - 0 - None   ; 1 - EntryID */
#define AR_SERVER_INFO_DELAYED_CACHE   82/*    int  - 0 -delay on; 1 -delay off*/
#define AR_SERVER_INFO_DSO_MERGE_STYLE 83/*    int  - 0 - merge; 1 - overwrite */
#define AR_SERVER_INFO_EMAIL_LINE_LEN  84/*    int  - line length of e-mail    */
#define AR_SERVER_INFO_EMAIL_SYSTEM    85/*    char - e-mail system (UNIX)     */
#define AR_SERVER_INFO_INFORMIX_RELAY_MOD 86/* char - informix relay module    */
#define AR_SERVER_INFO_PS_RPC_SOCKET   87/*    char - privSvr socket/port pairs*/
#define AR_SERVER_INFO_REGISTER_PORTMAPPER 88/*int  - 0 - not reg;1 - register */
#define AR_SERVER_INFO_SERVER_NAME     89/*    char - name of the server       */
#define AR_SERVER_INFO_DBCONF          90/*    char - dbconf file content      */
#define AR_SERVER_INFO_APPL_PENDING    91/*    char - name of schema holding   */
                                         /*           application pending items*/
#define AR_SERVER_INFO_AP_RPC_SOCKET   92/*    int  - RPC socket for AP server */
#define AR_SERVER_INFO_AP_LOG_FILE     93/*    char - file used for AP log     */
#define AR_SERVER_INFO_AP_DEFN_CHECK   94/*    int  - interval between checks  */
                                         /*           for changed defns in appl*/
#define AR_SERVER_INFO_MAX_LOG_FILE_SIZE 95/*  int  - 0 - no limit             */
#define AR_SERVER_INFO_CLUSTERED_INDEX 96/*    int  - - 0 - non-clustered;     */
                                         /*             1 - clustered          */
#define AR_SERVER_INFO_ACTLINK_DIR     97/*    char - actlink run process      */
                                         /*           directory                */
#define AR_SERVER_INFO_ACTLINK_SHELL   98/*    char - shell for actlink run    */
                                         /*           processes                */
#define AR_SERVER_INFO_USER_CACHE_UTILS 99/*   int  - 1 - allow arcache, aruser*/
                                          /*             API calls             */
#define AR_SERVER_INFO_EMAIL_TIMEOUT  100/*    int  - email timeout (UNIX)     */
#define AR_SERVER_INFO_EXPORT_VERSION 101/*    int  - server's export version  */
#define AR_SERVER_INFO_ENCRYPT_AL_SQL 102/*    int  - encrypt AL direct SQL    */
                                         /*           exports                  */
#define AR_SERVER_INFO_SCC_ENABLED    103/*    int  - 0 - not enabled          */
#define AR_SERVER_INFO_SCC_PROVIDER_NAME 104/* char - name of SCC provider     */
#define AR_SERVER_INFO_SCC_TARGET_DIR 105   /* char - target dir for SCC       */
#define AR_SERVER_INFO_SCC_COMMENT_CHECKIN 106/* int- comments required at     */
                                               /*     checkin time (0/1)       */
#define AR_SERVER_INFO_SCC_COMMENT_CHECKOUT 107/* int-comments required at     */
                                               /*     checkout time (0/1)      */
#define AR_SERVER_INFO_SCC_INTEGRATION_MODE 108/* int-level of SCC             */
                                               /*     integration (0/1)        */
#define AR_SERVER_INFO_EA_RPC_SOCKET  109/*    int  - RPC socket for external  */
                                         /*           authentication server    */
#define AR_SERVER_INFO_EA_RPC_TIMEOUT 110/*    int  - Timeout associated with  */
                                         /*        calls to an external        */
                                         /*        authentication server       */
#define AR_SERVER_INFO_USER_INFO_LISTS 111/*   int  - Number of User/NotifyUser*/
                                          /*          hash Lists.              */
#define AR_SERVER_INFO_USER_INST_TIMEOUT 112/* int  - Timeout interval to flush*/
                                          /*          user instances in User   */
                                          /*          Cache hash lists.        */
#define AR_SERVER_INFO_DEBUG_GROUPID  113/* ARInternalId - id of the group     */
                                         /*           whose members are allowed*/
                                         /*           to retrieve server       */
                                         /*           logging information      */
#define AR_SERVER_INFO_APPLICATION_AUDIT 114/* char - application license audit*/
                                            /*        line                     */
#define AR_SERVER_INFO_EA_SYNC_TIMEOUT 115/*   int  - Timeout associated with  */
                                          /*          calls to an external     */
                                          /*          authentication server    */
#define AR_SERVER_INFO_SERVER_TIME    116/*    int  - server's current time    */
#define AR_SERVER_INFO_SVR_SEC_CACHE  117/*    int  - tie security cache to    */
                                         /*           specific server name(0/1)*/
#define AR_SERVER_INFO_LOGFILE_APPEND 118/*    int  - - 0 - create bak file    */
                                         /*             1 - append to existing */
#define AR_SERVER_INFO_MINIMUM_API_VER 119/*    int --specifies the oldes API  */
                                         /*           version with which server*/
                                         /*           will commuicate          */
#define AR_SERVER_INFO_MAX_AUDIT_LOG_FILE_SIZE 120/*    0 -  no limit          */
#define AR_SERVER_INFO_CANCEL_QUERY   121/*     int -- 0 - inactive; 1 - active*/
#define AR_MAX_SERVER_INFO_USED       121/* set to code for "highest" serv info*/

#define AR_DEBUG_SERVER_NONE          0 /* debug flag is OFF */
#define AR_DEBUG_SERVER_SQL           1 /* debug flag for SQL debugging */
#define AR_DEBUG_SERVER_FILTER        2 /* debug flag for filter debugging */
#define AR_DEBUG_SERVER_USER          4 /* debug flag for user debugging */
#define AR_DEBUG_SERVER_ESCALATION    8 /* debug flag for escalation debugging*/
#define AR_DEBUG_SERVER_API          16 /* debug flag for api debugging */
#define AR_DEBUG_THREAD              32 /* debug flag for thread debugging */
#define AR_DEBUG_SERVER_CACHE        64 /* debug flag for shr cache debugging */
#define AR_DEBUG_SERVER_DISTRIB   32768 /* debug flag for distrib server debug*/
#define AR_DEBUG_SERVER_APPROVAL  65536 /* debug flag for approve server debug*/

#define AR_SUBMITTER_MODE_LOCKED      1 /* submitter locked at create */
#define AR_SUBMITTER_MODE_CHANGEABLE  2 /* submitter changeable after create */

#define AR_SAVE_LOGIN_USER_OPTION     0 /* let user define whether to save */
#define AR_SAVE_LOGIN_ADMIN_SAVE      1 /* admin override, force saving */
#define AR_SAVE_LOGIN_ADMIN_NO_SAVE   2 /* admin override, force NO saving */

#define AR_CASE_SENSITIVE_YES         0 /* DB is case sensitive */
#define AR_CASE_SENSITIVE_NO          1 /* DB is case INsensitive */

                                        /* tags for server stats operations */
/* NOTE: All of the integer values that are counts or total numbers start at */
/*       0 and increase during the running of the server.  They are all      */
/*       long values.  If they hit the maximum allowed in a long, they will  */
/*       wrap around to 0 again.                                             */
/* NOTE: All time values are in 1/100ths of a second                         */
#define AR_SERVER_STAT_START_TIME      1/*    long - start time of the server */
#define AR_SERVER_STAT_BAD_PASSWORD    2/*    long - num logins w/ bad passwd */
#define AR_SERVER_STAT_NO_WRITE_TOKEN  3/*    long - num logins where was no  */
                                        /*           free floating write token*/
#define AR_SERVER_STAT_NO_FULL_TOKEN   4/*    long - num logins where was no  */
                                        /*           free floating write token*/
#define AR_SERVER_STAT_CURRENT_USERS   5/*    long - num current users        */
#define AR_SERVER_STAT_WRITE_FIXED     6/*    long - num write fixed users    */
#define AR_SERVER_STAT_WRITE_FLOATING  7/*    long - num write floating users */
#define AR_SERVER_STAT_WRITE_READ      8/*    long - num write read-only users*/
#define AR_SERVER_STAT_FULL_FIXED      9/*    long - num fulltext fixed users */
#define AR_SERVER_STAT_FULL_FLOATING  10/*    long - num fulltext float users */
#define AR_SERVER_STAT_FULL_NONE      11/*    long - num fulltext none users  */
#define AR_SERVER_STAT_API_REQUESTS   12/*    long - num API requests         */
#define AR_SERVER_STAT_API_TIME       13/*    long - time in API calls        */
#define AR_SERVER_STAT_ENTRY_TIME     14/*    long - time in "entry" calls    */
#define AR_SERVER_STAT_RESTRUCT_TIME  15/*    long - time in "restructure"    */
#define AR_SERVER_STAT_OTHER_TIME     16/*    long - time in calls that       */
                                        /*           aren't entry/restructure */
#define AR_SERVER_STAT_CACHE_TIME     17/*    long - time loading/reloading   */
                                        /*           the server process cache */
#define AR_SERVER_STAT_GET_E_COUNT    18/*    long - num calls ARGetEntry     */
#define AR_SERVER_STAT_GET_E_TIME     19/*    long - time in ARGetEntry       */
#define AR_SERVER_STAT_SET_E_COUNT    20/*    long - num calls ARSetEntry     */
#define AR_SERVER_STAT_SET_E_TIME     21/*    long - time in ARSetEntry       */
#define AR_SERVER_STAT_CREATE_E_COUNT 22/*    long - num calls ARCreateEntry  */
#define AR_SERVER_STAT_CREATE_E_TIME  23/*    long - time in ARCreateEntry    */
#define AR_SERVER_STAT_DELETE_E_COUNT 24/*    long - num calls ARDeleteEntry  */
#define AR_SERVER_STAT_DELETE_E_TIME  25/*    long - time in ARDeleteEntry    */
#define AR_SERVER_STAT_MERGE_E_COUNT  26/*    long - num calls ARMergeEntry   */
#define AR_SERVER_STAT_MERGE_E_TIME   27/*    long - time in ARMergeEntry     */
#define AR_SERVER_STAT_GETLIST_E_COUNT 28/*   long - num calls ARGetListEntry */
#define AR_SERVER_STAT_GETLIST_E_TIME 29/*    long - time in ARGetListEntry   */
#define AR_SERVER_STAT_E_STATS_COUNT  30/*    long - num calls AREntryStatisti*/
#define AR_SERVER_STAT_E_STATS_TIME   31/*    long - time in AREntryStatistics*/
#define AR_SERVER_STAT_FILTER_PASSED  32/*    long - num filters executed     */
#define AR_SERVER_STAT_FILTER_FAILED  33/*    long - num filters where qualify*/
                                        /*           check failed             */
#define AR_SERVER_STAT_FILTER_DISABLE 34/*    long - num filters checked that */
                                        /*           were marked disabled     */
#define AR_SERVER_STAT_FILTER_NOTIFY  35/*    long - num filters notify action*/
#define AR_SERVER_STAT_FILTER_MESSAGE 36/*    long - num filters message actio*/
#define AR_SERVER_STAT_FILTER_LOG     37/*    long - num filters log action   */
#define AR_SERVER_STAT_FILTER_FIELDS  38/*    long - num filters fields action*/
#define AR_SERVER_STAT_FILTER_PROCESS 39/*    long - num filters process actio*/
#define AR_SERVER_STAT_FILTER_TIME    40/*    long - time spent during        */
                                        /*           filter processing        */
#define AR_SERVER_STAT_ESCL_PASSED    41/*    long - num escls executed       */
#define AR_SERVER_STAT_ESCL_FAILED    42/*    long - num escls where qualify  */
                                        /*           check failed             */
#define AR_SERVER_STAT_ESCL_DISABLE   43/*    long - num escls checked that   */
                                        /*           were marked disabled     */
#define AR_SERVER_STAT_ESCL_NOTIFY    44/*    long - num escls notify action  */
#define AR_SERVER_STAT_ESCL_LOG       45/*    long - num escls log action     */
#define AR_SERVER_STAT_ESCL_FIELDS    46/*    long - num escls fields action  */
#define AR_SERVER_STAT_ESCL_PROCESS   47/*    long - num escls process action */
#define AR_SERVER_STAT_ESCL_TIME      48/*    long - time spent during        */
                                        /*           escalation processing    */
#define AR_SERVER_STAT_TIMES_BLOCKED  49/*    long - number of times a request*/
                                        /*           was temporarily blocked  */
#define AR_SERVER_STAT_NUMBER_BLOCKED 50/*    long - number of items that were*/
                                        /*           blocked at end of a call */
#define AR_SERVER_STAT_CPU            51/*    long - total CPU time used by   */
                                        /*           the server process       */
#define AR_SERVER_STAT_SQL_DB_COUNT   52/*    long - num DB commands issued   */
#define AR_SERVER_STAT_SQL_DB_TIME    53/*    long - time spend DB operations */
#define AR_SERVER_STAT_FTS_SRCH_COUNT 54/*    long - num FTS search operations*/
#define AR_SERVER_STAT_FTS_SRCH_TIME  55/*    long - time spent in FTS search */
#define AR_SERVER_STAT_SINCE_START    56/*    long - time from start time     */
#define AR_SERVER_STAT_IDLE_TIME      57/*    long - idle time between calls  */
#define AR_SERVER_STAT_NET_RESP_TIME  58/*    long - time spent on network    */
                                        /*           sending resp. to API call*/
#define AR_SERVER_STAT_FILTER_FIELDP  59/*    long - num filters push actions */
#define AR_SERVER_STAT_ESCL_FIELDP    60/*    long - num escls push actions   */
#define AR_SERVER_STAT_FILTER_SQL     61/*    long - num filters sql actions  */
#define AR_SERVER_STAT_ESCL_SQL       62/*    long - num escls sql actions    */
#define AR_SERVER_STAT_NUM_THREADS    63/*    long - num threads in queue     */

#define AR_MAX_SERVER_STAT_USED       63/* set to code for "highest" serv stat*/

typedef struct {               /* list of server info to get */
                  unsigned int  numItems;
                  unsigned int *requestList;
               } ARServerInfoRequestList;

typedef struct {               /* operation type and data */
                  unsigned int   operation;
                  ARValueStruct  value;
               } ARServerInfoStruct;

typedef struct {               /* list of 0 or more server info item entries */
                  unsigned int        numItems;
                  ARServerInfoStruct *serverInfoList;
               } ARServerInfoList;

                                              /* tags for FullText requests */
#define AR_FULLTEXTINFO_COLLECTION_DIR      1 /* Location of collection */
#define AR_FULLTEXTINFO_STOPWORD            2 /* Store stop words */
#define AR_FULLTEXTINFO_REINDEX             3 /* Reindex the collection */
#define AR_FULLTEXTINFO_CASE_SENSITIVE_SRCH 4 /* Case-sensitive search */
#define AR_FULLTEXTINFO_STATE               5 /* FTS on/off */
#define AR_FULLTEXTINFO_FTS_MATCH_OP        6 /* FTS Match Operator */
#define AR_FULLTEXTINFO_HOMEDIR             7 /* FTS Home directory */
#define AR_FULLTEXTINFO_DEBUG               8 /* FTS Debugging */

#define AR_MAX_FULLTEXT_INFO_USED           8 /* Code for "highest" FT info */

#define AR_FULLTEXT_REINDEX        1  /* If reindexing set the valuestruct to */
                                      /* this value.  When doing a get, a 0   */
                                      /* will be returned for this info type. */
                                      /* i.e this info type is useful only for*/
                                      /* a set operation.                     */

#define AR_CASE_SENSITIVE_SEARCH   0  /* FTS case sensitive searching */
#define AR_CASE_INSENSITIVE_SEARCH 1  /* FTS case insensitive searching */

/* If ft ops are turned off, then no indexing, searching or any other ft      */
/* operations are possible, except 1) set full textinfo () which can be used  */
/* to turn ft ops. on again 2) to change the collection directory if desired. */
/* 3) get full textinfo.                                                      */
/* However, this will not prevent fulltext from being initialized if turned   */
/* off.  This info type is to allow admin type operations to occur safely,    */
/* such as moving the collection directory.  If the state is turned on, and   */
/* you try to move the collection directory, then you will be told to turn ft */
/* off and then redo the operation.  This info type is also useful when       */
/* importing schemas that have fields that are full text indexed.  After      */
/* importing the schema definitions, turn ft state to off, arcopy in the data.*/
/* This will allow arcopy to complete without passing any data to be fed to   */
/* the full text engine for indexing.  Once the arcopy is done, turn ft state */
/* to on and do a reindex.  This is the fastest way to get arcopy done.  If ft*/
/* was turned on and arimport had to feed data to vdk for each record, then   */
/* this would be extremely slow.  FTS Match Operator is another operation that*/
/* can only be set when FT State is on.                                       */

#define AR_FULLTEXT_STATE_OFF      0  /* Turn FTS operations off */
#define AR_FULLTEXT_STATE_ON       1  /* Turn FTS operations on */

#define AR_FULLTEXT_FTS_MATCH_FORCE_L_T_WILD 0 /* Force Leading & Trailing */
                                               /*  wildcards               */
#define AR_FULLTEXT_FTS_MATCH_FORCE_T_WILD   1 /* Force Trailing wildcards */
#define AR_FULLTEXT_FTS_MATCH_IGNORE_L_WILD  2 /* Ignore Leading wildcards */
#define AR_FULLTEXT_FTS_MATCH_REMOVE_WILD    3 /* Remove all wildcards */
#define AR_FULLTEXT_FTS_MATCH_UNCHANGED      4 /* Query unchanged */

typedef struct {               /* list of FullText info to get */
                  unsigned int  numItems;
                  unsigned int *requestList;
               } ARFullTextInfoRequestList;

typedef struct {               /* info type and data */
                  unsigned int  infoType;
                  union {
                     ARValueList    valueList;  /* List of stop words */
                     ARValueStruct  value;      /* Collection dir, case srch,
                      ** reindex, ft state, FTS Match op */
                  } u;
               } ARFullTextInfoStruct;

typedef struct {               /* list of FullText info item entries */
                  unsigned int          numItems;
                  ARFullTextInfoStruct *fullTextInfoList;
               } ARFullTextInfoList;


/* Structures used in the Decode operations to convert the internal form */
/* of structured character strings into structures that are more easily  */
/* managed by the caller.                                                */

typedef struct {               /* label of state and user/time of last set */
                  ARNameType   user;
                  ARTimestamp  timeVal;
               } ARStatusHistoryStruct;

typedef struct {               /* decoded status history */
                  unsigned int           numItems;
                  ARStatusHistoryStruct *statHistList;
               } ARStatusHistoryList;

typedef struct {               /* user/time/text of entry */
                  ARNameType   user;
                  ARTimestamp  timeVal;
                  char        *value;
               } ARDiaryStruct;

typedef struct {               /* decoded diary text */
                  unsigned int   numItems;
                  ARDiaryStruct *diaryList;
               } ARDiaryList;

/* Structure used in defining escalation firing time */
/* Bit 0 to 30 of 'monthday' represents day 1 to 31 of a month.       */
/* Bit 0 to  6 of 'weekday'  represents sunday to saturday of a week. */
/* Bit 0 to 23 of 'hourmask' represents hour 0 to 23 of a day.        */

#define AR_DAY(x, y)             (((x) >> (y)) & 0x1)
#define AR_HOUR(x, y)            (((x) >> (y)) & 0x1)
#define AR_SETDAY(x)             (1 << x)
#define AR_SETHOUR(x)            (1 << x)
#define AR_HOUR_A_DAY            24
#define AR_TIMEMARK_ALL          -1
#define AR_TIMEMARK_NOTFOUND     -1
#define AR_TIMEMARK_END_OF_MONTH 31

typedef struct {
                  long          monthday;  /* day of month in bitmask */
                  long          weekday;   /* day of week in bitmask  */
                  long          hourmask;  /* hour bitmask of the day */
                                           /* one hour for all days   */
                  unsigned int  minute;    /* 0-59 minute of the hour */
                                           /* one minute mark only    */
               } ARDayStruct;

#define AR_ESCALATION_TYPE_INTERVAL   1 /* codes for types of escalation time */
#define AR_ESCALATION_TYPE_TIMEMARK   2

typedef struct {
                  unsigned int  escalationTmType;   /* interval or timemark */
                  union {
                           long         interval;   /* time in seconds */
                           ARDayStruct  date;       /* escalation fire date */
                        } u;
               } AREscalationTmStruct;


#define AR_LONGVALUE_TYPE_HELPTEXT    1  /* help text */
#define AR_LONGVALUE_TYPE_CHANGEDIARY 2  /* change diary */

#define AR_MAX_TABLENAME_SIZE 256  /* maximum external table name size */

#define AR_FIELD_NONE         0  /* null field */
#define AR_FIELD_REGULAR      1  /* field of regular schema */
#define AR_FIELD_JOIN         2  /* field of join schema */
#define AR_FIELD_VIEW         3  /* field of view schema */

#define AR_FIELD_CLEAN_DELETE 0  /* default field delete option */
                                 /* delete field only when there is no */
                                 /* dependency and there is no data */
#define AR_FIELD_DATA_DELETE  1  /* delete field even there is data */
                                 /* only applicable for regular schema */
#define AR_FIELD_FORCE_DELETE 2  /* delete field cascade */
                                 /* delete all invalid delete fields and */
                                 /* schemas, override DATA_DELETE */

#define AR_FIELD_MAPPING_PRIMARY   0  /* primary join member schema */
#define AR_FIELD_MAPPING_SECONDARY 1  /* secondary join member schema */

typedef struct ARJoinMappingStruct {
                  unsigned int   schemaIndex;  /* 0 - primary, 1 - secondary */
                  ARInternalId   realId;       /* field id of member schema */
               } ARJoinMappingStruct;

typedef struct ARViewMappingStruct {
                  ARNameType     fieldName;    /* field name of external table*/
               } ARViewMappingStruct;

typedef struct ARFieldMappingStruct {
                  unsigned int fieldType;            /* field type */
                  union  {
                            ARJoinMappingStruct  join;
                            ARViewMappingStruct  view;
                         } u;
               } ARFieldMappingStruct;

typedef struct {               /* list of 0 or more field mappings */
                  unsigned int          numItems;
                  ARFieldMappingStruct *mappingList;
               } ARFieldMappingList;

#define AR_SCHEMA_NONE       0  /* null schema */
#define AR_SCHEMA_REGULAR    1  /* regular schema */
#define AR_SCHEMA_JOIN       2  /* join schema, has two member schemas */
#define AR_SCHEMA_VIEW       3  /* view schema, has one base schema */
#define AR_SCHEMA_DIALOG     4  /* dialog schema, only display-only fields */

#define AR_LIST_SCHEMA_ALL           0  /* get list of all schemas */
#define AR_LIST_SCHEMA_REGULAR       1  /* get list of all regular schemas */
#define AR_LIST_SCHEMA_JOIN          2  /* get list of all join schemas */
#define AR_LIST_SCHEMA_VIEW          3  /* get list of all view schemas */
#define AR_LIST_SCHEMA_UPLINK        4  /* get list of all schemas depending */
                                        /* on given schema */
#define AR_LIST_SCHEMA_DOWNLINK      5  /* get list of all schemas the given */
                                        /* schema bases on */
#define AR_LIST_SCHEMA_DIALOG        6  /* get list of all dialog schemas */
#define AR_LIST_SCHEMA_ALL_WITH_DATA 7  /* get list of all schemas with */
                                        /* database fields              */

#define AR_HIDDEN_INCREMENT   1024  /* code added to above to "include hidden */
                                    /*  schemas" in the list returned         */

#define AR_ATTRIB_NONE          0   /* no attribute and visible attribute */
                                    /* for ARS objects                    */
#define AR_ATTRIB_VISIBLE       AR_ATTRIB_NONE
#define AR_ATTRIB_HIDDEN        1   /* hidden attribute for ARS objects */

                                   /* join schema definition option */
#define AR_JOIN_OPTION_NONE     0  /* no join option */
#define AR_JOIN_OPTION_OUTER    1  /* define the join as outer join */

                                   /* SetEntry option */
#define AR_JOIN_SETOPTION_NONE  0  /* don't enforce join referential */
                                   /* integrity */
#define AR_JOIN_SETOPTION_REF   1  /* enforce join referential integrity */

                                   /* DeleteEntry option */
#define AR_JOIN_DELOPTION_NONE  0  /* individual entries will be deleted */
                                   /* only when the entry can be retrieved */
                                   /* through the join schema */
#define AR_JOIN_DELOPTION_FORCE 1  /* delete individual entries even when */
                                   /* the entry cannot be retrieved from */
                                   /* the join schema. Error will be ignored */
                                   /* for those entry pieces that are no */
                                   /* longer existing. */

#define AR_SCHEMA_CLEAN_DELETE  0  /* default schema delete option */
                                   /* delete schema only when there is no */
                                   /* dependency and there is no data in the */
                                   /* schema.(ignored in the case of join */
                                   /* schema) */
#define AR_SCHEMA_DATA_DELETE   1  /* delete schema even there is data */
                                   /* only applicable for regular schema */
#define AR_SCHEMA_FORCE_DELETE  2  /* delete schema even there is dependency */
                                   /* all the invalid schemas will be deleted */
                                   /* this option overrides DATA_DELETE */

typedef struct ARJoinSchema {           /* join schema specific info */
                  ARNameType         memberA;     /* name of member schema A */
                  ARNameType         memberB;     /* name of member schema B */
                  ARQualifierStruct  joinQual;    /* join qualification */
                  unsigned int       option;      /* join option bit mask */
               } ARJoinSchema;

typedef struct ARViewSchema {           /* straight view to an external table */
                  char        tableName[AR_MAX_TABLENAME_SIZE];
                  ARNameType  keyField;  /* primary field entryId(C1) maps to */
                  char       *viewQual;  /* view qualification on ext table */
               } ARViewSchema;

typedef struct ARCompoundSchema {
                  unsigned int      schemaType;
                  union {  /* two types of join */
                           ARJoinSchema    join;
                           ARViewSchema    view;
                        } u;
               } ARCompoundSchema;
                                    /* tags for types of support files */
#define AR_SUPPORT_FILE_NONE              0
#define AR_SUPPORT_FILE_EXTERNAL_REPORT   1


    /* The next two Statistics structures are present for backward          */
    /* compatibility only.  They should not be used in any new development. */
typedef struct {                    /* OBSOLETE; Backward compatibility only */
                  unsigned int              operation;
                  ARFieldValueOrArithStruct field;
               } ARStatisticsStruct;

typedef struct {                    /* OBSOLETE; Backward compatibility only */
                               /* list of 0 or more statistics requests */
                  unsigned int        numItems;
                  ARStatisticsStruct *statisticsList;
               } ARStatisticsList;

   /* The following definitions are present for backward compatibility */
   /* only.  They should not be used for any new development.          */

#define AR_DISPLAY_TYPE_NONE     0
#define AR_DISPLAY_TYPE_TEXT     1 /* tags for field display types */
#define AR_DISPLAY_TYPE_NUMTEXT  2
#define AR_DISPLAY_TYPE_CHECKBOX 4
#define AR_DISPLAY_TYPE_CHOICE   5
#define AR_DISPLAY_TYPE_BUTTON   6
#define AR_DISPLAY_TYPE_TRIM     7

#define AR_DISPLAY_OPT_VISIBLE   1 /* tags for field display options */
#define AR_DISPLAY_OPT_HIDDEN    2

#ifndef ASCII  /* Added ifndef to avoid multiple defines of the following */
#define AR_DISPLAY_LABEL_LEFT    1 /* tags for where to display the label */
#define AR_DISPLAY_LABEL_TOP     2
#endif /* ASCII */


typedef struct {
                  ARNameType    displayTag;
                  ARNameType    label;
                  unsigned int  labelLocation;
                  unsigned int  type;
                  unsigned int  length;
                  unsigned int  numRows;
                  unsigned int  option;
                  int           x;
                  int           y;
               } ARDisplayStruct;

typedef struct {               /* list of 1 or more display structures */
                  unsigned int     numItems;
                  ARDisplayStruct *displayList;
               } ARDisplayList;


/* Container types */
#define ARCON_ALL                   0  /* all container types */
#define ARCON_GUIDE                 1  /* guide container */
#define ARCON_APP                   2  /* application container */
#define ARCON_PACK                  3  /* packing list container */
#define ARCON_LAST_RESERVED     65535  /* last Remedy reserved container type */

/* Reference types */
#define ARREF_NONE                  0  /* no references */
#define ARREF_ALL                   1  /* all reference types */
#define ARREF_SCHEMA                2  /* reference to a schema */
#define ARREF_FILTER                3  /* reference to a filter */
#define ARREF_ESCALATION            4  /* reference to an escalation */
#define ARREF_ACTLINK               5  /* reference to an active link */
#define ARREF_CONTAINER             6  /* reference to a container */
#define ARREF_CHAR_MENU             7  /* reference to a character menu */
#define ARREF_LAST_SERVER_OBJ   32767  /* last server object reference type */

         /* Remedy defined external references from here down */
#define ARREF_ICON              32768  /* reference to an icon */
#define ARREF_SMALL_ICON        32769  /* reference to a small icon */
#define ARREF_MAXIMIZE_FORMS    32770  /* for applications - int (boolean) value: */
                                       /*  maximize forms or not?           */
#define ARREF_APPLICATION_FORMS 32771  /* for applications - forms used in    */
                                       /*  the application                    */
                                       /* tag that next reference is a form */
                                       /* can be repeated multiple times */
#define ARREF_ABOUT_BOX_IMAGE   32772  /* about box image - bytelist value */
#define ARREF_ABOUT_BOX_FORM    32773  /* tag that about box form is next reference */
#define ARREF_NULL_STRING       32774  /* used for null strings ie. labels */
#define ARREF_APPLICATION_HELP_EXT  32775  /* CHAR - used for Application */
                                           /*  object help file extension */
#define ARREF_APPLICATION_HELP_FILE 32776  /* BYTELIST - used for Application */
                                           /* object help file                */
#define ARREF_APPLICATION_PRIMARY_FORM 32777 /* tag that next reference is    */
                                             /* primary form */
#define ARREF_APPLICATION_FORM_VUI  32778  /* ulong; vui-id of previous form  */
                                           /* reference */
#define ARREF_APPLICATION_DISABLE_BEGIN_TASK  32779 /* int (boolean) - TRUE if*/
                                           /* begin a task should be disabled.*/
                                           /* Default is FALSE                */
#define ARREF_APPLICATION_HELP_INDEX_EXT  32780 /* CHAR - used for Application*/
                                                /*  object help file's index  */
                                                /*  file extension            */
#define ARREF_APPLICATION_HELP_INDEX_FILE 32781 /* BYTELIST - for Application */
                                                /*  object help file's index  */
                                                /*  file                      */
#define ARREF_APPLICATION_HELP_FILE_NAME  32782 /* CHAR - for Application     */
                                                /*  object help file's name,  */
                                                /*  w/o the extension         */
#define ARREF_PACKINGLIST_GUIDE      32783 /* CHAR - for Packing Lists        */
                                           /*  reference to a Guide           */
#define ARREF_PACKINGLIST_APP        32784 /* CHAR - for Packing Lists        */
                                           /*  reference to an Application    */
#define ARREF_PACKINGLIST_PACK       32785 /* CHAR -  for Packing Lists       */
                                           /*  reference to a Packing List    */
#define ARREF_GROUP_DATA             32786 /* CHAR -  for Packing Lists       */
                                           /*  reference to data in the Group */
                                           /*  schema                         */
#define ARREF_DISTMAPPING_DATA       32787 /* CHAR -  for Packing Lists       */
                                           /*  reference to data in the       */
                                           /*  Distributed Mapping schema     */
#define ARREF_APPLICATION_HAS_EXT_HELP 32788 /*INT -  for applications        */
                                           /*  use external help or not (bool)*/

#define ARREF_LAST_RESERVED     65535  /* last Remedy reserved reference type */
         /* customer defined external references from here down */

/* Reference data types */
#define ARREF_DATA_ARSREF  0  /* AR System reference data */
#define ARREF_DATA_EXTREF  1  /* external reference data */

/* Types of container owning objects */
#define ARCONOWNER_NONE    0  /* global container (unowned) */
#define ARCONOWNER_ALL     1  /* all container, owned and unowned ones */
#define ARCONOWNER_SCHEMA  2  /* container owned by a schema */

/* API and server enforced limits on lengths of byte list structures */
/* in a container or reference                                       */
#define ARMAX_CON_LABEL_LEN       255   /* max chars in a label */
#define ARMAX_CON_DESCRIPTION_LEN 2000  /* max chars in a description */

/* Structure describing an object that owns a container. */
typedef struct ARContainerOwnerObj {
                  unsigned int  type;
                  ARNameType    ownerName;
               } ARContainerOwnerObj;

/* A structure to hold references to non-AR System server objects.  Each */
/* external reference has a list of groups that are permitted to use the */
/* reference.                                                            */
typedef struct ARExtReferenceStruct {
                  ARInternalIdList  permittedGroups;
                  ARValueStruct     value;
               } ARExtReferenceStruct;

/* Reference structure.  This structure can point at server objects including */
/* schemas, filters, escalations, active links, menus, and containers. It can */
/* also hold other information like URLs and filenames as external references.*/
typedef struct {
                  unsigned int   dataType;  /* ARREF_DATA_ */
                  union {
                     ARNameType            name;   /* AR System server object */
                     ARExtReferenceStruct  extRef; /* non-AR System object    */
                  } u;
               } ARReferenceUnion;

typedef struct ARReferenceStruct {
                  char             *label;        /* max 255 chars */
                  char             *description;  /* max 2000 chars */
                  unsigned int      type;         /* ARREF_ */
                  ARReferenceUnion  reference;
               } ARReferenceStruct;

/* A list of references */
typedef struct ARReferenceList {
                  unsigned int       numItems;
                  ARReferenceStruct *referenceList;
               } ARReferenceList;

/* A list of reference types */
typedef struct ARReferenceTypeList {
                  unsigned int  numItems;
                  int          *refType;
               } ARReferenceTypeList;

/* A structure to contain the results of an ARGetListContainer call */
typedef struct ARContainerInfo {
                  ARNameType    name;
                  unsigned int  type;
                  ARNameType    ownerName;
                  unsigned int  ownerType;
               } ARContainerInfo;

/* A list of structures, each with information about a container */
typedef struct ARContainerInfoList {
                  unsigned int     numItems;
                  ARContainerInfo *conInfoList;
               } ARContainerInfoList;

/* list of 0 or more container type entries */
typedef struct ARContainerTypeList {
                  unsigned int  numItems;
                  int          *type;
               } ARContainerTypeList;

/* Signal for the server */
#define AR_SIGNAL_CONFIG_CHANGED       1  /* reread the configuraton file */
#define AR_SIGNAL_GROUP_CACHE_CHANGED  2  /* read the group info and cache */
#define AR_SIGNAL_LICENSE_CHANGED      3  /* read the license information */

/* list of signals for the server */
typedef struct ARSignalList {
                  unsigned int  numItems;
                  int          *signal;
               } ARSignalList;

/* Flag indicates whether logging information should be written to */
/* a file, and/or just returned via the status list */ 
#define AR_WRITE_TO_FILE        1
#define AR_WRITE_TO_STATUS_LIST 2  

#define AR_WORKFLOW_CONN_SCHEMA_LIST    1 /* assoc with a list of schemas */

typedef struct ARWorkflowConnectStruct {
                  unsigned int   type;
                  union {
                         ARNameList   *schemaList;
                  } u;
} ARWorkflowConnectStruct;

#ifdef __cplusplus
/* This closes the 'extern "C" {' statement started at the top of this      */
/* file.  This is needed so C++ applications don't compile these structures */
/* as C++, which creates name-mangling and structure padding problems.      */ 
}
#endif

#endif
